/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.usermgr.client.users;

import com.sun.admin.cis.common.ActionString;
import com.sun.admin.cis.common.ContextHelpListener;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.tsol.client.ClearanceBuilderDialog;
import com.sun.admin.tsol.client.LabelBuilderDialog;
import com.sun.admin.tsol.common.BadLabelException;
import com.sun.admin.tsol.common.TrustedSolarisDefaults;
import com.sun.admin.tsol.server.TrustedSolarisServiceInterface;
import com.sun.admin.usermgr.client.UMgrContextHelpListener;
import com.sun.admin.usermgr.client.UMgrPropsPanel;
import com.sun.admin.usermgr.client.VUserMgr;
import com.sun.admin.usermgr.common.UserAttrObj;
import com.sun.admin.usermgr.common.UserObj;
import com.sun.management.viper.Service;
import com.sun.management.viper.ToolInfrastructure;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;

public class TsolLabelProps
extends UMgrPropsPanel {
    private static final String TSOL_INVALID_VALUE = "*****";
    private static final String[] defLabel = new String[]{"showsl", "hidesl"};
    private static final String[] defLabelView = new String[]{"default", "external", "internal"};
    private static final String[] defLock = new String[]{"yes", "no"};
    private JTextArea minLabelText;
    private JTextArea clearText;
    private JComboBox viewChoice;
    private JComboBox labelChoice;
    private JComboBox lockChoice;
    private VUserMgr theApp;
    private ActionString actionString;
    private TrustedSolarisServiceInterface tsService = null;
    private LabelBuilderDialog lbuilder = null;
    private ClearanceBuilderDialog cbuilder = null;
    private String userName = null;
    private ToolInfrastructure inf = null;
    private JButton clearEdit;
    private JButton minLabelEdit;
    private String hexMinLabel = null;
    private String hexClearance = null;
    protected GenInfoPanel infoPanel;
    protected TrustedSolarisDefaults tsolDefaults = null;
    protected UserAttrObj userAttr = null;
    protected ResourceBundle bundle;
    protected JPanel otherPanel;
    private boolean hasError = false;

    public TsolLabelProps(VUserMgr vUserMgr, UserObj userObj, GenInfoPanel genInfoPanel) {
        this.infoPanel = genInfoPanel;
        this.theApp = vUserMgr;
        this.bundle = vUserMgr.getResourceBundle();
        this.inf = vUserMgr.getToolInfrastructure();
        this.userName = vUserMgr.getAuthenticatedUser();
        try {
            this.tsService = (TrustedSolarisServiceInterface)this.inf.getServiceByName("com.sun.admin.tsol.server.TrustedSolarisService");
            this.tsolDefaults = this.tsService.getDefaultTsolInfo(this.userName);
        }
        catch (Exception exception) {
            vUserMgr.reportErrorException(exception);
        }
        this.userAttr = userObj.getSolAuthAttrs();
        this.createGui();
        Vector vector = new Vector(10);
        vUserMgr.addHelpListener(this.viewChoice, new UMgrContextHelpListener(vUserMgr, vector, this.infoPanel, "uprop_tsol_label_view"));
        vUserMgr.addHelpListener(this.labelChoice, new UMgrContextHelpListener(vUserMgr, vector, this.infoPanel, "uprop_tsol_label_label"));
        vUserMgr.addHelpListener(this.lockChoice, new UMgrContextHelpListener(vUserMgr, vector, this.infoPanel, "uprop_tsol_label_lock"));
        this.focusListener = new UMgrContextHelpListener(vUserMgr, vector, this.infoPanel, "uprop_tsol_label");
        Thread thread = new Thread(){

            public void run() {
                try {
                    ContextHelpListener.loadHelp((ContextHelpListener)((UMgrContextHelpListener)((Object)TsolLabelProps.this.getFocusListener())));
                }
                catch (Exception exception) {}
            }
        };
        thread.start();
    }

    static /* synthetic */ String access$12(TsolLabelProps tsolLabelProps) {
        return tsolLabelProps.hexClearance;
    }

    static /* synthetic */ String access$6(TsolLabelProps tsolLabelProps) {
        return tsolLabelProps.hexMinLabel;
    }

    private void createGui() {
        JPanel jPanel = this.createLabelPanel();
        this.otherPanel = this.createOtherPanel();
        this.setLayout(new BorderLayout(0, 5));
        this.add((Component)jPanel, "Center");
        this.add((Component)this.otherPanel, "South");
    }

    private JPanel createLabelPanel() {
        Object object;
        Object object2;
        JPanel jPanel = new JPanel();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"tsol_label_props_labelTitle"));
        jPanel.setBorder(titledBorder);
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"tsol_label_props_minLabelText"));
        this.minLabelText = new JTextArea();
        this.minLabelText.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.minLabelText);
        ActionString actionString = new ActionString(this.bundle, "tsol_label_props_editText");
        this.minLabelEdit = new JButton();
        this.minLabelEdit.setText(actionString.getString());
        this.minLabelEdit.setMnemonic(actionString.getMnemonic());
        this.minLabelEdit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TsolLabelProps.this.minLabelEdit.setEnabled(false);
                String string = TsolLabelProps.this.minLabelText.getText();
                if (string.equals(TsolLabelProps.TSOL_INVALID_VALUE) || string.equals("")) {
                    string = TsolLabelProps.this.tsolDefaults.getMinLabel();
                }
                if (TsolLabelProps.this.lbuilder == null) {
                    try {
                        TsolLabelProps.this.lbuilder = new LabelBuilderDialog(TsolLabelProps.this.theApp.getFrame(), TsolLabelProps.this.inf);
                    }
                    catch (Exception exception) {
                        TsolLabelProps.this.theApp.reportErrorException(exception);
                    }
                }
                if (TsolLabelProps.this.lbuilder != null) {
                    try {
                        TsolLabelProps.this.lbuilder.setLabel(string);
                    }
                    catch (BadLabelException badLabelException) {
                        TsolLabelProps.this.theApp.reportErrorException((Exception)((Object)badLabelException));
                    }
                    catch (Exception exception) {
                        TsolLabelProps.this.theApp.reportErrorException(exception);
                    }
                    TsolLabelProps.this.lbuilder.setVisible(true);
                    if (TsolLabelProps.this.lbuilder.isChangeCommitted()) {
                        String string2 = TsolLabelProps.this.lbuilder.getLabel();
                        TsolLabelProps.this.hexMinLabel = TsolLabelProps.this.lbuilder.getHexLabel();
                        TsolLabelProps.this.minLabelText.setText(string2);
                    }
                }
                TsolLabelProps.this.minLabelEdit.setEnabled(true);
            }
        });
        JLabel jLabel2 = new JLabel(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"tsol_label_props_clearanceText"));
        this.clearText = new JTextArea();
        this.clearText.setEditable(false);
        JScrollPane jScrollPane2 = new JScrollPane(this.clearText);
        this.clearEdit = new JButton();
        this.clearEdit.setText(actionString.getString());
        this.clearEdit.setMnemonic(actionString.getMnemonic());
        this.clearEdit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TsolLabelProps.this.clearEdit.setEnabled(false);
                String string = TsolLabelProps.this.clearText.getText();
                if (string.equals(TsolLabelProps.TSOL_INVALID_VALUE) || string.equals("")) {
                    string = TsolLabelProps.this.tsolDefaults.getClearance();
                }
                if (TsolLabelProps.this.cbuilder == null) {
                    try {
                        TsolLabelProps.this.cbuilder = new ClearanceBuilderDialog(TsolLabelProps.this.theApp.getFrame(), TsolLabelProps.this.inf);
                    }
                    catch (Exception exception) {
                        TsolLabelProps.this.theApp.reportErrorException(exception);
                    }
                }
                if (TsolLabelProps.this.cbuilder != null) {
                    try {
                        TsolLabelProps.this.cbuilder.setClearance(string);
                    }
                    catch (BadLabelException badLabelException) {
                        TsolLabelProps.this.theApp.reportErrorException((Exception)((Object)badLabelException));
                    }
                    catch (Exception exception) {
                        TsolLabelProps.this.theApp.reportErrorException(exception);
                    }
                    TsolLabelProps.this.cbuilder.setVisible(true);
                    if (TsolLabelProps.this.cbuilder.isChangeCommitted()) {
                        String string2 = TsolLabelProps.this.cbuilder.getClearance();
                        TsolLabelProps.this.hexClearance = TsolLabelProps.this.cbuilder.getHexClearance();
                        TsolLabelProps.this.clearText.setText(string2);
                    }
                }
                TsolLabelProps.this.clearEdit.setEnabled(true);
            }
        });
        JLabel jLabel3 = new JLabel(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"tsol_label_props_viewText"));
        this.viewChoice = new JComboBox();
        this.viewChoice.setEditable(false);
        this.viewChoice.addItem(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"tsol_label_props_viewOption1"));
        this.viewChoice.addItem(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"tsol_label_props_viewOption2"));
        this.viewChoice.addItem(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"tsol_label_props_viewOption3"));
        JLabel jLabel4 = new JLabel(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"tsol_label_props_labelText"));
        this.labelChoice = new JComboBox();
        this.labelChoice.setEditable(false);
        this.labelChoice.addItem(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"tsol_label_props_labelOption1"));
        this.labelChoice.addItem(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"tsol_label_props_labelOption2"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel5 = new JLabel("");
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 0.3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)jLabel5, gridBagConstraints);
        gridBagConstraints.anchor = 12;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jPanel.add((Component)this.minLabelEdit, gridBagConstraints);
        gridBagConstraints.anchor = 12;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.weighty = 0.1;
        jPanel.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jPanel.add((Component)jScrollPane2, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jPanel.add((Component)this.clearEdit, gridBagConstraints);
        gridBagConstraints.anchor = 12;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jPanel.add((Component)this.viewChoice, gridBagConstraints);
        gridBagConstraints.anchor = 12;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jLabel4, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jPanel.add((Component)this.labelChoice, gridBagConstraints);
        JLabel jLabel6 = new JLabel("");
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 0.3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)jLabel6, gridBagConstraints);
        String string = null;
        if (this.userAttr == null) {
            string = this.tsolDefaults.getMinLabel();
        } else {
            object2 = this.userAttr.getAttributeArray("min_label");
            if (object2 != null && ((String[])object2).length == 1) {
                try {
                    string = this.tsService.hexLabelToString(object2[0], this.userName);
                }
                catch (BadLabelException badLabelException) {
                    this.theApp.reportErrorException(new Exception(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"tsol_invalid_label")));
                    string = TSOL_INVALID_VALUE;
                }
                catch (Exception exception) {
                    this.theApp.reportErrorException(exception);
                    string = TSOL_INVALID_VALUE;
                }
            } else {
                string = this.tsolDefaults.getMinLabel();
            }
        }
        this.minLabelText.setText(string);
        object2 = null;
        if (this.userAttr == null) {
            object2 = this.tsolDefaults.getClearance();
        } else {
            object = this.userAttr.getAttributeArray("clearance");
            if (object != null && ((String[])object).length == 1) {
                try {
                    object2 = this.tsService.hexClearanceToString(object[0], this.userName);
                }
                catch (BadLabelException badLabelException) {
                    this.theApp.reportErrorException(new Exception(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"tsol_invalid_clear")));
                    object2 = TSOL_INVALID_VALUE;
                }
                catch (Exception exception) {
                    this.theApp.reportErrorException(exception);
                    object2 = TSOL_INVALID_VALUE;
                }
            } else {
                object2 = this.tsolDefaults.getClearance();
            }
        }
        this.clearText.setText((String)object2);
        object = null;
        String string2 = null;
        if (this.userAttr == null) {
            string2 = "default";
            object = this.tsolDefaults.getLabelOption();
        } else {
            String[] stringArray = this.userAttr.getAttributeArray("labelview");
            if (stringArray == null) {
                string2 = "default";
                object = this.tsolDefaults.getLabelOption();
            } else if (stringArray.length == 1) {
                string2 = "default";
                object = stringArray[0];
            } else if (stringArray.length >= 2) {
                string2 = stringArray[0];
                object = stringArray[1];
            }
        }
        if (string2 == null) {
            this.viewChoice.setSelectedIndex(0);
        } else if (string2.equals(defLabelView[1])) {
            this.viewChoice.setSelectedIndex(1);
        } else if (string2.equals(defLabelView[2])) {
            this.viewChoice.setSelectedIndex(2);
        } else {
            this.viewChoice.setSelectedIndex(0);
        }
        if (object == null) {
            this.labelChoice.setSelectedIndex(0);
        } else if (object.equals(defLabel[1])) {
            this.labelChoice.setSelectedIndex(1);
        } else {
            this.labelChoice.setSelectedIndex(0);
        }
        return jPanel;
    }

    private JPanel createOtherPanel() {
        String[] stringArray;
        JPanel jPanel = new JPanel();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"tsol_label_props_otherTitle"));
        jPanel.setBorder(titledBorder);
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0));
        JLabel jLabel = new JLabel(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"tsol_label_props_lockText"), 2);
        this.lockChoice = new JComboBox();
        this.lockChoice.setEditable(false);
        this.lockChoice.addItem(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"tsol_label_props_lockOption1"));
        this.lockChoice.addItem(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"tsol_label_props_lockOption2"));
        jPanel2.add(jLabel);
        jPanel2.add(this.lockChoice);
        String string = null;
        string = this.userAttr == null ? this.tsolDefaults.getLockOption() : ((stringArray = this.userAttr.getAttributeArray("lock_after_retries")) != null && stringArray.length == 1 ? (stringArray[0].equals("no") || stringArray[0].equals("yes") ? stringArray[0] : this.tsolDefaults.getLockOption()) : this.tsolDefaults.getLockOption());
        if (string.equals(defLock[1])) {
            this.lockChoice.setSelectedIndex(1);
        } else {
            this.lockChoice.setSelectedIndex(0);
        }
        jPanel.add((Component)jPanel2, "Center");
        return jPanel;
    }

    protected void finalize() throws Throwable {
        if (this.tsService != null) {
            this.inf.releaseService((Service)this.tsService);
        }
    }

    private Vector getLabelView() {
        Vector<String> vector = new Vector<String>();
        int n = this.viewChoice.getSelectedIndex();
        if (n != 0) {
            vector.addElement(defLabelView[n]);
        }
        int n2 = this.labelChoice.getSelectedIndex();
        vector.addElement(defLabel[n2]);
        return vector;
    }

    public boolean hasInvalidData() {
        return this.hasError;
    }

    public UserObj updateTsolLabelProps(UserObj userObj) {
        Object object;
        this.hasError = false;
        UserAttrObj userAttrObj = userObj.getSolAuthAttrs();
        if (userAttrObj == null) {
            userAttrObj = new UserAttrObj();
        }
        if (this.hexMinLabel != null || this.hexClearance != null) {
            String[] stringArray;
            object = this.hexMinLabel == null ? ((stringArray = userAttrObj.getAttributeArray("min_label")) != null && stringArray.length == 1 ? stringArray[0] : this.tsolDefaults.getMinLabel()) : this.hexMinLabel;
            String string = this.hexClearance == null ? ((stringArray = this.userAttr.getAttributeArray("clearance")) != null && stringArray.length == 1 ? stringArray[0] : this.tsolDefaults.getClearance()) : this.hexClearance;
            boolean bl = true;
            try {
                bl = this.tsService.checkClearanceDominance((String)object, string, this.userName);
            }
            catch (Exception exception) {
                this.theApp.reportErrorException(exception);
                this.hasError = true;
                return userObj;
            }
            if (!bl) {
                ErrorDialog errorDialog = new ErrorDialog(this.theApp.getFrame(), ResourceStrings.getString((ResourceBundle)this.bundle, (String)"tsol_label_dominance_error"));
                this.hasError = true;
                return userObj;
            }
        }
        if (this.hexMinLabel != null) {
            userAttrObj.setAttribute("min_label", this.hexMinLabel);
        }
        if (this.hexClearance != null) {
            userAttrObj.setAttribute("clearance", this.hexClearance);
        }
        object = this.getLabelView();
        userAttrObj.setAttribute("labelview", (Vector)object);
        int n = this.lockChoice.getSelectedIndex();
        userAttrObj.setAttribute("lock_after_retries", defLock[n]);
        userObj.setSolAuthAttrs(userAttrObj);
        return userObj;
    }
}

