/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.browser;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Hashtable;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ConsoleServlet
extends HttpServlet {
    private Hashtable cache;
    private String docRoot = null;
    private String codebase = null;

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getPathInfo();
        if (string != null && string.indexOf("..") >= 0) {
            httpServletResponse.sendError(403, "Cannot serve request.");
            return;
        }
        try {
            if (string == null || string.equals("")) {
                String string2 = "http://" + httpServletRequest.getServerName() + ":" + httpServletRequest.getServerPort() + httpServletRequest.getServletPath() + "/";
                httpServletResponse.sendRedirect(string2);
            } else if (string.equals("/") || string.equals("//")) {
                this.sendFile(httpServletResponse, "text/html", "/console.html");
            } else if (string.endsWith(".html")) {
                this.sendFile(httpServletResponse, "text/html", string);
            } else if (string.endsWith(".gif")) {
                this.sendFile(httpServletResponse, "image/gif", string);
            } else if (string.endsWith(".js")) {
                this.sendFile(httpServletResponse, "application/x-javascript", string);
            } else {
                httpServletResponse.sendError(403, "Cannot serve request.");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("File not found: " + string);
            httpServletResponse.sendError(404, "File " + string + " not found (webconsole).");
        }
    }

    public String getServletInfo() {
        return "Viper Web Console Servlet, v1.0";
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.cache = new Hashtable();
        this.docRoot = servletConfig.getServletContext().getRealPath("/");
        try {
            this.docRoot = new File(this.docRoot).getCanonicalPath();
        }
        catch (IOException iOException) {}
        this.codebase = System.getProperty("java.rmi.server.codebase");
    }

    public void log(String string) {
    }

    public void log(String string, Throwable throwable) {
    }

    private byte[] parseBuffer(byte[] byArray) {
        String string = new String(byArray);
        String string2 = new String();
        int n = 0;
        int n2 = 0;
        while ((n = string.indexOf("<#", n)) != -1) {
            int n3 = string.indexOf("#>", n);
            if (n3 == -1) continue;
            string2 = String.valueOf(string2) + string.substring(n2, n);
            String string3 = string.substring(n + 2, n3);
            if (string3.equals("CODEBASEURL")) {
                string2 = String.valueOf(string2) + this.codebase;
                n += 4 + string3.length();
            }
            n2 = n;
        }
        string2 = String.valueOf(string2) + string.substring(n2, string.length());
        return string2.getBytes();
    }

    private byte[] readFile(String string) throws FileNotFoundException {
        byte[] byArray = null;
        FileInputStream fileInputStream = new FileInputStream(string);
        try {
            byArray = new byte[fileInputStream.available()];
            fileInputStream.read(byArray);
            fileInputStream.close();
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
        return byArray;
    }

    private void sendFile(HttpServletResponse httpServletResponse, String string, String string2) throws FileNotFoundException {
        byte[] byArray;
        if (!this.cache.containsKey(string2)) {
            byArray = this.readFile(String.valueOf(this.docRoot) + string2);
            if (string.equals("text/html")) {
                byArray = this.parseBuffer(byArray);
            }
            this.cache.put(string2, byArray);
        } else {
            byArray = (byte[])this.cache.get(string2);
        }
        try {
            if (byArray != null) {
                File file = new File(String.valueOf(this.docRoot) + string2);
                long l = file.lastModified();
                httpServletResponse.setDateHeader("Last-Modified", l);
                httpServletResponse.setContentType(string);
                httpServletResponse.setContentLength(byArray.length);
                ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
                servletOutputStream.write(byArray);
                servletOutputStream.close();
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }
}

