/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.services.authentication.server;

import com.sun.management.viper.services.AuthenticationException;
import com.sun.management.viper.services.AuthenticationFlavor;
import com.sun.management.viper.services.Log;
import com.sun.management.viperimpl.services.authentication.AuthenticationUtil;
import com.sun.management.viperimpl.services.authentication.AuthenticatorSecurityToken;
import com.sun.management.viperimpl.services.authentication.ConfirmSecurityToken;
import com.sun.management.viperimpl.services.authentication.MessageSecurityToken;
import com.sun.management.viperimpl.services.authentication.RequestSecurityToken;
import com.sun.management.viperimpl.services.authentication.ResponseSecurityToken;
import com.sun.management.viperimpl.services.authentication.SecurityContext;
import com.sun.management.viperimpl.services.authentication.server.AuthenticationLibrary;

public abstract class ServerSecurityContext
extends SecurityContext {
    private boolean msgVerify = false;
    private long clientVers = 0L;
    private String clientHost = null;
    private String clientVMID = null;
    private String userPswd = null;
    private Log logsvc = null;
    private int maxRetries;
    private int uid = -1;
    private int gid = -1;
    private String home = null;
    private String shell = null;
    private String sensitivity = null;
    private long htbtTime;
    protected static final String AUTH_SERVICE_RESOURCES = "com.sun.management.viperimpl.services.authentication.server.AuthenticationServiceResources";

    public ServerSecurityContext(AuthenticationFlavor authenticationFlavor) throws AuthenticationException {
        super(authenticationFlavor);
        try {
            this.maxRetries = Integer.parseInt("5");
        }
        catch (NumberFormatException numberFormatException) {
            this.maxRetries = 5;
        }
        this.setHeartbeatTime();
        this.setAuthState(0);
    }

    protected void auditAuthSuccess(String string, String string2, long l) {
        try {
            AuthenticationLibrary.auditLogin(string, string2, 0, l);
        }
        catch (Exception exception) {}
    }

    protected void auditBadPasswd(String string, String string2) {
        try {
            AuthenticationLibrary.auditLogin(string, string2, -2, 0L);
        }
        catch (Exception exception) {}
    }

    protected void auditBadUser(String string, String string2) {
        try {
            AuthenticationLibrary.auditLogin(string, string2, -1, 0L);
        }
        catch (Exception exception) {}
    }

    protected void copyAttrs(ServerSecurityContext serverSecurityContext) throws AuthenticationException {
        super.copyAttrs(serverSecurityContext);
        serverSecurityContext.setVerify(this.msgVerify);
        serverSecurityContext.setClientVersion(this.clientVers);
        if (this.clientHost != null) {
            serverSecurityContext.setClientHost(new String(this.clientHost));
        }
        if (this.clientVMID != null) {
            serverSecurityContext.setClientVMID(new String(this.clientVMID));
        }
        if (this.userPswd != null) {
            serverSecurityContext.setUserPassword(this.getUserPassword());
        }
        serverSecurityContext.setLogService(this.logsvc);
        serverSecurityContext.setMaxRetries(this.maxRetries);
    }

    public abstract String decryptPassword(byte[] var1) throws AuthenticationException;

    public void disableVerify() {
        this.msgVerify = false;
    }

    public String getClientHost() {
        return this.clientHost;
    }

    public String getClientVMID() {
        return this.clientVMID;
    }

    public long getClientVersion() {
        return this.clientVers;
    }

    public int getGid() {
        return this.gid;
    }

    public long getHeartbeatTime() {
        return this.htbtTime;
    }

    public String getHome() {
        return this.home;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public String getSensitivity() {
        return this.sensitivity;
    }

    public String getShell() {
        return this.shell;
    }

    public int getUid() {
        return this.uid;
    }

    public String getUserPassword() {
        return AuthenticationUtil.unhashPassword(this.userPswd);
    }

    public boolean isVerify() {
        return this.msgVerify;
    }

    public abstract ServerSecurityContext newCopy() throws AuthenticationException;

    public void setClientHost(String string) {
        this.clientHost = string;
    }

    public void setClientVMID(String string) {
        this.clientVMID = string;
    }

    public void setClientVersion(long l) {
        this.clientVers = l;
    }

    public void setGid(int n) {
        this.gid = n;
    }

    public void setHeartbeatTime() {
        this.htbtTime = System.currentTimeMillis();
    }

    public void setHome(String string) {
        this.home = string;
    }

    public void setLogService(Log log) {
        this.logsvc = log;
    }

    public void setMaxRetries(int n) {
        this.maxRetries = n;
    }

    public void setSensitivity(String string) {
        this.sensitivity = string;
    }

    public void setShell(String string) {
        this.shell = string;
    }

    public void setUid(int n) {
        this.uid = n;
    }

    public void setUserPassword(String string) {
        this.userPswd = AuthenticationUtil.hashPassword(string);
    }

    public void setVerify(boolean bl) {
        this.msgVerify = bl;
    }

    public abstract boolean verifyAuthFlavor(AuthenticationFlavor var1) throws AuthenticationException;

    public abstract ConfirmSecurityToken verifyAuthenticatorToken(AuthenticatorSecurityToken var1) throws AuthenticationException;

    public abstract void verifyMessageToken(MessageSecurityToken var1, Object[] var2) throws AuthenticationException;

    public abstract ResponseSecurityToken verifyRequestToken(RequestSecurityToken var1) throws AuthenticationException;

    protected void writeLog(int n, String string, String string2) {
        this.writeLog(n, string, string2, (String[])null);
    }

    protected void writeLog(int n, String string, String string2, String string3) {
        this.writeLog(n, string, string2, new String[]{string3});
    }

    protected void writeLog(int n, String string, String string2, String string3, String string4) {
        this.writeLog(n, string, string2, new String[]{string3, string4});
    }

    protected void writeLog(int n, String string, String string2, String string3, String string4, String string5) {
        this.writeLog(n, string, string2, new String[]{string3, string4, string5});
    }

    protected void writeLog(int n, String string, String string2, String[] stringArray) {
        block2: {
            if (this.logsvc == null) break block2;
            try {
                this.logsvc.writeLog("LMS_AuthSvcName", "security", n, string, string2, stringArray, AUTH_SERVICE_RESOURCES, null);
            }
            catch (Exception exception) {}
        }
    }
}

