/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.tsol.server;

import com.sun.admin.cis.common.AdminCommonTools;
import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.tsol.common.AuditClassObj;
import com.sun.admin.tsol.common.AuditUserObj;
import com.sun.admin.tsol.common.BadLabelException;
import com.sun.admin.tsol.common.BadPrivilegeException;
import com.sun.admin.tsol.common.CDEAction;
import com.sun.admin.tsol.common.CDEActionGroup;
import com.sun.admin.tsol.common.LabelObj;
import com.sun.admin.tsol.common.LabelTitle;
import com.sun.admin.tsol.common.Privilege;
import com.sun.admin.tsol.common.PrivilegeGroup;
import com.sun.admin.tsol.common.RandomWord;
import com.sun.admin.tsol.common.TrustedSolarisDefaults;
import com.sun.admin.tsol.common.UserSecurityInfo;
import com.sun.admin.tsol.server.TrustedSolarisServiceInterface;
import com.sun.management.viper.AdminMgmtScope;
import com.sun.management.viper.VService;
import com.sun.management.viper.util.ResourceManager;
import com.sun.wbem.utility.directorytable.DirectoryRow;
import com.sun.wbem.utility.directorytable.DirectoryTable;
import com.sun.wbem.utility.directorytable.DirectoryTableDoesNotExistException;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import com.sun.wbem.utility.directorytable.DirectoryTableFactory;
import com.sun.wbem.utility.directorytable.SearchTemplate;
import com.sun.wbem.utility.directorytable.TableDefinitions;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public class TrustedSolarisService
extends VService
implements TrustedSolarisServiceInterface {
    private static String PRIV_GROUP_RESOURCE = "com.sun.admin.tsol.server.resource.PrivGroups";
    private static final String ACTIONPATH = "/usr/dt/appconfig/smc/";
    private static final String ACTIONFILE = "actions";
    private static final String ICONPATH = "/usr/dt/appconfig/icons/";
    private static final String APPMGRPATH = "/usr/dt/appconfig/appmanager/";
    private static final String DEFAULT_FILE = "/etc/security/policy.conf";
    private static final String table = new String("audit_user");
    private static final String nameCol = "name";
    private static final String alwaysCol = "alwaysauditflags";
    private static final String neverCol = "neverauditflags";
    private static final String classTable = new String("audit_class");
    private static final String maskCol = "mask";
    private static final String classNameCol = "name";
    private static final String descCol = "desc";
    private String scope;
    private String mScope;

    static {
        System.loadLibrary("TsolNative");
    }

    public TrustedSolarisService() throws RemoteException, AdminException {
        String string = "";
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            string = inetAddress.getHostName();
        }
        catch (Exception exception) {
            string = "";
        }
        this.scope = new String("File:/" + string + "/" + string);
    }

    public boolean checkClearanceDominance(String string, String string2, String string3) throws RemoteException, BadLabelException, RuntimeException {
        return this.nativeCheckClearanceDominance(string, false, string2, string3);
    }

    public boolean checkClearanceDominance(String string, boolean bl, String string2, String string3) throws RemoteException, BadLabelException, RuntimeException {
        return this.nativeCheckClearanceDominance(string, bl, string2, string3);
    }

    public boolean checkLabelDominance(String string, String string2, String string3) throws RemoteException, BadLabelException, RuntimeException {
        return this.nativeCheckLabelDominance(string, string2, string3);
    }

    public LabelObj convertClearance(LabelObj labelObj, String string, String string2) throws RemoteException, BadLabelException, RuntimeException {
        return this.nativeCvtClearance(labelObj, string, string2);
    }

    public LabelObj convertFullClearance(String string, String string2, String string3, UserSecurityInfo userSecurityInfo) throws RemoteException, BadLabelException, RuntimeException {
        return this.nativeCvtFullClearance(string, string2, string3, userSecurityInfo);
    }

    public LabelObj convertFullLabel(String string, String string2, String string3, boolean bl, UserSecurityInfo userSecurityInfo) throws RemoteException, BadLabelException, RuntimeException {
        return this.nativeCvtFullLabel(string, string2, string3, bl, userSecurityInfo);
    }

    public LabelObj convertLabel(LabelObj labelObj, String string, boolean bl, UserSecurityInfo userSecurityInfo) throws RemoteException, BadLabelException, RuntimeException {
        return this.nativeCvtLabel(labelObj, string, bl, userSecurityInfo);
    }

    public void createAuditUserTable() throws DirectoryTableException {
        DirectoryTable directoryTable = null;
        boolean bl = true;
        try {
            directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.mScope);
            directoryTable.open(table);
        }
        catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
            bl = false;
        }
        catch (DirectoryTableException directoryTableException) {
            AdminCommonTools.CMN_Trace1((String)("Unexpected error creating audit_user table: " + directoryTableException.getMessage()));
            directoryTable.close();
            throw directoryTableException;
        }
        TableDefinitions tableDefinitions = null;
        try {
            try {
                if (!bl) {
                    tableDefinitions = directoryTable.getTableDefinitionsInstance();
                    tableDefinitions.loadTableDefinitions(table);
                    directoryTable.create(table);
                }
            }
            catch (DirectoryTableException directoryTableException) {
                AdminCommonTools.CMN_Trace1((String)("Unexpected error creating audit_user table: " + directoryTableException.getMessage()));
                directoryTable.close();
                throw directoryTableException;
            }
            Object var5_7 = null;
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            directoryTable.close();
            throw throwable;
        }
        directoryTable.close();
    }

    public RandomWord[] generateRandomWord(int n) throws RemoteException, RuntimeException {
        return this.nativeGenRandomWord(n);
    }

    public CDEActionGroup[] getAllCDEActionGroups(Locale locale) throws RemoteException {
        String string = this.getLanguageCode(locale);
        String string2 = APPMGRPATH + string;
        Vector vector = new Vector();
        File file = new File(string2);
        String[] stringArray = file.list();
        int n = 0;
        while (stringArray != null && n < stringArray.length) {
            String string3 = String.valueOf(string2) + File.separator + stringArray[n];
            this.getCDEActionGroup(vector, string3, null);
            ++n;
        }
        Object[] objectArray = new CDEActionGroup[vector.size()];
        vector.copyInto(objectArray);
        Arrays.sort(objectArray, objectArray[0]);
        return objectArray;
    }

    public CDEAction[] getAllCDEActions(Locale locale) throws RemoteException, FileNotFoundException, RuntimeException {
        String string = this.getLanguageCode(locale);
        String string2 = ACTIONPATH + string + "/" + ACTIONFILE;
        Vector<CDEAction> vector = new Vector<CDEAction>();
        BufferedReader bufferedReader = null;
        FileReader fileReader = null;
        String string3 = null;
        CDEAction cDEAction = null;
        try {
            String string4;
            fileReader = new FileReader(new File(string2));
            bufferedReader = new BufferedReader(fileReader);
            while ((string4 = bufferedReader.readLine()) != null) {
                int n;
                int n2;
                if (string4.startsWith("=======")) {
                    if (cDEAction != null) {
                        vector.add(cDEAction);
                    }
                    n2 = string4.indexOf(32) + 1;
                    n = string4.indexOf(32, n2);
                    string3 = string4.substring(n2, n);
                    cDEAction = new CDEAction(string3);
                    continue;
                }
                if (cDEAction == null) continue;
                if (string4.startsWith("loaded")) {
                    cDEAction.setFile(string4.substring("loaded from ".length()));
                    continue;
                }
                n2 = 1;
                n = string4.indexOf(32);
                String string5 = string4.substring(n2, n);
                n2 = string4.indexOf(58) + 2;
                String string6 = string4.substring(n2);
                cDEAction.setKeyValue(string5, string6);
            }
            if (cDEAction != null) {
                vector.add(cDEAction);
            }
            fileReader.close();
            Object[] objectArray = new CDEAction[vector.size()];
            vector.copyInto(objectArray);
            Arrays.sort(objectArray, objectArray[0]);
            return objectArray;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw fileNotFoundException;
        }
        catch (Exception exception) {
            throw new RuntimeException();
        }
    }

    public Vector getAllPrivilegeGroups() throws RemoteException, RuntimeException {
        Vector<PrivilegeGroup> vector = new Vector<PrivilegeGroup>();
        ResourceBundle resourceBundle = ResourceManager.getBundle((String)PRIV_GROUP_RESOURCE, this.getClass());
        if (resourceBundle == null) {
            return vector;
        }
        String string = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"privgroup.count");
        if (string == null) {
            return vector;
        }
        Integer n = new Integer(string);
        int n2 = n;
        int n3 = 0;
        while (n3 < n2) {
            String string2 = "privgroup" + n3 + ".prefix";
            String string3 = "privgroup" + n3 + ".title";
            String string4 = "privgroup" + n3 + ".help";
            String string5 = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)string2);
            String string6 = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)string3);
            String string7 = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)string4);
            if (string6 != null && string5 != null) {
                PrivilegeGroup privilegeGroup = new PrivilegeGroup(string6, string5, string7);
                vector.add(privilegeGroup);
            }
            ++n3;
        }
        return vector;
    }

    public Vector getAllPrivileges() throws RemoteException, RuntimeException {
        Privilege[] privilegeArray = this.nativeGetAllPrivileges();
        if (privilegeArray == null) {
            throw new RuntimeException("Can't get privileges");
        }
        Vector<Privilege> vector = new Vector<Privilege>();
        int n = 0;
        while (n < privilegeArray.length) {
            Privilege privilege = privilegeArray[n];
            if (privilege != null) {
                Privilege privilege2 = (Privilege)privilege.clone();
                vector.addElement(privilege2);
            }
            ++n;
        }
        return vector;
    }

    private void getCDEActionGroup(Vector vector, String string, CDEActionGroup cDEActionGroup) {
        File file = new File(string);
        if (file.isDirectory()) {
            Serializable serializable;
            String string2 = file.getName();
            String[] stringArray = file.list();
            HashSet<String> hashSet = new HashSet<String>();
            Vector<String> vector2 = new Vector<String>();
            int n = 0;
            while (n < stringArray.length) {
                serializable = new File(String.valueOf(string) + File.separator + stringArray[n]);
                if (((File)serializable).isDirectory()) {
                    vector2.add(stringArray[n]);
                } else {
                    hashSet.add(stringArray[n]);
                }
                ++n;
            }
            serializable = new CDEActionGroup(string2, string, hashSet, cDEActionGroup);
            vector.add(serializable);
            int n2 = 0;
            while (n2 < vector2.size()) {
                String string3 = String.valueOf(string) + File.separator + vector2.get(n2);
                this.getCDEActionGroup(vector, string3, (CDEActionGroup)serializable);
                ++n2;
            }
        }
    }

    public char[] getCDEicon(String string, Locale locale) throws RemoteException, FileNotFoundException, IOException {
        String string2 = this.getLanguageCode(locale);
        String string3 = ICONPATH + string2 + "/" + string + ".m.pm";
        char[] cArray = new char[4096];
        FileReader fileReader = new FileReader(string3);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        int n = fileReader.read(cArray, 0, cArray.length);
        fileReader.close();
        char[] cArray2 = new char[n];
        int n2 = 0;
        while (n2 < cArray2.length) {
            cArray2[n2] = cArray[n2];
            ++n2;
        }
        return cArray2;
    }

    public TrustedSolarisDefaults getDefaultTsolInfo(String string) throws RemoteException, RuntimeException {
        UserSecurityInfo userSecurityInfo = this.nativeGetDefaultTsolInfo(string);
        if (userSecurityInfo == null) {
            throw new RuntimeException();
        }
        TrustedSolarisDefaults trustedSolarisDefaults = new TrustedSolarisDefaults();
        trustedSolarisDefaults.setMinLabel(userSecurityInfo.getMinLabel());
        trustedSolarisDefaults.setClearance(userSecurityInfo.getClearance());
        try {
            FileInputStream fileInputStream = new FileInputStream(DEFAULT_FILE);
            trustedSolarisDefaults.load(fileInputStream);
            fileInputStream.close();
        }
        catch (Exception exception) {
            throw new RuntimeException();
        }
        return trustedSolarisDefaults;
    }

    public String[] getInterfaceList() throws RemoteException, RuntimeException {
        return this.nativeGetInterfaceList();
    }

    private String getLanguageCode(Locale locale) {
        String string = null;
        if (locale == null) {
            string = new String("C");
        } else {
            string = locale.getLanguage();
            if (string == null) {
                string = new String("C");
            } else if (string.equals("en")) {
                string = new String("C");
            }
        }
        return string;
    }

    public LabelTitle getPanelTitles() throws RemoteException, RuntimeException {
        return this.nativeGetLabelFields();
    }

    public UserSecurityInfo getUserSecurityInfo(String string) throws RemoteException, RuntimeException {
        return this.nativeGetUserSecurityInfo(string);
    }

    public String hexCMWLabelToString(String string, String string2) throws RemoteException, BadLabelException, RuntimeException {
        return this.nativeHexCMWLabelToString(string, string2);
    }

    public String hexClearanceToString(String string, String string2) throws RemoteException, BadLabelException, RuntimeException {
        return this.nativeHexClearanceToString(string, string2);
    }

    public String hexLabelToString(String string, String string2) throws RemoteException, BadLabelException, RuntimeException {
        return this.nativeHexLabelToString(string, string2);
    }

    public void initializeScope(AdminMgmtScope adminMgmtScope) throws RemoteException, AdminException {
        this.mScope = adminMgmtScope.toDirectoryTableURL();
    }

    public native boolean nativeCheckClearanceDominance(String var1, boolean var2, String var3, String var4);

    public native boolean nativeCheckLabelDominance(String var1, String var2, String var3);

    public native LabelObj nativeCvtClearance(LabelObj var1, String var2, String var3);

    public native LabelObj nativeCvtFullClearance(String var1, String var2, String var3, UserSecurityInfo var4);

    public native LabelObj nativeCvtFullLabel(String var1, String var2, String var3, boolean var4, UserSecurityInfo var5);

    public native LabelObj nativeCvtLabel(LabelObj var1, String var2, boolean var3, UserSecurityInfo var4);

    public native RandomWord[] nativeGenRandomWord(int var1);

    public native Privilege[] nativeGetAllPrivileges();

    public native UserSecurityInfo nativeGetDefaultTsolInfo(String var1);

    public native String[] nativeGetInterfaceList();

    public native LabelTitle nativeGetLabelFields();

    public native UserSecurityInfo nativeGetUserSecurityInfo(String var1);

    public native String nativeHexCMWLabelToString(String var1, String var2);

    public native String nativeHexClearanceToString(String var1, String var2);

    public native String nativeHexLabelToString(String var1, String var2);

    public native String nativePrivNumToPrivString(String var1);

    public native String nativePrivStringToPrivNum(String var1);

    public native String nativeStringCMWLabelToHex(String var1, String var2);

    public native String nativeStringClearanceToHex(String var1, String var2);

    public native String nativeStringLabelToHex(String var1, String var2);

    public AuditUserObj newAuditUser(String string) throws DirectoryTableException, RemoteException {
        return new AuditUserObj(string);
    }

    private DirectoryTable openAuditClassTable() throws DirectoryTableException {
        DirectoryTableFactory directoryTableFactory = new DirectoryTableFactory();
        DirectoryTable directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
        directoryTable.open(classTable);
        return directoryTable;
    }

    private DirectoryTable openAuditUserTable() throws DirectoryTableException {
        DirectoryTableFactory directoryTableFactory = new DirectoryTableFactory();
        DirectoryTable directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.mScope);
        directoryTable.open(table);
        return directoryTable;
    }

    public String privNameListToPrivNumList(String string) throws RemoteException, BadPrivilegeException, RuntimeException {
        return this.nativePrivStringToPrivNum(string);
    }

    public Vector privNameListToPrivNumVector(String string) throws RemoteException, BadPrivilegeException, RuntimeException {
        String string2 = this.nativePrivStringToPrivNum(string);
        if (string2 == null) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            vector.addElement(string3);
        }
        return vector;
    }

    public String privNumListToPrivStringList(String string) throws RemoteException, BadPrivilegeException, RuntimeException {
        return this.nativePrivNumToPrivString(string);
    }

    public String privNumToPrivString(int n) throws RemoteException, BadPrivilegeException {
        String string = null;
        try {
            string = String.valueOf(n);
        }
        catch (Exception exception) {
            throw new BadPrivilegeException("");
        }
        return this.nativePrivNumToPrivString(string);
    }

    public String privNumToPrivString(String string) throws RemoteException, BadPrivilegeException {
        return this.nativePrivNumToPrivString(string);
    }

    public String privStringToPrivNum(String string) throws RemoteException, BadPrivilegeException {
        return this.nativePrivStringToPrivNum(string);
    }

    public AuditClassObj[] readAuditClass() throws DirectoryTableException, RemoteException {
        AuditClassObj auditClassObj = null;
        Vector<AuditClassObj> vector = new Vector<AuditClassObj>();
        DirectoryTable directoryTable = this.openAuditClassTable();
        try {
            TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
            DirectoryRow directoryRow = directoryTable.getAll();
            int n = 1;
            while (n <= directoryRow.getNumberOfRows()) {
                String string = directoryRow.getColumn(tableDefinitions.getColumnNumber("name"), n);
                String string2 = directoryRow.getColumn(tableDefinitions.getColumnNumber(descCol), n);
                auditClassObj = new AuditClassObj(string, string2);
                vector.addElement(auditClassObj);
                ++n;
            }
        }
        finally {
            Object var5_9 = null;
            directoryTable.close();
        }
        Object[] objectArray = new AuditClassObj[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public AuditClassObj readAuditClass(String string) throws DirectoryTableException, RemoteException {
        DirectoryTable directoryTable;
        AuditClassObj auditClassObj;
        block3: {
            auditClassObj = null;
            directoryTable = this.openAuditClassTable();
            try {
                TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
                DirectoryRow directoryRow = new DirectoryRow(tableDefinitions.getNumberOfColumns());
                directoryRow.putColumn(tableDefinitions.getColumnNumber("name"), string);
                directoryRow = directoryTable.getFirstRow((SearchTemplate)directoryRow);
                if (directoryRow != null) {
                    String string2 = directoryRow.getColumn(tableDefinitions.getColumnNumber(descCol));
                    auditClassObj = new AuditClassObj(string, string2);
                    break block3;
                }
                AdminCommonTools.CMN_Trace3((String)("Audit class information for " + string + " do not exist"));
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                directoryTable.close();
                throw throwable;
            }
        }
        Object var5_7 = null;
        directoryTable.close();
        return auditClassObj;
    }

    public AuditUserObj readAuditUser(String string) throws DirectoryTableException, RemoteException {
        DirectoryTable directoryTable;
        AuditUserObj auditUserObj;
        block2: {
            auditUserObj = null;
            directoryTable = this.openAuditUserTable();
            try {
                TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
                DirectoryRow directoryRow = new DirectoryRow(tableDefinitions.getNumberOfColumns());
                directoryRow.putColumn(tableDefinitions.getColumnNumber("name"), string);
                directoryRow = directoryTable.getFirstRow((SearchTemplate)directoryRow);
                if (directoryRow == null) break block2;
                auditUserObj = new AuditUserObj(string);
                String string2 = directoryRow.getColumn(tableDefinitions.getColumnNumber(alwaysCol));
                String string3 = directoryRow.getColumn(tableDefinitions.getColumnNumber(neverCol));
                auditUserObj.setAlwaysList(string2);
                auditUserObj.setNeverList(string3);
            }
            catch (Throwable throwable) {
                Object var5_9 = null;
                directoryTable.close();
                throw throwable;
            }
        }
        Object var5_8 = null;
        directoryTable.close();
        return auditUserObj;
    }

    public void removeAuditUser(AuditUserObj auditUserObj) throws DirectoryTableException, RemoteException {
        String string = auditUserObj.getUserName();
        this.removeAuditUser(string);
    }

    public void removeAuditUser(String string) throws DirectoryTableException, RemoteException {
        DirectoryTable directoryTable;
        block3: {
            directoryTable = this.openAuditUserTable();
            try {
                TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
                DirectoryRow directoryRow = new DirectoryRow(tableDefinitions.getNumberOfColumns());
                directoryRow.putColumn(tableDefinitions.getColumnNumber("name"), string);
                directoryRow = directoryTable.getFirstRow((SearchTemplate)directoryRow);
                if (directoryRow == null) {
                    AdminCommonTools.CMN_Trace3((String)("Audit information for " + string + " do not exist"));
                    break block3;
                }
                directoryTable.deleteRow(directoryRow);
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                directoryTable.close();
                throw throwable;
            }
        }
        Object var4_5 = null;
        directoryTable.close();
    }

    public String stringCMWLabelToHex(String string, String string2) throws RemoteException, BadLabelException, RuntimeException {
        return this.nativeStringCMWLabelToHex(string, string2);
    }

    public String stringClearanceToHex(String string, String string2) throws RemoteException, BadLabelException {
        return this.nativeStringClearanceToHex(string, string2);
    }

    public String stringLabelToHex(String string, String string2) throws RemoteException, BadLabelException, RuntimeException {
        return this.nativeStringLabelToHex(string, string2);
    }

    public void writeAuditUser(AuditUserObj auditUserObj) throws DirectoryTableException, RemoteException {
        DirectoryTable directoryTable;
        block3: {
            directoryTable = this.openAuditUserTable();
            try {
                TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
                DirectoryRow directoryRow = new DirectoryRow(tableDefinitions.getNumberOfColumns());
                directoryRow.putColumn(tableDefinitions.getColumnNumber("name"), auditUserObj.getUserName());
                directoryRow.putColumn(tableDefinitions.getColumnNumber(alwaysCol), auditUserObj.getAlwaysList());
                directoryRow.putColumn(tableDefinitions.getColumnNumber(neverCol), auditUserObj.getNeverList());
                DirectoryRow directoryRow2 = directoryTable.getFirstRow((SearchTemplate)directoryRow);
                if (directoryRow2 == null) {
                    directoryTable.addRow(directoryRow);
                    break block3;
                }
                directoryTable.modifyRow(directoryRow2, directoryRow);
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                directoryTable.close();
                throw throwable;
            }
        }
        Object var4_6 = null;
        directoryTable.close();
    }
}

