/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.utility.directorytable;

import com.sun.wbem.utility.directorytable.DirectoryRow;
import com.sun.wbem.utility.directorytable.DirectoryTable;
import com.sun.wbem.utility.directorytable.DirectoryTableAccessException;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import com.sun.wbem.utility.directorytable.DirectoryTableLibrary;
import com.sun.wbem.utility.directorytable.DirectoryTableOperationNotSupportedException;
import com.sun.wbem.utility.directorytable.DirectoryUtility;
import com.sun.wbem.utility.directorytable.LdapTableDefinitions;
import com.sun.wbem.utility.directorytable.SearchTemplate;
import com.sun.wbem.utility.directorytable.TableDefinitions;
import com.sun.wbem.utility.directorytable.TableSetup;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Vector;

public class LdapDirectoryTable
implements DirectoryTable,
TableSetup {
    TableDefinitions tableDefinitions;
    boolean needsFlush;
    String domainName;
    String serverName;
    String authName;
    String authPassword;
    int sessionDescriptor = -1;

    public int access(TableDefinitions tableDefinitions) throws DirectoryTableException {
        int n = 0;
        String string = tableDefinitions.getMappedTableName();
        if (DirectoryTableLibrary.ldapAccess(string, 16, this.authName, this.authPassword) != 0) {
            return n;
        }
        if (DirectoryTableLibrary.ldapAccess(string, 4, this.authName, this.authPassword) == 0) {
            n |= 1;
        }
        if (DirectoryTableLibrary.ldapAccess(string, 8, this.authName, this.authPassword) == 0) {
            n |= 2;
        }
        if (DirectoryTableLibrary.ldapAccess(string, 2, this.authName, this.authPassword) == 0) {
            n |= 8;
        }
        if (DirectoryTableLibrary.ldapAccess(string, 1, this.authName, this.authPassword) == 0) {
            n |= 4;
        }
        return n;
    }

    public int access(String string) throws DirectoryTableException {
        int n = 0;
        LdapTableDefinitions ldapTableDefinitions = new LdapTableDefinitions(this.serverName, this.domainName);
        ldapTableDefinitions.loadTableDefinitions(string);
        String string2 = ldapTableDefinitions.getMappedTableName();
        if (DirectoryTableLibrary.ldapAccess(string2, 16, this.authName, this.authPassword) != 0) {
            return n;
        }
        if (DirectoryTableLibrary.ldapAccess(string2, 4, this.authName, this.authPassword) == 0) {
            n |= 1;
        }
        if (DirectoryTableLibrary.ldapAccess(string2, 8, this.authName, this.authPassword) == 0) {
            n |= 2;
        }
        if (DirectoryTableLibrary.ldapAccess(string2, 2, this.authName, this.authPassword) == 0) {
            n |= 8;
        }
        if (DirectoryTableLibrary.ldapAccess(string2, 1, this.authName, this.authPassword) == 0) {
            n |= 4;
        }
        return n;
    }

    public void addRow(DirectoryRow directoryRow) throws DirectoryTableException {
        String string = null;
        if ((this.tableDefinitions.getTableAttributes() & 1) == 1) {
            throw new DirectoryTableAccessException("EXM_READONLY");
        }
        int n = 1;
        while (n <= directoryRow.getNumberOfRows()) {
            string = this.rowToDN(directoryRow, n);
            if (string == null) {
                throw new DirectoryTableAccessException("EXM_NOTUNIQUE");
            }
            int n2 = DirectoryTableLibrary.ldapAddEntry(this.sessionDescriptor, string, this.rowToArray(directoryRow, n));
            DirectoryTableLibrary.ldapErrorToException(n2, this.tableDefinitions);
            ++n;
        }
        this.needsFlush = true;
    }

    private void arrayIntoRow(String[] stringArray, int n, DirectoryRow directoryRow, int n2, int n3) throws DirectoryTableException {
        int n4 = this.tableDefinitions.getNumberOfColumns();
        if (n3 == 0) {
            n3 = (stringArray.length - n) / n4;
        }
        int n5 = n2;
        while (n5 < n2 + n3) {
            int n6 = 0;
            while (n6 < n4) {
                directoryRow.putColumn(n6 + 1, n5, stringArray[(n5 - n2) * n4 + n + n6]);
                ++n6;
            }
            ++n5;
        }
    }

    private DirectoryRow arrayToRow(String[] stringArray) throws DirectoryTableException {
        int n = this.tableDefinitions.getNumberOfColumns();
        DirectoryRow directoryRow = new DirectoryRow(n);
        int n2 = 0;
        while (n2 < n) {
            directoryRow.putColumn(n2 + 1, stringArray[n2]);
            ++n2;
        }
        return directoryRow;
    }

    public void close() {
        try {
            this.flush();
        }
        catch (DirectoryTableException directoryTableException) {
            this.needsFlush = false;
        }
        DirectoryTableLibrary.ldapCloseTable(this.sessionDescriptor);
        this.tableDefinitions = null;
        this.sessionDescriptor = -1;
    }

    public void create(TableDefinitions tableDefinitions) throws DirectoryTableException {
        char c = tableDefinitions.getColumnSeparators().charAt(0);
        int n = DirectoryTableLibrary.convertAccessToRights(tableDefinitions.getAccess());
        int n2 = tableDefinitions.getNumberOfColumns();
        String[] stringArray = new String[n2];
        int n3 = 0;
        while (n3 < n2) {
            stringArray[n3] = (tableDefinitions.getColumnAttributes(n3 + 1) & 1) == 1 ? "S" + tableDefinitions.getMappedColumnName(n3 + 1) : "N" + tableDefinitions.getMappedColumnName(n3 + 1);
            ++n3;
        }
        this.sessionDescriptor = DirectoryTableLibrary.ldapAddTable(tableDefinitions.getMappedTableName(), n, stringArray, this.authName, this.authPassword);
        if (this.sessionDescriptor < 1) {
            int n4 = -this.sessionDescriptor;
            DirectoryTableLibrary.ldapErrorToException(n4, tableDefinitions);
        }
        this.tableDefinitions = tableDefinitions;
        this.needsFlush = false;
    }

    public void create(String string) throws DirectoryTableException {
        LdapTableDefinitions ldapTableDefinitions = new LdapTableDefinitions(this.serverName, this.domainName);
        ldapTableDefinitions.loadTableDefinitions(string);
        char c = ldapTableDefinitions.getColumnSeparators().charAt(0);
        int n = DirectoryTableLibrary.convertAccessToRights(ldapTableDefinitions.getAccess());
        int n2 = ldapTableDefinitions.getNumberOfColumns();
        String[] stringArray = new String[n2];
        int n3 = 0;
        while (n3 < n2) {
            stringArray[n3] = (ldapTableDefinitions.getColumnAttributes(n3 + 1) & 1) == 1 ? "S" + ldapTableDefinitions.getMappedColumnName(n3 + 1) : "N" + ldapTableDefinitions.getMappedColumnName(n3 + 1);
            ++n3;
        }
        this.sessionDescriptor = DirectoryTableLibrary.ldapAddTable(ldapTableDefinitions.getMappedTableName(), n, stringArray, this.authName, this.authPassword);
        if (this.sessionDescriptor < 1) {
            int n4 = -this.sessionDescriptor;
            DirectoryTableLibrary.ldapErrorToException(n4, ldapTableDefinitions);
        }
        this.tableDefinitions = ldapTableDefinitions;
        this.needsFlush = false;
    }

    public void delete(TableDefinitions tableDefinitions) throws DirectoryTableException {
        int n = 0;
        n = DirectoryTableLibrary.ldapDeleteTable(tableDefinitions.getMappedTableName(), this.authName, this.authPassword);
        DirectoryTableLibrary.ldapErrorToException(n, tableDefinitions);
    }

    public void delete(String string) throws DirectoryTableException {
        int n = 0;
        LdapTableDefinitions ldapTableDefinitions = new LdapTableDefinitions(this.serverName, this.domainName);
        ldapTableDefinitions.loadTableDefinitions(string);
        n = DirectoryTableLibrary.ldapDeleteTable(ldapTableDefinitions.getMappedTableName(), this.authName, this.authPassword);
        DirectoryTableLibrary.ldapErrorToException(n, ldapTableDefinitions);
    }

    public void deleteRow(DirectoryRow directoryRow) throws DirectoryTableException {
        String string = null;
        if ((this.tableDefinitions.getTableAttributes() & 1) == 1) {
            throw new DirectoryTableAccessException("EXM_READONLY");
        }
        int n = 1;
        while (n <= directoryRow.getNumberOfRows()) {
            string = this.rowToDN(directoryRow, n);
            if (string == null) {
                throw new DirectoryTableAccessException("EXM_NOTUNIQUE");
            }
            int n2 = DirectoryTableLibrary.ldapDeleteEntry(this.sessionDescriptor, string);
            DirectoryTableLibrary.ldapErrorToException(n2, this.tableDefinitions);
            ++n;
        }
        this.needsFlush = true;
    }

    public void flush() throws DirectoryTableException {
        if (this.needsFlush) {
            this.needsFlush = false;
        }
    }

    public DirectoryRow getAll() throws DirectoryTableException {
        DirectoryRow directoryRow = null;
        DirectoryRow directoryRow2 = null;
        boolean bl = true;
        int n = 0;
        int n2 = 0;
        directoryRow2 = new DirectoryRow(this.tableDefinitions.getNumberOfColumns(), 1);
        String string = this.rowToSearchName(directoryRow2, 1);
        String[] stringArray = DirectoryTableLibrary.ldapGetAllEntries(this.sessionDescriptor, string);
        if (stringArray == null) {
            return directoryRow;
        }
        n = this.tableDefinitions.getNumberOfColumns();
        n2 = stringArray.length / n;
        directoryRow = new DirectoryRow(n, n2);
        this.arrayIntoRow(stringArray, 0, directoryRow, 1, n2);
        return directoryRow;
    }

    public DirectoryRow getAll(SearchTemplate searchTemplate) throws DirectoryTableException {
        DirectoryRow directoryRow = new DirectoryRow(this.tableDefinitions.getNumberOfColumns(), 1);
        int n = 1;
        int n2 = 0;
        int n3 = 0;
        DirectoryRow directoryRow2 = searchTemplate.getTemplateAsRow(this.tableDefinitions);
        String string = directoryRow2 == null ? "" : this.rowToSearchName(directoryRow2, 1);
        String[] stringArray = DirectoryTableLibrary.ldapGetAllEntries(this.sessionDescriptor, string);
        if (stringArray == null) {
            return null;
        }
        n2 = this.tableDefinitions.getNumberOfColumns();
        n3 = stringArray.length / n2;
        int n4 = 0;
        while (n4 < n3) {
            this.arrayIntoRow(stringArray, n4 * n2, directoryRow, n, 1);
            if (!directoryRow.isEmpty() && searchTemplate.matchRow(directoryRow, n, this.tableDefinitions)) {
                directoryRow.addRows(1);
                ++n;
            }
            ++n4;
        }
        directoryRow.deleteRow(n);
        if (n == 1) {
            return null;
        }
        return directoryRow;
    }

    public TableDefinitions getCurrentTableDefinitions() {
        return this.tableDefinitions;
    }

    public DirectoryRow getFirstRow() throws DirectoryTableException {
        DirectoryRow directoryRow = new DirectoryRow(this.tableDefinitions.getNumberOfColumns());
        return this.getFirstRow(directoryRow);
    }

    public DirectoryRow getFirstRow(SearchTemplate searchTemplate) throws DirectoryTableException {
        DirectoryRow directoryRow = searchTemplate.getTemplateAsRow(this.tableDefinitions);
        String string = directoryRow == null ? "" : this.rowToSearchName(directoryRow, 1);
        String[] stringArray = DirectoryTableLibrary.ldapGetFirstEntry(this.sessionDescriptor, string);
        if (stringArray == null) {
            return null;
        }
        DirectoryRow directoryRow2 = this.arrayToRow(stringArray);
        if (!directoryRow2.isEmpty() && searchTemplate.matchRow(directoryRow2, 1, this.tableDefinitions)) {
            return directoryRow2;
        }
        stringArray = DirectoryTableLibrary.ldapGetNextEntry(this.sessionDescriptor);
        while (stringArray != null) {
            directoryRow2 = this.arrayToRow(stringArray);
            if (!directoryRow2.isEmpty() && searchTemplate.matchRow(directoryRow2, 1, this.tableDefinitions)) {
                return directoryRow2;
            }
            stringArray = DirectoryTableLibrary.ldapGetNextEntry(this.sessionDescriptor);
        }
        return null;
    }

    public DirectoryRow getNextRow() throws DirectoryTableException {
        DirectoryRow directoryRow = new DirectoryRow(this.tableDefinitions.getNumberOfColumns());
        return this.getNextRow(directoryRow);
    }

    public DirectoryRow getNextRow(SearchTemplate searchTemplate) throws DirectoryTableException {
        String[] stringArray = DirectoryTableLibrary.ldapGetNextEntry(this.sessionDescriptor);
        while (stringArray != null) {
            DirectoryRow directoryRow = this.arrayToRow(stringArray);
            if (!directoryRow.isEmpty() && searchTemplate.matchRow(directoryRow, 1, this.tableDefinitions)) {
                return directoryRow;
            }
            stringArray = DirectoryTableLibrary.ldapGetNextEntry(this.sessionDescriptor);
        }
        return null;
    }

    public DirectoryRow getRowInstance() {
        return new DirectoryRow(this.tableDefinitions.getNumberOfColumns(), 1);
    }

    public DirectoryRow getRowInstance(int n) {
        return new DirectoryRow(this.tableDefinitions.getNumberOfColumns(), n);
    }

    public Vector getScopes(int n) {
        String string;
        Vector<String> vector = null;
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            return vector;
        }
        String string2 = DirectoryTableLibrary.getDomain();
        if (string2.length() > 0 && string2.charAt(string2.length() - 1) == '.') {
            string2 = string2.substring(0, string2.length() - 1);
        }
        if (string2.equals("")) {
            return vector;
        }
        LdapTableDefinitions ldapTableDefinitions = new LdapTableDefinitions(string, string2);
        try {
            ldapTableDefinitions.loadTableDefinitions("group");
        }
        catch (Exception exception) {
            return vector;
        }
        String string3 = ldapTableDefinitions.getMappedTableName();
        if ((n & 2) == 2) {
            if (DirectoryTableLibrary.ldapAccess(string3, 2, this.authName, this.authPassword) == 0) {
                vector = new Vector<String>();
                vector.addElement("ldap:/" + string + "/" + string2);
            }
        } else if (DirectoryTableLibrary.ldapAccess(string3, 1, this.authName, this.authPassword) == 0) {
            vector = new Vector();
            vector.addElement("ldap:/" + string + "/" + string2);
        }
        return vector;
    }

    public TableDefinitions getTableDefinitionsInstance() {
        return new LdapTableDefinitions(this.serverName, this.domainName);
    }

    public void modifyRow(DirectoryRow directoryRow, DirectoryRow directoryRow2) throws DirectoryTableException {
        if ((this.tableDefinitions.getTableAttributes() & 1) == 1) {
            throw new DirectoryTableAccessException("EXM_READONLY");
        }
        int n = DirectoryTableLibrary.ldapModifyEntry(this.sessionDescriptor, this.rowToDN(directoryRow, 1), this.rowToArray(directoryRow2, 1));
        DirectoryTableLibrary.ldapErrorToException(n, this.tableDefinitions);
        this.needsFlush = true;
    }

    public void open(TableDefinitions tableDefinitions) throws DirectoryTableException {
        int n = tableDefinitions.getNumberOfColumns();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = tableDefinitions.getMappedColumnName(n2 + 1);
            ++n2;
        }
        this.sessionDescriptor = DirectoryTableLibrary.ldapOpenTable(this.serverName, tableDefinitions.getMappedTableName(), stringArray, this.authName, this.authPassword);
        if (this.sessionDescriptor < 1) {
            int n3 = -this.sessionDescriptor;
            DirectoryTableLibrary.ldapErrorToException(n3, tableDefinitions);
        }
        this.tableDefinitions = tableDefinitions;
        this.needsFlush = false;
    }

    public void open(String string) throws DirectoryTableException {
        LdapTableDefinitions ldapTableDefinitions = new LdapTableDefinitions(this.serverName, this.domainName);
        ldapTableDefinitions.loadTableDefinitions(string);
        int n = ldapTableDefinitions.getNumberOfColumns();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = ldapTableDefinitions.getMappedColumnName(n2 + 1);
            ++n2;
        }
        this.sessionDescriptor = DirectoryTableLibrary.ldapOpenTable(this.serverName, ldapTableDefinitions.getMappedTableName(), stringArray, this.authName, this.authPassword);
        if (this.sessionDescriptor < 1) {
            int n3 = -this.sessionDescriptor;
            DirectoryTableLibrary.ldapErrorToException(n3, ldapTableDefinitions);
        }
        this.tableDefinitions = ldapTableDefinitions;
        this.needsFlush = false;
    }

    public void refreshSetup() {
    }

    private String[] rowToArray(DirectoryRow directoryRow, int n) throws DirectoryTableException {
        int n2 = directoryRow.getNumberOfColumns();
        String[] stringArray = new String[n2 + 1];
        stringArray[0] = this.tableDefinitions.getTableType();
        int n3 = 1;
        while (n3 < n2 + 1) {
            stringArray[n3] = directoryRow.getColumn(n3, n);
            ++n3;
        }
        return stringArray;
    }

    private String rowToDN(DirectoryRow directoryRow, int n) throws DirectoryTableException {
        String string = "";
        boolean bl = true;
        int n2 = directoryRow.getNumberOfColumns();
        int n3 = 0;
        while (n3 < n2) {
            if ((this.tableDefinitions.getColumnAttributes(n3 + 1) & 0x20) == 32) {
                if (!bl) {
                    string = String.valueOf(string) + ", ";
                } else {
                    bl = false;
                }
                if (directoryRow.getColumn(n3 + 1, n).equals("")) {
                    String string2 = this.tableDefinitions.getAuxilliaryColumnData(n3 + 1);
                    string = String.valueOf(string) + this.tableDefinitions.getMappedColumnName(n3 + 1) + " = " + directoryRow.getColumn(this.tableDefinitions.getColumnNumber(string2), n);
                } else {
                    string = String.valueOf(string) + this.tableDefinitions.getMappedColumnName(n3 + 1) + " = " + directoryRow.getColumn(n3 + 1, n);
                }
            }
            ++n3;
        }
        return string;
    }

    private String rowToSearchName(DirectoryRow directoryRow, int n) throws DirectoryTableException {
        int n2 = directoryRow.getNumberOfColumns();
        boolean bl = true;
        String string = new String("");
        int n3 = 1;
        while (n3 <= n2) {
            if ((this.tableDefinitions.getColumnAttributes(n3) & 1) == 1) {
                if (bl) {
                    string = String.valueOf(string) + "(&";
                    bl = false;
                }
                string = !directoryRow.getColumn(n3, n).equals("") ? String.valueOf(string) + "(" + this.tableDefinitions.getMappedColumnName(n3) + " = " + directoryRow.getColumn(n3, n) + ")" : String.valueOf(string) + "(" + this.tableDefinitions.getMappedColumnName(n3) + " =*)";
            }
            ++n3;
        }
        if (!bl) {
            string = String.valueOf(string) + "(objectClass = " + this.tableDefinitions.getTableType() + "))";
        }
        return string;
    }

    public void setContext(String string) throws DirectoryTableException {
        this.serverName = DirectoryUtility.getContextProperty(string, "serverName");
        this.domainName = DirectoryUtility.getContextProperty(string, "domainName");
        this.authName = DirectoryUtility.getContextProperty(string, "authName");
        this.authPassword = DirectoryUtility.getContextProperty(string, "authPassword");
        try {
            if (!this.serverName.equalsIgnoreCase(InetAddress.getLocalHost().getHostName())) {
                throw new DirectoryTableOperationNotSupportedException("Remote LDAP");
            }
        }
        catch (UnknownHostException unknownHostException) {
            throw new DirectoryTableException("EXM_INTERNAL");
        }
    }

    public void setup() {
    }
}

