/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.utility.directorytable;

import com.sun.wbem.utility.common.UException;
import com.sun.wbem.utility.directorytable.DirectoryTableInvalidParameterException;
import com.sun.wbem.utility.directorytable.DirectoryUtility;
import com.sun.wbem.utility.directorytable.TableDefinitions;
import java.util.StringTokenizer;

public class NisTableDefinitions
implements TableDefinitions {
    static int NUMBER_OF_TABLES = 22;
    static int TABLE_NAME = 0;
    static int MAPPED_TABLE_NAME = 1;
    static int COLUMN_SEPARATORS = 2;
    static int COMMENT_SEPARATORS = 3;
    static int USERID = 4;
    static int GROUPID = 5;
    static int ACCESS = 6;
    static int TABLE_ATTRIBUTES = 7;
    static int TABLE_TYPE = 8;
    static int NUMBER_OF_COLUMNS = 9;
    static int USER_DEFINED = 99;
    static String[][] definitions = new String[][]{{"ethers", "%DIR%/ethers", " \t", "#", "0", "3", Integer.toString(287), Integer.toString(4), "ethers", "3", "addr", Integer.toString(3), "name", Integer.toString(9), "comment", Integer.toString(8)}, {"bootparams", "%DIR%/bootparams", " \t", "#", "0", "3", Integer.toString(287), Integer.toString(36), "bootparams", "3", "clientname", Integer.toString(3), "identifiers", Integer.toString(73), "comment", Integer.toString(8)}, {"timezone", "%DIR%/timezone", " \t", "#", "0", "3", Integer.toString(273), Integer.toString(4), "timezone", "3", "timezone", Integer.toString(3), "domain", Integer.toString(3), "comment", Integer.toString(8)}, {"netmasks", "%DIR%/netmasks", " \t", "#", "0", "3", Integer.toString(273), Integer.toString(4), "netmasks", "3", "addr", Integer.toString(3), "mask", Integer.toString(3), "comment", Integer.toString(8)}, {"group", "%DIR%/group", ":", "#", "0", "3", Integer.toString(287), Integer.toString(10), "group", "4", "name", Integer.toString(9), "passwd", Integer.toString(8), "gid", Integer.toString(5), "members", Integer.toString(8)}, {"hosts", "%DIR%/hosts", " \t", "#", "0", "3", Integer.toString(273), Integer.toString(4), "hosts", "4", "addr", Integer.toString(3), "cname", Integer.toString(9), "aliases", Integer.toString(73), "comment", Integer.toString(8)}, {"networks", "%DIR%/networks", " \t", "#", "0", "3", Integer.toString(273), Integer.toString(4), "networks", "4", "cname", Integer.toString(9), "addr", Integer.toString(3), "aliases", Integer.toString(73), "comment", Integer.toString(8)}, {"passwd", "%PWDIR%/passwd", ":", "#", "0", "3", Integer.toString(287), Integer.toString(10), "passwd", "7", "name", Integer.toString(9), "passwd", Integer.toString(8), "uid", Integer.toString(5), "gid", Integer.toString(4), "gcos", Integer.toString(8), "home", Integer.toString(8), "shell", Integer.toString(8)}, {"shadow", "%PWDIR%/shadow", ":", "#", "0", "3", Integer.toString(1), Integer.toString(10), "passwd", "9", "name", Integer.toString(9), "passwd", Integer.toString(8), "lastchg", Integer.toString(8), "min", Integer.toString(8), "max", Integer.toString(8), "warn", Integer.toString(8), "inactive", Integer.toString(8), "expire", Integer.toString(8), "flag", Integer.toString(8)}, {"protocols", "%DIR%/protocols", " \t", "#", "0", "3", Integer.toString(273), Integer.toString(4), "protocols", "4", "cname", Integer.toString(9), "number", Integer.toString(9), "aliases", Integer.toString(73), "comment", Integer.toString(8)}, {"services", "%DIR%/services", " \t/", "#", "0", "3", Integer.toString(273), Integer.toString(4), "services", "5", "cname", Integer.toString(9), "port", Integer.toString(5), "proto", Integer.toString(9), "aliases", Integer.toString(73), "comment", Integer.toString(8)}, {"rpc", "%DIR%/rpc", " \t", "#", "0", "3", Integer.toString(287), Integer.toString(4), "rpc", "4", "cname", Integer.toString(9), "number", Integer.toString(5), "aliases", Integer.toString(73), "comment", Integer.toString(8)}, {"aliases", "%ALIASES%", ":", "#", "0", "3", Integer.toString(287), Integer.toString(70), "aliases", "3", "alias", Integer.toString(9), "expansion", Integer.toString(72), "comment", Integer.toString(8)}, {"auto_master", "%DIR%/auto_master", " \t", "#", "0", "3", Integer.toString(287), Integer.toString(8), "auto.master", "2", "key", Integer.toString(9), "value", Integer.toString(73)}, {"auto_home", "%DIR%/auto_home", " \t", "#", "0", "3", Integer.toString(287), Integer.toString(8), "auto.home", "2", "key", Integer.toString(9), "value", Integer.toString(72)}, {"user_attr", "%DIR%/user_attr", ":", "#", "0", "3", Integer.toString(287), Integer.toString(26), "user.attr", "5", "name", Integer.toString(9), "qualifier", Integer.toString(9), "res1", Integer.toString(8), "res2", Integer.toString(8), "attr", Integer.toString(8)}, {"auth_attr", "%RBACDIR%/auth_attr", ":", "#", "0", "3", Integer.toString(287), Integer.toString(26), "auth.attr", "6", "name", Integer.toString(9), "res1", Integer.toString(8), "res2", Integer.toString(8), "short_descr", Integer.toString(8), "long_descr", Integer.toString(8), "attr", Integer.toString(8)}, {"prof_attr", "%RBACDIR%/prof_attr", ":", "#", "0", "3", Integer.toString(287), Integer.toString(42), "prof.attr", "5", "name", Integer.toString(9), "res1", Integer.toString(8), "res2", Integer.toString(8), "long_descr", Integer.toString(8), "attr", Integer.toString(8)}, {"exec_attr", "%RBACDIR%/exec_attr", ":", "#", "0", "3", Integer.toString(287), Integer.toString(42), "exec.attr", "7", "name", Integer.toString(9), "policy", Integer.toString(9), "type", Integer.toString(8), "res1", Integer.toString(8), "res2", Integer.toString(8), "id", Integer.toString(9), "attr", Integer.toString(8)}, {"audit_user", "%RBACDIR%/audit_user", ":", "#", "0", "3", Integer.toString(287), Integer.toString(42), "audit.user", "3", "name", Integer.toString(9), "alwaysauditflags", Integer.toString(8), "neverauditflags", Integer.toString(8)}, {"tnrhtp", "%DIR%/tnrhtp", ":", "#", "0", "3", Integer.toString(287), Integer.toString(42), "tnrhtp", "2", "name", Integer.toString(9), "attributes", Integer.toString(8)}, {"tnrhdb", "%DIR%/tnrhdb", ":", "#", "0", "3", Integer.toString(287), Integer.toString(42), "tnrhdb", "2", "addr", Integer.toString(9), "name", Integer.toString(8)}};
    String path_pwdir;
    String path_aliases;
    String path_dir;
    String path_rbacdir;
    int tableIndex;
    String tableName;
    String tableType;
    String mappedTableName;
    String columnSeparators;
    String commentSeparators;
    int userId;
    int groupId;
    int access;
    int numberOfColumns;
    int tableAttributes;
    int[] columnAttributes;
    String[] columnNames;
    String[] mappedColumnNames;
    String[] secondaryMappedColumnNames;
    String serverName;
    String domainName;

    public NisTableDefinitions(String string, String string2) {
        this.serverName = string;
        this.domainName = string2;
        this.tableIndex = USER_DEFINED;
        this.tableName = "";
        this.tableType = "";
        this.mappedTableName = "";
        this.columnSeparators = " \t";
        this.commentSeparators = "#";
        this.tableAttributes = 0;
        this.columnNames = null;
        this.mappedColumnNames = null;
        this.secondaryMappedColumnNames = null;
        this.columnAttributes = null;
        try {
            this.path_pwdir = DirectoryUtility.getDirectoryTableProperty("directorytable.nis.pwdir");
            if (this.path_pwdir == null || this.path_pwdir.equals("")) {
                this.path_pwdir = "/etc";
            }
        }
        catch (UException uException) {
            this.path_pwdir = "/etc";
        }
        try {
            this.path_dir = DirectoryUtility.getDirectoryTableProperty("directorytable.nis.dir");
            if (this.path_dir == null || this.path_dir.equals("")) {
                this.path_dir = "/etc";
            }
        }
        catch (UException uException) {
            this.path_dir = "/etc";
        }
        try {
            this.path_rbacdir = DirectoryUtility.getDirectoryTableProperty("directorytable.nis.rbacdir");
            if (this.path_rbacdir == null || this.path_rbacdir.equals("")) {
                this.path_rbacdir = "/etc/security";
            }
        }
        catch (UException uException) {
            this.path_rbacdir = "/etc/security";
        }
        try {
            this.path_aliases = DirectoryUtility.getDirectoryTableProperty("directorytable.nis.aliases");
            if (this.path_aliases == null || this.path_aliases.equals("")) {
                this.path_aliases = "/etc/mail/aliases";
            }
        }
        catch (UException uException) {
            this.path_aliases = "/etc/mail/aliases";
        }
        this.userId = 0;
        this.groupId = 3;
        this.access = 273;
    }

    private String expandMacros(String string) {
        String string2 = "";
        String string3 = null;
        StringTokenizer stringTokenizer = null;
        stringTokenizer = new StringTokenizer(string, "%");
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
            string2 = string3.compareTo("DIR") == 0 ? String.valueOf(string2) + this.path_dir : (string3.compareTo("RBACDIR") == 0 ? String.valueOf(string2) + this.path_rbacdir : (string3.compareTo("PWDIR") == 0 ? String.valueOf(string2) + this.path_pwdir : (string3.compareTo("ALIASES") == 0 ? String.valueOf(string2) + this.path_aliases : String.valueOf(string2) + string3)));
        }
        return string2;
    }

    public int getAccess() {
        return this.access;
    }

    public String getAuxilliaryColumnData(int n) throws DirectoryTableInvalidParameterException {
        if (n < 0 || n > this.numberOfColumns) {
            throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
        }
        return this.secondaryMappedColumnNames[n - 1];
    }

    public int getColumnAttributes(int n) throws DirectoryTableInvalidParameterException {
        if (n <= this.numberOfColumns && n > 0) {
            return this.columnAttributes[n - 1];
        }
        throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
    }

    public String getColumnName(int n) throws DirectoryTableInvalidParameterException {
        if (n < 0 || n > this.numberOfColumns) {
            throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
        }
        return this.columnNames[n - 1];
    }

    public int getColumnNumber(String string) throws DirectoryTableInvalidParameterException {
        int n = 0;
        while (n < this.numberOfColumns) {
            if (this.columnNames[n].equalsIgnoreCase(string)) {
                return n + 1;
            }
            ++n;
        }
        throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
    }

    public String getColumnSeparators() {
        return this.columnSeparators;
    }

    public String getCommentSeparators() {
        return this.commentSeparators;
    }

    public int getGroup() {
        return this.groupId;
    }

    public String getMappedColumnName(int n) throws DirectoryTableInvalidParameterException {
        if (n < 0 || n > this.numberOfColumns) {
            throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
        }
        return this.mappedColumnNames[n - 1];
    }

    public String getMappedTableName() {
        return this.expandMacros(this.mappedTableName);
    }

    public int getNumberOfColumns() {
        return this.numberOfColumns;
    }

    public String getRawMappedTableName() {
        return this.mappedTableName;
    }

    public int getTableAttributes() {
        return this.tableAttributes;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getTableType() {
        return this.tableType;
    }

    public int getUser() {
        return this.userId;
    }

    public void loadTableDefinitions(String string) throws DirectoryTableInvalidParameterException {
        this.tableName = string;
        int n = 0;
        while (n < NUMBER_OF_TABLES) {
            if (string.equalsIgnoreCase(definitions[n][TABLE_NAME])) {
                this.tableIndex = n;
                this.tableName = definitions[n][TABLE_NAME];
                this.mappedTableName = definitions[n][MAPPED_TABLE_NAME];
                this.columnSeparators = definitions[n][COLUMN_SEPARATORS];
                this.commentSeparators = definitions[n][COMMENT_SEPARATORS];
                this.userId = Integer.valueOf(definitions[n][USERID]);
                this.groupId = Integer.valueOf(definitions[n][GROUPID]);
                this.access = Integer.valueOf(definitions[n][ACCESS]);
                this.tableAttributes = Integer.valueOf(definitions[n][TABLE_ATTRIBUTES]);
                this.tableType = definitions[n][TABLE_TYPE];
                this.numberOfColumns = Integer.valueOf(definitions[n][NUMBER_OF_COLUMNS]);
                this.columnNames = new String[this.numberOfColumns];
                this.mappedColumnNames = new String[this.numberOfColumns];
                this.secondaryMappedColumnNames = new String[this.numberOfColumns];
                this.columnAttributes = new int[this.numberOfColumns];
                int n2 = 0;
                while (n2 < this.numberOfColumns) {
                    this.columnNames[n2] = definitions[n][NUMBER_OF_COLUMNS + n2 * 2 + 1];
                    this.mappedColumnNames[n2] = definitions[n][NUMBER_OF_COLUMNS + n2 * 2 + 1];
                    this.secondaryMappedColumnNames[n2] = definitions[n][NUMBER_OF_COLUMNS + n2 * 2 + 1];
                    this.columnAttributes[n2] = Integer.valueOf(definitions[n][NUMBER_OF_COLUMNS + n2 * 2 + 2]);
                    ++n2;
                }
                break;
            }
            ++n;
        }
        if (n == NUMBER_OF_TABLES) {
            throw new DirectoryTableInvalidParameterException("EXM_NOTABLEDEF", string);
        }
    }

    public void setAccess(int n) {
        this.access = n;
    }

    public void setAuxilliaryColumnData(int n, String string) throws DirectoryTableInvalidParameterException {
        if (n > this.numberOfColumns || n <= 0) {
            throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
        }
        this.secondaryMappedColumnNames[n - 1] = string;
    }

    public void setColumnAttributes(int n, int n2) throws DirectoryTableInvalidParameterException {
        if (n > this.numberOfColumns || n <= 0) {
            throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
        }
        this.columnAttributes[n - 1] = n2;
    }

    public void setColumnName(int n, String string) throws DirectoryTableInvalidParameterException {
        if (n > this.numberOfColumns || n <= 0) {
            throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
        }
        this.columnNames[n - 1] = string;
    }

    public void setColumnSeparators(String string) {
        this.columnSeparators = string;
    }

    public void setCommentSeparators(String string) {
        this.commentSeparators = string;
    }

    public void setGroup(int n) {
        this.groupId = n;
    }

    public void setMappedColumnName(int n, String string) throws DirectoryTableInvalidParameterException {
        if (n > this.numberOfColumns || n <= 0) {
            throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
        }
        this.mappedColumnNames[n - 1] = string;
    }

    public void setMappedTableName(String string) {
        this.mappedTableName = string;
    }

    public void setNumberOfColumns(int n) throws DirectoryTableInvalidParameterException {
        if (n < 0) {
            throw new DirectoryTableInvalidParameterException();
        }
        this.numberOfColumns = n;
        this.columnNames = new String[this.numberOfColumns];
        this.columnAttributes = new int[this.numberOfColumns];
    }

    public void setTableAttributes(int n) {
        this.tableAttributes = n;
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public void setTableType(String string) {
        this.tableType = string;
    }

    public void setUser(int n) {
        this.userId = n;
    }
}

