/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.hostmgr.cli.template;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.CommandLineOption;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.hostmgr.cli.HostMgrCliTool;
import com.sun.admin.hostmgr.common.HostException;
import com.sun.admin.hostmgr.common.HostMgrCliArgParsingException;
import com.sun.admin.hostmgr.common.HostMgrCliHelpException;
import com.sun.admin.hostmgr.common.TemplateData;
import com.sun.admin.tsol.common.BadLabelException;
import com.sun.admin.tsol.server.TrustedSolarisServiceInterface;
import com.sun.management.viper.ToolInfrastructure;
import com.sun.management.viper.util.CommandOption;
import com.sun.management.viper.util.CommandParser;
import com.sun.management.viper.util.ResourceManager;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;

public class HostMgrTmplCli
extends HostMgrCliTool {
    private Vector vObjs = new Vector();
    private CommandLineOption coTaskFile;
    private CommandLineOption coHelp;
    private CommandLineOption coTemplateName;
    private CommandLineOption coHostType;
    private CommandLineOption coXArgs;
    private CommandLineOption coLabel;
    private CommandLineOption coClearance;
    private CommandLineOption coAddForcedPriv;
    private CommandLineOption coAddAllowedPriv;
    private CommandLineOption coIpLabel;
    private Vector vXArgs;
    private TrustedSolarisServiceInterface labelService;
    private String userName;
    private static final String PRIV_NONE = "none";
    private static final String PRIV_ALL = "all";
    private static final String PRIV_EMPTY = "empty";
    private static final int HOSTTYPE_UNLABELED = 0;
    private static final int HOSTTYPE_SUN_TSOL = 1;
    private static final int HOSTTYPE_RIPSO = 2;
    private static final int HOSTTYPE_CIPSO = 3;
    private static final int HOSTTYPE_TSIX = 4;
    private static String[] hostTypeList = new String[]{"unlabeled", "sun_tsol", "ripso", "cipso", "tsix"};
    private static String[] ipLabelList = new String[]{"none", "ripso", "cipso"};
    private static final String NONE_IPLABEL = ipLabelList[0];
    private static final String RIPSO_IPLABEL = ipLabelList[1];
    private static final String CIPSO_IPLABEL = ipLabelList[2];
    private static String[] ripsoSendClassList = new String[]{"Top Secret", "Secret", "Confidential", "Unclassified"};
    private static String[] ripsoSendClassHexList = new String[]{"0x3d", "0x5a", "0x96", "0xab"};
    private static String[] ripsoPAFList = new String[]{"GENSER", "SIOP-ESI", "SCI", "NSA", "DOE"};
    private static String[] ripsoPAFHexList = new String[]{"0x80000000", "0x40000000", "0x20000000", "0x10000000", "0x08000000"};
    ResourceBundle bundle;
    private static final int MAX_VALID_DOI = (int)Math.pow(2.0, 32.0);
    private static final String EMPTY = "empty";

    public HostMgrTmplCli() {
        try {
            this.bundle = ResourceManager.getBundle((String)"com.sun.admin.hostmgr.cli.template.resources.Resources", ((Object)((Object)this)).getClass());
            this.setResourceBundle(this.bundle);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.bundle = null;
        }
        if (this.bundle == null) {
            this.bundle = ResourceBundle.getBundle("com.sun.admin.hostmgr.cli.template.resources.Resources", Locale.getDefault(), ((Object)((Object)this)).getClass().getClassLoader());
            this.setResourceBundle(this.bundle);
        }
        if (this.bundle == null) {
            this.giveNoBundleMessage();
            System.exit(2);
        }
    }

    public void addObject() throws Exception {
        this.trace("in HostMgrTmplCli->addObject()");
        try {
            TemplateData templateData = (TemplateData)this.vObjs.elementAt(0);
            if (this.getHostMgr() == null) {
                this.trace("in addObject:  hostmgr is null!");
                throw new HostException("EXM_CLI_NO_SERVICE");
            }
            this.getHostMgr().addTemplate(templateData);
        }
        catch (Exception exception) {
            this.trace("exception in addObject(): " + exception.getMessage());
            if (this.getDebugStatus()) {
                exception.printStackTrace();
            }
            throw exception;
        }
    }

    public String checkCMWLabel(String string) throws HostException {
        String string2 = null;
        this.trace("HostMgrTmplCli->checkCMWLabel()");
        try {
            if (string.startsWith("0x")) {
                string2 = this.labelService.hexCMWLabelToString(string, this.userName);
                return string;
            }
            string2 = this.labelService.stringCMWLabelToHex(string, this.userName);
            return string2;
        }
        catch (BadLabelException badLabelException) {
            int n = badLabelException.getErrorCode();
            throw new HostException("EXM_CLI_NETTMPL_BAD_CMW_LABEL_ERROR", string, Integer.toString(n));
        }
        catch (Exception exception) {
            throw new HostException("EXM_CLI_NETTMPL_CMW_LABEL_ERROR");
        }
    }

    public String checkClearance(String string) throws Exception {
        String string2 = null;
        this.trace("HostMgrTmplCli->checkClearance()");
        try {
            if (string.startsWith("0x")) {
                string2 = this.labelService.hexClearanceToString(string, this.userName);
                return string;
            }
            string2 = this.labelService.stringClearanceToHex(string, this.userName);
            return string2;
        }
        catch (BadLabelException badLabelException) {
            int n = badLabelException.getErrorCode();
            throw new HostException("EXM_CLI_NETTMPL_CLEARANCE_BAD_ERROR", string, Integer.toString(n));
        }
        catch (Exception exception) {
            throw new HostException("EXM_CLI_NETTMPL_CLEARANCE_ERROR");
        }
    }

    public void checkDominance(String string, String string2) throws Exception {
        boolean bl = true;
        this.trace("HostMgrTmplCli->checkDominance()");
        try {
            bl = this.labelService.checkClearanceDominance(string2, true, string, this.userName);
        }
        catch (Exception exception) {
            throw new HostException("EXM_CLI_NETTMPL_DOM_CLEARCHK_ERROR");
        }
        if (!bl) {
            throw new HostException("EXM_CLI_NETTMPL_DOM_CLEARCHK_FAILED");
        }
    }

    public void checkDominance(String string, String string2, TemplateData templateData) throws Exception {
        boolean bl = true;
        this.trace("HostMgrTmplCli->checkDominance()");
        if (string == null && string2 == null) {
            return;
        }
        if (string == null && (string = templateData.getDefClearance()) == null) {
            throw new HostException("EXM_CLI_NETTMPL_ERR_DATA_ERROR_DEFCL");
        }
        if (string2 == null && (string2 = templateData.getDefLabel()) == null) {
            throw new HostException("EXM_CLI_NETTMPL_ERR_DATA_ERROR_DEFLABEL");
        }
        this.checkDominance(string, string2);
    }

    private void checkForAddOptions(String[] stringArray) throws Exception {
        TemplateData templateData = new TemplateData();
        String string = null;
        String string2 = null;
        String string3 = null;
        if (this.getDebugStatus()) {
            this.trace("checkForAddOptions-> args.length = " + stringArray.length);
            int n = 0;
            while (n < stringArray.length) {
                this.trace("args[" + n + "] = " + stringArray[n]);
                ++n;
            }
        }
        CommandParser commandParser = new CommandParser(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"smtmpladd_name"), ResourceStrings.getString((ResourceBundle)this.bundle, (String)"smtmpladd_desc"), true, null, null);
        this.coXArgs = new CommandLineOption("xArgs", ResourceStrings.getString((ResourceBundle)this.bundle, (String)"arg_XARGADDTMPL_desc"), "x", 1, false, true, (Object)"", true);
        try {
            int n;
            String[] stringArray2;
            commandParser.addOption((CommandOption)this.coTemplateName);
            commandParser.addOption((CommandOption)this.coHostType);
            commandParser.addOption((CommandOption)this.coXArgs);
            commandParser.addOption((CommandOption)this.coLabel);
            commandParser.addOption((CommandOption)this.coClearance);
            commandParser.addOption((CommandOption)this.coAddForcedPriv);
            commandParser.addOption((CommandOption)this.coAddAllowedPriv);
            commandParser.addOption((CommandOption)this.coIpLabel);
            commandParser.addOption((CommandOption)this.coTaskFile);
            commandParser.addOption((CommandOption)this.coHelp);
            if (commandParser.parseArgs(stringArray)) {
                if (this.coTemplateName.wasSet()) {
                    stringArray2 = (String[])this.coTemplateName.getValue();
                    this.trace("Templatename :  " + (String)stringArray2);
                    if (this.checkTemplateExists((String)stringArray2)) {
                        throw new HostException("EXM_CLI_NETTMPL_ALREADY_EXIST", (String)stringArray2);
                    }
                    templateData.setTemplateName((String)stringArray2);
                }
                if (this.coXArgs.wasSet()) {
                    this.vXArgs = this.coXArgs.getValues();
                }
                if (this.vXArgs == null) {
                    this.vXArgs = new Vector();
                }
                if (this.coHostType.wasSet()) {
                    stringArray2 = (String)this.coHostType.getValue();
                    this.trace("HostType :  " + (String)stringArray2);
                    n = 0;
                    int n2 = 0;
                    n2 = 0;
                    while (n2 < hostTypeList.length) {
                        if (stringArray2.equals(hostTypeList[n2])) {
                            n = 1;
                            break;
                        }
                        ++n2;
                    }
                    if (n == 0) {
                        throw new HostException("EXM_CLI_NETTMPL_INVALID_HOSTTYPE", (String)stringArray2);
                    }
                    templateData.setHostType((String)stringArray2);
                    switch (n2) {
                        case 0: {
                            this.trace("checkForAddOptions: HOSTTYPE_UNLABELED");
                            if (!this.coClearance.wasSet()) {
                                throw new HostException("EXM_CLI_NETTMPL_NEED_CLEARANCE");
                            }
                            string = (String)this.coClearance.getValue();
                            this.trace("Clearance : " + string);
                            string = this.checkClearance(string);
                            if (!this.coLabel.wasSet()) {
                                throw new HostException("EXM_CLI_NETTMPL_NEED_LABEL");
                            }
                            string2 = (String)this.coLabel.getValue();
                            this.trace("Label : " + string2);
                            string2 = this.checkCMWLabel(string2);
                            if (string2 != null && string != null) {
                                this.checkDominance(string, string2);
                            }
                            if (string != null) {
                                templateData.setDefClearance(string);
                            }
                            if (string2 != null) {
                                templateData.setDefLabel(string2);
                            }
                            if (!this.coAddForcedPriv.wasSet()) {
                                throw new HostException("EXM_CLI_NETTMPL_NEED_FORCEDPRIVS");
                            }
                            String string4 = (String)this.coAddForcedPriv.getValue();
                            String string5 = this.checkListPrivs(string4);
                            templateData.setForcedPrivs(string5);
                            if (!this.coIpLabel.wasSet()) {
                                throw new HostException("EXM_CLI_NETTMPL_NEED_IPLABEL");
                            }
                            string3 = (String)this.coIpLabel.getValue();
                            this.trace("IP_Label : " + string3);
                            this.checkIpLabel(string3);
                            templateData.setIPLabel(string3);
                            if (this.vXArgs.size() <= 0) {
                                throw new HostException("EXM_CLI_NETTMPL_NEED_XARG");
                            }
                            templateData = this.parseAddXOptions(this.vXArgs, templateData, string3, true);
                            if (!this.coAddAllowedPriv.wasSet()) break;
                            throw new HostException("EXM_CLI_NETTMPL_ERR_OPTION_A");
                        }
                        case 1: {
                            this.trace("checkForAddOptions: HOSTTYPE_SUN_TSOL");
                            if (!this.coAddAllowedPriv.wasSet()) {
                                throw new HostException("EXM_CLI_NETTMPL_NEED_ALLOWEDPRIVS");
                            }
                            String string4 = (String)this.coAddAllowedPriv.getValue();
                            String string5 = this.checkListPrivs(string4);
                            templateData.setAllowedPrivs(string5);
                            if (!this.coIpLabel.wasSet()) {
                                throw new HostException("EXM_CLI_NETTMPL_NEED_IPLABEL");
                            }
                            string3 = (String)this.coIpLabel.getValue();
                            this.trace("IP_Label : " + string3);
                            this.checkIpLabel(string3);
                            templateData.setIPLabel(string3);
                            if (this.coLabel.wasSet()) {
                                throw new HostException("EXM_CLI_NETTMPL_ERR_OPTION_L");
                            }
                            if (this.coClearance.wasSet()) {
                                throw new HostException("EXM_CLI_NETTMPL_ERR_OPTION_C");
                            }
                            if (this.coAddForcedPriv.wasSet()) {
                                throw new HostException("EXM_CLI_NETTMPL_ERR_OPTION_F");
                            }
                            if (this.vXArgs.size() > 0) {
                                templateData = this.parseAddXOptions(this.vXArgs, templateData, string3, true);
                                break;
                            }
                            throw new HostException("EXM_CLI_NETTMPL_NEED_XARG");
                        }
                        case 2: {
                            this.trace("checkForAddOptions: HOSTTYPE_RIPSO");
                            if (!this.coClearance.wasSet()) {
                                throw new HostException("EXM_CLI_NETTMPL_NEED_CLEARANCE");
                            }
                            string = (String)this.coClearance.getValue();
                            this.trace("Clearance : " + string);
                            string = this.checkClearance(string);
                            if (!this.coLabel.wasSet()) {
                                throw new HostException("EXM_CLI_NETTMPL_NEED_LABEL");
                            }
                            string2 = (String)this.coLabel.getValue();
                            this.trace("Label : " + string2);
                            string2 = this.checkCMWLabel(string2);
                            if (string2 != null && string != null) {
                                this.checkDominance(string, string2);
                            }
                            if (string != null) {
                                templateData.setDefClearance(string);
                            }
                            if (string2 != null) {
                                templateData.setDefLabel(string2);
                            }
                            if (!this.coAddForcedPriv.wasSet()) {
                                throw new HostException("EXM_CLI_NETTMPL_NEED_FORCEDPRIVS");
                            }
                            String string4 = (String)this.coAddForcedPriv.getValue();
                            String string5 = this.checkListPrivs(string4);
                            templateData.setForcedPrivs(string5);
                            if (this.coAddAllowedPriv.wasSet()) {
                                throw new HostException("EXM_CLI_NETTMPL_ERR_OPTION_A");
                            }
                            if (this.coIpLabel.wasSet()) {
                                throw new HostException("EXM_CLI_NETTMPL_ERR_OPTION_I");
                            }
                            if (this.vXArgs.size() > 0) {
                                templateData = this.parseAddXOptions(this.vXArgs, templateData, RIPSO_IPLABEL, true);
                                break;
                            }
                            throw new HostException("EXM_CLI_NETTMPL_NEED_XARG");
                        }
                        case 3: {
                            this.trace("checkForAddOptions: HOSTTYPE_CIPSO");
                            if (!this.coClearance.wasSet()) {
                                throw new HostException("EXM_CLI_NETTMPL_NEED_CLEARANCE");
                            }
                            string = (String)this.coClearance.getValue();
                            this.trace("Clearance : " + string);
                            string = this.checkClearance(string);
                            templateData.setDefClearance(string);
                            if (!this.coAddForcedPriv.wasSet()) {
                                throw new HostException("EXM_CLI_NETTMPL_NEED_FORCEDPRIVS");
                            }
                            String string4 = (String)this.coAddForcedPriv.getValue();
                            String string5 = this.checkListPrivs(string4);
                            templateData.setForcedPrivs(string5);
                            if (this.coLabel.wasSet()) {
                                throw new HostException("EXM_CLI_NETTMPL_ERR_OPTION_L");
                            }
                            if (this.coAddAllowedPriv.wasSet()) {
                                throw new HostException("EXM_CLI_NETTMPL_ERR_OPTION_A");
                            }
                            if (this.coIpLabel.wasSet()) {
                                throw new HostException("EXM_CLI_NETTMPL_ERR_OPTION_I");
                            }
                            if (this.vXArgs.size() > 0) {
                                templateData = this.parseAddXOptions(this.vXArgs, templateData, CIPSO_IPLABEL, false);
                                break;
                            }
                            throw new HostException("EXM_CLI_NETTMPL_NEED_XARG");
                        }
                        case 4: {
                            this.trace("checkForAddOptions: HOSTTYPE_TSIX");
                            if (!this.coClearance.wasSet()) {
                                throw new HostException("EXM_CLI_NETTMPL_NEED_CLEARANCE");
                            }
                            string = (String)this.coClearance.getValue();
                            this.trace("Clearance : " + string);
                            string = this.checkClearance(string);
                            if (!this.coLabel.wasSet()) {
                                throw new HostException("EXM_CLI_NETTMPL_NEED_LABEL");
                            }
                            string2 = (String)this.coLabel.getValue();
                            this.trace("Label : " + string2);
                            string2 = this.checkCMWLabel(string2);
                            if (string2 != null && string != null) {
                                this.checkDominance(string, string2);
                            }
                            if (string != null) {
                                templateData.setDefClearance(string);
                            }
                            if (string2 != null) {
                                templateData.setDefLabel(string2);
                            }
                            if (!this.coAddForcedPriv.wasSet()) {
                                throw new HostException("EXM_CLI_NETTMPL_NEED_FORCEDPRIVS");
                            }
                            String string4 = (String)this.coAddForcedPriv.getValue();
                            String string5 = this.checkListPrivs(string4);
                            templateData.setForcedPrivs(string5);
                            if (!this.coAddAllowedPriv.wasSet()) {
                                throw new HostException("EXM_CLI_NETTMPL_NEED_ALLOWEDPRIVS");
                            }
                            string4 = (String)this.coAddAllowedPriv.getValue();
                            string5 = this.checkListPrivs(string4);
                            templateData.setAllowedPrivs(string5);
                            if (!this.coIpLabel.wasSet()) {
                                throw new HostException("EXM_CLI_NETTMPL_NEED_IPLABEL");
                            }
                            string3 = (String)this.coIpLabel.getValue();
                            this.trace("IP_Label : " + string3);
                            this.checkIpLabel(string3);
                            templateData.setIPLabel(string3);
                            if (this.vXArgs.size() > 0) {
                                templateData = this.parseAddXOptions(this.vXArgs, templateData, string3, true);
                                break;
                            }
                            throw new HostException("EXM_CLI_NETTMPL_NEED_XARG");
                        }
                        default: {
                            this.trace("should never be here:  xxxx");
                            this.trace("couldn't recognize switch:  " + n2);
                            break;
                        }
                    }
                }
                if (this.coTaskFile.wasSet()) {
                    stringArray2 = (String)this.coTaskFile.getValue();
                    this.trace("Task = " + (String)stringArray2);
                    this.setTaskOperation(stringArray2.charAt(0));
                }
                if (this.coHelp.wasSet()) {
                    this.trace("read in help");
                    commandParser.printUsage(null);
                    throw new HostMgrCliHelpException(null);
                }
            } else {
                this.trace("Error parsing args");
                throw new Exception("parseArgs failed.");
            }
            stringArray2 = commandParser.getUnmatchedOptions();
            if (stringArray2.length >= 1) {
                n = 0;
                while (n < stringArray2.length) {
                    this.trace("unrecognized option:  " + stringArray2[n]);
                    ++n;
                }
                commandParser.printUsage(null);
                throw new HostMgrCliArgParsingException("EXM_CLI_INVALID_ARG", stringArray2[0]);
            }
            this.vObjs.addElement(templateData);
        }
        catch (HostMgrCliHelpException hostMgrCliHelpException) {
            throw hostMgrCliHelpException;
        }
        catch (HostMgrCliArgParsingException hostMgrCliArgParsingException) {
            throw hostMgrCliArgParsingException;
        }
        catch (HostException hostException) {
            throw hostException;
        }
        catch (Throwable throwable) {
            this.trace("Throwable type-of-exception");
            if (this.getDebugStatus()) {
                throwable.printStackTrace();
            }
            throw new HostMgrCliArgParsingException("EXM_CLI_GENERIC_ERROR");
        }
    }

    private void checkForDeleteOptions(String[] stringArray) throws Exception {
        TemplateData templateData = new TemplateData();
        if (this.getDebugStatus()) {
            this.trace("checkForDeleteOptions-> args.length = " + stringArray.length);
            int n = 0;
            while (n < stringArray.length) {
                this.trace("args[" + n + "] = " + stringArray[n]);
                ++n;
            }
        }
        CommandParser commandParser = new CommandParser(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"smptmpldel_name"), ResourceStrings.getString((ResourceBundle)this.bundle, (String)"smtmpldel_desc"), true, null, null);
        try {
            String[] stringArray2;
            commandParser.addOption((CommandOption)this.coTemplateName);
            commandParser.addOption((CommandOption)this.coTaskFile);
            commandParser.addOption((CommandOption)this.coHelp);
            if (commandParser.parseArgs(stringArray)) {
                if (this.coTemplateName.wasSet()) {
                    stringArray2 = (String[])this.coTemplateName.getValue();
                    this.trace("Templatename :  " + (String)stringArray2);
                    if (!this.checkTemplateExists((String)stringArray2)) {
                        throw new HostException("EXM_CLI_NETTMPL_NOT_EXIST", (String)stringArray2);
                    }
                    templateData.setTemplateName((String)stringArray2);
                }
                if (this.coTaskFile.wasSet()) {
                    stringArray2 = (String)this.coTaskFile.getValue();
                    this.trace("Task = " + (String)stringArray2);
                    this.setTaskOperation(stringArray2.charAt(0));
                }
                if (this.coHelp.wasSet()) {
                    this.trace("read in help");
                    commandParser.printUsage(null);
                    throw new HostMgrCliHelpException(null);
                }
            } else {
                this.trace("Error parsing args");
                throw new Exception("parseArgs failed.");
            }
            stringArray2 = commandParser.getUnmatchedOptions();
            if (stringArray2.length >= 1) {
                int n = 0;
                while (n < stringArray2.length) {
                    this.trace("unrecognized option:  " + stringArray2[n]);
                    ++n;
                }
                commandParser.printUsage(null);
                throw new HostMgrCliArgParsingException("EXM_CLI_INVALID_ARG", stringArray2[0]);
            }
            this.vObjs.addElement(templateData);
        }
        catch (HostMgrCliHelpException hostMgrCliHelpException) {
            throw hostMgrCliHelpException;
        }
        catch (HostMgrCliArgParsingException hostMgrCliArgParsingException) {
            throw hostMgrCliArgParsingException;
        }
        catch (HostException hostException) {
            throw hostException;
        }
        catch (Throwable throwable) {
            this.trace("Throwable type-of-exception");
            if (this.getDebugStatus()) {
                throwable.printStackTrace();
            }
            throw new HostMgrCliArgParsingException("EXM_CLI_GENERIC_ERROR");
        }
    }

    private void checkForModifyOptions(String[] stringArray) throws Exception {
        TemplateData templateData = new TemplateData();
        TemplateData templateData2 = new TemplateData();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        boolean bl = false;
        if (this.getDebugStatus()) {
            this.trace("checkForModifyOptions-> args.length = " + stringArray.length);
            int n = 0;
            while (n < stringArray.length) {
                this.trace("args[" + n + "] = " + stringArray[n]);
                ++n;
            }
        }
        this.coHostType = new CommandLineOption("hosttype", ResourceStrings.getString((ResourceBundle)this.bundle, (String)"arg_hosttype_desc"), "t", 1, true, false, null, true);
        this.coXArgs = new CommandLineOption("xArgs", ResourceStrings.getString((ResourceBundle)this.bundle, (String)"arg_XARGADDTMPL_desc"), "x", 1, true, true, (Object)"", true);
        CommandParser commandParser = new CommandParser(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"smtmplmod_name"), ResourceStrings.getString((ResourceBundle)this.bundle, (String)"smtmplmod_desc"), true, null, null);
        try {
            int n;
            String[] stringArray2;
            commandParser.addOption((CommandOption)this.coTemplateName);
            commandParser.addOption((CommandOption)this.coHostType);
            commandParser.addOption((CommandOption)this.coXArgs);
            commandParser.addOption((CommandOption)this.coLabel);
            commandParser.addOption((CommandOption)this.coClearance);
            commandParser.addOption((CommandOption)this.coAddForcedPriv);
            commandParser.addOption((CommandOption)this.coAddAllowedPriv);
            commandParser.addOption((CommandOption)this.coIpLabel);
            commandParser.addOption((CommandOption)this.coTaskFile);
            commandParser.addOption((CommandOption)this.coHelp);
            if (commandParser.parseArgs(stringArray)) {
                if (this.coTemplateName.wasSet()) {
                    string = (String)this.coTemplateName.getValue();
                    this.trace("Templatename :  " + string);
                    if (!this.checkTemplateExists(string)) {
                        throw new HostException("EXM_CLI_NETTMPL_NOT_EXIST", string);
                    }
                    templateData = this.getObjectProps(string);
                    templateData2 = (TemplateData)templateData.clone();
                    this.trace("modObj = " + templateData2.getAttributeString());
                }
                if (this.coXArgs.wasSet()) {
                    this.vXArgs = this.coXArgs.getValues();
                }
                if (this.vXArgs == null) {
                    this.vXArgs = new Vector();
                }
                stringArray2 = null;
                if (this.coHostType.wasSet()) {
                    bl = true;
                    stringArray2 = (String)this.coHostType.getValue();
                    this.trace("HostType :  " + (String)stringArray2);
                    templateData2 = new TemplateData(string);
                    templateData2.setHostType((String)stringArray2);
                } else {
                    stringArray2 = templateData2.getHostType();
                    if (stringArray2 == null) {
                        throw new HostException("EXM_CLI_NETTMPL_ERR_DATA_ERROR_HOSTTYPE");
                    }
                    this.trace("HostType in tnrhtp database: " + (String)stringArray2);
                }
                n = 0;
                int n2 = 0;
                n2 = 0;
                while (n2 < hostTypeList.length) {
                    if (stringArray2.equals(hostTypeList[n2])) {
                        n = 1;
                        break;
                    }
                    ++n2;
                }
                if (n == 0) {
                    throw new HostException("EXM_CLI_NETTMPL_INVALID_HOSTTYPE", (String)stringArray2);
                }
                switch (n2) {
                    case 0: {
                        String string5;
                        this.trace("checkForModifyOptions: HOSTTYPE_UNLABELED");
                        if (this.coClearance.wasSet()) {
                            string2 = (String)this.coClearance.getValue();
                            this.trace("Clearance : " + string2);
                            string2 = this.checkClearance(string2);
                        } else if (bl) {
                            throw new HostException("EXM_CLI_NETTMPL_NEED_CLEARANCE");
                        }
                        if (this.coLabel.wasSet()) {
                            string3 = (String)this.coLabel.getValue();
                            this.trace("Label : " + string3);
                            string3 = this.checkCMWLabel(string3);
                        } else if (bl) {
                            throw new HostException("EXM_CLI_NETTMPL_NEED_LABEL");
                        }
                        this.checkDominance(string2, string3, templateData);
                        if (string2 != null) {
                            templateData2.setDefClearance(string2);
                        }
                        if (string3 != null) {
                            templateData2.setDefLabel(string3);
                        }
                        if (this.coAddForcedPriv.wasSet()) {
                            String string6 = (String)this.coAddForcedPriv.getValue();
                            string5 = this.checkListPrivs(string6);
                            templateData2.setForcedPrivs(string5);
                        } else if (bl) {
                            throw new HostException("EXM_CLI_NETTMPL_NEED_FORCEDPRIVS");
                        }
                        if (this.coIpLabel.wasSet()) {
                            string4 = (String)this.coIpLabel.getValue();
                            this.trace("IP_Label : " + string4);
                            this.checkIpLabel(string4);
                            templateData2.setIPLabel(string4);
                        } else if (bl) {
                            throw new HostException("EXM_CLI_NETTMPL_NEED_IPLABEL");
                        }
                        if (bl) {
                            if (this.vXArgs.size() > 0) {
                                templateData2 = this.parseAddXOptions(this.vXArgs, templateData2, string4, true);
                                break;
                            }
                            throw new HostException("EXM_CLI_NETTMPL_NEED_XARG");
                        }
                        boolean bl2 = false;
                        string5 = templateData.getIPLabel();
                        if (string5 == null) {
                            throw new HostException("EXM_CLI_NETTMPL_ERR_DATA_ERROR_IPLABEL");
                        }
                        if (string4 == null) {
                            string4 = string5;
                        } else if (!string4.equals(string5)) {
                            bl2 = true;
                        }
                        if (this.vXArgs.size() <= 0 && !bl2) break;
                        templateData2 = this.parseModXOptions(this.vXArgs, templateData, templateData2, string5, string4, true);
                        break;
                    }
                    case 1: {
                        String string5;
                        this.trace("checkForModifyOptions: HOSTTYPE_SUN_TSOL");
                        if (this.coAddAllowedPriv.wasSet()) {
                            String string7 = (String)this.coAddAllowedPriv.getValue();
                            string5 = this.checkListPrivs(string7);
                            templateData2.setAllowedPrivs(string5);
                        } else if (bl) {
                            throw new HostException("EXM_CLI_NETTMPL_NEED_ALLOWEDPRIVS");
                        }
                        if (this.coIpLabel.wasSet()) {
                            string4 = (String)this.coIpLabel.getValue();
                            this.trace("IP_Label : " + string4);
                            this.checkIpLabel(string4);
                            templateData2.setIPLabel(string4);
                        } else if (bl) {
                            throw new HostException("EXM_CLI_NETTMPL_NEED_IPLABEL");
                        }
                        if (bl) {
                            if (this.vXArgs.size() > 0) {
                                templateData2 = this.parseAddXOptions(this.vXArgs, templateData2, string4, true);
                                break;
                            }
                            throw new HostException("EXM_CLI_NETTMPL_NEED_XARG");
                        }
                        boolean bl3 = false;
                        string5 = templateData.getIPLabel();
                        if (string5 == null) {
                            throw new HostException("EXM_CLI_NETTMPL_ERR_DATA_ERROR_IPLABEL");
                        }
                        if (string4 == null) {
                            string4 = string5;
                        } else if (!string4.equals(string5)) {
                            bl3 = true;
                        }
                        if (this.vXArgs.size() <= 0 && !bl3) break;
                        templateData2 = this.parseModXOptions(this.vXArgs, templateData, templateData2, string5, string4, true);
                        break;
                    }
                    case 2: {
                        String string5;
                        this.trace("checkForModifyOptions: HOSTTYPE_RIPSO");
                        if (this.coClearance.wasSet()) {
                            string2 = (String)this.coClearance.getValue();
                            this.trace("Clearance : " + string2);
                            string2 = this.checkClearance(string2);
                        } else if (bl) {
                            throw new HostException("EXM_CLI_NETTMPL_NEED_CLEARANCE");
                        }
                        if (this.coLabel.wasSet()) {
                            string3 = (String)this.coLabel.getValue();
                            this.trace("Label : " + string3);
                            string3 = this.checkCMWLabel(string3);
                        } else if (bl) {
                            throw new HostException("EXM_CLI_NETTMPL_NEED_LABEL");
                        }
                        this.checkDominance(string2, string3, templateData);
                        if (string2 != null) {
                            templateData2.setDefClearance(string2);
                        }
                        if (string3 != null) {
                            templateData2.setDefLabel(string3);
                        }
                        if (this.coAddForcedPriv.wasSet()) {
                            String string8 = (String)this.coAddForcedPriv.getValue();
                            string5 = this.checkListPrivs(string8);
                            templateData2.setForcedPrivs(string5);
                        } else if (bl) {
                            throw new HostException("EXM_CLI_NETTMPL_NEED_FORCEDPRIVS");
                        }
                        if (bl) {
                            if (this.vXArgs.size() > 0) {
                                templateData2 = this.parseAddXOptions(this.vXArgs, templateData2, string4, true);
                                break;
                            }
                            throw new HostException("EXM_CLI_NETTMPL_NEED_XARG");
                        }
                        if (this.vXArgs.size() <= 0) break;
                        templateData2 = this.parseModXOptions(this.vXArgs, templateData, templateData2, RIPSO_IPLABEL, RIPSO_IPLABEL, true);
                        break;
                    }
                    case 3: {
                        String string5;
                        this.trace("checkForModifyOptions: HOSTTYPE_CIPSO");
                        if (this.coClearance.wasSet()) {
                            string2 = (String)this.coClearance.getValue();
                            this.trace("Clearance : " + string2);
                            string2 = this.checkClearance(string2);
                            templateData2.setDefClearance(string2);
                        } else if (bl) {
                            throw new HostException("EXM_CLI_NETTMPL_NEED_CLEARANCE");
                        }
                        if (this.coAddForcedPriv.wasSet()) {
                            String string9 = (String)this.coAddForcedPriv.getValue();
                            string5 = this.checkListPrivs(string9);
                            templateData2.setForcedPrivs(string5);
                        } else if (bl) {
                            throw new HostException("EXM_CLI_NETTMPL_NEED_FORCEDPRIVS");
                        }
                        if (bl) {
                            if (this.vXArgs.size() > 0) {
                                templateData2 = this.parseAddXOptions(this.vXArgs, templateData2, string4, false);
                                break;
                            }
                            throw new HostException("EXM_CLI_NETTMPL_NEED_XARG");
                        }
                        if (this.vXArgs.size() <= 0) break;
                        templateData2 = this.parseModXOptions(this.vXArgs, templateData, templateData2, CIPSO_IPLABEL, CIPSO_IPLABEL, false);
                        break;
                    }
                    case 4: {
                        String string10;
                        String string5;
                        this.trace("checkForModifyOptions: HOSTTYPE_TSIX");
                        if (this.coClearance.wasSet()) {
                            string2 = (String)this.coClearance.getValue();
                            this.trace("Clearance : " + string2);
                            string2 = this.checkClearance(string2);
                        } else if (bl) {
                            throw new HostException("EXM_CLI_NETTMPL_NEED_CLEARANCE");
                        }
                        if (this.coLabel.wasSet()) {
                            string3 = (String)this.coLabel.getValue();
                            this.trace("Label : " + string3);
                            string3 = this.checkCMWLabel(string3);
                        } else if (bl) {
                            throw new HostException("EXM_CLI_NETTMPL_NEED_LABEL");
                        }
                        this.checkDominance(string2, string3, templateData);
                        if (string2 != null) {
                            templateData2.setDefClearance(string2);
                        }
                        if (string3 != null) {
                            templateData2.setDefLabel(string3);
                        }
                        if (this.coAddForcedPriv.wasSet()) {
                            string10 = (String)this.coAddForcedPriv.getValue();
                            string5 = this.checkListPrivs(string10);
                            templateData2.setForcedPrivs(string5);
                        } else if (bl) {
                            throw new HostException("EXM_CLI_NETTMPL_NEED_FORCEDPRIVS");
                        }
                        if (this.coAddAllowedPriv.wasSet()) {
                            string10 = (String)this.coAddAllowedPriv.getValue();
                            string5 = this.checkListPrivs(string10);
                            templateData2.setAllowedPrivs(string5);
                        } else if (bl) {
                            throw new HostException("EXM_CLI_NETTMPL_NEED_ALLOWEDPRIVS");
                        }
                        if (this.coIpLabel.wasSet()) {
                            string4 = (String)this.coIpLabel.getValue();
                            this.trace("IP_Label : " + string4);
                            this.checkIpLabel(string4);
                            templateData2.setIPLabel(string4);
                        } else if (bl) {
                            throw new HostException("EXM_CLI_NETTMPL_NEED_IPLABEL");
                        }
                        if (bl) {
                            if (this.vXArgs.size() > 0) {
                                templateData2 = this.parseAddXOptions(this.vXArgs, templateData2, string4, true);
                                break;
                            }
                            throw new HostException("EXM_CLI_NETTMPL_NEED_XARG");
                        }
                        boolean bl4 = false;
                        string5 = templateData.getIPLabel();
                        if (string5 == null) {
                            throw new HostException("EXM_CLI_NETTMPL_ERR_DATA_ERROR_IPLABEL");
                        }
                        if (string4 == null) {
                            string4 = string5;
                        } else if (!string4.equals(string5)) {
                            bl4 = true;
                        }
                        if (this.vXArgs.size() <= 0 && !bl4) break;
                        templateData2 = this.parseModXOptions(this.vXArgs, templateData, templateData2, string5, string4, true);
                        break;
                    }
                    default: {
                        this.trace("should never be here:  xxxx");
                        this.trace("couldn't recognize switch:  " + n2);
                    }
                }
                if (this.coTaskFile.wasSet()) {
                    String string11 = (String)this.coTaskFile.getValue();
                    this.trace("Task = " + string11);
                    this.setTaskOperation(string11.charAt(0));
                }
                if (this.coHelp.wasSet()) {
                    this.trace("read in help");
                    commandParser.printUsage(null);
                    throw new HostMgrCliHelpException(null);
                }
            } else {
                this.trace("Error parsing args");
                throw new Exception("parseArgs failed.");
            }
            stringArray2 = commandParser.getUnmatchedOptions();
            if (stringArray2.length >= 1) {
                n = 0;
                while (n < stringArray2.length) {
                    this.trace("unrecognized option:  " + stringArray2[n]);
                    ++n;
                }
                commandParser.printUsage(null);
                throw new HostMgrCliArgParsingException("EXM_CLI_INVALID_ARG", stringArray2[0]);
            }
        }
        catch (HostMgrCliHelpException hostMgrCliHelpException) {
            throw hostMgrCliHelpException;
        }
        catch (HostMgrCliArgParsingException hostMgrCliArgParsingException) {
            throw hostMgrCliArgParsingException;
        }
        catch (HostException hostException) {
            throw hostException;
        }
        catch (Throwable throwable) {
            this.trace("Throwable type-of-exception");
            if (this.getDebugStatus()) {
                throwable.printStackTrace();
            }
            throw new HostMgrCliArgParsingException("EXM_CLI_GENERIC_ERROR");
        }
        this.vObjs.addElement(templateData2);
    }

    private void checkForViewOptions(String[] stringArray) throws Exception {
        TemplateData templateData = new TemplateData();
        if (this.getDebugStatus()) {
            this.trace("checkForViewOptions-> args.length = " + stringArray.length);
            int n = 0;
            while (n < stringArray.length) {
                this.trace("args[" + n + "] = " + stringArray[n]);
                ++n;
            }
        }
        this.coTemplateName = new CommandLineOption("name", ResourceStrings.getString((ResourceBundle)this.bundle, (String)"arg_templatename_desc"), "n", 1, true, true, null, true);
        CommandParser commandParser = new CommandParser(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"smtmplls_name"), ResourceStrings.getString((ResourceBundle)this.bundle, (String)"smtmplls_desc"), true, null, null);
        try {
            String[] stringArray2;
            commandParser.addOption((CommandOption)this.coTemplateName);
            commandParser.addOption((CommandOption)this.coTaskFile);
            commandParser.addOption((CommandOption)this.coHelp);
            if (commandParser.parseArgs(stringArray)) {
                if (this.coTaskFile.wasSet()) {
                    stringArray2 = (String[])this.coTaskFile.getValue();
                    this.trace("Task = " + (String)stringArray2);
                    this.setTaskOperation(stringArray2.charAt(0));
                }
                if (this.coHelp.wasSet()) {
                    this.trace("read in help");
                    commandParser.printUsage(null);
                    throw new HostMgrCliHelpException(null);
                }
            } else {
                this.trace("Error parsing args");
                throw new Exception("parseArgs failed.");
            }
            stringArray2 = commandParser.getUnmatchedOptions();
            if (stringArray2.length >= 1) {
                int n = 0;
                while (n < stringArray2.length) {
                    this.trace("unrecognized option:  " + stringArray2[n]);
                    ++n;
                }
                commandParser.printUsage(null);
                throw new HostMgrCliArgParsingException("EXM_CLI_INVALID_ARG", stringArray2[0]);
            }
        }
        catch (HostMgrCliHelpException hostMgrCliHelpException) {
            throw hostMgrCliHelpException;
        }
        catch (HostMgrCliArgParsingException hostMgrCliArgParsingException) {
            throw hostMgrCliArgParsingException;
        }
        catch (HostException hostException) {
            throw hostException;
        }
        catch (Throwable throwable) {
            this.trace("Throwable type-of-exception");
            if (this.getDebugStatus()) {
                throwable.printStackTrace();
            }
            throw new HostMgrCliArgParsingException("EXM_CLI_GENERIC_ERROR");
        }
    }

    public void checkIpLabel(String string) throws HostException {
        Object var2_2 = null;
        boolean bl = false;
        this.trace("HostMgrTmplCli->checkIpLabel()");
        int n = 0;
        while (n < ipLabelList.length) {
            if (string.equals(ipLabelList[n])) {
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            throw new HostException("EXM_CLI_NETTMPL_INVALID_IPLABEL", string);
        }
        this.trace("Leaving HostMgrTmplCli->checkIpLabel()");
    }

    public String checkLabel(String string) throws HostException {
        String string2 = null;
        this.trace("HostMgrTmplCli->checkLabel()");
        try {
            if (string.startsWith("0x")) {
                string2 = this.labelService.hexLabelToString(string, this.userName);
                return string;
            }
            string2 = this.labelService.stringLabelToHex(string, this.userName);
            return string2;
        }
        catch (BadLabelException badLabelException) {
            int n = badLabelException.getErrorCode();
            throw new HostException("EXM_CLI_NETTMPL_BAD_LABEL_ERROR", string, Integer.toString(n));
        }
        catch (Exception exception) {
            throw new HostException("EXM_CLI_NETTMPL_LABEL_ERROR");
        }
    }

    public void checkLabelsDominance(String string, String string2) throws HostException {
        boolean bl = true;
        try {
            bl = this.labelService.checkLabelDominance(string, string2, this.userName);
        }
        catch (Exception exception) {
            throw new HostException("EXM_CLI_NETTMPL_DOM_LABCHK_ERROR");
        }
        if (!bl) {
            throw new HostException("EXM_CLI_NETTMPL_DOM_LABCHK_FAILED");
        }
    }

    public String checkListPrivs(String string) throws Exception {
        this.trace("HostMgrTmplCli->checkListPrivs()");
        if (string == null) {
            throw new HostException("EXM_CLI_NETTMPL_ERR_BAD_PRIV", string);
        }
        if (string.equals(PRIV_ALL) || string.equals("empty") || string.equals(PRIV_NONE)) {
            return string;
        }
        String string2 = null;
        try {
            string2 = this.labelService.privNumListToPrivStringList(string);
            if (string2 == null) {
                throw new HostException("EXM_CLI_NETTMPL_ERR_BAD_PRIV", string);
            }
        }
        catch (Exception exception) {
            throw new HostException("EXM_CLI_NETTMPL_ERR_BAD_PRIV", string);
        }
        return string2;
    }

    private boolean checkTemplateExists(String string) {
        this.trace("HostMgrTmplCli->checkTemplateExists()");
        Vector vector = this.getListTemplates();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            TemplateData templateData = (TemplateData)enumeration.nextElement();
            String string2 = templateData.getTemplateName();
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public void deleteObject() throws Exception {
        this.trace("in HostMgrTmplCli->deleteObject()");
        try {
            this.trace("vObjs.size() = " + this.vObjs.size());
            TemplateData templateData = (TemplateData)this.vObjs.elementAt(0);
            if (this.getHostMgr() == null) {
                this.trace("hostmgr is null!");
                throw new HostException("EXM_CLI_NO_SERVICE");
            }
            this.getHostMgr().deleteTnrhtp(templateData);
        }
        catch (Exception exception) {
            this.trace("exception in deleteObject(): " + exception.getMessage());
            if (this.getDebugStatus()) {
                exception.printStackTrace();
            }
            throw exception;
        }
    }

    private void doFirstArgPass(String[] stringArray) throws Exception {
        block6: {
            TemplateData templateData = new TemplateData();
            CommandParser commandParser = new CommandParser("HostMgrTmplCli", "main tool for users related cli's", true, null, null);
            try {
                commandParser.addOption((CommandOption)this.coTaskFile);
                commandParser.addOption((CommandOption)this.coHelp);
                if (commandParser.parseArgs(stringArray)) {
                    if (this.coTaskFile.wasSet()) {
                        String string = (String)this.coTaskFile.getValue();
                        this.trace("Task = " + string);
                        this.setTaskOperation(string.charAt(0));
                    }
                } else {
                    this.trace("Error parsing args");
                    throw new HostMgrCliArgParsingException("EXM_CLI_MISSING_ARG");
                }
                this.coHelp.wasSet();
                if (this.getOperation() == -1) {
                    this.trace("Error:  iOperation == -1");
                    throw new HostException("EXM_CLI_NO_TASK");
                }
            }
            catch (Throwable throwable) {
                this.trace("Throwable type-of-exception");
                if (!this.getDebugStatus()) break block6;
                throwable.printStackTrace();
            }
        }
    }

    private Vector getListTemplates() {
        Vector vector = null;
        try {
            vector = this.getHostMgr().listTemplates();
        }
        catch (Exception exception) {}
        return vector;
    }

    private TemplateData getObjectProps(String string) throws Exception {
        TemplateData templateData = null;
        this.trace("HostMgrTmplCli->getObjectProps()");
        Vector vector = this.getListTemplates();
        Enumeration enumeration = vector.elements();
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            templateData = (TemplateData)enumeration.nextElement();
            String string2 = templateData.getTemplateName();
            if (!string2.equals(string)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            throw new HostException("EXM_CLI_NETTMPL_NOT_EXIST");
        }
        return templateData;
    }

    private void initCommandLineOptions() {
        this.coTaskFile = new CommandLineOption("task", ResourceStrings.getString((ResourceBundle)this.bundle, (String)"arg_task_desc"), "K", 1, false, false, (Object)"V", true, true);
        this.coTemplateName = new CommandLineOption("name", ResourceStrings.getString((ResourceBundle)this.bundle, (String)"arg_templatename_desc"), "n", 1, false, false, null, true);
        this.coHostType = new CommandLineOption("hosttype", ResourceStrings.getString((ResourceBundle)this.bundle, (String)"arg_hosttype_desc"), "t", 1, false, false, null, true);
        this.coLabel = new CommandLineOption("label", ResourceStrings.getString((ResourceBundle)this.bundle, (String)"arg_label_desc"), "l", 1, true, false, null, true);
        this.coClearance = new CommandLineOption("clearance", ResourceStrings.getString((ResourceBundle)this.bundle, (String)"arg_clearance_desc"), "c", 1, true, false, null, true);
        this.coAddForcedPriv = new CommandLineOption("addforcedprivs", ResourceStrings.getString((ResourceBundle)this.bundle, (String)"arg_addforcedprivs_desc"), "f", 1, true, false, null, true);
        this.coAddAllowedPriv = new CommandLineOption("addallowedprivs", ResourceStrings.getString((ResourceBundle)this.bundle, (String)"arg_addallowedprivs_desc"), "a", 1, true, false, null, true);
        this.coIpLabel = new CommandLineOption("iplabeltype", ResourceStrings.getString((ResourceBundle)this.bundle, (String)"arg_iplabeltype_desc"), "i", 1, true, false, null, true);
        this.coHelp = new CommandLineOption("help", ResourceStrings.getString((ResourceBundle)this.bundle, (String)"arg_help_desc"), "h", 0, true, false, (Object)"", false);
        this.coHelp.setPriority(true);
    }

    public void modifyObject() throws Exception {
        this.trace("in HostMgrTmplCli->modifyObject()");
        try {
            TemplateData templateData = (TemplateData)this.vObjs.elementAt(0);
            this.trace("template is:  " + templateData.getTemplateName());
            if (this.getHostMgr() == null) {
                this.trace("in modifyObject:  hostmgr is null!");
                throw new HostException("EXM_CLI_NO_SERVICE");
            }
            this.trace("newObj = " + templateData.getAttributeString());
            TemplateData templateData2 = this.getObjectProps(templateData.getTemplateName());
            this.getHostMgr().modTemplate(templateData2, templateData);
        }
        catch (Exception exception) {
            this.trace("exception in modifyObject(): " + exception.getMessage());
            if (this.getDebugStatus()) {
                exception.printStackTrace();
            }
            throw exception;
        }
    }

    public TemplateData parseAddXOptions(Vector vector, TemplateData templateData, String string, boolean bl) throws HostException {
        int n = 0;
        String string2 = "";
        String string3 = "";
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        boolean bl2 = false;
        this.trace("HostMgrTmplCli->parseAddXOptions()");
        if (templateData == null) {
            templateData = new TemplateData();
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            string2 = string2.trim();
            n = string2.indexOf("=");
            string3 = string2.substring(n + 1, string2.length());
            string3 = string3.trim();
            string2 = string2.substring(0, n);
            this.trace("Parsed out x property:  " + string2);
            this.trace("Parsed out x property value:  " + string3);
            if (string2.compareTo(ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"xprop_min_sl")) == 0) {
                templateData = this.setXOptionMinSl(string3, templateData);
                string7 = string3;
                continue;
            }
            if (string2.compareTo(ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"xprop_max_sl")) == 0) {
                templateData = this.setXOptionMaxSl(string3, templateData);
                string8 = string3;
                continue;
            }
            if (string2.compareTo(ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"xprop_ripso_label_SC")) == 0) {
                string4 = string3;
                continue;
            }
            if (string2.compareTo(ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"xprop_ripso_label_SPAF")) == 0) {
                string5 = string3;
                continue;
            }
            if (string2.compareTo(ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"xprop_ripso_label_RPAF")) == 0) {
                string6 = string3;
                continue;
            }
            if (string2.compareTo(ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"xprop_cDom")) == 0) {
                templateData = this.setXOptionDOI(string3, templateData, string);
                bl2 = true;
                continue;
            }
            this.logit("unrecognized: x property value:\t" + string3);
            this.logit("unrecognized: x property:  " + string2);
            throw new HostException("EXM_CLI_UNKNOWN_X_ARG");
        }
        if (string7 == null || string8 == null) {
            if (string7 == null) {
                throw new HostException("EXM_CLI_NETTMPL_NEED_XARG_MIN_LABEL");
            }
            throw new HostException("EXM_CLI_NETTMPL_NEED_XARG_MAX_LABEL");
        }
        this.checkLabelsDominance(string7, string8);
        if (!bl2) {
            throw new HostException("EXM_CLI_NETTMPL_NEED_DOI");
        }
        if (!bl) {
            if (string4 != null || string5 != null || string6 != null) {
                throw new HostException("EXM_CLI_NETTMPL_ERR_RIPSO_NOT_ALLOWED");
            }
        } else {
            templateData = this.setXOptionRipso(string4, string5, string6, templateData, string);
        }
        return templateData;
    }

    private void parseAndValidateArgs(String[] stringArray) throws Exception {
        switch (this.getOperation()) {
            case 0: {
                this.checkForAddOptions(stringArray);
                break;
            }
            case 1: {
                this.checkForDeleteOptions(stringArray);
                break;
            }
            case 2: {
                this.checkForModifyOptions(stringArray);
                break;
            }
            case 3: {
                this.checkForViewOptions(stringArray);
                break;
            }
            default: {
                this.trace("should never be here:  xxxx");
                this.trace("couldn't recognize switch:  " + this.getOperation());
                break;
            }
        }
    }

    public TemplateData parseModXOptions(Vector vector, TemplateData templateData, TemplateData templateData2, String string, String string2, boolean bl) throws HostException {
        Object object;
        String string3;
        int n = 0;
        String string4 = "";
        String string5 = "";
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        String string11 = null;
        this.trace("HostMgrTmplCli->parseModXOptions()");
        if (templateData2 == null) {
            templateData2 = new TemplateData();
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            string4 = (String)enumeration.nextElement();
            string4 = string4.trim();
            n = string4.indexOf("=");
            string5 = string4.substring(n + 1, string4.length());
            string5 = string5.trim();
            string4 = string4.substring(0, n);
            this.trace("Parsed out x property:  " + string4);
            this.trace("Parsed out x property value:  " + string5);
            if (string4.compareTo(ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"xprop_min_sl")) == 0) {
                templateData2 = this.setXOptionMinSl(string5, templateData2);
                string9 = string5;
                continue;
            }
            if (string4.compareTo(ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"xprop_max_sl")) == 0) {
                templateData2 = this.setXOptionMaxSl(string5, templateData2);
                string10 = string5;
                continue;
            }
            if (string4.compareTo(ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"xprop_ripso_label_SC")) == 0) {
                string6 = string5;
                continue;
            }
            if (string4.compareTo(ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"xprop_ripso_label_SPAF")) == 0) {
                string7 = string5;
                continue;
            }
            if (string4.compareTo(ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"xprop_ripso_label_RPAF")) == 0) {
                string8 = string5;
                continue;
            }
            if (string4.compareTo(ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"xprop_cDom")) == 0) {
                string11 = string5;
                continue;
            }
            this.logit("unrecognized: x property value:\t" + string5);
            this.logit("unrecognized: x property:  " + string4);
            throw new HostException("EXM_CLI_UNKNOWN_X_ARG");
        }
        if (string9 != null || string10 != null) {
            string3 = null;
            object = null;
            if (string9 == null) {
                string3 = templateData.getMinSL();
                if (string3 == null) {
                    throw new HostException("EXM_CLI_NETTMPL_ERR_DATA_ERROR_MINSL");
                }
            } else {
                string3 = string9;
            }
            if (string10 == null) {
                object = templateData.getMaxSL();
                if (object == null) {
                    throw new HostException("EXM_CLI_NETTMPL_ERR_DATA_ERROR_MAXSL");
                }
            } else {
                object = string10;
            }
            this.checkLabelsDominance(string3, (String)object);
        }
        if (string11 != null) {
            templateData2 = this.setXOptionDOI(string11, templateData2, string2);
        } else if (string2.equals(CIPSO_IPLABEL) && !string.equals(CIPSO_IPLABEL)) {
            string3 = templateData.getDoi();
            if (string3 == null) {
                throw new HostException("EXM_CLI_NETTMPL_ERR_DATA_ERROR_DOI");
            }
            object = new TemplateData("tmp");
            ((TemplateData)object).setDoi(string3);
            try {
                object = this.setXOptionDOI(string3, templateData2, string2);
            }
            catch (Exception exception) {
                throw new HostException("EXM_CLI_NETTMPL_ERR_BAD_OLD_DOI");
            }
        }
        if (!bl) {
            if (string6 != null || string7 != null || string8 != null) {
                throw new HostException("EXM_CLI_NETTMPL_ERR_RIPSO_NOT_ALLOWED");
            }
        } else if (string2.equals(RIPSO_IPLABEL) && string.equals(RIPSO_IPLABEL)) {
            if (string6 != null || string7 != null || string8 != null) {
                int n2;
                string3 = templateData.getRipsoLabel();
                if (string3 == null) {
                    throw new HostException("EXM_CLI_NETTMPL_ERR_DATA_ERROR_RIPSOLABEL");
                }
                int n3 = string3.indexOf(" ");
                String string12 = string3.substring(n3 + 1, string3.length());
                String string13 = string3.substring(0, n3);
                if (string6 == null) {
                    n2 = 0;
                    while (n2 < ripsoSendClassHexList.length) {
                        if (string13.equals(ripsoSendClassHexList[n2])) {
                            string6 = ripsoSendClassList[n2];
                            break;
                        }
                        ++n2;
                    }
                }
                if (string6 == null) {
                    throw new HostException("EXM_CLI_NETTMPL_ERR_DATA_ERROR_RIPSOSENDCLASS");
                }
                if (string7 == null) {
                    n2 = 0;
                    while (n2 < ripsoPAFHexList.length) {
                        if (string12.equals(ripsoPAFHexList[n2])) {
                            string7 = ripsoPAFList[n2];
                            break;
                        }
                        ++n2;
                    }
                }
                if (string7 == null) {
                    throw new HostException("EXM_CLI_NETTMPL_ERR_DATA_ERROR_RIPSOSENDPAF");
                }
                if (string8 == null) {
                    String string14 = templateData.getRipsoError();
                    if (string14 == null) {
                        throw new HostException("EXM_CLI_NETTMPL_ERR_DATA_ERROR_RIPSOERROR");
                    }
                    int n4 = 0;
                    while (n4 < ripsoPAFHexList.length) {
                        if (string14.equals(ripsoPAFHexList[n4])) {
                            string8 = ripsoPAFList[n4];
                            break;
                        }
                        ++n4;
                    }
                }
                if (string8 == null) {
                    throw new HostException("EXM_CLI_NETTMPL_ERR_DATA_ERROR_RIPSORETURNPAF");
                }
                templateData2 = this.setXOptionRipso(string6, string7, string8, templateData2, string2);
            }
        } else if (string2.equals(RIPSO_IPLABEL) && !string.equals(RIPSO_IPLABEL)) {
            templateData2 = this.setXOptionRipso(string6, string7, string8, templateData2, string2);
        } else if (!string2.equals(RIPSO_IPLABEL) && string.equals(RIPSO_IPLABEL)) {
            templateData2 = this.setXOptionRipso(string6, string7, string8, templateData2, string2);
        }
        return templateData2;
    }

    public int runCommandLine(String[] stringArray, InputStream inputStream, PrintStream printStream, PrintStream printStream2) {
        String[] stringArray2 = new String[]{};
        int n = 0;
        this.userName = this.getAuthenticatedUser();
        ToolInfrastructure toolInfrastructure = this.getToolInfrastructure();
        try {
            this.labelService = (TrustedSolarisServiceInterface)toolInfrastructure.getServiceByName("com.sun.admin.tsol.server.TrustedSolarisService");
        }
        catch (Exception exception) {
            this.trace("got exception in getting TrustedSolarisService");
            String string = exception.getLocalizedMessage();
            this.handleErrors(string);
            return 2;
        }
        try {
            this.trace("calling initCommandLineOptions");
            this.initCommandLineOptions();
            this.trace("calling doFirstArgPass");
            this.doFirstArgPass(stringArray);
            this.initCommandLineOptions();
            this.trace("calling parseAndValidateArgs");
            this.parseAndValidateArgs(stringArray);
        }
        catch (HostMgrCliHelpException hostMgrCliHelpException) {
            return 0;
        }
        catch (HostMgrCliArgParsingException hostMgrCliArgParsingException) {
            String string = hostMgrCliArgParsingException.getLocalizedMessage();
            this.handleErrors(string);
            return 1;
        }
        catch (HostException hostException) {
            this.trace("got HostException in runCommandLine");
            String string = hostException.getLocalizedMessage();
            this.handleErrors(string);
            return 2;
        }
        catch (Exception exception) {
            String string = exception.getLocalizedMessage();
            this.handleErrors(string);
            if (this.getDebugStatus()) {
                exception.printStackTrace();
            }
            return 2;
        }
        try {
            this.doOperation();
        }
        catch (HostException hostException) {
            this.trace("runCommandLine, HostException:  " + hostException.getLocalizedMessage());
            this.handleErrors(hostException.getLocalizedMessage());
            n = 2;
        }
        catch (AdminException adminException) {
            this.trace("runCommandLine, AdminException:  " + adminException.getLocalizedMessage());
            this.handleErrors(adminException.getLocalizedMessage());
            n = 2;
        }
        catch (Exception exception) {
            this.trace("runCommandLine, Exception:  " + exception.getLocalizedMessage());
            this.handleErrors(exception.getLocalizedMessage());
            if (this.getDebugStatus()) {
                exception.printStackTrace();
            }
            n = 2;
        }
        return n;
    }

    private TemplateData setXOptionDOI(String string, TemplateData templateData, String string2) throws HostException {
        this.trace("HostMgrTmplCli->setXOptionDOI()");
        int n = -1;
        try {
            Integer n2 = new Integer(string);
            n = n2;
        }
        catch (Exception exception) {
            throw new HostException("EXM_CLI_NETTMPL_ERR_INVALID_DOI", String.valueOf(MAX_VALID_DOI));
        }
        if (string2.equals(CIPSO_IPLABEL)) {
            if (n < 1 || n > MAX_VALID_DOI) {
                throw new HostException("EXM_CLI_NETTMPL_ERR_INVALID_DOI_CIPSO", String.valueOf(MAX_VALID_DOI));
            }
        } else if (n < 0 || n > MAX_VALID_DOI) {
            throw new HostException("EXM_CLI_NETTMPL_ERR_INVALID_DOI", String.valueOf(MAX_VALID_DOI));
        }
        templateData.setDoi(string);
        return templateData;
    }

    private TemplateData setXOptionMaxSl(String string, TemplateData templateData) throws HostException {
        this.trace("HostMgrTmplCli->setXOptionMaxSl()");
        String string2 = this.checkLabel(string);
        templateData.setMaxSL(string2);
        return templateData;
    }

    private TemplateData setXOptionMinSl(String string, TemplateData templateData) throws HostException {
        this.trace("HostMgrTmplCli->setXOptionMinSl()");
        String string2 = this.checkLabel(string);
        templateData.setMinSL(string2);
        return templateData;
    }

    private TemplateData setXOptionRipso(String string, String string2, String string3, TemplateData templateData, String string4) throws HostException {
        this.trace("HostMgrTmplCli->setXOptionRispo()");
        this.trace("ipLabel = " + string4);
        if (string4.equals(RIPSO_IPLABEL)) {
            if (string == null || string2 == null || string3 == null) {
                throw new HostException("EXM_CLI_NETTMPL_ERR_RIPSO_NEEDED");
            }
            int n = -1;
            int n2 = -1;
            int n3 = -1;
            int n4 = 0;
            while (n4 < ripsoSendClassList.length) {
                if (string.equals(ripsoSendClassList[n4])) {
                    n = n4;
                    break;
                }
                ++n4;
            }
            if (n == -1) {
                throw new HostException("EXM_CLI_NETTMPL_ERR_RIPSO_SEND_CLASS", string);
            }
            int n5 = 0;
            while (n5 < ripsoPAFList.length) {
                if (string2.equals(ripsoPAFList[n5])) {
                    n2 = n5;
                    break;
                }
                ++n5;
            }
            if (n2 == -1) {
                throw new HostException("EXM_CLI_NETTMPL_ERR_RIPSO_SEND_PAF", string2);
            }
            int n6 = 0;
            while (n6 < ripsoPAFList.length) {
                if (string3.equals(ripsoPAFList[n6])) {
                    n3 = n6;
                    break;
                }
                ++n6;
            }
            if (n3 == -1) {
                throw new HostException("EXM_CLI_NETTMPL_ERR_RIPSO_RETURN_PAF", string3);
            }
            templateData.setRipsoLabel(String.valueOf(ripsoSendClassHexList[n]) + " " + ripsoPAFHexList[n2]);
            templateData.setRipsoError(ripsoPAFHexList[n3]);
        } else {
            if (string != null || string2 != null || string3 != null) {
                throw new HostException("EXM_CLI_NETTMPL_ERR_RIPSO_NOT_NEEDED");
            }
            templateData.setRipsoLabel("empty");
            templateData.setRipsoError("empty");
        }
        return templateData;
    }

    public void viewObjectProps() throws Exception {
        TemplateData templateData = null;
        this.trace("in HostMgrTmplCli->viewObjectProps()");
        try {
            if (this.getHostMgr() == null) {
                this.trace("in viewObjectProps:  hostmgr is null!");
                throw new HostException("EXM_CLI_NO_SERVICE");
            }
            this.vObjs = this.getHostMgr().listTemplates();
            Enumeration enumeration = this.vObjs.elements();
            while (enumeration.hasMoreElements()) {
                templateData = (TemplateData)enumeration.nextElement();
                this.viewUserOutput(templateData);
            }
        }
        catch (Exception exception) {
            this.trace("exception in viewObjectProps(): " + exception.getMessage());
            if (this.getDebugStatus()) {
                exception.printStackTrace();
            }
            throw exception;
        }
    }

    public void viewUserOutput(TemplateData templateData) throws Exception {
        this.trace("in HostMgrTmplCli->viewUserOutput");
        System.out.println("Template Name:        " + templateData.getTemplateName());
        String string = templateData.getHostType();
        if (string != null) {
            System.out.println("  Host Type:          " + string);
        }
        if ((string = templateData.getMinSL()) != null) {
            System.out.println("  Minimum Label:      " + string);
        }
        if ((string = templateData.getMaxSL()) != null) {
            System.out.println("  Maximum Label:      " + string);
        }
        if ((string = templateData.getDefLabel()) != null) {
            System.out.println("  Default Label:      " + string);
        }
        if ((string = templateData.getDefClearance()) != null) {
            System.out.println("  Default Clearance:  " + string);
        }
        if ((string = templateData.getForcedPrivsAsString()) != null) {
            System.out.println("  Forced Privileges:  " + string);
        }
        if ((string = templateData.getAllowedPrivsAsString()) != null) {
            System.out.println("  Allowed Privileges: " + string);
        }
        if ((string = templateData.getIPLabel()) != null) {
            System.out.println("  IP Label:           " + string);
        }
        if ((string = templateData.getRipsoLabel()) != null) {
            System.out.println("  Ripso Label:        " + string);
        }
        if ((string = templateData.getRipsoError()) != null) {
            System.out.println("  Ripso Error:        " + string);
        }
        if ((string = templateData.getDoi()) != null) {
            System.out.println("  DOI:                " + string);
        }
    }
}

