/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.hostmgr.common;

import com.sun.admin.hostmgr.common.HostException;
import java.io.Serializable;
import java.util.StringTokenizer;

public class TnrhdbData
implements Serializable,
Cloneable {
    private static final int CLASS_A_MAX = 127;
    private static final int CLASS_B_MAX = 191;
    private static final int CLASS_C_MAX = 223;
    private static final int CLASS_D_MAX = 239;
    private static final long IN_CLASSA_HOST = 0xFFFFFFL;
    private static final long IN_CLASSB_HOST = 65535L;
    private static final long IN_CLASSC_HOST = 255L;
    private static final int IN6ADDRSZ = 16;
    private static final int INADDRSZ = 4;
    private static final int INT16SZ = 2;
    private String ipAddress = null;
    private String TemplateType = null;
    private String prefixlen = null;
    private String hostname = null;
    private static final int MAX_IPV4_PREFIX_VAL = 32;
    private static final int MIN_IPV4_PREFIX_VAL = 1;
    private static final int MAX_IPV6_PREFIX_VAL = 128;
    private static final int MIN_IPV6_PREFIX_VAL = 1;

    public void debugPrint() {
        System.out.println("ipAddress = " + this.ipAddress);
        System.out.println("Host name = " + this.hostname);
        System.out.println("prefixlen = " + this.prefixlen);
        System.out.println("TemplateType = " + this.TemplateType);
    }

    public String getHostName() {
        return this.hostname;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    private int getMinIPv4PrefixLen() throws HostException {
        StringTokenizer stringTokenizer = new StringTokenizer(this.ipAddress, ".", false);
        if (stringTokenizer.countTokens() != 4) {
            throw new HostException("EXM_HST_CMN1");
        }
        int[] nArray = new int[4];
        int n = 0;
        while (n < 4) {
            String string = stringTokenizer.nextToken();
            try {
                nArray[n] = new Integer(string);
            }
            catch (Exception exception) {
                throw new HostException("EXM_HST_CMN1");
            }
            ++n;
        }
        int n2 = 0;
        int n3 = 3;
        int n4 = 0;
        while (n3 >= 0) {
            int n5 = nArray[n3];
            int n6 = -1;
            if ((n5 & 0xFF) != 0 && (n6 = this.getOneBitPosFromByte(n5)) != -1) {
                n2 = n4 * 8 + n6;
                break;
            }
            --n3;
            ++n4;
        }
        return 32 - n2;
    }

    private int getMinIPv6PrefixLen() throws HostException {
        String string;
        int n;
        int n2;
        StringTokenizer stringTokenizer;
        String string2;
        int[] nArray = new int[8];
        int n3 = 0;
        while (n3 < 8) {
            nArray[n3] = 0;
            ++n3;
        }
        int n4 = 0;
        int n5 = 0;
        n4 = this.ipAddress.indexOf("::");
        if (!this.ipAddress.startsWith("::")) {
            string2 = n4 != -1 ? this.ipAddress.substring(0, n4) : this.ipAddress;
            stringTokenizer = new StringTokenizer(string2, ":");
            n2 = stringTokenizer.countTokens();
            n5 = 0;
            n = 0;
            while (n < n2) {
                if (n5 == 8) {
                    throw new HostException("PREFIX_ERROR");
                }
                string = stringTokenizer.nextToken();
                if (string.indexOf(".") != -1) {
                    String string3 = this.ipAddress;
                    this.ipAddress = string;
                    int n6 = 0;
                    try {
                        n6 = this.getMinIPv4PrefixLen();
                    }
                    catch (HostException hostException) {
                        this.ipAddress = string3;
                        throw hostException;
                    }
                    this.ipAddress = string3;
                    return n6;
                }
                try {
                    nArray[n5] = Integer.decode("0x" + string);
                }
                catch (Exception exception) {
                    throw new HostException("PREFIX_ERROR");
                }
                ++n5;
                ++n;
            }
        }
        if (n4 != -1) {
            string2 = this.ipAddress.substring(n4 + 2);
            stringTokenizer = new StringTokenizer(string2, ":");
            n2 = stringTokenizer.countTokens();
            n5 = 7 - (n2 - 1);
            n = 0;
            while (n < n2) {
                if (n5 == 8) {
                    throw new HostException("PREFIX_ERROR");
                }
                string = stringTokenizer.nextToken();
                try {
                    nArray[n5] = Integer.decode("0x" + string);
                }
                catch (Exception exception) {
                    throw new HostException("PREFIX_ERROR");
                }
                ++n5;
                ++n;
            }
        }
        int n7 = 0;
        int n8 = 7;
        n2 = 0;
        while (n8 >= 0) {
            n = nArray[n8];
            int n9 = -1;
            if ((n & 0xFFFF) != 0) {
                n9 = this.getOneBitPosFromByte(n);
                if (n9 != -1) {
                    n7 = n2 * 16 + n9;
                    break;
                }
                n9 = this.getOneBitPosFromByte(n >> 8);
                if (n9 != -1) {
                    n7 = n2 * 16 + n9 + 8;
                }
            }
            --n8;
            ++n2;
        }
        return 128 - n7;
    }

    private int getOneBitPosFromByte(int n) throws HostException {
        int n2 = 0;
        while (n2 < 8) {
            if ((n & 1 << n2) != 0) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public String getPrefixLen() {
        return this.prefixlen;
    }

    public String getTemplateType() {
        return this.TemplateType;
    }

    public static boolean isIPv6Address(String string) {
        return string.indexOf(":") != -1;
    }

    public boolean isWildCardIPAddress() throws HostException {
        if (TnrhdbData.isIPv6Address(this.ipAddress)) {
            return this.isWildCardIPv6Address();
        }
        return this.isWildCardIPv4Address();
    }

    private boolean isWildCardIPv4Address() throws HostException {
        long l;
        if (this.prefixlen != null) {
            return true;
        }
        int n = 0;
        int[] nArray = new int[4];
        if (this.ipAddress.endsWith(".")) {
            throw new HostException("EXM_HST_CMN10");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.ipAddress, ".", false);
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            try {
                nArray[n] = new Integer(string);
            }
            catch (Exception exception) {
                throw new HostException("EXM_HST_CMN10");
            }
            if (nArray[n] > 255 || nArray[n] < 0) {
                throw new HostException("EXM_HST_CMN10");
            }
            ++n;
        }
        if (n != 4) {
            throw new HostException("EXM_HST_CMN10");
        }
        long l2 = nArray[0] << 24 | nArray[1] << 16 | nArray[2] << 8 | nArray[3];
        if (nArray[0] <= 127 && (l = 0xFFFFFFL & l2) == 0L) {
            return true;
        }
        if (nArray[0] <= 191 && (l = 0xFFFFL & l2) == 0L) {
            return true;
        }
        return nArray[0] <= 223 && (l = 0xFFL & l2) == 0L;
    }

    private boolean isWildCardIPv6Address() throws HostException {
        return this.prefixlen != null;
    }

    public void setHostName(String string) {
        this.hostname = string;
    }

    public void setIpAddress(String string) {
        this.ipAddress = string;
    }

    public void setPrefixLen(String string) {
        this.prefixlen = string;
    }

    public void setTemplateType(String string) {
        this.TemplateType = string;
    }

    public static void validateIPAddress(String string) throws HostException {
        if (TnrhdbData.isIPv6Address(string)) {
            if (string.endsWith("::")) {
                TnrhdbData.validateIPv6Address(String.valueOf(string) + "1");
            } else {
                TnrhdbData.validateIPv6Address(string);
            }
        } else {
            TnrhdbData.validateIPv4Address(string);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void validateIPv4Address(String var0) throws HostException {
        var1_1 = 0;
        var2_2 = new int[4];
        var8_3 = new StringTokenizer(var0, ".", false);
        if (!var0.endsWith(".")) ** GOTO lbl15
        throw new HostException("EXM_HST_CMN1");
lbl-1000:
        // 1 sources

        {
            var7_4 = var8_3.nextToken();
            try {
                var2_2[var1_1] = new Integer(var7_4);
            }
            catch (Exception v0) {
                throw new HostException("EXM_HST_CMN1");
            }
            if (var2_2[var1_1] > 255 || var2_2[var1_1] < 0) {
                throw new HostException("EXM_HST_CMN1");
            }
            ++var1_1;
lbl15:
            // 2 sources

            ** while (var8_3.hasMoreTokens())
        }
lbl16:
        // 1 sources

        if (var1_1 != 4) {
            throw new HostException("EXM_HST_CMN1");
        }
        var3_5 = var2_2[0] << 24 | var2_2[1] << 16 | var2_2[2] << 8 | var2_2[3];
        if (var2_2[0] <= 127 && (var5_6 = 0xFFFFFFL & var3_5) != 0L && var5_6 != 0xFFFFFFL) {
            return;
        }
        if (var2_2[0] <= 191 && (var5_6 = 65535L & var3_5) != 0L && var5_6 != 65535L) {
            return;
        }
        if (var2_2[0] <= 223 && (var5_6 = 255L & var3_5) != 0L && var5_6 != 255L) {
            return;
        }
        throw new HostException("EXM_HST_CMN1");
    }

    private void validateIPv4PrefixLen() throws HostException {
        int n;
        if (this.ipAddress.endsWith(".")) {
            throw new HostException("EXM_HST_CMN1");
        }
        try {
            n = new Integer(this.prefixlen);
        }
        catch (Exception exception) {
            throw new HostException("PREFIX_ERROR");
        }
        if (n < 1 || n > 32) {
            throw new HostException("PREFIX_ERROR");
        }
        int n2 = this.getMinIPv4PrefixLen();
        if (n2 == 0) {
            throw new HostException("PREFIX_ERROR");
        }
        if (n < n2) {
            throw new HostException("PREFIX_ERROR1", String.valueOf(n2));
        }
    }

    private static void validateIPv6Address(String string) throws HostException {
        String string2 = "0123456789abcdef";
        String string3 = "0123456789ABCDEF";
        char[] cArray = new char[]{'*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*'};
        int n = 0;
        int n2 = n + 16;
        int n3 = 0;
        int n4 = 0;
        int n5 = -1;
        n4 = string.length();
        int n6 = -1;
        if (string.charAt(n3) == ':' && string.charAt(++n3) != ':') {
            throw new HostException("EXM_HST_CMN9");
        }
        int n7 = n3;
        boolean bl = false;
        int n8 = 0;
        while (n3 < n4) {
            n5 = string2.indexOf(string.charAt(n3));
            if (n5 == -1) {
                n5 = string3.indexOf(string.charAt(n3));
            }
            if (n5 != -1) {
                n8 <<= 4;
                if ((n8 |= n5) > 65535) {
                    throw new HostException("EXM_HST_CMN9");
                }
                bl = true;
                ++n3;
                continue;
            }
            if (string.charAt(n3) == ':') {
                n7 = n3 + 1;
                if (!bl) {
                    if (n6 != -1 && cArray[n6] != '*') {
                        throw new HostException("EXM_HST_CMN9");
                    }
                    n6 = n;
                    ++n3;
                    continue;
                }
                if (n3 + 1 >= n4) {
                    throw new HostException("EXM_HST_CMN9");
                }
                if (n + 2 > n2) {
                    throw new HostException("EXM_HST_CMN9");
                }
                cArray[n] = 35;
                cArray[++n] = 35;
                ++n;
                bl = false;
                n8 = 0;
                ++n3;
                continue;
            }
            try {
                if (string.charAt(n3) == '.' && n + 4 <= n2) {
                    TnrhdbData.validateIPAddress(string.substring(n7));
                    n += 16;
                    bl = false;
                    break;
                }
            }
            catch (HostException hostException) {
                throw new HostException("EXM_HST_CMN9");
            }
            throw new HostException("EXM_HST_CMN9");
        }
        if (bl) {
            if (n + 2 > n2) {
                throw new HostException("EXM_HST_CMN9");
            }
            cArray[n] = 35;
            cArray[++n] = 35;
            ++n;
        }
        if (n6 != -1 && cArray[n6] != '*') {
            if (n == n2) {
                throw new HostException("EXM_HST_CMN9");
            }
            n = n2;
        }
        if (n != n2) {
            throw new HostException("EXM_HST_CMN9");
        }
    }

    private void validateIPv6PrefixLen() throws HostException {
        int n;
        try {
            n = new Integer(this.prefixlen);
        }
        catch (Exception exception) {
            throw new HostException("PREFIX_ERROR");
        }
        if (n < 1 || n > 128) {
            throw new HostException("PREFIX_ERROR");
        }
        int n2 = this.getMinIPv6PrefixLen();
        if (n2 == 0) {
            throw new HostException("PREFIX_ERROR");
        }
        if (n < n2) {
            throw new HostException("PREFIX_ERROR1", String.valueOf(n2));
        }
    }

    public void validatePrefixLen() throws HostException {
        if (TnrhdbData.isIPv6Address(this.ipAddress)) {
            this.validateIPv6PrefixLen();
        } else {
            this.validateIPv4PrefixLen();
        }
    }
}

