/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.hostmgr.common;

import com.sun.admin.cis.common.ExtAttrObj;
import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.Vector;

public class TemplateData
extends ExtAttrObj
implements Serializable,
Cloneable {
    private String templatename = null;
    private static final String HOST_TYPE_KW = "host_type";
    private static final String MIN_SL_KW = "min_sl";
    private static final String MAX_SL_KW = "max_sl";
    private static final String ALLOWED_PRIVS_KW = "allowed_privs";
    private static final String FORCED_PRIVS_KW = "forced_privs";
    private static final String DEFAULT_LABEL_KW = "def_label";
    private static final String DEFAULT_CLEAR_KW = "def_cl";
    private static final String IP_LABEL_KW = "ip_label";
    private static final String RIPSO_LABEL_KW = "ripso_label";
    private static final String RIPSO_ERROR_KW = "ripso_error";
    private static final String CIPSO_DOI_KW = "cipso_doi";
    private static final String DOI_KW = "doi";

    public TemplateData() {
    }

    public TemplateData(String string) {
        this.templatename = string;
    }

    public Object clone() {
        TemplateData templateData = new TemplateData(this.templatename);
        super.clone((ExtAttrObj)templateData);
        return templateData;
    }

    public void debugPrint() {
        System.out.println("Template Name: " + this.getTemplateName());
        System.out.println("Host Type: " + this.getHostType());
        System.out.println("Min SL: " + this.getMinSL());
        System.out.println("Max SL: " + this.getMaxSL());
        System.out.println("Def Label: " + this.getDefLabel());
        System.out.println("Def Clearance: " + this.getDefClearance());
        System.out.println("Forced Privileges: " + this.getForcedPrivsAsString());
        System.out.println("Allowed Privileges: " + this.getAllowedPrivsAsString());
        System.out.println("IP Label: " + this.getIPLabel());
        System.out.println("Ripso Label: " + this.getRipsoLabel());
        System.out.println("Ripso Error: " + this.getRipsoError());
        System.out.println("DOI: " + this.getDoi());
    }

    public String getAllowedPrivsAsString() {
        Vector vector = this.getAllowedPrivsAsVector();
        return this.privVectorToString(vector);
    }

    public Vector getAllowedPrivsAsVector() {
        Vector vector = this.getAttribute(ALLOWED_PRIVS_KW);
        return vector;
    }

    public String getDefClearance() {
        Vector vector = this.getAttribute(DEFAULT_CLEAR_KW);
        if (vector == null || vector.size() != 1) {
            return null;
        }
        return (String)vector.elementAt(0);
    }

    public String getDefLabel() {
        Vector vector = this.getAttribute(DEFAULT_LABEL_KW);
        if (vector == null || vector.size() != 1) {
            return null;
        }
        return (String)vector.elementAt(0);
    }

    public String getDoi() {
        Vector vector = this.getAttribute(DOI_KW);
        if (vector == null ? (vector = this.getAttribute(CIPSO_DOI_KW)) == null || vector.size() != 1 : vector.size() != 1) {
            return null;
        }
        return (String)vector.elementAt(0);
    }

    public String getForcedPrivsAsString() {
        Vector vector = this.getForcedPrivsAsVector();
        return this.privVectorToString(vector);
    }

    public Vector getForcedPrivsAsVector() {
        Vector vector = this.getAttribute(FORCED_PRIVS_KW);
        return vector;
    }

    public String getHostType() {
        Vector vector = this.getAttribute(HOST_TYPE_KW);
        if (vector == null || vector.size() != 1) {
            return null;
        }
        return (String)vector.elementAt(0);
    }

    public String getIPLabel() {
        Vector vector = this.getAttribute(IP_LABEL_KW);
        if (vector == null || vector.size() != 1) {
            return null;
        }
        return (String)vector.elementAt(0);
    }

    public String getMaxSL() {
        Vector vector = this.getAttribute(MAX_SL_KW);
        if (vector == null || vector.size() != 1) {
            return null;
        }
        return (String)vector.elementAt(0);
    }

    public String getMinSL() {
        Vector vector = this.getAttribute(MIN_SL_KW);
        if (vector == null || vector.size() != 1) {
            return null;
        }
        return (String)vector.elementAt(0);
    }

    public String getRipsoError() {
        Vector vector = this.getAttribute(RIPSO_ERROR_KW);
        if (vector == null || vector.size() != 1) {
            return null;
        }
        return (String)vector.elementAt(0);
    }

    public String getRipsoLabel() {
        Vector vector = this.getAttribute(RIPSO_LABEL_KW);
        if (vector == null || vector.size() != 1) {
            return null;
        }
        return (String)vector.elementAt(0);
    }

    public String getTemplateName() {
        return this.templatename;
    }

    public String privVectorToString(Vector vector) {
        if (vector == null || vector.size() < 1) {
            return "empty";
        }
        String string = (String)vector.elementAt(0);
        int n = 1;
        while (n < vector.size()) {
            string = String.valueOf(string) + "," + (String)vector.elementAt(n);
            ++n;
        }
        return string;
    }

    public void setAllowedPrivs(String string) {
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            vector.addElement(string2);
        }
        this.setAllowedPrivs(vector);
    }

    public void setAllowedPrivs(Vector vector) {
        this.setAttribute(ALLOWED_PRIVS_KW, vector);
    }

    public void setDefClearance(String string) {
        this.setAttribute(DEFAULT_CLEAR_KW, string);
    }

    public void setDefLabel(String string) {
        this.setAttribute(DEFAULT_LABEL_KW, string);
    }

    public void setDoi(String string) {
        this.setAttribute(DOI_KW, string);
    }

    public void setForcedPrivs(String string) {
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            vector.addElement(string2);
        }
        this.setForcedPrivs(vector);
    }

    public void setForcedPrivs(Vector vector) {
        this.setAttribute(FORCED_PRIVS_KW, vector);
    }

    public void setHostType(String string) {
        this.setAttribute(HOST_TYPE_KW, string);
    }

    public void setIPLabel(String string) {
        this.setAttribute(IP_LABEL_KW, string);
    }

    public void setMaxSL(String string) {
        this.setAttribute(MAX_SL_KW, string);
    }

    public void setMinSL(String string) {
        this.setAttribute(MIN_SL_KW, string);
    }

    public void setRipsoError(String string) {
        this.setAttribute(RIPSO_ERROR_KW, string);
    }

    public void setRipsoLabel(String string) {
        this.setAttribute(RIPSO_LABEL_KW, string);
    }

    public void setTemplateName(String string) {
        this.templatename = string;
    }
}

