/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.hostmgr.server;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.FilterItem;
import com.sun.admin.cis.common.ListProperties;
import com.sun.admin.cis.common.QuickVector;
import com.sun.admin.hostmgr.common.HostAuthException;
import com.sun.admin.hostmgr.common.HostData;
import com.sun.admin.hostmgr.common.HostException;
import com.sun.admin.hostmgr.common.HostWarningException;
import com.sun.admin.hostmgr.common.NetworkData;
import com.sun.admin.hostmgr.common.TemplateData;
import com.sun.admin.hostmgr.common.TnrhdbData;
import com.sun.admin.hostmgr.server.HostMgr;
import com.sun.management.viper.AdminMgmtScope;
import com.sun.management.viper.VService;
import com.sun.wbem.utility.authorization.AuthorizationUtility;
import com.sun.wbem.utility.directorytable.DirectoryFilter;
import com.sun.wbem.utility.directorytable.DirectoryRow;
import com.sun.wbem.utility.directorytable.DirectoryTable;
import com.sun.wbem.utility.directorytable.DirectoryTableAccessException;
import com.sun.wbem.utility.directorytable.DirectoryTableConnectionException;
import com.sun.wbem.utility.directorytable.DirectoryTableDoesNotExistException;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import com.sun.wbem.utility.directorytable.DirectoryTableFactory;
import com.sun.wbem.utility.directorytable.DirectoryTableRowNotFoundException;
import com.sun.wbem.utility.directorytable.DirectoryTableRowNotUniqueException;
import com.sun.wbem.utility.directorytable.SearchTemplate;
import com.sun.wbem.utility.directorytable.TableDefinitions;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.Vector;

public class HostMgrImpl
extends VService
implements HostMgr {
    private static final boolean LOG_SYSLOG = true;
    private static final String LOCAL_HOST_NAME = "localhost";
    private static final boolean EXPOSE_BAD_NETWORKS = true;
    private int ethersColumnAddr = 0;
    private int ethersColumnName = 0;
    private int ethersColumnComment = 0;
    private int hostsColumnAddr = 0;
    private int hostsColumnCname = 0;
    private int hostsColumnAliases = 0;
    private int hostsColumnComment = 0;
    private int templateColumnName = 0;
    private int templateColumnAttr = 0;
    private int tnrhdbColumnIpAddress = 0;
    private int tnrhdbColumnTemplateType = 0;
    private static final String TNRHDB_DELIMITER = ":";
    private int netmasksColumnAddr = 0;
    private int netmasksColumnMask = 0;
    private int netmasksColumnComment = 0;
    private int networksColumnCname = 0;
    private int networksColumnAddr = 0;
    private int networksColumnAliases = 0;
    private int networksColumnComment = 0;
    private int tnrhtpColumnName = 0;
    private int tnrhtpColumnType = 0;
    private int tnrhdbColumnTemplateName = 0;
    private DirectoryRow etherListRow = null;
    private DirectoryRow etherMatchRow = null;
    private DirectoryRow hostListRow = null;
    private DirectoryRow netmaskListRow = null;
    private int chunkSize = 0;
    private boolean sortAscending = true;
    private int hostListLimit = 1;
    private int hostListIndex = 1;
    private int hostListIncrement = 1;
    private int etherListLimit = 1;
    private int etherListIndex = 1;
    private TableDefinitions ethersTableDefn = null;
    private String scope = "";
    private String scopeUserName = "";
    private String scopeClientHost = "";
    private String scopeHostName = "";
    private static final String[] rights = new String[]{"solaris.network.hosts.write"};

    public HostMgrImpl() throws RemoteException, AdminException {
        String string = "";
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            string = inetAddress.getHostName();
        }
        catch (Exception exception) {
            string = "";
        }
        this.scope = new String("File:/" + string + "/" + string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addEthernetAddress(HostData hostData) throws RemoteException, AdminException, HostAuthException {
        HostWarningException hostWarningException;
        block16: {
            this.checkRights("solaris.network.hosts.write");
            DirectoryTable directoryTable = null;
            hostWarningException = null;
            if (hostData.getEthernetAddress().length() == 0) {
                return;
            }
            HostData hostData2 = this.getHostByEtherAddr(hostData.getEthernetAddress());
            if (hostData2 != null) {
                if (!hostData.getHostName().equals(hostData2.getHostName())) {
                    throw new HostWarningException("EXM_HST_SRV70_WARN");
                }
                return;
            }
            String string = this.getEtherAddrByHost(hostData.getHostName());
            if (string.length() > 0 && !string.equals(hostData.getEthernetAddress())) {
                hostWarningException = new HostWarningException("EXM_HST_SRV72_WARN");
            }
            try {
                try {
                    directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
                    TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                    tableDefinitions.loadTableDefinitions("ethers");
                    try {
                        directoryTable.open(tableDefinitions);
                    }
                    catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                        directoryTable.create(tableDefinitions);
                    }
                    DirectoryRow directoryRow = directoryTable.getRowInstance();
                    directoryRow.putColumn(this.ethersColumnName, hostData.getHostName());
                    directoryRow.putColumn(this.ethersColumnAddr, hostData.getEthernetAddress());
                    directoryTable.addRow(directoryRow);
                }
                catch (DirectoryTableRowNotUniqueException directoryTableRowNotUniqueException) {
                    HostException hostException = new HostException("EXM_HST_SRV65");
                    throw new HostWarningException("EXM_HST_SRV18_WARN", (Exception)((Object)hostException));
                }
                catch (DirectoryTableAccessException directoryTableAccessException) {
                    HostException hostException = new HostException("EXM_HST_SRV30");
                    throw new HostWarningException("EXM_HST_SRV18_WARN", (Exception)((Object)hostException));
                }
                catch (DirectoryTableConnectionException directoryTableConnectionException) {
                    HostException hostException = new HostException("EXM_HST_SRV31");
                    throw new HostWarningException("EXM_HST_SRV18_WARN", (Exception)((Object)hostException));
                }
                catch (DirectoryTableException directoryTableException) {
                    HostException hostException = new HostException("EXM_HST_SRV32");
                    throw new HostWarningException("EXM_HST_SRV18_WARN", (Exception)((Object)hostException));
                }
                catch (Exception exception) {
                    HostException hostException = new HostException("EXM_HST_SRV99", exception);
                    throw new HostWarningException("EXM_HST_SRV18_WARN", (Exception)((Object)hostException));
                }
                Object var11_14 = null;
                if (directoryTable == null) break block16;
            }
            catch (Throwable throwable) {
                Object var11_15 = null;
                if (directoryTable != null) {
                    directoryTable.close();
                }
                throw throwable;
            }
            directoryTable.close();
        }
        if (hostWarningException != null) {
            throw hostWarningException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addHost(HostData hostData) throws RemoteException, AdminException, HostAuthException {
        block12: {
            this.checkRights("solaris.network.hosts.write");
            DirectoryTable directoryTable = null;
            HostData hostData2 = this.getHostByAddress(hostData.getNetworkAddress());
            if (hostData2 != null) {
                if (hostData2.getHostName().equals(hostData.getHostName())) {
                    throw new HostException("EXM_HST_SRV23", (Exception)((Object)new HostException("EXM_HST_SRV64")));
                }
                throw new HostException("EXM_HST_SRV23", (Exception)((Object)new HostException("EXM_HST_SRV69")));
            }
            try {
                try {
                    directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
                    TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                    tableDefinitions.loadTableDefinitions("hosts");
                    directoryTable.open(tableDefinitions);
                    DirectoryRow directoryRow = directoryTable.getRowInstance();
                    directoryRow.putColumn(this.hostsColumnCname, hostData.getHostName());
                    directoryRow.putColumn(this.hostsColumnAddr, hostData.getNetworkAddress());
                    directoryRow.putColumn(this.hostsColumnAliases, hostData.getAliases());
                    directoryRow.putColumn(this.hostsColumnComment, hostData.getDescription());
                    directoryTable.addRow(directoryRow);
                }
                catch (DirectoryTableRowNotUniqueException directoryTableRowNotUniqueException) {
                    HostException hostException = new HostException("EXM_HST_SRV64");
                    throw new HostException("EXM_HST_SRV23", (Exception)((Object)hostException));
                }
                catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                    HostException hostException = new HostException("EXM_HST_SRV60");
                    throw new HostException("EXM_HST_SRV23", (Exception)((Object)hostException));
                }
                catch (DirectoryTableAccessException directoryTableAccessException) {
                    HostException hostException = new HostException("EXM_HST_SRV30");
                    throw new HostException("EXM_HST_SRV23", (Exception)((Object)hostException));
                }
                catch (DirectoryTableConnectionException directoryTableConnectionException) {
                    HostException hostException = new HostException("EXM_HST_SRV31");
                    throw new HostException("EXM_HST_SRV23", (Exception)((Object)hostException));
                }
                catch (DirectoryTableException directoryTableException) {
                    HostException hostException = new HostException("EXM_HST_SRV32");
                    throw new HostException("EXM_HST_SRV23", (Exception)((Object)hostException));
                }
                catch (Exception exception) {
                    HostException hostException = new HostException("EXM_HST_SRV99", exception);
                    throw new HostException("EXM_HST_SRV23", (Exception)((Object)hostException));
                }
                Object var8_13 = null;
                if (directoryTable == null) break block12;
            }
            catch (Throwable throwable) {
                Object var8_14 = null;
                if (directoryTable != null) {
                    directoryTable.close();
                }
                throw throwable;
            }
            directoryTable.close();
        }
        this.addEthernetAddress(hostData);
        String[] stringArray = new String[]{hostData.getHostName(), hostData.getNetworkAddress()};
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean addNetmask(NetworkData networkData) throws RemoteException, AdminException, HostAuthException {
        String string;
        this.checkRights("solaris.network.hosts.write");
        if (networkData.getNetmask().length() == 0) {
            return false;
        }
        try {
            string = this.getNetmask(networkData);
        }
        catch (HostException hostException) {
            throw new HostException("EXM_HST_SRV11", (Exception)((Object)hostException));
        }
        if (string != null && string.length() > 0) {
            if (!string.equals(networkData.getNetmask())) throw new HostException("EXM_HST_SRV45");
            return false;
        }
        DirectoryTable directoryTable = null;
        try {
            try {
                directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
                TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                tableDefinitions.loadTableDefinitions("netmasks");
                directoryTable.open(tableDefinitions);
                DirectoryRow directoryRow = directoryTable.getRowInstance();
                directoryRow.putColumn(this.netmasksColumnMask, networkData.getNetmask());
                directoryRow.putColumn(this.netmasksColumnAddr, networkData.getNetworkAddress());
                directoryTable.addRow(directoryRow);
            }
            catch (DirectoryTableRowNotUniqueException directoryTableRowNotUniqueException) {
                HostException hostException = new HostException("EXM_HST_SRV45");
                throw new HostException("EXM_HST_SRV11", (Exception)((Object)hostException));
            }
            catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                HostException hostException = new HostException("EXM_HST_SRV41");
                throw new HostException("EXM_HST_SRV11", (Exception)((Object)hostException));
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                HostException hostException = new HostException("EXM_HST_SRV30");
                throw new HostException("EXM_HST_SRV11", (Exception)((Object)hostException));
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                HostException hostException = new HostException("EXM_HST_SRV31");
                throw new HostException("EXM_HST_SRV11", (Exception)((Object)hostException));
            }
            catch (DirectoryTableException directoryTableException) {
                HostException hostException = new HostException("EXM_HST_SRV32");
                throw new HostException("EXM_HST_SRV11", (Exception)((Object)hostException));
            }
            catch (Exception exception) {
                HostException hostException = new HostException("EXM_HST_SRV99", exception);
                throw new HostException("EXM_HST_SRV11", (Exception)((Object)hostException));
            }
            Object var9_14 = null;
            if (directoryTable == null) return true;
        }
        catch (Throwable throwable) {
            Object var9_15 = null;
            if (directoryTable == null) throw throwable;
            directoryTable.close();
            throw throwable;
        }
        directoryTable.close();
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addNetwork(NetworkData networkData) throws RemoteException, AdminException, HostAuthException {
        this.checkRights("solaris.network.hosts.write");
        DirectoryTable directoryTable = null;
        if (this.getNetwork(networkData) != null) {
            throw new HostException("EXM_HST_SRV6", (Exception)((Object)new HostException("EXM_HST_SRV47")));
        }
        boolean bl = this.addNetmask(networkData);
        if (networkData.getNetworkName().length() == 0) {
            return;
        }
        try {
            try {
                directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
                TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                tableDefinitions.loadTableDefinitions("networks");
                directoryTable.open(tableDefinitions);
                DirectoryRow directoryRow = directoryTable.getRowInstance();
                directoryRow.putColumn(this.networksColumnCname, networkData.getNetworkName());
                directoryRow.putColumn(this.networksColumnAddr, networkData.getNetworkAddress());
                directoryRow.putColumn(this.networksColumnAliases, networkData.getAliases());
                directoryRow.putColumn(this.networksColumnComment, networkData.getDescription());
                directoryTable.addRow(directoryRow);
            }
            catch (DirectoryTableRowNotUniqueException directoryTableRowNotUniqueException) {
                HostException hostException = new HostException("EXM_HST_SRV44");
                if (!bl) throw new HostException("EXM_HST_SRV6", (Exception)((Object)hostException));
                throw new HostWarningException("EXM_HST_SRV6_WARN", (Exception)((Object)hostException));
            }
            catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                HostException hostException = new HostException("EXM_HST_SRV40");
                if (!bl) throw new HostException("EXM_HST_SRV6", (Exception)((Object)hostException));
                throw new HostWarningException("EXM_HST_SRV6_WARN", (Exception)((Object)hostException));
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                HostException hostException = new HostException("EXM_HST_SRV30");
                if (!bl) throw new HostException("EXM_HST_SRV6", (Exception)((Object)hostException));
                throw new HostWarningException("EXM_HST_SRV6_WARN", (Exception)((Object)hostException));
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                HostException hostException = new HostException("EXM_HST_SRV31");
                if (!bl) throw new HostException("EXM_HST_SRV6", (Exception)((Object)hostException));
                throw new HostWarningException("EXM_HST_SRV6_WARN", (Exception)((Object)hostException));
            }
            catch (DirectoryTableException directoryTableException) {
                HostException hostException = new HostException("EXM_HST_SRV32");
                if (!bl) throw new HostException("EXM_HST_SRV6", (Exception)((Object)hostException));
                throw new HostWarningException("EXM_HST_SRV6_WARN", (Exception)((Object)hostException));
            }
            catch (Exception exception) {
                HostException hostException = new HostException("EXM_HST_SRV99", exception);
                if (!bl) throw new HostException("EXM_HST_SRV6", (Exception)((Object)hostException));
                throw new HostWarningException("EXM_HST_SRV6_WARN", (Exception)((Object)hostException));
            }
            Object var9_13 = null;
            if (directoryTable == null) return;
        }
        catch (Throwable throwable) {
            Object var9_14 = null;
            if (directoryTable == null) throw throwable;
            directoryTable.close();
            throw throwable;
        }
        directoryTable.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addTemplate(TemplateData templateData) throws RemoteException, AdminException, DirectoryTableException, HostAuthException {
        block11: {
            this.checkRights("solaris.network.security.write");
            DirectoryTable directoryTable = null;
            try {
                try {
                    directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
                    TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                    tableDefinitions.loadTableDefinitions("tnrhtp");
                    try {
                        directoryTable.open(tableDefinitions);
                    }
                    catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                        directoryTable.create(tableDefinitions);
                    }
                    DirectoryRow directoryRow = directoryTable.getRowInstance();
                    directoryRow.putColumn(this.templateColumnName, templateData.getTemplateName());
                    directoryRow.putColumn(this.templateColumnAttr, templateData.getAttributeString());
                    directoryTable.addRow(directoryRow);
                }
                catch (DirectoryTableRowNotUniqueException directoryTableRowNotUniqueException) {
                    throw new HostException("EXM_SERVER_ROW_NOT_UNIQUE");
                }
                catch (DirectoryTableAccessException directoryTableAccessException) {
                    throw new HostException("EXM_SERVER_ACCESS_ERROR");
                }
                catch (DirectoryTableConnectionException directoryTableConnectionException) {
                    throw new HostException("EXM_SERVER_CONNECTION_ERROR");
                }
                catch (DirectoryTableException directoryTableException) {
                    throw new HostException("EXM_SERVER_TABLE_ERROR");
                }
                catch (Exception exception) {
                    throw new HostException("EXM_SERVER_ERROR");
                }
                Object var6_5 = null;
                if (directoryTable == null) break block11;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (directoryTable != null) {
                    directoryTable.close();
                }
                throw throwable;
            }
            directoryTable.close();
        }
        this.updateTntime("tnrhtp");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private DirectoryRow cacheEthersList() throws RemoteException, AdminException {
        DirectoryRow directoryRow = null;
        DirectoryTable directoryTable = null;
        try {
            try {
                directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
                this.ethersTableDefn = directoryTable.getTableDefinitionsInstance();
                this.ethersTableDefn.loadTableDefinitions("ethers");
                directoryTable.open(this.ethersTableDefn);
                this.etherMatchRow = directoryTable.getRowInstance();
                directoryRow = directoryTable.getAll();
            }
            catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                HostException hostException = new HostException("EXM_HST_SRV30");
                throw new HostException("EXM_HST_SRV16", (Exception)((Object)hostException));
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                HostException hostException = new HostException("EXM_HST_SRV31");
                throw new HostException("EXM_HST_SRV16", (Exception)((Object)hostException));
            }
            catch (DirectoryTableException directoryTableException) {
                HostException hostException = new HostException("EXM_HST_SRV32");
                throw new HostException("EXM_HST_SRV16", (Exception)((Object)hostException));
            }
            catch (Exception exception) {
                HostException hostException = new HostException("EXM_HST_SRV99", exception);
                throw new HostException("EXM_HST_SRV16", (Exception)((Object)hostException));
            }
            Object var5_8 = null;
            if (directoryTable == null) return directoryRow;
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            if (directoryTable == null) throw throwable;
            directoryTable.close();
            throw throwable;
        }
        directoryTable.close();
        return directoryRow;
    }

    private void checkRights(String string) throws HostAuthException {
        String string2 = null;
        try {
            string2 = this.getContext().getCaller().getName();
        }
        catch (Exception exception) {
            throw new HostAuthException("");
        }
        if (string2 == null) {
            throw new HostAuthException("");
        }
        if (!AuthorizationUtility.checkAuthName((String)string2, (String)string)) {
            throw new HostAuthException("");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void deleteEthernetAddress(HostData hostData) throws RemoteException, AdminException, HostAuthException {
        this.checkRights("solaris.network.hosts.write");
        if (hostData.getEthernetAddress().length() == 0) {
            return;
        }
        DirectoryTable directoryTable = null;
        try {
            try {
                directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
                TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                tableDefinitions.loadTableDefinitions("ethers");
                directoryTable.open(tableDefinitions);
                DirectoryRow directoryRow = directoryTable.getRowInstance();
                directoryRow.putColumn(this.ethersColumnAddr, hostData.getEthernetAddress());
                directoryRow.putColumn(this.ethersColumnName, hostData.getHostName());
                directoryTable.deleteRow(directoryRow);
            }
            catch (DirectoryTableRowNotFoundException directoryTableRowNotFoundException) {
                HostException hostException = new HostException("EXM_HST_SRV63");
                throw new HostException("EXM_HST_SRV19", (Exception)((Object)hostException));
            }
            catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                HostException hostException = new HostException("EXM_HST_SRV61");
                throw new HostException("EXM_HST_SRV19", (Exception)((Object)hostException));
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                HostException hostException = new HostException("EXM_HST_SRV30");
                throw new HostException("EXM_HST_SRV19", (Exception)((Object)hostException));
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                HostException hostException = new HostException("EXM_HST_SRV31");
                throw new HostException("EXM_HST_SRV19", (Exception)((Object)hostException));
            }
            catch (DirectoryTableException directoryTableException) {
                HostException hostException = new HostException("EXM_HST_SRV32");
                throw new HostException("EXM_HST_SRV19", (Exception)((Object)hostException));
            }
            catch (Exception exception) {
                HostException hostException = new HostException("EXM_HST_SRV99", exception);
                throw new HostException("EXM_HST_SRV19", (Exception)((Object)hostException));
            }
            Object var7_12 = null;
            if (directoryTable == null) return;
        }
        catch (Throwable throwable) {
            Object var7_13 = null;
            if (directoryTable == null) throw throwable;
            directoryTable.close();
            throw throwable;
        }
        directoryTable.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteHost(HostData hostData) throws RemoteException, AdminException, HostAuthException {
        block11: {
            this.checkRights("solaris.network.hosts.write");
            DirectoryTable directoryTable = null;
            if (hostData.getHostName().equals(LOCAL_HOST_NAME)) {
                HostException hostException = new HostException("EXM_HST_SRV71");
                throw new HostException("EXM_HST_SRV24", (Exception)((Object)hostException));
            }
            try {
                try {
                    directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
                    TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                    tableDefinitions.loadTableDefinitions("hosts");
                    directoryTable.open(tableDefinitions);
                    DirectoryRow directoryRow = directoryTable.getRowInstance();
                    directoryRow.putColumn(this.hostsColumnCname, hostData.getHostName());
                    directoryRow.putColumn(this.hostsColumnAddr, hostData.getNetworkAddress());
                    directoryRow.putColumn(this.hostsColumnAliases, hostData.getAliases());
                    directoryTable.deleteRow(directoryRow);
                }
                catch (DirectoryTableRowNotFoundException directoryTableRowNotFoundException) {
                    HostException hostException = new HostException("EXM_HST_SRV62");
                    throw new HostException("EXM_HST_SRV24", (Exception)((Object)hostException));
                }
                catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                    HostException hostException = new HostException("EXM_HST_SRV60");
                    throw new HostException("EXM_HST_SRV24", (Exception)((Object)hostException));
                }
                catch (DirectoryTableAccessException directoryTableAccessException) {
                    HostException hostException = new HostException("EXM_HST_SRV30");
                    throw new HostException("EXM_HST_SRV24", (Exception)((Object)hostException));
                }
                catch (DirectoryTableConnectionException directoryTableConnectionException) {
                    HostException hostException = new HostException("EXM_HST_SRV31");
                    throw new HostException("EXM_HST_SRV24", (Exception)((Object)hostException));
                }
                catch (DirectoryTableException directoryTableException) {
                    HostException hostException = new HostException("EXM_HST_SRV32");
                    throw new HostException("EXM_HST_SRV24", (Exception)((Object)hostException));
                }
                catch (Exception exception) {
                    HostException hostException = new HostException("EXM_HST_SRV99", exception);
                    throw new HostException("EXM_HST_SRV24", (Exception)((Object)hostException));
                }
                Object var7_13 = null;
                if (directoryTable == null) break block11;
            }
            catch (Throwable throwable) {
                Object var7_14 = null;
                if (directoryTable != null) {
                    directoryTable.close();
                }
                throw throwable;
            }
            directoryTable.close();
        }
        this.deleteEthernetAddress(hostData);
        String[] stringArray = new String[]{hostData.getHostName(), hostData.getNetworkAddress()};
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void deleteNetmask(NetworkData networkData) throws RemoteException, AdminException, HostAuthException {
        this.checkRights("solaris.network.hosts.write");
        if (networkData.getNetmask().length() == 0) {
            return;
        }
        DirectoryFilter directoryFilter = new DirectoryFilter(2);
        DirectoryTable directoryTable = null;
        try {
            try {
                directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
                TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                tableDefinitions.loadTableDefinitions("netmasks");
                directoryTable.open(tableDefinitions);
                DirectoryRow directoryRow = directoryTable.getRowInstance();
                directoryRow.putColumn(this.netmasksColumnAddr, networkData.getNetworkAddress());
                directoryRow.putColumn(this.netmasksColumnMask, networkData.getNetmask());
                directoryTable.deleteRow(directoryRow);
            }
            catch (DirectoryTableRowNotFoundException directoryTableRowNotFoundException) {
                HostException hostException = new HostException("EXM_HST_SRV43");
                throw new HostException("EXM_HST_SRV12", (Exception)((Object)hostException));
            }
            catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                HostException hostException = new HostException("EXM_HST_SRV41");
                throw new HostException("EXM_HST_SRV12", (Exception)((Object)hostException));
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                HostException hostException = new HostException("EXM_HST_SRV30");
                throw new HostException("EXM_HST_SRV12", (Exception)((Object)hostException));
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                HostException hostException = new HostException("EXM_HST_SRV31");
                throw new HostException("EXM_HST_SRV12", (Exception)((Object)hostException));
            }
            catch (DirectoryTableException directoryTableException) {
                HostException hostException = new HostException("EXM_HST_SRV32");
                throw new HostException("EXM_HST_SRV12", (Exception)((Object)hostException));
            }
            catch (Exception exception) {
                HostException hostException = new HostException("EXM_HST_SRV99", exception);
                throw new HostException("EXM_HST_SRV12", (Exception)((Object)hostException));
            }
            Object var9_13 = null;
            if (directoryTable == null) return;
        }
        catch (Throwable throwable) {
            Object var9_14 = null;
            if (directoryTable == null) throw throwable;
            directoryTable.close();
            throw throwable;
        }
        directoryTable.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteNetwork(NetworkData networkData) throws RemoteException, AdminException, HostAuthException {
        block11: {
            this.checkRights("solaris.network.hosts.write");
            DirectoryTable directoryTable = null;
            if (networkData.getNetworkName().equals("")) {
                return;
            }
            this.deleteNetmask(networkData);
            try {
                try {
                    directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
                    TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                    tableDefinitions.loadTableDefinitions("networks");
                    directoryTable.open(tableDefinitions);
                    DirectoryRow directoryRow = directoryTable.getRowInstance();
                    directoryRow.putColumn(this.networksColumnCname, networkData.getNetworkName());
                    directoryRow.putColumn(this.networksColumnAddr, networkData.getNetworkAddress());
                    directoryRow.putColumn(this.networksColumnAliases, networkData.getAliases());
                    directoryTable.deleteRow(directoryRow);
                }
                catch (DirectoryTableRowNotFoundException directoryTableRowNotFoundException) {
                    HostException hostException = new HostException("EXM_HST_SRV42");
                    throw new HostException("EXM_HST_SRV7", (Exception)((Object)hostException));
                }
                catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                    HostException hostException = new HostException("EXM_HST_SRV40");
                    throw new HostException("EXM_HST_SRV7", (Exception)((Object)hostException));
                }
                catch (DirectoryTableAccessException directoryTableAccessException) {
                    HostException hostException = new HostException("EXM_HST_SRV30");
                    throw new HostException("EXM_HST_SRV7", (Exception)((Object)hostException));
                }
                catch (DirectoryTableConnectionException directoryTableConnectionException) {
                    HostException hostException = new HostException("EXM_HST_SRV31");
                    throw new HostException("EXM_HST_SRV7", (Exception)((Object)hostException));
                }
                catch (DirectoryTableException directoryTableException) {
                    HostException hostException = new HostException("EXM_HST_SRV32");
                    throw new HostException("EXM_HST_SRV7", (Exception)((Object)hostException));
                }
                catch (Exception exception) {
                    HostException hostException = new HostException("EXM_HST_SRV99", exception);
                    throw new HostException("EXM_HST_SRV7", (Exception)((Object)hostException));
                }
                Object var7_12 = null;
                if (directoryTable == null) break block11;
            }
            catch (Throwable throwable) {
                Object var7_13 = null;
                if (directoryTable != null) {
                    directoryTable.close();
                }
                throw throwable;
            }
            directoryTable.close();
        }
        String[] stringArray = new String[]{networkData.getNetworkName(), networkData.getNetworkAddress()};
    }

    public void deleteTnrhdb(TnrhdbData tnrhdbData) throws RemoteException, AdminException, DirectoryTableException, HostException, HostAuthException {
        DirectoryTable directoryTable;
        block6: {
            this.checkRights("solaris.network.security.write");
            directoryTable = null;
            try {
                directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
                TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                tableDefinitions.loadTableDefinitions("tnrhdb");
                try {
                    directoryTable.open(tableDefinitions);
                }
                catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                    directoryTable.create(tableDefinitions);
                }
                DirectoryRow directoryRow = new DirectoryRow(tableDefinitions.getNumberOfColumns());
                this.tnrhdbColumnIpAddress = tableDefinitions.getColumnNumber("addr");
                this.tnrhdbColumnTemplateType = tableDefinitions.getColumnNumber("name");
                String string = this.insertEscapeChar(tnrhdbData.getIpAddress(), TNRHDB_DELIMITER);
                if (tnrhdbData.getPrefixLen() == null) {
                    directoryRow.putColumn(this.tnrhdbColumnIpAddress, string);
                } else {
                    directoryRow.putColumn(this.tnrhdbColumnIpAddress, String.valueOf(string) + "/" + tnrhdbData.getPrefixLen());
                }
                directoryRow.putColumn(this.tnrhdbColumnTemplateType, tnrhdbData.getTemplateType());
                directoryRow = directoryTable.getFirstRow((SearchTemplate)directoryRow);
                if (directoryRow == null) break block6;
                directoryTable.deleteRow(directoryRow);
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                directoryTable.close();
                throw throwable;
            }
        }
        Object var6_6 = null;
        directoryTable.close();
        this.updateTntime("tnrhdb");
    }

    public void deleteTnrhtp(TemplateData templateData) throws RemoteException, AdminException, DirectoryTableException, HostException, HostAuthException {
        DirectoryTable directoryTable;
        block5: {
            this.checkRights("solaris.network.security.write");
            directoryTable = null;
            try {
                directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
                TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                tableDefinitions.loadTableDefinitions("tnrhtp");
                try {
                    directoryTable.open(tableDefinitions);
                }
                catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                    directoryTable.create(tableDefinitions);
                }
                DirectoryRow directoryRow = new DirectoryRow(tableDefinitions.getNumberOfColumns());
                this.tnrhtpColumnName = tableDefinitions.getColumnNumber("name");
                if (templateData.getTemplateName() != null) {
                    directoryRow.putColumn(this.tnrhtpColumnName, templateData.getTemplateName());
                }
                if ((directoryRow = directoryTable.getFirstRow((SearchTemplate)directoryRow)) == null) break block5;
                directoryTable.deleteRow(directoryRow);
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                directoryTable.close();
                throw throwable;
            }
        }
        Object var6_5 = null;
        directoryTable.close();
        this.updateTntime("tnrhtp");
    }

    private String execCmd(String string) throws HostException {
        String string2 = new String("");
        try {
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(string);
            InputStreamReader inputStreamReader = new InputStreamReader(process.getInputStream());
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string3 = bufferedReader.readLine();
            while (string3 != null) {
                string2 = String.valueOf(string2) + string3;
                string3 = bufferedReader.readLine();
            }
            bufferedReader.close();
            inputStreamReader.close();
            process.getInputStream().close();
            process.getErrorStream().close();
            process.waitFor();
        }
        catch (Exception exception) {
            throw new HostException("EXM_HST_SRV74");
        }
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getEtherAddrByHost(String string) throws RemoteException, AdminException, HostAuthException {
        this.checkRights("solaris.network.hosts.read");
        DirectoryTable directoryTable = null;
        String string2 = "";
        try {
            try {
                directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
                TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                tableDefinitions.loadTableDefinitions("ethers");
                directoryTable.open(tableDefinitions);
                DirectoryRow directoryRow = directoryTable.getRowInstance();
                directoryRow.putColumn(this.ethersColumnName, string);
                DirectoryRow directoryRow2 = directoryTable.getFirstRow((SearchTemplate)directoryRow);
                if (directoryRow2 != null) {
                    string2 = directoryRow2.getColumn(this.ethersColumnAddr);
                }
            }
            catch (DirectoryTableRowNotFoundException directoryTableRowNotFoundException) {
                HostException hostException = new HostException("EXM_HST_SRV63");
                throw new HostException("EXM_HST_SRV15", (Exception)((Object)hostException));
            }
            catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                HostException hostException = new HostException("EXM_HST_SRV30");
                throw new HostException("EXM_HST_SRV15", (Exception)((Object)hostException));
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                HostException hostException = new HostException("EXM_HST_SRV31");
                throw new HostException("EXM_HST_SRV15", (Exception)((Object)hostException));
            }
            catch (DirectoryTableException directoryTableException) {
                HostException hostException = new HostException("EXM_HST_SRV32");
                throw new HostException("EXM_HST_SRV15", (Exception)((Object)hostException));
            }
            catch (Exception exception) {
                HostException hostException = new HostException("EXM_HST_SRV99", exception);
                throw new HostException("EXM_HST_SRV15", (Exception)((Object)hostException));
            }
            Object var9_13 = null;
            if (directoryTable == null) return string2;
        }
        catch (Throwable throwable) {
            Object var9_14 = null;
            if (directoryTable == null) throw throwable;
            directoryTable.close();
            throw throwable;
        }
        directoryTable.close();
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public HostData getHostByAddress(String string) throws RemoteException, AdminException, HostAuthException {
        this.checkRights("solaris.network.hosts.read");
        DirectoryTable directoryTable = null;
        HostData hostData = null;
        try {
            try {
                directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
                TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                tableDefinitions.loadTableDefinitions("hosts");
                directoryTable.open(tableDefinitions);
                DirectoryRow directoryRow = directoryTable.getRowInstance();
                directoryRow.putColumn(this.hostsColumnAddr, string);
                DirectoryRow directoryRow2 = directoryTable.getFirstRow((SearchTemplate)directoryRow);
                if (directoryRow2 != null) {
                    hostData = new HostData();
                    hostData.setNetworkAddress(directoryRow2.getColumn(this.hostsColumnAddr));
                    hostData.setHostName(directoryRow2.getColumn(this.hostsColumnCname));
                }
            }
            catch (DirectoryTableRowNotFoundException directoryTableRowNotFoundException) {
            }
            catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                HostException hostException = new HostException("EXM_HST_SRV30");
                throw new HostException("EXM_HST_SRV20", (Exception)((Object)hostException));
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                HostException hostException = new HostException("EXM_HST_SRV31");
                throw new HostException("EXM_HST_SRV20", (Exception)((Object)hostException));
            }
            catch (DirectoryTableException directoryTableException) {
                HostException hostException = new HostException("EXM_HST_SRV32");
                throw new HostException("EXM_HST_SRV20", (Exception)((Object)hostException));
            }
            catch (Exception exception) {
                HostException hostException = new HostException("EXM_HST_SRV99", exception);
                throw new HostException("EXM_HST_SRV20", (Exception)((Object)hostException));
            }
            Object var9_12 = null;
            if (directoryTable == null) return hostData;
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            if (directoryTable == null) throw throwable;
            directoryTable.close();
            throw throwable;
        }
        directoryTable.close();
        return hostData;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private HostData getHostByEtherAddr(String string) throws RemoteException, AdminException, HostAuthException {
        this.checkRights("solaris.network.hosts.read");
        if (string.length() == 0) {
            return null;
        }
        DirectoryTable directoryTable = null;
        HostData hostData = null;
        try {
            try {
                directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
                TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                tableDefinitions.loadTableDefinitions("ethers");
                directoryTable.open(tableDefinitions);
                DirectoryRow directoryRow = directoryTable.getRowInstance();
                directoryRow.putColumn(this.ethersColumnAddr, string);
                DirectoryRow directoryRow2 = directoryTable.getFirstRow((SearchTemplate)directoryRow);
                if (directoryRow2 != null) {
                    hostData = new HostData(directoryRow2.getColumn(this.ethersColumnName));
                    hostData.setEthernetAddress(string);
                }
            }
            catch (DirectoryTableRowNotFoundException directoryTableRowNotFoundException) {
            }
            catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                HostException hostException = new HostException("EXM_HST_SRV30");
                throw new HostException("EXM_HST_SRV15", (Exception)((Object)hostException));
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                HostException hostException = new HostException("EXM_HST_SRV31");
                throw new HostException("EXM_HST_SRV15", (Exception)((Object)hostException));
            }
            catch (DirectoryTableException directoryTableException) {
                HostException hostException = new HostException("EXM_HST_SRV32");
                throw new HostException("EXM_HST_SRV15", (Exception)((Object)hostException));
            }
            catch (Exception exception) {
                HostException hostException = new HostException("EXM_HST_SRV99", exception);
                throw new HostException("EXM_HST_SRV15", (Exception)((Object)hostException));
            }
            Object var9_12 = null;
            if (directoryTable == null) return hostData;
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            if (directoryTable == null) throw throwable;
            directoryTable.close();
            throw throwable;
        }
        directoryTable.close();
        return hostData;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HostData getHostByNameAddr(String string, String string2) throws RemoteException, AdminException, HostAuthException {
        HostData hostData;
        DirectoryTable directoryTable;
        block11: {
            HostData hostData2;
            block10: {
                this.checkRights("solaris.network.hosts.read");
                Object var3_3 = null;
                directoryTable = null;
                hostData = null;
                try {
                    try {
                        directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
                        TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                        tableDefinitions.loadTableDefinitions("hosts");
                        directoryTable.open(tableDefinitions);
                        DirectoryRow directoryRow = directoryTable.getRowInstance();
                        directoryRow.putColumn(this.hostsColumnCname, string);
                        directoryRow.putColumn(this.hostsColumnAddr, string2);
                        DirectoryRow directoryRow2 = directoryTable.getFirstRow((SearchTemplate)directoryRow);
                        if (directoryRow2 == null) {
                            hostData2 = hostData;
                            Object var12_10 = null;
                            if (directoryTable == null) return hostData2;
                            break block10;
                        }
                        hostData = new HostData();
                        hostData.setNetworkAddress(directoryRow2.getColumn(this.hostsColumnAddr));
                        hostData.setHostName(directoryRow2.getColumn(this.hostsColumnCname));
                        hostData.setAliases(directoryRow2.getColumn(this.hostsColumnAliases));
                        hostData.setDescription(directoryRow2.getColumn(this.hostsColumnComment));
                        hostData.setEthernetAddress(this.getEtherAddrByHost(hostData.getHostName()));
                        break block11;
                    }
                    catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                        break block11;
                    }
                    catch (DirectoryTableAccessException directoryTableAccessException) {
                        HostException hostException = new HostException("EXM_HST_SRV30");
                        throw new HostException("EXM_HST_SRV20", (Exception)((Object)hostException));
                    }
                    catch (DirectoryTableConnectionException directoryTableConnectionException) {
                        HostException hostException = new HostException("EXM_HST_SRV31");
                        throw new HostException("EXM_HST_SRV20", (Exception)((Object)hostException));
                    }
                    catch (DirectoryTableException directoryTableException) {
                        HostException hostException = new HostException("EXM_HST_SRV32");
                        throw new HostException("EXM_HST_SRV20", (Exception)((Object)hostException));
                    }
                    catch (HostException hostException) {
                        throw new HostException("EXM_HST_SRV20", (Exception)((Object)hostException));
                    }
                    catch (Exception exception) {
                        HostException hostException = new HostException("EXM_HST_SRV99", exception);
                        throw new HostException("EXM_HST_SRV20", (Exception)((Object)hostException));
                    }
                }
                catch (Throwable throwable) {
                    Object var12_12 = null;
                    if (directoryTable == null) throw throwable;
                    directoryTable.close();
                    throw throwable;
                }
            }
            directoryTable.close();
            return hostData2;
        }
        Object var12_11 = null;
        if (directoryTable == null) return hostData;
        directoryTable.close();
        return hostData;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Vector getHostOtherAddrs(HostData hostData) throws RemoteException, AdminException, HostAuthException {
        Vector<String> vector;
        DirectoryTable directoryTable;
        block12: {
            Vector<String> vector2;
            block11: {
                this.checkRights("solaris.network.hosts.read");
                Object var2_2 = null;
                directoryTable = null;
                vector = new Vector<String>();
                try {
                    try {
                        String[] stringArray = new String[]{hostData.getHostName()};
                        directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
                        TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                        tableDefinitions.loadTableDefinitions("hosts");
                        directoryTable.open(tableDefinitions);
                        DirectoryRow directoryRow = directoryTable.getRowInstance();
                        directoryRow.putColumn(this.hostsColumnCname, hostData.getHostName());
                        DirectoryRow directoryRow2 = directoryTable.getAll((SearchTemplate)directoryRow);
                        if (directoryRow2 == null) {
                            vector2 = vector;
                            Object var12_11 = null;
                            if (directoryTable == null) return vector2;
                            break block11;
                        }
                        String string = hostData.getNetworkAddress();
                        int n = 1;
                        while (n <= directoryRow2.getNumberOfRows()) {
                            if (directoryRow2.getColumn(this.hostsColumnAddr, n).length() > 0 && !string.equals(directoryRow2.getColumn(this.hostsColumnAddr, n))) {
                                vector.addElement(directoryRow2.getColumn(this.hostsColumnAddr, n));
                            }
                            ++n;
                        }
                        break block12;
                    }
                    catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                        break block12;
                    }
                    catch (DirectoryTableAccessException directoryTableAccessException) {
                        HostException hostException = new HostException("EXM_HST_SRV30");
                        throw new HostException("EXM_HST_SRV20", (Exception)((Object)hostException));
                    }
                    catch (DirectoryTableConnectionException directoryTableConnectionException) {
                        HostException hostException = new HostException("EXM_HST_SRV31");
                        throw new HostException("EXM_HST_SRV20", (Exception)((Object)hostException));
                    }
                    catch (DirectoryTableException directoryTableException) {
                        HostException hostException = new HostException("EXM_HST_SRV32");
                        throw new HostException("EXM_HST_SRV20", (Exception)((Object)hostException));
                    }
                    catch (Exception exception) {
                        HostException hostException = new HostException("EXM_HST_SRV99", exception);
                        throw new HostException("EXM_HST_SRV20", (Exception)((Object)hostException));
                    }
                }
                catch (Throwable throwable) {
                    Object var12_13 = null;
                    if (directoryTable == null) throw throwable;
                    directoryTable.close();
                    throw throwable;
                }
            }
            directoryTable.close();
            return vector2;
        }
        Object var12_12 = null;
        if (directoryTable == null) return vector;
        directoryTable.close();
        return vector;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Vector getHostsByName(String string) throws RemoteException, AdminException, HostAuthException {
        Vector<HostData> vector;
        DirectoryTable directoryTable;
        block12: {
            Vector<HostData> vector2;
            block11: {
                this.checkRights("solaris.network.hosts.read");
                Object var2_2 = null;
                directoryTable = null;
                vector = new Vector<HostData>();
                try {
                    try {
                        directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
                        TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                        tableDefinitions.loadTableDefinitions("hosts");
                        directoryTable.open(tableDefinitions);
                        DirectoryRow directoryRow = directoryTable.getRowInstance();
                        directoryRow.putColumn(this.hostsColumnCname, string);
                        DirectoryRow directoryRow2 = directoryTable.getAll((SearchTemplate)directoryRow);
                        if (directoryRow2 == null) {
                            vector2 = vector;
                            Object var12_9 = null;
                            if (directoryTable == null) return vector2;
                            break block11;
                        }
                        vector = new Vector(directoryRow2.getNumberOfRows());
                        int n = 1;
                        while (n <= directoryRow2.getNumberOfRows()) {
                            HostData hostData = new HostData();
                            hostData.setNetworkAddress(directoryRow2.getColumn(this.hostsColumnAddr, n));
                            hostData.setHostName(directoryRow2.getColumn(this.hostsColumnCname, n));
                            hostData.setAliases(directoryRow2.getColumn(this.hostsColumnAliases, n));
                            hostData.setDescription(directoryRow2.getColumn(this.hostsColumnComment, n));
                            hostData.setEthernetAddress(this.getEtherAddrByHost(hostData.getHostName()));
                            vector.addElement(hostData);
                            ++n;
                        }
                        break block12;
                    }
                    catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                        break block12;
                    }
                    catch (DirectoryTableAccessException directoryTableAccessException) {
                        HostException hostException = new HostException("EXM_HST_SRV30");
                        throw new HostException("EXM_HST_SRV20", (Exception)((Object)hostException));
                    }
                    catch (DirectoryTableConnectionException directoryTableConnectionException) {
                        HostException hostException = new HostException("EXM_HST_SRV31");
                        throw new HostException("EXM_HST_SRV20", (Exception)((Object)hostException));
                    }
                    catch (DirectoryTableException directoryTableException) {
                        HostException hostException = new HostException("EXM_HST_SRV32");
                        throw new HostException("EXM_HST_SRV20", (Exception)((Object)hostException));
                    }
                    catch (HostException hostException) {
                        throw new HostException("EXM_HST_SRV20", (Exception)((Object)hostException));
                    }
                    catch (Exception exception) {
                        HostException hostException = new HostException("EXM_HST_SRV99", exception);
                        throw new HostException("EXM_HST_SRV20", (Exception)((Object)hostException));
                    }
                }
                catch (Throwable throwable) {
                    Object var12_11 = null;
                    if (directoryTable == null) throw throwable;
                    directoryTable.close();
                    throw throwable;
                }
            }
            directoryTable.close();
            return vector2;
        }
        Object var12_10 = null;
        if (directoryTable == null) return vector;
        directoryTable.close();
        return vector;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getNetmask(NetworkData networkData) throws RemoteException, AdminException, HostAuthException {
        this.checkRights("solaris.network.hosts.read");
        DirectoryFilter directoryFilter = new DirectoryFilter(2);
        DirectoryTable directoryTable = null;
        String string = "";
        try {
            try {
                directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
                TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                tableDefinitions.loadTableDefinitions("netmasks");
                directoryTable.open(tableDefinitions);
                directoryFilter.add(this.netmasksColumnAddr, 1, 5, networkData.getNetId());
                directoryFilter.add(this.netmasksColumnAddr, 3, 3, String.valueOf(networkData.getNetId()) + ".");
                DirectoryRow directoryRow = directoryTable.getFirstRow((SearchTemplate)directoryFilter);
                if (directoryRow != null) {
                    string = directoryRow.getColumn(this.netmasksColumnMask);
                }
            }
            catch (DirectoryTableRowNotFoundException directoryTableRowNotFoundException) {
                HostException hostException = new HostException("EXM_HST_SRV43");
                throw new HostException("EXM_HST_SRV8", (Exception)((Object)hostException));
            }
            catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                HostException hostException = new HostException("EXM_HST_SRV30", (Exception)((Object)directoryTableAccessException));
                throw new HostException("EXM_HST_SRV8", (Exception)((Object)hostException));
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                HostException hostException = new HostException("EXM_HST_SRV31", (Exception)((Object)directoryTableConnectionException));
                throw new HostException("EXM_HST_SRV8", (Exception)((Object)hostException));
            }
            catch (DirectoryTableException directoryTableException) {
                HostException hostException = new HostException("EXM_HST_SRV32");
                throw new HostException("EXM_HST_SRV8", (Exception)((Object)hostException));
            }
            catch (Exception exception) {
                HostException hostException = new HostException("EXM_HST_SRV99", exception);
                throw new HostException("EXM_HST_SRV8", (Exception)((Object)hostException));
            }
            Object var9_15 = null;
            if (directoryTable == null) return string;
        }
        catch (Throwable throwable) {
            Object var9_16 = null;
            if (directoryTable == null) throw throwable;
            directoryTable.close();
            throw throwable;
        }
        directoryTable.close();
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public NetworkData getNetwork(NetworkData networkData) throws HostAuthException, RemoteException, AdminException {
        this.checkRights("solaris.network.hosts.read");
        DirectoryTable directoryTable = null;
        NetworkData networkData2 = null;
        String string = "";
        String string2 = null;
        string2 = networkData.getNetworkName();
        if (string2 == null || string2.length() == 0) {
            throw new HostException("EXM_HST_CMM7");
        }
        try {
            try {
                directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
                TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                tableDefinitions.loadTableDefinitions("networks");
                directoryTable.open(tableDefinitions);
                DirectoryRow directoryRow = directoryTable.getRowInstance();
                directoryRow.putColumn(this.networksColumnCname, string2);
                DirectoryRow directoryRow2 = directoryTable.getAll((SearchTemplate)directoryRow);
                if (directoryRow2 != null) {
                    networkData2 = new NetworkData(directoryRow2.getColumn(this.networksColumnAddr));
                    networkData2.setNetworkName(directoryRow2.getColumn(this.networksColumnCname));
                    networkData2.setAliases(directoryRow2.getColumn(this.networksColumnAliases));
                    networkData2.setDescription(directoryRow2.getColumn(this.networksColumnComment));
                    string = this.getNetmask(networkData2);
                    networkData2.setNetmask(string);
                }
            }
            catch (DirectoryTableRowNotFoundException directoryTableRowNotFoundException) {
                HostException hostException = new HostException("EXM_HST_SRV42");
                throw new HostException("EXM_HST_SRV1", (Exception)((Object)hostException));
            }
            catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                HostException hostException = new HostException("EXM_HST_SRV30");
                throw new HostException("EXM_HST_SRV1", (Exception)((Object)hostException));
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                HostException hostException = new HostException("EXM_HST_SRV31");
                throw new HostException("EXM_HST_SRV1", (Exception)((Object)hostException));
            }
            catch (DirectoryTableException directoryTableException) {
                HostException hostException = new HostException("EXM_HST_SRV32");
                throw new HostException("EXM_HST_SRV1", (Exception)((Object)hostException));
            }
            catch (Exception exception) {
                HostException hostException = new HostException("EXM_HST_SRV99", exception);
                throw new HostException("EXM_HST_SRV1", (Exception)((Object)hostException));
            }
            Object var10_15 = null;
            if (directoryTable == null) return networkData2;
        }
        catch (Throwable throwable) {
            Object var10_16 = null;
            if (directoryTable == null) throw throwable;
            directoryTable.close();
            throw throwable;
        }
        directoryTable.close();
        return networkData2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public NetworkData getNetworkByAddr(String string) throws RemoteException, AdminException, HostAuthException {
        this.checkRights("solaris.network.hosts.read");
        Object var2_2 = null;
        DirectoryTable directoryTable = null;
        NetworkData networkData = new NetworkData();
        try {
            try {
                directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
                TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                tableDefinitions.loadTableDefinitions("networks");
                directoryTable.open(tableDefinitions);
                DirectoryRow directoryRow = directoryTable.getRowInstance();
                directoryRow.putColumn(this.networksColumnAddr, string);
                DirectoryRow directoryRow2 = directoryTable.getFirstRow((SearchTemplate)directoryRow);
                if (directoryRow2 == null) {
                    networkData.setNetworkAddress(string);
                    if (networkData.isNetwork()) {
                        networkData.setNetmask(this.getNetmask(networkData));
                        if (networkData.getNetmask().length() == 0) {
                            networkData = null;
                        }
                    } else {
                        networkData = null;
                    }
                } else {
                    networkData.setNetworkAddress(directoryRow2.getColumn(this.networksColumnAddr));
                    networkData.setNetworkName(directoryRow2.getColumn(this.networksColumnCname));
                    networkData.setAliases(directoryRow2.getColumn(this.networksColumnAliases));
                    networkData.setDescription(directoryRow2.getColumn(this.networksColumnComment));
                    if (networkData.isNetwork()) {
                        networkData.setNetmask(this.getNetmask(networkData));
                    }
                }
            }
            catch (DirectoryTableRowNotFoundException directoryTableRowNotFoundException) {
                HostException hostException = new HostException("EXM_HST_SRV42");
                throw new HostException("EXM_HST_SRV1", (Exception)((Object)hostException));
            }
            catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                HostException hostException = new HostException("EXM_HST_SRV30");
                throw new HostException("EXM_HST_SRV1", (Exception)((Object)hostException));
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                HostException hostException = new HostException("EXM_HST_SRV31");
                throw new HostException("EXM_HST_SRV1", (Exception)((Object)hostException));
            }
            catch (DirectoryTableException directoryTableException) {
                HostException hostException = new HostException("EXM_HST_SRV32");
                throw new HostException("EXM_HST_SRV1", (Exception)((Object)hostException));
            }
            catch (HostException hostException) {
                throw new HostException("EXM_HST_SRV1", (Exception)((Object)hostException));
            }
            catch (Exception exception) {
                HostException hostException = new HostException("EXM_HST_SRV99", exception);
                throw new HostException("EXM_HST_SRV1", (Exception)((Object)hostException));
            }
            Object var10_15 = null;
            if (directoryTable == null) return networkData;
        }
        catch (Throwable throwable) {
            Object var10_16 = null;
            if (directoryTable == null) throw throwable;
            directoryTable.close();
            throw throwable;
        }
        directoryTable.close();
        return networkData;
    }

    public String getTemplateByAddress(String string) throws RemoteException, AdminException, DirectoryTableException, HostAuthException {
        this.checkRights("solaris.network.security.read");
        DirectoryTable directoryTable = null;
        String string2 = null;
        try {
            directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
            TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
            tableDefinitions.loadTableDefinitions("tnrhdb");
            try {
                directoryTable.open(tableDefinitions);
            }
            catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                directoryTable.create(tableDefinitions);
            }
            string2 = this.insertEscapeChar(string, TNRHDB_DELIMITER);
            DirectoryRow directoryRow = directoryTable.getAll();
            if (directoryRow != null) {
                int n = 1;
                int n2 = directoryRow.getNumberOfRows() + 1;
                int n3 = 1;
                while (n != n2) {
                    String string3 = directoryRow.getColumn(this.tnrhdbColumnIpAddress, n);
                    if (string3.equals(string2)) {
                        return directoryRow.getColumn(this.tnrhdbColumnTemplateType, n);
                    }
                    n += n3;
                }
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public void initializeScope(AdminMgmtScope adminMgmtScope) throws RemoteException, AdminException {
        DirectoryTable directoryTable = null;
        String string = "unknown";
        TableDefinitions tableDefinitions = null;
        TableDefinitions tableDefinitions2 = null;
        TableDefinitions tableDefinitions3 = null;
        TableDefinitions tableDefinitions4 = null;
        TableDefinitions tableDefinitions5 = null;
        TableDefinitions tableDefinitions6 = null;
        this.scope = adminMgmtScope.toDirectoryTableURL();
        try {
            directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
            tableDefinitions = directoryTable.getTableDefinitionsInstance();
            string = "ethers";
            tableDefinitions.loadTableDefinitions("ethers");
            this.ethersColumnAddr = tableDefinitions.getColumnNumber("addr");
            this.ethersColumnName = tableDefinitions.getColumnNumber("name");
            this.ethersColumnComment = tableDefinitions.getColumnNumber("comment");
            tableDefinitions2 = directoryTable.getTableDefinitionsInstance();
            string = "hosts";
            tableDefinitions2.loadTableDefinitions("hosts");
            this.hostsColumnAddr = tableDefinitions2.getColumnNumber("addr");
            this.hostsColumnCname = tableDefinitions2.getColumnNumber("cname");
            this.hostsColumnAliases = tableDefinitions2.getColumnNumber("aliases");
            this.hostsColumnComment = tableDefinitions2.getColumnNumber("comment");
            tableDefinitions3 = directoryTable.getTableDefinitionsInstance();
            string = "netmasks";
            tableDefinitions3.loadTableDefinitions("netmasks");
            this.netmasksColumnAddr = tableDefinitions3.getColumnNumber("addr");
            this.netmasksColumnMask = tableDefinitions3.getColumnNumber("mask");
            this.netmasksColumnComment = tableDefinitions3.getColumnNumber("comment");
            tableDefinitions6 = directoryTable.getTableDefinitionsInstance();
            string = "tnrhdb";
            tableDefinitions6.loadTableDefinitions("tnrhdb");
            this.tnrhdbColumnIpAddress = tableDefinitions6.getColumnNumber("addr");
            this.tnrhdbColumnTemplateType = tableDefinitions6.getColumnNumber("name");
            tableDefinitions5 = directoryTable.getTableDefinitionsInstance();
            string = "tnrhtp";
            tableDefinitions5.loadTableDefinitions("tnrhtp");
            this.templateColumnName = tableDefinitions5.getColumnNumber("name");
            this.templateColumnAttr = tableDefinitions5.getColumnNumber("attributes");
            tableDefinitions4 = directoryTable.getTableDefinitionsInstance();
            string = "networks";
            tableDefinitions4.loadTableDefinitions("networks");
            this.networksColumnCname = tableDefinitions4.getColumnNumber("cname");
            this.networksColumnAddr = tableDefinitions4.getColumnNumber("addr");
            this.networksColumnAliases = tableDefinitions4.getColumnNumber("aliases");
            this.networksColumnComment = tableDefinitions4.getColumnNumber("comment");
        }
        catch (DirectoryTableAccessException directoryTableAccessException) {
            HostException hostException = new HostException("EXM_HST_SRV30");
            throw new HostException("EXM_HST_SRV68", (Exception)((Object)hostException));
        }
        catch (DirectoryTableConnectionException directoryTableConnectionException) {
            HostException hostException = new HostException("EXM_HST_SRV31");
            throw new HostException("EXM_HST_SRV68", (Exception)((Object)hostException));
        }
        catch (DirectoryTableException directoryTableException) {
            HostException hostException = new HostException("EXM_HST_SRV32");
            throw new HostException("EXM_HST_SRV68", (Exception)((Object)hostException));
        }
    }

    private String insertEscapeChar(String string, String string2) {
        int n = 0;
        int n2 = -1;
        StringBuffer stringBuffer = new StringBuffer(string);
        String string3 = string;
        n2 = string3.indexOf(string2, n);
        while (n2 != -1) {
            stringBuffer.insert(n2, '\\');
            n = n2 + 2;
            string3 = stringBuffer.toString();
            n2 = -1;
            n2 = string3.indexOf(string2, n);
        }
        return stringBuffer.toString();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void listHostNetworks(QuickVector var1_1) throws RemoteException, AdminException, HostAuthException {
        block21: {
            block20: {
                this.checkRights("solaris.network.hosts.read");
                var4_2 = 0;
                var7_3 = null;
                try {
                    try {
                        var7_3 = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
                        var11_4 = var7_3.getTableDefinitionsInstance();
                        var11_4.loadTableDefinitions("hosts");
                        var7_3.open(var11_4);
                        var6_5 = var7_3.getAll();
                        if (var6_5 == null) {
                            var13_6 = null;
                            if (var7_3 == null) return;
                            break block20;
                        }
                        var10_9 = var1_1.size() > 0 ? (NetworkData)var1_1.quickElementAt(0) : new NetworkData("255");
                        var14_10 = 1;
                        block11: while (var14_10 <= var6_5.getNumberOfRows()) {
                            block22: {
                                try {
                                    NetworkData.validateIPAddress(var6_5.getColumn(this.hostsColumnAddr, var14_10));
                                }
                                catch (Exception v0) {
                                    ** GOTO lbl41
                                }
                                var9_16 = new NetworkData(var6_5.getColumn(this.hostsColumnAddr, var14_10));
                                if (var9_16.netIdCompare(var10_9) == 0) ** GOTO lbl41
                                var4_2 = 0;
                                if (var4_2 >= var1_1.size()) break block22;
                                var3_14 = false;
                                var2_13 = false;
                                var10_9 = (NetworkData)var1_1.quickElementAt(var4_2);
                                if (true) ** GOTO lbl87
                            }
                            var2_13 = true;
lbl34:
                            // 2 sources

                            while (true) {
                                if (var2_13) {
                                    if (!var9_16.isNetwork()) {
                                        var9_16.setNetworkAddress(var9_16.getNetId());
                                    }
                                    var9_16.setNetmask(this.getNetmask(var9_16));
                                    var1_1.insertElementAt(var9_16, var4_2);
                                    var10_9 = var9_16;
                                }
lbl41:
                                // 5 sources

                                ++var14_10;
                                continue block11;
                                break;
                            }
                        }
                        break block21;
                    }
                    catch (DirectoryTableDoesNotExistException v1) {
                        break block21;
                    }
                    catch (DirectoryTableAccessException v2) {
                        var8_17 = new HostException("EXM_HST_SRV30");
                        throw new HostException("EXM_HST_SRV2", (Exception)var8_17);
                    }
                    catch (DirectoryTableConnectionException v3) {
                        var8_18 = new HostException("EXM_HST_SRV31");
                        throw new HostException("EXM_HST_SRV2", (Exception)var8_18);
                    }
                    catch (DirectoryTableException v4) {
                        var8_19 = new HostException("EXM_HST_SRV32");
                        throw new HostException("EXM_HST_SRV2", (Exception)var8_19);
                    }
                    catch (HostException var14_11) {
                        throw new HostException("EXM_HST_SRV2", (Exception)var14_11);
                    }
                    catch (Exception var14_12) {
                        var8_20 = new HostException("EXM_HST_SRV99", var14_12);
                        throw new HostException("EXM_HST_SRV2", (Exception)var8_20);
                    }
                }
                catch (Throwable var12_21) {
                    var13_8 = null;
                    if (var7_3 == null) throw var12_21;
                    var7_3.close();
                    throw var12_21;
                }
            }
            var7_3.close();
            return;
        }
        var13_7 = null;
        if (var7_3 == null) return;
        var7_3.close();
        return;
        do {
            if ((var5_15 = var9_16.netIdCompare(var10_9)) == 0) {
                var3_14 = true;
                continue;
            }
            if (var5_15 > 0) {
                if (++var4_2 < var1_1.size()) {
                    var10_9 = (NetworkData)var1_1.quickElementAt(var4_2);
                    continue;
                }
                var2_13 = true;
                var3_14 = true;
                continue;
            }
            var2_13 = true;
            var3_14 = true;
lbl87:
            // 5 sources

        } while (!var3_14);
        ** while (true)
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Vector listHostSubnets(QuickVector quickVector, NetworkData networkData) throws RemoteException, AdminException, HostAuthException {
        this.checkRights("solaris.network.hosts.read");
        int n = 0;
        DirectoryTable directoryTable = null;
        NetworkData networkData2 = new NetworkData();
        long l = networkData.getNetmaskLong();
        if (l == 0L) {
            return quickVector;
        }
        String string = networkData.getNetId();
        try {
            try {
                directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
                TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                tableDefinitions.loadTableDefinitions("hosts");
                directoryTable.open(tableDefinitions);
                DirectoryRow directoryRow = directoryTable.getAll();
                if (directoryRow != null) {
                    n = directoryRow.getNumberOfRows();
                }
                int n2 = 1;
                while (n2 <= n) {
                    block19: {
                        String string2 = directoryRow.getColumn(this.hostsColumnAddr, n2);
                        try {
                            NetworkData.validateIPAddress(string2);
                        }
                        catch (Exception exception) {
                            break block19;
                        }
                        if (string2.startsWith(String.valueOf(string) + ".")) {
                            networkData2.setNetworkAddress(string2);
                            long l2 = l & networkData2.getNetworkAddressLong();
                            networkData2.setNetworkAddress(networkData2.convertLongToAddress(l2));
                            if (!networkData2.isNetwork()) {
                                int n3 = quickVector.size();
                                int n4 = 0;
                                while (n4 < quickVector.size()) {
                                    NetworkData networkData3 = (NetworkData)quickVector.quickElementAt(n4);
                                    int n5 = networkData3.netAddrCompare(networkData2);
                                    if (n5 == 0) {
                                        n3 = -1;
                                        break;
                                    }
                                    if (n5 > 0) {
                                        n3 = n4;
                                        break;
                                    }
                                    ++n4;
                                }
                                if (n3 >= 0) {
                                    quickVector.insertElementAt(networkData2, n3);
                                    networkData2.setNetmaskForSubnet(networkData.getNetmask());
                                    networkData2 = new NetworkData();
                                }
                            }
                        }
                    }
                    ++n2;
                }
            }
            catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                HostException hostException = new HostException("EXM_HST_SRV30");
                throw new HostException("EXM_HST_SRV3", (Exception)((Object)hostException));
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                HostException hostException = new HostException("EXM_HST_SRV31");
                throw new HostException("EXM_HST_SRV3", (Exception)((Object)hostException));
            }
            catch (DirectoryTableException directoryTableException) {
                HostException hostException = new HostException("EXM_HST_SRV32");
                throw new HostException("EXM_HST_SRV3", (Exception)((Object)hostException));
            }
            catch (Exception exception) {
                HostException hostException = new HostException("EXM_HST_SRV99", exception);
                throw new HostException("EXM_HST_SRV3", (Exception)((Object)hostException));
            }
            Object var19_22 = null;
            if (directoryTable == null) return quickVector;
        }
        catch (Throwable throwable) {
            Object var19_23 = null;
            if (directoryTable == null) throw throwable;
            directoryTable.close();
            throw throwable;
        }
        directoryTable.close();
        return quickVector;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Vector listHosts(ListProperties listProperties) throws RemoteException, AdminException, HostAuthException {
        this.checkRights("solaris.network.hosts.read");
        Object var2_2 = null;
        if (listProperties == null) {
            throw new HostException("EXM_HST_SRV21", (Exception)((Object)new HostException("EXM_HST_SRV99")));
        }
        int n = 0;
        DirectoryRow directoryRow = null;
        DirectoryTable directoryTable = null;
        HostData hostData = null;
        QuickVector quickVector = null;
        try {
            try {
                int n2;
                int n3;
                int n4;
                DirectoryRow directoryRow2;
                directoryRow = this.cacheEthersList();
                directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
                TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                tableDefinitions.loadTableDefinitions("hosts");
                TableDefinitions tableDefinitions2 = directoryTable.getTableDefinitionsInstance();
                tableDefinitions2.loadTableDefinitions("ethers");
                directoryTable.open(tableDefinitions);
                Vector vector = listProperties.getFilters();
                if (vector != null && !vector.isEmpty()) {
                    DirectoryFilter directoryFilter = new DirectoryFilter(vector.size());
                    int n5 = 0;
                    while (n5 < vector.size()) {
                        FilterItem filterItem = (FilterItem)vector.elementAt(n5);
                        directoryFilter.add(this.mapHostColumnToNum(filterItem.getAttribute()), filterItem.getBooleanOperator(), filterItem.getOperator(), filterItem.getValue());
                        ++n5;
                    }
                    directoryRow2 = directoryTable.getAll((SearchTemplate)directoryFilter);
                } else {
                    directoryRow2 = directoryTable.getAll();
                }
                if (directoryRow2 != null) {
                    directoryRow2.sortByColumn(this.mapHostColumnToNum(listProperties.getSortColumn()), tableDefinitions);
                    quickVector = new QuickVector(directoryRow2.getNumberOfRows());
                    quickVector.setSize(directoryRow2.getNumberOfRows());
                    if (listProperties.isSortOrderAscending()) {
                        n4 = 1;
                        n3 = directoryRow2.getNumberOfRows() + 1;
                        n2 = 1;
                    } else {
                        n4 = directoryRow2.getNumberOfRows();
                        n3 = 0;
                        n2 = -1;
                    }
                } else {
                    quickVector = new QuickVector(0);
                    quickVector.setSize(0);
                    n2 = 0;
                    n3 = 0;
                    n4 = 0;
                }
                while (n4 != n3) {
                    hostData = new HostData();
                    hostData.setNetworkAddress(directoryRow2.getColumn(this.hostsColumnAddr, n4));
                    hostData.setHostName(directoryRow2.getColumn(this.hostsColumnCname, n4));
                    hostData.setAliases(directoryRow2.getColumn(this.hostsColumnAliases, n4));
                    hostData.setDescription(directoryRow2.getColumn(this.hostsColumnComment, n4));
                    if (directoryRow != null) {
                        DirectoryRow directoryRow3 = directoryTable.getRowInstance();
                        directoryRow3.putColumn(this.ethersColumnName, hostData.getHostName());
                        int n6 = directoryRow.getFirstRow((SearchTemplate)directoryRow3, tableDefinitions2);
                        if (n6 > 0) {
                            hostData.setEthernetAddress(directoryRow.getColumn(this.ethersColumnAddr, n6));
                        }
                    }
                    quickVector.quickSetElementAt((Object)hostData, n++);
                    n4 += n2;
                }
            }
            catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                HostException hostException = new HostException("EXM_HST_SRV30");
                throw new HostException("EXM_HST_SRV21", (Exception)((Object)hostException));
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                HostException hostException = new HostException("EXM_HST_SRV31");
                throw new HostException("EXM_HST_SRV21", (Exception)((Object)hostException));
            }
            catch (DirectoryTableException directoryTableException) {
                HostException hostException = new HostException("EXM_HST_SRV32");
                throw new HostException("EXM_HST_SRV21", (Exception)((Object)hostException));
            }
            catch (HostException hostException) {
                throw new HostException("EXM_HST_SRV21", (Exception)((Object)hostException));
            }
            catch (Exception exception) {
                HostException hostException = new HostException("EXM_HST_SRV99", exception);
                throw new HostException("EXM_HST_SRV21", (Exception)((Object)hostException));
            }
            Object var21_26 = null;
            if (directoryTable == null) return quickVector;
        }
        catch (Throwable throwable) {
            Object var21_27 = null;
            if (directoryTable == null) throw throwable;
            directoryTable.close();
            throw throwable;
        }
        directoryTable.close();
        return quickVector;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Vector listHostsByNetwork(NetworkData networkData, ListProperties listProperties) throws RemoteException, AdminException, HostAuthException {
        Vector<HostData> vector;
        DirectoryTable directoryTable;
        block23: {
            Vector vector2;
            block22: {
                this.checkRights("solaris.network.hosts.read");
                Object var3_3 = null;
                if (listProperties == null) {
                    throw new HostException("EXM_HST_SRV21", (Exception)((Object)new HostException("EXM_HST_SRV99")));
                }
                if (networkData == null) {
                    return this.listHosts(listProperties);
                }
                boolean bl = false;
                directoryTable = null;
                HostData hostData = null;
                vector = null;
                try {
                    try {
                        int n;
                        int n2;
                        int n3;
                        DirectoryFilter directoryFilter;
                        if (!networkData.isNetwork()) {
                            networkData.setNetmask(this.getNetmask(networkData));
                            if (networkData.getNetmask().length() == 0) {
                                throw new HostException("EXM_HST_SRV26");
                            }
                            if (networkData.getNetmaskShiftCount() % 8 != 0) {
                                bl = true;
                            }
                        }
                        directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
                        TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                        tableDefinitions.loadTableDefinitions("hosts");
                        directoryTable.open(tableDefinitions);
                        if (bl) {
                            directoryFilter = new DirectoryFilter(2);
                            String string = networkData.convertLongToAddress(networkData.getNetworkAddressLong() - 1L);
                            String string2 = networkData.convertLongToAddress(networkData.getNetworkAddressLong() + (long)(1 << networkData.getNetmaskShiftCount()));
                            directoryFilter.add(this.hostsColumnAddr, 1, 8, string);
                            directoryFilter.add(this.hostsColumnAddr, 2, 7, string2);
                        } else {
                            directoryFilter = new DirectoryFilter(1);
                            String string = networkData.convertLongToAddress(networkData.getNetworkAddressLong());
                            directoryFilter.add(this.hostsColumnAddr, 1, 3, String.valueOf(string) + ".");
                        }
                        DirectoryRow directoryRow = directoryTable.getAll((SearchTemplate)directoryFilter);
                        if (directoryRow == null) {
                            vector2 = new Vector();
                            Object var21_15 = null;
                            if (directoryTable == null) return vector2;
                            break block22;
                        }
                        directoryRow.sortByColumn(this.mapHostColumnToNum(listProperties.getSortColumn()), tableDefinitions);
                        vector = new Vector<HostData>(directoryRow.getNumberOfRows());
                        if (listProperties.isSortOrderAscending()) {
                            n3 = 1;
                            n2 = directoryRow.getNumberOfRows() + 1;
                            n = 1;
                        } else {
                            n3 = directoryRow.getNumberOfRows();
                            n2 = 0;
                            n = -1;
                        }
                        while (n3 != n2) {
                            hostData = new HostData();
                            try {
                                HostData.validateIPAddress(directoryRow.getColumn(this.hostsColumnAddr, n3));
                            }
                            catch (Exception exception) {
                                n3 += n;
                                continue;
                            }
                            hostData.setNetworkAddress(directoryRow.getColumn(this.hostsColumnAddr, n3));
                            hostData.setHostName(directoryRow.getColumn(this.hostsColumnCname, n3));
                            hostData.setAliases(directoryRow.getColumn(this.hostsColumnAliases, n3));
                            hostData.setDescription(directoryRow.getColumn(this.hostsColumnComment, n3));
                            hostData.setEthernetAddress(this.getEtherAddrByHost(hostData.getHostName()));
                            vector.addElement(hostData);
                            n3 += n;
                        }
                        break block23;
                    }
                    catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                        break block23;
                    }
                    catch (DirectoryTableAccessException directoryTableAccessException) {
                        HostException hostException = new HostException("EXM_HST_SRV30");
                        throw new HostException("EXM_HST_SRV4", (Exception)((Object)hostException));
                    }
                    catch (DirectoryTableConnectionException directoryTableConnectionException) {
                        HostException hostException = new HostException("EXM_HST_SRV31");
                        throw new HostException("EXM_HST_SRV4", (Exception)((Object)hostException));
                    }
                    catch (DirectoryTableException directoryTableException) {
                        HostException hostException = new HostException("EXM_HST_SRV32");
                        throw new HostException("EXM_HST_SRV4", (Exception)((Object)hostException));
                    }
                    catch (HostException hostException) {
                        throw new HostException("EXM_HST_SRV4", (Exception)((Object)hostException));
                    }
                    catch (Exception exception) {
                        HostException hostException = new HostException("EXM_HST_SRV99", exception);
                        throw new HostException("EXM_HST_SRV4", (Exception)((Object)hostException));
                    }
                }
                catch (Throwable throwable) {
                    Object var21_17 = null;
                    if (directoryTable == null) throw throwable;
                    directoryTable.close();
                    throw throwable;
                }
            }
            directoryTable.close();
            return vector2;
        }
        Object var21_16 = null;
        if (directoryTable == null) return vector;
        directoryTable.close();
        return vector;
    }

    public void listHostsByNetworkEnd() throws RemoteException, AdminException, HostAuthException {
        this.checkRights("solaris.network.hosts.read");
        this.hostListRow = null;
        this.hostListIndex = this.hostListLimit;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Vector listHostsByNetworkNext() throws RemoteException, AdminException, HostAuthException {
        this.checkRights("solaris.network.hosts.read");
        int n = this.chunkSize;
        Vector<HostData> vector = new Vector<HostData>(this.chunkSize);
        if (this.hostListIndex == this.hostListLimit) {
            return new Vector();
        }
        try {
            while (n > 0) {
                if (this.hostListIndex == this.hostListLimit) {
                    return vector;
                }
                HostData hostData = new HostData();
                try {
                    HostData.validateIPAddress(this.hostListRow.getColumn(this.hostsColumnAddr, this.hostListIndex));
                }
                catch (Exception exception) {
                    this.hostListIndex += this.hostListIncrement;
                    continue;
                }
                hostData.setNetworkAddress(this.hostListRow.getColumn(this.hostsColumnAddr, this.hostListIndex));
                hostData.setHostName(this.hostListRow.getColumn(this.hostsColumnCname, this.hostListIndex));
                hostData.setAliases(this.hostListRow.getColumn(this.hostsColumnAliases, this.hostListIndex));
                hostData.setDescription(this.hostListRow.getColumn(this.hostsColumnComment, this.hostListIndex));
                hostData.setEthernetAddress(this.getEtherAddrByHost(hostData.getHostName()));
                vector.addElement(hostData);
                --n;
                this.hostListIndex += this.hostListIncrement;
            }
            return vector;
        }
        catch (DirectoryTableException directoryTableException) {
            HostException hostException = new HostException("EXM_HST_SRV32");
            throw new HostException("EXM_HST_SRV4", (Exception)((Object)hostException));
        }
        catch (Exception exception) {
            HostException hostException = new HostException("EXM_HST_SRV99", exception);
            throw new HostException("EXM_HST_SRV4", (Exception)((Object)hostException));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int listHostsByNetworkPrime(NetworkData networkData, ListProperties listProperties) throws RemoteException, AdminException, HostAuthException {
        DirectoryTable directoryTable;
        DirectoryRow directoryRow;
        block20: {
            int n;
            block19: {
                this.checkRights("solaris.network.hosts.read");
                Object var3_3 = null;
                boolean bl = false;
                directoryRow = null;
                directoryTable = null;
                Object var8_7 = null;
                if (listProperties == null) throw new HostException("EXM_HST_SRV21", (Exception)((Object)new HostException("EXM_HST_SRV99")));
                if (listProperties.getChunkSize() < 1) {
                    throw new HostException("EXM_HST_SRV21", (Exception)((Object)new HostException("EXM_HST_SRV99")));
                }
                if (networkData == null) {
                    throw new HostException("EXM_HST_SRV21", (Exception)((Object)new HostException("EXM_HST_SRV99")));
                }
                this.chunkSize = listProperties.getChunkSize();
                this.sortAscending = listProperties.isSortOrderAscending();
                try {
                    try {
                        DirectoryFilter directoryFilter;
                        if (!networkData.isNetwork()) {
                            networkData.setNetmask(this.getNetmask(networkData));
                            if (networkData.getNetmask().length() == 0) {
                                throw new HostException("EXM_HST_SRV26");
                            }
                            if (networkData.getNetmaskShiftCount() % 8 != 0) {
                                bl = true;
                            }
                        }
                        directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
                        TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                        tableDefinitions.loadTableDefinitions("hosts");
                        directoryTable.open(tableDefinitions);
                        if (bl) {
                            directoryFilter = new DirectoryFilter(2);
                            String string = networkData.convertLongToAddress(networkData.getNetworkAddressLong() - 1L);
                            String string2 = networkData.convertLongToAddress(networkData.getNetworkAddressLong() + (long)(1 << networkData.getNetmaskShiftCount()));
                            directoryFilter.add(this.hostsColumnAddr, 1, 8, string);
                            directoryFilter.add(this.hostsColumnAddr, 2, 7, string2);
                        } else {
                            directoryFilter = new DirectoryFilter(1);
                            String string = networkData.convertLongToAddress(networkData.getNetworkAddressLong());
                            directoryFilter.add(this.hostsColumnAddr, 1, 3, String.valueOf(string) + ".");
                        }
                        this.hostListRow = directoryRow = directoryTable.getAll((SearchTemplate)directoryFilter);
                        if (directoryRow == null) {
                            n = 0;
                            Object var17_14 = null;
                            if (directoryTable == null) return n;
                            break block19;
                        }
                        directoryRow.sortByColumn(this.mapHostColumnToNum(listProperties.getSortColumn()), tableDefinitions);
                        if (this.sortAscending) {
                            this.hostListIndex = 1;
                            this.hostListLimit = directoryRow.getNumberOfRows() + 1;
                            this.hostListIncrement = 1;
                            break block20;
                        } else {
                            this.hostListIndex = directoryRow.getNumberOfRows();
                            this.hostListLimit = 0;
                            this.hostListIncrement = -1;
                        }
                        break block20;
                    }
                    catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                        break block20;
                    }
                    catch (DirectoryTableAccessException directoryTableAccessException) {
                        HostException hostException = new HostException("EXM_HST_SRV30");
                        throw new HostException("EXM_HST_SRV4", (Exception)((Object)hostException));
                    }
                    catch (DirectoryTableConnectionException directoryTableConnectionException) {
                        HostException hostException = new HostException("EXM_HST_SRV31");
                        throw new HostException("EXM_HST_SRV4", (Exception)((Object)hostException));
                    }
                    catch (DirectoryTableException directoryTableException) {
                        HostException hostException = new HostException("EXM_HST_SRV32");
                        throw new HostException("EXM_HST_SRV4", (Exception)((Object)hostException));
                    }
                    catch (HostException hostException) {
                        throw new HostException("EXM_HST_SRV4", (Exception)((Object)hostException));
                    }
                    catch (Exception exception) {
                        HostException hostException = new HostException("EXM_HST_SRV99", exception);
                        throw new HostException("EXM_HST_SRV4", (Exception)((Object)hostException));
                    }
                }
                catch (Throwable throwable) {
                    Object var17_16 = null;
                    if (directoryTable == null) throw throwable;
                    directoryTable.close();
                    throw throwable;
                }
            }
            directoryTable.close();
            return n;
        }
        Object var17_15 = null;
        if (directoryTable == null) return directoryRow.getNumberOfRows();
        directoryTable.close();
        return directoryRow.getNumberOfRows();
    }

    public void listHostsEnd() throws RemoteException, AdminException, HostAuthException {
        this.checkRights("solaris.network.hosts.read");
        this.hostListRow = null;
        this.hostListIndex = this.hostListLimit;
        this.etherListRow = null;
        this.ethersTableDefn = null;
    }

    public Vector listHostsNext() throws RemoteException, AdminException, HostAuthException {
        this.checkRights("solaris.network.hosts.read");
        int n = this.chunkSize;
        int n2 = 0;
        HostData hostData = null;
        QuickVector quickVector = new QuickVector(this.chunkSize);
        try {
            quickVector.setSize(this.chunkSize);
            while (n > 0 && this.hostListIndex != this.hostListLimit) {
                hostData = new HostData();
                hostData.setNetworkAddress(this.hostListRow.getColumn(this.hostsColumnAddr, this.hostListIndex));
                hostData.setHostName(this.hostListRow.getColumn(this.hostsColumnCname, this.hostListIndex));
                hostData.setAliases(this.hostListRow.getColumn(this.hostsColumnAliases, this.hostListIndex));
                hostData.setDescription(this.hostListRow.getColumn(this.hostsColumnComment, this.hostListIndex));
                if (this.etherListRow != null && this.ethersTableDefn != null) {
                    this.etherMatchRow.putColumn(this.ethersColumnName, hostData.getHostName());
                    int n3 = this.etherListRow.getFirstRow((SearchTemplate)this.etherMatchRow, this.ethersTableDefn);
                    if (n3 > 0) {
                        hostData.setEthernetAddress(this.etherListRow.getColumn(this.ethersColumnAddr, n3));
                    }
                }
                quickVector.quickSetElementAt((Object)hostData, n2++);
                --n;
                this.hostListIndex += this.hostListIncrement;
            }
        }
        catch (DirectoryTableException directoryTableException) {
            HostException hostException = new HostException("EXM_HST_SRV32");
            throw new HostException("EXM_HST_SRV21", (Exception)((Object)hostException));
        }
        catch (Exception exception) {
            HostException hostException = new HostException("EXM_HST_SRV99", exception);
            throw new HostException("EXM_HST_SRV21", (Exception)((Object)hostException));
        }
        if (n2 < this.chunkSize) {
            quickVector.setSize(n2);
        }
        return quickVector;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int listHostsPrime(ListProperties listProperties) throws RemoteException, AdminException, HostAuthException {
        DirectoryTable directoryTable;
        DirectoryRow directoryRow;
        block18: {
            int n;
            block17: {
                this.checkRights("solaris.network.hosts.read");
                Object var2_2 = null;
                directoryRow = null;
                directoryTable = null;
                if (listProperties == null) throw new HostException("EXM_HST_SRV21", (Exception)((Object)new HostException("EXM_HST_SRV99")));
                if (listProperties.getChunkSize() < 1) {
                    throw new HostException("EXM_HST_SRV21", (Exception)((Object)new HostException("EXM_HST_SRV99")));
                }
                this.chunkSize = listProperties.getChunkSize();
                this.sortAscending = listProperties.isSortOrderAscending();
                try {
                    try {
                        TableDefinitions tableDefinitions;
                        block16: {
                            this.etherListRow = this.cacheEthersList();
                            directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
                            tableDefinitions = directoryTable.getTableDefinitionsInstance();
                            tableDefinitions.loadTableDefinitions("hosts");
                            directoryTable.open(tableDefinitions);
                            Vector vector = listProperties.getFilters();
                            if (vector != null && !vector.isEmpty()) {
                                DirectoryFilter directoryFilter = new DirectoryFilter(vector.size());
                                int n2 = 0;
                                while (true) {
                                    if (n2 >= vector.size()) {
                                        directoryRow = directoryTable.getAll((SearchTemplate)directoryFilter);
                                        break block16;
                                    }
                                    FilterItem filterItem = (FilterItem)vector.elementAt(n2);
                                    directoryFilter.add(this.mapHostColumnToNum(filterItem.getAttribute()), filterItem.getBooleanOperator(), filterItem.getOperator(), filterItem.getValue());
                                    ++n2;
                                }
                            }
                            directoryRow = directoryTable.getAll();
                        }
                        this.hostListRow = directoryRow;
                        if (directoryRow == null) {
                            n = 0;
                            Object var12_13 = null;
                            if (directoryTable == null) return n;
                            break block17;
                        }
                        directoryRow.sortByColumn(this.mapHostColumnToNum(listProperties.getSortColumn()), tableDefinitions);
                        if (this.sortAscending) {
                            this.hostListIndex = 1;
                            this.hostListLimit = directoryRow.getNumberOfRows() + 1;
                            this.hostListIncrement = 1;
                            break block18;
                        } else {
                            this.hostListIndex = directoryRow.getNumberOfRows();
                            this.hostListLimit = 0;
                            this.hostListIncrement = -1;
                        }
                        break block18;
                    }
                    catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                        break block18;
                    }
                    catch (DirectoryTableAccessException directoryTableAccessException) {
                        HostException hostException = new HostException("EXM_HST_SRV30");
                        throw new HostException("EXM_HST_SRV21", (Exception)((Object)hostException));
                    }
                    catch (DirectoryTableConnectionException directoryTableConnectionException) {
                        HostException hostException = new HostException("EXM_HST_SRV31");
                        throw new HostException("EXM_HST_SRV21", (Exception)((Object)hostException));
                    }
                    catch (DirectoryTableException directoryTableException) {
                        HostException hostException = new HostException("EXM_HST_SRV32");
                        throw new HostException("EXM_HST_SRV21", (Exception)((Object)hostException));
                    }
                    catch (HostException hostException) {
                        throw new HostException("EXM_HST_SRV21", (Exception)((Object)hostException));
                    }
                    catch (Exception exception) {
                        HostException hostException = new HostException("EXM_HST_SRV99", exception);
                        throw new HostException("EXM_HST_SRV21", (Exception)((Object)hostException));
                    }
                }
                catch (Throwable throwable) {
                    Object var12_15 = null;
                    if (directoryTable == null) throw throwable;
                    directoryTable.close();
                    throw throwable;
                }
            }
            directoryTable.close();
            return n;
        }
        Object var12_14 = null;
        if (directoryTable == null) return directoryRow.getNumberOfRows();
        directoryTable.close();
        return directoryRow.getNumberOfRows();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void listNetmaskNetworks(QuickVector var1_1) throws RemoteException, AdminException, HostAuthException {
        block21: {
            block20: {
                this.checkRights("solaris.network.hosts.read");
                var4_2 = 0;
                var7_3 = null;
                try {
                    try {
                        var7_3 = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
                        var11_4 = var7_3.getTableDefinitionsInstance();
                        var11_4.loadTableDefinitions("netmasks");
                        var7_3.open(var11_4);
                        var6_5 = var7_3.getAll();
                        if (var6_5 == null) {
                            var13_6 = null;
                            if (var7_3 == null) return;
                            break block20;
                        }
                        var6_5.sortByColumn(this.netmasksColumnAddr, var11_4);
                        var10_9 = var1_1.size() > 0 ? (NetworkData)var1_1.quickElementAt(0) : new NetworkData("255");
                        var14_10 = 1;
                        block11: while (var14_10 <= var6_5.getNumberOfRows()) {
                            block22: {
                                try {
                                    NetworkData.validateIPAddress(var6_5.getColumn(this.netmasksColumnAddr, var14_10));
                                }
                                catch (Exception v0) {
                                    ** GOTO lbl39
                                }
                                var9_16 = new NetworkData(var6_5.getColumn(this.netmasksColumnAddr, var14_10));
                                if (var4_2 >= var1_1.size()) break block22;
                                var3_14 = false;
                                var2_13 = false;
                                if (true) ** GOTO lbl85
                            }
                            var2_13 = true;
lbl32:
                            // 2 sources

                            while (true) {
                                if (var2_13) {
                                    if (!var9_16.isNetwork()) {
                                        var9_16.setNetworkAddress(var9_16.getNetId());
                                    }
                                    var9_16.setNetmask(this.getNetmask(var9_16));
                                    var1_1.insertElementAt(var9_16, var4_2);
                                    var10_9 = var9_16;
                                }
lbl39:
                                // 4 sources

                                ++var14_10;
                                continue block11;
                                break;
                            }
                        }
                        break block21;
                    }
                    catch (DirectoryTableDoesNotExistException v1) {
                        break block21;
                    }
                    catch (DirectoryTableAccessException v2) {
                        var8_17 = new HostException("EXM_HST_SRV30");
                        throw new HostException("EXM_HST_SRV2", (Exception)var8_17);
                    }
                    catch (DirectoryTableConnectionException v3) {
                        var8_18 = new HostException("EXM_HST_SRV31");
                        throw new HostException("EXM_HST_SRV2", (Exception)var8_18);
                    }
                    catch (DirectoryTableException v4) {
                        var8_19 = new HostException("EXM_HST_SRV32");
                        throw new HostException("EXM_HST_SRV2", (Exception)var8_19);
                    }
                    catch (HostException var14_11) {
                        throw new HostException("EXM_HST_SRV2", (Exception)var14_11);
                    }
                    catch (Exception var14_12) {
                        var8_20 = new HostException("EXM_HST_SRV99", var14_12);
                        throw new HostException("EXM_HST_SRV2", (Exception)var8_20);
                    }
                }
                catch (Throwable var12_21) {
                    var13_8 = null;
                    if (var7_3 == null) throw var12_21;
                    var7_3.close();
                    throw var12_21;
                }
            }
            var7_3.close();
            return;
        }
        var13_7 = null;
        if (var7_3 == null) return;
        var7_3.close();
        return;
        do {
            if ((var5_15 = var9_16.netIdCompare(var10_9)) == 0) {
                var3_14 = true;
                continue;
            }
            if (var5_15 > 0) {
                if (++var4_2 < var1_1.size()) {
                    var10_9 = (NetworkData)var1_1.quickElementAt(var4_2);
                    continue;
                }
                var2_13 = true;
                var3_14 = true;
                continue;
            }
            var2_13 = true;
            var3_14 = true;
lbl85:
            // 5 sources

        } while (!var3_14);
        ** while (true)
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Vector listNetworkSubnets(NetworkData networkData, ListProperties listProperties) throws RemoteException, AdminException, HostAuthException {
        DirectoryRow directoryRow;
        QuickVector quickVector;
        block26: {
            this.checkRights("solaris.network.hosts.read");
            Object var3_3 = null;
            if (networkData == null) {
                throw new HostException("EXM_HST_SRV2", (Exception)((Object)new HostException("EXM_HST_SRV99")));
            }
            if (listProperties == null) {
                throw new HostException("EXM_HST_SRV2", (Exception)((Object)new HostException("EXM_HST_SRV99")));
            }
            if (!listProperties.hasCustomBooleanArg1BeenSet()) {
                throw new HostException("EXM_HST_SRV2", (Exception)((Object)new HostException("EXM_HST_SRV99")));
            }
            int n = 0;
            DirectoryTable directoryTable = null;
            NetworkData networkData2 = new NetworkData();
            quickVector = new QuickVector();
            String string = networkData.getNetId();
            try {
                try {
                    directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
                    TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                    tableDefinitions.loadTableDefinitions("networks");
                    directoryTable.open(tableDefinitions);
                    directoryRow = directoryTable.getAll();
                    if (directoryRow != null) {
                        n = directoryRow.getNumberOfRows();
                    }
                    int n2 = 1;
                    while (n2 <= n) {
                        block25: {
                            String string2 = directoryRow.getColumn(this.networksColumnAddr, n2);
                            try {
                                NetworkData.validateIPAddress(string2);
                            }
                            catch (Exception exception) {
                                break block25;
                            }
                            if (string2.startsWith(String.valueOf(string) + ".")) {
                                networkData2.setNetworkAddress(string2);
                                if (!networkData2.isNetwork()) {
                                    int n3 = quickVector.size();
                                    int n4 = 0;
                                    while (n4 < quickVector.size()) {
                                        NetworkData networkData3 = (NetworkData)quickVector.quickElementAt(n4);
                                        int n5 = networkData3.netAddrCompare(networkData2);
                                        if (n5 == 0) {
                                            n3 = -1;
                                            break;
                                        }
                                        if (n5 > 0) {
                                            n3 = n4;
                                            break;
                                        }
                                        ++n4;
                                    }
                                    if (n3 >= 0) {
                                        networkData2.setNetworkName(directoryRow.getColumn(this.networksColumnCname, n2));
                                        networkData2.setAliases(directoryRow.getColumn(this.networksColumnAliases, n2));
                                        networkData2.setDescription(directoryRow.getColumn(this.networksColumnComment, n2));
                                        networkData2.setNetmaskForSubnet(networkData.getNetmask());
                                        quickVector.insertElementAt(networkData2, n3);
                                        networkData2 = new NetworkData();
                                    }
                                }
                            }
                        }
                        ++n2;
                    }
                }
                catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                }
                catch (DirectoryTableAccessException directoryTableAccessException) {
                    HostException hostException = new HostException("EXM_HST_SRV30");
                    throw new HostException("EXM_HST_SRV3", (Exception)((Object)hostException));
                }
                catch (DirectoryTableConnectionException directoryTableConnectionException) {
                    HostException hostException = new HostException("EXM_HST_SRV31");
                    throw new HostException("EXM_HST_SRV3", (Exception)((Object)hostException));
                }
                catch (DirectoryTableException directoryTableException) {
                    HostException hostException = new HostException("EXM_HST_SRV32");
                    throw new HostException("EXM_HST_SRV3", (Exception)((Object)hostException));
                }
                catch (Exception exception) {
                    HostException hostException = new HostException("EXM_HST_SRV99", exception);
                    throw new HostException("EXM_HST_SRV3", (Exception)((Object)hostException));
                }
                Object var17_22 = null;
                if (directoryTable == null) break block26;
            }
            catch (Throwable throwable) {
                Object var17_23 = null;
                if (directoryTable != null) {
                    directoryTable.close();
                }
                throw throwable;
            }
            directoryTable.close();
        }
        directoryRow = null;
        networkData.setNetmask(this.getNetmask(networkData));
        if (listProperties.getCustomBooleanArg1()) {
            this.listHostSubnets(quickVector, networkData);
        }
        if (!listProperties.isSortOrderAscending()) {
            int n = quickVector.size() / 2;
            int n6 = 0;
            while (n6 < n) {
                quickVector.quickSwapElementsAt(n6, quickVector.size() - n6 - 1);
                ++n6;
            }
        }
        return quickVector;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Vector listNetworks(ListProperties listProperties) throws RemoteException, AdminException, HostAuthException {
        DirectoryRow directoryRow;
        QuickVector quickVector;
        block22: {
            this.checkRights("solaris.network.hosts.read");
            Object var2_2 = null;
            if (listProperties == null) {
                throw new HostException("EXM_HST_SRV2", (Exception)((Object)new HostException("EXM_HST_SRV99")));
            }
            if (!listProperties.hasCustomBooleanArg1BeenSet()) {
                throw new HostException("EXM_HST_SRV2", (Exception)((Object)new HostException("EXM_HST_SRV99")));
            }
            int n = 0;
            long l = 0L;
            DirectoryTable directoryTable = null;
            NetworkData networkData = null;
            quickVector = new QuickVector();
            try {
                try {
                    directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
                    TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                    tableDefinitions.loadTableDefinitions("networks");
                    directoryTable.open(tableDefinitions);
                    directoryRow = directoryTable.getAll();
                    if (directoryRow != null) {
                        directoryRow.sortByColumn(this.networksColumnAddr, tableDefinitions);
                        n = directoryRow.getNumberOfRows();
                        networkData = new NetworkData();
                    }
                    int n2 = 1;
                    while (n2 <= n) {
                        String string = directoryRow.getColumn(this.networksColumnAddr, n2);
                        try {
                            NetworkData.validateIPAddress(string);
                        }
                        catch (Exception exception) {}
                        networkData.setNetworkAddress(string);
                        if (networkData.isNetwork() || l != networkData.getNetIdLong()) {
                            if (networkData.isNetwork()) {
                                networkData.setNetworkName(directoryRow.getColumn(this.networksColumnCname, n2));
                                networkData.setAliases(directoryRow.getColumn(this.networksColumnAliases, n2));
                                networkData.setDescription(directoryRow.getColumn(this.networksColumnComment, n2));
                                networkData.setNetmask(this.getNetmask(networkData));
                            } else {
                                networkData.setNetworkAddress(networkData.getNetId());
                            }
                            networkData.setNetmask(this.getNetmask(networkData));
                            l = networkData.getNetIdLong();
                            quickVector.addElement(networkData);
                            networkData = new NetworkData();
                        }
                        ++n2;
                    }
                }
                catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                }
                catch (DirectoryTableAccessException directoryTableAccessException) {
                    HostException hostException = new HostException("EXM_HST_SRV30");
                    throw new HostException("EXM_HST_SRV2", (Exception)((Object)hostException));
                }
                catch (DirectoryTableConnectionException directoryTableConnectionException) {
                    HostException hostException = new HostException("EXM_HST_SRV31");
                    throw new HostException("EXM_HST_SRV2", (Exception)((Object)hostException));
                }
                catch (DirectoryTableException directoryTableException) {
                    HostException hostException = new HostException("EXM_HST_SRV32");
                    throw new HostException("EXM_HST_SRV2", (Exception)((Object)hostException));
                }
                catch (HostException hostException) {
                    throw new HostException("EXM_HST_SRV2", (Exception)((Object)hostException));
                }
                catch (Exception exception) {
                    HostException hostException = new HostException("EXM_HST_SRV99", exception);
                    throw new HostException("EXM_HST_SRV2", (Exception)((Object)hostException));
                }
                Object var14_18 = null;
                if (directoryTable == null) break block22;
            }
            catch (Throwable throwable) {
                Object var14_19 = null;
                if (directoryTable != null) {
                    directoryTable.close();
                }
                throw throwable;
            }
            directoryTable.close();
        }
        directoryRow = null;
        if (listProperties.getCustomBooleanArg1()) {
            this.listHostNetworks(quickVector);
        }
        this.listNetmaskNetworks(quickVector);
        if (!listProperties.isSortOrderAscending()) {
            int n = quickVector.size() / 2;
            int n3 = 0;
            while (n3 < n) {
                quickVector.quickSwapElementsAt(n3, quickVector.size() - n3 - 1);
                ++n3;
            }
        }
        return quickVector;
    }

    public Vector listTemplates() throws RemoteException, AdminException, DirectoryTableException, HostAuthException {
        DirectoryTable directoryTable;
        QuickVector quickVector;
        block9: {
            this.checkRights("solaris.network.security.read");
            quickVector = null;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            String string = null;
            String string2 = null;
            directoryTable = null;
            try {
                directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
                TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                tableDefinitions.loadTableDefinitions("tnrhtp");
                try {
                    directoryTable.open(tableDefinitions);
                }
                catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                    Vector vector = null;
                    Object var14_11 = null;
                    if (directoryTable != null) {
                        directoryTable.close();
                    }
                    return vector;
                }
                DirectoryRow directoryRow = directoryTable.getAll();
                if (directoryRow == null) break block9;
                n3 = 1;
                n2 = directoryRow.getNumberOfRows() + 1;
                int n5 = directoryRow.getNumberOfColumns();
                Integer n6 = new Integer(n5);
                Integer n7 = new Integer(this.templateColumnName);
                quickVector = new QuickVector(directoryRow.getNumberOfRows());
                quickVector.setSize(directoryRow.getNumberOfRows());
                n4 = 1;
                while (n3 != n2) {
                    TemplateData templateData = new TemplateData();
                    string = directoryRow.getColumn(this.templateColumnName, n3);
                    string2 = directoryRow.getColumn(this.templateColumnAttr, n3);
                    if (string != null && string2 != null) {
                        templateData.setTemplateName(string);
                        templateData.putAttributeString(string2);
                    }
                    quickVector.quickSetElementAt((Object)templateData, n++);
                    n3 += n4;
                }
                if (n != 0) break block9;
                quickVector = null;
            }
            catch (Throwable throwable) {
                Object var14_13 = null;
                if (directoryTable != null) {
                    directoryTable.close();
                }
                throw throwable;
            }
        }
        Object var14_12 = null;
        if (directoryTable != null) {
            directoryTable.close();
        }
        return quickVector;
    }

    public Vector listTnrhdb(String string) throws RemoteException, AdminException, DirectoryTableException, HostAuthException {
        QuickVector quickVector;
        block15: {
            this.checkRights("solaris.network.security.read");
            quickVector = null;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            DirectoryTable directoryTable = null;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            try {
                directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
                TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                tableDefinitions.loadTableDefinitions("tnrhdb");
                try {
                    directoryTable.open(tableDefinitions);
                }
                catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                    return null;
                }
                DirectoryRow directoryRow = directoryTable.getAll();
                if (directoryRow != null) {
                    n3 = 1;
                    n2 = directoryRow.getNumberOfRows() + 1;
                    quickVector = new QuickVector(directoryRow.getNumberOfRows());
                    quickVector.setSize(directoryRow.getNumberOfRows());
                    n4 = 1;
                    while (n3 != n2) {
                        TnrhdbData tnrhdbData = new TnrhdbData();
                        string2 = directoryRow.getColumn(this.tnrhdbColumnIpAddress, n3);
                        string2 = this.removeEscapeChar(string2, TNRHDB_DELIMITER);
                        int n5 = string2.indexOf(47, 0);
                        string4 = null;
                        if (n5 != -1) {
                            string3 = string2.substring(0, n5);
                            string4 = string2.substring(n5 + 1);
                        } else {
                            string3 = string2;
                        }
                        tnrhdbData.setIpAddress(string3);
                        HostData hostData = this.getHostByAddress(string3);
                        if (hostData != null) {
                            tnrhdbData.setHostName(hostData.getHostName());
                        }
                        if (string4 != null) {
                            tnrhdbData.setPrefixLen(string4);
                        }
                        tnrhdbData.setTemplateType(directoryRow.getColumn(this.tnrhdbColumnTemplateType, n3));
                        if (string.equals("ALL")) {
                            quickVector.quickSetElementAt((Object)tnrhdbData, n++);
                        } else if (tnrhdbData.getTemplateType().equals(string)) {
                            quickVector.quickSetElementAt((Object)tnrhdbData, n++);
                        }
                        n3 += n4;
                    }
                    if (n == 0) {
                        quickVector = null;
                    } else {
                        quickVector.setSize(n);
                    }
                    break block15;
                }
                return null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return quickVector;
    }

    public Vector listTnrhdbByIPAddress(String string, String string2) throws RemoteException, AdminException, DirectoryTableException, HostAuthException {
        this.checkRights("solaris.network.security.read");
        QuickVector quickVector = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        DirectoryTable directoryTable = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        try {
            directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
            TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
            tableDefinitions.loadTableDefinitions("tnrhdb");
            try {
                directoryTable.open(tableDefinitions);
            }
            catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                directoryTable.create(tableDefinitions);
            }
            DirectoryRow directoryRow = directoryTable.getAll();
            if (directoryRow != null) {
                n3 = 1;
                n2 = directoryRow.getNumberOfRows() + 1;
                quickVector = new QuickVector(directoryRow.getNumberOfRows());
                quickVector.setSize(directoryRow.getNumberOfRows());
                n4 = 1;
                Integer n5 = new Integer(n2);
                while (n3 != n2) {
                    TnrhdbData tnrhdbData = new TnrhdbData();
                    string3 = directoryRow.getColumn(this.tnrhdbColumnIpAddress, n3);
                    int n6 = (string3 = this.removeEscapeChar(string3, TNRHDB_DELIMITER)).indexOf(47, 0);
                    if (n6 != -1) {
                        string4 = string3.substring(0, n6);
                        string5 = string3.substring(n6 + 1);
                    } else {
                        string4 = string3;
                    }
                    tnrhdbData.setIpAddress(string4);
                    HostData hostData = this.getHostByAddress(string4);
                    if (hostData != null) {
                        tnrhdbData.setHostName(hostData.getHostName());
                    }
                    if (n6 != -1 && string5 != null) {
                        tnrhdbData.setPrefixLen(string5);
                    }
                    if (string5 != null) {
                        tnrhdbData.setPrefixLen(string5);
                    }
                    tnrhdbData.setTemplateType(directoryRow.getColumn(this.tnrhdbColumnTemplateType, n3));
                    if (tnrhdbData.getIpAddress().equals(string)) {
                        if (tnrhdbData.getPrefixLen() != null) {
                            if (tnrhdbData.getPrefixLen().equals(string2)) {
                                quickVector.quickSetElementAt((Object)tnrhdbData, n++);
                            }
                        } else {
                            quickVector.quickSetElementAt((Object)tnrhdbData, n++);
                        }
                    }
                    n3 += n4;
                }
                if (n == 0) {
                    quickVector = null;
                } else {
                    quickVector.setSize(n);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return quickVector;
    }

    private int mapHostColumnToNum(String string) throws RemoteException, AdminException {
        if (string == null || string.length() == 0) {
            throw new HostException("EXM_HST_SRV99");
        }
        if (string.equals("hostListComputerName")) {
            return this.hostsColumnCname;
        }
        if (string.equals("hostListIPAddress")) {
            return this.hostsColumnAddr;
        }
        if (string.equals("hostListAliases")) {
            return this.hostsColumnAliases;
        }
        if (string.equals("hostListComment")) {
            return this.hostsColumnComment;
        }
        if (string.equals("hostListEnetAddress")) {
            throw new HostException("EXM_HST_SRV67");
        }
        throw new HostException("EXM_HST_SRV99");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void modTemplate(TemplateData templateData, TemplateData templateData2) throws RemoteException, AdminException, DirectoryTableException, HostAuthException {
        block11: {
            this.checkRights("solaris.network.security.write");
            DirectoryTable directoryTable = null;
            try {
                try {
                    directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
                    TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                    tableDefinitions.loadTableDefinitions("tnrhtp");
                    directoryTable.open(tableDefinitions);
                    DirectoryRow directoryRow = directoryTable.getRowInstance();
                    directoryRow.putColumn(this.templateColumnName, templateData.getTemplateName());
                    directoryRow.putColumn(this.templateColumnAttr, templateData.getAttributeString());
                    DirectoryRow directoryRow2 = directoryTable.getRowInstance();
                    directoryRow2.putColumn(this.templateColumnName, templateData2.getTemplateName());
                    directoryRow2.putColumn(this.templateColumnAttr, templateData2.getAttributeString());
                    directoryTable.modifyRow(directoryRow, directoryRow2);
                }
                catch (DirectoryTableRowNotFoundException directoryTableRowNotFoundException) {
                    throw new HostException("EXM_SERVER_ROW_NOT_FOUND", templateData.getTemplateName());
                }
                catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                    throw new HostException("EXM_SERVER_TABLE_NOT_EXIST");
                }
                catch (DirectoryTableRowNotUniqueException directoryTableRowNotUniqueException) {
                    throw new HostException("EXM_SERVER_ROW_NOT_UNIQUE");
                }
                catch (DirectoryTableAccessException directoryTableAccessException) {
                    throw new HostException("EXM_SERVER_ACCESS_ERROR");
                }
                catch (DirectoryTableConnectionException directoryTableConnectionException) {
                    throw new HostException("EXM_SERVER_CONNECTION_ERROR");
                }
                catch (DirectoryTableException directoryTableException) {
                    throw new HostException("EXM_SERVER_TABLE_ERROR");
                }
                catch (Exception exception) {
                    throw new HostException("EXM_SERVER_ERROR");
                }
                Object var8_7 = null;
                if (directoryTable == null) break block11;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (directoryTable != null) {
                    directoryTable.close();
                }
                throw throwable;
            }
            directoryTable.close();
        }
        this.updateTntime("tnrhtp");
    }

    protected String[] myAuthRights() {
        return rights;
    }

    private String removeEscapeChar(String string, String string2) {
        int n = -1;
        char[] cArray = new char[]{'\\'};
        String string3 = String.valueOf(new String(cArray)) + string2;
        StringBuffer stringBuffer = new StringBuffer(string);
        String string4 = string;
        n = string4.indexOf(string3);
        while (n != -1) {
            stringBuffer.deleteCharAt(n);
            string4 = stringBuffer.toString();
            n = string4.indexOf(string3);
        }
        return stringBuffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void renameEthernetAddress(HostData hostData, String string) throws RemoteException, AdminException, HostAuthException {
        DirectoryTable directoryTable;
        block12: {
            block11: {
                this.checkRights("solaris.network.hosts.write");
                directoryTable = null;
                try {
                    try {
                        directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
                        TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                        tableDefinitions.loadTableDefinitions("ethers");
                        directoryTable.open(tableDefinitions);
                        DirectoryRow directoryRow = directoryTable.getRowInstance();
                        directoryRow.putColumn(this.ethersColumnName, hostData.getHostName());
                        DirectoryRow directoryRow2 = directoryTable.getAll((SearchTemplate)directoryRow);
                        if (directoryRow2 == null) {
                            Object var11_7 = null;
                            if (directoryTable == null) return;
                            break block11;
                        }
                        int n = 1;
                        while (n <= directoryRow2.getNumberOfRows()) {
                            DirectoryRow directoryRow3 = directoryRow2.extractRows(n, n);
                            DirectoryRow directoryRow4 = directoryRow2.extractRows(n, n);
                            directoryRow4.putColumn(this.ethersColumnName, string);
                            directoryTable.modifyRow(directoryRow3, directoryRow4);
                            ++n;
                        }
                        break block12;
                    }
                    catch (DirectoryTableRowNotFoundException directoryTableRowNotFoundException) {
                        break block12;
                    }
                    catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                        break block12;
                    }
                    catch (DirectoryTableAccessException directoryTableAccessException) {
                        HostException hostException = new HostException("EXM_HST_SRV30");
                        throw new HostException("EXM_HST_SRV27", (Exception)((Object)hostException));
                    }
                    catch (DirectoryTableConnectionException directoryTableConnectionException) {
                        HostException hostException = new HostException("EXM_HST_SRV31");
                        throw new HostException("EXM_HST_SRV27", (Exception)((Object)hostException));
                    }
                    catch (DirectoryTableException directoryTableException) {
                        HostException hostException = new HostException("EXM_HST_SRV32");
                        throw new HostException("EXM_HST_SRV27", (Exception)((Object)hostException));
                    }
                    catch (Exception exception) {
                        HostException hostException = new HostException("EXM_HST_SRV99", exception);
                        throw new HostException("EXM_HST_SRV27", (Exception)((Object)hostException));
                    }
                }
                catch (Throwable throwable) {
                    Object var11_9 = null;
                    if (directoryTable == null) throw throwable;
                    directoryTable.close();
                    throw throwable;
                }
            }
            directoryTable.close();
            return;
        }
        Object var11_8 = null;
        if (directoryTable == null) return;
        directoryTable.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int renameHost(HostData hostData, String string, Integer n) throws RemoteException, AdminException, HostAuthException {
        DirectoryRow directoryRow;
        DirectoryTable directoryTable;
        block16: {
            int n2;
            block15: {
                this.checkRights("solaris.network.hosts.write");
                int n3 = n;
                directoryTable = null;
                try {
                    try {
                        directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
                        TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                        tableDefinitions.loadTableDefinitions("hosts");
                        directoryTable.open(tableDefinitions);
                        DirectoryRow directoryRow2 = directoryTable.getRowInstance();
                        directoryRow2.putColumn(this.hostsColumnCname, hostData.getHostName());
                        directoryRow = directoryTable.getAll((SearchTemplate)directoryRow2);
                        if (directoryRow == null) {
                            throw new HostException("EXM_HST_SRV62");
                        }
                        if (n3 == 0 && directoryRow.getNumberOfRows() > 1) {
                            n2 = directoryRow.getNumberOfRows();
                            Object var15_11 = null;
                            if (directoryTable == null) return n2;
                            break block15;
                        }
                        int n4 = 1;
                        while (n4 <= directoryRow.getNumberOfRows()) {
                            if (n3 > 1 || hostData.getNetworkAddress().equals(directoryRow.getColumn(this.hostsColumnAddr, n4))) {
                                DirectoryRow directoryRow3 = directoryRow.extractRows(n4, n4);
                                DirectoryRow directoryRow4 = directoryRow.extractRows(n4, n4);
                                directoryRow4.putColumn(this.hostsColumnCname, string);
                                directoryTable.modifyRow(directoryRow3, directoryRow4);
                            }
                            ++n4;
                        }
                        break block16;
                    }
                    catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                        HostException hostException = new HostException("EXM_HST_SRV60");
                        throw new HostException("EXM_HST_SRV25", (Exception)((Object)hostException));
                    }
                    catch (DirectoryTableAccessException directoryTableAccessException) {
                        HostException hostException = new HostException("EXM_HST_SRV30");
                        throw new HostException("EXM_HST_SRV25", (Exception)((Object)hostException));
                    }
                    catch (DirectoryTableConnectionException directoryTableConnectionException) {
                        HostException hostException = new HostException("EXM_HST_SRV31");
                        throw new HostException("EXM_HST_SRV25", (Exception)((Object)hostException));
                    }
                    catch (DirectoryTableException directoryTableException) {
                        HostException hostException = new HostException("EXM_HST_SRV32");
                        throw new HostException("EXM_HST_SRV25", (Exception)((Object)hostException));
                    }
                    catch (HostException hostException) {
                        throw new HostException("EXM_HST_SRV25", (Exception)((Object)hostException));
                    }
                    catch (Exception exception) {
                        HostException hostException = new HostException("EXM_HST_SRV99", exception);
                        throw new HostException("EXM_HST_SRV25", (Exception)((Object)hostException));
                    }
                }
                catch (Throwable throwable) {
                    Object var15_13 = null;
                    if (directoryTable != null) {
                        directoryTable.close();
                    }
                    throw throwable;
                }
            }
            directoryTable.close();
            return n2;
        }
        Object var15_12 = null;
        if (directoryTable != null) {
            directoryTable.close();
        }
        this.renameEthernetAddress(hostData, string);
        String[] stringArray = new String[]{hostData.getHostName(), string};
        return directoryRow.getNumberOfRows();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setEthernetAddress(HostData hostData, HostData hostData2) throws RemoteException, AdminException, HostAuthException {
        this.checkRights("solaris.network.hosts.read");
        if (hostData.getEthernetAddress().equals(hostData2.getEthernetAddress())) {
            return;
        }
        if (hostData2.getEthernetAddress().length() == 0) {
            this.deleteEthernetAddress(hostData);
            return;
        }
        if (hostData.getEthernetAddress().length() == 0) {
            this.addEthernetAddress(hostData2);
            return;
        }
        DirectoryTable directoryTable = null;
        HostData hostData3 = this.getHostByEtherAddr(hostData2.getEthernetAddress());
        if (hostData3 != null && !hostData2.getHostName().equals(hostData3.getHostName())) {
            throw new HostWarningException("EXM_HST_SRV70_WARN");
        }
        try {
            try {
                directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
                TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                tableDefinitions.loadTableDefinitions("ethers");
                directoryTable.open(tableDefinitions);
                DirectoryRow directoryRow = directoryTable.getRowInstance();
                directoryRow.putColumn(this.ethersColumnName, hostData.getHostName());
                directoryRow.putColumn(this.ethersColumnAddr, hostData.getEthernetAddress());
                DirectoryRow directoryRow2 = directoryTable.getRowInstance();
                directoryRow2.putColumn(this.ethersColumnName, hostData2.getHostName());
                directoryRow2.putColumn(this.ethersColumnAddr, hostData2.getEthernetAddress());
                directoryTable.modifyRow(directoryRow, directoryRow2);
            }
            catch (DirectoryTableRowNotFoundException directoryTableRowNotFoundException) {
                HostException hostException = new HostException("EXM_HST_SRV63");
                throw new HostWarningException("EXM_HST_SRV17_WARN", (Exception)((Object)hostException));
            }
            catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                HostException hostException = new HostException("EXM_HST_SRV61");
                throw new HostWarningException("EXM_HST_SRV17_WARN", (Exception)((Object)hostException));
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                HostException hostException = new HostException("EXM_HST_SRV30");
                throw new HostWarningException("EXM_HST_SRV17_WARN", (Exception)((Object)hostException));
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                HostException hostException = new HostException("EXM_HST_SRV31");
                throw new HostWarningException("EXM_HST_SRV17_WARN", (Exception)((Object)hostException));
            }
            catch (DirectoryTableException directoryTableException) {
                HostException hostException = new HostException("EXM_HST_SRV32");
                throw new HostWarningException("EXM_HST_SRV17_WARN", (Exception)((Object)hostException));
            }
            catch (Exception exception) {
                HostException hostException = new HostException("EXM_HST_SRV99", exception);
                throw new HostWarningException("EXM_HST_SRV17_WARN", (Exception)((Object)hostException));
            }
            Object var10_15 = null;
            if (directoryTable == null) return;
        }
        catch (Throwable throwable) {
            Object var10_16 = null;
            if (directoryTable == null) throw throwable;
            directoryTable.close();
            throw throwable;
        }
        directoryTable.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setHost(HostData hostData, HostData hostData2) throws RemoteException, AdminException, HostAuthException {
        String[] stringArray;
        block12: {
            this.checkRights("solaris.network.hosts.write");
            DirectoryTable directoryTable = null;
            if (!hostData.getNetworkAddress().equals(hostData2.getNetworkAddress()) && (stringArray = this.getHostByAddress(hostData2.getNetworkAddress())) != null) {
                if (stringArray.getHostName().equals(hostData2.getHostName())) {
                    throw new HostException("EXM_HST_SRV22", (Exception)((Object)new HostException("EXM_HST_SRV64")));
                }
                throw new HostException("EXM_HST_SRV22", (Exception)((Object)new HostException("EXM_HST_SRV69")));
            }
            try {
                try {
                    directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
                    TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                    tableDefinitions.loadTableDefinitions("hosts");
                    directoryTable.open(tableDefinitions);
                    DirectoryRow directoryRow = directoryTable.getRowInstance();
                    directoryRow.putColumn(this.hostsColumnCname, hostData.getHostName());
                    directoryRow.putColumn(this.hostsColumnAddr, hostData.getNetworkAddress());
                    directoryRow.putColumn(this.hostsColumnAliases, hostData.getAliases());
                    directoryRow.putColumn(this.hostsColumnComment, hostData.getDescription());
                    DirectoryRow directoryRow2 = directoryTable.getRowInstance();
                    directoryRow2.putColumn(this.hostsColumnCname, hostData2.getHostName());
                    directoryRow2.putColumn(this.hostsColumnAddr, hostData2.getNetworkAddress());
                    directoryRow2.putColumn(this.hostsColumnAliases, hostData2.getAliases());
                    directoryRow2.putColumn(this.hostsColumnComment, hostData2.getDescription());
                    directoryTable.modifyRow(directoryRow, directoryRow2);
                }
                catch (DirectoryTableRowNotFoundException directoryTableRowNotFoundException) {
                    HostException hostException = new HostException("EXM_HST_SRV62");
                    throw new HostException("EXM_HST_SRV22", (Exception)((Object)hostException));
                }
                catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                    HostException hostException = new HostException("EXM_HST_SRV60");
                    throw new HostException("EXM_HST_SRV22", (Exception)((Object)hostException));
                }
                catch (DirectoryTableAccessException directoryTableAccessException) {
                    HostException hostException = new HostException("EXM_HST_SRV30");
                    throw new HostException("EXM_HST_SRV22", (Exception)((Object)hostException));
                }
                catch (DirectoryTableConnectionException directoryTableConnectionException) {
                    HostException hostException = new HostException("EXM_HST_SRV31");
                    throw new HostException("EXM_HST_SRV22", (Exception)((Object)hostException));
                }
                catch (DirectoryTableException directoryTableException) {
                    HostException hostException = new HostException("EXM_HST_SRV32");
                    throw new HostException("EXM_HST_SRV22", (Exception)((Object)hostException));
                }
                catch (Exception exception) {
                    HostException hostException = new HostException("EXM_HST_SRV99", exception);
                    throw new HostException("EXM_HST_SRV22", (Exception)((Object)hostException));
                }
                Object var9_16 = null;
                if (directoryTable == null) break block12;
            }
            catch (Throwable throwable) {
                Object var9_17 = null;
                if (directoryTable != null) {
                    directoryTable.close();
                }
                throw throwable;
            }
            directoryTable.close();
        }
        this.setEthernetAddress(hostData, hostData2);
        stringArray = new String[]{hostData.getHostName()};
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean setNetmask(NetworkData networkData, NetworkData networkData2) throws RemoteException, AdminException, HostAuthException {
        this.checkRights("solaris.network.hosts.write");
        DirectoryFilter directoryFilter = new DirectoryFilter(2);
        DirectoryTable directoryTable = null;
        if (networkData2.getNetmask().length() == 0) {
            this.deleteNetmask(networkData);
            return true;
        }
        if (networkData.getNetmask().length() == 0) {
            return this.addNetmask(networkData2);
        }
        if (!networkData.getNetworkAddress().equals(networkData2.getNetworkAddress())) {
            String string;
            try {
                string = this.getNetmask(networkData2);
            }
            catch (HostException hostException) {
                throw new HostException("EXM_HST_SRV10", (Exception)((Object)hostException));
            }
            if (string != null && string.length() > 0) {
                if (!string.equals(networkData2.getNetmask())) throw new HostException("EXM_HST_SRV45");
                return false;
            }
        }
        try {
            try {
                directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
                TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                tableDefinitions.loadTableDefinitions("netmasks");
                directoryTable.open(tableDefinitions);
                directoryFilter.add(this.netmasksColumnAddr, 1, 5, networkData.getNetId());
                directoryFilter.add(this.netmasksColumnAddr, 3, 3, String.valueOf(networkData.getNetId()) + ".");
                DirectoryRow directoryRow = directoryTable.getFirstRow((SearchTemplate)directoryFilter);
                if (directoryRow == null) {
                    throw new HostException("EXM_HST_SRV43");
                }
                DirectoryRow directoryRow2 = directoryTable.getRowInstance();
                directoryRow2.putColumn(this.netmasksColumnMask, networkData2.getNetmask());
                if (networkData.getNetworkAddress().equals(networkData2.getNetworkAddress())) {
                    directoryRow2.putColumn(this.netmasksColumnAddr, directoryRow.getColumn(this.netmasksColumnAddr));
                } else {
                    directoryRow2.putColumn(this.netmasksColumnAddr, networkData2.getNetworkAddress());
                }
                directoryTable.modifyRow(directoryRow, directoryRow2);
            }
            catch (DirectoryTableRowNotFoundException directoryTableRowNotFoundException) {
                HostException hostException = new HostException("EXM_HST_SRV43");
                throw new HostException("EXM_HST_SRV10", (Exception)((Object)hostException));
            }
            catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                HostException hostException = new HostException("EXM_HST_SRV41");
                throw new HostException("EXM_HST_SRV10", (Exception)((Object)hostException));
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                HostException hostException = new HostException("EXM_HST_SRV30");
                throw new HostException("EXM_HST_SRV10", (Exception)((Object)hostException));
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                HostException hostException = new HostException("EXM_HST_SRV31");
                throw new HostException("EXM_HST_SRV10", (Exception)((Object)hostException));
            }
            catch (DirectoryTableException directoryTableException) {
                HostException hostException = new HostException("EXM_HST_SRV32");
                throw new HostException("EXM_HST_SRV10", (Exception)((Object)hostException));
            }
            catch (HostException hostException) {
                throw new HostException("EXM_HST_SRV10", (Exception)((Object)hostException));
            }
            catch (Exception exception) {
                HostException hostException = new HostException("EXM_HST_SRV99", exception);
                throw new HostException("EXM_HST_SRV10", (Exception)((Object)hostException));
            }
            Object var10_8 = null;
            if (directoryTable == null) return true;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            if (directoryTable == null) throw throwable;
            directoryTable.close();
            throw throwable;
        }
        directoryTable.close();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setNetwork(NetworkData networkData, NetworkData networkData2) throws RemoteException, AdminException, HostAuthException {
        block22: {
            this.checkRights("solaris.network.hosts.write");
            DirectoryTable directoryTable = null;
            if (networkData2.getNetworkName().length() == 0) {
                boolean bl;
                if (networkData.getNetworkName().length() > 0) {
                    String string = networkData.getNetmask();
                    networkData.setNetmask("");
                    this.deleteNetwork(networkData);
                    networkData.setNetmask(string);
                }
                if (!(bl = this.setNetmask(networkData, networkData2))) {
                    throw new HostException("EXM_HST_SRV45");
                }
                return;
            }
            boolean bl = this.setNetmask(networkData, networkData2);
            try {
                try {
                    directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
                    TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                    tableDefinitions.loadTableDefinitions("networks");
                    directoryTable.open(tableDefinitions);
                    DirectoryRow directoryRow = directoryTable.getRowInstance();
                    directoryRow.putColumn(this.networksColumnCname, networkData.getNetworkName());
                    directoryRow.putColumn(this.networksColumnAddr, networkData.getNetworkAddress());
                    directoryRow.putColumn(this.networksColumnAliases, networkData.getAliases());
                    directoryRow.putColumn(this.networksColumnComment, networkData.getDescription());
                    DirectoryRow directoryRow2 = directoryTable.getRowInstance();
                    directoryRow2.putColumn(this.networksColumnCname, networkData2.getNetworkName());
                    directoryRow2.putColumn(this.networksColumnAddr, networkData2.getNetworkAddress());
                    directoryRow2.putColumn(this.networksColumnAliases, networkData2.getAliases());
                    directoryRow2.putColumn(this.networksColumnComment, networkData2.getDescription());
                    if (networkData.getNetworkName().length() == 0 && networkData2.getNetworkName().length() > 0) {
                        directoryTable.addRow(directoryRow2);
                    } else {
                        directoryTable.modifyRow(directoryRow, directoryRow2);
                    }
                }
                catch (DirectoryTableRowNotFoundException directoryTableRowNotFoundException) {
                    HostException hostException = new HostException("EXM_HST_SRV42");
                    if (bl) {
                        throw new HostWarningException("EXM_HST_SRV5_WARN", (Exception)((Object)hostException));
                    }
                    throw new HostException("EXM_HST_SRV5", (Exception)((Object)hostException));
                }
                catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                    HostException hostException = new HostException("EXM_HST_SRV40");
                    if (bl) {
                        throw new HostWarningException("EXM_HST_SRV5_WARN", (Exception)((Object)hostException));
                    }
                    throw new HostException("EXM_HST_SRV5", (Exception)((Object)hostException));
                }
                catch (DirectoryTableAccessException directoryTableAccessException) {
                    HostException hostException = new HostException("EXM_HST_SRV30");
                    if (bl) {
                        throw new HostWarningException("EXM_HST_SRV5_WARN", (Exception)((Object)hostException));
                    }
                    throw new HostException("EXM_HST_SRV5", (Exception)((Object)hostException));
                }
                catch (DirectoryTableConnectionException directoryTableConnectionException) {
                    HostException hostException = new HostException("EXM_HST_SRV31");
                    if (bl) {
                        throw new HostWarningException("EXM_HST_SRV5_WARN", (Exception)((Object)hostException));
                    }
                    throw new HostException("EXM_HST_SRV5", (Exception)((Object)hostException));
                }
                catch (DirectoryTableException directoryTableException) {
                    HostException hostException = new HostException("EXM_HST_SRV32");
                    if (bl) {
                        throw new HostWarningException("EXM_HST_SRV5_WARN", (Exception)((Object)hostException));
                    }
                    throw new HostException("EXM_HST_SRV5", (Exception)((Object)hostException));
                }
                catch (Exception exception) {
                    HostException hostException = new HostException("EXM_HST_SRV99", exception);
                    if (bl) {
                        throw new HostWarningException("EXM_HST_SRV5_WARN", (Exception)((Object)hostException));
                    }
                    throw new HostException("EXM_HST_SRV5", (Exception)((Object)hostException));
                }
                Object var10_19 = null;
                if (directoryTable == null) break block22;
            }
            catch (Throwable throwable) {
                Object var10_20 = null;
                if (directoryTable != null) {
                    directoryTable.close();
                }
                throw throwable;
            }
            directoryTable.close();
        }
        String[] stringArray = new String[]{networkData.getNetworkName(), networkData.getNetworkAddress()};
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int setTnrhdb(TnrhdbData tnrhdbData) throws RemoteException, AdminException, DirectoryTableException, HostException, HostAuthException {
        block12: {
            this.checkRights("solaris.network.security.write");
            DirectoryTable directoryTable = null;
            try {
                try {
                    directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
                    TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                    tableDefinitions.loadTableDefinitions("tnrhdb");
                    try {
                        directoryTable.open(tableDefinitions);
                    }
                    catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                        directoryTable.create(tableDefinitions);
                    }
                    this.tnrhdbColumnIpAddress = tableDefinitions.getColumnNumber("addr");
                    this.tnrhdbColumnTemplateName = tableDefinitions.getColumnNumber("name");
                    DirectoryRow directoryRow = new DirectoryRow(tableDefinitions.getNumberOfColumns());
                    String string = this.insertEscapeChar(tnrhdbData.getIpAddress(), TNRHDB_DELIMITER);
                    if (tnrhdbData.getPrefixLen() != null) {
                        directoryRow.putColumn(this.tnrhdbColumnIpAddress, String.valueOf(string) + "/" + tnrhdbData.getPrefixLen());
                    } else {
                        directoryRow.putColumn(this.tnrhdbColumnIpAddress, string);
                    }
                    DirectoryRow directoryRow2 = directoryTable.getFirstRow((SearchTemplate)directoryRow);
                    if (directoryRow2 == null) {
                        directoryRow.putColumn(this.tnrhdbColumnTemplateName, tnrhdbData.getTemplateType());
                        directoryTable.addRow(directoryRow);
                    } else {
                        directoryRow.putColumn(this.tnrhdbColumnTemplateName, tnrhdbData.getTemplateType());
                        directoryTable.modifyRow(directoryRow2, directoryRow);
                    }
                }
                catch (Exception exception) {
                    int n = -1;
                    Object var8_8 = null;
                    if (directoryTable == null) return n;
                    directoryTable.close();
                    return n;
                }
                Object var8_9 = null;
                if (directoryTable == null) break block12;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (directoryTable != null) {
                    directoryTable.close();
                }
                throw throwable;
            }
            directoryTable.close();
        }
        this.updateTntime("tnrhdb");
        return 1;
    }

    private void updateTntime(String string) throws HostException {
        if (!string.equals("tnrhdb") && !string.equals("tnrhtp")) {
            throw new HostException("EXM_HST_SRV73", string);
        }
        String string2 = new String("/usr/lib/nis/nistntime " + string);
        this.execCmd(string2);
    }

    class StopWatch {
        Date startTime;
        Date stopTime;

        StopWatch() {
        }

        public void start() {
            this.startTime = new Date();
        }

        public long stop() {
            this.stopTime = new Date();
            return (this.stopTime.getTime() - this.startTime.getTime()) / 1000L;
        }
    }
}

