/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.usermgr.cli;

import com.sun.admin.cis.common.AdminCommonTools;
import com.sun.admin.cis.common.CheckSyntax;
import com.sun.admin.cis.common.IClientResource;
import com.sun.admin.cis.common.VCommonInfo;
import com.sun.admin.usermgr.client.ApplicationContext;
import com.sun.admin.usermgr.client.ServiceWrapper;
import com.sun.admin.usermgr.common.SolGroupAttr;
import com.sun.admin.usermgr.common.SolHomedirAttr;
import com.sun.admin.usermgr.common.SolPasswordAttr;
import com.sun.admin.usermgr.common.SolServicesAttr;
import com.sun.admin.usermgr.common.UserException;
import com.sun.admin.usermgr.common.UserObj;
import com.sun.management.viper.CriticalStopException;
import com.sun.management.viper.Tool;
import com.sun.management.viper.ToolContext;
import com.sun.management.viper.ToolInfrastructure;
import com.sun.management.viper.VIdentity;
import com.sun.management.viper.console.VConsoleActionListener;
import com.sun.management.viper.console.VConsoleProperties;
import com.sun.management.viper.console.VScopeNode;
import com.sun.management.viper.util.ResourceManager;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.Vector;

public class UMgrCliTool
implements Tool,
IClientResource {
    public static final int SINGLE_ADD = 0;
    public static final int SINGLE_DELETE = 1;
    public static final int SINGLE_MODIFY = 2;
    public static final int SINGLE_VIEW = 3;
    public static final int MULTI_ADD = 4;
    public static final int MULTI_DELETE = 5;
    public static final int MULTI_MODIFY = 6;
    public static final int PASSWD_DATAFILE = 0;
    public static final int MUTX_DATAFILE = 1;
    private int iOperation = -1;
    private int iDataFileType = 0;
    private boolean bDebug = false;
    private String strInputFile = "";
    private String strLogFile = "";
    private ServiceWrapper userMgr = null;
    private VConsoleProperties properties = null;
    private boolean bRunning = false;
    private ToolInfrastructure infrastructure = null;
    private ResourceBundle resourceBundle = null;
    private ResourceBundle cisBundle = null;
    private Vector vUserObjs = new Vector();
    private ApplicationContext applicationContext = null;

    public UMgrCliTool() {
        this.trace("enterred in UMgrCliTool constructor");
        try {
            this.cisBundle = ResourceManager.getBundle((String)VCommonInfo.resourceClass, this.getClass());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.cisBundle = null;
        }
        String string = System.getProperty("usermgr.Debugging");
        if (string != null && string.equals("ON")) {
            this.setDebugStatus(true);
            this.trace("Debugging enabled");
        }
        this.trace("leaving UMgrCliTool constructor");
    }

    public void addConsoleActionListener(VConsoleActionListener vConsoleActionListener) {
    }

    public void addMultiObjects() throws Exception {
    }

    public void addObject() throws Exception {
    }

    public void addUserObj(UserObj userObj) {
        this.vUserObjs.addElement(userObj);
    }

    public void cascade_logging(String string) {
        this.trace("in cascade_logging");
        String string2 = this.getLogFile();
        if (this.strLogFile == null || this.strLogFile.equals("")) {
            this.trace("cascade_logging:  no log file specified so logging off");
            return;
        }
        string = String.valueOf(string) + "\n";
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string2, true);
            fileOutputStream.write(string.getBytes());
            fileOutputStream.close();
        }
        catch (Exception exception) {
            this.trace("Can't open file for logging:  " + string2);
            this.handleErrors("Can't open file for logging:  " + string2);
        }
        this.trace("cascade_logging to file:  " + string);
    }

    public void cascade_logging(String string, boolean bl) {
        this.trace("in cascade_logging");
        if (bl) {
            string = String.valueOf(this.getDate()) + " " + this.getApplicationContext().getMgmtServer() + ":  " + string;
        }
        String string2 = this.getLogFile();
        if (this.strLogFile == null || this.strLogFile.equals("")) {
            this.trace("cascade_logging:  no log file specified so logging off");
            return;
        }
        string = String.valueOf(string) + "\n";
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string2, true);
            fileOutputStream.write(string.getBytes());
            fileOutputStream.close();
        }
        catch (Exception exception) {
            this.trace("Can't open file for logging:  " + string2);
            this.handleErrors("Can't open file for logging:  " + string2);
        }
        this.trace("cascade_logging to file:  " + string);
    }

    public void deleteMultiObjects() throws Exception {
    }

    public void deleteObject() throws Exception {
    }

    public void destroy() {
    }

    public void doOperation() throws Exception {
        switch (this.iOperation) {
            case 0: {
                this.addObject();
                break;
            }
            case 4: {
                this.addMultiObjects();
                break;
            }
            case 5: {
                this.deleteMultiObjects();
                break;
            }
            case 1: {
                this.deleteObject();
                break;
            }
            case 2: {
                this.modifyObject();
                break;
            }
            case 6: {
                this.modifyMultiObjects();
                break;
            }
            case 3: {
                this.viewObjectProps();
            }
        }
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public String getAuthenticatedUser() {
        String string = null;
        VIdentity vIdentity = this.infrastructure.getIdentity();
        if (vIdentity != null) {
            string = vIdentity.getName();
        }
        return string;
    }

    public ResourceBundle getCisBundle() {
        return this.cisBundle;
    }

    public int getDataFileType() {
        return this.iDataFileType;
    }

    public String getDate() {
        long l = System.currentTimeMillis();
        Date date = new Date(l);
        return date.toString();
    }

    public boolean getDebugStatus() {
        return this.bDebug;
    }

    public String getInputDataFile() {
        return this.strInputFile;
    }

    public String getLogFile() {
        return this.strLogFile;
    }

    public String getMgmtServer() {
        return this.applicationContext.getMgmtServer();
    }

    public int getOperation() {
        return this.iOperation;
    }

    public String getOperationType() {
        String string = "";
        switch (this.iOperation) {
            case 0: {
                string = "Add User";
                break;
            }
            case 4: {
                string = "Multi Add";
                break;
            }
            case 1: {
                string = "Delete User";
                break;
            }
            case 5: {
                string = "Multi Delete";
                break;
            }
            case 2: {
                string = "Modify User";
                break;
            }
            case 6: {
                string = "Multi Modify";
                break;
            }
            case 3: {
                string = "Single View";
                break;
            }
        }
        return string;
    }

    public VConsoleProperties getProperties() {
        return this.properties;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public VScopeNode getScopeNode() {
        return null;
    }

    public ToolInfrastructure getToolInfrastructure() {
        return this.infrastructure;
    }

    public ServiceWrapper getUserMgr() {
        return this.userMgr;
    }

    public Vector getUserObjs() {
        return this.vUserObjs;
    }

    public void giveNoBundleMessage() {
        System.err.println("This tool was not able to load it's resource strings.");
        System.err.println("This could be a temporary situation. Try again.");
        System.err.println("If this problem persists, refer to the Log Viewer and ");
        System.err.println("contact your Sun Microsystems support provider.");
    }

    public void handleErrors(String string) {
        System.err.println(string);
    }

    public void init(ToolInfrastructure toolInfrastructure) throws CriticalStopException {
        this.trace("enterred UMgrCliTool.init() ");
        this.infrastructure = toolInfrastructure;
        try {
            this.trace("calling applicationContext.getServiceWrapper()");
            this.userMgr = this.applicationContext.getServiceWrapper(toolInfrastructure);
            this.trace("done calling applicationContext.getServiceWrapper()");
        }
        catch (UserException userException) {
            this.handleErrors(userException.getLocalizedMessage());
            throw new CriticalStopException(userException.getLocalizedMessage());
        }
        catch (Exception exception) {
            UserException userException = new UserException("EXM_NO_CIMOM");
            this.handleErrors(userException.getLocalizedMessage());
            throw new CriticalStopException(exception.getLocalizedMessage());
        }
        AdminCommonTools.CMN_TraceOpen((int)2, (String)"stdout");
        this.trace("leaving UMgrCliTool.init() ");
    }

    public boolean isLocalScope() {
        return this.applicationContext.isLocalScope();
    }

    public void logit(String string) {
        System.out.println(string);
    }

    public void modifyMultiObjects() throws Exception {
    }

    public void modifyObject() throws Exception {
    }

    public UserObj parseLineForUserInfo(String string) throws UserException {
        int n = 0;
        UserObj userObj = new UserObj();
        String string2 = "";
        n = string.indexOf(":");
        string2 = string.substring(0, n);
        string = string.substring(n + 1);
        userObj.setUserName(string2);
        this.trace("in parseLineForUserInfo: user:  " + string2);
        n = string.indexOf(":");
        string2 = string.substring(0, n);
        string2 = string2.trim();
        string = string.substring(n + 1);
        if (CheckSyntax.isPasswordLenOK((String)string2)) {
            userObj = this.setUserPasswd(string2, userObj, false);
        }
        n = string.indexOf(":");
        string2 = string.substring(0, n);
        string = string.substring(n + 1);
        userObj.setUserID(string2);
        n = string.indexOf(":");
        string2 = string.substring(0, n);
        string = string.substring(n + 1);
        SolGroupAttr solGroupAttr = new SolGroupAttr();
        solGroupAttr.setPrimaryGroup(string2);
        userObj.setSolGroupAttr(solGroupAttr);
        n = string.indexOf(":");
        string2 = string.substring(0, n);
        string = string.substring(n + 1);
        userObj.setUserDescription(string2);
        n = string.indexOf(":");
        string2 = string.substring(0, n);
        string = string.substring(n + 1);
        SolHomedirAttr solHomedirAttr = new SolHomedirAttr();
        solHomedirAttr.setPathname(string2);
        userObj.setSolHomedirAttr(solHomedirAttr);
        if (string.indexOf(":") == -1) {
            SolServicesAttr solServicesAttr = new SolServicesAttr();
            solServicesAttr.setInitialShell(string);
            userObj.setSolServicesAttr(solServicesAttr);
        } else {
            n = string.indexOf(":");
            string2 = string.substring(0, n);
            string = string.substring(n + 1);
            SolServicesAttr solServicesAttr = new SolServicesAttr();
            solServicesAttr.setInitialShell(string2);
            userObj.setSolServicesAttr(solServicesAttr);
            userObj.setUserFullName(string);
        }
        return userObj;
    }

    public void printDebugStack(Exception exception) {
        if (this.getDebugStatus()) {
            exception.printStackTrace();
        }
    }

    public void printDebugStack(Throwable throwable) {
        if (this.getDebugStatus()) {
            throwable.printStackTrace();
        }
    }

    public int runCommandLine(String[] stringArray, InputStream inputStream, PrintStream printStream, PrintStream printStream2) {
        return 0;
    }

    public void setCisBundle(ResourceBundle resourceBundle) {
        this.cisBundle = resourceBundle;
    }

    public void setDataFileType(int n) {
        this.iDataFileType = n;
    }

    public void setDebugStatus(boolean bl) {
        this.bDebug = bl;
    }

    public void setInputDataFile(String string) {
        this.trace("read in input_file:  " + string);
        this.strInputFile = string;
    }

    public void setLogFile(String string) {
        this.trace("read in logfile:  " + string);
        this.strLogFile = string;
    }

    public void setOperation(int n) {
        this.iOperation = n;
    }

    public void setProperties(VConsoleProperties vConsoleProperties) {
        this.trace("UMgrCliTool.setProperties");
        this.properties = vConsoleProperties;
    }

    public void setResourceBundle(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    public void setTaskOperation(char c) {
        switch (c) {
            case 'A': {
                this.iOperation = 0;
                this.trace("RECOGNIZED ACTION: ADDING ONE OBJECT");
                break;
            }
            case 'R': {
                this.iOperation = 4;
                this.trace("RECOGNIZED ACTION: ADDING MULTIPLE OBJECT");
                break;
            }
            case 'X': {
                this.iOperation = 1;
                this.trace("RECOGNIZED ACTION: DELETING ONE OBJECT");
                break;
            }
            case 'Y': {
                this.iOperation = 5;
                this.trace("RECOGNIZED ACTION: DELETING MULTIPLE OBJECT");
                break;
            }
            case 'M': {
                this.iOperation = 2;
                this.trace("RECOGNIZED ACTION: MODIFYING ONE OBJECT");
                break;
            }
            case 'N': {
                this.iOperation = 6;
                this.trace("RECOGNIZED ACTION: MODIFYING MULTIPLE OBJECTS");
                break;
            }
            case 'V': {
                this.iOperation = 3;
                this.trace("RECOGNIZED ACTION: viewing a list of objects");
                break;
            }
        }
    }

    public void setToolContext(ToolContext toolContext) {
        this.applicationContext = new ApplicationContext(this, toolContext);
    }

    public void setUserMgr(ServiceWrapper serviceWrapper) {
        this.userMgr = serviceWrapper;
    }

    public void setUserObjs(Vector vector) {
        this.vUserObjs = vector;
    }

    protected UserObj setUserPasswd(String string, UserObj userObj, boolean bl) throws UserException {
        SolPasswordAttr solPasswordAttr = userObj.getSolPasswordAttr();
        if (solPasswordAttr == null) {
            solPasswordAttr = new SolPasswordAttr();
        }
        if (bl) {
            if (string != null && !string.equals("")) {
                solPasswordAttr.setHasPassword(true);
                solPasswordAttr.setChangePassword(true);
                solPasswordAttr.setUnixEPasswd(string);
            } else {
                solPasswordAttr.setHasPassword(false);
                solPasswordAttr.setChangePassword(false);
            }
            userObj.setSolPasswordAttr(solPasswordAttr);
        } else if (string != null && !string.equals("")) {
            solPasswordAttr.setChangePassword(true);
            userObj.setSolPasswordAttr(solPasswordAttr);
            try {
                userObj = this.getUserMgr().setUpPassword(string, userObj);
            }
            catch (Exception exception) {
                this.printDebugStack(exception);
                throw new UserException("EXM_CLI_USER_BADPWD");
            }
        } else {
            solPasswordAttr.setHasPassword(false);
            solPasswordAttr.setChangePassword(false);
            userObj.setSolPasswordAttr(solPasswordAttr);
        }
        return userObj;
    }

    public void start() {
        this.bRunning = true;
        this.trace("UMgrCliTool.start");
    }

    public void stop() {
        this.bRunning = false;
    }

    public void trace(String string) {
        if (this.getDebugStatus()) {
            System.out.println(string);
        }
    }

    public void viewObjectProps() throws Exception {
    }
}

