/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.usermgr.common;

import com.sun.admin.cis.common.AdminCommonTools;
import com.sun.admin.tsol.common.AuditUserObj;
import com.sun.admin.usermgr.common.SolAccountAttr;
import com.sun.admin.usermgr.common.SolGroupAttr;
import com.sun.admin.usermgr.common.SolHomedirAttr;
import com.sun.admin.usermgr.common.SolPasswordAttr;
import com.sun.admin.usermgr.common.SolServicesAttr;
import com.sun.admin.usermgr.common.UserAttrObj;
import java.io.Serializable;

public class UserObj
implements Serializable,
Cloneable {
    public static final int MAX_DESCRIPTION_INTEGER_VALUE = 256;
    public static final int MAX_UID_USER_INTEGER_VALUE = Integer.MAX_VALUE;
    public static final int MIN_UID_USER_INTEGER_VALUE = 100;
    public static final int MIN_UID_SYSTEM_INTEGER_VALUE = 0;
    public static final int UID_NONE = 60001;
    public static final int UID_NOBODY = 60002;
    public static final int UID_FORMER_MAX = 65534;
    public static final String DEFAULT_PRIMARY_GROUP_NAME = "staff";
    public static final String DEFAULT_ROLE_GROUP_NAME = "sysadmin";
    private String strName = "";
    private String strFullName = "";
    private String strID = "";
    private String strDescription = "";
    private String strType = "";
    private String strTemplateName = "";
    private String initFilePath = "";
    private String scriptBefore = "";
    private String scriptAfter = "";
    private boolean delHomeDir = false;
    private boolean delMBox = false;
    private SolPasswordAttr solPasswd;
    private SolGroupAttr solGroup;
    private SolHomedirAttr solHomedir;
    private SolServicesAttr solServices;
    private SolAccountAttr solAccount;
    private UserAttrObj solAuthAttrs;
    private AuditUserObj tsolAudit;

    public UserObj() {
        this.solAuthAttrs = null;
        this.tsolAudit = null;
    }

    public UserObj(String string) {
        this.strName = string;
        this.solAuthAttrs = null;
        this.tsolAudit = null;
    }

    public Object clone() {
        try {
            UserObj userObj = (UserObj)super.clone();
            if (this.solPasswd != null) {
                userObj.solPasswd = (SolPasswordAttr)this.solPasswd.clone();
            }
            if (this.solAccount != null) {
                userObj.solAccount = (SolAccountAttr)this.solAccount.clone();
            }
            if (this.solGroup != null) {
                userObj.solGroup = (SolGroupAttr)this.solGroup.clone();
            }
            if (this.solHomedir != null) {
                userObj.solHomedir = (SolHomedirAttr)this.solHomedir.clone();
            }
            if (this.solServices != null) {
                userObj.solServices = (SolServicesAttr)this.solServices.clone();
            }
            if (this.solAuthAttrs != null) {
                userObj.solAuthAttrs = (UserAttrObj)this.solAuthAttrs.clone();
            }
            if (this.tsolAudit != null) {
                userObj.tsolAudit = (AuditUserObj)this.tsolAudit.clone();
            }
            return userObj;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void debugPrint() {
        AdminCommonTools.CMN_Trace3((String)"---------------------------------");
        AdminCommonTools.CMN_Trace3((String)"User Object is as follows:");
        AdminCommonTools.CMN_Trace3((String)("User name is " + this.strName));
        AdminCommonTools.CMN_Trace3((String)("User ID is " + this.strID));
        AdminCommonTools.CMN_Trace3((String)("User Description is " + this.strDescription));
        AdminCommonTools.CMN_Trace3((String)("User type is " + this.strType));
        AdminCommonTools.CMN_Trace3((String)("User Template is " + this.strTemplateName));
        AdminCommonTools.CMN_Trace3((String)("Delete Home dir is " + this.delHomeDir));
        AdminCommonTools.CMN_Trace3((String)("Delete MailBox is " + this.delMBox));
        if (this.solServices != null) {
            this.solServices.debugPrint();
        }
        if (this.solHomedir != null) {
            this.solHomedir.debugPrint();
        }
        if (this.solGroup != null) {
            this.solGroup.debugPrint();
        }
        if (this.solPasswd != null) {
            this.solPasswd.debugPrint();
        }
        if (this.solAccount != null) {
            this.solAccount.debugPrint();
        }
        if (this.solAuthAttrs != null) {
            this.solAuthAttrs.debugPrint();
        }
        AdminCommonTools.CMN_Trace3((String)"End of User Object");
        AdminCommonTools.CMN_Trace3((String)"---------------------------------");
    }

    public boolean equals(UserObj userObj) {
        if (!this.strName.equals(userObj.getUserName())) {
            return false;
        }
        if (!this.strFullName.equals(userObj.getUserFullName())) {
            return false;
        }
        if (!this.strTemplateName.equals(userObj.getTemplateName())) {
            return false;
        }
        if (!this.strID.equals(userObj.getUserID())) {
            return false;
        }
        if (!this.strDescription.equals(userObj.getUserDescription())) {
            return false;
        }
        if (!this.scriptBefore.equals(userObj.getScriptBefore())) {
            return false;
        }
        if (!this.initFilePath.equals(userObj.getInitFilePath())) {
            return false;
        }
        if (!this.scriptAfter.equals(userObj.getScriptAfter())) {
            return false;
        }
        if (!this.strType.equals(userObj.getUserType())) {
            return false;
        }
        if (this.delHomeDir != userObj.getDelHomeDir()) {
            return false;
        }
        if (this.delMBox != userObj.getDelMBox()) {
            return false;
        }
        SolPasswordAttr solPasswordAttr = userObj.getSolPasswordAttr();
        if (this.solPasswd != null) {
            if (solPasswordAttr == null) {
                return false;
            }
            if (!this.solPasswd.equals(solPasswordAttr)) {
                return false;
            }
        } else if (solPasswordAttr != null) {
            return false;
        }
        SolAccountAttr solAccountAttr = userObj.getSolAccountAttr();
        if (this.solAccount != null) {
            if (solAccountAttr == null) {
                return false;
            }
            if (!this.solAccount.equals(solAccountAttr)) {
                return false;
            }
        } else if (solAccountAttr != null) {
            return false;
        }
        SolGroupAttr solGroupAttr = userObj.getSolGroupAttr();
        if (this.solGroup != null) {
            if (solGroupAttr == null) {
                return false;
            }
            if (!this.solGroup.equals(solGroupAttr)) {
                return false;
            }
        } else if (solGroupAttr != null) {
            return false;
        }
        SolHomedirAttr solHomedirAttr = userObj.getSolHomedirAttr();
        if (this.solHomedir != null) {
            if (solHomedirAttr == null) {
                return false;
            }
            if (!this.solHomedir.equals(solHomedirAttr)) {
                return false;
            }
        } else if (solHomedirAttr != null) {
            return false;
        }
        SolServicesAttr solServicesAttr = userObj.getSolServicesAttr();
        if (this.solServices != null) {
            if (solServicesAttr == null) {
                return false;
            }
            if (!this.solServices.equals(solServicesAttr)) {
                return false;
            }
        } else if (solServicesAttr != null) {
            return false;
        }
        UserAttrObj userAttrObj = userObj.getSolAuthAttrs();
        if (this.solAuthAttrs != null) {
            if (userAttrObj == null) {
                return false;
            }
            if (!this.solAuthAttrs.equals(userAttrObj)) {
                return false;
            }
        } else if (userAttrObj != null) {
            return false;
        }
        return true;
    }

    public boolean getDelHomeDir() {
        return this.delHomeDir;
    }

    public boolean getDelMBox() {
        return this.delMBox;
    }

    public String getInitFilePath() {
        return this.initFilePath;
    }

    public String getScriptAfter() {
        return this.scriptAfter;
    }

    public String getScriptBefore() {
        return this.scriptBefore;
    }

    public SolAccountAttr getSolAccountAttr() {
        return this.solAccount;
    }

    public UserAttrObj getSolAuthAttrs() {
        return this.solAuthAttrs;
    }

    public SolGroupAttr getSolGroupAttr() {
        return this.solGroup;
    }

    public SolHomedirAttr getSolHomedirAttr() {
        return this.solHomedir;
    }

    public SolPasswordAttr getSolPasswordAttr() {
        return this.solPasswd;
    }

    public SolServicesAttr getSolServicesAttr() {
        return this.solServices;
    }

    public String getTemplateName() {
        return this.strTemplateName;
    }

    public AuditUserObj getTsolAudit() {
        return this.tsolAudit;
    }

    public String getUserDescription() {
        return this.strDescription;
    }

    public String getUserFullName() {
        return this.strFullName;
    }

    public String getUserID() {
        return this.strID;
    }

    public String getUserName() {
        return this.strName;
    }

    public String getUserType() {
        return this.strType;
    }

    public boolean requireModify() {
        if (this.solPasswd.requireModify()) {
            return true;
        }
        if (this.solHomedir.requireModify()) {
            return true;
        }
        return this.solServices.requireModify();
    }

    public void setDelHomeDir(boolean bl) {
        this.delHomeDir = bl;
    }

    public void setDelMBox(boolean bl) {
        this.delMBox = bl;
    }

    public void setInitFilePath(String string) {
        this.initFilePath = string;
    }

    public void setScriptAfter(String string) {
        this.scriptAfter = string;
    }

    public void setScriptBefore(String string) {
        this.scriptBefore = string;
    }

    public void setSolAccountAttr(SolAccountAttr solAccountAttr) {
        this.solAccount = solAccountAttr;
    }

    public void setSolAuthAttrs(UserAttrObj userAttrObj) {
        this.solAuthAttrs = userAttrObj;
    }

    public void setSolGroupAttr(SolGroupAttr solGroupAttr) {
        this.solGroup = solGroupAttr;
    }

    public void setSolHomedirAttr(SolHomedirAttr solHomedirAttr) {
        this.solHomedir = solHomedirAttr;
    }

    public void setSolPasswordAttr(SolPasswordAttr solPasswordAttr) {
        this.solPasswd = solPasswordAttr;
    }

    public void setSolServicesAttr(SolServicesAttr solServicesAttr) {
        this.solServices = solServicesAttr;
    }

    public void setTemplateName(String string) {
        this.strTemplateName = string;
    }

    public void setTsolAudit(AuditUserObj auditUserObj) {
        this.tsolAudit = auditUserObj;
    }

    public void setUserDescription(String string) {
        this.strDescription = string;
    }

    public void setUserFullName(String string) {
        this.strFullName = string;
    }

    public void setUserID(String string) {
        this.strID = string;
    }

    public void setUserName(String string) {
        this.strName = string;
    }

    public void setUserType(String string) {
        this.strType = string;
    }
}

