/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.usermgr.client;

import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.usermgr.client.Content;
import com.sun.admin.usermgr.client.FilterObj;
import com.sun.admin.usermgr.client.VUserMgr;
import com.sun.admin.usermgr.client.email.EmailContent;
import com.sun.admin.usermgr.client.groups.GroupContent;
import com.sun.admin.usermgr.client.rbac.RoleContent;
import com.sun.admin.usermgr.client.templates.TemplContent;
import com.sun.admin.usermgr.client.users.UserContent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;

public class UserActionsListener
implements ActionListener {
    public static final String DELETE = "Delete";
    public static final String FILTER_1STVIEW = "FilterInitialView";
    public static final String FIND = "Find";
    public static final String NEW = "New";
    public static final String OPEN = "Open";
    public static final String REFRESH = "Refresh";
    public static final String RENAME = "Rename";
    public static final String SHOW_ALL = "ShowAll";
    public static final String SHOW_BY_TYPE = "ShowByType";
    public static final String VIEW_PROPS = "ViewProps";
    public static final String MULTI_ADD = "MultiAdd";
    public static final String TEMPL_ADD = "AddWithTempl";
    public static final String TEMPL_MULTI_ADD = "MultiAddWithTempl";
    public static final String PASTE = "Paste";
    public static final String COPY = "Copy";
    public static final String USER_POL = "UserPolicies";
    public static final String ASSIGN = "Assign";
    public static final String ASSIGN_RIGHT = "Assign Right";
    public static final String ABOUT = "About";
    private boolean isUserAction;
    private Content content = null;
    private VUserMgr theApp;
    private ResourceBundle bundle;

    public UserActionsListener(VUserMgr vUserMgr) {
        this(vUserMgr, true);
    }

    public UserActionsListener(VUserMgr vUserMgr, boolean bl) {
        this.theApp = vUserMgr;
        this.isUserAction = bl;
        this.bundle = vUserMgr.getResourceBundle();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.isUserAction && this.theApp.isWaitOn()) {
            return;
        }
        String string = actionEvent.getActionCommand();
        Content content = this.theApp.getTree().getCurrentContent();
        if (string.compareTo(FIND) == 0) {
            content.find();
        } else if (string.compareTo(FILTER_1STVIEW) == 0) {
            String string2 = "";
            content.setShowAll(false);
            if (content instanceof UserContent) {
                string2 = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"users");
            } else if (content instanceof GroupContent) {
                string2 = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"groups");
            } else if (content instanceof EmailContent) {
                string2 = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"email");
            }
            FilterObj filterObj = new FilterObj(this.theApp, string2);
        } else if (string.compareTo(SHOW_ALL) == 0) {
            content.setShowAll(true);
            content.refresh();
        } else if (string.compareTo(DELETE) == 0) {
            content.deleteSelected();
        } else if (string.compareTo(NEW) == 0) {
            content.createProperties();
        } else if (string.compareTo(ASSIGN) == 0) {
            if (content instanceof RoleContent) {
                RoleContent roleContent = (RoleContent)content;
                roleContent.assignRole();
            }
        } else if (string.compareTo(ASSIGN_RIGHT) == 0) {
            if (content instanceof RoleContent) {
                RoleContent roleContent = (RoleContent)content;
                roleContent.assignRight();
            } else if (content instanceof UserContent) {
                UserContent userContent = (UserContent)content;
                userContent.assignRight();
            }
        } else if (string.compareTo(MULTI_ADD) == 0) {
            if (content instanceof UserContent) {
                UserContent userContent = (UserContent)content;
                userContent.addMultiUsers();
            }
        } else if (string.compareTo(TEMPL_ADD) == 0) {
            if (content instanceof UserContent) {
                UserContent userContent = (UserContent)content;
                userContent.addUserWithTempl();
            }
        } else if (string.compareTo(TEMPL_MULTI_ADD) == 0) {
            if (content instanceof UserContent) {
                UserContent userContent = (UserContent)content;
                userContent.addMultiUsersWithTempl();
            }
        } else if (string.compareTo(OPEN) == 0) {
            content.openSelected();
        } else if (string.compareTo(REFRESH) == 0) {
            content.refresh();
        } else if (string.compareTo(RENAME) == 0) {
            content.renameSelected();
        } else if (string.compareTo(COPY) == 0) {
            if (content instanceof UserContent) {
                UserContent userContent = (UserContent)content;
                userContent.copyUsers();
            } else if (content instanceof TemplContent) {
                TemplContent templContent = (TemplContent)content;
                templContent.cloneTempl();
            }
        } else if (string.compareTo(PASTE) == 0) {
            if (content instanceof GroupContent) {
                GroupContent groupContent = (GroupContent)content;
                groupContent.pasteUsers();
            } else if (content instanceof EmailContent) {
                EmailContent emailContent = (EmailContent)content;
                emailContent.pasteUsers();
            }
        } else if (string.compareTo(SHOW_BY_TYPE) == 0) {
            content.showByType();
        } else if (string.compareTo(USER_POL) == 0) {
            content.showUserPolicies();
        } else if (string.compareTo(VIEW_PROPS) == 0) {
            content.viewProperties();
        } else if (string.compareTo(ABOUT) == 0) {
            this.theApp.getTree().getCurrentContent().aboutBox();
        }
    }
}

