/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.console.gui;

import com.sun.management.viper.console.gui.VOptionPane;
import com.sun.management.viper.resources.ContextHelpLoader;
import com.sun.management.viper.util.BasicFileFilter;
import com.sun.management.viper.util.Debug;
import com.sun.management.viper.util.ResourceManager;
import com.sun.management.viperimpl.console.config.VBaseConfiguration;
import com.sun.management.viperimpl.console.config.VConfigurationInfo;
import com.sun.management.viperimpl.console.gui.BaseToolBoxChooser;
import com.sun.management.viperimpl.console.gui.ToolBoxChooser;
import com.sun.management.viperimpl.console.gui.ToolBoxChooserUI;
import com.sun.management.viperimpl.util.ImplResourceManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Vector;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicFileChooserUI;

public class LocalToolBoxChooserUI
extends BasicFileChooserUI
implements ToolBoxChooserUI {
    protected static final String TOOLBOX_EXT = "tbx";
    protected Action directoryComboBoxAction = new DirectoryComboBoxAction();
    protected DirectoryComboBoxModel directoryComboBoxModel = null;
    protected FilterComboBoxModel filterComboBoxModel = null;
    protected JComboBox directoryComboBox = null;
    protected JTextField filenameTextField = null;
    protected JPanel centerPanel = null;
    protected JList list = null;
    protected JButton approveButton = null;
    protected JButton cancelButton = null;
    protected JComboBox filterComboBox = null;
    protected JPanel bodyPanel = null;
    protected JLabel lookInLabel = null;
    protected JButton upButton = null;
    protected JButton homeButton = null;
    protected JButton folderButton = null;
    protected JLabel fileNameLabel = null;
    protected JLabel filesOfTypeLabel = null;
    protected JLabel descLabel = null;
    protected JTextArea description = null;
    protected JPanel resultPanel = null;
    protected JFileChooser hiddenFC = null;
    protected ToolBoxChooser chooser = null;
    protected String localOpenHelp = null;
    protected String localSaveHelp = null;
    protected String localTitle = null;
    protected static final Dimension hstrut10 = new Dimension(10, 1);
    protected static final Dimension hstrut25 = new Dimension(25, 1);
    protected static final Dimension vstrut10 = new Dimension(1, 10);
    protected static final Insets shrinkwrap = new Insets(0, 0, 0, 0);
    int lastIndex = -1;
    boolean editing = false;
    int editX = 20;
    int editWidth = 200;
    JTextField editCell = null;
    static final int space = 10;

    public LocalToolBoxChooserUI(ToolBoxChooser toolBoxChooser) {
        super(null);
        this.chooser = toolBoxChooser;
        this.localOpenHelp = ImplResourceManager.getString("OPENLOCALTOOLBOXHELP");
        this.localOpenHelp = ContextHelpLoader.getContextHelp((String)this.localOpenHelp, null);
        this.localSaveHelp = ImplResourceManager.getString("SAVELOCALTOOLBOXHELP");
        this.localSaveHelp = ContextHelpLoader.getContextHelp((String)this.localSaveHelp, null);
        this.localTitle = ImplResourceManager.getString("Local Toolbox");
        this.installUI(null);
        this.installComponents(toolBoxChooser);
        toolBoxChooser.setUIReference(this);
        toolBoxChooser.setTitle(this.localTitle);
        if (toolBoxChooser.getDialogType() == 0) {
            toolBoxChooser.setHelpHTML(this.localOpenHelp);
        } else {
            toolBoxChooser.setHelpHTML(this.localSaveHelp);
        }
    }

    protected void cancelEdit() {
        this.editing = false;
        if (this.editCell != null) {
            this.list.remove(this.editCell);
        }
    }

    protected JPanel createDesc() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.description = new JTextArea(){

            public Dimension getMinimumSize() {
                return new Dimension(super.getMinimumSize().width, 80);
            }
        };
        this.description.setEditable(false);
        this.description.setBackground(Color.lightGray);
        this.description.setLineWrap(true);
        this.description.setWrapStyleWord(true);
        JScrollPane jScrollPane = new JScrollPane(this.description);
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    protected DirectoryComboBoxModel createDirectoryComboBoxModel(JFileChooser jFileChooser) {
        return new DirectoryComboBoxModel();
    }

    protected DirectoryComboBoxRenderer createDirectoryComboBoxRenderer(JFileChooser jFileChooser) {
        return new DirectoryComboBoxRenderer();
    }

    protected FilterComboBoxModel createFilterComboBoxModel() {
        return new FilterComboBoxModel();
    }

    protected FilterComboBoxRenderer createFilterComboBoxRenderer() {
        return new FilterComboBoxRenderer();
    }

    protected JPanel createList(JFileChooser jFileChooser) {
        JPanel jPanel = new JPanel(new BorderLayout()){

            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, 80);
            }
        };
        this.list = new JList();
        this.list.setCellRenderer(new FileRenderer());
        this.list.setModel(this.getModel());
        this.list.addListSelectionListener(this.createListSelectionListener(jFileChooser));
        this.list.addMouseListener(this.createDoubleClickListener(jFileChooser, this.list));
        this.list.addMouseListener(this.createSingleClickListener(jFileChooser, this.list));
        JScrollPane jScrollPane = new JScrollPane(this.list);
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    public PropertyChangeListener createPropertyChangeListener(JFileChooser jFileChooser) {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("SelectedFileChangedProperty")) {
                    LocalToolBoxChooserUI.this.cancelEdit();
                    File file = (File)propertyChangeEvent.getNewValue();
                    if (file != null) {
                        LocalToolBoxChooserUI.this.setFileName(LocalToolBoxChooserUI.this.getFileChooser().getName(file));
                        if (LocalToolBoxChooserUI.this.getModel().contains(file)) {
                            LocalToolBoxChooserUI.this.list.setSelectedIndex(LocalToolBoxChooserUI.this.getModel().indexOf(file));
                            LocalToolBoxChooserUI.this.list.ensureIndexIsVisible(LocalToolBoxChooserUI.this.list.getSelectedIndex());
                        }
                    }
                    LocalToolBoxChooserUI.this.handleTBSelection();
                } else if (string.equals("directoryChanged")) {
                    LocalToolBoxChooserUI.this.cancelEdit();
                    LocalToolBoxChooserUI.this.clearIconCache();
                    LocalToolBoxChooserUI.this.list.clearSelection();
                    File file = LocalToolBoxChooserUI.this.getFileChooser().getCurrentDirectory();
                    if (file != null) {
                        LocalToolBoxChooserUI.this.directoryComboBoxModel.addItem(file);
                        LocalToolBoxChooserUI.this.folderButton.setEnabled(LocalToolBoxChooserUI.this.chooser.getDialogType() != 0 && file.canWrite());
                    }
                } else if (string.equals("fileSelectionChanged")) {
                    LocalToolBoxChooserUI.this.clearIconCache();
                    LocalToolBoxChooserUI.this.list.clearSelection();
                } else if (string == "AccessoryChangedProperty") {
                    if (LocalToolBoxChooserUI.this.getAccessoryPanel() != null) {
                        JComponent jComponent;
                        if (propertyChangeEvent.getOldValue() != null) {
                            LocalToolBoxChooserUI.this.getAccessoryPanel().remove((JComponent)propertyChangeEvent.getOldValue());
                        }
                        if ((jComponent = (JComponent)propertyChangeEvent.getNewValue()) != null) {
                            LocalToolBoxChooserUI.this.getAccessoryPanel().add((Component)jComponent, "Center");
                        }
                    }
                } else if (string == "ApproveButtonTextChangedProperty" || string == "DialogTypeChangedProperty") {
                    JFileChooser jFileChooser = LocalToolBoxChooserUI.this.getFileChooser();
                    LocalToolBoxChooserUI.this.approveButton.setText(LocalToolBoxChooserUI.this.getApproveButtonText(jFileChooser));
                    LocalToolBoxChooserUI.this.approveButton.setToolTipText(LocalToolBoxChooserUI.this.getApproveButtonToolTipText(jFileChooser));
                    LocalToolBoxChooserUI.this.approveButton.setMnemonic(LocalToolBoxChooserUI.this.getApproveButtonMnemonic(jFileChooser));
                } else if (string.equals("ApproveButtonMnemonicChangedProperty")) {
                    LocalToolBoxChooserUI.this.approveButton.setMnemonic(LocalToolBoxChooserUI.this.getApproveButtonMnemonic(LocalToolBoxChooserUI.this.getFileChooser()));
                }
            }
        };
    }

    protected MouseListener createSingleClickListener(JFileChooser jFileChooser, JList jList) {
        return new SingleClickListener(jList);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new LocalToolBoxChooserUI((BaseToolBoxChooser)((Object)jComponent));
    }

    public void ensureFileIsVisible(JFileChooser jFileChooser, File file) {
        if (this.getModel().contains(file)) {
            this.list.ensureIndexIsVisible(this.getModel().indexOf(file));
        }
    }

    protected JButton getApproveButton(JFileChooser jFileChooser) {
        return this.approveButton;
    }

    public String getDirectoryName() {
        return null;
    }

    public JFileChooser getFileChooser() {
        return this.hiddenFC;
    }

    public String getFileName() {
        if (this.filenameTextField != null) {
            return this.filenameTextField.getText();
        }
        return null;
    }

    public String getHelpHTML() {
        return this.localOpenHelp;
    }

    public JComponent getResultPanel() {
        return this.resultPanel;
    }

    public String getTitle() {
        return this.localTitle;
    }

    protected void handleTBSelection() {
        try {
            File file = this.hiddenFC.getSelectedFile();
            if (file == null || !file.isFile()) {
                this.description.setText("");
                this.chooser.setToolBoxURL(null);
                return;
            }
            VBaseConfiguration vBaseConfiguration = VBaseConfiguration.createConfiguration(file.toURL());
            VConfigurationInfo vConfigurationInfo = vBaseConfiguration.getInfo();
            this.description.setText(vConfigurationInfo.getDescription());
            this.chooser.setToolBoxURL(vConfigurationInfo.getURL());
            this.approveButton.setEnabled(true);
        }
        catch (Throwable throwable) {
            Debug.trace((String)"ConsoleManager", (int)Debug.ERROR, (String)"Problem loading toolbox", (Throwable)throwable);
            this.description.setText("");
            this.chooser.setToolBoxURL(null);
            this.approveButton.setEnabled(false);
        }
    }

    public void installComponents(ToolBoxChooser toolBoxChooser) {
        toolBoxChooser.toggleContentTitle(false);
        this.resultPanel = new JPanel();
        this.resultPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.resultPanel.setLayout(new BoxLayout(this.resultPanel, 1));
        this.resultPanel.add(Box.createRigidArea(vstrut10));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        this.resultPanel.add(jPanel);
        this.resultPanel.add(Box.createRigidArea(vstrut10));
        this.lookInLabel = new JLabel();
        this.lookInLabel.setAlignmentX(0.0f);
        this.lookInLabel.setAlignmentY(0.5f);
        jPanel.add(Box.createRigidArea(hstrut10));
        jPanel.add(this.lookInLabel);
        jPanel.add(Box.createRigidArea(hstrut25));
        this.directoryComboBox = new JComboBox();
        this.directoryComboBox.putClientProperty("JComboBox.lightweightKeyboardNavigation", "Lightweight");
        this.lookInLabel.setLabelFor(this.directoryComboBox);
        this.directoryComboBoxModel = this.createDirectoryComboBoxModel(this.hiddenFC);
        this.directoryComboBox.setModel(this.directoryComboBoxModel);
        this.directoryComboBox.addActionListener(this.directoryComboBoxAction);
        this.directoryComboBox.setRenderer(this.createDirectoryComboBoxRenderer(this.hiddenFC));
        this.directoryComboBox.setAlignmentX(0.0f);
        this.directoryComboBox.setAlignmentY(0.5f);
        jPanel.add(this.directoryComboBox);
        jPanel.add(Box.createRigidArea(hstrut10));
        this.upButton = new JButton(this.upFolderIcon);
        this.upButton.setAlignmentX(0.0f);
        this.upButton.setAlignmentY(0.5f);
        this.upButton.setMargin(shrinkwrap);
        this.upButton.addActionListener(this.getChangeToParentDirectoryAction());
        jPanel.add(this.upButton);
        jPanel.add(Box.createRigidArea(hstrut10));
        this.homeButton = new JButton(this.homeFolderIcon);
        this.homeButton.setAlignmentX(0.0f);
        this.homeButton.setAlignmentY(0.5f);
        this.homeButton.setMargin(shrinkwrap);
        this.homeButton.addActionListener(this.getGoHomeAction());
        jPanel.add(this.homeButton);
        jPanel.add(Box.createRigidArea(hstrut10));
        this.folderButton = new JButton(this.newFolderIcon);
        this.folderButton.setAlignmentX(0.0f);
        this.folderButton.setAlignmentY(0.5f);
        this.folderButton.setMargin(shrinkwrap);
        this.folderButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                File file = LocalToolBoxChooserUI.this.hiddenFC.getCurrentDirectory();
                File file2 = null;
                try {
                    file2 = LocalToolBoxChooserUI.this.hiddenFC.getFileSystemView().createNewFolder(file);
                    LocalToolBoxChooserUI.this.hiddenFC.rescanCurrentDirectory();
                    LocalToolBoxChooserUI.this.list.setModel(LocalToolBoxChooserUI.this.getModel());
                    int n = LocalToolBoxChooserUI.this.getModel().indexOf(file2);
                    LocalToolBoxChooserUI.this.list.setSelectedIndex(n);
                    LocalToolBoxChooserUI.this.list.ensureIndexIsVisible(n);
                    LocalToolBoxChooserUI.this.list.validate();
                    LocalToolBoxChooserUI.this.list.repaint();
                    LocalToolBoxChooserUI.this.list.setSelectedIndex(n);
                }
                catch (Throwable throwable) {}
            }
        });
        jPanel.add(this.folderButton);
        jPanel.add(Box.createRigidArea(hstrut10));
        this.centerPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = this.createList(this.hiddenFC);
        this.centerPanel.add((Component)jPanel2, "Center");
        this.centerPanel.add((Component)this.getAccessoryPanel(), "East");
        JComponent jComponent = this.hiddenFC.getAccessory();
        if (jComponent != null) {
            this.getAccessoryPanel().add(jComponent);
        }
        this.resultPanel.add(this.centerPanel);
        JPanel jPanel3 = new JPanel(){

            public Dimension getMaximumSize() {
                return new Dimension(super.getMaximumSize().width, super.getMinimumSize().height);
            }

            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, super.getMinimumSize().height);
            }
        };
        jPanel3.setLayout(new GridLayout(2, 1));
        EmptyBorder emptyBorder = new EmptyBorder(7, 0, 7, 0);
        this.fileNameLabel = new JLabel();
        this.fileNameLabel.setBorder(emptyBorder);
        jPanel3.add(this.fileNameLabel);
        this.filesOfTypeLabel = new JLabel();
        this.filesOfTypeLabel.setBorder(emptyBorder);
        jPanel3.add(this.filesOfTypeLabel);
        JPanel jPanel4 = new JPanel(){

            public Dimension getMaximumSize() {
                return new Dimension(super.getMaximumSize().width, super.getMinimumSize().height);
            }

            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, super.getMinimumSize().height);
            }
        };
        jPanel4.setLayout(new GridLayout(2, 1));
        this.filenameTextField = new JTextField();
        this.fileNameLabel.setLabelFor(this.filenameTextField);
        this.filenameTextField.addActionListener(this.getApproveSelectionAction());
        File file = this.hiddenFC.getSelectedFile();
        if (file != null) {
            this.setFileName(this.hiddenFC.getName(file));
        }
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout());
        jPanel5.add((Component)this.filenameTextField, "North");
        jPanel4.add(jPanel5);
        this.filterComboBoxModel = this.createFilterComboBoxModel();
        this.hiddenFC.addPropertyChangeListener(this.filterComboBoxModel);
        this.filterComboBox = new JComboBox(this.filterComboBoxModel);
        this.filesOfTypeLabel.setLabelFor(this.filterComboBox);
        this.filterComboBox.setRenderer(this.createFilterComboBoxRenderer());
        jPanel4.add(this.filterComboBox);
        JPanel jPanel6 = new JPanel(){

            public Dimension getMaximumSize() {
                return new Dimension(super.getMaximumSize().width, super.getMinimumSize().height);
            }

            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, super.getMinimumSize().height);
            }
        };
        jPanel6.setLayout(new BoxLayout(jPanel6, 0));
        jPanel6.add(jPanel3);
        jPanel6.add(Box.createHorizontalStrut(10));
        jPanel6.add(jPanel4);
        this.resultPanel.add(Box.createVerticalStrut(5));
        this.resultPanel.add(jPanel6);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BoxLayout(jPanel7, 0));
        this.descLabel = new JLabel();
        jPanel7.add(this.descLabel);
        jPanel7.add(Box.createHorizontalGlue());
        this.resultPanel.add(jPanel7);
        this.resultPanel.add(Box.createVerticalStrut(5));
        this.resultPanel.add(this.createDesc());
        this.resultPanel.add(Box.createVerticalStrut(10));
        this.resultPanel.add(Box.createVerticalGlue());
        toolBoxChooser.getContentPane().removeAll();
        toolBoxChooser.getContentPane().setLayout(new BorderLayout());
        toolBoxChooser.getContentPane().add((Component)this.resultPanel, "Center");
        this.approveButton = new JButton();
        this.approveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    File file = LocalToolBoxChooserUI.this.hiddenFC.getCurrentDirectory();
                    URL uRL = file.toURL();
                    String string = LocalToolBoxChooserUI.this.filenameTextField.getText();
                    if (!string.endsWith(".tbx")) {
                        string = String.valueOf(string) + ".tbx";
                    }
                    LocalToolBoxChooserUI.this.chooser.setToolBoxURL(new URL(uRL, string));
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                LocalToolBoxChooserUI.this.chooser.approveSelection();
            }
        });
        this.approveButton.setEnabled(false);
        toolBoxChooser.getButtonPane().add(this.approveButton);
        toolBoxChooser.getButtonPane().add(Box.createHorizontalStrut(5));
        this.cancelButton = new JButton();
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LocalToolBoxChooserUI.this.chooser.cancelSelection();
            }
        });
        toolBoxChooser.getButtonPane().add(this.cancelButton);
        this.installStrings();
    }

    protected void installStrings() {
        AccessibleContext accessibleContext;
        this.lookInLabel.setText(ImplResourceManager.getString("Look in:"));
        this.lookInLabel.setDisplayedMnemonic(ImplResourceManager.getString("Look in:_mnemonic").charAt(0));
        this.upButton.setToolTipText(ImplResourceManager.getString("UP_BUTTON_tooltip"));
        this.upButton.getAccessibleContext().setAccessibleName(ImplResourceManager.getString("UP_BUTTON_access_name"));
        this.homeButton.setToolTipText(ImplResourceManager.getString("HOME_BUTTON_tooltip"));
        this.homeButton.getAccessibleContext().setAccessibleName(ImplResourceManager.getString("HOME_BUTTON_access_name"));
        this.folderButton.setToolTipText(ImplResourceManager.getString("FOLDER_BUTTON_tooltip"));
        this.folderButton.getAccessibleContext().setAccessibleName(ImplResourceManager.getString("FOLDER_BUTTON_access_name"));
        this.fileNameLabel.setText(ImplResourceManager.getString("Filename:"));
        this.fileNameLabel.setDisplayedMnemonic(ImplResourceManager.getString("Filename:_mnemonic").charAt(0));
        this.filesOfTypeLabel.setText(ImplResourceManager.getString("Files of type:"));
        this.filesOfTypeLabel.setDisplayedMnemonic(ImplResourceManager.getString("Files of type:_mnemonic").charAt(0));
        this.descLabel.setText(ImplResourceManager.getString("Description:"));
        this.descLabel.setDisplayedMnemonic(ImplResourceManager.getString("Description:_mnemonic").charAt(0));
        if (this.chooser.getDialogType() == 0) {
            this.approveButton.setText(ImplResourceManager.getString("OPEN_BUTTON"));
            this.approveButton.setToolTipText(ImplResourceManager.getString("OPEN_BUTTON_tooltip"));
            this.approveButton.setMnemonic(ImplResourceManager.getString("OPEN_BUTTON_mnemonic").charAt(0));
            accessibleContext = this.approveButton.getAccessibleContext();
            accessibleContext.setAccessibleName(ImplResourceManager.getString("OPEN_BUTTON_access_name"));
            accessibleContext.setAccessibleDescription(ImplResourceManager.getString("OPEN_BUTTON_access_desc"));
        } else {
            this.approveButton.setText(ImplResourceManager.getString("SAVE_BUTTON"));
            this.approveButton.setToolTipText(ImplResourceManager.getString("SAVE_BUTTON_tooltip"));
            this.approveButton.setMnemonic(ImplResourceManager.getString("SAVE_BUTTON_mnemonic").charAt(0));
            accessibleContext = this.approveButton.getAccessibleContext();
            accessibleContext.setAccessibleName(ImplResourceManager.getString("SAVE_BUTTON_access_name"));
            accessibleContext.setAccessibleDescription(ImplResourceManager.getString("SAVE_BUTTON_access_desc"));
        }
        this.cancelButton.setText(ImplResourceManager.getString("CANCEL_BUTTON"));
        this.cancelButton.setToolTipText(ImplResourceManager.getString("CANCEL_BUTTON_tooltip"));
        this.cancelButton.setMnemonic(ImplResourceManager.getString("CANCEL_BUTTON_mnemonic").charAt(0));
        accessibleContext = this.cancelButton.getAccessibleContext();
        accessibleContext.setAccessibleName(ImplResourceManager.getString("CANCEL_BUTTON_access_name"));
        accessibleContext.setAccessibleDescription(ImplResourceManager.getString("CANCEL_BUTTON_access_desc"));
    }

    public void installUI(JComponent jComponent) {
        if (this.hiddenFC == null) {
            this.hiddenFC = new JFileChooser(){

                public void ensureFileIsVisible(File file) {
                    LocalToolBoxChooserUI.this.ensureFileIsVisible(LocalToolBoxChooserUI.this.hiddenFC, file);
                }

                public void rescanCurrentDirectory() {
                    LocalToolBoxChooserUI.this.rescanCurrentDirectory(LocalToolBoxChooserUI.this.hiddenFC);
                }
            };
            BasicFileFilter basicFileFilter = new BasicFileFilter(TOOLBOX_EXT, ImplResourceManager.getString("TOOLBOX_DESCRIPTION"));
            this.hiddenFC.setFileFilter((FileFilter)basicFileFilter);
        }
        super.installUI(this.hiddenFC);
    }

    public void refreshDisplay() {
        try {
            this.hiddenFC.setSelectedFile(null);
            this.filenameTextField.setText("");
            this.description.setText("");
            this.list.clearSelection();
            this.hiddenFC.rescanCurrentDirectory();
            this.list.setModel(this.getModel());
            if (this.chooser.getDialogType() == 1) {
                this.chooser.setHelpHTML(this.localSaveHelp);
                this.approveButton.setEnabled(true);
            } else {
                this.chooser.setHelpHTML(this.localOpenHelp);
                this.approveButton.setEnabled(false);
            }
            this.folderButton.setEnabled(this.chooser.getDialogType() != 0);
            this.installStrings();
            this.updateFontAndColor();
        }
        catch (Throwable throwable) {}
    }

    public void rescanCurrentDirectory(JFileChooser jFileChooser) {
        this.getModel().invalidateFileCache();
        this.getModel().validateFileCache();
    }

    public void setApproveButtonText(String string) {
    }

    public void setDirectoryName(String string) {
    }

    public void setFileName(String string) {
        if (this.filenameTextField != null) {
            this.filenameTextField.setText(string);
        }
    }

    public void setOptionPane(VOptionPane vOptionPane) {
    }

    public void uninstallUI(JComponent jComponent) {
        jComponent.removePropertyChangeListener(this.filterComboBoxModel);
        this.cancelButton.removeActionListener(this.getCancelSelectionAction());
        this.approveButton.removeActionListener(this.getApproveSelectionAction());
        this.filenameTextField.removeActionListener(this.getApproveSelectionAction());
        super.uninstallUI(jComponent);
    }

    protected void updateFontAndColor() {
        this.lookInLabel.setFont(ResourceManager.labelFont);
        this.lookInLabel.setForeground(ResourceManager.labelColor);
        this.directoryComboBox.setFont(ResourceManager.bodyFont);
        this.directoryComboBox.setForeground(ResourceManager.bodyColor);
        this.fileNameLabel.setFont(ResourceManager.labelFont);
        this.fileNameLabel.setForeground(ResourceManager.labelColor);
        this.filenameTextField.setFont(ResourceManager.bodyFont);
        this.filenameTextField.setForeground(ResourceManager.bodyColor);
        this.list.setFont(ResourceManager.bodyFont);
        this.list.setForeground(ResourceManager.bodyColor);
        this.filesOfTypeLabel.setFont(ResourceManager.labelFont);
        this.filesOfTypeLabel.setForeground(ResourceManager.labelColor);
        this.filterComboBox.setFont(ResourceManager.bodyFont);
        this.filterComboBox.setForeground(ResourceManager.bodyColor);
        this.descLabel.setFont(ResourceManager.labelFont);
        this.descLabel.setForeground(ResourceManager.labelColor);
        this.description.setFont(ResourceManager.bodyFont);
        this.description.setForeground(ResourceManager.bodyColor);
        this.approveButton.setFont(ResourceManager.menuFont);
        this.approveButton.setForeground(ResourceManager.menuColor);
        this.cancelButton.setFont(ResourceManager.menuFont);
        this.cancelButton.setForeground(ResourceManager.menuColor);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        File file = this.getFileChooser().getSelectedFile();
        if (!listSelectionEvent.getValueIsAdjusting() && file != null && !this.getFileChooser().isTraversable(file)) {
            this.setFileName(this.getFileChooser().getName(file));
        }
    }

    protected class SingleClickListener
    extends MouseAdapter {
        JList list;

        public SingleClickListener(JList jList) {
            this.list = jList;
            LocalToolBoxChooserUI.this.editCell = new JTextField();
            LocalToolBoxChooserUI.this.editCell.addActionListener(new EditActionListener());
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 1) {
                int n = this.list.locationToIndex(mouseEvent.getPoint());
                if (LocalToolBoxChooserUI.this.lastIndex == n && !LocalToolBoxChooserUI.this.editing) {
                    LocalToolBoxChooserUI.this.editing = true;
                    Rectangle rectangle = this.list.getCellBounds(n, n);
                    this.list.add(LocalToolBoxChooserUI.this.editCell);
                    File file = (File)this.list.getSelectedValue();
                    LocalToolBoxChooserUI.this.editCell.setText(LocalToolBoxChooserUI.this.getFileChooser().getName(file));
                    LocalToolBoxChooserUI.this.editCell.setBounds(LocalToolBoxChooserUI.this.editX + rectangle.x, rectangle.y, LocalToolBoxChooserUI.this.editWidth, rectangle.height);
                    LocalToolBoxChooserUI.this.editCell.selectAll();
                } else {
                    LocalToolBoxChooserUI.this.lastIndex = n;
                    LocalToolBoxChooserUI.this.cancelEdit();
                }
            } else {
                LocalToolBoxChooserUI.this.cancelEdit();
            }
            this.list.repaint();
        }
    }

    class EditActionListener
    implements ActionListener {
        EditActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            File file;
            JTextField jTextField = (JTextField)actionEvent.getSource();
            File file2 = (File)LocalToolBoxChooserUI.this.list.getSelectedValue();
            String string = jTextField.getText();
            if (!(string = string.trim()).equals(LocalToolBoxChooserUI.this.getFileChooser().getName(file2)) && file2.renameTo(file = LocalToolBoxChooserUI.this.getFileChooser().getFileSystemView().createFileObject(LocalToolBoxChooserUI.this.getFileChooser().getCurrentDirectory(), string))) {
                LocalToolBoxChooserUI.this.rescanCurrentDirectory(LocalToolBoxChooserUI.this.getFileChooser());
            }
            LocalToolBoxChooserUI.this.cancelEdit();
            LocalToolBoxChooserUI.this.list.repaint();
        }
    }

    protected class FileRenderer
    extends DefaultListCellRenderer {
        protected FileRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            File file = (File)object;
            String string = LocalToolBoxChooserUI.this.getFileChooser().getName(file);
            this.setText(string);
            Icon icon = LocalToolBoxChooserUI.this.getFileChooser().getIcon(file);
            this.setIcon(icon);
            if (bl) {
                LocalToolBoxChooserUI.this.editX = icon.getIconWidth() + 4;
            }
            return this;
        }
    }

    class DirectoryComboBoxRenderer
    extends DefaultListCellRenderer {
        IndentIcon ii;

        DirectoryComboBoxRenderer() {
            this.ii = new IndentIcon();
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Object object2;
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            File file = (File)object;
            if (file == null) {
                this.setText("");
                return this;
            }
            String string = LocalToolBoxChooserUI.this.getFileChooser().getName(file);
            this.setText(string);
            int n2 = 0;
            if (n != -1) {
                object2 = file;
                while (((File)object2).getParent() != null) {
                    ++n2;
                    object2 = LocalToolBoxChooserUI.this.getFileChooser().getFileSystemView().createFileObject(((File)object2).getParent());
                }
            }
            this.ii.icon = object2 = LocalToolBoxChooserUI.this.getFileChooser().getIcon(file);
            this.ii.depth = n2;
            this.setIcon(this.ii);
            return this;
        }
    }

    class IndentIcon
    implements Icon {
        Icon icon = null;
        int depth = 0;

        IndentIcon() {
        }

        public int getIconHeight() {
            return this.icon.getIconHeight();
        }

        public int getIconWidth() {
            return this.icon.getIconWidth() + this.depth * 10;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            this.icon.paintIcon(component, graphics, n + this.depth * 10, n2);
        }
    }

    protected class DirectoryComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        Vector directories = new Vector();
        int topIndex = -1;
        int pathCount = 0;
        File selectedDirectory = null;

        public DirectoryComboBoxModel() {
            File[] fileArray = LocalToolBoxChooserUI.this.getFileChooser().getFileSystemView().getRoots();
            int n = 0;
            while (n < fileArray.length) {
                this.directories.addElement(fileArray[n]);
                ++n;
            }
            this.addItem(LocalToolBoxChooserUI.this.getFileChooser().getCurrentDirectory());
        }

        protected void addItem(File file) {
            if (file == null) {
                return;
            }
            if (this.selectedDirectory != null) {
                this.removeSelectedDirectory();
            }
            File file2 = null;
            try {
                file2 = LocalToolBoxChooserUI.this.getFileChooser().getFileSystemView().createFileObject(file.getCanonicalPath());
            }
            catch (IOException iOException) {}
            File file3 = file2;
            Vector<File> vector = new Vector<File>(10);
            while (file3.getParent() != null) {
                vector.addElement(file3);
                if (this.directories.contains(file3)) {
                    this.topIndex = this.directories.indexOf(file3);
                }
                file3 = LocalToolBoxChooserUI.this.getFileChooser().getFileSystemView().createFileObject(file3.getParent());
            }
            this.pathCount = vector.size();
            if (this.topIndex < 0 && this.directories.contains(file3)) {
                this.topIndex = this.directories.indexOf(file3);
            }
            int n = 0;
            while (n < vector.size()) {
                this.directories.insertElementAt(vector.elementAt(n), this.topIndex + 1);
                ++n;
            }
            this.setSelectedItem(file2);
        }

        public Object getElementAt(int n) {
            return this.directories.elementAt(n);
        }

        public Object getSelectedItem() {
            return this.selectedDirectory;
        }

        public int getSize() {
            return this.directories.size();
        }

        protected void removeSelectedDirectory() {
            if (this.topIndex >= 0) {
                int n = this.topIndex;
                while (n < this.topIndex + this.pathCount) {
                    this.directories.removeElementAt(this.topIndex + 1);
                    ++n;
                }
            }
            this.topIndex = -1;
            this.pathCount = 0;
            this.selectedDirectory = null;
        }

        public void setSelectedItem(Object object) {
            this.selectedDirectory = (File)object;
            this.fireContentsChanged(this, -1, -1);
        }
    }

    public class FilterComboBoxRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            FileFilter fileFilter = (FileFilter)object;
            if (fileFilter != null) {
                this.setText(fileFilter.getDescription());
            }
            return this;
        }
    }

    protected class FilterComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    PropertyChangeListener {
        protected FileFilter[] filters;

        protected FilterComboBoxModel() {
            this.filters = LocalToolBoxChooserUI.this.getFileChooser().getChoosableFileFilters();
        }

        public Object getElementAt(int n) {
            if (n > this.getSize() - 1) {
                return LocalToolBoxChooserUI.this.getFileChooser().getFileFilter();
            }
            if (this.filters != null) {
                return this.filters[n];
            }
            return null;
        }

        public Object getSelectedItem() {
            FileFilter fileFilter = LocalToolBoxChooserUI.this.getFileChooser().getFileFilter();
            boolean bl = false;
            if (fileFilter != null) {
                int n = 0;
                while (n < this.filters.length) {
                    if (this.filters[n] == fileFilter) {
                        bl = true;
                    }
                    ++n;
                }
                if (!bl) {
                    LocalToolBoxChooserUI.this.getFileChooser().addChoosableFileFilter(fileFilter);
                }
            }
            return LocalToolBoxChooserUI.this.getFileChooser().getFileFilter();
        }

        public int getSize() {
            if (this.filters != null) {
                return this.filters.length;
            }
            return 0;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string == "ChoosableFileFilterChangedProperty") {
                this.filters = (FileFilter[])propertyChangeEvent.getNewValue();
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public void setSelectedItem(Object object) {
            if (object != null) {
                LocalToolBoxChooserUI.this.getFileChooser().setFileFilter((FileFilter)object);
                this.fireContentsChanged(this, -1, -1);
            }
        }
    }

    protected class DirectoryComboBoxAction
    extends AbstractAction {
        protected DirectoryComboBoxAction() {
            super("DirectoryComboBoxAction");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LocalToolBoxChooserUI.this.hiddenFC.setCurrentDirectory((File)LocalToolBoxChooserUI.this.directoryComboBox.getSelectedItem());
        }
    }
}

