/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.utility.directorytable;

import com.sun.wbem.utility.common.CommonTools;
import com.sun.wbem.utility.directorytable.TableSetup;
import java.util.StringTokenizer;
import java.util.Vector;

public class DirectoryTableSetup
implements TableSetup {
    protected static final int NUM_OF_DIRSERVICES = 5;
    private static final String grepCmd = "/bin/grep";
    private static final String sedCmd = "/bin/sed";
    private static final String nssFileName = "/etc/nsswitch.conf";
    protected static final String[] dirServiceName = new String[]{"File", "Nis", "Nisplus", "Dns", "Ldap"};

    public Vector getNameServiceSwitchOrder(String string) {
        Vector<String> vector = null;
        String[] stringArray = new String[]{"sh", "-c", "/bin/grep '^" + string + ":' " + nssFileName + " | " + sedCmd + " 's/^" + string + "://'"};
        String[] stringArray2 = CommonTools.CMN_exec(stringArray);
        if (stringArray2.length < 1) {
            return vector;
        }
        stringArray2[0].trim();
        StringTokenizer stringTokenizer = new StringTokenizer(stringArray2[0], " \t\n\r");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            string2.trim();
            if (string2.equals("files")) {
                if (vector == null) {
                    vector = new Vector<String>();
                }
                vector.addElement("file");
            }
            if (string2.equals("nisplus")) {
                if (vector == null) {
                    vector = new Vector();
                }
                vector.addElement("nisplus");
            }
            if (string2.equals("nis")) {
                if (vector == null) {
                    vector = new Vector();
                }
                vector.addElement("nis");
            }
            if (string2.equals("dns")) {
                if (vector == null) {
                    vector = new Vector();
                }
                vector.addElement("dns");
            }
            if (string2.equals("ldap")) {
                if (vector == null) {
                    vector = new Vector();
                }
                vector.addElement("ldap");
            }
            if (string2.indexOf("NOTFOUND = return") == -1) continue;
            return vector;
        }
        return vector;
    }

    public Vector getScopes(int n) {
        Vector vector = null;
        Vector<String> vector2 = null;
        if ((n & 1) == 1) {
            vector2 = this.getNameServiceSwitchOrder("group");
            if (vector2 == null) {
                return vector;
            }
        } else {
            vector2 = new Vector<String>(4);
            vector2.addElement("File");
            vector2.addElement("Nis");
            vector2.addElement("Nisplus");
            vector2.addElement("Dns");
            vector2.addElement("Ldap");
        }
        int n2 = 0;
        while (n2 < vector2.size()) {
            String string = (String)vector2.elementAt(n2);
            Vector vector3 = this.getScopes(string = String.valueOf(string.substring(0, 1).toUpperCase()) + string.substring(1, string.length()).toLowerCase(), n);
            if (vector3 != null) {
                if (vector == null) {
                    vector = new Vector();
                }
                int n3 = 0;
                while (n3 < vector3.size()) {
                    vector.addElement(vector3.elementAt(n3));
                    ++n3;
                }
            }
            ++n2;
        }
        return vector;
    }

    public Vector getScopes(String string, int n) {
        Vector vector = null;
        String string2 = String.valueOf(string.substring(0, 1).toUpperCase()) + string.substring(1, string.length()).toLowerCase();
        String string3 = "com.sun.wbem.utility.directorytable." + string2 + "DirectoryTable";
        try {
            TableSetup tableSetup = (TableSetup)Class.forName(string3).newInstance();
            if (tableSetup != null) {
                vector = tableSetup.getScopes(n);
            }
            tableSetup = null;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {}
        return vector;
    }

    public static void main(String[] stringArray) {
        DirectoryTableSetup directoryTableSetup = new DirectoryTableSetup();
        if (stringArray[0].equals("initial")) {
            directoryTableSetup.setup();
        } else if (stringArray[0].equals("refresh")) {
            directoryTableSetup.refreshSetup();
        } else if (stringArray[0].equals("scopes")) {
            System.out.println("Getting list of managable scopes...");
            Vector vector = directoryTableSetup.getScopes(0);
            if (vector != null) {
                int n = 0;
                while (n < vector.size()) {
                    System.out.println("Scope " + (n + 1) + " " + vector.elementAt(n));
                    ++n;
                }
            }
        }
    }

    public void refreshSetup() {
        int n = 0;
        while (n < 5) {
            String string = "com.sun.wbem.utility.directorytable." + dirServiceName[n] + "DirectoryTable";
            try {
                TableSetup tableSetup = (TableSetup)Class.forName(string).newInstance();
                if (tableSetup != null) {
                    tableSetup.refreshSetup();
                }
                tableSetup = null;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
            ++n;
        }
    }

    public void setup() {
        int n = 0;
        while (n < 5) {
            String string = "com.sun.wbem.utility.directorytable." + dirServiceName[n] + "DirectoryTable";
            try {
                TableSetup tableSetup = (TableSetup)Class.forName(string).newInstance();
                if (tableSetup != null) {
                    tableSetup.setup();
                }
                tableSetup = null;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
            ++n;
        }
    }
}

