/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.utility.directorytable;

import com.sun.wbem.utility.directorytable.DirectoryTableInvalidParameterException;
import com.sun.wbem.utility.directorytable.TableDefinitions;
import java.util.StringTokenizer;

public class LdapTableDefinitions
implements TableDefinitions {
    static int NUMBER_OF_TABLES = 15;
    static int TABLE_NAME = 0;
    static int MAPPED_TABLE_NAME = 1;
    static int COLUMN_SEPARATORS = 2;
    static int COMMENT_SEPARATORS = 3;
    static int USERID = 4;
    static int GROUPID = 5;
    static int ACCESS = 6;
    static int TABLE_ATTRIBUTES = 7;
    static int TABLE_TYPE = 8;
    static int NUMBER_OF_COLUMNS = 9;
    static int USER_DEFINED = 99;
    static String[][] definitions = new String[][]{{"ethers", "ou = Hosts, ou = Services, %DN%", " \t", "#", "0", "3", Integer.toString(4351), Integer.toString(4), "ieee802Device", "3", "name", "cn", "", Integer.toString(41), "addr", "macAddress", "", Integer.toString(3), "comment", "", "", Integer.toString(8)}, {"netmasks", "ou = Hosts, ou = Services, %DN%", " \t", "#", "0", "3", Integer.toString(4351), Integer.toString(4), "ipNetwork", "3", "addr", "ipNetworkNumber", "", Integer.toString(35), "mask", "ipNetmaskNumber", "", Integer.toString(3), "comment", "description", "", Integer.toString(8)}, {"group", "ou = Group, ou = Services, %DN%", ":", "#", "0", "3", Integer.toString(4351), Integer.toString(10), "posixGroup", "4", "name", "cn", "", Integer.toString(41), "passwd", "userPassword", "", Integer.toString(8), "gid", "gidNumber", "", Integer.toString(5), "members", "memberUid", "", Integer.toString(8)}, {"hosts", "ou = Hosts, ou = Services, %DN%", " \t", "#", "0", "3", Integer.toString(4351), Integer.toString(4), "ipHost", "3", "cname", "cn", "", Integer.toString(41), "addr", "ipHostNumber", "", Integer.toString(3), "comment", "description", "", Integer.toString(8)}, {"networks", "ou = Networks, ou = Services, %DN%", " \t", "#", "0", "3", Integer.toString(4351), Integer.toString(4), "ipNetwork", "4", "cname", "cn", "", Integer.toString(41), "aliases", "cn", "", Integer.toString(9), "addr", "ipNetworkNumber", "", Integer.toString(3), "comment", "description", "", Integer.toString(8)}, {"passwd", "ou = people, %DN%", ":", "#", "0", "3", Integer.toString(4351), Integer.toString(10), "posixAccount", "8", "cn", "cn", "name", Integer.toString(41), "name", "uid", "", Integer.toString(9), "passwd", "userPassword", "", Integer.toString(8), "uid", "uidNumber", "", Integer.toString(5), "gid", "gidNumber", "", Integer.toString(4), "gcos", "gecos", "", Integer.toString(8), "home", "homeDirectory", "", Integer.toString(8), "shell", "loginShell", "", Integer.toString(8), "description", "description", "", Integer.toString(8)}, {"shadow", "ou = People, %DN%", ":", "#", "0", "3", Integer.toString(4351), Integer.toString(10), "shadowAccount", "10", "name", "uid", "", Integer.toString(41), "passwd", "userPassword", "", Integer.toString(8), "lastchg", "shadowLastChange", "", Integer.toString(8), "min", "shadowMin", "", Integer.toString(8), "max", "shadowMax", "", Integer.toString(8), "warn", "shadowWarning", "", Integer.toString(8), "inactive", "shadowInactive", "", Integer.toString(8), "expire", "shadowExpire", "", Integer.toString(8), "flag", "shadowFlag", "", Integer.toString(8), "description", "description", "", Integer.toString(8)}, {"protocols", "ou = protocols, ou = Services, %DN%", " \t", "#", "0", "3", Integer.toString(4351), Integer.toString(4), "ipProtocol", "4", "cname", "cn", "", Integer.toString(41), "aliases", "cn", "", Integer.toString(9), "number", "ipProtocolNumber", "", Integer.toString(9), "comment", "description", "", Integer.toString(8)}, {"rpc", "ou = rpc, ou = Services, %DN%", " \t", "#", "0", "3", Integer.toString(4351), Integer.toString(4), "oncRpc", "4", "cname", "cn", "", Integer.toString(41), "aliases", "cn", "", Integer.toString(9), "number", "oncRpcNumber", "", Integer.toString(5), "comment", "description", "", Integer.toString(8)}, {"aliases", "ou = aliases, ou = Services, %DN%", ":", "#", "0", "3", Integer.toString(4351), Integer.toString(6), "nisMailAlias", "3", "alias", "cn", "", Integer.toString(41), "expansion", "", "nisMailAlias", Integer.toString(8), "comment", "", "", Integer.toString(8)}, {"user_attr", "ou = People, %DN%", ":", "#", "0", "3", Integer.toString(511), Integer.toString(26), "SolarisUserAttr", "5", "name", "uid", "", Integer.toString(41), "qualifier", "SolarisUserQualifier", "", Integer.toString(9), "res1", "SolarisAttrReserved1", "", Integer.toString(8), "res2", "SolarisAttrReserved2", "", Integer.toString(8), "attr", "SolarisAttrKeyValue", "", Integer.toString(8)}, {"auth_attr", "ou = SolarisAuthAttr, %DN%", ":", "#", "0", "3", Integer.toString(511), Integer.toString(26), "SolarisAuthAttr", "6", "name", "cn", "", Integer.toString(41), "res1", "SolarisAttrReserved1", "", Integer.toString(8), "res2", "SolarisAttrReserved2", "", Integer.toString(8), "short_descr", "SolarisAttrShortDesc", "", Integer.toString(8), "long_descr", "SolarisAttrLongDesc", "", Integer.toString(8), "attr", "SolarisAttrKeyValue", "", Integer.toString(8)}, {"prof_attr", "ou = SolarisProfAttr, %DN%", ":", "#", "0", "3", Integer.toString(511), Integer.toString(26), "SolarisProfAttr", "5", "name", "cn", "", Integer.toString(41), "res1", "SolarisAttrReserved1", "", Integer.toString(8), "res2", "SolarisAttrReserved2", "", Integer.toString(8), "long_descr", "SolarisAttrLongDesc", "", Integer.toString(8), "attr", "SolarisAttrKeyValue", "", Integer.toString(8)}, {"exec_attr", "ou = SolarisProfAttr, %DN%", ":", "#", "0", "3", Integer.toString(511), Integer.toString(26), "SolarisExecAttr", "7", "name", "cn", "", Integer.toString(41), "policy", "SolarisKernelSecurityPolicy", "", Integer.toString(41), "type", "SolarisProfileType", "", Integer.toString(40), "res1", "SolarisAttrReserved1", "", Integer.toString(8), "res2", "SolarisAttrReserved1", "", Integer.toString(8), "id", "SolarisProfileId", "", Integer.toString(41), "attr", "SolarisAttrKeyValue", "", Integer.toString(8)}, {"audit_user", "ou = People, %DN%", ":", "#", "0", "3", Integer.toString(511), Integer.toString(26), "SolarisAuditUser", "3", "name", "cn", "", Integer.toString(41), "alwaysauditflags", "SolarisAuditAlways", "", Integer.toString(8), "neverauditflags", "SolarisAuditNever", "", Integer.toString(8)}};
    int tableIndex;
    String tableName;
    String tableType;
    String mappedTableName;
    String columnSeparators;
    String commentSeparators;
    int numberOfColumns;
    int tableAttributes;
    int[] columnAttributes;
    String[] columnNames;
    String[] mappedColumnNames;
    String[] secondaryMappedColumnNames;
    String serverName;
    String domainName;
    int userId;
    int groupId;
    int access;

    public LdapTableDefinitions(String string, String string2) {
        this.serverName = string;
        this.domainName = string2;
        this.tableIndex = USER_DEFINED;
        this.tableName = "";
        this.tableType = "";
        this.mappedTableName = "";
        this.columnSeparators = " \t";
        this.commentSeparators = "#";
        this.tableAttributes = 0;
        this.columnNames = null;
        this.mappedColumnNames = null;
        this.secondaryMappedColumnNames = null;
        this.columnAttributes = null;
        this.userId = 0;
        this.groupId = 3;
        this.access = 4351;
    }

    private String expandMacros(String string) {
        String string2 = "";
        String string3 = null;
        StringTokenizer stringTokenizer = null;
        stringTokenizer = new StringTokenizer(string, "%");
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
            string2 = string3.compareTo("DN") == 0 ? String.valueOf(string2) + this.generateDNFromDomain(this.domainName) : String.valueOf(string2) + string3;
        }
        return string2;
    }

    private String generateDNFromDomain(String string) {
        StringTokenizer stringTokenizer = null;
        String string2 = null;
        String string3 = "";
        stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            string3 = String.valueOf(string3) + "dc = " + string2;
            if (!stringTokenizer.hasMoreTokens()) continue;
            string3 = String.valueOf(string3) + ", ";
        }
        return string3;
    }

    public int getAccess() {
        return this.access;
    }

    public String getAuxilliaryColumnData(int n) throws DirectoryTableInvalidParameterException {
        if (n < 0 || n > this.numberOfColumns) {
            throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
        }
        return this.secondaryMappedColumnNames[n - 1];
    }

    public int getColumnAttributes(int n) throws DirectoryTableInvalidParameterException {
        if (n <= this.numberOfColumns && n > 0) {
            return this.columnAttributes[n - 1];
        }
        throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
    }

    public String getColumnName(int n) throws DirectoryTableInvalidParameterException {
        if (n < 0 || n > this.numberOfColumns) {
            throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
        }
        return this.columnNames[n - 1];
    }

    public int getColumnNumber(String string) throws DirectoryTableInvalidParameterException {
        int n = 0;
        while (n < this.numberOfColumns) {
            if (this.columnNames[n].equalsIgnoreCase(string)) {
                return n + 1;
            }
            ++n;
        }
        throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
    }

    public String getColumnSeparators() {
        return this.columnSeparators;
    }

    public String getCommentSeparators() {
        return this.commentSeparators;
    }

    public int getGroup() {
        return this.groupId;
    }

    public String getMappedColumnName(int n) throws DirectoryTableInvalidParameterException {
        if (n < 0 || n > this.numberOfColumns) {
            throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
        }
        return this.mappedColumnNames[n - 1];
    }

    public String getMappedTableName() {
        return this.expandMacros(this.mappedTableName);
    }

    public int getNumberOfColumns() {
        return this.numberOfColumns;
    }

    public String getRawMappedTableName() {
        return this.mappedTableName;
    }

    public int getTableAttributes() {
        return this.tableAttributes;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getTableType() {
        return this.tableType;
    }

    public int getUser() {
        return this.userId;
    }

    public void loadTableDefinitions(String string) throws DirectoryTableInvalidParameterException {
        this.tableName = string;
        int n = 0;
        while (n < NUMBER_OF_TABLES) {
            if (string.equalsIgnoreCase(definitions[n][TABLE_NAME])) {
                this.tableIndex = n;
                this.tableName = definitions[n][TABLE_NAME];
                this.mappedTableName = definitions[n][MAPPED_TABLE_NAME];
                this.columnSeparators = definitions[n][COLUMN_SEPARATORS];
                this.commentSeparators = definitions[n][COMMENT_SEPARATORS];
                this.userId = Integer.valueOf(definitions[n][USERID]);
                this.groupId = Integer.valueOf(definitions[n][GROUPID]);
                this.access = Integer.valueOf(definitions[n][ACCESS]);
                this.tableAttributes = Integer.valueOf(definitions[n][TABLE_ATTRIBUTES]);
                this.tableType = definitions[n][TABLE_TYPE];
                this.numberOfColumns = Integer.valueOf(definitions[n][NUMBER_OF_COLUMNS]);
                this.columnNames = new String[this.numberOfColumns];
                this.mappedColumnNames = new String[this.numberOfColumns];
                this.secondaryMappedColumnNames = new String[this.numberOfColumns];
                this.columnAttributes = new int[this.numberOfColumns];
                int n2 = 0;
                while (n2 < this.numberOfColumns) {
                    this.columnNames[n2] = definitions[n][NUMBER_OF_COLUMNS + n2 * 4 + 1];
                    this.mappedColumnNames[n2] = definitions[n][NUMBER_OF_COLUMNS + n2 * 4 + 2];
                    this.secondaryMappedColumnNames[n2] = definitions[n][NUMBER_OF_COLUMNS + n2 * 4 + 3];
                    this.columnAttributes[n2] = Integer.valueOf(definitions[n][NUMBER_OF_COLUMNS + n2 * 4 + 4]);
                    ++n2;
                }
                break;
            }
            ++n;
        }
        if (n == NUMBER_OF_TABLES) {
            throw new DirectoryTableInvalidParameterException("EXM_NOTABLEDEF", string);
        }
    }

    public void setAccess(int n) {
        this.access = n;
    }

    public void setAuxilliaryColumnData(int n, String string) throws DirectoryTableInvalidParameterException {
        if (n > this.numberOfColumns || n <= 0) {
            throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
        }
        this.secondaryMappedColumnNames[n - 1] = string;
    }

    public void setColumnAttributes(int n, int n2) throws DirectoryTableInvalidParameterException {
        if (n > this.numberOfColumns || n <= 0) {
            throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
        }
        this.columnAttributes[n - 1] = n2;
    }

    public void setColumnName(int n, String string) throws DirectoryTableInvalidParameterException {
        if (n > this.numberOfColumns || n <= 0) {
            throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
        }
        this.columnNames[n - 1] = string;
    }

    public void setColumnSeparators(String string) {
        this.columnSeparators = string;
    }

    public void setCommentSeparators(String string) {
        this.commentSeparators = string;
    }

    public void setGroup(int n) {
        this.groupId = n;
    }

    public void setMappedColumnName(int n, String string) throws DirectoryTableInvalidParameterException {
        if (n > this.numberOfColumns || n <= 0) {
            throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
        }
        this.mappedColumnNames[n - 1] = string;
    }

    public void setMappedTableName(String string) {
        this.mappedTableName = string;
    }

    public void setNumberOfColumns(int n) throws DirectoryTableInvalidParameterException {
        if (n < 0) {
            throw new DirectoryTableInvalidParameterException();
        }
        this.numberOfColumns = n;
        this.columnNames = new String[this.numberOfColumns];
        this.columnAttributes = new int[this.numberOfColumns];
    }

    public void setTableAttributes(int n) {
        this.tableAttributes = n;
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public void setTableType(String string) {
        this.tableType = string;
    }

    public void setUser(int n) {
        this.userId = n;
    }
}

