/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.usermgr.cli.execs;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.CommandLineOption;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.tsol.common.BadLabelException;
import com.sun.admin.tsol.common.UserSecurityInfo;
import com.sun.admin.tsol.server.TrustedSolarisServiceInterface;
import com.sun.admin.usermgr.cli.UMgrCliTool;
import com.sun.admin.usermgr.common.ExecAttrObj;
import com.sun.admin.usermgr.common.RightObj;
import com.sun.admin.usermgr.common.UserException;
import com.sun.admin.usermgr.common.UserMgrCliArgParsingException;
import com.sun.admin.usermgr.common.UserMgrCliHelpException;
import com.sun.management.viper.ToolInfrastructure;
import com.sun.management.viper.util.CommandOption;
import com.sun.management.viper.util.CommandParser;
import com.sun.management.viper.util.ResourceManager;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;

public class UserMgrExecCli
extends UMgrCliTool {
    private Vector vObjs = new Vector();
    private boolean bListAll;
    private boolean bLongList;
    private String strOldRightName;
    private CommandLineOption coTaskFile;
    private CommandLineOption coName;
    private CommandLineOption coPolicy;
    private CommandLineOption coType;
    private CommandLineOption coCommandPath;
    private CommandLineOption coHelp;
    private CommandLineOption coUID;
    private CommandLineOption coEUID;
    private CommandLineOption coEGID;
    private CommandLineOption coGID;
    ResourceBundle bundle;
    private boolean tsolPolicy;
    private CommandLineOption coClearance;
    private CommandLineOption coLabel;
    private CommandLineOption coAddPrivs;
    private CommandLineOption coDelPrivs;
    private TrustedSolarisServiceInterface labelService;
    private String userName;
    private UserSecurityInfo userSecurityInfo;
    private static final String TSOL_POLICY = "tsol";
    private static final String SUSER_POLICY = "suser";
    private static final String CMD_TYPE = "cmd";
    private static final String ACT_TYPE = "act";
    private static final String TSOL_LABEL = "label";
    private static final String TSOL_CLEARANCE = "clearance";
    private static final String TSOL_PRIVS = "privs";
    private static final String TSOL_ALL_PRIVS = "all";

    public UserMgrExecCli() {
        try {
            this.bundle = ResourceManager.getBundle((String)"com.sun.admin.usermgr.cli.execs.resources.Resources", this.getClass());
            this.setResourceBundle(this.bundle);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.bundle = null;
        }
        if (this.bundle == null) {
            this.bundle = ResourceBundle.getBundle("com.sun.admin.usermgr.cli.execs.resources.Resources", Locale.getDefault(), this.getClass().getClassLoader());
            this.setResourceBundle(this.bundle);
        }
        if (this.bundle == null) {
            this.giveNoBundleMessage();
            System.exit(2);
        }
    }

    public void addObject() throws Exception {
        try {
            RightObj rightObj = (RightObj)this.vObjs.elementAt(0);
            if (this.getUserMgr() == null) {
                this.trace("in addObject:  usermgr is null!");
                throw new UserException("EXM_CLI_NO_SERVICE");
            }
            this.getUserMgr().addRight(rightObj);
        }
        catch (Exception exception) {
            this.trace("exception in addObject(): " + exception.getMessage());
            if (this.getDebugStatus()) {
                exception.printStackTrace();
            }
            throw exception;
        }
    }

    public String checkClearance(String string) throws Exception {
        String string2 = null;
        try {
            if (string.startsWith("0x")) {
                string2 = this.labelService.hexClearanceToString(string, this.userName);
                return string;
            }
            string2 = this.labelService.stringClearanceToHex(string, this.userName);
            return string2;
        }
        catch (BadLabelException badLabelException) {
            int n = badLabelException.getErrorCode();
            throw new UserException("EXM_CLI_TSOL_BAD_CLEARANCE_ERROR", string, Integer.toString(n));
        }
        catch (Exception exception) {
            throw new UserException("EXM_CLI_TSOL_CLEARANCE_UPDATE_ERROR");
        }
    }

    public void checkDominance(String string, String string2) throws Exception {
        boolean bl = true;
        try {
            bl = this.labelService.checkClearanceDominance(string2, string, this.userName);
        }
        catch (Exception exception) {
            throw new UserException("EXM_CLI_DOM_CHK_ERROR");
        }
        if (!bl) {
            throw new UserException("EXM_CLI_RIGHT_TSOL_DOM_CHK_FAILED");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkForAddOptions(String[] stringArray) throws Exception {
        RightObj rightObj = new RightObj();
        ExecAttrObj execAttrObj = new ExecAttrObj();
        String string = null;
        String string2 = null;
        CommandParser commandParser = new CommandParser(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"smexecadd_name"), ResourceStrings.getString((ResourceBundle)this.bundle, (String)"smexecadd_desc"), true, null, null);
        try {
            commandParser.addOption((CommandOption)this.coName);
            commandParser.addOption((CommandOption)this.coType);
            commandParser.addOption((CommandOption)this.coCommandPath);
            commandParser.addOption((CommandOption)this.coUID);
            commandParser.addOption((CommandOption)this.coEUID);
            commandParser.addOption((CommandOption)this.coGID);
            commandParser.addOption((CommandOption)this.coEGID);
            commandParser.addOption((CommandOption)this.coPolicy);
            commandParser.addOption((CommandOption)this.coClearance);
            commandParser.addOption((CommandOption)this.coLabel);
            commandParser.addOption((CommandOption)this.coAddPrivs);
            commandParser.addOption((CommandOption)this.coTaskFile);
            commandParser.addOption((CommandOption)this.coHelp);
            if (commandParser.parseArgs(stringArray)) {
                if (this.coName.wasSet()) {
                    String string3 = (String)this.coName.getValue();
                    this.trace("Rightname :  " + string3);
                    if (!this.checkRightExists(string3)) {
                        throw new UserException("EXM_CLI_RIGHT_NOT_EXIST", string3);
                    }
                    rightObj.setRightName(string3);
                    execAttrObj.setProfName(string3);
                }
                if (this.coPolicy.wasSet()) {
                    String string4 = (String)this.coPolicy.getValue();
                    this.trace("Policy :  " + string4);
                    if (string4.equals(TSOL_POLICY)) {
                        execAttrObj.setPolicy(TSOL_POLICY);
                        this.tsolPolicy = true;
                    } else {
                        if (!string4.equals(SUSER_POLICY)) throw new UserException("EXM_CLI_RIGHT_TSOL_BAD_POLICY", string4);
                        execAttrObj.setPolicy(SUSER_POLICY);
                        this.tsolPolicy = false;
                    }
                } else {
                    execAttrObj.setPolicy(SUSER_POLICY);
                    this.tsolPolicy = false;
                }
                if (this.coType.wasSet()) {
                    String string5 = (String)this.coType.getValue();
                    this.trace("Type : " + string5);
                    execAttrObj.setType(string5);
                    if (this.tsolPolicy) {
                        if (!string5.equals(CMD_TYPE) && !string5.equals(ACT_TYPE)) {
                            throw new UserException("EXM_CLI_RIGHT_TSOL_BAD_TYPE", string5);
                        }
                    } else if (!string5.equals(CMD_TYPE)) {
                        throw new UserException("EXM_CLI_RIGHT_INVALID_TYPE", string5);
                    }
                }
                if (this.coCommandPath.wasSet()) {
                    String string6 = (String)this.coCommandPath.getValue();
                    this.trace("CommandPath : " + string6);
                    execAttrObj.setId(string6);
                }
                if (this.coUID.wasSet()) {
                    String string7 = (String)this.coUID.getValue();
                    this.trace("UID : " + string7);
                    execAttrObj.setUid(string7);
                }
                if (this.coEUID.wasSet()) {
                    String string8 = (String)this.coEUID.getValue();
                    this.trace("EUID : " + string8);
                    execAttrObj.setEuid(string8);
                }
                if (this.coGID.wasSet()) {
                    String string9 = (String)this.coGID.getValue();
                    this.trace("GID : " + string9);
                    execAttrObj.setGid(string9);
                }
                if (this.coEGID.wasSet()) {
                    String string10 = (String)this.coEGID.getValue();
                    this.trace("EGID : " + string10);
                    execAttrObj.setEgid(string10);
                }
                if (this.tsolPolicy) {
                    if (this.coClearance.wasSet()) {
                        string = (String)this.coClearance.getValue();
                        this.trace("Clearance : " + string);
                        string = this.checkClearance(string);
                    }
                    if (this.coLabel.wasSet()) {
                        string2 = (String)this.coLabel.getValue();
                        this.trace("Label : " + string2);
                        string2 = this.checkLabel(string2);
                    }
                    if (string2 != null && string == null) {
                        string = string2;
                    } else if (string != null && string2 == null) {
                        try {
                            this.userSecurityInfo = this.labelService.getUserSecurityInfo(this.userName);
                            if (this.userSecurityInfo == null) {
                                throw new UserException("EXM_CLI_RIGHT_TSOL_MINLABEL_ERR");
                            }
                            string2 = this.userSecurityInfo.getMinLabel();
                            this.checkDominance(string, string2);
                        }
                        catch (Exception exception) {
                            throw new UserException("EXM_CLI_RIGHT_TSOL_MINLABEL_ERR");
                        }
                    } else if (string2 != null && string != null) {
                        this.checkDominance(string, string2);
                    }
                    if (string != null) {
                        execAttrObj.setAttribute(TSOL_CLEARANCE, string);
                    }
                    if (string2 != null) {
                        execAttrObj.setAttribute(TSOL_LABEL, string2);
                    }
                    if (this.coAddPrivs.wasSet()) {
                        Vector vector2 = this.coAddPrivs.getValues();
                        vector2 = this.checkListPrivs(vector2);
                        execAttrObj.setAttribute(TSOL_PRIVS, vector2);
                    }
                } else if (this.coClearance.wasSet() || this.coLabel.wasSet() || this.coAddPrivs.wasSet()) {
                    throw new UserException("EXM_CLI_RIGHT_TSOL_BAD_OPTION");
                }
                if (this.coHelp.wasSet()) {
                    this.trace("read in help");
                    commandParser.printUsage(null);
                    throw new UserMgrCliHelpException(null);
                }
            } else {
                this.trace("Error parsing args");
                throw new Exception("parseArgs failed.");
            }
            String[] stringArray2 = commandParser.getUnmatchedOptions();
            if (stringArray2.length >= 1) {
                int n = 0;
                while (n < stringArray2.length) {
                    this.trace("unrecognized option:  " + stringArray2[n]);
                    ++n;
                }
                commandParser.printUsage(null);
                throw new UserMgrCliArgParsingException("EXM_CLI_INVALID_ARG", stringArray2[0]);
            }
            ArrayList<ExecAttrObj> arrayList = new ArrayList<ExecAttrObj>();
            arrayList.add(execAttrObj);
            rightObj.setExecAttrs(arrayList);
            this.vObjs.addElement(rightObj);
            return;
        }
        catch (UserMgrCliHelpException userMgrCliHelpException) {
            throw userMgrCliHelpException;
        }
        catch (UserMgrCliArgParsingException userMgrCliArgParsingException) {
            throw userMgrCliArgParsingException;
        }
        catch (UserException userException) {
            throw userException;
        }
        catch (Throwable throwable) {
            this.trace("Throwable type-of-exception");
            if (!this.getDebugStatus()) throw new UserMgrCliArgParsingException("EXM_CLI_GENERIC_ERROR");
            throwable.printStackTrace();
            throw new UserMgrCliArgParsingException("EXM_CLI_GENERIC_ERROR");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkForDeleteOptions(String[] stringArray) throws Exception {
        ExecAttrObj execAttrObj = new ExecAttrObj();
        RightObj rightObj = new RightObj();
        CommandParser commandParser = new CommandParser(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"smexecdel_name"), ResourceStrings.getString((ResourceBundle)this.bundle, (String)"smexecdel_desc"), true, null, null);
        try {
            String[] stringArray2;
            commandParser.addOption((CommandOption)this.coName);
            commandParser.addOption((CommandOption)this.coType);
            commandParser.addOption((CommandOption)this.coCommandPath);
            commandParser.addOption((CommandOption)this.coPolicy);
            commandParser.addOption((CommandOption)this.coTaskFile);
            commandParser.addOption((CommandOption)this.coHelp);
            if (commandParser.parseArgs(stringArray)) {
                if (this.coName.wasSet()) {
                    stringArray2 = (String[])this.coName.getValue();
                    this.trace("Rightname :  " + (String)stringArray2);
                    if (!this.checkRightExists((String)stringArray2)) {
                        throw new UserException("EXM_CLI_RIGHT_NOT_EXIST", (String)stringArray2);
                    }
                    rightObj.setRightName((String)stringArray2);
                    execAttrObj.setProfName((String)stringArray2);
                }
                if (this.coType.wasSet()) {
                    stringArray2 = (String)this.coType.getValue();
                    this.trace("Type : " + (String)stringArray2);
                    execAttrObj.setType((String)stringArray2);
                }
                if (this.coCommandPath.wasSet()) {
                    stringArray2 = (String)this.coCommandPath.getValue();
                    this.trace("strCommandPath :  " + (String)stringArray2);
                    execAttrObj.setId((String)stringArray2);
                }
                if (this.coPolicy.wasSet()) {
                    stringArray2 = (String)this.coPolicy.getValue();
                    this.trace("Policy :  " + (String)stringArray2);
                    if (stringArray2.equals(TSOL_POLICY)) {
                        execAttrObj.setPolicy(TSOL_POLICY);
                    } else {
                        if (!stringArray2.equals(SUSER_POLICY)) throw new UserException("EXM_CLI_RIGHT_TSOL_BAD_POLICY", (String)stringArray2);
                        execAttrObj.setPolicy(SUSER_POLICY);
                    }
                } else {
                    execAttrObj.setPolicy(SUSER_POLICY);
                }
                if (this.coHelp.wasSet()) {
                    this.trace("read in help");
                    commandParser.printUsage(null);
                    throw new UserMgrCliHelpException(null);
                }
            } else {
                this.trace("Error parsing args");
                throw new Exception("parseArgs failed.");
            }
            stringArray2 = commandParser.getUnmatchedOptions();
            if (stringArray2.length >= 1) {
                int n = 0;
                while (n < stringArray2.length) {
                    this.trace("unrecognized option:  " + stringArray2[n]);
                    ++n;
                }
                commandParser.printUsage(null);
                throw new UserMgrCliArgParsingException("EXM_CLI_INVALID_ARG", stringArray2[0]);
            }
            ArrayList<ExecAttrObj> arrayList = new ArrayList<ExecAttrObj>();
            arrayList.add(execAttrObj);
            rightObj.setExecAttrs(arrayList);
            this.vObjs.addElement(rightObj);
            return;
        }
        catch (UserMgrCliHelpException userMgrCliHelpException) {
            throw userMgrCliHelpException;
        }
        catch (UserMgrCliArgParsingException userMgrCliArgParsingException) {
            throw userMgrCliArgParsingException;
        }
        catch (UserException userException) {
            throw userException;
        }
        catch (Throwable throwable) {
            this.trace("Throwable type-of-exception");
            if (!this.getDebugStatus()) throw new UserMgrCliArgParsingException("EXM_CLI_GENERIC_ERROR");
            throwable.printStackTrace();
            throw new UserMgrCliArgParsingException("EXM_CLI_GENERIC_ERROR");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkForModifyOptions(String[] stringArray) throws Exception {
        Object object;
        RightObj rightObj = new RightObj();
        ExecAttrObj execAttrObj = new ExecAttrObj();
        String string = null;
        String string2 = null;
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        CommandParser commandParser = new CommandParser(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"smexecmod_name"), ResourceStrings.getString((ResourceBundle)this.bundle, (String)"smexecmod_desc"), true, null, null);
        try {
            commandParser.addOption((CommandOption)this.coName);
            commandParser.addOption((CommandOption)this.coType);
            commandParser.addOption((CommandOption)this.coCommandPath);
            commandParser.addOption((CommandOption)this.coUID);
            commandParser.addOption((CommandOption)this.coEUID);
            commandParser.addOption((CommandOption)this.coGID);
            commandParser.addOption((CommandOption)this.coEGID);
            commandParser.addOption((CommandOption)this.coPolicy);
            commandParser.addOption((CommandOption)this.coClearance);
            commandParser.addOption((CommandOption)this.coLabel);
            commandParser.addOption((CommandOption)this.coAddPrivs);
            commandParser.addOption((CommandOption)this.coDelPrivs);
            commandParser.addOption((CommandOption)this.coTaskFile);
            commandParser.addOption((CommandOption)this.coHelp);
            if (commandParser.parseArgs(stringArray)) {
                if (this.coName.wasSet()) {
                    string3 = (String)this.coName.getValue();
                    this.trace("Rightname :  " + string3);
                    if (!this.checkRightExists(string3)) {
                        throw new UserException("EXM_CLI_RIGHT_NOT_EXIST", string3);
                    }
                    rightObj.setRightName(string3);
                    execAttrObj.setProfName(string3);
                }
                if (this.coPolicy.wasSet()) {
                    object = (String[])this.coPolicy.getValue();
                    this.trace("Policy :  " + (String)object);
                    if (((String)object).equals(TSOL_POLICY)) {
                        this.tsolPolicy = true;
                    } else {
                        if (!((String)object).equals(SUSER_POLICY)) throw new UserException("EXM_CLI_RIGHT_TSOL_BAD_POLICY", (String)object);
                        this.tsolPolicy = false;
                    }
                } else {
                    this.tsolPolicy = false;
                }
                if (this.coType.wasSet()) {
                    string4 = (String)this.coType.getValue();
                    this.trace("Type : " + string4);
                    if (this.tsolPolicy) {
                        if (!string4.equals(CMD_TYPE) && !string4.equals(ACT_TYPE)) {
                            throw new UserException("EXM_CLI_RIGHT_TSOL_BAD_TYPE", string4);
                        }
                    } else if (!string4.equals(CMD_TYPE)) {
                        throw new UserException("EXM_CLI_RIGHT_INVALID_TYPE", string4);
                    }
                }
                if (this.coCommandPath.wasSet()) {
                    string5 = (String)this.coCommandPath.getValue();
                    this.trace("CommandPath : " + string5);
                    execAttrObj.setId(string5);
                }
                if (this.coUID.wasSet()) {
                    string6 = (String)this.coUID.getValue();
                    this.trace("UID : " + string6);
                    execAttrObj.setUid(string6);
                }
                if (this.coEUID.wasSet()) {
                    string7 = (String)this.coEUID.getValue();
                    this.trace("EUID : " + string7);
                    execAttrObj.setEuid(string7);
                }
                if (this.coGID.wasSet()) {
                    string8 = (String)this.coGID.getValue();
                    this.trace("GID : " + string8);
                    execAttrObj.setGid(string8);
                }
                if (this.coEGID.wasSet()) {
                    string9 = (String)this.coEGID.getValue();
                    this.trace("EGID : " + string9);
                    execAttrObj.setEgid(string9);
                }
                if (this.tsolPolicy) {
                    if (this.coClearance.wasSet()) {
                        string = (String)this.coClearance.getValue();
                        this.trace("Clearance : " + string);
                        string = this.checkClearance(string);
                    }
                    if (this.coLabel.wasSet()) {
                        string2 = (String)this.coLabel.getValue();
                        this.trace("Label : " + string2);
                        string2 = this.checkLabel(string2);
                    }
                    if (this.coAddPrivs.wasSet()) {
                        vector = this.coAddPrivs.getValues();
                        vector = this.checkListPrivs(vector);
                    }
                    if (this.coDelPrivs.wasSet()) {
                        vector2 = this.coDelPrivs.getValues();
                        vector2 = this.checkListPrivs(vector2);
                    }
                } else if (this.coClearance.wasSet() || this.coLabel.wasSet() || this.coAddPrivs.wasSet() || this.coDelPrivs.wasSet()) {
                    throw new UserException("EXM_CLI_RIGHT_TSOL_BAD_OPTION");
                }
                if (this.coHelp.wasSet()) {
                    this.trace("read in help");
                    commandParser.printUsage(null);
                    throw new UserMgrCliHelpException(null);
                }
            } else {
                this.trace("Error parsing args");
                throw new Exception("parseArgs failed.");
            }
            object = commandParser.getUnmatchedOptions();
            if (((String[])object).length >= 1) {
                int n = 0;
                while (n < ((String[])object).length) {
                    this.trace("unrecognized option:  " + object[n]);
                    ++n;
                }
                commandParser.printUsage(null);
                throw new UserMgrCliArgParsingException("EXM_CLI_INVALID_ARG", object[0]);
            }
        }
        catch (UserMgrCliHelpException userMgrCliHelpException) {
            throw userMgrCliHelpException;
        }
        catch (UserMgrCliArgParsingException userMgrCliArgParsingException) {
            throw userMgrCliArgParsingException;
        }
        catch (UserException userException) {
            throw userException;
        }
        catch (Throwable throwable) {
            this.trace("Throwable type-of-exception");
            if (!this.getDebugStatus()) throw new UserMgrCliArgParsingException("EXM_CLI_GENERIC_ERROR");
            throwable.printStackTrace();
            throw new UserMgrCliArgParsingException("EXM_CLI_GENERIC_ERROR");
        }
        execAttrObj = this.tsolPolicy ? this.getExecObject(string3, string4, string5, TSOL_POLICY) : this.getExecObject(string3, string4, string5, SUSER_POLICY);
        if (string6 != null) {
            execAttrObj.setUid(string6);
        }
        if (string7 != null) {
            execAttrObj.setEuid(string7);
        }
        if (string8 != null) {
            execAttrObj.setGid(string8);
        }
        if (string9 != null) {
            execAttrObj.setEgid(string9);
        }
        if (this.tsolPolicy) {
            if (string2 != null && string == null) {
                object = execAttrObj.getAttribute(TSOL_CLEARANCE);
                if (object != null) {
                    string = (String)((Vector)object).elementAt(0);
                    this.checkDominance(string, string2);
                } else {
                    string = string2;
                }
            } else if (string != null && string2 == null) {
                object = execAttrObj.getAttribute(TSOL_LABEL);
                if (object != null) {
                    string2 = (String)((Vector)object).elementAt(0);
                    this.checkDominance(string, string2);
                } else {
                    try {
                        this.userSecurityInfo = this.labelService.getUserSecurityInfo(this.userName);
                        if (this.userSecurityInfo == null) {
                            throw new UserException("EXM_CLI_RIGHT_TSOL_MINLABEL_ERR");
                        }
                        string2 = this.userSecurityInfo.getMinLabel();
                        this.checkDominance(string, string2);
                    }
                    catch (Exception exception) {
                        throw new UserException("EXM_CLI_RIGHT_TSOL_MINLABEL_ERR");
                    }
                }
            } else if (string != null && string2 != null) {
                this.checkDominance(string, string2);
            }
            if (string != null) {
                execAttrObj.setAttribute(TSOL_CLEARANCE, string);
            }
            if (string2 != null) {
                execAttrObj.setAttribute(TSOL_LABEL, string2);
            }
            if (vector.size() > 0) {
                execAttrObj.addAttribute(TSOL_PRIVS, vector);
            }
            if (vector2.size() > 0) {
                execAttrObj.delAttribute(TSOL_PRIVS, vector2);
            }
        }
        object = new ArrayList();
        ((ArrayList)object).add(execAttrObj);
        rightObj.setExecAttrs((ArrayList)object);
        this.vObjs.addElement(rightObj);
    }

    public String checkLabel(String string) throws Exception {
        String string2 = null;
        try {
            if (string.startsWith("0x")) {
                string2 = this.labelService.hexLabelToString(string, this.userName);
                return string;
            }
            string2 = this.labelService.stringLabelToHex(string, this.userName);
            return string2;
        }
        catch (BadLabelException badLabelException) {
            int n = badLabelException.getErrorCode();
            throw new UserException("EXM_CLI_TSOL_BAD_LABEL_ERROR", string, Integer.toString(n));
        }
        catch (Exception exception) {
            throw new UserException("EXM_CLI_TSOL_LABEL_UPDATE_ERROR");
        }
    }

    public Vector checkListPrivs(Vector vector) throws Exception {
        boolean bl = false;
        Vector<String> vector2 = new Vector<String>();
        String string = null;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            boolean bl2 = false;
            String string2 = (String)enumeration.nextElement();
            if (string2.equals(TSOL_ALL_PRIVS)) {
                bl = true;
                vector2.addElement(TSOL_ALL_PRIVS);
                continue;
            }
            try {
                if (Character.isLetter(string2.charAt(0))) {
                    string = this.labelService.privStringToPrivNum(string2);
                    vector2.addElement(string);
                    continue;
                }
                if (Character.isDigit(string2.charAt(0))) {
                    string = this.labelService.privNumToPrivString(string2);
                    vector2.addElement(string2);
                    continue;
                }
                throw new UserException("EXM_CLI_RIGHT_TSOL_BAD_PRIV", string2);
            }
            catch (Exception exception) {
                throw new UserException("EXM_CLI_RIGHT_TSOL_XLATE_PRIV_ERR", string2);
            }
        }
        if (bl) {
            vector2 = new Vector();
            vector2.addElement(TSOL_ALL_PRIVS);
        }
        return vector2;
    }

    public boolean checkRightExists(String string) {
        Vector vector = this.getListRights();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            RightObj rightObj = (RightObj)enumeration.nextElement();
            String string2 = rightObj.getRightName();
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public void deleteObject() throws Exception {
        this.trace("in UserMgrExecCli->deleteObject()");
        try {
            this.trace("vObjs.size() = " + this.vObjs.size());
            RightObj rightObj = (RightObj)this.vObjs.elementAt(0);
            ArrayList arrayList = rightObj.getExecAttrs();
            ExecAttrObj execAttrObj = (ExecAttrObj)arrayList.get(0);
            if (this.getUserMgr() == null) {
                this.trace("usermgr is null!");
                throw new UserException("EXM_CLI_NO_SERVICE");
            }
            this.getUserMgr().deleteExecAttrEntry(rightObj.getRightName(), execAttrObj.getType(), execAttrObj.getId(), execAttrObj.getPolicy());
        }
        catch (Exception exception) {
            this.trace("exception in deleteObject(): " + exception.getMessage());
            if (this.getDebugStatus()) {
                exception.printStackTrace();
            }
            throw exception;
        }
    }

    private void doFirstArgPass(String[] stringArray) throws Exception {
        block6: {
            RightObj rightObj = new RightObj();
            CommandParser commandParser = new CommandParser("UserMgrExecCli", "main tool for users related cli's", true, null, null);
            try {
                commandParser.addOption((CommandOption)this.coTaskFile);
                commandParser.addOption((CommandOption)this.coHelp);
                if (commandParser.parseArgs(stringArray)) {
                    if (this.coTaskFile.wasSet()) {
                        String string = (String)this.coTaskFile.getValue();
                        this.trace("Task = " + string);
                        this.setTaskOperation(string.charAt(0));
                    }
                } else {
                    this.trace("Error parsing args");
                    throw new UserMgrCliArgParsingException("EXM_CLI_MISSING_ARG");
                }
                this.coHelp.wasSet();
                if (this.getOperation() == -1) {
                    this.trace("Error:  iOperation == -1");
                    throw new UserException("EXM_CLI_NO_TASK");
                }
            }
            catch (Throwable throwable) {
                this.trace("Throwable type-of-exception");
                if (!this.getDebugStatus()) break block6;
                throwable.printStackTrace();
            }
        }
    }

    private ExecAttrObj getExecObject(String string, String string2, String string3, String string4) throws Exception {
        ExecAttrObj execAttrObj = new ExecAttrObj(string);
        try {
            if (this.getUserMgr() == null) {
                this.trace("in getObjectProps:  usermgr svc wrapper` is null!");
                throw new UserException("EXM_CLI_NO_SERVICE");
            }
            execAttrObj = this.getUserMgr().readExecAttr(string, string2, string3, string4);
        }
        catch (Exception exception) {
            if (this.getDebugStatus()) {
                exception.printStackTrace();
            }
            throw exception;
        }
        return execAttrObj;
    }

    public Vector getListRights() {
        Vector vector = null;
        try {
            vector = this.getUserMgr().getRightProfs();
        }
        catch (Exception exception) {}
        return vector;
    }

    private RightObj getObjectProps(String string) throws Exception {
        RightObj rightObj = new RightObj(string);
        try {
            if (this.getUserMgr() == null) {
                this.trace("in getObjectProps:  usermgr svc wrapper` is null!");
                throw new UserException("EXM_CLI_NO_SERVICE");
            }
            rightObj = this.getUserMgr().readRight(string);
        }
        catch (Exception exception) {
            if (this.getDebugStatus()) {
                exception.printStackTrace();
            }
            throw exception;
        }
        return rightObj;
    }

    private void initCommandLineOptions() {
        this.coTaskFile = new CommandLineOption("task", ResourceStrings.getString((ResourceBundle)this.bundle, (String)"arg_task_desc"), "K", 1, false, false, (Object)"V", true, true);
        this.coName = new CommandLineOption("name", ResourceStrings.getString((ResourceBundle)this.bundle, (String)"arg_profilename_desc"), "n", 1, false, false, null, true);
        this.coType = new CommandLineOption("type", ResourceStrings.getString((ResourceBundle)this.bundle, (String)"arg_type_desc"), "t", 1, false, false, (Object)"", true);
        this.coCommandPath = new CommandLineOption("command_path", ResourceStrings.getString((ResourceBundle)this.bundle, (String)"arg_id_desc"), "c", 1, false, false, (Object)"", true);
        this.coUID = new CommandLineOption("uid", ResourceStrings.getString((ResourceBundle)this.bundle, (String)"arg_uid_desc"), "U", 1, true, false, (Object)"", true);
        this.coEUID = new CommandLineOption("euid", ResourceStrings.getString((ResourceBundle)this.bundle, (String)"arg_euid_desc"), "u", 1, true, false, (Object)"", true);
        this.coGID = new CommandLineOption("gid", ResourceStrings.getString((ResourceBundle)this.bundle, (String)"arg_gid_desc"), "G", 1, true, false, (Object)"", true);
        this.coEGID = new CommandLineOption("egid", ResourceStrings.getString((ResourceBundle)this.bundle, (String)"arg_egid_desc"), "g", 1, true, false, (Object)"", true);
        this.coPolicy = new CommandLineOption("policy", ResourceStrings.getString((ResourceBundle)this.bundle, (String)"arg_policy_desc"), "p", 1, true, false, (Object)"", true);
        this.coClearance = new CommandLineOption(TSOL_CLEARANCE, ResourceStrings.getString((ResourceBundle)this.bundle, (String)"arg_clearance_desc"), "C", 1, true, false, (Object)"", true);
        this.coLabel = new CommandLineOption(TSOL_LABEL, ResourceStrings.getString((ResourceBundle)this.bundle, (String)"arg_label_desc"), "L", 1, true, false, (Object)"", true);
        this.coAddPrivs = new CommandLineOption("addprivs", ResourceStrings.getString((ResourceBundle)this.bundle, (String)"arg_addprivs_desc"), "P", 1, true, true, (Object)"", true);
        this.coDelPrivs = new CommandLineOption("delprivs", ResourceStrings.getString((ResourceBundle)this.bundle, (String)"arg_delprivs_desc"), "R", 1, true, true, (Object)"", true);
        this.coHelp = new CommandLineOption("help", ResourceStrings.getString((ResourceBundle)this.bundle, (String)"arg_help_desc"), "h", 0, true, false, (Object)"", false);
        this.coHelp.setPriority(true);
    }

    public void modifyObject() throws Exception {
        try {
            RightObj rightObj = (RightObj)this.vObjs.elementAt(0);
            this.trace("profile is:  " + rightObj.getRightName());
            if (this.getUserMgr() == null) {
                this.trace("in modifyObject:  usermgr is null!");
                throw new UserException("EXM_CLI_NO_SERVICE");
            }
            ArrayList arrayList = rightObj.getExecAttrs();
            ExecAttrObj execAttrObj = (ExecAttrObj)arrayList.get(0);
            this.getUserMgr().modifyExecAttr(execAttrObj);
        }
        catch (Exception exception) {
            this.trace("exception in modifyObject(): " + exception.getMessage());
            if (this.getDebugStatus()) {
                exception.printStackTrace();
            }
            throw exception;
        }
    }

    private void parseAndValidateArgs(String[] stringArray) throws Exception {
        switch (this.getOperation()) {
            case 0: {
                this.checkForAddOptions(stringArray);
                break;
            }
            case 1: {
                this.checkForDeleteOptions(stringArray);
                break;
            }
            case 2: {
                this.checkForModifyOptions(stringArray);
                break;
            }
            default: {
                this.trace("should never be here:  xxxx");
                this.trace("couldn't recognize switch:  " + this.getOperation());
                break;
            }
        }
    }

    public int runCommandLine(String[] stringArray, InputStream inputStream, PrintStream printStream, PrintStream printStream2) {
        String[] stringArray2 = new String[]{};
        int n = 0;
        this.userName = this.getAuthenticatedUser();
        ToolInfrastructure toolInfrastructure = this.getToolInfrastructure();
        try {
            this.labelService = (TrustedSolarisServiceInterface)toolInfrastructure.getServiceByName("com.sun.admin.tsol.server.TrustedSolarisService");
        }
        catch (Exception exception) {
            this.trace("got exception in getting TrustedSolarisService");
            String string = exception.getLocalizedMessage();
            this.handleErrors(string);
            return 2;
        }
        try {
            this.trace("calling initCommandLineOptions");
            this.initCommandLineOptions();
            this.trace("calling doFirstArgPass");
            this.doFirstArgPass(stringArray);
            this.initCommandLineOptions();
            this.trace("calling parseAndValidateArgs");
            this.parseAndValidateArgs(stringArray);
        }
        catch (UserMgrCliHelpException userMgrCliHelpException) {
            return 0;
        }
        catch (UserMgrCliArgParsingException userMgrCliArgParsingException) {
            String string = userMgrCliArgParsingException.getLocalizedMessage();
            this.handleErrors(string);
            return 1;
        }
        catch (UserException userException) {
            this.trace("got UserException in runCommandLine");
            String string = userException.getLocalizedMessage();
            this.handleErrors(string);
            return 2;
        }
        catch (Exception exception) {
            String string = exception.getLocalizedMessage();
            this.handleErrors(string);
            if (this.getDebugStatus()) {
                exception.printStackTrace();
            }
            return 2;
        }
        try {
            this.doOperation();
        }
        catch (UserException userException) {
            this.trace("runCommandLine, UserException:  " + userException.getLocalizedMessage());
            this.handleErrors(userException.getLocalizedMessage());
            n = 2;
        }
        catch (AdminException adminException) {
            this.trace("runCommandLine, AdminException:  " + adminException.getLocalizedMessage());
            this.handleErrors(adminException.getLocalizedMessage());
            n = 2;
        }
        catch (Exception exception) {
            this.trace("runCommandLine, Exception:  " + exception.getLocalizedMessage());
            this.handleErrors(exception.getLocalizedMessage());
            if (this.getDebugStatus()) {
                exception.printStackTrace();
            }
            n = 2;
        }
        return n;
    }
}

