/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.hostmgr.cli.host;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.CommandLineOption;
import com.sun.admin.cis.common.ListProperties;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.hostmgr.cli.HostMgrCliTool;
import com.sun.admin.hostmgr.common.HostData;
import com.sun.admin.hostmgr.common.HostException;
import com.sun.admin.hostmgr.common.HostMgrCliArgParsingException;
import com.sun.admin.hostmgr.common.HostMgrCliHelpException;
import com.sun.admin.hostmgr.common.TemplateData;
import com.sun.admin.hostmgr.common.TnrhdbData;
import com.sun.management.viper.util.CommandOption;
import com.sun.management.viper.util.CommandParser;
import com.sun.management.viper.util.ResourceManager;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;

public class HostMgrCli
extends HostMgrCliTool {
    private ResourceBundle resourceBundle = null;
    private CommandLineOption coHostname;
    private CommandLineOption coIpaddr;
    private CommandLineOption coIpwild;
    private CommandLineOption coTemplate;
    private CommandLineOption coPrefixLen;
    private CommandLineOption coAlias;
    private CommandLineOption coDescription;
    private CommandLineOption coEther;
    private CommandLineOption coTask;
    private CommandLineOption coHelp;
    private Vector vHostObjs = new Vector();
    private Vector vTnrhdbObjs = new Vector();
    private static final int VIEW_HOST = 1;
    private static final int VIEW_ETHER = 2;
    private static final int VIEW_TNRHDB = 3;
    private static final String SEP = " ";
    private int viewOption = 0;

    public HostMgrCli() {
        try {
            this.resourceBundle = ResourceManager.getBundle((String)"com.sun.admin.hostmgr.cli.host.resources.Resources", this.getClass());
        }
        catch (Exception exception) {
            this.resourceBundle = null;
            this.trace("Debugging enabled");
        }
        if (this.resourceBundle == null) {
            this.resourceBundle = ResourceBundle.getBundle("com.sun.admin.hostmgr.cli.host.resources.Resources", Locale.getDefault(), this.getClass().getClassLoader());
        }
        if (this.resourceBundle == null) {
            this.trace("HostMgrCli Constructor....Null resourceBundle!!!");
        }
    }

    private void addHost() throws Exception {
        this.trace("doing addHost() operation");
        this.trace("Here are the host objs:");
        int n = 0;
        while (n < this.vHostObjs.size()) {
            HostData hostData = (HostData)this.vHostObjs.elementAt(n);
            if (this.getDebugStatus()) {
                hostData.print();
            }
            this.getHostMgr().addHost(hostData);
            ++n;
        }
        this.trace("here are the tnrhdb objs:");
        int n2 = 0;
        while (n2 < this.vTnrhdbObjs.size()) {
            TnrhdbData tnrhdbData = (TnrhdbData)this.vTnrhdbObjs.elementAt(n2);
            this.trace("ip address = " + tnrhdbData.getIpAddress());
            this.trace("prefix length = " + tnrhdbData.getPrefixLen());
            this.trace("template type = " + tnrhdbData.getTemplateType());
            this.getHostMgr().setTnrhdb(tnrhdbData);
            ++n2;
        }
    }

    private void checkForAddOptions(String[] stringArray) throws Exception {
        CommandParser commandParser;
        boolean bl;
        block13: {
            this.trace("enterred checkForAddOptions");
            bl = false;
            commandParser = new CommandParser(this.getLocalizedMessage("smhostadd_name"), this.getLocalizedMessage("smhostadd_desc"), true, null, null);
            commandParser.addOption((CommandOption)this.coHelp);
            commandParser.addOption((CommandOption)this.coHostname);
            commandParser.addOption((CommandOption)this.coIpaddr);
            commandParser.addOption((CommandOption)this.coTemplate);
            commandParser.addOption((CommandOption)this.coAlias);
            commandParser.addOption((CommandOption)this.coDescription);
            commandParser.addOption((CommandOption)this.coEther);
            commandParser.addOption((CommandOption)this.coIpwild);
            commandParser.addOption((CommandOption)this.coPrefixLen);
            CommandParser commandParser2 = new CommandParser(this.getLocalizedMessage("smhostadd_name"), this.getLocalizedMessage("smhostadd_desc"), true, null, null);
            commandParser2.addOption((CommandOption)this.coHelp);
            commandParser2.addOption((CommandOption)this.coHostname);
            commandParser2.addOption((CommandOption)this.coIpaddr);
            commandParser2.addOption((CommandOption)this.coTemplate);
            commandParser2.addOption((CommandOption)this.coIpwild);
            commandParser2.addOption((CommandOption)this.coTask);
            try {
                if (commandParser2.parseArgs(stringArray)) {
                    if (this.coHelp.wasSet()) {
                        commandParser.printUsage(null);
                        throw new HostMgrCliHelpException(null);
                    }
                    if (this.coHostname.wasSet() && this.coIpaddr.wasSet()) {
                        this.parseAddHostDataOptions(stringArray);
                        bl = true;
                    } else if (this.coHostname.wasSet() && this.coTemplate.wasSet()) {
                        this.parseAddTnrhdbDataHostname(stringArray);
                        bl = true;
                    } else if (this.coIpaddr.wasSet() && this.coTemplate.wasSet()) {
                        this.parseAddTnrhdbDataIpaddr(stringArray);
                        bl = true;
                    } else if (this.coIpwild.wasSet() && this.coTemplate.wasSet()) {
                        this.parseAddTnrhdbDataWildIp(stringArray);
                        bl = true;
                    }
                    break block13;
                }
                this.trace("Error parsing args");
                throw new Exception("parseArgs failed");
            }
            catch (HostMgrCliArgParsingException hostMgrCliArgParsingException) {
                commandParser.printUsage(null);
                throw new HostMgrCliArgParsingException("EXM_CLI_INVALID_ARG", hostMgrCliArgParsingException.getMessage());
            }
            catch (Exception exception) {
                throw exception;
            }
        }
        if (!bl) {
            commandParser.printUsage(null);
            throw new HostMgrCliArgParsingException("EXM_CLI_GENERIC_ERROR");
        }
    }

    private void checkForDeleteOptions(String[] stringArray) throws Exception {
        CommandParser commandParser;
        boolean bl;
        block19: {
            this.trace("enterred checkForDeleteOptions");
            bl = false;
            commandParser = new CommandParser(this.getLocalizedMessage("smhostdel_name"), this.getLocalizedMessage("smhostdel_desc"), false, null, null);
            commandParser.addOption((CommandOption)this.coHelp);
            commandParser.addOption((CommandOption)this.coHostname);
            commandParser.addOption((CommandOption)this.coIpaddr);
            commandParser.addOption((CommandOption)this.coIpwild);
            commandParser.addOption((CommandOption)this.coPrefixLen);
            commandParser.addOption((CommandOption)this.coTask);
            try {
                if (commandParser.parseArgs(stringArray)) {
                    if (this.coHelp.wasSet()) {
                        commandParser.printUsage(null);
                        throw new HostMgrCliHelpException(null);
                    }
                    if (this.coHostname.wasSet()) {
                        String string = (String)this.coHostname.getValue();
                        this.trace("Trying to delete hostname = " + string);
                        Vector vector = this.getHostMgr().getHostsByName(string);
                        if (vector == null) {
                            this.trace("Unable to find host to be modified: " + string);
                            throw new HostException("EXM_HOST_CLI_HOST_NOT_FOUND", string);
                        }
                        if (vector.size() > 1) {
                            this.trace("More than one host has the name " + string);
                            throw new HostException("EXM_HOST_CLI_HOST_MORE_THAN_ONE", string);
                        }
                        if (vector.size() == 0) {
                            this.trace("Unable to find host to be modified: " + string);
                            throw new HostException("EXM_HOST_CLI_HOST_NOT_FOUND", string);
                        }
                        HostData hostData = (HostData)vector.elementAt(0);
                        if (hostData == null) {
                            this.trace("Unable to find host to be modified: " + string);
                            throw new HostException("EXM_HOST_CLI_HOST_NOT_FOUND", string);
                        }
                        this.vHostObjs.addElement(hostData);
                        bl = true;
                    } else if (this.coIpaddr.wasSet()) {
                        String string = (String)this.coIpaddr.getValue();
                        Vector vector = this.getHostMgr().listTnrhdbByIPAddress(string, null);
                        if (vector == null || vector.size() == 0) {
                            this.trace("Unable to find entry in tnrhdb for ip address: " + string);
                            throw new HostException("EXM_HOST_CLI_NOIP_IN_TNRHDB", string);
                        }
                        if (vector.size() > 1) {
                            this.trace("More than one entry in tnrhdb for ip address: " + string);
                            throw new HostException("EXM_HOST_CLI_IP_IN_TNRHDB_MORE_THAN_ONE", string);
                        }
                        TnrhdbData tnrhdbData = (TnrhdbData)vector.elementAt(0);
                        this.vTnrhdbObjs.addElement(tnrhdbData);
                        bl = true;
                    } else if (this.coIpwild.wasSet()) {
                        Vector vector;
                        bl = true;
                        String string = (String)this.coIpwild.getValue();
                        String string2 = null;
                        if (this.coPrefixLen.wasSet()) {
                            string2 = (String)this.coPrefixLen.getValue();
                        }
                        if ((vector = this.getHostMgr().listTnrhdbByIPAddress(string, string2)) == null || vector.size() == 0) {
                            this.trace("More than one entry in tnrhdb for ip address: " + string);
                            throw new HostException("EXM_HOST_CLI_NOIP_IN_TNRHDB", string);
                        }
                        if (vector.size() > 1) {
                            this.trace("Unable to find entry in tnrhdb for ip address: " + string);
                            throw new HostException("EXM_HOST_CLI_IP_IN_TNRHDB_MORE_THAN_ONE", string);
                        }
                        TnrhdbData tnrhdbData = (TnrhdbData)vector.elementAt(0);
                        this.vTnrhdbObjs.addElement(tnrhdbData);
                        bl = true;
                    }
                    break block19;
                }
                this.trace("In ELSE.....Error parsing args");
                throw new HostMgrCliArgParsingException("EXM_CLI_GENERIC_ERROR");
            }
            catch (Exception exception) {
                this.trace("Caught Exception in checkForDeleteOption");
                throw exception;
            }
        }
        if (!bl) {
            commandParser.printUsage(null);
            throw new HostMgrCliArgParsingException("EXM_CLI_GENERIC_ERROR");
        }
    }

    private void checkForModifyOptions(String[] stringArray) throws Exception {
        CommandParser commandParser;
        boolean bl;
        block11: {
            this.trace("enterred checkForModifyOptions");
            bl = false;
            commandParser = new CommandParser(this.getLocalizedMessage("smhostmod_name"), this.getLocalizedMessage("smhostmod_desc"), true, null, null);
            commandParser.addOption((CommandOption)this.coHelp);
            commandParser.addOption((CommandOption)this.coHostname);
            commandParser.addOption((CommandOption)this.coIpaddr);
            commandParser.addOption((CommandOption)this.coTemplate);
            commandParser.addOption((CommandOption)this.coAlias);
            commandParser.addOption((CommandOption)this.coDescription);
            commandParser.addOption((CommandOption)this.coEther);
            commandParser.addOption((CommandOption)this.coIpwild);
            commandParser.addOption((CommandOption)this.coPrefixLen);
            CommandParser commandParser2 = new CommandParser(this.getLocalizedMessage("smhostmod_name"), this.getLocalizedMessage("smhostmod_desc"), true, null, null);
            commandParser2.addOption((CommandOption)this.coHelp);
            commandParser2.addOption((CommandOption)this.coHostname);
            commandParser2.addOption((CommandOption)this.coIpaddr);
            commandParser2.addOption((CommandOption)this.coIpwild);
            commandParser2.addOption((CommandOption)this.coTask);
            try {
                if (commandParser2.parseArgs(stringArray)) {
                    if (this.coHelp.wasSet()) {
                        commandParser.printUsage(null);
                        throw new HostMgrCliHelpException(null);
                    }
                    if (this.coHostname.wasSet()) {
                        this.parseModifyHostDataOptions(stringArray);
                        bl = true;
                    } else if (this.coIpaddr.wasSet()) {
                        this.parseModifyTnrhdbDataIpaddr(stringArray);
                        bl = true;
                    } else if (this.coIpwild.wasSet()) {
                        this.parseModifyTnrhdbDataWildIp(stringArray);
                        bl = true;
                    }
                    break block11;
                }
                this.trace("Error parsing args");
                throw new Exception("parseArgs failed");
            }
            catch (HostMgrCliArgParsingException hostMgrCliArgParsingException) {
                commandParser.printUsage(null);
                throw new HostMgrCliArgParsingException("EXM_CLI_INVALID_ARG", hostMgrCliArgParsingException.getMessage());
            }
            catch (Exception exception) {
                throw exception;
            }
        }
        if (!bl) {
            commandParser.printUsage(null);
            throw new HostMgrCliArgParsingException("EXM_CLI_GENERIC_ERROR");
        }
    }

    private void checkForViewOptions(String[] stringArray) throws Exception {
        block9: {
            this.trace("enterred checkForViewOptions");
            CommandLineOption commandLineOption = new CommandLineOption("ethernet_address", this.getLocalizedMessage("arg_ether_list_desc"), "e", 0, true, false, null, false, false);
            CommandLineOption commandLineOption2 = new CommandLineOption("tnrhdb", this.getLocalizedMessage("arg_tnrhdb_list_desc"), "n", 0, true, false, null, false, false);
            CommandLineOption commandLineOption3 = new CommandLineOption("hostname", this.getLocalizedMessage("arg_host_list_desc"), "H", 0, true, false, null, false, false);
            CommandParser commandParser = new CommandParser(this.getLocalizedMessage("smhostls_name"), this.getLocalizedMessage("smhostls_desc"), false, null, null);
            commandParser.addOption((CommandOption)this.coHelp);
            commandParser.addOption((CommandOption)commandLineOption3);
            commandParser.addOption((CommandOption)commandLineOption2);
            commandParser.addOption((CommandOption)commandLineOption);
            commandParser.addOption((CommandOption)this.coTask);
            try {
                if (commandParser.parseArgs(stringArray)) {
                    if (this.coHelp.wasSet()) {
                        commandParser.printUsage(null);
                        throw new HostMgrCliHelpException(null);
                    }
                    if (commandLineOption3.wasSet()) {
                        this.viewOption = 1;
                    } else if (commandLineOption2.wasSet()) {
                        this.viewOption = 3;
                    } else if (commandLineOption.wasSet()) {
                        this.viewOption = 2;
                    }
                    break block9;
                }
                this.trace("In ELSE.....Error parsing args");
                throw new HostMgrCliArgParsingException("EXM_CLI_GENERIC_ERROR");
            }
            catch (Exception exception) {
                this.trace("Caught Exception in checkForViewOption");
                throw exception;
            }
        }
    }

    private void deleteHost() throws Exception {
        this.trace("doing deleteHost() operation");
        this.trace("Here are the host objs:");
        int n = 0;
        while (n < this.vHostObjs.size()) {
            HostData hostData = (HostData)this.vHostObjs.elementAt(n);
            if (this.getDebugStatus()) {
                hostData.print();
            }
            this.getHostMgr().deleteHost(hostData);
            ++n;
        }
        this.trace("here are the tnrhdb objs:");
        int n2 = 0;
        while (n2 < this.vTnrhdbObjs.size()) {
            TnrhdbData tnrhdbData = (TnrhdbData)this.vTnrhdbObjs.elementAt(n2);
            this.trace("ip address = " + tnrhdbData.getIpAddress());
            this.trace("prefix length = " + tnrhdbData.getPrefixLen());
            this.trace("template type = " + tnrhdbData.getTemplateType());
            this.getHostMgr().deleteTnrhdb(tnrhdbData);
            ++n2;
        }
    }

    private void doFirstArgPass(String[] stringArray) throws Exception {
        if (this.getDebugStatus()) {
            this.trace("doFirstArgPass: args.length = " + stringArray.length);
            int n = 0;
            while (n < stringArray.length) {
                this.trace("args[" + n + "] = " + stringArray[n]);
                ++n;
            }
        }
        CommandParser commandParser = new CommandParser("HostMgrCli", this.getLocalizedMessage("hostcli_desc"), true, null, null);
        try {
            commandParser.addOption((CommandOption)this.coTask);
            commandParser.addOption((CommandOption)this.coHelp);
            if (commandParser.parseArgs(stringArray)) {
                if (this.coTask.wasSet()) {
                    String string = (String)this.coTask.getValue();
                    this.trace("Operation = " + string);
                    this.setOperation(string.charAt(0));
                }
            } else {
                this.trace("Error parsing args");
                throw new HostMgrCliArgParsingException("EXM_CLI_MISSING_ARG");
            }
            this.coHelp.wasSet();
            if (this.getOperation() == -1) {
                this.trace("Error:  iOperation == -1");
                throw new HostException("EXM_CLI_NO_TASK");
            }
        }
        catch (Throwable throwable) {
            this.trace("Throwable type-of-exception");
            throwable.printStackTrace();
        }
    }

    public void doOperation() throws Exception {
        switch (this.getOperation()) {
            case 0: {
                this.addHost();
                break;
            }
            case 1: {
                this.deleteHost();
                break;
            }
            case 2: {
                this.modifyHost();
                break;
            }
            case 3: {
                this.viewHost();
                break;
            }
        }
    }

    private String getHostNameFromIp(String string) throws Exception {
        HostData hostData = this.getHostMgr().getHostByAddress(string);
        if (hostData == null) {
            return null;
        }
        return hostData.getHostName();
    }

    private String getIpFromName(String string) throws Exception {
        Vector vector = this.getHostMgr().getHostsByName(string);
        if (vector == null) {
            return null;
        }
        if (vector.size() == 0) {
            return null;
        }
        HostData hostData = (HostData)vector.elementAt(0);
        return hostData.getNetworkAddress();
    }

    private String getLocalizedMessage(String string) {
        return ResourceStrings.getString((ResourceBundle)this.resourceBundle, (String)string);
    }

    private void initCommandLineOptions() {
        this.coTask = new CommandLineOption("task", this.getLocalizedMessage("arg_taskfile_desc"), "K", 1, false, false, (Object)"", false, true);
        this.coHelp = new CommandLineOption("help", this.getLocalizedMessage("arg_help_desc"), "h", 0, true, false, (Object)"", false);
        this.coHelp.setPriority(true);
        this.coIpaddr = new CommandLineOption("ip_address", this.getLocalizedMessage("arg_ipaddr_desc"), "i", 1, true, false, null, false, false);
        this.coHostname = new CommandLineOption("hostname", this.getLocalizedMessage("arg_hostname_desc"), "H", 1, true, false, null, false, false);
        this.coIpwild = new CommandLineOption("Ip_address_wildcard", this.getLocalizedMessage("arg_ipwild_desc"), "w", 1, true, false, null, false, false);
        this.coTemplate = new CommandLineOption("template", this.getLocalizedMessage("arg_template_desc"), "n", 1, true, false, null, false, false);
        this.coPrefixLen = new CommandLineOption("prefixlen", this.getLocalizedMessage("arg_prefixlen_desc"), "p", 1, true, false, null, false);
        this.coAlias = new CommandLineOption("alias", this.getLocalizedMessage("arg_alias_desc"), "a", 1, true, false, null, false, false);
        this.coDescription = new CommandLineOption("description", this.getLocalizedMessage("arg_description_desc"), "d", 1, true, false, null, false, false);
        this.coEther = new CommandLineOption("ethernet_address", this.getLocalizedMessage("arg_ether_desc"), "e", 1, true, false, null, false, false);
    }

    private void modifyHost() throws Exception {
        Object object;
        this.trace("doing modifyHost() operation");
        this.trace("Here are the host objs to be modified:");
        int n = 0;
        while (n < this.vHostObjs.size()) {
            HostData hostData = (HostData)this.vHostObjs.elementAt(n);
            if (this.getDebugStatus()) {
                hostData.print();
            }
            object = hostData.getHostName();
            Vector vector = this.getHostMgr().getHostsByName((String)object);
            if (vector == null) {
                this.trace("Unable to find host to be modified: " + (String)object);
                throw new HostException("EXM_HOST_CLI_HOST_NOT_FOUND", (String)object);
            }
            if (vector.size() > 1) {
                this.trace("More than one host has the name " + (String)object);
                throw new HostException("EXM_HOST_CLI_HOST_MORE_THAN_ONE", (String)object);
            }
            if (vector.size() == 0) {
                this.trace("Unable to find host to be modified: " + (String)object);
                throw new HostException("EXM_HOST_CLI_HOST_NOT_FOUND", (String)object);
            }
            HostData hostData2 = (HostData)vector.elementAt(0);
            if (hostData2 == null) {
                this.trace("Unable to find host to be modified: " + (String)object);
                throw new HostException("EXM_HOST_CLI_HOST_NOT_FOUND", (String)object);
            }
            this.getHostMgr().setHost(hostData2, hostData);
            ++n;
        }
        this.trace("here are the tnrhdb objs:");
        int n2 = 0;
        while (n2 < this.vTnrhdbObjs.size()) {
            object = (TnrhdbData)this.vTnrhdbObjs.elementAt(n2);
            this.trace("ip address = " + ((TnrhdbData)object).getIpAddress());
            this.trace("prefix length = " + ((TnrhdbData)object).getPrefixLen());
            this.trace("template type = " + ((TnrhdbData)object).getTemplateType());
            this.getHostMgr().setTnrhdb((TnrhdbData)object);
            ++n2;
        }
    }

    private void parseAddHostDataOptions(String[] stringArray) throws Exception {
        HostData hostData;
        String[] stringArray2;
        this.trace("enterred parseHostDataOptions");
        this.initCommandLineOptions();
        CommandParser commandParser = new CommandParser(null, null, true, null, null);
        commandParser.addOption((CommandOption)this.coHelp);
        commandParser.addOption((CommandOption)this.coHostname);
        commandParser.addOption((CommandOption)this.coIpaddr);
        commandParser.addOption((CommandOption)this.coTemplate);
        commandParser.addOption((CommandOption)this.coAlias);
        commandParser.addOption((CommandOption)this.coDescription);
        commandParser.addOption((CommandOption)this.coEther);
        commandParser.addOption((CommandOption)this.coTask);
        if (commandParser.parseArgs(stringArray)) {
            Object object;
            this.trace("adding to host database");
            stringArray2 = (String[])this.coHostname.getValue();
            HostData.validateHostName((String)stringArray2);
            String string = (String)this.coIpaddr.getValue();
            HostData.validateIPAddress(string);
            hostData = new HostData((String)stringArray2);
            hostData.setNetworkAddress(string);
            if (this.coAlias.wasSet()) {
                object = (String)this.coAlias.getValue();
                HostData.validateAliasNames((String)object);
                hostData.setAliases((String)object);
            }
            if (this.coDescription.wasSet()) {
                object = (String)this.coDescription.getValue();
                HostData.validateDescription((String)object);
                hostData.setDescription((String)object);
            }
            if (this.coEther.wasSet()) {
                object = (String)this.coEther.getValue();
                HostData.validateEthernetAddress((String)object);
                hostData.setEthernetAddress((String)object);
            }
            if (this.coTemplate.wasSet()) {
                object = new TnrhdbData();
                TnrhdbData.validateIPAddress(string);
                ((TnrhdbData)object).setIpAddress(string);
                String string2 = (String)this.coTemplate.getValue();
                this.validateTemplateName(string2);
                ((TnrhdbData)object).setTemplateType(string2);
                this.vTnrhdbObjs.addElement(object);
            }
        } else {
            this.trace("Problem with parsing args.  Should never be here");
            throw new Exception("problem with parsing args");
        }
        this.vHostObjs.addElement(hostData);
        stringArray2 = commandParser.getUnmatchedOptions();
        if (stringArray2.length >= 1) {
            int n = 0;
            while (n < stringArray2.length) {
                this.trace("unrecognized option:  " + stringArray2[n]);
                ++n;
            }
            throw new HostMgrCliArgParsingException(stringArray2[0]);
        }
    }

    private void parseAddTnrhdbDataHostname(String[] stringArray) throws Exception {
        String string;
        String[] stringArray2;
        this.trace("enterred parseTnrhdbDataHostname");
        this.initCommandLineOptions();
        CommandParser commandParser = new CommandParser(null, null, true, null, null);
        commandParser.addOption((CommandOption)this.coHelp);
        commandParser.addOption((CommandOption)this.coTask);
        commandParser.addOption((CommandOption)this.coHostname);
        commandParser.addOption((CommandOption)this.coTemplate);
        if (commandParser.parseArgs(stringArray)) {
            stringArray2 = new TnrhdbData();
            String string2 = (String)this.coHostname.getValue();
            string = this.getIpFromName(string2);
            if (string == null) {
                throw new HostException("EXM_HOST_CLI_NO_MATCH_HOST");
            }
        } else {
            this.trace("Problem with parsing args.  Should never be here");
            throw new Exception("problem with parsing args");
        }
        stringArray2.setIpAddress(string);
        String string3 = (String)this.coTemplate.getValue();
        this.validateTemplateName(string3);
        stringArray2.setTemplateType(string3);
        this.vTnrhdbObjs.addElement(stringArray2);
        stringArray2 = commandParser.getUnmatchedOptions();
        if (stringArray2.length >= 1) {
            int n = 0;
            while (n < stringArray2.length) {
                this.trace("unrecognized option:  " + stringArray2[n]);
                ++n;
            }
            throw new HostMgrCliArgParsingException(stringArray2[0]);
        }
    }

    private void parseAddTnrhdbDataIpaddr(String[] stringArray) throws Exception {
        String string;
        String[] stringArray2;
        this.trace("enterred parseTnrhdbDataIpaddr");
        this.initCommandLineOptions();
        CommandParser commandParser = new CommandParser(null, null, true, null, null);
        commandParser.addOption((CommandOption)this.coHelp);
        commandParser.addOption((CommandOption)this.coIpaddr);
        commandParser.addOption((CommandOption)this.coTemplate);
        commandParser.addOption((CommandOption)this.coTask);
        if (commandParser.parseArgs(stringArray)) {
            stringArray2 = new TnrhdbData();
            string = (String)this.coIpaddr.getValue();
            TnrhdbData.validateIPAddress(string);
            if (!TnrhdbData.isIPv6Address(string) && this.getHostNameFromIp(string) == null) {
                throw new HostException("EXM_HOST_CLI_NO_MATCH_IP");
            }
        } else {
            this.trace("Problem with parsing args.  Should never be here");
            throw new Exception("problem with parsing args");
        }
        stringArray2.setIpAddress(string);
        String string2 = (String)this.coTemplate.getValue();
        this.validateTemplateName(string2);
        stringArray2.setTemplateType(string2);
        this.vTnrhdbObjs.addElement(stringArray2);
        stringArray2 = commandParser.getUnmatchedOptions();
        if (stringArray2.length >= 1) {
            int n = 0;
            while (n < stringArray2.length) {
                this.trace("unrecognized option:  " + stringArray2[n]);
                ++n;
            }
            throw new HostMgrCliArgParsingException(stringArray2[0]);
        }
    }

    private void parseAddTnrhdbDataWildIp(String[] stringArray) throws Exception {
        TnrhdbData tnrhdbData;
        String[] stringArray2;
        this.trace("enterred parseTnrhdbDataWildIp");
        this.initCommandLineOptions();
        CommandParser commandParser = new CommandParser(null, null, true, null, null);
        commandParser.addOption((CommandOption)this.coHelp);
        commandParser.addOption((CommandOption)this.coIpwild);
        commandParser.addOption((CommandOption)this.coTemplate);
        commandParser.addOption((CommandOption)this.coTask);
        commandParser.addOption((CommandOption)this.coPrefixLen);
        if (commandParser.parseArgs(stringArray)) {
            this.trace("adding to tnrhdb database");
            stringArray2 = (String[])this.coIpwild.getValue();
            tnrhdbData = new TnrhdbData();
            tnrhdbData.setIpAddress((String)stringArray2);
            String string = (String)this.coTemplate.getValue();
            this.validateTemplateName(string);
            tnrhdbData.setTemplateType(string);
            if (this.coPrefixLen.wasSet()) {
                String string2 = (String)this.coPrefixLen.getValue();
                tnrhdbData.setPrefixLen(string2);
                tnrhdbData.validatePrefixLen();
            }
            if (!tnrhdbData.isWildCardIPAddress()) {
                throw new HostException("EXM_HOST_CLI_NOT_WILD_CARD");
            }
        } else {
            this.trace("Problem with parsing args.  Should never be here");
            throw new Exception("problem with parsing args");
        }
        this.vTnrhdbObjs.addElement(tnrhdbData);
        stringArray2 = commandParser.getUnmatchedOptions();
        if (stringArray2.length >= 1) {
            int n = 0;
            while (n < stringArray2.length) {
                this.trace("unrecognized option:  " + stringArray2[n]);
                ++n;
            }
            throw new HostMgrCliArgParsingException(stringArray2[0]);
        }
    }

    private void parseAndValidateArgs(String[] stringArray) throws Exception {
        switch (this.getOperation()) {
            case 0: {
                this.checkForAddOptions(stringArray);
                break;
            }
            case 1: {
                this.checkForDeleteOptions(stringArray);
                break;
            }
            case 2: {
                this.checkForModifyOptions(stringArray);
                break;
            }
            case 3: {
                this.checkForViewOptions(stringArray);
                break;
            }
            default: {
                this.trace("should never be here:  xxxx");
                this.trace("couldn't recognize switch:  " + this.getOperation());
                break;
            }
        }
    }

    private void parseModifyHostDataOptions(String[] stringArray) throws Exception {
        String[] stringArray2;
        this.trace("enterred parseModHostDataOptions");
        boolean bl = false;
        this.initCommandLineOptions();
        CommandParser commandParser = new CommandParser(null, null, true, null, null);
        commandParser.addOption((CommandOption)this.coHelp);
        commandParser.addOption((CommandOption)this.coHostname);
        commandParser.addOption((CommandOption)this.coIpaddr);
        commandParser.addOption((CommandOption)this.coTemplate);
        commandParser.addOption((CommandOption)this.coAlias);
        commandParser.addOption((CommandOption)this.coDescription);
        commandParser.addOption((CommandOption)this.coEther);
        commandParser.addOption((CommandOption)this.coTask);
        if (commandParser.parseArgs(stringArray)) {
            Object object;
            this.trace("modifying host database");
            stringArray2 = null;
            String string = (String)this.coHostname.getValue();
            stringArray2 = this.getIpFromName(string);
            if (stringArray2 == null) {
                throw new HostException("EXM_HOST_CLI_NO_MATCH_HOST");
            }
            HostData hostData = new HostData(string);
            TnrhdbData tnrhdbData = null;
            if (this.coIpaddr.wasSet()) {
                stringArray2 = (String)this.coIpaddr.getValue();
                HostData.validateIPAddress((String)stringArray2);
                hostData.setNetworkAddress((String)stringArray2);
                bl = true;
                object = this.getHostMgr().listTnrhdbByIPAddress((String)stringArray2, null);
                if (object != null && ((Vector)object).size() == 1) {
                    tnrhdbData = (TnrhdbData)((Vector)object).elementAt(0);
                    tnrhdbData.setIpAddress((String)stringArray2);
                    this.vTnrhdbObjs.addElement(tnrhdbData);
                }
            }
            if (this.coAlias.wasSet()) {
                object = (String)this.coAlias.getValue();
                HostData.validateAliasNames((String)object);
                hostData.setAliases((String)object);
                bl = true;
            }
            if (this.coDescription.wasSet()) {
                object = (String)this.coDescription.getValue();
                HostData.validateDescription((String)object);
                hostData.setDescription((String)object);
                bl = true;
            }
            if (this.coEther.wasSet()) {
                object = (String)this.coEther.getValue();
                HostData.validateEthernetAddress((String)object);
                hostData.setEthernetAddress((String)object);
                bl = true;
            }
            if (bl) {
                this.vHostObjs.addElement(hostData);
            }
            if (this.coTemplate.wasSet()) {
                if (tnrhdbData == null) {
                    tnrhdbData = new TnrhdbData();
                    TnrhdbData.validateIPAddress((String)stringArray2);
                    tnrhdbData.setIpAddress((String)stringArray2);
                    this.vTnrhdbObjs.addElement(tnrhdbData);
                }
                object = (String)this.coTemplate.getValue();
                this.validateTemplateName((String)object);
                tnrhdbData.setTemplateType((String)object);
                bl = true;
            }
        } else {
            this.trace("Problem with parsing args.  Should never be here");
            throw new Exception("problem with parsing args");
        }
        stringArray2 = commandParser.getUnmatchedOptions();
        if (stringArray2.length >= 1) {
            int n = 0;
            while (n < stringArray2.length) {
                this.trace("unrecognized option:  " + stringArray2[n]);
                ++n;
            }
            throw new HostMgrCliArgParsingException(stringArray2[0]);
        }
        if (!bl) {
            throw new HostMgrCliArgParsingException("EXM_CLI_GENERIC_ERROR");
        }
    }

    private void parseModifyTnrhdbDataIpaddr(String[] stringArray) throws Exception {
        String string;
        String[] stringArray2;
        this.trace("enterred parseModifyTnrhdbDataIpaddr");
        this.initCommandLineOptions();
        CommandParser commandParser = new CommandParser(null, null, true, null, null);
        commandParser.addOption((CommandOption)this.coHelp);
        commandParser.addOption((CommandOption)this.coIpaddr);
        commandParser.addOption((CommandOption)this.coTemplate);
        commandParser.addOption((CommandOption)this.coTask);
        if (commandParser.parseArgs(stringArray)) {
            stringArray2 = new TnrhdbData();
            string = (String)this.coIpaddr.getValue();
            TnrhdbData.validateIPAddress(string);
            if (!TnrhdbData.isIPv6Address(string) && this.getHostNameFromIp(string) == null) {
                throw new HostException("EXM_HOST_CLI_NO_MATCH_IP");
            }
        } else {
            this.trace("Problem with parsing args.  Should never be here");
            throw new Exception("problem with parsing args");
        }
        stringArray2.setIpAddress(string);
        String string2 = (String)this.coTemplate.getValue();
        this.validateTemplateName(string2);
        stringArray2.setTemplateType(string2);
        this.vTnrhdbObjs.addElement(stringArray2);
        stringArray2 = commandParser.getUnmatchedOptions();
        if (stringArray2.length >= 1) {
            int n = 0;
            while (n < stringArray2.length) {
                this.trace("unrecognized option:  " + stringArray2[n]);
                ++n;
            }
            throw new HostMgrCliArgParsingException(stringArray2[0]);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseModifyTnrhdbDataWildIp(String[] stringArray) throws Exception {
        TnrhdbData tnrhdbData;
        String[] stringArray2;
        this.trace("enterred parseModifyTnrhdbDataWildIp");
        this.initCommandLineOptions();
        CommandParser commandParser = new CommandParser(null, null, true, null, null);
        commandParser.addOption((CommandOption)this.coHelp);
        commandParser.addOption((CommandOption)this.coIpwild);
        commandParser.addOption((CommandOption)this.coTemplate);
        commandParser.addOption((CommandOption)this.coTask);
        commandParser.addOption((CommandOption)this.coPrefixLen);
        if (commandParser.parseArgs(stringArray)) {
            Vector vector;
            this.trace("adding to tnrhdb database");
            stringArray2 = (String[])this.coIpwild.getValue();
            String string = null;
            if (this.coPrefixLen.wasSet()) {
                string = (String)this.coPrefixLen.getValue();
            }
            if ((vector = this.getHostMgr().listTnrhdbByIPAddress((String)stringArray2, string)) == null || vector.size() == 0) {
                throw new HostException("EXM_HOST_CLI_NOIP_IN_TNRHDB", (String)stringArray2);
            }
            if (vector.size() > 1) {
                throw new HostException("EXM_HOST_CLI_IP_IN_TNRHDB_MORE_THAN_ONE", (String)stringArray2);
            }
            tnrhdbData = (TnrhdbData)vector.elementAt(0);
            if (!this.coTemplate.wasSet()) throw new HostMgrCliArgParsingException("EXM_CLI_GENERIC_ERROR");
            String string2 = (String)this.coTemplate.getValue();
            this.validateTemplateName(string2);
            tnrhdbData.setTemplateType(string2);
            if (!tnrhdbData.isWildCardIPAddress()) {
                throw new HostException("EXM_HOST_CLI_NOT_WILD_CARD");
            }
        } else {
            this.trace("Problem with parsing args.  Should never be here");
            throw new Exception("problem with parsing args");
        }
        this.vTnrhdbObjs.addElement(tnrhdbData);
        stringArray2 = commandParser.getUnmatchedOptions();
        if (stringArray2.length < 1) return;
        int n = 0;
        while (n < stringArray2.length) {
            this.trace("unrecognized option:  " + stringArray2[n]);
            ++n;
        }
        throw new HostMgrCliArgParsingException(stringArray2[0]);
    }

    public int runCommandLine(String[] stringArray, InputStream inputStream, PrintStream printStream, PrintStream printStream2) {
        String[] stringArray2 = new String[]{};
        int n = 0;
        if (stringArray == null) {
            this.trace("runCommandLine args == null");
            return 1;
        }
        try {
            this.trace("calling initCommandLineOptions");
            this.initCommandLineOptions();
            this.trace("calling doFirstArgPass");
            this.doFirstArgPass(stringArray);
            this.initCommandLineOptions();
            this.trace("calling parseAndValidateArgs");
            this.parseAndValidateArgs(stringArray);
        }
        catch (HostMgrCliHelpException hostMgrCliHelpException) {
            this.trace("got HostMgrCliHelpException in runCommandLine");
            return 0;
        }
        catch (HostMgrCliArgParsingException hostMgrCliArgParsingException) {
            String string = hostMgrCliArgParsingException.getLocalizedMessage();
            this.handleErrors(string);
            return 1;
        }
        catch (Exception exception) {
            String string = exception.getLocalizedMessage();
            this.handleErrors(string);
            return 2;
        }
        try {
            this.doOperation();
        }
        catch (AdminException adminException) {
            this.trace("runCommandLine, AdminException:  " + adminException.getLocalizedMessage());
            System.out.println(adminException.getLocalizedMessage());
            n = 2;
            if (this.getDebugStatus()) {
                adminException.printStackTrace();
            }
        }
        catch (Exception exception) {
            this.trace("runCommandLine, Exception:  " + exception.getLocalizedMessage());
            System.out.println(exception.getLocalizedMessage());
            this.getDebugStatus();
            n = 2;
        }
        return n;
    }

    private void setOperation(char c) {
        switch (c) {
            case 'A': {
                this.setOperation(0);
                this.trace("Action: Add a host");
                break;
            }
            case 'X': {
                this.setOperation(1);
                this.trace("Action: Delete a host");
                break;
            }
            case 'M': {
                this.setOperation(2);
                this.trace("Action: Modify a host");
                break;
            }
            case 'V': {
                this.setOperation(3);
                this.trace("Action: View hosts");
                break;
            }
            default: {
                this.trace("Action: UNKNOWN");
            }
        }
    }

    private void validateTemplateName(String string) throws Exception {
        Vector vector = this.getHostMgr().listTemplates();
        if (vector == null) {
            throw new HostException("EXM_HOST_CLI_INVALID_TEMPLATE");
        }
        if (vector.size() == 0) {
            throw new HostException("EXM_HOST_CLI_INVALID_TEMPLATE");
        }
        boolean bl = false;
        int n = 0;
        while (n < vector.size()) {
            TemplateData templateData = (TemplateData)vector.elementAt(n);
            String string2 = templateData.getTemplateName();
            if (string2.compareTo(string) == 0) {
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            throw new HostException("EXM_HOST_CLI_INVALID_TEMPLATE");
        }
    }

    private void viewHost() throws Exception {
        this.trace("entered viewHost()");
        switch (this.viewOption) {
            case 1: 
            case 2: {
                ListProperties listProperties = new ListProperties();
                listProperties.setSortColumn("hostListComputerName");
                Vector vector = this.getHostMgr().listHosts(listProperties);
                if (vector == null || vector.size() == 0) {
                    if (this.viewOption == 1) {
                        System.out.println(this.getLocalizedMessage("no_host"));
                    } else {
                        System.out.println(this.getLocalizedMessage("no_ether"));
                    }
                }
                if (this.viewOption == 1) {
                    int n = 0;
                    while (n < vector.size()) {
                        HostData hostData = (HostData)vector.elementAt(n);
                        if (hostData != null) {
                            String string;
                            String string2 = hostData.getHostName();
                            string2 = String.valueOf(string2) + SEP + hostData.getNetworkAddress();
                            String string3 = hostData.getAliases();
                            if (string3 != null) {
                                string2 = String.valueOf(string2) + SEP + string3;
                            }
                            if ((string = hostData.getDescription()) != null) {
                                string2 = String.valueOf(string2) + SEP + string;
                            }
                            System.out.println(string2);
                        }
                        ++n;
                    }
                    break;
                }
                boolean bl = false;
                int n = 0;
                while (n < vector.size()) {
                    String string;
                    HostData hostData = (HostData)vector.elementAt(n);
                    if (hostData != null && (string = hostData.getEthernetAddress()) != null && !string.equals("")) {
                        String string4 = String.valueOf(string) + SEP + hostData.getHostName();
                        bl = true;
                        System.out.println(string4);
                    }
                    ++n;
                }
                if (bl) break;
                System.out.println(this.getLocalizedMessage("no_ether"));
                break;
            }
            case 3: {
                Vector vector = this.getHostMgr().listTnrhdb("ALL");
                if (vector == null || vector.size() == 0) {
                    System.out.println(this.getLocalizedMessage("no_tnrhdb"));
                }
                int n = 0;
                while (n < vector.size()) {
                    TnrhdbData tnrhdbData = (TnrhdbData)vector.elementAt(n);
                    if (tnrhdbData != null) {
                        String string = tnrhdbData.getPrefixLen();
                        String string5 = tnrhdbData.getIpAddress();
                        String string6 = tnrhdbData.getTemplateType();
                        String string7 = string == null ? String.valueOf(string5) + SEP + string6 : String.valueOf(string5) + "/" + string + SEP + string6;
                        System.out.println(string7);
                    }
                    ++n;
                }
                break;
            }
        }
    }
}

