/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.hostmgr.cli.network;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.CommandLineOption;
import com.sun.admin.cis.common.ListProperties;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.hostmgr.cli.HostMgrCliTool;
import com.sun.admin.hostmgr.common.HostException;
import com.sun.admin.hostmgr.common.HostMgrCliArgParsingException;
import com.sun.admin.hostmgr.common.HostMgrCliHelpException;
import com.sun.admin.hostmgr.common.NetworkData;
import com.sun.management.viper.util.CommandOption;
import com.sun.management.viper.util.CommandParser;
import com.sun.management.viper.util.ResourceManager;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;

public class HostMgrNetworkCli
extends HostMgrCliTool {
    private Vector vObjs = new Vector();
    private CommandLineOption coTaskFile;
    private CommandLineOption coNetworkName;
    private CommandLineOption coIPaddress;
    private CommandLineOption coNetmask;
    private CommandLineOption coAliases;
    private CommandLineOption coDescription;
    private CommandLineOption coHelp;
    ResourceBundle bundle;

    public HostMgrNetworkCli() {
        try {
            this.bundle = ResourceManager.getBundle((String)"com.sun.admin.hostmgr.cli.network.resources.Resources", this.getClass());
            this.setResourceBundle(this.bundle);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.bundle = null;
        }
        if (this.bundle == null) {
            this.bundle = ResourceBundle.getBundle("com.sun.admin.hostmgr.cli.network.resources.Resources", Locale.getDefault(), this.getClass().getClassLoader());
            this.setResourceBundle(this.bundle);
        }
        if (this.bundle == null) {
            this.trace("HostMgrNetworkCli constructor ... Null bundle !!!");
            System.exit(2);
        }
    }

    public void addObject() throws Exception {
        try {
            NetworkData networkData = (NetworkData)this.vObjs.elementAt(0);
            if (this.getHostMgr() == null) {
                this.trace("in addObject:  hostmgr is null!");
                throw new HostException("EXM_CLI_NO_SERVICE");
            }
            this.getHostMgr().addNetwork(networkData);
        }
        catch (Exception exception) {
            this.trace("exception in addObject(): " + exception.getMessage());
            if (this.getDebugStatus()) {
                exception.printStackTrace();
            }
            throw exception;
        }
    }

    private void checkForAddOptions(String[] stringArray) throws Exception {
        NetworkData networkData = new NetworkData();
        CommandParser commandParser = new CommandParser(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"smnetworkadd_name"), ResourceStrings.getString((ResourceBundle)this.bundle, (String)"smnetworkadd_description"), true, null, null);
        try {
            String[] stringArray2;
            commandParser.addOption((CommandOption)this.coNetworkName);
            commandParser.addOption((CommandOption)this.coIPaddress);
            commandParser.addOption((CommandOption)this.coNetmask);
            commandParser.addOption((CommandOption)this.coAliases);
            commandParser.addOption((CommandOption)this.coDescription);
            commandParser.addOption((CommandOption)this.coTaskFile);
            commandParser.addOption((CommandOption)this.coHelp);
            if (commandParser.parseArgs(stringArray)) {
                if (this.coNetworkName.wasSet()) {
                    stringArray2 = (String[])this.coNetworkName.getValue();
                    this.trace("Network name = " + (String)stringArray2);
                    networkData.setNetworkName((String)stringArray2);
                }
                if (this.coIPaddress.wasSet()) {
                    stringArray2 = (String)this.coIPaddress.getValue();
                    this.trace("Network IP address = " + (String)stringArray2);
                    networkData.setNetworkAddress((String)stringArray2);
                }
                if (this.coNetmask.wasSet()) {
                    stringArray2 = (String)this.coNetmask.getValue();
                    this.trace("Netmask = " + (String)stringArray2);
                    networkData.setNetmask((String)stringArray2);
                }
                if (this.coAliases.wasSet()) {
                    stringArray2 = (String)this.coAliases.getValue();
                    this.trace("Aliases = " + (String)stringArray2);
                    networkData.setAliases((String)stringArray2);
                }
                if (this.coDescription.wasSet()) {
                    stringArray2 = (String)this.coDescription.getValue();
                    this.trace("Description = " + (String)stringArray2);
                    networkData.setDescription((String)stringArray2);
                }
                if (this.coTaskFile.wasSet()) {
                    stringArray2 = (String)this.coTaskFile.getValue();
                    this.trace("Task = " + (String)stringArray2);
                    this.setTaskOperation(stringArray2.charAt(0));
                }
                if (this.coHelp.wasSet()) {
                    this.trace("read in help");
                    commandParser.printUsage(null);
                    throw new HostMgrCliHelpException(null);
                }
            } else {
                this.trace("Error parsing args");
                throw new Exception("parseArgs failed");
            }
            stringArray2 = commandParser.getUnmatchedOptions();
            if (stringArray2.length >= 1) {
                int n = 0;
                while (n < stringArray2.length) {
                    this.trace("unrecognized option:  " + stringArray2[n]);
                    ++n;
                }
                commandParser.printUsage(null);
                throw new HostMgrCliArgParsingException("EXM_CLI_INVALID_ARG", stringArray2[0]);
            }
            this.vObjs.addElement(networkData);
        }
        catch (HostMgrCliHelpException hostMgrCliHelpException) {
            throw hostMgrCliHelpException;
        }
        catch (HostMgrCliArgParsingException hostMgrCliArgParsingException) {
            throw hostMgrCliArgParsingException;
        }
        catch (HostException hostException) {
            throw hostException;
        }
        catch (Throwable throwable) {
            this.trace("Throwable type-of-exception");
            if (this.getDebugStatus()) {
                throwable.printStackTrace();
            }
            throw new HostMgrCliArgParsingException("EXM_CLI_GENERIC_ERROR");
        }
    }

    private void checkForDeleteOptions(String[] stringArray) throws Exception {
        NetworkData networkData = new NetworkData();
        NetworkData networkData2 = new NetworkData();
        CommandParser commandParser = new CommandParser(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"smnetworkdel_name"), ResourceStrings.getString((ResourceBundle)this.bundle, (String)"smnetworkdel_description"), true, null, null);
        try {
            String[] stringArray2;
            commandParser.addOption((CommandOption)this.coNetworkName);
            commandParser.addOption((CommandOption)this.coTaskFile);
            commandParser.addOption((CommandOption)this.coHelp);
            if (commandParser.parseArgs(stringArray)) {
                if (this.coNetworkName.wasSet()) {
                    stringArray2 = (String[])this.coNetworkName.getValue();
                    this.trace("Network name = " + (String)stringArray2);
                    networkData.setNetworkName((String)stringArray2);
                }
                if ((networkData2 = this.getHostMgr().getNetwork(networkData)) == null) {
                    throw new HostException("EXM_HST_CMN7");
                }
                if (this.coTaskFile.wasSet()) {
                    stringArray2 = (String)this.coTaskFile.getValue();
                    this.trace("Task = " + (String)stringArray2);
                    this.setTaskOperation(stringArray2.charAt(0));
                }
                if (this.coHelp.wasSet()) {
                    this.trace("read in help");
                    commandParser.printUsage(null);
                    throw new HostMgrCliHelpException(null);
                }
            } else {
                this.trace("Error parsing args");
                throw new Exception("parseArgs failed");
            }
            stringArray2 = commandParser.getUnmatchedOptions();
            if (stringArray2.length >= 1) {
                int n = 0;
                while (n < stringArray2.length) {
                    this.trace("unrecognized option:  " + stringArray2[n]);
                    ++n;
                }
                commandParser.printUsage(null);
                throw new HostMgrCliArgParsingException("EXM_CLI_INVALID_ARG", stringArray2[0]);
            }
            this.vObjs.addElement(networkData2);
        }
        catch (HostMgrCliHelpException hostMgrCliHelpException) {
            throw hostMgrCliHelpException;
        }
        catch (HostMgrCliArgParsingException hostMgrCliArgParsingException) {
            throw hostMgrCliArgParsingException;
        }
        catch (HostException hostException) {
            throw hostException;
        }
        catch (Throwable throwable) {
            this.trace("Throwable type-of-exception");
            if (this.getDebugStatus()) {
                throwable.printStackTrace();
            }
            throw new HostMgrCliArgParsingException("EXM_CLI_GENERIC_ERROR");
        }
    }

    private void checkForModifyOptions(String[] stringArray) throws Exception {
        NetworkData networkData = new NetworkData();
        NetworkData networkData2 = new NetworkData();
        CommandParser commandParser = new CommandParser(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"smnetworkmod_name"), ResourceStrings.getString((ResourceBundle)this.bundle, (String)"smnetworkmod_description"), true, null, null);
        try {
            String[] stringArray2;
            commandParser.addOption((CommandOption)this.coNetworkName);
            commandParser.addOption((CommandOption)this.coIPaddress);
            commandParser.addOption((CommandOption)this.coNetmask);
            commandParser.addOption((CommandOption)this.coAliases);
            commandParser.addOption((CommandOption)this.coDescription);
            commandParser.addOption((CommandOption)this.coTaskFile);
            commandParser.addOption((CommandOption)this.coHelp);
            if (commandParser.parseArgs(stringArray)) {
                if (this.coNetworkName.wasSet()) {
                    stringArray2 = (String[])this.coNetworkName.getValue();
                    this.trace("Network name = " + (String)stringArray2);
                    networkData2.setNetworkName((String)stringArray2);
                    networkData = this.getHostMgr().getNetwork(networkData2);
                    if (networkData == null) {
                        throw new HostException("EXM_HST_CMN7");
                    }
                }
                if (this.coIPaddress.wasSet()) {
                    stringArray2 = (String)this.coIPaddress.getValue();
                    this.trace("Network IP address = " + (String)stringArray2);
                    networkData2.setNetworkAddress((String)stringArray2);
                }
                if (this.coNetmask.wasSet()) {
                    stringArray2 = (String)this.coNetmask.getValue();
                    this.trace("Netmask = " + (String)stringArray2);
                    networkData2.setNetmask((String)stringArray2);
                } else if (networkData != null) {
                    networkData2.setNetmask(networkData.getNetmask());
                }
                if (this.coAliases.wasSet()) {
                    stringArray2 = (String)this.coAliases.getValue();
                    this.trace("Aliases = " + (String)stringArray2);
                    networkData2.setAliases((String)stringArray2);
                } else if (networkData != null) {
                    networkData2.setAliases(networkData.getAliases());
                }
                if (this.coDescription.wasSet()) {
                    stringArray2 = (String)this.coDescription.getValue();
                    this.trace("Description = " + (String)stringArray2);
                    networkData2.setDescription((String)stringArray2);
                } else if (networkData != null) {
                    networkData2.setDescription(networkData.getDescription());
                }
                if (this.coTaskFile.wasSet()) {
                    stringArray2 = (String)this.coTaskFile.getValue();
                    this.trace("Task = " + (String)stringArray2);
                    this.setTaskOperation(stringArray2.charAt(0));
                }
                if (this.coHelp.wasSet()) {
                    this.trace("read in help");
                    commandParser.printUsage(null);
                    throw new HostMgrCliHelpException(null);
                }
            } else {
                this.trace("Error parsing args");
                throw new Exception("parseArgs failed");
            }
            stringArray2 = commandParser.getUnmatchedOptions();
            if (stringArray2.length >= 1) {
                int n = 0;
                while (n < stringArray2.length) {
                    this.trace("unrecognized option:  " + stringArray2[n]);
                    ++n;
                }
                commandParser.printUsage(null);
                throw new HostMgrCliArgParsingException("EXM_CLI_INVALID_ARG", stringArray2[0]);
            }
            this.vObjs.addElement(networkData);
            this.vObjs.addElement(networkData2);
        }
        catch (HostMgrCliHelpException hostMgrCliHelpException) {
            throw hostMgrCliHelpException;
        }
        catch (HostMgrCliArgParsingException hostMgrCliArgParsingException) {
            throw hostMgrCliArgParsingException;
        }
        catch (HostException hostException) {
            throw hostException;
        }
        catch (Throwable throwable) {
            this.trace("Throwable type-of-exception");
            if (this.getDebugStatus()) {
                throwable.printStackTrace();
            }
            throw new HostMgrCliArgParsingException("EXM_CLI_GENERIC_ERROR");
        }
    }

    private void checkForViewOptions(String[] stringArray) throws Exception {
        NetworkData networkData = new NetworkData();
        CommandParser commandParser = new CommandParser(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"smnetworkls_name"), ResourceStrings.getString((ResourceBundle)this.bundle, (String)"smnetworkls_description"), true, null, null);
        try {
            String[] stringArray2;
            commandParser.addOption((CommandOption)this.coTaskFile);
            commandParser.addOption((CommandOption)this.coHelp);
            if (commandParser.parseArgs(stringArray)) {
                if (this.coTaskFile.wasSet()) {
                    stringArray2 = (String[])this.coTaskFile.getValue();
                    this.trace("Task = " + (String)stringArray2);
                    this.setTaskOperation(stringArray2.charAt(0));
                }
                if (this.coHelp.wasSet()) {
                    this.trace("read in help");
                    commandParser.printUsage(null);
                    throw new HostMgrCliHelpException(null);
                }
            } else {
                this.trace("Error parsing args");
                throw new Exception("parseArgs failed");
            }
            stringArray2 = commandParser.getUnmatchedOptions();
            if (stringArray2.length >= 1) {
                int n = 0;
                while (n < stringArray2.length) {
                    this.trace("unrecognized option:  " + stringArray2[n]);
                    ++n;
                }
                commandParser.printUsage(null);
                throw new HostMgrCliArgParsingException("EXM_CLI_INVALID_ARG", stringArray2[0]);
            }
        }
        catch (HostMgrCliHelpException hostMgrCliHelpException) {
            throw hostMgrCliHelpException;
        }
        catch (HostMgrCliArgParsingException hostMgrCliArgParsingException) {
            throw hostMgrCliArgParsingException;
        }
        catch (HostException hostException) {
            throw hostException;
        }
        catch (Throwable throwable) {
            this.trace("Throwable type-of-exception");
            if (this.getDebugStatus()) {
                throwable.printStackTrace();
            }
            throw new HostMgrCliArgParsingException("EXM_CLI_GENERIC_ERROR");
        }
    }

    public void deleteObject() throws Exception {
        this.trace("in HostMgrNetworkCli->deleteObject()");
        try {
            this.trace("vObjs.size() = " + this.vObjs.size());
            NetworkData networkData = (NetworkData)this.vObjs.elementAt(0);
            if (this.getHostMgr() == null) {
                this.trace("hostmgr is null!");
                throw new HostException("EXM_CLI_NO_SERVICE");
            }
            this.getHostMgr().deleteNetwork(networkData);
        }
        catch (Exception exception) {
            this.trace("exception in deleteObject(): " + exception.getMessage());
            if (this.getDebugStatus()) {
                exception.printStackTrace();
            }
            throw exception;
        }
    }

    private void doFirstArgPass(String[] stringArray) throws Exception {
        block6: {
            NetworkData networkData = new NetworkData();
            CommandParser commandParser = new CommandParser("HostMgrNetworkCli", "main tool for network related cli's", true, null, null);
            try {
                commandParser.addOption((CommandOption)this.coTaskFile);
                commandParser.addOption((CommandOption)this.coHelp);
                if (commandParser.parseArgs(stringArray)) {
                    if (this.coTaskFile.wasSet()) {
                        String string = (String)this.coTaskFile.getValue();
                        this.trace("Task = " + string);
                        this.setTaskOperation(string.charAt(0));
                    }
                } else {
                    this.trace("Error parsing args");
                    throw new HostException("EXM_CLI_MISSING_ARG");
                }
                this.coHelp.wasSet();
                if (this.getOperation() == -1) {
                    this.trace("Error:  iOperation == -1");
                    throw new HostException("EXM_CLI_NO_TASK");
                }
            }
            catch (Throwable throwable) {
                this.trace("Throwable type-of-exception");
                if (!this.getDebugStatus()) break block6;
                throwable.printStackTrace();
            }
        }
    }

    private void initCommandLineOptions() {
        this.coTaskFile = new CommandLineOption("task", ResourceStrings.getString((ResourceBundle)this.bundle, (String)"arg_task_desc"), "K", 1, false, false, (Object)"V", true, true);
        this.coNetworkName = new CommandLineOption("name", ResourceStrings.getString((ResourceBundle)this.bundle, (String)"arg_networkname_desc"), "n", 1, false, false, null, true);
        this.coIPaddress = new CommandLineOption("ipaddress", ResourceStrings.getString((ResourceBundle)this.bundle, (String)"arg_ipaddress_desc"), "i", 1, false, false, null, true);
        this.coNetmask = new CommandLineOption("netmask", ResourceStrings.getString((ResourceBundle)this.bundle, (String)"arg_netmask_desc"), "m", 1, true, false, null, true);
        this.coAliases = new CommandLineOption("aliases", ResourceStrings.getString((ResourceBundle)this.bundle, (String)"arg_aliases_desc"), "a", 1, true, false, null, true);
        this.coDescription = new CommandLineOption("description", ResourceStrings.getString((ResourceBundle)this.bundle, (String)"arg_description_desc"), "d", 1, true, false, null, true);
        this.coHelp = new CommandLineOption("help", ResourceStrings.getString((ResourceBundle)this.bundle, (String)"arg_help_desc"), "h", 0, true, false, null, false);
        this.coHelp.setPriority(true);
    }

    public void modifyObject() throws Exception {
        try {
            NetworkData networkData = (NetworkData)this.vObjs.elementAt(0);
            NetworkData networkData2 = (NetworkData)this.vObjs.elementAt(1);
            this.trace("The nework name  " + networkData.getNetworkName());
            this.trace("old nework IP address  " + networkData.getNetworkAddress());
            this.trace("new nework IP address  " + networkData2.getNetworkAddress());
            if (this.getHostMgr() == null) {
                this.trace("in modifyObject:  hostmgr is null!");
                throw new HostException("EXM_CLI_NO_SERVICE");
            }
            this.getHostMgr().setNetwork(networkData, networkData2);
        }
        catch (Exception exception) {
            this.trace("exception in modifyObject(): " + exception.getMessage());
            if (this.getDebugStatus()) {
                exception.printStackTrace();
            }
            throw exception;
        }
    }

    private void parseAndValidateArgs(String[] stringArray) throws Exception {
        switch (this.getOperation()) {
            case 0: {
                this.checkForAddOptions(stringArray);
                break;
            }
            case 1: {
                this.checkForDeleteOptions(stringArray);
                break;
            }
            case 2: {
                this.checkForModifyOptions(stringArray);
                break;
            }
            case 3: {
                this.checkForViewOptions(stringArray);
                break;
            }
            default: {
                this.trace("should never be here:  xxxx");
                this.trace("couldn't recognize switch:  " + this.getOperation());
                break;
            }
        }
    }

    public int runCommandLine(String[] stringArray, InputStream inputStream, PrintStream printStream, PrintStream printStream2) {
        String[] stringArray2 = new String[]{};
        int n = 0;
        try {
            this.trace("calling initCommandLineOptions");
            this.initCommandLineOptions();
            this.trace("calling doFirstArgPass");
            this.doFirstArgPass(stringArray);
            this.initCommandLineOptions();
            this.trace("calling parseAndValidateArgs");
            this.parseAndValidateArgs(stringArray);
        }
        catch (HostMgrCliHelpException hostMgrCliHelpException) {
            this.trace("got HostMgrCliHelpException in runCommandLine");
            return 0;
        }
        catch (HostMgrCliArgParsingException hostMgrCliArgParsingException) {
            String string = hostMgrCliArgParsingException.getLocalizedMessage();
            this.handleErrors(string);
            return 1;
        }
        catch (Exception exception) {
            String string = exception.getLocalizedMessage();
            this.handleErrors(string);
            if (this.getDebugStatus()) {
                exception.printStackTrace();
            }
            return 2;
        }
        try {
            this.doOperation();
        }
        catch (HostException hostException) {
            this.trace("runCommandLine, UserException:  " + hostException.getLocalizedMessage());
            this.handleErrors(hostException.getLocalizedMessage());
            n = 2;
        }
        catch (AdminException adminException) {
            this.trace("runCommandLine, AdminException:  " + adminException.getLocalizedMessage());
            this.handleErrors(adminException.getLocalizedMessage());
            n = 2;
        }
        catch (Exception exception) {
            this.trace("runCommandLine, Exception:  " + exception.getLocalizedMessage());
            this.handleErrors(exception.getLocalizedMessage());
            if (this.getDebugStatus()) {
                exception.printStackTrace();
            }
            n = 2;
        }
        return n;
    }

    public void viewObjectProps() throws Exception {
        NetworkData networkData = null;
        String string = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"view_name");
        String string2 = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"view_address");
        String string3 = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"view_netmask");
        String string4 = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"view_alias");
        String string5 = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"view_desc");
        this.trace("calling viewObjectProps");
        try {
            if (this.getHostMgr() == null) {
                this.trace("in viewObjectProps:  hostmgr is null!");
                throw new HostException("EXM_CLI_NO_SERVICE");
            }
            ListProperties listProperties = new ListProperties();
            listProperties.setCustomBooleanArg1(false);
            Vector vector = this.getHostMgr().listNetworks(listProperties);
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                networkData = (NetworkData)enumeration.nextElement();
                System.out.println(String.valueOf(string) + networkData.getNetworkName() + "  " + string2 + networkData.getNetworkAddress() + "  " + string3 + networkData.getNetmask() + "  " + string4 + networkData.getAliases() + "  " + string5 + networkData.getDescription());
            }
        }
        catch (Exception exception) {
            this.trace("exception in viewObjectProps(): " + exception.getMessage());
            if (this.getDebugStatus()) {
                exception.printStackTrace();
            }
            throw exception;
        }
    }
}

