/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.usermgr.client;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.ListProperties;
import com.sun.admin.tsol.common.AuditUserObj;
import com.sun.admin.tsol.server.TrustedSolarisServiceInterface;
import com.sun.admin.usermgr.common.AuthAttrObj;
import com.sun.admin.usermgr.common.EmailAliasObj;
import com.sun.admin.usermgr.common.ExecAttrObj;
import com.sun.admin.usermgr.common.GroupObj;
import com.sun.admin.usermgr.common.ProfAttrObj;
import com.sun.admin.usermgr.common.RightObj;
import com.sun.admin.usermgr.common.TemplateObj;
import com.sun.admin.usermgr.common.UserObj;
import com.sun.management.viper.AdminMgmtScope;
import com.sun.management.viper.Service;
import com.sun.management.viper.ToolInfrastructure;
import com.sun.management.viper.VPermission;
import com.sun.management.viper.services.Authorization;
import com.sun.management.viper.services.ServiceList;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Principal;
import java.util.Vector;

public abstract class ServiceWrapper {
    public static final String USERMGR_WRITE_RIGHT = "solaris.admin.usermgr.write";
    public static final String USERMGR_PASSWD_RIGHT = "solaris.admin.usermgr.pswd";
    public static final String USERMGR_READ_RIGHT = "solaris.admin.usermgr.read";
    public static final String ROLE_WRITE_RIGHT = "solaris.role.write";
    public static final String ROLE_ASSIGN_RIGHT = "solaris.role.assign";
    public static final String ROLE_DELEGATE_RIGHT = "solaris.role.delegate";
    public static final String PROF_WRITE_RIGHT = "solaris.profmgr.write";
    public static final String PROF_EXECATTR_WRITE_RIGHT = "solaris.profmgr.execattr.write";
    public static final String PROF_ASSIGN_RIGHT = "solaris.profmgr.assign";
    public static final String PROF_DELEGATE_RIGHT = "solaris.profmgr.delegate";
    public static final String USERMGR_LABEL_ADMIN_RIGHT = "solaris.admin.usermgr.labels";
    public static final String USERMGR_AUDIT_ADMIN_RIGHT = "solaris.admin.usermgr.audit";
    private TrustedSolarisServiceInterface tsolService = null;
    private ToolInfrastructure infrastructure;
    protected PermissionCollection permissionCollection;

    public abstract void addEmailAlias(EmailAliasObj var1) throws AdminException;

    public abstract void addGroup(GroupObj var1) throws AdminException;

    public abstract void addRight(RightObj var1) throws AdminException;

    public abstract void addTemplate(TemplateObj var1) throws AdminException;

    public abstract void addUser(UserObj var1) throws AdminException;

    public abstract GroupObj addUsersToGroup(GroupObj var1, String[] var2) throws AdminException;

    public abstract TemplateObj copyTemplate(String var1, String var2, String var3) throws AdminException;

    public abstract void createExecAttrEntry(ExecAttrObj var1) throws AdminException;

    public void deleteAuditUser(String string) throws AdminException {
        if (this.tsolService == null) {
            throw new AdminException("EXM_TSOL_DELETE_AUDIT_ERROR");
        }
        try {
            this.tsolService.removeAuditUser(string);
        }
        catch (Exception exception) {
            throw new AdminException("EXM_TSOL_DELETE_AUDIT_ERROR");
        }
    }

    public abstract void deleteEmailAlias(EmailAliasObj var1) throws AdminException;

    public abstract void deleteExecAttrEntry(String var1, String var2, String var3, String var4) throws AdminException;

    public abstract void deleteGroup(GroupObj var1) throws AdminException;

    public abstract void deleteRight(RightObj var1) throws AdminException;

    public abstract void deleteTemplate(String var1) throws AdminException;

    public abstract void deleteUser(UserObj var1) throws AdminException;

    public abstract GroupObj deleteUsersFromGroup(GroupObj var1, String[] var2) throws AdminException;

    protected void finalize() throws Throwable {
        if (this.tsolService != null) {
            this.infrastructure.releaseService((Service)this.tsolService);
        }
    }

    public abstract Vector getAllEmailAliases() throws AdminException;

    public abstract Vector getAllEmailAliases(ListProperties var1) throws AdminException;

    public abstract Vector getAllGroups() throws AdminException;

    public abstract Vector getAllGroups(ListProperties var1) throws AdminException;

    public abstract Vector getAllRights() throws AdminException;

    public abstract Vector getAllRoles() throws AdminException;

    public abstract Vector getAllRoles(ListProperties var1) throws AdminException;

    public abstract Vector getAllTemplates() throws AdminException;

    public abstract Vector getAllUsers() throws AdminException;

    public abstract Vector getAllUsers(ListProperties var1) throws AdminException;

    public AuditUserObj getAuditUser(String string) throws AdminException {
        AuditUserObj auditUserObj = null;
        if (this.tsolService == null) {
            throw new AdminException("EXM_TSOL_GET_AUDIT_ERROR");
        }
        try {
            auditUserObj = this.tsolService.readAuditUser(string);
        }
        catch (Exception exception) {
            throw new AdminException("EXM_TSOL_GET_AUDIT_ERROR");
        }
        return auditUserObj;
    }

    public abstract AuthAttrObj[] getAuthAttrList() throws AdminException;

    public abstract EmailAliasObj getEmailAliasAttributes(EmailAliasObj var1) throws AdminException;

    public abstract String[] getExecutables(String var1) throws AdminException;

    public abstract UserObj getFullAttributes(UserObj var1) throws AdminException;

    public abstract GroupObj getGroupAttributes(GroupObj var1) throws AdminException;

    public abstract String getNextAvailableGID() throws AdminException;

    public abstract String getNextAvailableUID() throws AdminException;

    public abstract ProfAttrObj[] getProfileObjs() throws AdminException;

    public abstract Vector getRightProfs() throws AdminException;

    public abstract TemplateObj getTemplate(String var1) throws AdminException;

    public abstract String[] getUserAuths(String var1) throws AdminException;

    public abstract String[] getUserProfs(String var1) throws AdminException;

    public abstract String[] getUserRoles(String var1) throws AdminException;

    public boolean hasAuditAdminAuth() {
        try {
            if (this.permissionCollection == null) {
                return false;
            }
            VPermission vPermission = new VPermission(USERMGR_AUDIT_ADMIN_RIGHT);
            if (this.permissionCollection.implies((Permission)vPermission)) {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public boolean hasLabelAdminAuth() {
        try {
            if (this.permissionCollection == null) {
                return false;
            }
            VPermission vPermission = new VPermission(USERMGR_LABEL_ADMIN_RIGHT);
            if (this.permissionCollection.implies((Permission)vPermission)) {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public boolean hasProfMgrAssignAuth() {
        try {
            if (this.permissionCollection == null) {
                return false;
            }
            VPermission vPermission = new VPermission(PROF_ASSIGN_RIGHT);
            if (this.permissionCollection.implies((Permission)vPermission)) {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public boolean hasProfMgrDelegateAuth() {
        try {
            if (this.permissionCollection == null) {
                return false;
            }
            VPermission vPermission = new VPermission(PROF_DELEGATE_RIGHT);
            if (this.permissionCollection.implies((Permission)vPermission)) {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public boolean hasProfMgrExecAttrWriteAuth() {
        try {
            if (this.permissionCollection == null) {
                return false;
            }
            VPermission vPermission = new VPermission(PROF_EXECATTR_WRITE_RIGHT);
            if (this.permissionCollection.implies((Permission)vPermission)) {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public boolean hasProfMgrWriteAuth() {
        try {
            if (this.permissionCollection == null) {
                return false;
            }
            VPermission vPermission = new VPermission(PROF_WRITE_RIGHT);
            if (this.permissionCollection.implies((Permission)vPermission)) {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public boolean hasRoleMgrAssignAuth() {
        try {
            if (this.permissionCollection == null) {
                return false;
            }
            VPermission vPermission = new VPermission(ROLE_ASSIGN_RIGHT);
            if (this.permissionCollection.implies((Permission)vPermission)) {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public boolean hasRoleMgrDelegateAuth() {
        try {
            if (this.permissionCollection == null) {
                return false;
            }
            VPermission vPermission = new VPermission(ROLE_DELEGATE_RIGHT);
            if (this.permissionCollection.implies((Permission)vPermission)) {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public boolean hasRoleMgrWriteAuth() {
        try {
            if (this.permissionCollection == null) {
                return false;
            }
            VPermission vPermission = new VPermission(ROLE_WRITE_RIGHT);
            if (this.permissionCollection.implies((Permission)vPermission)) {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public boolean hasUserMgrPasswdAuth() {
        try {
            if (this.permissionCollection == null) {
                return false;
            }
            VPermission vPermission = new VPermission(USERMGR_PASSWD_RIGHT);
            if (this.permissionCollection.implies((Permission)vPermission)) {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public boolean hasUserMgrReadAuth() {
        try {
            if (this.permissionCollection == null) {
                return false;
            }
            VPermission vPermission = new VPermission(USERMGR_READ_RIGHT);
            if (this.permissionCollection.implies((Permission)vPermission)) {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public boolean hasUserMgrWriteAuth() {
        try {
            if (this.permissionCollection == null) {
                return false;
            }
            VPermission vPermission = new VPermission(USERMGR_WRITE_RIGHT);
            if (this.permissionCollection.implies((Permission)vPermission)) {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public void init(Object object, Object object2, AdminMgmtScope adminMgmtScope) throws Exception {
        this.infrastructure = (ToolInfrastructure)object2;
        try {
            Authorization authorization = (Authorization)this.infrastructure.getServiceByName(ServiceList.AUTHORIZATION);
            this.permissionCollection = authorization.readUserPermissions((Principal)this.infrastructure.getIdentity());
            this.tsolService = (TrustedSolarisServiceInterface)this.infrastructure.getServiceByName("com.sun.admin.tsol.server.TrustedSolarisService");
            this.tsolService.initializeScope(adminMgmtScope);
        }
        catch (Exception exception) {}
    }

    public abstract boolean isDemo();

    public abstract EmailAliasObj modifyEmailAlias(EmailAliasObj var1, EmailAliasObj var2) throws AdminException;

    public abstract void modifyExecAttr(ExecAttrObj var1) throws AdminException;

    public abstract GroupObj modifyGroup(GroupObj var1, GroupObj var2) throws AdminException;

    public abstract void modifyRight(RightObj var1) throws AdminException;

    public abstract void modifyRightEntries(RightObj var1) throws AdminException;

    public abstract void modifyTemplate(TemplateObj var1) throws AdminException;

    public abstract UserObj modifyUser(UserObj var1, UserObj var2) throws AdminException;

    public abstract ExecAttrObj readExecAttr(String var1, String var2, String var3, String var4) throws AdminException;

    public abstract ExecAttrObj[] readExecAttrs(String var1, String var2, String var3) throws AdminException;

    public abstract RightObj readRight(String var1) throws AdminException;

    public abstract UserObj setUpPassword(String var1, UserObj var2);

    public void writeAuditUser(AuditUserObj auditUserObj) throws AdminException {
        if (auditUserObj == null) {
            return;
        }
        if (this.tsolService == null) {
            throw new AdminException("EXM_TSOL_WRITE_AUDIT_ERROR");
        }
        try {
            this.tsolService.writeAuditUser(auditUserObj);
        }
        catch (Exception exception) {
            throw new AdminException("EXM_TSOL_WRITE_AUDIT_ERROR");
        }
    }

    public abstract void writeLogRecord(String var1, String var2, String var3, String var4, String var5, int var6, int var7, boolean var8, String var9) throws AdminException;
}

