/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.hostmgr.client;

import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.hostmgr.client.ApplicationContext;
import com.sun.admin.hostmgr.client.Content;
import com.sun.admin.hostmgr.client.ContentEvent;
import com.sun.admin.hostmgr.client.ContentListener;
import com.sun.admin.hostmgr.client.HostActionsListener;
import com.sun.admin.hostmgr.client.NavigationSelectionListener;
import com.sun.admin.hostmgr.client.NetworkContent;
import com.sun.admin.hostmgr.client.TreeNodeData;
import com.sun.admin.hostmgr.client.VHostMgr;
import com.sun.management.viper.console.VConsoleProperties;
import com.sun.management.viper.console.VScopeNode;
import com.sun.management.viper.util.ResourceManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolBar;
import javax.swing.border.Border;

public class MainToolBar
extends JToolBar {
    private ToolBarButton tbNewHost;
    private ToolBarButton tbNewNetwork;
    private ToolBarButton tbNewSubnetwork;
    private ContentListener contentListener;
    private Content content;
    private int newButtonPosition;
    private VHostMgr theApp;
    private final int groupGap = 9;
    HostActionsListener buttonClickListener;

    public MainToolBar(VHostMgr vHostMgr) {
        this.theApp = vHostMgr;
        this.buttonClickListener = new HostActionsListener(vHostMgr);
        ((Container)this).setLayout(new GridBagLayout());
        this.tbNewHost = new ToolBarButton("TBNewHost", "toolbar_add_host_enabled", "New");
        Constraints.constrain((Container)this, (Component)this.tbNewHost, (int)-1, (int)0, (int)1, (int)1, (int)0, (int)5, (int)0, (int)0);
        this.newButtonPosition = 0;
        this.tbNewNetwork = new ToolBarButton("TBNewNetwork", "toolbar_add_network_enabled", "New");
        this.tbNewSubnetwork = new ToolBarButton("TBNewSubnetwork", "toolbar_add_subnetwork_enabled", "New");
        Constraints.constrain((Container)this, (Component)new Box.Filler(new Dimension(9, 1), new Dimension(9, 1), new Dimension(9, 1)), (int)-1, (int)0, (int)1, (int)1);
        Constraints.constrain((Container)this, (Component)new Box.Filler(new Dimension(1, 1), new Dimension(1, 1), new Dimension(1, 1)), (int)-1, (int)0, (int)0, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
        this.contentListener = new ContentListener(){

            public void itemPressed(ContentEvent contentEvent) {
                Content content = contentEvent.getSource();
                MainToolBar.this.notifySelectionChange(content.getNumSelections());
            }
        };
        vHostMgr.addNavigationSelectionListener(new NavigationSelectionListener(){

            public void toolDestroyed() {
            }

            public void toolStopped() {
            }

            public void valueChanged(VScopeNode vScopeNode) {
                if (MainToolBar.this.content != null) {
                    MainToolBar.this.content.removeContentListener(MainToolBar.this.contentListener);
                }
                TreeNodeData treeNodeData = (TreeNodeData)vScopeNode.getPayload();
                MainToolBar.this.content = treeNodeData.getContent();
                MainToolBar.this.content.addContentListener(MainToolBar.this.contentListener);
                MainToolBar.this.configureForContent();
                MainToolBar.this.notifySelectionChange(MainToolBar.this.content.getNumSelections());
            }
        });
    }

    private void configureForContent() {
        VConsoleProperties vConsoleProperties = this.theApp.getProperties();
        ApplicationContext applicationContext = this.theApp.getApplicationContext();
        this.remove(this.newButtonPosition);
        Component component = this.getComponent(this.newButtonPosition);
        component.setCursor(Cursor.getDefaultCursor());
        GridBagConstraints gridBagConstraints = ((GridBagLayout)this.getLayout()).getConstraints(component);
        if (this.content instanceof NetworkContent) {
            ToolBarButton toolBarButton = this.content.whatAmI().equals("networks") ? this.tbNewNetwork : this.tbNewSubnetwork;
            this.add(toolBarButton, gridBagConstraints, 0);
            toolBarButton.setEnabled(applicationContext.isNetworksSupported());
        } else {
            this.add(this.tbNewHost, gridBagConstraints, 0);
        }
        if (!this.theApp.getHostMgr().hasWriteAuthorization()) {
            this.tbNewHost.setEnabled(false);
            this.tbNewNetwork.setEnabled(false);
            vConsoleProperties.setProperty("vconsole.deleteenabled", "false");
        }
    }

    private void notifySelectionChange(int n) {
        VConsoleProperties vConsoleProperties = this.theApp.getProperties();
        if (n == 1) {
            vConsoleProperties.setProperty("vconsole.propertiesenabled", "true");
        } else {
            vConsoleProperties.setProperty("vconsole.propertiesenabled", "false");
        }
        boolean bl = true;
        if (n == 0) {
            bl = false;
        }
        vConsoleProperties.setProperty("vconsole.deleteenabled", bl ? "true" : "false");
        if (!this.theApp.getHostMgr().hasWriteAuthorization()) {
            this.tbNewHost.setEnabled(false);
            this.tbNewNetwork.setEnabled(false);
            vConsoleProperties.setProperty("vconsole.deleteenabled", "false");
        }
    }

    class ToolBarButton
    extends JButton
    implements PropertyChangeListener {
        private ImageIcon enabledIcon;
        private Border defaultBorder;
        private String text;

        public ToolBarButton(String string) {
            this(string, "???", "undefined");
        }

        public ToolBarButton(String string, String string2, String string3) {
            ResourceBundle resourceBundle = MainToolBar.this.theApp.getResourceBundle();
            this.enabledIcon = MainToolBar.this.theApp.loadImageIcon(String.valueOf(string2) + ".gif");
            this.text = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)string);
            if (this.enabledIcon != null && this.enabledIcon.getIconHeight() != -1) {
                this.setIcon(this.enabledIcon);
            } else {
                this.setText(this.text);
            }
            this.setBorderPainted(true);
            this.defaultBorder = this.getBorder();
            this.setFocusPainted(false);
            this.setActionCommand(string3);
            this.setToolTipText(ResourceStrings.getString((ResourceBundle)resourceBundle, (String)(String.valueOf(string) + "Tooltip")));
            this.setMargin(new Insets(0, 0, 0, 0));
            this.setFont(ResourceManager.bodyFont);
            this.addActionListener(MainToolBar.this.buttonClickListener);
            MainToolBar.this.theApp.addPropertyChangeListener(this);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("vconsole.buttondisplay")) {
                VConsoleProperties vConsoleProperties = MainToolBar.this.theApp.getProperties();
                String string2 = vConsoleProperties.getProperty("vconsole.buttondisplay");
                if (string2.equals("vconsole.textonly")) {
                    this.setIcon(null);
                    this.setText(this.text);
                    this.setMargin(new Insets(0, 0, 0, 0));
                } else if (string2.equals("vconsole.icononly")) {
                    this.setIcon(this.enabledIcon);
                    this.setText("");
                    this.setMargin(null);
                } else if (string2.equals("vconsole.textandicon")) {
                    this.setIcon(this.enabledIcon);
                    this.setText(this.text);
                    this.setMargin(new Insets(0, 0, 0, 0));
                }
            }
        }

        public void showAsDepressed() {
            this.setBorder(BorderFactory.createBevelBorder(1));
        }

        public void showAsEnabled() {
            this.setBorder(this.defaultBorder);
            this.setEnabled(true);
        }
    }
}

