/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.server;

import com.sun.management.viper.util.Debug;
import com.sun.management.viper.util.QuotedStringTokenizer;
import com.sun.management.viperimpl.server.ViperServer;
import com.sun.management.viperimpl.util.SectionedProperties;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TimeZone;

public class Registry {
    protected SectionedProperties reg;
    protected SectionedProperties prereg;
    protected Set addedSet;
    protected Set removedSet;
    protected Set updatedSet;
    protected String regPath = String.valueOf(VIPER_RTHOME) + "/properties/registry.properties";
    protected String preregDir = String.valueOf(VIPER_HOME) + "/prereg";
    protected static String STAMP = "timestamp";
    protected static String SUFFIX = ".mcreg";
    protected static String VIPER_HOME = System.getProperty("viper.home");
    protected static String VIPER_RTHOME = System.getProperty("viper.rthome");
    protected String[] envArray;
    protected SimpleDateFormat dateFmt;

    public Registry() {
        this.reg = new SectionedProperties();
        this.prereg = new SectionedProperties();
        this.addedSet = new HashSet();
        this.removedSet = new HashSet();
        this.updatedSet = new HashSet();
        this.dateFmt = new SimpleDateFormat("yyyyMMddHHmmss");
        this.dateFmt.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.envArray = new String[]{"VIPER_HOME=" + VIPER_HOME, "SMC_HOME=" + VIPER_HOME, "SMC_RTHOME=" + VIPER_RTHOME};
    }

    protected void addFragments() {
        Iterator iterator = this.addedSet.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Debug.trace((String)"Registry", (int)Debug.INFORMATION, (String)("Adding fragment " + string + " with: " + this.prereg.getProperty(string, "install")), null);
            String string2 = this.prereg.getProperty(string, "install");
            StringBuffer stringBuffer = new StringBuffer();
            int n = this.runCommand(string2, stringBuffer);
            if (n != 0) {
                Debug.trace((String)"Registry", (int)Debug.WARNING, (String)("Addition failed (" + n + ")" + ": " + stringBuffer), null);
            }
            this.reg.setBlock(string, this.prereg.getBlock(string));
            this.reg.setProperty(string, STAMP, this.dateFmt.format(new Date()));
        }
    }

    public static void doEverything() {
        Registry registry = new Registry();
        try {
            registry.loadPrereg();
        }
        catch (FileNotFoundException fileNotFoundException) {
            return;
        }
        catch (IOException iOException) {
            Debug.trace((String)"Registry", (int)Debug.WARNING, null, (Throwable)iOException);
        }
        try {
            registry.load();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            Debug.trace((String)"Registry", (int)Debug.WARNING, null, (Throwable)iOException);
        }
        registry.update();
        try {
            registry.store();
        }
        catch (Exception exception) {
            Debug.trace((String)"Registry", (int)Debug.WARNING, null, (Throwable)exception);
        }
    }

    public void findNewFragments() {
        Iterator iterator = this.prereg.blockNames();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (this.reg.containsKey(string)) continue;
            this.addedSet.add(string);
        }
    }

    public void findRemovedFragments() {
        Iterator iterator = this.reg.blockNames();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (this.prereg.containsKey(string)) continue;
            this.removedSet.add(string);
        }
    }

    public void findUpdatedFragments() {
        Iterator iterator = this.reg.blockNames();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = this.reg.getProperty(string, STAMP);
            String string3 = this.prereg.getProperty(string, STAMP);
            if (string2 == null) {
                Debug.trace((String)"Registry", (int)Debug.WARNING, (String)("Bad registry block " + string + ": no timestamp"), null);
            }
            try {
                if (Long.parseLong(string2) >= Long.parseLong(string3)) continue;
                this.updatedSet.add(string);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public void load() throws FileNotFoundException, IOException {
        this.reg.load(new FileInputStream(this.regPath));
    }

    public void loadPrereg() throws FileNotFoundException, IOException {
        FilenameFilter filenameFilter = new FilenameFilter(){

            public boolean accept(File file, String string) {
                File file2 = new File(String.valueOf(String.valueOf(file)) + "/" + string);
                return file2.isDirectory();
            }
        };
        FilenameFilter filenameFilter2 = new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.endsWith(SUFFIX);
            }
        };
        File[] fileArray = new File(this.preregDir).listFiles(filenameFilter);
        if (fileArray == null) {
            String string = ViperServer.getMessage("NoPreregDirs", null);
            throw new FileNotFoundException(string);
        }
        int n = 0;
        while (n < fileArray.length) {
            File[] fileArray2 = fileArray[n].listFiles(filenameFilter2);
            int n2 = 0;
            while (n2 < fileArray2.length) {
                this.prereg.load(new FileInputStream(fileArray2[n2]));
                ++n2;
            }
            ++n;
        }
    }

    protected void removeFragments() {
        Iterator iterator = this.removedSet.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Debug.trace((String)"Registry", (int)Debug.INFORMATION, (String)("Removing fragment " + string + " with: " + this.reg.getProperty(string, "remove")), null);
            String string2 = this.reg.getProperty(string, "remove");
            StringBuffer stringBuffer = new StringBuffer();
            int n = this.runCommand(string2, stringBuffer);
            if (n != 0) {
                Debug.trace((String)"Registry", (int)Debug.WARNING, (String)("Removal failed (" + n + ")" + ": " + stringBuffer), null);
            }
            this.reg.remove(string);
        }
    }

    protected int runCommand(String string, StringBuffer stringBuffer) {
        int n;
        while ((n = string.indexOf("$SMC_HOME")) != -1) {
            string = String.valueOf(string.substring(0, n)) + VIPER_HOME + string.substring(n + 9);
        }
        while ((n = string.indexOf("$SMC_RTHOME")) != -1) {
            string = String.valueOf(string.substring(0, n)) + VIPER_RTHOME + string.substring(n + 11);
        }
        String[] stringArray = QuotedStringTokenizer.toArray((String)string);
        Process process = null;
        int n2 = -1;
        try {
            process = Runtime.getRuntime().exec(stringArray, this.envArray);
        }
        catch (IOException iOException) {
            stringBuffer.append(iOException.getMessage());
            return n2;
        }
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuffer.append("\n  " + string2);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            Debug.trace((String)"Registry", (int)Debug.WARNING, (String)"Failed to read from process", (Throwable)iOException);
        }
        boolean bl = false;
        while (!bl) {
            try {
                n2 = process.waitFor();
                bl = true;
            }
            catch (InterruptedException interruptedException) {}
        }
        return n2;
    }

    public void store() throws FileNotFoundException, IOException {
        this.reg.store(new FileOutputStream(this.regPath), null);
    }

    public void update() {
        this.findRemovedFragments();
        this.findNewFragments();
        this.findUpdatedFragments();
        this.removeFragments();
        this.addFragments();
        this.updateFragments();
    }

    protected void updateFragments() {
        Iterator iterator = this.updatedSet.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Debug.trace((String)"Registry", (int)Debug.INFORMATION, (String)("Updating fragment " + string + " with: " + this.prereg.getProperty(string, "install")), null);
            String string2 = this.prereg.getProperty(string, "install");
            StringBuffer stringBuffer = new StringBuffer();
            int n = this.runCommand(string2, stringBuffer);
            if (n != 0) {
                Debug.trace((String)"Registry", (int)Debug.WARNING, (String)("Update failed (" + n + ")" + ": " + stringBuffer), null);
            }
            this.reg.setBlock(string, this.prereg.getBlock(string));
            this.reg.setProperty(string, STAMP, this.dateFmt.format(new Date()));
        }
    }
}

