/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.server.repository;

import com.sun.management.viper.util.Debug;
import com.sun.management.viperimpl.ViperImplVersion;
import com.sun.management.viperimpl.server.repository.Reads;
import com.sun.management.viperimpl.server.repository.VRegistry;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CodebaseServlet
extends HttpServlet {
    private String codebase = null;
    private static Hashtable classList = null;
    protected Properties serverInfo;

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Object object;
        String string = httpServletRequest.getPathInfo();
        if (string == null || string.length() <= 1) {
            this.sendNotFoundError(httpServletResponse, string);
            return;
        }
        string = string.substring(1).trim();
        Debug.trace((String)"Codebase Servlet", (int)Debug.INFORMATION, (String)("Codebase Servlet: request: " + string), null);
        if (string.indexOf("..") >= 0) {
            this.sendNotFoundError(httpServletResponse, string);
            return;
        }
        if (string.endsWith("/")) {
            if (string.startsWith("info/")) {
                try {
                    object = new ObjectOutputStream((OutputStream)httpServletResponse.getOutputStream());
                    ((ObjectOutputStream)object).writeObject(this.serverInfo);
                    ((ObjectOutputStream)object).close();
                }
                catch (IOException iOException) {
                    this.sendNotFoundError(httpServletResponse, string);
                    return;
                }
            } else {
                this.sendNotFoundError(httpServletResponse, string);
                return;
            }
        }
        object = String.valueOf(this.codebase) + string;
        byte[] byArray = this.getBitsFromFile(String.valueOf(this.codebase) + string);
        if (byArray == null) {
            if (classList == null) {
                CodebaseServlet.reloadClassList();
            }
            if ((object = (String)classList.get(string)) == null) {
                this.sendNotFoundError(httpServletResponse, string);
                return;
            }
            if (((String)object).endsWith(".jar") || ((String)object).endsWith(".zip")) {
                byArray = this.getBitsFromJar((String)object, string);
            } else if (((String)object).endsWith(".class")) {
                byArray = this.getBitsFromFile((String)object);
            }
        }
        if (byArray != null) {
            long l = new File((String)object).lastModified();
            httpServletResponse.setDateHeader("Last-Modified", l);
            httpServletResponse.setContentType(this.getContentType(string));
            httpServletResponse.setContentLength(byArray.length);
            ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
            servletOutputStream.write(byArray);
            servletOutputStream.close();
            Debug.trace((String)"Codebase Servlet", (int)Debug.INFORMATION, (String)("Servlet loaded: " + string), null);
        } else {
            this.sendNotFoundError(httpServletResponse, string);
        }
    }

    private byte[] getBitsFromFile(String string) {
        byte[] byArray = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            byArray = new byte[fileInputStream.available()];
            fileInputStream.read(byArray);
            fileInputStream.close();
        }
        catch (IOException iOException) {
            Debug.trace((String)"Codebase Servlet", (int)Debug.WARNING, (String)("Codebase Servlet direct loading:" + iOException.getMessage()), (Throwable)iOException);
        }
        return byArray;
    }

    private byte[] getBitsFromJar(String string, String string2) {
        byte[] byArray = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            ZipInputStream zipInputStream = new ZipInputStream(fileInputStream);
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                if (zipEntry.getName().equals(string2)) {
                    byArray = Reads.read(zipInputStream);
                    zipInputStream.closeEntry();
                    break;
                }
                zipInputStream.closeEntry();
                zipEntry = zipInputStream.getNextEntry();
            }
            zipInputStream.close();
            fileInputStream.close();
        }
        catch (IOException iOException) {
            Debug.trace((String)"Codebase Servlet", (int)Debug.WARNING, (String)("VCodebase Servlet: " + iOException.getMessage()), (Throwable)iOException);
        }
        return byArray;
    }

    private String getContentType(String string) {
        String string2 = string.toLowerCase();
        String string3 = "text/plain";
        if (string2.endsWith(".class") || string2.endsWith(".ser")) {
            string3 = "application/java";
        } else if (string2.endsWith(".gif")) {
            string3 = "image/gif";
        } else if (string2.endsWith(".jpg") || string2.endsWith(".jpeg")) {
            string3 = "image/jpeg";
        } else if (string2.endsWith(".html") || string2.endsWith(".htm")) {
            string3 = "text/html";
        } else if (string2.endsWith(".jar")) {
            string3 = "application/java-archive";
        } else if (string2.endsWith(".js")) {
            string3 = "application/x-javascript";
        }
        return string3;
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.codebase = VRegistry.getCodebase();
        Properties properties = System.getProperties();
        this.serverInfo = new Properties();
        this.serverInfo.setProperty("viper.api.version", "1.0");
        this.serverInfo.setProperty("viper.impl.version", ViperImplVersion.getVersion());
        this.serverInfo.setProperty("viper.impl.fullversion", ViperImplVersion.getFullVersion());
        this.serverInfo.setProperty("os.name", properties.getProperty("os.name"));
        this.serverInfo.setProperty("os.arch", properties.getProperty("os.arch"));
        this.serverInfo.setProperty("os.version", properties.getProperty("os.version"));
        this.serverInfo.setProperty("rolesupport", "true");
    }

    public void log(String string) {
    }

    public void log(String string, Throwable throwable) {
    }

    protected static void reloadClassList() {
        classList = VRegistry.getClassList();
    }

    private void sendNotFoundError(HttpServletResponse httpServletResponse, String string) throws IOException {
        httpServletResponse.sendError(404, "File " + string + " is NOT found in Viper codebase.");
    }
}

