/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.server.repository;

import com.sun.management.viper.BeanNotFoundException;
import com.sun.management.viper.CriticalStopException;
import com.sun.management.viper.Service;
import com.sun.management.viper.ServiceInfrastructure;
import com.sun.management.viper.VException;
import com.sun.management.viper.util.Debug;
import com.sun.management.viperimpl.ContainerContext;
import com.sun.management.viperimpl.ExternalClientProviderInfoImpl;
import com.sun.management.viperimpl.LibInfoImpl;
import com.sun.management.viperimpl.ServiceAgent;
import com.sun.management.viperimpl.ServiceContainer;
import com.sun.management.viperimpl.ServiceContextImpl;
import com.sun.management.viperimpl.ServiceInfoImpl;
import com.sun.management.viperimpl.ToolInfoImpl;
import com.sun.management.viperimpl.VCallerImpl;
import com.sun.management.viperimpl.server.ViperServer;
import com.sun.management.viperimpl.server.repository.ObjectFactory;
import com.sun.management.viperimpl.server.repository.RepositoryException;
import com.sun.management.viperimpl.server.repository.ServiceInstance;
import com.sun.management.viperimpl.server.repository.VRegistry;
import java.rmi.RemoteException;
import java.security.SecureRandom;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;

public class RepositoryService {
    private static final String REPOSITORY_RESOURCE = "com.sun.management.viperimpl.server.repository.RepositoryServiceResources";
    private static ResourceBundle resource = null;
    private static ServiceInfoImpl[] slist;
    private static ExternalClientProviderInfoImpl[] xcplist;
    private static Hashtable servicelist;
    private static Hashtable toollist;
    private static Properties allProperties;
    private static Properties allServiceProperties;
    private static Properties allToolProperties;
    private Hashtable activeServices = new Hashtable();
    private Hashtable cidTable = new Hashtable();
    private SecureRandom random = ViperServer.getRandom();
    private ObjectFactory factory = null;
    private ServiceInfrastructure infra = null;
    private ContainerContext cContext = null;
    private Date lastReloadTime = null;
    private String msg = null;
    private transient Service directService = null;
    private transient Hashtable directHandles = new Hashtable();

    static {
        servicelist = new Hashtable();
        toollist = new Hashtable();
    }

    public RepositoryService(String[] stringArray, ServiceInfrastructure serviceInfrastructure, ContainerContext containerContext) throws RepositoryException, CriticalStopException, BeanNotFoundException {
        try {
            resource = ResourceBundle.getBundle(REPOSITORY_RESOURCE);
        }
        catch (MissingResourceException missingResourceException) {
            System.err.println("Can't load repository resource.");
        }
        this.factory = new ObjectFactory();
        this.infra = serviceInfrastructure;
        this.cContext = containerContext;
        slist = VRegistry.readServices();
        int n = 0;
        while (n < slist.length) {
            servicelist.put(slist[n].getClassName(), slist[n]);
            ++n;
        }
        ToolInfoImpl[] toolInfoImplArray = VRegistry.readTools();
        int n2 = 0;
        while (n2 < toolInfoImplArray.length) {
            toollist.put(toolInfoImplArray[n2].getClassName(), toolInfoImplArray[n2]);
            ++n2;
        }
        xcplist = VRegistry.readXCProviders();
        LibInfoImpl[] libInfoImplArray = VRegistry.readAllLibJars();
        if (libInfoImplArray != null) {
            Vector<String> vector = new Vector<String>();
            int n3 = 0;
            while (n3 < libInfoImplArray.length) {
                if (!libInfoImplArray[n3].getJarName().startsWith("tools/ALLTOOL@")) {
                    vector.addElement(libInfoImplArray[n3].getJarPath());
                }
                ++n3;
            }
            String[] stringArray2 = vector.toArray(new String[0]);
            this.factory.setClassPath("ALL", stringArray2);
        }
        allProperties = VRegistry.readAllProperties();
        allToolProperties = VRegistry.readAllToolProperties();
        allServiceProperties = VRegistry.readAllServiceProperties();
        this.lastReloadTime = new Date();
        int n4 = 0;
        while (n4 < stringArray.length) {
            Object object = null;
            try {
                object = this.createDirectHandle(stringArray[n4], serviceInfrastructure);
            }
            catch (CriticalStopException criticalStopException) {
                throw criticalStopException;
            }
            catch (Throwable throwable) {
                System.err.println("RepositoryService : createDirectHandle FAILEd" + throwable);
            }
            this.directHandles.put(stringArray[n4], object);
            ++n4;
        }
        this.loadDaemons(serviceInfrastructure, slist);
    }

    private Object createDirectHandle(String string, ServiceInfrastructure serviceInfrastructure) throws RepositoryException, CriticalStopException, BeanNotFoundException {
        block2: {
            this.directService = null;
            try {
                this.getServiceAgent(string, null, null);
            }
            catch (Throwable throwable) {
                if (!(throwable instanceof CriticalStopException)) break block2;
                throw (CriticalStopException)throwable;
            }
        }
        return this.directService;
    }

    public ServiceInfoImpl[] findServiceInfo(String string) {
        if (string == null) {
            return null;
        }
        Vector<ServiceInfoImpl> vector = new Vector<ServiceInfoImpl>();
        int n = slist.length - 1;
        while (n >= 0) {
            if (slist[n].getClassName().equals(string)) {
                vector.add(slist[n]);
            } else {
                String[] stringArray = slist[n].getInterfaces();
                int n2 = 0;
                while (n2 < stringArray.length) {
                    if (stringArray[n2].equals(string)) {
                        vector.add(slist[n]);
                        break;
                    }
                    ++n2;
                }
            }
            --n;
        }
        if (vector.size() > 0) {
            return vector.toArray(new ServiceInfoImpl[0]);
        }
        return null;
    }

    public Object getCoreService(String string) {
        return this.directHandles.get(string);
    }

    public ExternalClientProviderInfoImpl[] getExternalClientProviderInfo(String string) throws BeanNotFoundException {
        if (string == null) {
            throw new BeanNotFoundException("XCProviderNotFound", (Object)"null");
        }
        Vector<ExternalClientProviderInfoImpl> vector = new Vector<ExternalClientProviderInfoImpl>();
        if (xcplist != null) {
            int n = xcplist.length - 1;
            while (n >= 0) {
                String[] stringArray = xcplist[n].getClientTypes();
                if (stringArray != null) {
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        if (stringArray[n2].equals(string)) {
                            vector.add(xcplist[n]);
                            break;
                        }
                        ++n2;
                    }
                }
                --n;
            }
        }
        if (vector.size() > 0) {
            return vector.toArray(new ExternalClientProviderInfoImpl[0]);
        }
        throw new BeanNotFoundException("XCProviderNotFound", (Object)string);
    }

    public String getMessage(String string, String string2) {
        if (string2 != null) {
            Object[] objectArray = new Object[]{string2};
            return this.getMessage(string, objectArray);
        }
        return this.getMessage(string, (Object[])null);
    }

    public String getMessage(String string, Object[] objectArray) {
        String string2;
        block3: {
            if (string == null) {
                return null;
            }
            string2 = resource == null ? string : resource.getString(string);
            if (objectArray == null || objectArray.length <= 0) break block3;
            try {
                string2 = MessageFormat.format(string2, objectArray);
            }
            catch (Exception exception) {}
        }
        return string2;
    }

    public ServiceAgent getServiceAgent(String string, VCallerImpl vCallerImpl, Vector vector) throws BeanNotFoundException, CriticalStopException {
        Object object;
        Cloneable cloneable;
        ServiceInfoImpl[] serviceInfoImplArray = this.findServiceInfo(string);
        if (serviceInfoImplArray == null) {
            throw new BeanNotFoundException("ServiceNotFound", (Object)string);
        }
        String string2 = "";
        String string3 = null;
        ServiceInstance serviceInstance = null;
        int n = 0;
        while (n < serviceInfoImplArray.length) {
            Object object2;
            cloneable = serviceInfoImplArray[n];
            string3 = ((ServiceInfoImpl)cloneable).getClassName();
            if (((ServiceInfoImpl)cloneable).isSingleton() && (object = (Vector)this.activeServices.get(string3)) != null && ((Vector)object).size() > 0) {
                object2 = (ServiceInstance)((Vector)object).elementAt(0);
                this.directService = null;
                return ((ServiceInstance)object2).newAgent(vCallerImpl);
            }
            object = ((ServiceInfoImpl)cloneable).getLoadDependencies();
            if (object != null && ((String[])object).length > 0) {
                int n2 = 0;
                while (n2 < ((Object)object).length) {
                    if (vector == null) {
                        vector = new Vector<String>();
                    }
                    if (vector.contains(string3)) {
                        throw new CriticalStopException("DependencyDeadlock", (Object)string);
                    }
                    vector.addElement(string3);
                    this.getServiceAgent((String)object[n2], vCallerImpl, vector);
                    ++n2;
                }
            }
            object2 = this.factory.createCAPair(string3, ((ServiceInfoImpl)cloneable).getJarPaths());
            try {
                if (object2[0] == null || object2[1] == null) {
                    throw new CriticalStopException("ContainerAgentNotFound", (Object)string);
                }
                ServiceContainer serviceContainer = (ServiceContainer)((Object)object2[0]);
                ServiceAgent serviceAgent = (ServiceAgent)object2[1];
                serviceContainer.setContext(this.cContext);
                ServiceContextImpl serviceContextImpl = new ServiceContextImpl(null, ((LibInfoImpl)cloneable).getProperties());
                this.directService = serviceContainer.create(this.infra, serviceContextImpl);
                serviceInstance = new ServiceInstance(serviceContainer, serviceAgent, vCallerImpl);
                break;
            }
            catch (Throwable throwable) {
                string2 = String.valueOf(string2) + "\n" + ((ServiceInfoImpl)cloneable).getClassName() + ": " + throwable.getLocalizedMessage();
                ++n;
            }
        }
        if (serviceInstance == null) {
            throw new CriticalStopException("ServiceInternalError", (Object)string2);
        }
        cloneable = (Vector)this.activeServices.get(string3);
        if (cloneable == null) {
            cloneable = new Vector(1);
            ((Vector)cloneable).addElement(serviceInstance);
            this.activeServices.put(string3, cloneable);
        } else {
            ((Vector)cloneable).addElement(serviceInstance);
        }
        object = serviceInstance.newAgent(vCallerImpl);
        return object;
    }

    public ServiceInfoImpl[] getServiceInfo(String string) throws BeanNotFoundException {
        ServiceInfoImpl[] serviceInfoImplArray = this.findServiceInfo(string);
        if (serviceInfoImplArray == null) {
            throw new BeanNotFoundException("ServiceNotFound", (Object)string);
        }
        int n = 0;
        while (n < serviceInfoImplArray.length) {
            String string2;
            ServiceInfoImpl serviceInfoImpl = (ServiceInfoImpl)serviceInfoImplArray[n].clone();
            Properties properties = new Properties(allProperties);
            Enumeration<?> enumeration = allServiceProperties.propertyNames();
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                properties.setProperty(string2, allServiceProperties.getProperty(string2));
            }
            Properties properties2 = serviceInfoImpl.getProperties();
            Enumeration<?> enumeration2 = properties2.propertyNames();
            while (enumeration2.hasMoreElements()) {
                string2 = (String)enumeration2.nextElement();
                properties.setProperty(string2, properties2.getProperty(string2));
            }
            serviceInfoImpl.setProperties(properties);
            serviceInfoImplArray[n] = serviceInfoImpl;
            ++n;
        }
        return serviceInfoImplArray;
    }

    public Vector getServiceInfoList() {
        Vector<ServiceInfoImpl> vector = new Vector<ServiceInfoImpl>(20, 10);
        int n = 0;
        while (n < slist.length) {
            String string = slist[n].getClassName();
            try {
                vector.addElement(this.getServiceInfo(string)[0]);
            }
            catch (BeanNotFoundException beanNotFoundException) {}
            ++n;
        }
        return vector;
    }

    public ToolInfoImpl getToolInfo(String string) throws BeanNotFoundException {
        String string2;
        if (string == null) {
            throw new BeanNotFoundException("ToolNotFound", (Object)string);
        }
        ToolInfoImpl toolInfoImpl = (ToolInfoImpl)toollist.get(string);
        if (toolInfoImpl == null) {
            throw new BeanNotFoundException("ToolNotFound", (Object)string);
        }
        ToolInfoImpl toolInfoImpl2 = (ToolInfoImpl)toolInfoImpl.clone();
        Properties properties = new Properties(allProperties);
        Enumeration<?> enumeration = allToolProperties.propertyNames();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            properties.setProperty(string2, allToolProperties.getProperty(string2));
        }
        Properties properties2 = toolInfoImpl2.getProperties();
        Enumeration<?> enumeration2 = properties2.propertyNames();
        while (enumeration2.hasMoreElements()) {
            string2 = (String)enumeration2.nextElement();
            properties.setProperty(string2, properties2.getProperty(string2));
        }
        toolInfoImpl2.setProperties(properties);
        return toolInfoImpl2;
    }

    public Vector getToolInfoList() {
        Vector<ToolInfoImpl> vector = new Vector<ToolInfoImpl>(20, 10);
        Enumeration enumeration = toollist.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            try {
                vector.addElement(this.getToolInfo(string));
            }
            catch (BeanNotFoundException beanNotFoundException) {}
        }
        return vector;
    }

    public String getToolJarName(String string) throws BeanNotFoundException {
        ToolInfoImpl toolInfoImpl = (ToolInfoImpl)toollist.get(string);
        if (toolInfoImpl == null) {
            throw new BeanNotFoundException("ToolNotFound", (Object)string);
        }
        return toolInfoImpl.getJarName();
    }

    private void loadDaemons(ServiceInfrastructure serviceInfrastructure, ServiceInfoImpl[] serviceInfoImplArray) {
        int n = 0;
        while (n < serviceInfoImplArray.length) {
            if (serviceInfoImplArray[n].isDaemon()) {
                try {
                    this.getServiceAgent(serviceInfoImplArray[n].getClassName(), null, null);
                }
                catch (VException vException) {
                    Debug.trace((String)"Repository Service", (int)Debug.ERROR, (String)("Load daemon " + serviceInfoImplArray[n].getClassName() + " error"), (Throwable)vException);
                }
            }
            ++n;
        }
    }

    public void register(byte[] byArray) throws RemoteException, RepositoryException {
    }

    public void unload() {
        Enumeration enumeration = this.activeServices.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            ServiceInfoImpl serviceInfoImpl = (ServiceInfoImpl)servicelist.get(string);
            Vector vector = (Vector)this.activeServices.remove(string);
            if (vector == null) continue;
            int n = 0;
            while (n < vector.size()) {
                ServiceInstance serviceInstance = (ServiceInstance)vector.elementAt(n);
                ServiceContainer serviceContainer = serviceInstance.getContainer();
                try {
                    serviceContainer.stop();
                    serviceContainer.destroy();
                }
                catch (Exception exception) {
                    Debug.trace((String)"Repository Service", (int)Debug.ERROR, (String)"upload services error", (Throwable)exception);
                }
                ++n;
            }
        }
    }

    public void unregister(String string) throws RemoteException, RepositoryException {
    }
}

