/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.server.repository;

import com.sun.management.viper.util.Debug;
import com.sun.management.viperimpl.console.config.ConfigManagement;
import com.sun.management.viperimpl.console.config.ConfigurationException;
import com.sun.management.viperimpl.console.config.VConfigurationInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ToolBoxServlet
extends HttpServlet {
    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getPathInfo();
        if (string != null && string.startsWith("/")) {
            string = string.substring(1).trim();
        }
        Debug.trace((String)"Toolbox Servlet", (int)Debug.INFORMATION, (String)("Request: " + string), null);
        if (string.indexOf("..") >= 0) {
            this.sendNotFoundError(httpServletResponse, string);
            return;
        }
        Locale locale = this.parseLocale(httpServletRequest.getHeader("Locale"));
        if (string.equals("")) {
            this.listConfigs(httpServletResponse, locale);
        } else if (string.endsWith(".tbx")) {
            this.readToolbox(httpServletResponse, string, locale);
        } else if (string.endsWith(".gif")) {
            this.readImage(httpServletResponse, string);
        } else {
            this.readFile(httpServletResponse, string);
        }
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
    }

    protected void listConfigs(HttpServletResponse httpServletResponse, Locale locale) {
        try {
            VConfigurationInfo[] vConfigurationInfoArray = ConfigManagement.list(locale, true);
            ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)servletOutputStream);
            objectOutputStream.writeObject(vConfigurationInfoArray);
            objectOutputStream.close();
        }
        catch (ConfigurationException configurationException) {
            String string = "Could not process toolbox list request: " + configurationException.getMessage();
            this.sendInternalError(httpServletResponse, string);
        }
        catch (IOException iOException) {
            this.sendInternalError(httpServletResponse, iOException.getMessage());
        }
    }

    public void log(String string) {
    }

    public void log(String string, Throwable throwable) {
    }

    protected Locale parseLocale(String string) {
        if (string == null) {
            return null;
        }
        String string2 = "";
        String string3 = "";
        String string4 = "";
        int n = string.indexOf(95);
        if (n > 0) {
            string2 = string.substring(0, n);
            if ((n = (string = string.substring(n + 1)).indexOf(95)) > 0) {
                string3 = string.substring(0, n);
                string4 = string.substring(n + 1);
            } else {
                string3 = string;
            }
        } else {
            string2 = string;
        }
        return new Locale(string2, string3, string4);
    }

    protected void readFile(HttpServletResponse httpServletResponse, String string) {
        byte[] byArray = null;
        string = ConfigManagement.getFilePath(string);
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            byArray = new byte[fileInputStream.available()];
            fileInputStream.read(byArray);
            fileInputStream.close();
            long l = new File(string).lastModified();
            httpServletResponse.setDateHeader("Last-Modified", l);
            httpServletResponse.setContentType("text/plain");
            httpServletResponse.setContentLength(byArray.length);
            ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
            servletOutputStream.write(byArray);
            servletOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.sendNotFoundError(httpServletResponse, string);
        }
        catch (IOException iOException) {
            this.sendInternalError(httpServletResponse, iOException.getMessage());
        }
    }

    protected void readImage(HttpServletResponse httpServletResponse, String string) {
        byte[] byArray = null;
        string = ConfigManagement.getFilePath(string);
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            byArray = new byte[fileInputStream.available()];
            fileInputStream.read(byArray);
            fileInputStream.close();
            long l = new File(string).lastModified();
            httpServletResponse.setDateHeader("Last-Modified", l);
            httpServletResponse.setContentType("image/gif");
            ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
            servletOutputStream.write(byArray);
            servletOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.sendNotFoundError(httpServletResponse, string);
        }
        catch (IOException iOException) {
            this.sendInternalError(httpServletResponse, iOException.getMessage());
        }
    }

    protected void readToolbox(HttpServletResponse httpServletResponse, String string, Locale locale) {
        byte[] byArray = null;
        string = ConfigManagement.aliasifyPath(string);
        string = string.substring(0, string.lastIndexOf(".tbx"));
        String string2 = ConfigManagement.getConfigPath(string, locale);
        try {
            FileInputStream fileInputStream = new FileInputStream(string2);
            byArray = new byte[fileInputStream.available()];
            fileInputStream.read(byArray);
            fileInputStream.close();
            long l = new File(string2).lastModified();
            httpServletResponse.setDateHeader("Last-Modified", l);
            httpServletResponse.setContentType("text/plain");
            ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
            servletOutputStream.write(byArray);
            servletOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.sendNotFoundError(httpServletResponse, string);
        }
        catch (IOException iOException) {
            this.sendInternalError(httpServletResponse, iOException.getMessage());
        }
    }

    private void sendInternalError(HttpServletResponse httpServletResponse, String string) {
        if (string == null) {
            string = new String("Toolbox servlet internal error");
        }
        int n = 500;
        try {
            httpServletResponse.sendError(n, string);
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }

    private void sendNotFoundError(HttpServletResponse httpServletResponse, String string) {
        int n = 404;
        try {
            httpServletResponse.sendError(n, "Toolbox " + string + " not found.");
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }
}

