/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.usermgr.cli;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.AdminSecurityUtil;
import com.sun.admin.cis.common.CheckSyntax;
import com.sun.admin.cis.common.CommandLineOption;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.tsol.common.BadLabelException;
import com.sun.admin.tsol.common.TrustedSolarisDefaults;
import com.sun.admin.tsol.server.TrustedSolarisServiceInterface;
import com.sun.admin.usermgr.cli.UMgrCliTool;
import com.sun.admin.usermgr.client.FileParser;
import com.sun.admin.usermgr.client.users.MultiUserXferObj;
import com.sun.admin.usermgr.common.EmailAliasObj;
import com.sun.admin.usermgr.common.Permissions;
import com.sun.admin.usermgr.common.SolAccountAttr;
import com.sun.admin.usermgr.common.SolGroupAttr;
import com.sun.admin.usermgr.common.SolHomedirAttr;
import com.sun.admin.usermgr.common.SolPasswordAttr;
import com.sun.admin.usermgr.common.SolServerPartialSuccessException;
import com.sun.admin.usermgr.common.SolServicesAttr;
import com.sun.admin.usermgr.common.UserAttrObj;
import com.sun.admin.usermgr.common.UserException;
import com.sun.admin.usermgr.common.UserMgrCliArgParsingException;
import com.sun.admin.usermgr.common.UserMgrCliHelpException;
import com.sun.admin.usermgr.common.UserMgrIDAlreadyInUseException;
import com.sun.admin.usermgr.common.UserMgrNameAlreadyInUseException;
import com.sun.admin.usermgr.common.UserObj;
import com.sun.management.viper.ToolInfrastructure;
import com.sun.management.viper.util.CommandOption;
import com.sun.management.viper.util.CommandParser;
import com.sun.management.viper.util.ResourceManager;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;

public class BaseUserMgrCli
extends UMgrCliTool {
    private String strOldName = null;
    private String defaultTemplate = null;
    private boolean bLongList = false;
    private boolean bUsingFileInput = false;
    private boolean bUsingPipesOrFiles = false;
    private boolean bListAll = false;
    private Vector vXArgs = new Vector();
    private UserObj defaultObjSettings = new UserObj();
    private String UserOrRoleID = "normal";
    private boolean bIsMultiUserTypeARole = false;
    static CommandLineOption coUsername;
    static CommandLineOption coUid;
    static CommandLineOption coComment;
    static CommandLineOption coDir;
    static CommandLineOption coExpire;
    static CommandLineOption coInactive;
    static CommandLineOption coGid;
    static CommandLineOption coGroupNames;
    static CommandLineOption coShell;
    static CommandLineOption coNewLogin;
    static CommandLineOption coTemplate;
    static CommandLineOption coXArgs;
    static CommandLineOption coLongList;
    static CommandLineOption coLogFile;
    static CommandLineOption coInputFile;
    static CommandLineOption coTaskFile;
    static CommandLineOption coHelp;
    static CommandLineOption coFullName;
    static CommandLineOption coPassword;
    static CommandLineOption coDelRole;
    static CommandLineOption coAddRole;
    static CommandLineOption coDelProf;
    static CommandLineOption coAddProf;
    private InputStream input;
    private PrintStream output;
    static CommandLineOption coInputFileType;
    static CommandLineOption coDebug;
    ResourceBundle bundle = null;
    private TrustedSolarisServiceInterface tsService = null;
    private TrustedSolarisDefaults tsolDefaults = null;
    private String userName = null;
    private static final String TSOL_ROLE_SKEL_PATH = "/etc/skel/tsol";

    public BaseUserMgrCli() {
    }

    public BaseUserMgrCli(String string, String string2) {
        this.trace("made it into BaseUserMgrCli constructor.");
        this.UserOrRoleID = string2;
        try {
            this.bundle = ResourceManager.getBundle((String)string, this.getClass());
            this.setResourceBundle(this.bundle);
        }
        catch (Exception exception) {
            this.trace("1st attempt to get resourceBundle failed");
            exception.printStackTrace();
            this.bundle = null;
        }
        if (this.bundle == null) {
            this.bundle = ResourceBundle.getBundle(string, Locale.getDefault(), this.getClass().getClassLoader());
            this.setResourceBundle(this.bundle);
        }
        if (this.bundle == null) {
            this.giveNoBundleMessage();
            System.exit(2);
        }
    }

    private String[] VectorToStrArray(Vector vector) {
        int n = vector.size();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = (String)vector.elementAt(n2);
            ++n2;
        }
        return stringArray;
    }

    public void addMultiObjects() throws UserException {
        try {
            this.trace("addMultiObjects->SIMULATED RUNNING:");
            String string = ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"START_MULTIADD_LOG");
            this.cascade_logging(string);
            string = ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"START_DETAILS");
            this.cascade_logging(string);
            this.writeLoggingDate();
            MultiUserXferObj multiUserXferObj = this.getMuxoBasedOnInput();
            this.doMultiUserAdd(multiUserXferObj);
            try {
                File file = new File(this.getInputDataFile());
                file.delete();
            }
            catch (Exception exception) {}
            this.writeLoggingDate();
            string = ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"END_MULTIADD_LOG");
            this.cascade_logging(string);
        }
        catch (Exception exception) {
            this.trace("exception in addMultiObjects(): " + exception.getMessage());
            this.printDebugStack(exception);
            throw new UserException("EXM_AMU1");
        }
    }

    public void addObject() throws Exception {
        try {
            Vector vector = this.getUserObjs();
            UserObj userObj = (UserObj)vector.elementAt(0);
            if (this.getUserMgr() == null) {
                this.trace("in addObject:  usermgr is null!");
                throw new UserException("EXM_CLI_NO_SERVICE");
            }
            if (this.getDebugStatus()) {
                this.dumpObjectContents(userObj);
            }
            userObj = this.setPassAttr(userObj, this.getDefaultUserData());
            userObj = this.setGroupAttr(userObj, this.getDefaultUserData());
            userObj = this.setServiceAttr(userObj, this.getDefaultUserData());
            userObj = this.setAccountAttr(userObj, this.getDefaultUserData());
            userObj = this.setHomeDirAttr(userObj, this.getDefaultUserData());
            if (this.getDebugStatus()) {
                this.dumpObjectContents(userObj);
            }
            this.trace("adding user/role:  " + userObj.getUserName());
            this.getUserMgr().addUser(userObj);
            this.createMailAliasForRole(userObj);
        }
        catch (SolServerPartialSuccessException solServerPartialSuccessException) {
            throw new UserException("EXM_CLI_PARTIAL_ADD", solServerPartialSuccessException.getLocalizedMessage());
        }
        catch (Exception exception) {
            this.trace("exception in addObject(): " + exception.getMessage());
            this.printDebugStack(exception);
            throw exception;
        }
    }

    private void checkFailedAddForProblem(Vector vector, UserObj userObj, Exception exception) throws Exception {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            UserObj userObj2 = (UserObj)enumeration.nextElement();
            if (userObj2 == null || userObj == null) {
                this.trace("shouldn't get null user in checkFailedAddForProblem()");
                throw exception;
            }
            if (this.getDebugStatus()) {
                this.trace("-->userobj.name = " + userObj2.getUserName() + " uid = " + userObj2.getUserID());
                this.trace("-->uobj.name = " + userObj.getUserName() + " uid = " + userObj.getUserID());
            }
            if (userObj2.getUserID().equals(userObj.getUserID())) {
                throw new UserMgrIDAlreadyInUseException("DUMMY_KEY");
            }
            if (!userObj2.getUserName().equals(userObj.getUserName())) continue;
            throw new UserMgrNameAlreadyInUseException("DUMMY_KEY");
        }
        throw exception;
    }

    public void checkForAddOptions(String[] stringArray, String string, String string2) throws Exception {
        Object object;
        Vector vector;
        Cloneable cloneable;
        Object object2;
        boolean bl = false;
        UserObj userObj = new UserObj();
        ResourceBundle resourceBundle = this.getResourceBundle();
        this.trace("enterred checkForAddOptions");
        userObj = this.setDefaultData();
        CommandParser commandParser = new CommandParser(string, string2, true, null, null);
        String string3 = this.UserOrRoleID.equals("role") ? ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"arg_XARGADDROLE_desc") : ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"arg_XARGADDUSER_desc");
        coXArgs = new CommandLineOption("xArgs", string3, "x", 1, true, true, null, false, false);
        try {
            if (this.UserOrRoleID.equals("role")) {
                commandParser.addOption((CommandOption)coAddRole);
                commandParser.addOption((CommandOption)coAddProf);
                userObj = this.setPrimaryGroup(userObj, "14");
            } else {
                commandParser.addOption((CommandOption)coGid);
                commandParser.addOption((CommandOption)coExpire);
                commandParser.addOption((CommandOption)coInactive);
                commandParser.addOption((CommandOption)coTemplate);
            }
            commandParser.addOption((CommandOption)coUsername);
            commandParser.addOption((CommandOption)coFullName);
            commandParser.addOption((CommandOption)coPassword);
            commandParser.addOption((CommandOption)coUid);
            commandParser.addOption((CommandOption)coComment);
            commandParser.addOption((CommandOption)coDir);
            commandParser.addOption((CommandOption)coGroupNames);
            commandParser.addOption((CommandOption)coShell);
            commandParser.addOption((CommandOption)coXArgs);
            commandParser.addOption((CommandOption)coHelp);
            commandParser.addOption((CommandOption)coTaskFile);
            commandParser.addOption((CommandOption)coDebug);
            userObj.setUserType(this.UserOrRoleID);
            if (commandParser.parseArgs(stringArray)) {
                if (coHelp.wasSet()) {
                    commandParser.printUsage(null);
                    throw new UserMgrCliHelpException(null);
                }
                if (coAddRole.wasSet()) {
                    object2 = coAddRole.getValues();
                    userObj = this.setInitialUserRoleNames(userObj, (Vector)object2);
                }
                if (coAddProf.wasSet()) {
                    object2 = coAddProf.getValues();
                    userObj = this.setProfNameVector(userObj, (Vector)object2);
                }
                if (coUsername.wasSet()) {
                    object2 = (String)coUsername.getValue();
                    if (CheckSyntax.isNameOK((String)object2)) {
                        userObj.setUserName((String)object2);
                    } else {
                        throw new UserException("EXM_CLI_INVALID_USERNAME");
                    }
                }
                if (coFullName.wasSet()) {
                    object2 = (String)coFullName.getValue();
                    userObj.setUserFullName((String)object2);
                }
                if (coPassword.wasSet()) {
                    object2 = (String)coPassword.getValue();
                    if (!CheckSyntax.isPasswordLenOK((String)object2)) {
                        throw new UserException("EXM_CLI_INVALID_PWD");
                    }
                    userObj = this.setUserPasswd((String)object2, userObj, false);
                } else if (this.UserOrRoleID.equals("role") && coPassword.promptUser(this.input, this.output)) {
                    object2 = (String)coPassword.getValue();
                    userObj = this.setUserPasswd((String)object2, userObj, false);
                }
                if (coUid.wasSet()) {
                    object2 = (String)coUid.getValue();
                    this.validateUID((String)object2);
                    userObj.setUserID((String)object2);
                }
                if (coTemplate.wasSet()) {
                    object2 = (String)coTemplate.getValue();
                    userObj.setTemplateName((String)object2);
                }
                if (coComment.wasSet()) {
                    object2 = (String)coComment.getValue();
                    userObj.setUserDescription((String)object2);
                }
                if (coDir.wasSet()) {
                    object2 = (String)coDir.getValue();
                    if (!CheckSyntax.isHomeDirPathnameOK((String)object2)) {
                        throw new UserException("EXM_CLI_INVALID_HOMEDIR", CheckSyntax.getErrorString());
                    }
                    cloneable = userObj.getSolHomedirAttr();
                    if (cloneable == null) {
                        cloneable = new SolHomedirAttr();
                    }
                    ((SolHomedirAttr)cloneable).setPathname((String)object2);
                    userObj.setSolHomedirAttr((SolHomedirAttr)cloneable);
                }
                if (coExpire.wasSet()) {
                    object2 = (String)coExpire.getValue();
                    if (!this.isValidExpiresDate((String)object2)) {
                        throw new UserException("EXM_CLI_BAD_EXPIRESDATE");
                    }
                    cloneable = userObj.getSolAccountAttr();
                    if (cloneable == null) {
                        cloneable = new SolAccountAttr();
                    }
                    ((SolAccountAttr)cloneable).setAccountExpires((String)object2);
                    ((SolAccountAttr)cloneable).setAccountIsLocked(false);
                    userObj.setSolAccountAttr((SolAccountAttr)cloneable);
                }
                if (coInactive.wasSet()) {
                    object2 = (String)coInactive.getValue();
                    cloneable = userObj.getSolPasswordAttr();
                    if (cloneable == null) {
                        cloneable = new SolPasswordAttr();
                    }
                    ((SolPasswordAttr)cloneable).setInactiveDays((String)object2);
                    userObj.setSolPasswordAttr((SolPasswordAttr)cloneable);
                }
                if (coGid.wasSet()) {
                    object2 = (String)coGid.getValue();
                    userObj = this.setPrimaryGroup(userObj, (String)object2);
                }
                if (coGroupNames.wasSet()) {
                    object2 = new Vector();
                    object2 = coGroupNames.getValues();
                    userObj = this.setSecondaryGroupData((Vector)object2, userObj);
                }
                if (coShell.wasSet()) {
                    object2 = (String)coShell.getValue();
                    cloneable = userObj.getSolServicesAttr();
                    if (cloneable == null) {
                        cloneable = new SolServicesAttr();
                    }
                    if (!this.isValidShellEntry((String)object2)) {
                        throw new UserMgrCliArgParsingException("EXM_CLI_BAD_SHELL");
                    }
                    ((SolServicesAttr)cloneable).setInitialShell((String)object2);
                    userObj.setSolServicesAttr((SolServicesAttr)cloneable);
                }
                if (coXArgs.wasSet()) {
                    this.vXArgs = coXArgs.getValues();
                }
            } else {
                this.trace("Error parsing args");
                throw new UserMgrCliArgParsingException("EXM_CLI_MISSING_ARG");
            }
            object2 = commandParser.getUnmatchedOptions();
            if (((String[])object2).length >= 1) {
                commandParser.printUsage(null);
                throw new UserMgrCliArgParsingException("EXM_CLI_INVALID_ARG", object2[0]);
            }
        }
        catch (UserMgrCliHelpException userMgrCliHelpException) {
            throw userMgrCliHelpException;
        }
        catch (UserMgrCliArgParsingException userMgrCliArgParsingException) {
            throw userMgrCliArgParsingException;
        }
        catch (UserException userException) {
            throw userException;
        }
        catch (Throwable throwable) {
            this.trace("Throwable type-of-exception");
            this.printDebugStack(throwable);
            throw new UserMgrCliArgParsingException("EXM_CLI_GENERIC_ERROR");
        }
        try {
            if (this.vXArgs.size() > 0) {
                userObj = this.parseXAddOptions(this.vXArgs, userObj);
                object2 = userObj.getSolPasswordAttr();
            }
        }
        catch (UserException userException) {
            commandParser.printUsage(null);
            throw userException;
        }
        catch (Exception exception) {
            this.printDebugStack(exception);
            throw new UserMgrCliArgParsingException("EXM_GENERIC_XARG_ERR", exception.getLocalizedMessage());
        }
        object2 = userObj.getSolAuthAttrs();
        if (object2 != null) {
            cloneable = object2.getAttribute("min_label");
            vector = object2.getAttribute("clearance");
            if (cloneable != null || vector != null) {
                object = null;
                String string4 = null;
                object = cloneable == null ? this.tsolDefaults.getMinLabel() : (String)((Vector)cloneable).elementAt(0);
                string4 = vector == null ? this.tsolDefaults.getClearance() : (String)vector.elementAt(0);
                boolean bl2 = true;
                try {
                    bl2 = this.tsService.checkClearanceDominance((String)object, string4, this.userName);
                }
                catch (Exception exception) {
                    throw new UserException("EXM_CLI_DOM_CHK_ERROR");
                }
                if (!bl2) {
                    throw new UserException("EXM_CLI_DOM_CHK_FAILED");
                }
            }
        }
        if (this.UserOrRoleID.equals("role")) {
            cloneable = userObj.getSolAuthAttrs();
            if (cloneable == null) {
                cloneable = new UserAttrObj();
            }
            if ((vector = cloneable.getAttribute("min_label")) == null) {
                cloneable.setAttribute("min_label", "0x00000000000000000000000000000000000000000000000000000000000000000000");
            }
            vector = null;
            vector = cloneable.getAttribute("clearance");
            if (vector == null) {
                cloneable.setAttribute("clearance", "0x7fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff");
            }
            vector = null;
            vector = cloneable.getAttribute("labelview");
            if (vector == null) {
                object = new Vector();
                ((Vector)object).addElement("internal");
                ((Vector)object).addElement("showsl");
                cloneable.setAttribute("labelview", (Vector)object);
            }
            vector = null;
            vector = cloneable.getAttribute("password");
            if (vector == null) {
                cloneable.setAttribute("password", "manual");
            }
            cloneable.setAttribute("lock_after_retries", "no");
            userObj.setSolAuthAttrs((UserAttrObj)cloneable);
            userObj.setInitFilePath(TSOL_ROLE_SKEL_PATH);
        }
        this.addUserObj(userObj);
    }

    private void checkForDeleteOptions(String[] stringArray, String string, String string2) throws Exception {
        UserObj userObj = new UserObj();
        CommandLineOption commandLineOption = new CommandLineOption("user_name", ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"arg_optional_uname_desc"), "n", 1, false, true, null, false, false);
        CommandParser commandParser = new CommandParser(string, string2, true, null, null);
        try {
            String[] stringArray2;
            commandParser.addOption((CommandOption)commandLineOption);
            commandParser.addOption((CommandOption)coHelp);
            commandParser.addOption((CommandOption)coTaskFile);
            commandParser.addOption((CommandOption)coDebug);
            if (commandParser.parseArgs(stringArray)) {
                if (commandLineOption.wasSet()) {
                    stringArray2 = commandLineOption.getValues();
                    this.checkIfNamesAreValid((Vector)stringArray2);
                    Vector<UserObj> vector = new Vector<UserObj>();
                    Enumeration enumeration = stringArray2.elements();
                    while (enumeration.hasMoreElements()) {
                        UserObj userObj2 = new UserObj((String)enumeration.nextElement());
                        userObj2.setUserType(this.UserOrRoleID);
                        vector.addElement(userObj2);
                        this.trace("adding userobj:  " + userObj2.getUserName());
                    }
                    this.setUserObjs(vector);
                } else {
                    this.trace("XXX:  Missing Username!!!");
                }
                if (coHelp.wasSet()) {
                    commandParser.printUsage(null);
                    throw new UserMgrCliHelpException(null);
                }
            } else {
                this.trace("Error parsing args");
                throw new UserMgrCliArgParsingException("EXM_CLI_MISSING_ARG");
            }
            stringArray2 = commandParser.getUnmatchedOptions();
            if (stringArray2.length >= 1) {
                commandParser.printUsage(null);
                throw new UserMgrCliArgParsingException("EXM_CLI_INVALID_ARG", stringArray2[0]);
            }
        }
        catch (UserMgrCliHelpException userMgrCliHelpException) {
            throw userMgrCliHelpException;
        }
        catch (UserMgrCliArgParsingException userMgrCliArgParsingException) {
            throw userMgrCliArgParsingException;
        }
        catch (Throwable throwable) {
            this.trace("Throwable type-of-exception");
            this.printDebugStack(throwable);
            throw new UserMgrCliArgParsingException("EXM_CLI_GENERIC_ERROR");
        }
    }

    private void checkForModifyOptions(String[] stringArray, String string, String string2) throws Exception {
        Object object;
        boolean bl = false;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        String string11 = null;
        String string12 = null;
        Object var15_15 = null;
        UserObj userObj = new UserObj();
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        Vector vector4 = new Vector();
        Vector vector5 = new Vector();
        ResourceBundle resourceBundle = this.getResourceBundle();
        this.trace("enterred checkForModifyOptions");
        CommandParser commandParser = new CommandParser(string, string2, true, null, null);
        CommandLineOption commandLineOption = new CommandLineOption("new_user_name", ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"arg_addprof_desc"), "N", 1, true, true, (Object)"", false, false);
        CommandLineOption commandLineOption2 = new CommandLineOption("full_name", ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"arg_fullname_desc"), "F", 1, true, true, null, false, false);
        String string13 = this.UserOrRoleID.equals("role") ? ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"arg_XARGMODROLE_desc") : ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"arg_XARGMODUSER_desc");
        coXArgs = new CommandLineOption("xArgs", string13, "x", 1, true, true, null, false, false);
        try {
            if (!this.UserOrRoleID.equals("role")) {
                commandParser.addOption((CommandOption)coGid);
                commandParser.addOption((CommandOption)coExpire);
                commandParser.addOption((CommandOption)coInactive);
            }
            commandParser.addOption((CommandOption)coUsername);
            commandParser.addOption((CommandOption)commandLineOption2);
            commandParser.addOption((CommandOption)coPassword);
            commandParser.addOption((CommandOption)commandLineOption);
            commandParser.addOption((CommandOption)coGroupNames);
            commandParser.addOption((CommandOption)coComment);
            commandParser.addOption((CommandOption)coDir);
            commandParser.addOption((CommandOption)coShell);
            commandParser.addOption((CommandOption)coXArgs);
            commandParser.addOption((CommandOption)coDelRole);
            commandParser.addOption((CommandOption)coAddRole);
            commandParser.addOption((CommandOption)coDelProf);
            commandParser.addOption((CommandOption)coAddProf);
            commandParser.addOption((CommandOption)coHelp);
            commandParser.addOption((CommandOption)coTaskFile);
            commandParser.addOption((CommandOption)coDebug);
            if (commandParser.parseArgs(stringArray)) {
                if (coHelp.wasSet()) {
                    commandParser.printUsage(null);
                    throw new UserMgrCliHelpException(null);
                }
                if (coUsername.wasSet()) {
                    string9 = (String)coUsername.getValue();
                    this.setOldUserName(string9);
                    if (string9.equals("") || string9 == null) {
                        throw new UserException("EXM_CLI_ACCTNAME_REQ");
                    }
                    if (!CheckSyntax.isNameOK((String)string9)) {
                        throw new UserException("EXM_CLI_INVALID_USERNAME");
                    }
                }
                if (commandLineOption2.wasSet()) {
                    string6 = (String)commandLineOption2.getValue();
                }
                if (coPassword.wasSet() && !CheckSyntax.isPasswordLenOK((String)(string10 = (String)coPassword.getValue()))) {
                    throw new UserException("EXM_CLI_INVALID_PWD");
                }
                if (commandLineOption.wasSet() && !CheckSyntax.isNameOK((String)(string11 = (String)commandLineOption.getValue()))) {
                    throw new UserException("EXM_CLI_INVALID_USERNAME");
                }
                if (coComment.wasSet()) {
                    string3 = (String)coComment.getValue();
                }
                if (coDir.wasSet() && !CheckSyntax.isHomeDirPathnameOK((String)(string4 = (String)coDir.getValue()))) {
                    throw new UserException("EXM_CLI_INVALID_HOMEDIR", CheckSyntax.getErrorString());
                }
                if (coExpire.wasSet() && !this.isValidExpiresDate(string5 = (String)coExpire.getValue())) {
                    throw new UserException("EXM_CLI_BAD_EXPIRESDATE");
                }
                if (coInactive.wasSet()) {
                    string7 = (String)coInactive.getValue();
                }
                if (coGid.wasSet()) {
                    string8 = (String)coGid.getValue();
                }
                if (coGroupNames.wasSet()) {
                    vector5 = coGroupNames.getValues();
                }
                if (coShell.wasSet() && !this.isValidShellEntry(string12 = (String)coShell.getValue())) {
                    throw new UserMgrCliArgParsingException("EXM_CLI_BAD_SHELL");
                }
                if (coXArgs.wasSet()) {
                    this.vXArgs = coXArgs.getValues();
                }
                if (coDelRole.wasSet()) {
                    vector = coDelRole.getValues();
                    this.doUserRoleAuthCheck();
                }
                if (coAddRole.wasSet()) {
                    vector2 = coAddRole.getValues();
                    this.doUserRoleAuthCheck();
                    this.doUserRoleSanityCheck(vector2);
                }
                if (coDelProf.wasSet()) {
                    vector3 = coDelProf.getValues();
                }
                if (coAddProf.wasSet()) {
                    vector4 = coAddProf.getValues();
                }
            } else {
                this.trace("Error parsing args");
                throw new UserMgrCliArgParsingException("EXM_CLI_MISSING_ARG");
            }
            object = commandParser.getUnmatchedOptions();
            if (((String[])object).length >= 1) {
                commandParser.printUsage(null);
                throw new UserMgrCliArgParsingException("EXM_CLI_INVALID_ARG", object[0]);
            }
        }
        catch (UserMgrCliHelpException userMgrCliHelpException) {
            throw userMgrCliHelpException;
        }
        catch (UserMgrCliArgParsingException userMgrCliArgParsingException) {
            throw userMgrCliArgParsingException;
        }
        catch (UserException userException) {
            this.printDebugStack((Exception)((Object)userException));
            throw userException;
        }
        catch (Throwable throwable) {
            this.trace("Throwable type-of-exception");
            this.printDebugStack(throwable);
            throw new UserMgrCliArgParsingException("EXM_CLI_GENERIC_ERROR");
        }
        try {
            userObj.setUserName(string9);
            userObj = this.getObjectProps(userObj);
            if (string11 != null) {
                userObj.setUserName(string11);
            }
        }
        catch (AdminException adminException) {
            throw new UserException("EXM_CLI_NONEXISTANT_USER", string9);
        }
        userObj.setUserType(this.UserOrRoleID);
        if (string6 != null) {
            userObj.setUserFullName(string6);
        }
        if (string10 != null) {
            userObj = this.setUserPasswd(string10, userObj, false);
        }
        if (string3 != null) {
            userObj.setUserDescription(string3);
        }
        if (string4 != null) {
            object = new SolHomedirAttr();
            ((SolHomedirAttr)object).setPathname(string4);
            userObj.setSolHomedirAttr((SolHomedirAttr)object);
        }
        if (string5 != null) {
            object = new SolAccountAttr();
            ((SolAccountAttr)object).setAccountExpires(string5);
            userObj.setSolAccountAttr((SolAccountAttr)object);
        }
        if (string7 != null) {
            object = userObj.getSolPasswordAttr();
            if (object == null) {
                object = new SolPasswordAttr();
            }
            ((SolPasswordAttr)object).setMustChangeDays(string7);
            userObj.setSolPasswordAttr((SolPasswordAttr)object);
        }
        if (string8 != null) {
            userObj = this.setPrimaryGroup(userObj, string8);
        }
        if (string12 != null) {
            object = new SolServicesAttr();
            ((SolServicesAttr)object).setInitialShell(string12);
            userObj.setSolServicesAttr((SolServicesAttr)object);
        }
        if (vector5.size() > 0) {
            userObj = this.setSecondaryGroupData(vector5, userObj);
        }
        if (vector.size() > 0) {
            userObj = this.setDelRoleNames(userObj, vector);
        }
        if (vector2.size() > 0) {
            userObj = this.setAddRoleNames(userObj, vector2);
        }
        if (vector3.size() > 0) {
            userObj = this.setDelProfNames(userObj, vector3);
        }
        if (vector4.size() > 0) {
            userObj = this.setAddProfNames(userObj, vector4);
        }
        try {
            if (this.vXArgs.size() > 0) {
                userObj = this.parseXModifyOptions(this.vXArgs, userObj);
            }
        }
        catch (UserException userException) {
            commandParser.printUsage(null);
            throw userException;
        }
        catch (Exception exception) {
            this.printDebugStack(exception);
            throw new UserMgrCliArgParsingException("EXM_GENERIC_XARG_ERR");
        }
        this.addUserObj(userObj);
    }

    public void checkForMultiAddOptions(String[] stringArray, String string, String string2) throws UserException {
        CommandParser commandParser = new CommandParser(string, string2, true, null, null);
        CommandLineOption commandLineOption = new CommandLineOption("role", "unpublished method for multiadding roles", "ROLETYPE", 0, true, false, (Object)"", false, true);
        try {
            String[] stringArray2;
            commandParser.addOption((CommandOption)coInputFile);
            commandParser.addOption((CommandOption)coInputFileType);
            commandParser.addOption((CommandOption)coLogFile);
            commandParser.addOption((CommandOption)commandLineOption);
            commandParser.addOption((CommandOption)coTaskFile);
            commandParser.addOption((CommandOption)coDebug);
            commandParser.addOption((CommandOption)coHelp);
            if (commandParser.parseArgs(stringArray)) {
                if (coLogFile.wasSet()) {
                    stringArray2 = (String[])coLogFile.getValue();
                    if (!CheckSyntax.isHomeDirPathnameOK((String)stringArray2)) {
                        throw new UserException("EXM_CLI_BAD_LOGFILE");
                    }
                    this.setLogFile((String)stringArray2);
                }
                if (coInputFile.wasSet()) {
                    this.setInputDataFile((String)coInputFile.getValue());
                    this.bUsingFileInput = true;
                }
                if (coInputFileType.wasSet()) {
                    this.trace("we have a file that's not in /etc/passwd format");
                    this.setDataFileType(1);
                }
                if (commandLineOption.wasSet()) {
                    this.bIsMultiUserTypeARole = true;
                }
                if (coHelp.wasSet()) {
                    commandParser.printUsage(null);
                    throw new UserMgrCliHelpException(null);
                }
            } else {
                throw new UserMgrCliArgParsingException("EXM_CLI_MISSING_ARG");
            }
            if (this.getOperation() == -1) {
                this.trace("Error:  iOperation == -1");
                throw new UserException("EXM_CLI_NO_TASK");
            }
            stringArray2 = commandParser.getUnmatchedOptions();
            if (stringArray2.length >= 1) {
                commandParser.printUsage(null);
                throw new UserMgrCliArgParsingException("EXM_CLI_INVALID_ARG", stringArray2[0]);
            }
        }
        catch (UserMgrCliHelpException userMgrCliHelpException) {
            throw userMgrCliHelpException;
        }
        catch (UserMgrCliArgParsingException userMgrCliArgParsingException) {
            throw userMgrCliArgParsingException;
        }
        catch (Throwable throwable) {
            this.printDebugStack(throwable);
            throw new UserMgrCliArgParsingException("EXM_CLI_GENERIC_ERROR");
        }
    }

    public void checkForMultiDelOptions(String[] stringArray, String string, String string2) throws UserException {
        CommandParser commandParser = new CommandParser(string, string2, true, null, null);
        CommandLineOption commandLineOption = new CommandLineOption("role", "unpublished method for multideleting roles", "ROLETYPE", 0, true, false, (Object)"", false, true);
        try {
            commandParser.addOption((CommandOption)coInputFile);
            commandParser.addOption((CommandOption)coInputFileType);
            commandParser.addOption((CommandOption)coLogFile);
            commandParser.addOption((CommandOption)commandLineOption);
            commandParser.addOption((CommandOption)coTaskFile);
            commandParser.addOption((CommandOption)coDebug);
            commandParser.addOption((CommandOption)coHelp);
            if (commandParser.parseArgs(stringArray)) {
                if (coLogFile.wasSet()) {
                    this.setLogFile((String)coLogFile.getValue());
                }
                if (coInputFile.wasSet()) {
                    this.trace("InputFile = " + (String)coInputFile.getValue());
                    this.setInputDataFile((String)coInputFile.getValue());
                    this.bUsingFileInput = true;
                }
                if (coInputFileType.wasSet()) {
                    this.trace("we have a file that's not in /etc/passwd format");
                    this.setDataFileType(1);
                }
                if (commandLineOption.wasSet()) {
                    this.bIsMultiUserTypeARole = true;
                }
                if (coHelp.wasSet()) {
                    commandParser.printUsage(null);
                    throw new UserMgrCliHelpException(null);
                }
            } else {
                this.trace("Error parsing args");
                throw new UserMgrCliArgParsingException("EXM_CLI_MISSING_ARG");
            }
            if (this.getOperation() == -1) {
                throw new UserException("EXM_CLI_NO_TASK");
            }
            String[] stringArray2 = commandParser.getUnmatchedOptions();
            if (stringArray2.length >= 1) {
                commandParser.printUsage(null);
                throw new UserMgrCliArgParsingException("EXM_CLI_INVALID_ARG", stringArray2[0]);
            }
        }
        catch (UserMgrCliHelpException userMgrCliHelpException) {
            throw userMgrCliHelpException;
        }
        catch (UserMgrCliArgParsingException userMgrCliArgParsingException) {
            throw userMgrCliArgParsingException;
        }
        catch (Throwable throwable) {
            this.trace("Throwable type-of-exception");
            this.printDebugStack(throwable);
            throw new UserMgrCliArgParsingException("EXM_CLI_GENERIC_ERROR");
        }
    }

    public void checkForMultiModOptions(String[] stringArray, String string, String string2) throws UserException {
        CommandParser commandParser = new CommandParser(string, string2, true, null, null);
        CommandLineOption commandLineOption = new CommandLineOption("role", "unpublished method for multiadding roles", "ROLETYPE", 0, true, false, (Object)"", false, true);
        try {
            commandParser.addOption((CommandOption)coInputFile);
            commandParser.addOption((CommandOption)coInputFileType);
            commandParser.addOption((CommandOption)coLogFile);
            commandParser.addOption((CommandOption)commandLineOption);
            commandParser.addOption((CommandOption)coTaskFile);
            commandParser.addOption((CommandOption)coDebug);
            commandParser.addOption((CommandOption)coHelp);
            if (commandParser.parseArgs(stringArray)) {
                if (coLogFile.wasSet()) {
                    this.setLogFile((String)coLogFile.getValue());
                }
                if (coInputFile.wasSet()) {
                    this.trace("InputFile = " + (String)coInputFile.getValue());
                    this.setInputDataFile((String)coInputFile.getValue());
                    this.bUsingFileInput = true;
                }
                if (coInputFileType.wasSet()) {
                    this.trace("we have a file that's not in /etc/passwd format");
                    this.setDataFileType(1);
                }
                if (commandLineOption.wasSet()) {
                    this.bIsMultiUserTypeARole = true;
                }
                if (coHelp.wasSet()) {
                    commandParser.printUsage(null);
                    throw new UserMgrCliHelpException(null);
                }
            } else {
                this.trace("Error parsing args");
                throw new UserMgrCliArgParsingException("EXM_CLI_MISSING_ARG");
            }
            if (this.getOperation() == -1) {
                throw new UserException("EXM_CLI_NO_TASK");
            }
            String[] stringArray2 = commandParser.getUnmatchedOptions();
            if (stringArray2.length >= 1) {
                commandParser.printUsage(null);
                throw new UserMgrCliArgParsingException("EXM_CLI_INVALID_ARG", stringArray2[0]);
            }
        }
        catch (UserMgrCliHelpException userMgrCliHelpException) {
            throw userMgrCliHelpException;
        }
        catch (UserMgrCliArgParsingException userMgrCliArgParsingException) {
            throw userMgrCliArgParsingException;
        }
        catch (Throwable throwable) {
            this.trace("Throwable type-of-exception");
            this.printDebugStack(throwable);
            throw new UserMgrCliArgParsingException("EXM_CLI_GENERIC_ERROR");
        }
    }

    private void checkForViewOptions(String[] stringArray, String string, String string2) throws Exception {
        String string3 = "";
        UserObj userObj = new UserObj();
        boolean bl = false;
        ResourceBundle resourceBundle = this.getResourceBundle();
        Vector vector = new Vector();
        coUsername = new CommandLineOption("user_name", ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"arg_optional_uname_desc"), "n", 1, true, true, null, false, false);
        CommandParser commandParser = new CommandParser(string, string2, true, null, null);
        try {
            String[] stringArray2;
            commandParser.addOption((CommandOption)coUsername);
            commandParser.addOption((CommandOption)coLongList);
            userObj.setUserType(this.UserOrRoleID);
            commandParser.addOption((CommandOption)coHelp);
            commandParser.addOption((CommandOption)coTaskFile);
            commandParser.addOption((CommandOption)coDebug);
            if (commandParser.parseArgs(stringArray)) {
                if (coUsername.wasSet()) {
                    vector = coUsername.getValues();
                    string3 = (String)vector.elementAt(0);
                    userObj.setUserName(string3);
                    bl = true;
                }
                if (coLongList.wasSet()) {
                    this.setDisplayLongList(true);
                }
                if (coHelp.wasSet()) {
                    commandParser.printUsage(null);
                    throw new UserMgrCliHelpException(null);
                }
            } else {
                this.trace("Error parsing args");
                throw new UserMgrCliArgParsingException("EXM_CLI_MISSING_ARG");
            }
            if (bl) {
                stringArray2 = new Vector();
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    UserObj userObj2 = new UserObj((String)enumeration.nextElement());
                    userObj2.setUserType(this.UserOrRoleID);
                    stringArray2.addElement(userObj2);
                }
                this.setUserObjs((Vector)stringArray2);
            } else if (this.getOperation() == 3) {
                this.trace("checkForViewOptions:  No name so listing all");
                this.bListAll = true;
            }
            stringArray2 = commandParser.getUnmatchedOptions();
            if (stringArray2.length >= 1) {
                commandParser.printUsage(null);
                throw new UserMgrCliArgParsingException("EXM_CLI_INVALID_ARG", stringArray2[0]);
            }
        }
        catch (UserMgrCliHelpException userMgrCliHelpException) {
            throw userMgrCliHelpException;
        }
        catch (UserMgrCliArgParsingException userMgrCliArgParsingException) {
            throw userMgrCliArgParsingException;
        }
        catch (Throwable throwable) {
            this.trace("Throwable type-of-exception");
            this.printDebugStack(throwable);
            throw new UserMgrCliArgParsingException("EXM_CLI_GENERIC_ERROR");
        }
    }

    private void checkIfNamesAreValid(Vector vector) throws UserMgrCliArgParsingException {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!(string = string.trim()).equals("root") && !string.equals("primadmin") && !string.equals("sysadmin") && !string.equals("operator")) continue;
            throw new UserMgrCliArgParsingException("EXM_CLI_INVALID_DELETE_NAME", string);
        }
    }

    private UserObj checkIfUIDMatch(UserObj userObj) {
        UserObj userObj2 = null;
        this.trace("in checkIfUIDMatch");
        Vector vector = new Vector();
        try {
            vector = this.getUserMgr().getAllUsers();
        }
        catch (Exception exception) {
            this.printDebugStack(exception);
            return userObj;
        }
        String string = userObj.getUserID().trim();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            userObj2 = (UserObj)enumeration.nextElement();
            if (string.equals(userObj2.getUserID().trim())) {
                this.trace("found a matching userid in old username: " + userObj2.getUserName());
                break;
            }
            userObj2 = null;
        }
        return userObj2;
    }

    private void createMailAliasForRole(UserObj userObj) throws Exception {
        this.trace("in createMailAliasForRole()");
        String string = userObj.getUserName();
        Vector vector = null;
        if (userObj.getSolAuthAttrs() != null) {
            vector = userObj.getSolAuthAttrs().getAttribute("members");
        }
        if (!this.UserOrRoleID.equals("role")) {
            this.trace("normal user so returning from createMailAliasForRole()");
            return;
        }
        EmailAliasObj emailAliasObj = new EmailAliasObj(string);
        if (vector != null && !vector.isEmpty()) {
            String string2 = new String("");
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                string2 = String.valueOf(string2) + enumeration.nextElement();
                if (!enumeration.hasMoreElements()) continue;
                string2 = String.valueOf(string2) + ", ";
            }
            emailAliasObj.setAliasExpansion(string2);
        }
        this.getUserMgr().addEmailAlias(emailAliasObj);
    }

    public void deleteMultiObjects() throws UserException {
        try {
            this.trace("delMultiObjects->SIMULATED RUNNING:");
            String string = ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"START_MULTIDEL_LOG");
            this.cascade_logging(string);
            string = ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"START_DETAILS");
            this.cascade_logging(string);
            this.writeLoggingDate();
            MultiUserXferObj multiUserXferObj = this.getMuxoBasedOnInput();
            this.doMultiUserDel(multiUserXferObj);
            try {
                this.trace("deleting input file");
                File file = new File(this.getInputDataFile());
                file.delete();
            }
            catch (Exception exception) {}
            this.writeLoggingDate();
            string = ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"END_MULTIDEL_LOG");
            this.cascade_logging(string);
        }
        catch (Exception exception) {
            this.trace("exception in delMultiObjects(): " + exception.getMessage());
            this.printDebugStack(exception);
            throw new UserException("EXM_DMU1");
        }
    }

    public void deleteObject() throws Exception {
        this.trace("in deleteObject()");
        Vector vector = this.getUserObjs();
        try {
            int n = 0;
            while (n < vector.size()) {
                UserObj userObj = (UserObj)vector.elementAt(n);
                if (this.getUserMgr() == null) {
                    this.trace("usermgr is null!");
                    throw new UserException("EXM_CLI_NO_SERVICE");
                }
                if (this.getDebugStatus()) {
                    this.trace("\nDumping the object BEFOR we delete it.");
                    this.dumpObjectContents(userObj);
                }
                try {
                    this.getUserMgr().deleteUser(userObj);
                }
                catch (SolServerPartialSuccessException solServerPartialSuccessException) {
                    this.trace("Partial success error");
                    this.handleErrors(solServerPartialSuccessException.getLocalizedMessage());
                }
                catch (Exception exception) {
                    this.trace("got exception deleting a user.");
                    this.handleErrors(exception.getLocalizedMessage());
                }
                ++n;
            }
        }
        catch (Exception exception) {
            this.trace("exception in deleteObject(): " + exception.getMessage());
            this.printDebugStack(exception);
            throw exception;
        }
    }

    public void doFirstArgPass(String[] stringArray) throws UserException {
        CommandParser commandParser = new CommandParser("UserMgrCli", "main tool for users related cli's", true, null, null);
        try {
            commandParser.addOption((CommandOption)coTaskFile);
            commandParser.addOption((CommandOption)coLogFile);
            commandParser.addOption((CommandOption)coDebug);
            commandParser.addOption((CommandOption)coHelp);
            if (commandParser.parseArgs(stringArray)) {
                if (coTaskFile.wasSet()) {
                    String string = (String)coTaskFile.getValue();
                    this.setTaskOperation(string.charAt(0));
                    this.trace("doFirstArgPass->coTaskFile set for :  " + string);
                }
                if (coLogFile.wasSet()) {
                    this.setLogFile((String)coLogFile.getValue());
                }
                if (coDebug.wasSet()) {
                    this.setDebugStatus(true);
                }
            } else {
                this.trace("Error parsing args");
                throw new UserMgrCliArgParsingException("EXM_CLI_MISSING_ARG");
            }
            coHelp.wasSet();
            if (this.getOperation() == -1) {
                this.trace("Error:  iOperation == -1");
                throw new UserException("EXM_CLI_NO_TASK");
            }
        }
        catch (Throwable throwable) {
            this.trace("doh!  Throwable type-of-exception");
            this.printDebugStack(throwable);
        }
    }

    public void doMultiUserAdd(MultiUserXferObj multiUserXferObj) throws UserException {
        UserObj userObj = null;
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        Vector vector3 = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        Object var9_9 = null;
        String string4 = "user";
        String string5 = "";
        int n = 1;
        int n2 = 1;
        int n3 = 100;
        int n4 = 0;
        this.trace("in doMultiUserAdd()");
        if (multiUserXferObj == null) {
            this.trace("NULL MUXO in doMultiUserAdd");
            return;
        }
        String string6 = ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"ADD_USER_SUCCESS");
        String string7 = ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"ADD_USER_PARTIAL");
        String string8 = ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"ADD_USER_ERROR");
        String string9 = ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"ADD_USER_DUPNAME");
        try {
            if (multiUserXferObj.getInitialUserId() != null) {
                n3 = Integer.parseInt(multiUserXferObj.getInitialUserId());
            }
        }
        catch (Exception exception) {
            this.trace("Exception in doMultiUserAdd() while getting uid");
            throw new UserMgrCliArgParsingException("EXM_AMU1");
        }
        n4 = multiUserXferObj.getNumberOfUsers();
        userObj = new UserObj();
        userObj = this.setDefaultData();
        userObj.setUserType("normal");
        userObj = this.setMuxoPasswd(multiUserXferObj, userObj);
        SolGroupAttr solGroupAttr = new SolGroupAttr();
        solGroupAttr.setNumberSecondaryGroups(0);
        userObj.setSolGroupAttr(solGroupAttr);
        SolServicesAttr solServicesAttr = new SolServicesAttr();
        solServicesAttr.setMailServer(multiUserXferObj.getMailServer());
        userObj.setSolServicesAttr(solServicesAttr);
        userObj = this.setMuxoAccountAttr(multiUserXferObj, userObj);
        int n5 = multiUserXferObj.getAddType();
        if (n5 == 1) {
            string4 = multiUserXferObj.getNamePrefix();
            n = multiUserXferObj.getNameInitialSuffix();
            n2 = multiUserXferObj.getNameIncrementSuffix();
        }
        Enumeration enumeration = multiUserXferObj.getHDirPathEnum();
        Enumeration enumeration2 = multiUserXferObj.getUserNamesEnum();
        Enumeration enumeration3 = multiUserXferObj.getUserDescriptionEnum();
        Enumeration enumeration4 = multiUserXferObj.getFullNameEnum();
        Enumeration enumeration5 = multiUserXferObj.getUIDEnum();
        Enumeration enumeration6 = multiUserXferObj.getUnixShellEnum();
        Enumeration enumeration7 = multiUserXferObj.getPrimaryGroupEnum();
        int n6 = 0;
        while (n6 < n4) {
            Object object;
            Object object2;
            if (n5 == 0 && enumeration2 != null && enumeration2.hasMoreElements()) {
                string = (String)enumeration2.nextElement();
            } else if (n5 == 0) {
                this.trace("mismatch with # of users read in and whats expected");
                throw new UserException("EXM_CLI_BAD_MUXOLIST");
            }
            if (enumeration6 != null && enumeration6.hasMoreElements()) {
                object2 = userObj.getSolServicesAttr();
                object = (String)enumeration6.nextElement();
                if ((object = ((String)object).trim()) == null || ((String)object).equals("")) {
                    object = "/bin/sh";
                }
                ((SolServicesAttr)object2).setInitialShell((String)object);
                userObj.setSolServicesAttr((SolServicesAttr)object2);
            }
            if (enumeration3 != null && enumeration3.hasMoreElements()) {
                userObj.setUserDescription((String)enumeration3.nextElement());
            }
            if (enumeration7 != null && enumeration7.hasMoreElements()) {
                object2 = (String)enumeration7.nextElement();
                if ((object2 = ((String)object2).trim()) == null || ((String)object2).equals("")) {
                    object2 = "10";
                }
                object = null;
                object = userObj.getSolGroupAttr() == null ? new SolGroupAttr() : userObj.getSolGroupAttr();
                ((SolGroupAttr)object).setPrimaryGroup((String)object2);
                userObj.setSolGroupAttr((SolGroupAttr)object);
            }
            if (enumeration4 != null && enumeration4.hasMoreElements()) {
                string2 = (String)enumeration4.nextElement();
            }
            if (multiUserXferObj.getDefaultTemplateName() != null && !multiUserXferObj.getDefaultTemplateName().equals("")) {
                userObj.setTemplateName(multiUserXferObj.getDefaultTemplateName());
            } else {
                userObj.setTemplateName(this.getDefaultTemplatename());
            }
            if (enumeration5 != null && enumeration5.hasMoreElements() && multiUserXferObj.getUID() != null && multiUserXferObj.getUID().size() == n4) {
                object2 = (String)enumeration5.nextElement();
                if (object2 != null && !((String)object2).equals("")) {
                    userObj.setUserID((String)object2);
                } else {
                    userObj.setUserID(new Integer(n3).toString());
                }
            } else {
                userObj.setUserID(new Integer(n3).toString());
            }
            string3 = enumeration != null && enumeration.hasMoreElements() ? (String)enumeration.nextElement() : "";
            boolean bl = false;
            while (!bl) {
                bl = true;
                if (string2 != null && !string2.equals("")) {
                    userObj.setUserFullName(string2);
                }
                boolean bl2 = true;
                try {
                    if (n5 == 1) {
                        string = String.valueOf(string4) + new Integer(n).toString();
                    }
                    userObj.setUserName(string);
                    if (!CheckSyntax.isNameOK((String)string)) {
                        throw new UserException("EXM_CLI_INVALID_USERNAME");
                    }
                    userObj = this.setMuxoHomeDir(multiUserXferObj, userObj, string3);
                    try {
                        this.trace("really adding user: " + userObj.getUserName());
                        if (this.getDebugStatus()) {
                            this.dumpObjectContents(userObj);
                        }
                        this.getUserMgr().addUser(userObj);
                        string5 = String.valueOf(string6) + "\"" + userObj.getUserName() + "\"";
                        this.cascade_logging(string5, true);
                    }
                    catch (SolServerPartialSuccessException solServerPartialSuccessException) {
                        this.trace("partial success during multi-add");
                        throw solServerPartialSuccessException;
                    }
                    catch (Exception exception) {
                        this.trace("regular exception during multi-add");
                        if (vector3 == null) {
                            vector3 = this.getAllUserAndRoles();
                        }
                        this.checkFailedAddForProblem(vector3, userObj, exception);
                    }
                }
                catch (UserMgrNameAlreadyInUseException userMgrNameAlreadyInUseException) {
                    this.trace("gotta UserMgrNameAlreadyInUseException");
                    bl2 = false;
                    if (n5 == 1) {
                        n += n2;
                        bl = false;
                    }
                    if (n5 == 1) continue;
                    vector.addElement(userObj.getUserName());
                    string5 = String.valueOf(string8) + "\"" + userObj.getUserName() + "\"" + string9;
                    this.cascade_logging(string5, true);
                }
                catch (UserMgrIDAlreadyInUseException userMgrIDAlreadyInUseException) {
                    this.trace("gotta UserMgrIDAlreadyInUseException");
                    bl2 = false;
                    bl = false;
                    try {
                        object = this.getUserMgr().getNextAvailableUID();
                        n3 = Integer.parseInt((String)object);
                    }
                    catch (Exception exception) {
                        ++n3;
                    }
                    userObj.setUserID(new Integer(n3).toString());
                }
                catch (SolServerPartialSuccessException solServerPartialSuccessException) {
                    this.trace("gotta SolServerPartialSuccessException");
                    bl2 = false;
                    vector2.addElement(userObj.getUserName());
                    string5 = String.valueOf(string7) + "\"" + userObj.getUserName() + "\"" + "\n" + solServerPartialSuccessException.getLocalizedMessage();
                    this.cascade_logging(string5, true);
                }
                catch (UserException userException) {
                    this.trace("gotta UserException");
                    bl2 = false;
                    vector.addElement(userObj.getUserName());
                    string5 = String.valueOf(string8) + "\"" + userObj.getUserName() + "\"" + "\n" + userException.getLocalizedMessage();
                    this.cascade_logging(string5, true);
                }
                catch (Exception exception) {
                    this.trace("got Exception" + exception.getLocalizedMessage());
                    this.printDebugStack(exception);
                    bl2 = false;
                    vector.addElement(userObj.getUserName());
                    string5 = String.valueOf(string8) + "\"" + userObj.getUserName() + "\"" + "\n" + exception.getLocalizedMessage();
                    this.cascade_logging(string5, true);
                }
            }
            ++n3;
            if (n5 == 1) {
                n += n2;
            }
            ++n6;
        }
        String string10 = ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"END_DETAILS");
        this.cascade_logging(string10);
        this.logBulkOperationResults(n4, vector2, vector);
    }

    public void doMultiUserDel(MultiUserXferObj multiUserXferObj) throws UserException {
        String string = "";
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        boolean bl = true;
        int n = 0;
        this.trace("in doMultiUserDel()");
        if (multiUserXferObj == null) {
            this.trace("NULL MUXO in doMultiUserDel");
            return;
        }
        String string2 = ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"DELETE_USER_SUCCESS");
        String string3 = ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"DELETE_USER_PARTIAL");
        String string4 = ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"DELETE_USER_ERROR");
        n = multiUserXferObj.getNumberOfUsers();
        int n2 = 0;
        while (n2 < multiUserXferObj.getNumberOfUsers()) {
            if (multiUserXferObj.getAddType() != 0) {
                throw new UserException("EXM_CLI_MUXOFILETYPE_BAD");
            }
            String string5 = (String)multiUserXferObj.getUserNames().elementAt(n2);
            UserObj userObj = new UserObj(string5);
            userObj.setUserType("normal");
            this.trace("deleting account:  " + string5);
            if (this.bIsMultiUserTypeARole && !this.getUserMgr().hasRoleMgrAssignAuth() && !this.getUserMgr().hasRoleMgrDelegateAuth()) {
                this.trace("multidel of roles with no perms to del roels.");
                throw new UserException("EXM_CLI_NO_ROLEASSIGN");
            }
            if (this.getDebugStatus()) {
                this.trace("\nDumping the object BEFOR we delete it.");
                this.dumpObjectContents(userObj);
            }
            try {
                this.getUserMgr().deleteUser(userObj);
                string = String.valueOf(string2) + "\"" + userObj.getUserName() + "\"";
                this.cascade_logging(string, true);
            }
            catch (SolServerPartialSuccessException solServerPartialSuccessException) {
                this.trace("gotta SolServerPartialSuccessException");
                bl = false;
                vector2.addElement(userObj.getUserName());
                string = String.valueOf(string3) + "\"" + userObj.getUserName() + "\"" + "\n" + solServerPartialSuccessException.getLocalizedMessage();
                this.cascade_logging(string, true);
            }
            catch (UserException userException) {
                this.trace("gotta UserException");
                bl = false;
                vector.addElement(userObj.getUserName());
                string = String.valueOf(string4) + "\"" + userObj.getUserName() + "\"" + "\n" + userException.getLocalizedMessage();
                this.cascade_logging(string, true);
            }
            catch (Exception exception) {
                this.trace("Error was:  " + exception.getLocalizedMessage());
                this.printDebugStack(exception);
                bl = false;
                vector.addElement(userObj.getUserName());
                string = String.valueOf(string4) + "\"" + userObj.getUserName() + "\"" + "\n" + exception.getLocalizedMessage();
                this.cascade_logging(string, true);
            }
            ++n2;
        }
        String string6 = ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"END_DETAILS");
        this.cascade_logging(string6);
        this.logBulkOperationResults(n, vector2, vector);
    }

    public void doMultiUserMod(MultiUserXferObj multiUserXferObj) throws UserException {
        String string;
        UserObj userObj = new UserObj();
        UserObj userObj2 = null;
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        String string2 = null;
        String string3 = null;
        Object var8_8 = null;
        String string4 = "";
        int n = 0;
        this.trace("in doMultiUserMod()");
        if (multiUserXferObj == null) {
            this.trace("NULL MUXO in doMultiUserMod");
            return;
        }
        String string5 = ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"MOD_USER_SUCCESS");
        String string6 = ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"MOD_USER_PARTIAL");
        String string7 = ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"MOD_USER_ERROR");
        n = multiUserXferObj.getNumberOfUsers();
        userObj.setUserType("normal");
        String[] stringArray = multiUserXferObj.getUnixShellArray();
        String[] stringArray2 = multiUserXferObj.getFullNameArray();
        String[] stringArray3 = multiUserXferObj.getUIDArray();
        String[] stringArray4 = multiUserXferObj.getHDirPathArray();
        String[] stringArray5 = multiUserXferObj.getUserNamesArray();
        String[] stringArray6 = multiUserXferObj.getPrimaryGroupArray();
        String[] stringArray7 = multiUserXferObj.getPWDArray();
        String[] stringArray8 = multiUserXferObj.getUserDescriptionArray();
        int n2 = 0;
        while (n2 < n) {
            boolean bl;
            if (stringArray5 == null) {
                this.trace("invalid list of users.");
                throw new UserException("EXM_CLI_BAD_MUXOLIST");
            }
            string2 = stringArray5[n2];
            userObj.setUserName(string2);
            if (stringArray3 != null && stringArray3.length > n2 && multiUserXferObj.getUID().size() == n) {
                string = stringArray3[n2];
                if ((string = string.trim()) != null && !string.equals("")) {
                    userObj.setUserID(string);
                }
            }
            try {
                Cloneable cloneable;
                block20: {
                    try {
                        userObj = this.getObjectProps(userObj);
                        userObj2 = (UserObj)userObj.clone();
                    }
                    catch (Exception exception) {
                        userObj2 = this.checkIfUIDMatch(userObj);
                        if (userObj2 != null) break block20;
                        throw exception;
                    }
                }
                if (stringArray7 != null && stringArray7.length > n2 && (string = stringArray7[n2]) != null && !string.trim().equals("")) {
                    userObj = this.setUserPasswd(string, userObj, true);
                }
                if (stringArray != null && stringArray.length > n2) {
                    string = stringArray[n2];
                    if ((string = string.trim()) != null && !string.equals("")) {
                        cloneable = null;
                        cloneable = userObj.getSolServicesAttr() != null ? userObj.getSolServicesAttr() : new SolServicesAttr();
                        ((SolServicesAttr)cloneable).setInitialShell(string);
                        userObj.setSolServicesAttr((SolServicesAttr)cloneable);
                    }
                }
                if (stringArray8 != null && stringArray8.length > n2) {
                    string = stringArray8[n2];
                    if ((string = string.trim()) != null && !string.equals("")) {
                        userObj.setUserDescription(string);
                    }
                }
                if (stringArray6 != null && stringArray6.length > n2) {
                    string = stringArray6[n2];
                    cloneable = null;
                    cloneable = userObj.getSolGroupAttr() == null ? new SolGroupAttr() : userObj.getSolGroupAttr();
                    ((SolGroupAttr)cloneable).setPrimaryGroup(string);
                    userObj.setSolGroupAttr((SolGroupAttr)cloneable);
                }
                if (stringArray2 != null && stringArray2.length > n2) {
                    string = stringArray2[n2];
                    userObj.setUserFullName(string);
                }
                if (stringArray4 != null && stringArray4.length > n2) {
                    string3 = stringArray4[n2];
                }
                userObj = this.setMuxoHomeDir(multiUserXferObj, userObj, string3);
                bl = true;
                if (this.getDebugStatus()) {
                    this.dumpObjectContents(userObj);
                    this.dumpObjectContents(userObj2);
                }
                this.getUserMgr().modifyUser(userObj, userObj2);
                string4 = String.valueOf(string5) + "\"" + userObj.getUserName() + "\"";
                this.cascade_logging(string4, true);
            }
            catch (SolServerPartialSuccessException solServerPartialSuccessException) {
                bl = false;
                vector2.addElement(userObj.getUserName());
                string4 = String.valueOf(string6) + "\"" + userObj.getUserName() + "\"" + "\n" + solServerPartialSuccessException.getLocalizedMessage();
                this.cascade_logging(string4, true);
            }
            catch (UserException userException) {
                this.printDebugStack((Exception)((Object)userException));
                bl = false;
                vector.addElement(userObj.getUserName());
                string4 = String.valueOf(string7) + "\"" + userObj.getUserName() + "\"";
                this.cascade_logging(string4, true);
            }
            catch (Exception exception) {
                this.printDebugStack(exception);
                bl = false;
                vector.addElement(userObj.getUserName());
                string4 = String.valueOf(string7) + "\"" + userObj.getUserName() + "\"";
                this.cascade_logging(string4, true);
            }
            ++n2;
        }
        string = ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"END_DETAILS");
        this.cascade_logging(string);
        this.logBulkOperationResults(n, vector2, vector);
    }

    private void doUserRoleAuthCheck() throws Exception {
        if (!this.getUserMgr().hasRoleMgrAssignAuth() && !this.getUserMgr().hasRoleMgrDelegateAuth()) {
            throw new UserException("EXM_CLI_NO_ROLEASSIGN");
        }
    }

    private void doUserRoleSanityCheck(Vector vector) throws Exception {
        this.trace("in doUserRoleSanityCheck()");
        if (!this.UserOrRoleID.equals("role")) {
            Vector vector2 = new Vector();
            vector2 = this.getUserMgr().getAllRoles();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                boolean bl = false;
                Enumeration enumeration2 = vector2.elements();
                while (enumeration2.hasMoreElements()) {
                    UserObj userObj = (UserObj)enumeration2.nextElement();
                    String string2 = userObj.getUserName();
                    if (!string.equals(string2)) continue;
                    bl = true;
                }
                if (!bl) {
                    this.trace("invalid role:  " + string);
                    throw new UserException("EXM_CLI_INVALID_ROLE");
                }
                this.trace("valid role:  " + string);
            }
        }
    }

    private void dumpObjectContents(UserObj userObj) {
        SolAccountAttr solAccountAttr;
        String[] stringArray;
        Cloneable cloneable;
        SolHomedirAttr solHomedirAttr;
        this.trace("---------------------------------");
        this.trace("User Object is as follows:");
        this.trace("User name is " + userObj.getUserName());
        this.trace("User full name is " + userObj.getUserFullName());
        this.trace("User ID is " + userObj.getUserID());
        this.trace("User Description is " + userObj.getUserDescription());
        this.trace("User type is " + userObj.getUserType());
        this.trace("User Template is " + userObj.getTemplateName());
        this.trace("Delete Home dir is " + userObj.getDelHomeDir());
        this.trace("Delete MailBox is " + userObj.getDelMBox());
        SolServicesAttr solServicesAttr = userObj.getSolServicesAttr();
        if (solServicesAttr != null) {
            if (solServicesAttr.getMailServer() != null) {
                this.trace("The mail Server is " + solServicesAttr.getMailServer());
            } else {
                this.trace("No Mailbox Server specified");
            }
            if (solServicesAttr.getInitialShell() != null) {
                this.trace("The initial shell is " + solServicesAttr.getInitialShell());
            } else {
                this.trace("No initial shell specified");
            }
            this.trace("Modify Mail Server? " + solServicesAttr.getModifyMailServer());
            this.trace("Force a Modify of the Mail information? " + solServicesAttr.requireModify());
        }
        if ((solHomedirAttr = userObj.getSolHomedirAttr()) != null) {
            if (solHomedirAttr.getServer() != null) {
                this.trace("Home directory server is " + solHomedirAttr.getServer());
            } else {
                this.trace("No home directory server");
            }
            if (solHomedirAttr.getPathname() != null) {
                this.trace("Home directory pathname is " + solHomedirAttr.getPathname());
            } else {
                this.trace("No home directory pathname");
            }
            this.trace("Automount home directory? " + solHomedirAttr.getAutomount());
            this.trace("Modify the Server? " + solHomedirAttr.getModifyServer());
            this.trace("Force a Modify of Home Directory Information? " + solHomedirAttr.requireModify());
            cloneable = solHomedirAttr.getPerms();
            this.trace("perms = " + ((Permissions)cloneable).getPermissions());
        }
        if ((cloneable = userObj.getSolGroupAttr()) != null) {
            this.trace("Primary Group is " + ((SolGroupAttr)cloneable).getPrimaryGroup());
            this.trace("Number of secondary groups is " + ((SolGroupAttr)cloneable).getNumberSecondaryGroups());
            this.trace("Secondary group list:");
            stringArray = ((SolGroupAttr)cloneable).getSecondaryGroups();
            if (stringArray != null) {
                int n = ((SolGroupAttr)cloneable).getNumberSecondaryGroups();
                int n2 = 0;
                while (n2 < n) {
                    this.trace(String.valueOf(stringArray[n2]) + " ");
                    ++n2;
                }
            } else {
                this.trace("no secondary groups");
            }
        }
        if ((stringArray = userObj.getSolPasswordAttr()) != null) {
            if (stringArray.getPasswd() != null) {
                this.trace("Password is " + stringArray.getPasswd());
            } else {
                this.trace("Password is empty");
            }
            this.trace("Must Change in " + stringArray.getMustChangeDays() + " days");
            this.trace("Cannot change before " + stringArray.getCannotChangeDays() + " days");
            this.trace("Alert in " + stringArray.getAlertChangeDays() + " days");
            this.trace("Inactive for " + stringArray.getInactiveDays() + " days");
            this.trace("Has user changed the Password? " + stringArray.hasPasswordChanged());
            this.trace("Does user have a Password? " + stringArray.isThereAPassword());
            this.trace("Force a Modify of Password Values? " + stringArray.requireModify());
        }
        if ((solAccountAttr = userObj.getSolAccountAttr()) != null) {
            if (solAccountAttr.getAccountExpires() != null) {
                this.trace("Expires on: " + solAccountAttr.getAccountExpires());
            } else {
                this.trace("Does not expire");
            }
            this.trace("Account is locked is " + solAccountAttr.isAccountLocked());
        }
        UserAttrObj userAttrObj = userObj.getSolAuthAttrs();
        this.trace("---------------------------------");
    }

    private Vector getAllUserAndRoles() throws AdminException {
        Vector vector = this.getUserMgr().getAllUsers();
        Vector vector2 = this.getUserMgr().getAllRoles();
        vector.addAll(vector2);
        return vector;
    }

    private String getDefaultTemplatename() {
        return this.defaultTemplate;
    }

    private UserObj getDefaultUserData() {
        return this.defaultObjSettings;
    }

    private MultiUserXferObj getMuxoBasedOnInput() throws AdminException {
        MultiUserXferObj multiUserXferObj = null;
        if (this.getDataFileType() == 0) {
            this.trace("calling getUserMuxoData");
            multiUserXferObj = this.getUserMuxoData();
            this.trace("done calling getUserMuxoData");
        } else {
            try {
                String string = this.getInputDataFile();
                this.trace("Reading " + string);
                FileInputStream fileInputStream = new FileInputStream(string);
                ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                multiUserXferObj = (MultiUserXferObj)objectInputStream.readObject();
                objectInputStream.close();
                fileInputStream.close();
            }
            catch (Exception exception) {
                this.trace("ERROR reading real muxo-file");
            }
        }
        return multiUserXferObj;
    }

    private UserObj getObjectProps(UserObj userObj) throws Exception {
        try {
            if (this.getUserMgr() == null) {
                this.trace("in getObjectProps:  usermgr is null!");
                throw new UserException("EXM_CLI_NO_SERVICE");
            }
            userObj = this.getUserMgr().getFullAttributes(userObj);
        }
        catch (Exception exception) {
            this.printDebugStack(exception);
            throw exception;
        }
        return userObj;
    }

    private String getOldUserName() {
        return this.strOldName;
    }

    private MultiUserXferObj getUserMuxoData() throws UserException {
        Object object;
        Vector vector = new Vector();
        if (this.bUsingFileInput) {
            this.trace("bUsingFileInput is true");
        } else {
            this.trace("bUsingFileInput is false");
        }
        if (this.bUsingPipesOrFiles) {
            this.trace("bUsingPipesOrFiles is true");
        } else {
            this.trace("bUsingPipesOrFiles is false");
        }
        if (this.bUsingFileInput && this.bUsingPipesOrFiles) {
            this.trace("bUsingFileInput && bUsingPipesOrFiles");
            object = this.getInputDataFile();
            vector = this.getUsersFromFile((String)object);
        } else if (this.bUsingPipesOrFiles && !this.bUsingFileInput) {
            this.trace("!bUsingFileInput && bUsingPipesOrFiles");
            vector = this.getUserObjs();
        }
        object = new MultiUserXferObj();
        UserObj userObj = (UserObj)vector.elementAt(0);
        if (userObj == null) {
            this.trace("ERROR:  FirstObj == null");
            return null;
        }
        ((MultiUserXferObj)object).setNumberOfUsers(vector.size());
        ((MultiUserXferObj)object).setHashPswd("");
        ((MultiUserXferObj)object).setInitialUserId(userObj.getUserID());
        ((MultiUserXferObj)object).setDefaultTemplateName(this.getDefaultTemplatename());
        if (userObj.getSolHomedirAttr() != null) {
            ((MultiUserXferObj)object).setHDirServer(userObj.getSolHomedirAttr().getServer());
            ((MultiUserXferObj)object).setHDirPath(userObj.getSolHomedirAttr().getPathname());
            ((MultiUserXferObj)object).setHDirAutomount(true);
        }
        if (userObj.getSolServicesAttr() != null) {
            ((MultiUserXferObj)object).setMailServer(userObj.getSolServicesAttr().getMailServer());
        }
        if (userObj.getSolAccountAttr() != null) {
            ((MultiUserXferObj)object).setPWDExpiresDate(userObj.getSolAccountAttr().getAccountExpires());
        }
        if (userObj.getSolPasswordAttr() != null) {
            ((MultiUserXferObj)object).setPWDChangeDays(userObj.getSolPasswordAttr().getMustChangeDays());
            ((MultiUserXferObj)object).setPWDAlertDays(userObj.getSolPasswordAttr().getAlertChangeDays());
            ((MultiUserXferObj)object).setPWDReuseDays(userObj.getSolPasswordAttr().getCannotChangeDays());
            ((MultiUserXferObj)object).setPWDIdleDays(userObj.getSolPasswordAttr().getInactiveDays());
        }
        ((MultiUserXferObj)object).setAddSolarisUser(true);
        String string = userObj.getUserType();
        if (string.equals("Solaris and PC NetLink")) {
            ((MultiUserXferObj)object).setAddPDCUser(false);
        }
        ((MultiUserXferObj)object).setAddType(0);
        ((MultiUserXferObj)object).setUserNames(new Vector(vector.size()));
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            UserObj userObj2 = (UserObj)enumeration.nextElement();
            ((MultiUserXferObj)object).addUserName(userObj2.getUserName());
            ((MultiUserXferObj)object).addUserDescription(userObj2.getUserDescription());
            ((MultiUserXferObj)object).addUID(userObj2.getUserID());
            if (userObj2.getSolHomedirAttr() != null) {
                ((MultiUserXferObj)object).addHDirPath(userObj2.getSolHomedirAttr().getPathname());
            }
            if (userObj2.getSolPasswordAttr() != null) {
                ((MultiUserXferObj)object).addPWD(userObj2.getSolPasswordAttr().getUnixEPasswd());
            } else {
                ((MultiUserXferObj)object).addPWD(null);
            }
            ((MultiUserXferObj)object).addFullName(userObj2.getUserFullName());
            if (userObj2.getSolServicesAttr() != null) {
                ((MultiUserXferObj)object).addUnixShell(userObj2.getSolServicesAttr().getInitialShell());
            }
            if (userObj2.getSolGroupAttr() == null) continue;
            String string2 = null;
            string2 = userObj2.getSolGroupAttr().getPrimaryGroup();
            ((MultiUserXferObj)object).addPrimaryGroup(string2);
        }
        try {
            ((MultiUserXferObj)object).setMailServer(this.getApplicationContext().getMgmtServer());
        }
        catch (Exception exception) {
            this.trace("exception while setting mail server in getUserMuxoData");
        }
        ((MultiUserXferObj)object).setNamePrefix("user");
        ((MultiUserXferObj)object).setNameInitialSuffix(1);
        ((MultiUserXferObj)object).setNameIncrementSuffix(1);
        return object;
    }

    public Vector getUsersFromFile(String string) throws UserException {
        this.trace("READING USER INFO FROM FILE:  " + string);
        File file = null;
        try {
            file = new File(string);
        }
        catch (NullPointerException nullPointerException) {
            this.trace("we had a:  NullPointerException");
            this.printDebugStack(nullPointerException);
        }
        Vector vector = new Vector();
        if (file.canRead()) {
            this.trace("cascadefile is readable");
        } else {
            this.trace("datafile is not readable");
            this.trace("ugh...there appear to be java policy problems");
        }
        FileParser fileParser = new FileParser();
        vector = fileParser.parseOutLines(file);
        Vector<UserObj> vector2 = new Vector<UserObj>();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (string2 == null || string2.equals("") || string2.startsWith("#")) continue;
            UserObj userObj = this.parseLineForUserInfo(string2);
            vector2.addElement(userObj);
        }
        return vector2;
    }

    public void getUsersFromIStream(InputStream inputStream) throws UserException {
        String string = "";
        Vector<UserObj> vector = new Vector<UserObj>();
        this.trace("in getUsersFromIStream");
        if (this.bUsingFileInput) {
            this.trace("READING USER INFO FROM FILE.\n");
            this.trace("leaving getUsersFromIStream");
            return;
        }
        this.trace("READING USER INFO FROM PIPED INPUTSTREAM.\n");
        try {
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            byte by = dataInputStream.readByte();
            char c = (char)by;
            while (by != -1) {
                char c2 = (char)by;
                if (c2 == '\uffffffff') {
                    this.trace("c == -1");
                    break;
                }
                if (c2 == '\n' && c != '\n') {
                    string = String.valueOf(string) + c2;
                    if ((string = string.trim()) != null && !string.equals("") && !string.startsWith("#")) {
                        UserObj userObj = this.parseLineForUserInfo(string);
                        vector.addElement(userObj);
                    }
                    string = "";
                } else if (c2 != '\n' && c2 != '\r') {
                    string = String.valueOf(string) + c2;
                }
                c = c2;
                by = dataInputStream.readByte();
            }
        }
        catch (EOFException eOFException) {
            this.trace("done parsing inputstream date");
        }
        catch (UserException userException) {
            throw userException;
        }
        catch (Exception exception) {
            this.printDebugStack(exception);
            throw new UserMgrCliArgParsingException("EXM_INPUTSTREAM_ERR");
        }
        this.setUserObjs(vector);
        this.trace("leaving getUsersFromIStream");
    }

    private void initCommandLineOptions() {
        ResourceBundle resourceBundle = this.getResourceBundle();
        String string = null;
        coUsername = new CommandLineOption("user_name", ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"arg_required_uname_desc"), "n", 1, false, false, null, false, false);
        coFullName = new CommandLineOption("full_name", ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"arg_fullname_desc"), "F", 1, true, false, null, false, false);
        coPassword = new CommandLineOption("password", ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"arg_password_desc"), "P", 1, true, false, null, true, false);
        coPassword.setSensitive(true);
        coUid = new CommandLineOption("uid", ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"arg_uid_desc"), "u", 1, true, false, null, false, false);
        coComment = new CommandLineOption("description", ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"arg_comment_desc"), "c", 1, true, false, null, false, false);
        coDir = new CommandLineOption("dir", ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"arg_homedir_desc"), "d", 1, true, false, null, false, false);
        coExpire = new CommandLineOption("ddmmyyyy", ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"arg_acct_expire_desc"), "e", 1, true, false, null, false, false);
        coInactive = new CommandLineOption("inactive", ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"arg_daysinactive_desc"), "f", 1, true, false, null, false, false);
        coGid = new CommandLineOption("gid", ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"arg_groupid_desc"), "g", 1, true, false, null, false, false);
        coGroupNames = new CommandLineOption("group_name", ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"arg_groupnames_desc"), "G", 1, true, true, null, false, false);
        coShell = new CommandLineOption("shell", ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"arg_shell_desc"), "s", 1, true, false, (Object)"/sbin/sh", false, false);
        coInputFile = new CommandLineOption("inputFile", ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"arg_inputfile_desc"), "i", 1, true, false, (Object)"", false, false);
        coLogFile = new CommandLineOption("logFile", ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"arg_logfile_desc"), "L", 1, true, false, (Object)"", false, false);
        coTaskFile = new CommandLineOption("task", ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"arg_taskfile_desc"), "K", 1, false, false, (Object)"V", false, true);
        coInputFileType = new CommandLineOption("inputfiletype", ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"arg_inputfiletype_desc"), "MUXO", 0, true, false, (Object)"", false, true);
        coDebug = new CommandLineOption("Debug", ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"arg_debug_desc"), "DEBUG", 0, true, false, (Object)"", false, true);
        coHelp = new CommandLineOption("help", ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"arg_help_desc"), "h", 0, true, false, (Object)"", false, false);
        coHelp.setPriority(true);
        coLongList = new CommandLineOption("long_display", ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"arg_longlist_desc"), "l", 0, true, false, (Object)"", false);
        coTemplate = new CommandLineOption("template", ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"arg_template_desc"), "t", 1, true, false, (Object)"", false, false);
        string = this.UserOrRoleID.equals("role") ? ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"arg_deluser_desc") : ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"arg_delrole_desc");
        coDelRole = new CommandLineOption("delrole", string, "r", 1, true, true, (Object)"", false, false);
        string = this.UserOrRoleID.equals("role") ? ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"arg_adduser_desc") : ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"arg_addrole_desc");
        coAddRole = new CommandLineOption("adduser", string, "a", 1, true, true, (Object)"", false, false);
        coDelProf = new CommandLineOption("delprof", ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"arg_addprof_desc"), "q", 1, true, true, (Object)"", false, false);
        coAddProf = new CommandLineOption("addprof", ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"arg_addprof_desc"), "p", 1, true, true, (Object)"", false, false);
    }

    public boolean isDisplayLongList() {
        return this.bLongList;
    }

    private boolean isValidExpiresDate(String string) {
        boolean bl = true;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        this.trace("in isValidExpiresDate, validating: " + string);
        string = string.trim();
        if (string.length() != 8) {
            bl = false;
        } else {
            string2 = string.substring(0, 2);
            string3 = string.substring(3, 4);
            string4 = string.substring(4);
            n = Integer.parseInt(string2);
            n2 = Integer.parseInt(string4);
            n3 = Integer.parseInt(string3);
            this.trace("Day=" + n + "   Month=" + n3 + "   Year=" + n2);
            String string5 = string;
            int n4 = 0;
            while (n4 < string.length()) {
                char c = string5.charAt(n4);
                if (!Character.isDigit(c)) {
                    bl = false;
                    this.trace("we found a non-digit while parsing date");
                }
                ++n4;
            }
            if (n3 > 12 || n < 1) {
                this.trace("we found invalid month while parsing date");
                bl = false;
            }
            if (n2 > 2037 || n2 < 2000) {
                this.trace("we found invalid year while parsing date");
                bl = false;
            }
            if (n > 31 || n < 1) {
                this.trace("we found invalid day while parsing date");
                bl = false;
            } else {
                switch (n3) {
                    case 4: 
                    case 6: 
                    case 9: 
                    case 11: {
                        if (n <= 30) break;
                        bl = false;
                        this.trace("invalid day: > 30 not allowed");
                        break;
                    }
                    case 2: {
                        if (n2 % 4 == 0) {
                            if (n <= 29) break;
                            bl = false;
                            this.trace("invalid day: > 29 not allowed");
                            break;
                        }
                        if (n <= 28) break;
                        bl = false;
                        this.trace("invalid day: > 28 not allowed");
                        break;
                    }
                }
            }
        }
        return bl;
    }

    public boolean isValidShellEntry(String string) {
        return false;
    }

    private void listAllAccountInfo() throws Exception {
        UserObj userObj = new UserObj();
        Vector vector = this.getUserObjs();
        if (this.UserOrRoleID.equals("normal")) {
            this.trace("viewObjectProps:  listing all users");
            vector = this.getUserMgr().getAllUsers();
        } else {
            this.trace("viewObjectProps:  listing all roles");
            vector = this.getUserMgr().getAllRoles();
        }
        if (vector == null || vector.size() == 0) {
            String string = userObj.getUserType();
            String string2 = null;
            if (this.UserOrRoleID.equals("normal")) {
                this.trace("There are no User accounts");
                string2 = ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"no_user_accounts");
                System.out.println(string2);
            } else {
                this.trace("There are no Role accounts");
                string2 = ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"no_role_accounts");
                System.out.println(string2);
            }
        } else {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                userObj = (UserObj)enumeration.nextElement();
                if (this.isDisplayLongList()) {
                    userObj = this.getUserMgr().getFullAttributes(userObj);
                }
                this.viewUserOutput(userObj);
            }
        }
    }

    private void logBulkOperationResults(int n, Vector vector, Vector vector2) {
        String string = null;
        String string2 = null;
        String string3 = null;
        int n2 = vector.size();
        int n3 = vector2.size();
        int n4 = n - n2 - n3;
        String string4 = "";
        String string5 = ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"START_SUMMARY");
        this.cascade_logging(string5);
        String string6 = String.valueOf(ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"total_users")) + new Integer(n).toString();
        this.cascade_logging(string6);
        switch (this.getOperation()) {
            case 4: {
                string4 = ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"bulk_add_summary");
                string = ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"partial_users_added");
                string2 = ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"failed_users_added");
                string3 = ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"users_added");
                break;
            }
            case 5: {
                string4 = ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"bulk_del_summary");
                string = ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"partial_users_deleted");
                string2 = ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"failed_users_deleted");
                string3 = ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"users_deleted");
                break;
            }
            case 6: {
                string4 = ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"bulk_mod_summary");
                string = ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"partial_users_mod");
                string2 = ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"failed_users_mod");
                string3 = ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"users_mod");
                break;
            }
        }
        string = String.valueOf(string) + new Integer(n2).toString();
        this.cascade_logging(string);
        String string7 = "";
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            string7 = String.valueOf(string7) + "   " + (String)enumeration.nextElement() + "\n";
        }
        this.cascade_logging(string7);
        string2 = String.valueOf(string2) + new Integer(n3).toString();
        this.cascade_logging(string2);
        String string8 = "";
        Enumeration enumeration2 = vector2.elements();
        while (enumeration2.hasMoreElements()) {
            string8 = String.valueOf(string8) + "   " + (String)enumeration2.nextElement() + "\n";
        }
        this.cascade_logging(string8);
        string3 = String.valueOf(string3) + new Integer(n4).toString();
        this.cascade_logging(string3);
        string5 = ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"END_SUMMARY");
        this.cascade_logging(string5);
        String string9 = String.valueOf(string6) + "\n" + string3 + "\n" + string + "\n" + string7 + "\n" + string2 + "\n" + string8;
        this.writeServerSideLog(string4, string9, 0);
    }

    public void modifyMultiObjects() throws UserException {
        try {
            this.trace("RUNNING:");
            String string = ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"START_MULTIMOD_LOG");
            this.cascade_logging(string);
            string = ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"START_DETAILS");
            this.cascade_logging(string);
            this.writeLoggingDate();
            MultiUserXferObj multiUserXferObj = this.getMuxoBasedOnInput();
            this.doMultiUserMod(multiUserXferObj);
            this.trace("done calling doMultiUserMod");
            try {
                File file = new File(this.getInputDataFile());
                file.delete();
            }
            catch (Exception exception) {}
            this.writeLoggingDate();
            string = ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"END_MULTIMOD_LOG");
            this.cascade_logging(string);
        }
        catch (Exception exception) {
            this.printDebugStack(exception);
            throw new UserException("EXM_AMU1M");
        }
    }

    public void modifyObject() throws Exception {
        try {
            Vector vector = this.getUserObjs();
            UserObj userObj = (UserObj)vector.elementAt(0);
            if (this.getUserMgr() == null) {
                this.trace("in modifyObject:  usermgr is null!");
                throw new UserException("EXM_CLI_NO_SERVICE");
            }
            if (this.getDebugStatus()) {
                this.dumpObjectContents(userObj);
            }
            this.trace("modifying account:  " + userObj.getUserName());
            UserObj userObj2 = new UserObj(this.getOldUserName());
            userObj2 = this.getUserMgr().getFullAttributes(userObj2);
            this.getUserMgr().modifyUser(userObj, userObj2);
        }
        catch (SolServerPartialSuccessException solServerPartialSuccessException) {
            this.trace("Partial success error");
            throw new UserException("EXM_CLI_PARTIAL_MOD", solServerPartialSuccessException.getLocalizedMessage());
        }
        catch (Exception exception) {
            this.trace("exception in modifyObject(): " + exception.getMessage());
            this.printDebugStack(exception);
            throw exception;
        }
    }

    private void parseAndValidateArgs(String[] stringArray) throws Exception {
        boolean bl = false;
        String string = "";
        String string2 = "";
        switch (this.getOperation()) {
            case 0: {
                this.bUsingPipesOrFiles = false;
                if (this.UserOrRoleID.equals("role")) {
                    string = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"smroleadd_name");
                    string2 = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"smroleadd_desc");
                } else {
                    string = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"smuseradd_name");
                    string2 = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"smuseradd_desc");
                }
                this.checkForAddOptions(stringArray, string, string2);
                break;
            }
            case 4: {
                this.bUsingPipesOrFiles = true;
                string = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"smmuseradd_name");
                string2 = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"smmusradd_desc");
                this.checkForMultiAddOptions(stringArray, string, string2);
                break;
            }
            case 5: {
                this.bUsingPipesOrFiles = true;
                string = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"smmuserdel_name");
                string2 = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"smmusrdel_desc");
                this.checkForMultiDelOptions(stringArray, string, string2);
                break;
            }
            case 6: {
                this.bUsingPipesOrFiles = true;
                string = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"smmusermod_name");
                string2 = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"smmusrmod_desc");
                this.checkForMultiModOptions(stringArray, string, string2);
                break;
            }
            case 1: {
                this.bUsingPipesOrFiles = false;
                if (this.UserOrRoleID.equals("role")) {
                    string = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"smroledel_name");
                    string2 = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"smroledel_desc");
                } else {
                    string = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"smuserdel_name");
                    string2 = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"smuserdel_desc");
                }
                this.checkForDeleteOptions(stringArray, string, string2);
                break;
            }
            case 2: {
                this.bUsingPipesOrFiles = false;
                if (this.UserOrRoleID.equals("role")) {
                    string = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"smrolemod_name");
                    string2 = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"smrolemod_desc");
                } else {
                    string = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"smusermod_name");
                    string2 = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"smusermod_desc");
                }
                this.checkForModifyOptions(stringArray, string, string2);
                break;
            }
            case 3: {
                this.bUsingPipesOrFiles = false;
                if (this.UserOrRoleID.equals("role")) {
                    string = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"smrolels_name");
                    string2 = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"smrolels_desc");
                } else {
                    string = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"smuserls_name");
                    string2 = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"smuserls_desc");
                }
                this.checkForViewOptions(stringArray, string, string2);
                break;
            }
            default: {
                this.trace("couldn't recognize TASK switch:  " + this.getOperation());
                throw new UserException("EXM_CLI_SCRIPT_ERR");
            }
        }
    }

    public UserObj parseXAddOptions(Vector vector, UserObj userObj) throws UserException {
        return userObj;
    }

    private UserObj parseXDelOptions(Vector vector, UserObj userObj) throws UserException {
        boolean bl = false;
        int n = 0;
        String string = "";
        String string2 = "";
        String string3 = "";
        if (userObj == null) {
            userObj = new UserObj();
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            string = string.trim();
            n = string.indexOf("=");
            string3 = string.substring(n + 1, string.length());
            string3 = string3.trim();
            if ((string = string.substring(0, n)).compareTo(ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"xprop_rmmail")) == 0) {
                userObj = this.setXOptionRmmail(string3, userObj);
                continue;
            }
            throw new UserException("EXM_CLI_UNKNOWN_X_ARG");
        }
        return userObj;
    }

    public UserObj parseXModifyOptions(Vector vector, UserObj userObj) throws UserException {
        return userObj;
    }

    public int runCommandLine(String[] stringArray, InputStream inputStream, PrintStream printStream, PrintStream printStream2) {
        int n = 0;
        this.userName = this.getAuthenticatedUser();
        ToolInfrastructure toolInfrastructure = this.getToolInfrastructure();
        try {
            this.tsService = (TrustedSolarisServiceInterface)toolInfrastructure.getServiceByName("com.sun.admin.tsol.server.TrustedSolarisService");
            this.tsolDefaults = this.tsService.getDefaultTsolInfo(this.userName);
        }
        catch (Exception exception) {
            this.trace("got exception in getting TrustedSolarisService");
            String string = exception.getLocalizedMessage();
            this.handleErrors(string);
            return 2;
        }
        this.input = inputStream;
        this.output = printStream;
        try {
            this.trace("calling initCommandLineOptions");
            this.initCommandLineOptions();
            this.trace("calling doFirstArgPass");
            this.doFirstArgPass(stringArray);
            this.initCommandLineOptions();
            this.parseAndValidateArgs(stringArray);
            int n2 = this.getOperation();
            if ((n2 == 4 || n2 == 5 || n2 == 6) && inputStream != null) {
                this.getUsersFromIStream(inputStream);
            }
        }
        catch (UserMgrCliHelpException userMgrCliHelpException) {
            this.trace("got UserMgrCliHelpException in runCommandLine");
            return 0;
        }
        catch (UserMgrCliArgParsingException userMgrCliArgParsingException) {
            String string = userMgrCliArgParsingException.getLocalizedMessage();
            this.handleErrors(string);
            return 1;
        }
        catch (UserException userException) {
            this.trace("got UserException in runCommandLine");
            String string = userException.getLocalizedMessage();
            this.handleErrors(string);
            return 2;
        }
        catch (Exception exception) {
            this.trace("got a unrecognized Exception in runCommandLine");
            String string = exception.getLocalizedMessage();
            this.handleErrors(string);
            this.printDebugStack(exception);
            return 2;
        }
        try {
            this.doOperation();
        }
        catch (UserException userException) {
            this.trace("runCommandLine, UserException:  " + userException.getLocalizedMessage());
            this.handleErrors(userException.getLocalizedMessage());
            n = 2;
        }
        catch (AdminException adminException) {
            this.trace("runCommandLine, AdminException:  " + adminException.getLocalizedMessage());
            this.handleErrors(adminException.getLocalizedMessage());
            n = 2;
        }
        catch (Exception exception) {
            this.trace("runCommandLine, Exception:  " + exception.getLocalizedMessage());
            this.handleErrors(exception.getLocalizedMessage());
            this.printDebugStack(exception);
            n = 2;
        }
        return n;
    }

    private UserObj setAccountAttr(UserObj userObj, UserObj userObj2) throws Exception {
        SolAccountAttr solAccountAttr = new SolAccountAttr();
        SolAccountAttr solAccountAttr2 = userObj.getSolAccountAttr();
        SolAccountAttr solAccountAttr3 = null;
        if (userObj2 != null) {
            solAccountAttr3 = userObj2.getSolAccountAttr();
        }
        if (userObj2 != null && solAccountAttr3 != null) {
            String string = solAccountAttr3.getAccountExpires();
            solAccountAttr.setAccountExpires(string);
            solAccountAttr.setAccountIsLocked(false);
        }
        if (userObj2 != null && solAccountAttr2 != null) {
            if (solAccountAttr2.getAccountExpires() != null) {
                solAccountAttr.setAccountExpires(solAccountAttr2.getAccountExpires());
            }
            solAccountAttr.setAccountIsLocked(solAccountAttr2.isAccountLocked());
        }
        userObj.setSolAccountAttr(solAccountAttr);
        return userObj;
    }

    private UserObj setAddProfNames(UserObj userObj, Vector vector) {
        UserAttrObj userAttrObj = userObj.getSolAuthAttrs();
        if (userAttrObj == null) {
            userAttrObj = new UserAttrObj();
        }
        String[] stringArray = this.VectorToStrArray(vector);
        userAttrObj.addProfNames(stringArray);
        userObj.setSolAuthAttrs(userAttrObj);
        return userObj;
    }

    private UserObj setAddRoleNames(UserObj userObj, Vector vector) {
        UserAttrObj userAttrObj = userObj.getSolAuthAttrs();
        if (userAttrObj == null) {
            userAttrObj = new UserAttrObj();
        }
        if (!this.UserOrRoleID.equals("role")) {
            String[] stringArray = this.VectorToStrArray(vector);
            userAttrObj.addRoleNames(stringArray);
        } else {
            userAttrObj.addAttribute("members", vector);
        }
        userObj.setSolAuthAttrs(userAttrObj);
        return userObj;
    }

    private UserObj setDefaultData() {
        Object object;
        UserObj userObj = new UserObj();
        try {
            object = this.getUserMgr().getNextAvailableUID();
            userObj.setUserID((String)object);
        }
        catch (AdminException adminException) {
            this.trace("couldn't get next avail uid so defaulting to 100");
            userObj.setUserID("100");
        }
        object = new SolHomedirAttr();
        SolPasswordAttr solPasswordAttr = new SolPasswordAttr();
        SolGroupAttr solGroupAttr = new SolGroupAttr();
        SolAccountAttr solAccountAttr = new SolAccountAttr();
        SolServicesAttr solServicesAttr = new SolServicesAttr();
        UserAttrObj userAttrObj = new UserAttrObj();
        ((SolHomedirAttr)object).setServer(this.getApplicationContext().getMgmtServer());
        ((SolHomedirAttr)object).setPathname(SolHomedirAttr.DEFAULT_HOME_DIRECTORY_PREFIX);
        ((SolHomedirAttr)object).setAutomount(true);
        solPasswordAttr.setHasPassword(false);
        String string = this.getApplicationContext().getMgmtServer();
        solServicesAttr.setMailServer(string);
        userObj.setDelMBox(false);
        userObj.setDelHomeDir(false);
        if (this.UserOrRoleID.equals("role")) {
            solGroupAttr.setPrimaryGroup("14");
        } else {
            solGroupAttr.setPrimaryGroup("10");
        }
        solGroupAttr.setSecondaryGroups(null);
        if (this.UserOrRoleID.equals("role")) {
            solServicesAttr.setInitialShell("/bin/pfsh");
        } else {
            solServicesAttr.setInitialShell("/bin/sh");
        }
        userObj.setSolGroupAttr(solGroupAttr);
        userObj.setSolHomedirAttr((SolHomedirAttr)object);
        userObj.setSolPasswordAttr(solPasswordAttr);
        userObj.setSolAccountAttr(solAccountAttr);
        userObj.setSolServicesAttr(solServicesAttr);
        if (this.UserOrRoleID.equals("role")) {
            userObj.setSolAuthAttrs(userAttrObj);
        }
        this.setDefaultUserData(userObj);
        return userObj;
    }

    private void setDefaultTemplatename(String string) {
        this.defaultTemplate = string;
    }

    private void setDefaultUserData(UserObj userObj) {
        this.defaultObjSettings = userObj;
    }

    private UserObj setDelProfNames(UserObj userObj, Vector vector) {
        UserAttrObj userAttrObj = userObj.getSolAuthAttrs();
        if (userAttrObj == null) {
            userAttrObj = new UserAttrObj();
        }
        String[] stringArray = this.VectorToStrArray(vector);
        userAttrObj.delProfNames(stringArray);
        userObj.setSolAuthAttrs(userAttrObj);
        userObj.setSolAuthAttrs(userAttrObj);
        return userObj;
    }

    private UserObj setDelRoleNames(UserObj userObj, Vector vector) {
        UserAttrObj userAttrObj = userObj.getSolAuthAttrs();
        if (userAttrObj == null) {
            this.trace("attrObj was null");
            userAttrObj = new UserAttrObj();
        }
        if (!this.UserOrRoleID.equals("role")) {
            String[] stringArray = this.VectorToStrArray(vector);
            userAttrObj.delRoleNames(stringArray);
        } else {
            userAttrObj.delAttribute("members", vector);
        }
        userObj.setSolAuthAttrs(userAttrObj);
        return userObj;
    }

    public void setDisplayLongList(boolean bl) {
        this.bLongList = bl;
    }

    private UserObj setGroupAttr(UserObj userObj, UserObj userObj2) throws Exception {
        SolGroupAttr solGroupAttr = new SolGroupAttr();
        SolGroupAttr solGroupAttr2 = userObj.getSolGroupAttr();
        SolGroupAttr solGroupAttr3 = null;
        if (userObj2 != null) {
            solGroupAttr3 = userObj2.getSolGroupAttr();
        }
        if (userObj2 != null && solGroupAttr3 != null) {
            solGroupAttr.setPrimaryGroup(solGroupAttr3.getPrimaryGroup());
            solGroupAttr.setNumberSecondaryGroups(0);
        }
        if (userObj2 != null && solGroupAttr2 != null) {
            if (solGroupAttr2.getPrimaryGroup() != null) {
                solGroupAttr.setPrimaryGroup(solGroupAttr2.getPrimaryGroup());
            }
            if (solGroupAttr2.getNumberSecondaryGroups() > 0) {
                solGroupAttr.setNumberSecondaryGroups(solGroupAttr2.getNumberSecondaryGroups());
                solGroupAttr.setSecondaryGroups(solGroupAttr2.getSecondaryGroups());
            }
        }
        userObj.setSolGroupAttr(solGroupAttr);
        return userObj;
    }

    private UserObj setHomeDirAttr(UserObj userObj, UserObj userObj2) throws Exception {
        String string = SolHomedirAttr.DEFAULT_HOME_DIRECTORY_PREFIX;
        if (userObj2 != null) {
            SolHomedirAttr solHomedirAttr = new SolHomedirAttr();
            if (userObj2.getSolHomedirAttr() != null) {
                string = userObj2.getSolHomedirAttr().getPathname();
            }
            if (string != null) {
                if (!string.endsWith(File.separator)) {
                    string = string.concat(File.separator);
                }
            } else {
                string = SolHomedirAttr.DEFAULT_HOME_DIRECTORY_PREFIX;
            }
            string = String.valueOf(string) + userObj.getUserName();
            this.trace("homepath = " + string);
            solHomedirAttr.setPathname(string);
            String string2 = "";
            SolHomedirAttr solHomedirAttr2 = userObj2.getSolHomedirAttr();
            if (solHomedirAttr2 != null) {
                string2 = solHomedirAttr2.getServer();
                solHomedirAttr.setAutomount(solHomedirAttr2.getAutomount());
            } else {
                solHomedirAttr.setAutomount(false);
            }
            SolServicesAttr solServicesAttr = userObj2.getSolServicesAttr();
            String string3 = solServicesAttr != null ? solServicesAttr.getMailServer() : this.getApplicationContext().getMgmtServer();
            String string4 = "";
            string4 = string2 != null && !string2.equals("") ? string2 : (this.isLocalScope() ? this.getMgmtServer() : (string3 != null && !string3.equals("") ? string3 : this.getMgmtServer()));
            solHomedirAttr.setServer(string4);
            this.trace("homeDirServer = " + string4);
            Permissions permissions = userObj.getSolHomedirAttr().getPerms();
            if (permissions != null) {
                solHomedirAttr.setPerms(permissions);
            }
            userObj.setSolHomedirAttr(solHomedirAttr);
        }
        return userObj;
    }

    private UserObj setInitialUserRoleNames(UserObj userObj, Vector vector) {
        UserAttrObj userAttrObj = userObj.getSolAuthAttrs();
        if (userAttrObj == null) {
            userAttrObj = new UserAttrObj();
        }
        if (!this.UserOrRoleID.equals("role")) {
            userAttrObj.setRoleNamesVector(vector);
        } else {
            userAttrObj.setAttribute("members", vector);
        }
        userObj.setSolAuthAttrs(userAttrObj);
        return userObj;
    }

    private UserObj setMuxoAccountAttr(MultiUserXferObj multiUserXferObj, UserObj userObj) {
        SolAccountAttr solAccountAttr = userObj.getSolAccountAttr();
        if (solAccountAttr == null) {
            solAccountAttr = new SolAccountAttr();
            userObj.setSolAccountAttr(solAccountAttr);
        }
        solAccountAttr.setAccountExpires(multiUserXferObj.getPWDExpiresDate());
        userObj.setSolAccountAttr(solAccountAttr);
        return userObj;
    }

    private UserObj setMuxoHomeDir(MultiUserXferObj multiUserXferObj, UserObj userObj, String string) {
        String string2;
        String string3 = null;
        String string4 = userObj.getTemplateName();
        boolean bl = false;
        boolean bl2 = false;
        SolHomedirAttr solHomedirAttr = new SolHomedirAttr();
        if (string4 != null && !string4.equals("")) {
            bl = true;
        }
        if (string != null && !string.equals("") || multiUserXferObj.getHDirPath() != null && !multiUserXferObj.getHDirPath().equals("")) {
            bl2 = true;
        }
        if (!bl || bl2) {
            if (string != null && !string.equals("")) {
                string3 = string;
            } else {
                string2 = null;
                string2 = multiUserXferObj.getHDirPath() == null || multiUserXferObj.getHDirPath().equals("") ? new String(SolHomedirAttr.DEFAULT_HOME_DIRECTORY_PREFIX) : new String(multiUserXferObj.getHDirPath());
                if (!string2.endsWith(File.separator)) {
                    string2 = string2.concat(File.separator);
                }
                string3 = String.valueOf(string2) + userObj.getUserName();
            }
            solHomedirAttr.setPathname(string3);
        }
        solHomedirAttr.setAutomount(multiUserXferObj.getHDirAutomount());
        solHomedirAttr.setForceModify(true);
        try {
            string2 = multiUserXferObj.getHDirServer();
            if (string2 != null && !string2.trim().equals("")) {
                solHomedirAttr.setServer(string2);
            } else {
                solHomedirAttr.setServer(this.getApplicationContext().getMgmtServer());
            }
        }
        catch (Exception exception) {
            solHomedirAttr.setServer(multiUserXferObj.getHDirServer());
        }
        userObj.setSolHomedirAttr(solHomedirAttr);
        return userObj;
    }

    private UserObj setMuxoPasswd(MultiUserXferObj multiUserXferObj, UserObj userObj) throws UserException {
        this.trace("enterred setMuxoPasswd");
        SolPasswordAttr solPasswordAttr = new SolPasswordAttr();
        solPasswordAttr.setMustChangeDays(multiUserXferObj.getPWDChangeDays());
        solPasswordAttr.setAlertChangeDays(multiUserXferObj.getPWDAlertDays());
        solPasswordAttr.setCannotChangeDays(multiUserXferObj.getPWDReuseDays());
        solPasswordAttr.setInactiveDays(multiUserXferObj.getPWDIdleDays());
        userObj.setSolPasswordAttr(solPasswordAttr);
        if (multiUserXferObj.getHashPswd() != null && multiUserXferObj.getHashPswd().length() > 0) {
            try {
                String string = AdminSecurityUtil.unhashPassword((String)multiUserXferObj.getHashPswd());
                userObj = this.getUserMgr().setUpPassword(string, userObj);
            }
            catch (Exception exception) {
                this.trace("problem setting password");
                throw new UserException("EXM_CLI_USER_BADPWD");
            }
        } else {
            solPasswordAttr.setHasPassword(false);
            userObj.setSolPasswordAttr(solPasswordAttr);
        }
        this.trace("leaving setMuxoPasswd");
        return userObj;
    }

    private void setOldUserName(String string) {
        this.strOldName = string;
    }

    private UserObj setPassAttr(UserObj userObj, UserObj userObj2) throws Exception {
        this.trace("in setPassAttr");
        SolPasswordAttr solPasswordAttr = userObj.getSolPasswordAttr();
        SolPasswordAttr solPasswordAttr2 = new SolPasswordAttr();
        SolPasswordAttr solPasswordAttr3 = null;
        if (userObj2 != null) {
            solPasswordAttr3 = userObj2.getSolPasswordAttr();
        }
        if (userObj2 != null) {
            if (solPasswordAttr3 != null) {
                solPasswordAttr2.setMustChangeDays(solPasswordAttr3.getMustChangeDays());
                solPasswordAttr2.setAlertChangeDays(solPasswordAttr3.getAlertChangeDays());
                solPasswordAttr2.setCannotChangeDays(solPasswordAttr3.getCannotChangeDays());
                solPasswordAttr2.setInactiveDays(solPasswordAttr3.getInactiveDays());
            } else {
                solPasswordAttr2.setMustChangeDays(null);
                solPasswordAttr2.setAlertChangeDays(null);
                solPasswordAttr2.setCannotChangeDays(null);
                solPasswordAttr2.setInactiveDays(null);
            }
        }
        if (userObj2 != null && solPasswordAttr != null) {
            this.trace("defUserObj != null  &&  userAttrs != null");
            if (solPasswordAttr.getMustChangeDays() != null) {
                solPasswordAttr2.setMustChangeDays(solPasswordAttr.getMustChangeDays());
            }
            if (solPasswordAttr.getAlertChangeDays() != null) {
                solPasswordAttr2.setAlertChangeDays(solPasswordAttr.getAlertChangeDays());
            }
            if (solPasswordAttr.getAlertChangeDays() != null) {
                solPasswordAttr2.setCannotChangeDays(solPasswordAttr.getCannotChangeDays());
            }
            if (solPasswordAttr.getAlertChangeDays() != null) {
                solPasswordAttr2.setInactiveDays(solPasswordAttr.getInactiveDays());
            }
            if (solPasswordAttr.getUnixEPasswd() != null) {
                solPasswordAttr2.setUnixEPasswd(solPasswordAttr.getUnixEPasswd());
            }
            solPasswordAttr2.setChangePassword(solPasswordAttr.hasPasswordChanged());
            solPasswordAttr2.setHasPassword(solPasswordAttr.isThereAPassword());
        }
        userObj.setSolPasswordAttr(solPasswordAttr2);
        return userObj;
    }

    private UserObj setPrimaryGroup(UserObj userObj, String string) {
        SolGroupAttr solGroupAttr = userObj.getSolGroupAttr();
        if (solGroupAttr == null) {
            solGroupAttr = new SolGroupAttr();
        }
        solGroupAttr.setPrimaryGroup(string);
        userObj.setSolGroupAttr(solGroupAttr);
        return userObj;
    }

    private UserObj setProfNameVector(UserObj userObj, Vector vector) {
        UserAttrObj userAttrObj = userObj.getSolAuthAttrs();
        if (userAttrObj == null) {
            userAttrObj = new UserAttrObj();
        }
        userAttrObj.setProfNamesVector(vector);
        userObj.setSolAuthAttrs(userAttrObj);
        return userObj;
    }

    private UserObj setSecondaryGroupData(Vector vector, UserObj userObj) {
        String[] stringArray = new String[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            stringArray[n] = (String)vector.elementAt(n);
            this.trace("group[" + n + "] = " + stringArray[n]);
            ++n;
        }
        SolGroupAttr solGroupAttr = userObj.getSolGroupAttr();
        if (solGroupAttr == null) {
            solGroupAttr = new SolGroupAttr();
        }
        solGroupAttr.setSecondaryGroups(stringArray);
        solGroupAttr.setNumberSecondaryGroups(vector.size());
        userObj.setSolGroupAttr(solGroupAttr);
        return userObj;
    }

    private UserObj setServiceAttr(UserObj userObj, UserObj userObj2) throws Exception {
        SolServicesAttr solServicesAttr = new SolServicesAttr();
        SolServicesAttr solServicesAttr2 = userObj.getSolServicesAttr();
        SolServicesAttr solServicesAttr3 = null;
        if (userObj2 != null) {
            solServicesAttr3 = userObj2.getSolServicesAttr();
        }
        if (userObj2 != null && solServicesAttr3 != null) {
            solServicesAttr.setInitialShell(solServicesAttr3.getInitialShell());
            solServicesAttr.setMailServer(solServicesAttr3.getMailServer());
        }
        if (userObj2 != null && solServicesAttr2 != null) {
            if (solServicesAttr2.getInitialShell() != null) {
                solServicesAttr.setInitialShell(solServicesAttr2.getInitialShell());
            }
            if (solServicesAttr2.getMailServer() != null) {
                solServicesAttr.setMailServer(solServicesAttr2.getMailServer());
            } else {
                solServicesAttr.setMailServer(this.getApplicationContext().getMgmtServer());
            }
        }
        userObj.setSolServicesAttr(solServicesAttr);
        return userObj;
    }

    protected UserObj setXOptionAutohome(String string, UserObj userObj) throws UserException {
        boolean bl = false;
        String string2 = ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"common_xprop_yes");
        String string3 = ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"common_xprop_no");
        if (string.equals(string2)) {
            bl = true;
        } else if (string.equals(string3)) {
            bl = false;
        } else {
            throw new UserException("EXM_CLI_BAD_AUTOHOME");
        }
        SolHomedirAttr solHomedirAttr = userObj.getSolHomedirAttr();
        if (solHomedirAttr == null) {
            solHomedirAttr = new SolHomedirAttr();
        }
        solHomedirAttr.setAutomount(bl);
        userObj.setSolHomedirAttr(solHomedirAttr);
        return userObj;
    }

    protected UserObj setXOptionCred(String string, UserObj userObj) throws UserException {
        boolean bl = true;
        bl = string.compareTo(ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"common_xprop_yes")) == 0;
        return userObj;
    }

    protected UserObj setXOptionMail(String string, UserObj userObj) throws UserException {
        SolServicesAttr solServicesAttr = userObj.getSolServicesAttr();
        if (solServicesAttr == null) {
            solServicesAttr = new SolServicesAttr();
        }
        solServicesAttr.setMailServer(string);
        userObj.setSolServicesAttr(solServicesAttr);
        return userObj;
    }

    protected UserObj setXOptionPW(String string, UserObj userObj) {
        SolAccountAttr solAccountAttr;
        String string2 = null;
        this.trace("in setXOptionPW");
        SolPasswordAttr solPasswordAttr = userObj.getSolPasswordAttr();
        if (solPasswordAttr == null) {
            solPasswordAttr = new SolPasswordAttr();
        }
        if ((solAccountAttr = userObj.getSolAccountAttr()) != null) {
            string2 = solAccountAttr.getAccountExpires();
        } else {
            solAccountAttr = new SolAccountAttr();
        }
        if (string.indexOf("CLR") != -1) {
            solPasswordAttr.setHasPassword(false);
        }
        if (string.indexOf("LOCK") != -1) {
            if (string2 == null || string2.equals("")) {
                solAccountAttr.setAccountIsLocked(true);
            } else {
                solAccountAttr.setAccountIsLocked(false);
            }
        }
        if (string.indexOf("NONE") != -1) {
            solPasswordAttr.setHasPassword(false);
            if (string2 == null || string2.equals("")) {
                solAccountAttr.setAccountIsLocked(true);
            } else {
                solAccountAttr.setAccountIsLocked(false);
            }
        }
        if (string.indexOf("NORM") != -1) {
            solPasswordAttr.setHasPassword(true);
        }
        userObj.setSolPasswordAttr(solPasswordAttr);
        userObj.setSolAccountAttr(solAccountAttr);
        return userObj;
    }

    protected UserObj setXOptionPerm(String string, UserObj userObj) throws UserException {
        Permissions permissions;
        this.trace("in setXOptionPerm()");
        if (string.length() != 3 && string.length() != 4) {
            throw new UserException("EXM_CLI_USER_BADPERMS");
        }
        SolHomedirAttr solHomedirAttr = userObj.getSolHomedirAttr();
        if (solHomedirAttr == null) {
            solHomedirAttr = new SolHomedirAttr();
        }
        if ((permissions = solHomedirAttr.getPerms()) == null) {
            permissions = new Permissions();
        }
        if (string.length() == 3) {
            int n = Integer.parseInt(string.substring(0, 1), 8);
            permissions.setOwner(n);
            n = Integer.parseInt(string.substring(1, 2), 8);
            permissions.setGroup(n);
            n = Integer.parseInt(string.substring(2, 3), 8);
            permissions.setWorld(n);
        } else {
            int n = Integer.parseInt(string.substring(0, 2), 8);
            permissions.setOwner(n);
            n = Integer.parseInt(string.substring(2, 3), 8);
            permissions.setGroup(n);
            n = Integer.parseInt(string.substring(3, 4), 8);
            permissions.setWorld(n);
        }
        solHomedirAttr.setPerms(permissions);
        userObj.setSolHomedirAttr(solHomedirAttr);
        this.trace("leaving setXOptionPerm()");
        return userObj;
    }

    protected UserObj setXOptionPwmax(String string, UserObj userObj) throws UserException {
        SolPasswordAttr solPasswordAttr = userObj.getSolPasswordAttr();
        if (solPasswordAttr == null) {
            solPasswordAttr = new SolPasswordAttr();
            solPasswordAttr.setHasPassword(false);
        }
        solPasswordAttr.setCannotChangeDays(string);
        userObj.setSolPasswordAttr(solPasswordAttr);
        int n = Integer.parseInt(string);
        if (n < 0 || n > 730) {
            throw new UserException("EXM_CLI_INVALID_PWMAX");
        }
        return userObj;
    }

    protected UserObj setXOptionPwmin(String string, UserObj userObj) throws UserException {
        SolPasswordAttr solPasswordAttr = userObj.getSolPasswordAttr();
        if (solPasswordAttr == null) {
            solPasswordAttr = new SolPasswordAttr();
            solPasswordAttr.setHasPassword(true);
        }
        solPasswordAttr.setMustChangeDays(string);
        userObj.setSolPasswordAttr(solPasswordAttr);
        int n = Integer.parseInt(string);
        if (n < 0 || n > 730) {
            throw new UserException("EXM_CLI_INVALID_PWMIN");
        }
        return userObj;
    }

    protected UserObj setXOptionPwwarn(String string, UserObj userObj) throws UserException {
        SolPasswordAttr solPasswordAttr = userObj.getSolPasswordAttr();
        if (solPasswordAttr == null) {
            solPasswordAttr = new SolPasswordAttr();
            solPasswordAttr.setHasPassword(false);
        }
        solPasswordAttr.setAlertChangeDays(string);
        userObj.setSolPasswordAttr(solPasswordAttr);
        int n = Integer.parseInt(string);
        if (n < 0 || n > 730) {
            throw new UserException("EXM_CLI_INVALID_PWWARN");
        }
        return userObj;
    }

    protected UserObj setXOptionRmmail(String string, UserObj userObj) throws UserException {
        if (string.compareTo(ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"common_xprop_yes")) == 0) {
            userObj.setDelMBox(true);
        } else {
            userObj.setDelMBox(false);
        }
        return userObj;
    }

    protected UserObj setXOptionServ(String string, UserObj userObj) throws UserException {
        if (!CheckSyntax.isHomeDirServerOK((String)string)) {
            throw new UserException("EXM_CLI_INVALID_HDIRSERVER", CheckSyntax.getErrorString());
        }
        SolHomedirAttr solHomedirAttr = userObj.getSolHomedirAttr();
        if (solHomedirAttr == null) {
            solHomedirAttr = new SolHomedirAttr();
        }
        solHomedirAttr.setServer(string);
        userObj.setSolHomedirAttr(solHomedirAttr);
        return userObj;
    }

    protected UserObj setXOptionTsolClearance(String string, UserObj userObj) throws UserException {
        Object object;
        String string2 = null;
        try {
            if (string.startsWith("0x")) {
                object = this.tsService.hexClearanceToString(string, this.userName);
                string2 = string;
            } else {
                string2 = this.tsService.stringClearanceToHex(string, this.userName);
            }
        }
        catch (BadLabelException badLabelException) {
            String string3 = String.valueOf(badLabelException.getErrorCode());
            throw new UserException("EXM_CLI_TSOL_BAD_CLEARANCE_ERROR", string, string3);
        }
        catch (Exception exception) {
            throw new UserException("EXM_CLI_TSOL_CLEARANCE_UPDATE_ERROR");
        }
        object = userObj.getSolAuthAttrs();
        if (object == null) {
            object = new UserAttrObj();
        }
        object.setAttribute("clearance", string2);
        userObj.setSolAuthAttrs((UserAttrObj)object);
        return userObj;
    }

    protected UserObj setXOptionTsolIdleCmd(String string, UserObj userObj) throws UserException {
        String string2 = null;
        String string3 = ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"xprop_tsol_idlecmd_LOCK");
        String string4 = ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"xprop_tsol_idlecmd_LOGOUT");
        if (string.compareTo(string3) == 0) {
            this.trace("setting idlecmd = lock");
            string2 = "lock";
        } else if (string.compareTo(string4) == 0) {
            this.trace("setting idlecmd = logout");
            string2 = "logout";
        } else {
            throw new UserException("EXM_CLI_TSOL_BAD_IDLECMD", string);
        }
        UserAttrObj userAttrObj = userObj.getSolAuthAttrs();
        if (userAttrObj == null) {
            userAttrObj = new UserAttrObj();
        }
        userAttrObj.setAttribute("idlecmd", string2);
        userObj.setSolAuthAttrs(userAttrObj);
        return userObj;
    }

    protected UserObj setXOptionTsolIdleTime(String string, UserObj userObj) throws UserException {
        int n = -1;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            throw new UserException("EXM_CLI_TSOL_BAD_IDLETIME", string);
        }
        if (n < 0 || n > 120) {
            throw new UserException("EXM_CLI_TSOL_BAD_IDLETIME", string);
        }
        UserAttrObj userAttrObj = userObj.getSolAuthAttrs();
        if (userAttrObj == null) {
            userAttrObj = new UserAttrObj();
        }
        userAttrObj.setAttribute("idletime", string);
        userObj.setSolAuthAttrs(userAttrObj);
        return userObj;
    }

    protected UserObj setXOptionTsolLabel(String string, UserObj userObj) throws UserException {
        Object object;
        String string2 = null;
        try {
            if (string.startsWith("0x")) {
                object = this.tsService.hexLabelToString(string, this.userName);
                string2 = string;
            } else {
                string2 = this.tsService.stringLabelToHex(string, this.userName);
            }
        }
        catch (BadLabelException badLabelException) {
            String string3 = String.valueOf(badLabelException.getErrorCode());
            throw new UserException("EXM_CLI_TSOL_BAD_LABEL_ERROR", string, string3);
        }
        catch (Exception exception) {
            throw new UserException("EXM_CLI_TSOL_LABEL_UPDATE_ERROR");
        }
        object = userObj.getSolAuthAttrs();
        if (object == null) {
            object = new UserAttrObj();
        }
        object.setAttribute("min_label", string2);
        userObj.setSolAuthAttrs((UserAttrObj)object);
        return userObj;
    }

    protected UserObj setXOptionTsolLabelView(String string, UserObj userObj) throws UserException {
        String string2 = null;
        String string3 = ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"xprop_tsol_labelview_SHOW");
        String string4 = ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"xprop_tsol_labelview_HIDE");
        if (string.compareTo(string3) == 0) {
            this.trace("setting labelview = showsl");
            string2 = "showsl";
        } else if (string.compareTo(string4) == 0) {
            this.trace("setting labelview = hide");
            string2 = "hidesl";
        } else {
            throw new UserException("EXM_CLI_TSOL_BAD_LABELOPTION", string);
        }
        UserAttrObj userAttrObj = userObj.getSolAuthAttrs();
        Vector<String> vector = new Vector<String>();
        String string5 = null;
        if (userAttrObj != null) {
            Vector vector2 = userAttrObj.getAttribute("labelview");
            String string6 = null;
            if (vector2 != null && vector2.size() > 0) {
                string6 = (String)vector2.elementAt(0);
            }
            if (string6 != null && (string6.compareTo("internal") == 0 || string6.compareTo("external") == 0)) {
                string5 = string6;
            }
        }
        if (string5 != null) {
            vector.addElement(string5);
        }
        vector.addElement(string2);
        if (vector.size() > 0) {
            if (userAttrObj == null) {
                userAttrObj = new UserAttrObj();
            }
            userAttrObj.setAttribute("labelview", vector);
            userObj.setSolAuthAttrs(userAttrObj);
        }
        return userObj;
    }

    protected UserObj setXOptionTsolLock(String string, UserObj userObj) throws UserException {
        String string2 = null;
        String string3 = ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"xprop_tsol_lock_YES");
        String string4 = ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"xprop_tsol_lock_NO");
        if (string.compareTo(string3) == 0) {
            this.trace("setting lock_after_retries = yes");
            string2 = "yes";
        } else if (string.compareTo(string4) == 0) {
            this.trace("setting lock_after_retries = no");
            string2 = "no";
        } else {
            throw new UserException("EXM_CLI_TSOL_BAD_LOCKOPTION", string);
        }
        UserAttrObj userAttrObj = userObj.getSolAuthAttrs();
        if (userAttrObj == null) {
            userAttrObj = new UserAttrObj();
        }
        userAttrObj.setAttribute("lock_after_retries", string2);
        userObj.setSolAuthAttrs(userAttrObj);
        return userObj;
    }

    protected UserObj setXOptionTsolPwUpdate(String string, UserObj userObj) throws UserException {
        String string2;
        String string3 = ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"xprop_tsol_pwupdate_MANUAL");
        String string4 = ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"xprop_tsol_pwupdate_AUTO");
        if (string.compareTo(string3) == 0) {
            this.trace("setting passwd = manual");
            string2 = "manual";
        } else if (string.compareTo(string4) == 0) {
            this.trace("setting passwd = auto");
            string2 = "automatic";
        } else {
            throw new UserException("EXM_CLI_TSOL_BAD_PASSWD_UPDATE", string);
        }
        UserAttrObj userAttrObj = userObj.getSolAuthAttrs();
        if (userAttrObj == null) {
            userAttrObj = new UserAttrObj();
        }
        userAttrObj.setAttribute("password", string2);
        userObj.setSolAuthAttrs(userAttrObj);
        return userObj;
    }

    protected UserObj setXOptionTsolView(String string, UserObj userObj) throws UserException {
        Vector vector;
        String string2 = null;
        String string3 = ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"xprop_tsol_view_INTERNAL");
        String string4 = ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"xprop_tsol_view_EXTERNAL");
        String string5 = ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"xprop_tsol_view_DEFAULT");
        if (string.compareTo(string3) == 0) {
            this.trace("setting labelview = internal");
            string2 = "internal";
        } else if (string.compareTo(string4) == 0) {
            this.trace("setting labelview = external");
            string2 = "external";
        } else if (string.compareTo(string5) == 0) {
            this.trace("setting labelview = default");
            string2 = "default";
        } else {
            throw new UserException("EXM_CLI_TSOL_BAD_VIEWOPTION", string);
        }
        UserAttrObj userAttrObj = userObj.getSolAuthAttrs();
        Vector<String> vector2 = new Vector<String>();
        String string6 = null;
        if (userAttrObj != null && (vector = userAttrObj.getAttribute("labelview")) != null) {
            if (vector.size() == 2) {
                string6 = (String)vector.elementAt(1);
            } else if (vector.size() == 1) {
                string6 = (String)vector.elementAt(0);
            }
        }
        if (!string2.equals("default")) {
            vector2.addElement(string2);
        }
        if (string6 != null) {
            vector2.addElement(string6);
        }
        if (vector2.size() > 0) {
            if (userAttrObj == null) {
                userAttrObj = new UserAttrObj();
            }
            userAttrObj.setAttribute("labelview", vector2);
            userObj.setSolAuthAttrs(userAttrObj);
        }
        return userObj;
    }

    private boolean validateUID(String string) throws UserException {
        boolean bl = true;
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            throw new UserException("EXM_UID_NON_INT");
        }
        if (n < 100) {
            throw new UserException("EXM_UID_NON_INT");
        }
        return bl;
    }

    protected UserObj verifyXArgsOK(UserObj userObj, boolean bl, boolean bl2) {
        if (bl2 && !bl) {
            SolPasswordAttr solPasswordAttr = userObj.getSolPasswordAttr();
            solPasswordAttr.setHasPassword(false);
            userObj.setSolPasswordAttr(solPasswordAttr);
        }
        return userObj;
    }

    public void viewObjectProps() throws Exception {
        block7: {
            Vector vector = this.getUserObjs();
            UserObj userObj = new UserObj();
            try {
                if (this.getUserMgr() == null) {
                    this.trace("in viewObjectProps:  usermgr is null!");
                    throw new UserException("EXM_CLI_NO_SERVICE");
                }
                if (this.bListAll) {
                    this.listAllAccountInfo();
                    break block7;
                }
                if (vector != null) {
                    this.trace("there are:  " + vector.size() + "  users to display.");
                    Enumeration enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        userObj = (UserObj)enumeration.nextElement();
                        this.trace("listing attributs for user:  " + userObj.getUserName());
                        userObj = this.getUserMgr().getFullAttributes(userObj);
                        this.viewUserOutput(userObj);
                    }
                    break block7;
                }
                this.trace("Unexpected course of action in viewObjectProps.");
                throw new UserException("EXM_CLI_GENERIC_VIEW_ERR");
            }
            catch (UserException userException) {
                throw userException;
            }
            catch (Exception exception) {
                this.trace("generic exception in viewObjectProps(): " + exception.getMessage());
                this.printDebugStack(exception);
                throw exception;
            }
        }
    }

    public void viewUserOutput(UserObj userObj) {
        this.trace("in BaseUserMgrCli->viewUserOutput");
    }

    private void writeLoggingDate() {
        String string = ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"LOGGING_SERVER");
        this.cascade_logging(String.valueOf(string) + this.getApplicationContext().getMgmtServer());
        string = ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"LOGGING_DATESTAMP");
        this.cascade_logging(String.valueOf(string) + this.getDate());
    }

    private void writeServerSideLog(String string, String string2, int n) {
        String string3 = "UserMgr";
        String string4 = this.getAuthenticatedUser();
        String string5 = this.getMgmtServer();
        int n2 = 0;
        boolean bl = false;
        String string6 = "";
        try {
            this.getUserMgr().writeLogRecord(string3, string4, string, string2, string5, n2, n, bl, string6);
        }
        catch (AdminException adminException) {
            this.trace("got exception doing logging");
            this.printDebugStack((Exception)((Object)adminException));
        }
    }
}

