/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.client.group;

import com.sun.symon.base.client.group.SMObjectGroupInfo;
import com.sun.symon.base.client.service.SMDBObject;
import com.sun.symon.base.client.service.SMDBObjectID;
import com.sun.symon.base.client.service.SMLengthException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class SMObjectGroupData
extends SMObjectGroupInfo {
    private static final String version = "1.0";
    private boolean allObjectsInDomain_;
    private String[] objects_;
    private String userData_;

    public SMObjectGroupData() {
    }

    public SMObjectGroupData(SMDBObjectID sMDBObjectID, String string) {
        super(sMDBObjectID, string);
    }

    protected Object clone() {
        return super.clone();
    }

    public String[] getObjects() {
        return this.objects_;
    }

    public String getUserData() {
        if (this.userData_ == null) {
            return "";
        }
        return this.userData_;
    }

    public boolean isAllObjectsInDomain() {
        return this.allObjectsInDomain_;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        SMDBObject.readString(objectInputStream);
        this.allObjectsInDomain_ = objectInputStream.readBoolean();
        this.objects_ = (String[])objectInputStream.readObject();
        this.userData_ = SMDBObject.readString(objectInputStream);
    }

    public void setAllObjectsInDomain(boolean bl) {
        this.allObjectsInDomain_ = bl;
        this.setChanged(true);
    }

    public void setDescription(String string) throws SMLengthException {
        super.setDescription(string);
    }

    public void setDomain(String string) throws SMLengthException {
        super.setDomain(string);
    }

    public void setFilter(SMDBObjectID sMDBObjectID) {
        super.setFilter(sMDBObjectID);
    }

    public void setName(String string) throws SMLengthException {
        super.setName(string);
    }

    public void setObjects(String[] stringArray) throws SMLengthException {
        this.objects_ = SMDBObject.assertLength("object", stringArray, 512);
        this.setChanged(true);
    }

    public void setUserData(String string) throws SMLengthException {
        this.userData_ = SMDBObject.assertLength("userData", string, 64, false);
        this.setChanged(true);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        stringBuffer.append(super.toString());
        stringBuffer.append(", allObjectsInDomain=").append(this.allObjectsInDomain_);
        stringBuffer.append(", userData=").append(this.userData_);
        stringBuffer.append(", objects=");
        SMDBObject.arrayToStringBuffer(this.objects_, stringBuffer);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public void validate() throws IllegalArgumentException {
        if (this.name_ == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (this.name_.trim().equals("")) {
            throw new IllegalArgumentException("name cannot be empty");
        }
        if (this.domain_ == null) {
            throw new IllegalArgumentException("domain cannot be null");
        }
        if (this.domain_.trim().equals("")) {
            throw new IllegalArgumentException("domain cannot be empty");
        }
        if (!this.allObjectsInDomain_ && this.objects_ == null) {
            throw new IllegalArgumentException("object list cannot be null if AllObjectsInDomain is false");
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        SMDBObject.writeString(objectOutputStream, version);
        objectOutputStream.writeBoolean(this.allObjectsInDomain_);
        objectOutputStream.writeObject(this.objects_);
        SMDBObject.writeString(objectOutputStream, this.userData_);
    }
}

