/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.jndi.orb_dep;

import com.visigenic.vbroker.GIOP.Version;
import com.visigenic.vbroker.IIOP_1_1.ProfileBody;
import com.visigenic.vbroker.IIOP_1_1.ProfileBodyHelper;
import com.visigenic.vbroker.IOP.IOR;
import com.visigenic.vbroker.IOP.TaggedComponent;
import com.visigenic.vbroker.IOP.TaggedProfile;
import com.visigenic.vbroker.orb.GiopOutputStream;
import com.visigenic.vbroker.orb.ORB;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Properties;
import oracle.aurora.jndi.orb_dep.Orb;
import oracle.aurora.jndi.sess_iiop.InitialReferencesFinder;
import oracle.aurora.jndi.sess_iiop.ServiceCtx;
import oracle.aurora.sess_iiop.orb_dep.ComponentBody;
import oracle.aurora.sess_iiop.orb_dep.ComponentBodyHelper;
import oracle.aurora.ssl.AuroraCertificateManager;
import oracle.aurora.ssl.AuroraCertificateManagerHelper;
import oracle.aurora.ssl.SSLComponentBody;
import oracle.aurora.ssl.SSLComponentBodyHelper;
import oracle.security.jwallet.JWalletCertificate;
import oracle.security.jwallet.JWalletPersona;
import oracle.security.jwallet.JWalletPvtKey;
import oracle.security.jwallet.txtwallet.TxtWalletReader;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.InitialReferences;
import org.omg.CORBA.InitialReferencesHelper;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.OutputStream;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class SslIRFinder
implements InitialReferencesFinder {
    private Integer _tpType = null;
    private String _sslVersion = null;
    private boolean _useSname = false;
    private boolean __DEBUG = false;
    private static String bc = "-----BEGIN CERTIFICATE-----\n";
    private static String ec = "\n-----END CERTIFICATE-----";
    private static String bp = "-----BEGIN ENCRYPTED PRIVATE KEY-----\n";
    private static String ep = "\n-----END ENCRYPTED PRIVATE KEY-----";

    private Object getObject(short sslAuthentication, String host, short port, byte[] objectKey, Hashtable env) throws UnknownHostException {
        TaggedComponent[] components;
        AuroraCertificateManager cm;
        ORB orb;
        block19: {
            Properties props = new Properties();
            if (this._tpType.equals(ServiceCtx.IIOP)) {
                ((Hashtable)props).put("ORBservices", "oracle.aurora.client,oracle.aurora.ssl,oracle.aurora.jts.client.orb_dep");
            } else {
                ((Hashtable)props).put("ORBservices", "oracle.aurora.client,oracle.aurora.sess_iiop.orb_dep,oracle.aurora.sess_iiop.ssl.orb_dep,oracle.aurora.jts.client.orb_dep");
            }
            orb = (ORB)Orb.init(props);
            try {
                cm = AuroraCertificateManagerHelper.narrow(orb.resolve_initial_references("AuroraSSLCertificateManager"));
                if (this._sslVersion == null) break block19;
                if (this._sslVersion.equals("30")) {
                    cm.setProtocolVersion(768);
                    break block19;
                }
                if (this._sslVersion.equals("20")) {
                    cm.setProtocolVersion(2);
                    break block19;
                }
                if (this._sslVersion.equals("30_WITH_20_HELLO")) {
                    cm.setProtocolVersion(100);
                    break block19;
                }
                if (this._sslVersion.equals("Undetermined")) {
                    cm.setProtocolVersion(0);
                    break block19;
                }
                throw new BAD_PARAM("Bad value for SSL version");
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new INITIALIZE("Couldn't initialize SSL context");
            }
        }
        String auth = (String)env.get("java.naming.security.authentication");
        if (auth.equals("SslClientAuth")) {
            String passwd = (String)env.get("java.naming.security.credentials");
            if (passwd == null) {
                System.out.println("****Must set SECURITY_CREDENTIALS ******");
                throw new INITIALIZE();
            }
            String credsFile = (String)env.get("java.naming.security.principal");
            if (credsFile != null) {
                this.useFile(credsFile, cm, passwd);
            } else {
                this.useProperties(env, cm, passwd);
            }
        } else {
            try {
                String trustCert_base64 = (String)env.get("oracle.aurora.sess_iiop.security_trusted_cert");
                if (trustCert_base64 != null) {
                    if (this.__DEBUG) {
                        System.out.println("Trust point being set is :" + trustCert_base64);
                    }
                    byte[] trustCert = new BASE64Decoder().decodeBuffer(trustCert_base64);
                    cm.addTrustedCertificate(trustCert);
                }
            }
            catch (Exception exception) {
                throw new INITIALIZE("Couldn't set the trusted cert");
            }
        }
        String ipAddr = InetAddress.getByName(host).getHostAddress();
        Version version = new Version(1, 1);
        short supported = 0;
        SSLComponentBody compBody = new SSLComponentBody(sslAuthentication, supported, port);
        GiopOutputStream output = orb.newGiopOutputStream();
        output.write_boolean(false);
        SSLComponentBodyHelper.write((OutputStream)output, compBody);
        TaggedComponent comp1 = new TaggedComponent(20, output.toByteArray());
        TaggedProfile profile = null;
        if (this._tpType.equals(ServiceCtx.IIOP)) {
            components = new TaggedComponent[]{comp1};
        } else {
            ComponentBody sessionBody = new ComponentBody("ORCL", 0, orb.getLocalHost(), new byte[0]);
            output.offset(0);
            output.write_boolean(false);
            ComponentBodyHelper.write((OutputStream)output, sessionBody);
            TaggedComponent comp2 = new TaggedComponent(1330790656, output.toByteArray());
            components = new TaggedComponent[]{comp1, comp2};
        }
        ProfileBody profileBody = new ProfileBody(version, ipAddr, port, objectKey, components);
        output.offset(0);
        output.write_boolean(false);
        ProfileBodyHelper.write((OutputStream)output, (ProfileBody)profileBody);
        byte[] profileData = output.toByteArray();
        profile = new TaggedProfile(0, profileData);
        TaggedProfile[] profiles = new TaggedProfile[]{profile};
        return orb.iorToObject(new IOR("IDL:CORBA/InitialReferences:1.0", profiles));
    }

    private byte[] initKey(String sid) throws UnknownHostException {
        if (sid == null || sid.equals("")) {
            return InitialReferencesFinder.INITIAL_REFERENCES_KEY;
        }
        int keyLength = InitialReferencesFinder.INITIAL_REFERENCES_KEY.length;
        int len = 0;
        String tmp = this._useSname ? new String("(CONNECT_DATA=(REP_ID=IDL:CORBA/InitialReferences:1.0)(SERVICE_NAME=") : new String("(CONNECT_DATA=(REP_ID=IDL:CORBA/InitialReferences:1.0)(SID=");
        String tmp2 = "(SESSION_ID=0)";
        byte[] objectKey = this._tpType.equals(ServiceCtx.SESS_IIOP) ? new byte[7 + tmp.length() + sid.length() + tmp2.length() + keyLength] : new byte[7 + tmp.length() + sid.length() + keyLength];
        System.arraycopy("ORCL".getBytes(), 0, objectKey, 0, 4);
        len = 4;
        System.arraycopy(tmp.getBytes(), 0, objectKey, len, tmp.length());
        System.arraycopy(sid.getBytes(), 0, objectKey, len += tmp.length(), sid.length());
        System.arraycopy(")".getBytes(), 0, objectKey, len += sid.length(), 1);
        ++len;
        if (this._tpType.equals(ServiceCtx.SESS_IIOP)) {
            System.arraycopy(tmp2.getBytes(), 0, objectKey, len, tmp2.length());
            len += tmp2.length();
        }
        System.arraycopy(")".getBytes(), 0, objectKey, len, 1);
        objectKey[++len] = 0;
        System.arraycopy(InitialReferencesFinder.INITIAL_REFERENCES_KEY, 0, objectKey, ++len, keyLength);
        return objectKey;
    }

    public InitialReferences initialReferences(String host, short port, String sid, Hashtable env) throws UnknownHostException {
        if (System.getProperty("oracle.server.version") != null) {
            throw new NO_IMPLEMENT("Not supported in the server yet");
        }
        String _debug = System.getProperty("AURORA_CLIENT_SSL_DEBUG");
        if (_debug != null) {
            this.__DEBUG = _debug.equalsIgnoreCase("true");
        }
        this._tpType = (Integer)env.get("TRANSPORT_TYPE");
        if (this._tpType == null) {
            this._tpType = ServiceCtx.SESS_IIOP;
        }
        ServiceCtx._tpType = new Integer(this._tpType);
        String sidProp = (String)env.get("USE_SERVICE_NAME");
        if (sidProp != null) {
            this._useSname = sidProp.equalsIgnoreCase("true");
        }
        this._sslVersion = (String)env.get("CLIENT_SSL_VERSION");
        return InitialReferencesHelper.narrow(this.getObject(this.sslAuthentication(env), host, port, this.initKey(sid), env));
    }

    private short sslAuthentication(Hashtable env) {
        return 1;
    }

    private void useFile(String credsFile, AuroraCertificateManager cm, String passwd) {
        try {
            BASE64Encoder encoder = new BASE64Encoder();
            TxtWalletReader txtWltRdr = new TxtWalletReader(credsFile, null);
            int personaCount = txtWltRdr.getPersonaCount();
            if (personaCount == 0) {
                throw new INITIALIZE();
            }
            if (this.__DEBUG) {
                System.out.println("Persona Count: " + personaCount);
            }
            JWalletPersona personaObj = txtWltRdr.getPersonaByIndex(0);
            int certCount = personaObj.getCertChainCount();
            if (this.__DEBUG) {
                System.out.println("Cert chain Count: " + certCount);
            }
            if (certCount == 0) {
                throw new INITIALIZE();
            }
            byte[][] chain = new byte[certCount][];
            int j = certCount - 1;
            int k = 0;
            while (j >= 0) {
                JWalletCertificate cert = personaObj.getCertChainByIndex(j);
                chain[k] = cert.getCertData();
                if (this.__DEBUG) {
                    String cert_base64 = String.valueOf(bc) + encoder.encodeBuffer(chain[k]) + ec;
                    if (j == certCount - 1) {
                        System.out.println("B64 User Cert :\n" + cert_base64);
                    } else {
                        System.out.println("B64 CA Cert :\n" + cert_base64);
                    }
                }
                --j;
                ++k;
            }
            cm.setCertificateChain(chain);
            JWalletPvtKey pKeyObj = personaObj.getPrivateKey();
            byte[] pKey = pKeyObj.getPvtKeyData();
            if (this.__DEBUG) {
                String pKey_base64 = String.valueOf(bp) + encoder.encodeBuffer(pKey) + ep;
                System.out.println("PKEY length " + pKey.length);
                System.out.println("B64 Private Key:\n" + pKey_base64);
            }
            cm.setEncryptedPrivateKey(pKey, passwd);
            int tpCount = personaObj.getTrustedCertCount();
            if (this.__DEBUG) {
                System.out.println("TP Count: " + tpCount);
            }
            byte[][] tpChain = new byte[tpCount][];
            int i = 0;
            while (i < tpCount) {
                JWalletCertificate tpCert = personaObj.getTrustedCertByIndex(i);
                tpChain[i] = tpCert.getCertData();
                if (this.__DEBUG) {
                    String tp_base64 = String.valueOf(bc) + encoder.encodeBuffer(tpChain[i]) + ec;
                    System.out.println("B64 TP [" + i + "]:\n" + tp_base64);
                }
                cm.addTrustedCertificate(tpChain[i]);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new INITIALIZE("Couldn't read the credentials file");
        }
    }

    private void useProperties(Hashtable env, AuroraCertificateManager cm, String passwd) {
        BASE64Decoder decoder = new BASE64Decoder();
        String userCert_base64 = (String)env.get("oracle.aurora.sess_iiop.security_user_cert");
        if (userCert_base64 == null) {
            System.out.println("****Must set SECURITY_USER_CERT ******");
            throw new INITIALIZE();
        }
        String caCert_base64 = (String)env.get("oracle.aurora.sess_iiop.security_ca_cert");
        if (caCert_base64 == null) {
            System.out.println("****Must set SECURITY_CA_CERT ******");
            throw new INITIALIZE();
        }
        String encryptedPrivateKey_base64 = (String)env.get("oracle.aurora.sess_iiop.encrypted_pkey");
        if (encryptedPrivateKey_base64 == null) {
            System.out.println("****Must set SECURITY_ENCRYPTED_PKEY *****");
            throw new INITIALIZE();
        }
        String trustCert_base64 = (String)env.get("oracle.aurora.sess_iiop.security_trusted_cert");
        try {
            byte[] userCert = decoder.decodeBuffer(userCert_base64);
            byte[] caCert = decoder.decodeBuffer(caCert_base64);
            byte[][] certificates = new byte[][]{caCert, userCert};
            cm.setCertificateChain(certificates);
            byte[] encryptedPrivateKey = decoder.decodeBuffer(encryptedPrivateKey_base64);
            cm.setEncryptedPrivateKey(encryptedPrivateKey, passwd);
            if (trustCert_base64 != null) {
                byte[] trustCert = decoder.decodeBuffer(trustCert_base64);
                cm.addTrustedCertificate(trustCert);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new INITIALIZE("Couldn't initialize SSL context");
        }
    }
}

