/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.jts;

import java.util.Stack;
import oracle.aurora.jts.AuroraTransactionService;
import oracle.aurora.jts.TransactionContext;
import oracle.aurora.jts.util.NoTransactionServiceException;
import oracle.aurora.jts.util.TS;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.Inactive;
import org.omg.CosTransactions.InvalidControl;
import org.omg.CosTransactions.NoTransaction;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.Status;
import org.omg.CosTransactions.SubtransactionsUnavailable;
import org.omg.CosTransactions.Unavailable;
import org.omg.CosTransactions._CurrentImplBase;

public class CurrentImpl
extends _CurrentImplBase {
    private int timeout = 60;
    private Stack context = new Stack();
    private static final boolean DEBUG = false;
    protected PropagationContext createdCxt;

    CurrentImpl() {
    }

    public void begin() throws SubtransactionsUnavailable {
        if (!this.noTxn()) {
            throw new SubtransactionsUnavailable();
        }
        this.pushContext(null, null);
        try {
            this.set_control(((AuroraTransactionService)TS.getTS()).newTransaction(this.timeout));
        }
        catch (NoTransactionServiceException e) {
            e.printStackTrace();
            throw new SubtransactionsUnavailable();
        }
    }

    public void commit(boolean report_heuristics) throws NoTransaction, HeuristicMixed, HeuristicHazard {
        if (this.noTxn()) {
            throw new NoTransaction();
        }
        try {
            try {
                this.get_control().get_terminator().commit(report_heuristics);
            }
            catch (Unavailable unavailable) {
                throw new NoTransaction();
            }
            Object var3_2 = null;
            if (!this.noTxn()) {
                this.popContext();
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!this.noTxn()) {
                this.popContext();
            }
            throw throwable;
        }
    }

    protected TransactionContext getTxCxt() {
        return (TransactionContext)this.context.firstElement();
    }

    public PropagationContext get_context() {
        if (this.noTxn()) {
            return null;
        }
        return this.getTxCxt().context;
    }

    public Control get_control() {
        if (this.noTxn()) {
            return null;
        }
        TransactionContext cxt = this.getTxCxt();
        if (cxt.control != null) {
            return cxt.control;
        }
        if (cxt.context == null) {
            return null;
        }
        try {
            cxt.control = ((AuroraTransactionService)TS.getTS()).recreate(cxt.context);
        }
        catch (NoTransactionServiceException e) {
            e.printStackTrace();
            return null;
        }
        return cxt.control;
    }

    public Status get_status() {
        if (this.noTxn()) {
            return Status.StatusNoTransaction;
        }
        try {
            return this.get_control().get_coordinator().get_status();
        }
        catch (Unavailable e) {
            ((Throwable)((Object)e)).printStackTrace();
            return Status.StatusNoTransaction;
        }
    }

    public String get_transaction_name() {
        if (this.noTxn()) {
            return null;
        }
        try {
            return this.get_control().get_coordinator().get_transaction_name();
        }
        catch (Unavailable e) {
            ((Throwable)((Object)e)).printStackTrace();
            return null;
        }
    }

    public boolean noTxn() {
        return this.context.size() == 0;
    }

    public void popContext() {
        this.context.pop();
    }

    void pushContext(Control c, PropagationContext cxt) {
        this.context.push(new TransactionContext(c, cxt));
    }

    public void resume(Control which) throws InvalidControl {
        try {
            PropagationContext cxt = null;
            if (which == null) {
                throw new InvalidControl();
            }
            cxt = which.get_coordinator().get_txcontext();
            if (cxt == null) {
                throw new InvalidControl();
            }
            this.pushContext(which, cxt);
            ((AuroraTransactionService)TS.getTS()).resumeTxn(cxt);
        }
        catch (Unavailable e) {
            ((Throwable)((Object)e)).printStackTrace();
            throw new InvalidControl();
        }
        catch (InvalidControl e) {
            ((Throwable)((Object)e)).printStackTrace();
            throw e;
        }
        catch (NoTransactionServiceException e) {
            e.printStackTrace();
            throw new InvalidControl();
        }
    }

    public void rollback() throws NoTransaction {
        if (this.noTxn()) {
            throw new NoTransaction();
        }
        try {
            this.get_control().get_terminator().rollback();
        }
        catch (Unavailable unavailable) {
            throw new NoTransaction();
        }
        if (!this.noTxn()) {
            this.popContext();
        }
    }

    public void rollback_only() throws NoTransaction {
        if (this.noTxn()) {
            throw new NoTransaction();
        }
        try {
            this.get_control().get_coordinator().rollback_only();
        }
        catch (Unavailable unavailable) {
            throw new NoTransaction();
        }
        catch (Inactive inactive) {
            throw new NoTransaction();
        }
    }

    protected void set_context(PropagationContext cxt) {
        this.getTxCxt().context = cxt;
    }

    private void set_control(Control c) {
        this.getTxCxt().control = c;
    }

    public void set_timeout(int seconds) {
        this.timeout = seconds;
    }

    public Control suspend() {
        if (this.noTxn()) {
            return null;
        }
        Control c = this.get_control();
        try {
            ((AuroraTransactionService)TS.getTS()).suspendTxn(c.get_coordinator().get_txcontext());
        }
        catch (Unavailable e) {
            ((Throwable)((Object)e)).printStackTrace();
        }
        catch (NoTransactionServiceException e) {
            e.printStackTrace();
        }
        this.popContext();
        return c;
    }
}

