/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.client.probe;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.probe.SMProbeListener;
import com.sun.symon.base.server.common.ScBaseProbeImpl;
import com.sun.symon.base.server.common.ScProbeListener;
import com.sun.symon.base.server.receptors.rmi.RMIProbeInterface;
import com.sun.symon.base.server.receptors.rmi.RMIProbeListener;
import com.sun.symon.base.utility.UcDDL;
import com.sun.symon.base.utility.UcURL;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ResourceBundle;

public class SMProbeConnection {
    private SMRawDataRequest handle;
    private RMIProbeInterface pHandle;
    private ScBaseProbeImpl localProbeHandle;
    private RMIProbeListener innerCallback;
    private SMProbeListener externalCallback;
    private ScProbeListener localProbecallback;
    private static String[] dummyArgs = new String[0];
    boolean isConnected;
    String host;
    int port;
    String password;
    private ResourceBundle bundle;
    private boolean isLocal;
    private String basePropFile;

    public SMProbeConnection(SMRawDataRequest sMRawDataRequest) throws SMAPIException {
        block5: {
            this.isConnected = false;
            this.isLocal = false;
            this.basePropFile = "com.sun.symon.base.client.ClientApiMessages";
            try {
                this.handle = sMRawDataRequest;
                this.bundle = sMRawDataRequest.getResourceBundle();
                this.isLocal = sMRawDataRequest.getLocal();
                if (!this.isLocal) {
                    this.pHandle = sMRawDataRequest.getProbeService();
                } else {
                    this.localProbeHandle = new ScBaseProbeImpl();
                }
                this.isConnected = false;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                if (throwable instanceof RemoteException) {
                    throw new SMAPIException(throwable.getMessage());
                }
                if (!(throwable instanceof SMAPIException)) break block5;
                throw (SMAPIException)throwable;
            }
        }
    }

    public SMProbeConnection(SMRawDataRequest sMRawDataRequest, SMProbeListener sMProbeListener) throws SMAPIException {
        this(sMRawDataRequest);
        this.externalCallback = sMProbeListener;
    }

    public void close() throws SMAPIException {
        try {
            if (!this.isLocal) {
                this.pHandle.close();
            } else {
                this.localProbeHandle.close();
            }
            this.isConnected = false;
            if (this.externalCallback != null) {
                this.externalCallback = null;
            }
        }
        catch (Throwable throwable) {
            UcDDL.logErrorMessage((String)("Probe Close: " + throwable));
            if (throwable instanceof SMAPIException) {
                throw (SMAPIException)throwable;
            }
            throw new SMAPIException(throwable);
        }
    }

    public void connect(String string) throws SMAPIException {
        this.connect(string, null);
        this.isConnected = true;
    }

    public void connect(String string, String[] stringArray) throws SMAPIException {
        UcURL ucURL = new UcURL(string);
        String string2 = ucURL.getHost();
        try {
            String string3 = this.handle.getProbeCookie(string, stringArray);
            this.parseResponse(string3);
            if (!this.isLocal) {
                this.innerCallback = new ProbeCallback();
                this.pHandle.connect(this.host, this.port, this.password, this.innerCallback);
            } else {
                this.localProbeHandle.connect(this.host, this.port, this.password, (ScProbeListener)new LocalProbeCallback());
            }
            this.isConnected = true;
        }
        catch (Throwable throwable) {
            try {
                if (!this.isLocal) {
                    this.innerCallback = new ProbeCallback();
                    this.pHandle.connect(string2, this.port, this.password, this.innerCallback);
                } else {
                    this.localProbeHandle.connect(string2, this.port, this.password, (ScProbeListener)new LocalProbeCallback());
                }
            }
            catch (Exception exception) {
                String string4 = this.bundle.getString("ProbeConnection.ConnectionNotAvailable");
                UcDDL.logInfoMessage((String)(String.valueOf(string4) + string));
                throw new SMAPIException(string4, throwable);
            }
        }
    }

    public void connectWithErr(String string) throws SMAPIException {
        this.connectWithErr(string, dummyArgs);
        this.isConnected = true;
    }

    public void connectWithErr(String string, String[] stringArray) throws SMAPIException {
        UcURL ucURL = new UcURL(string);
        String string2 = ucURL.getHost();
        try {
            String string3 = this.handle.getProbeErrCookie(string, stringArray);
            this.parseResponse(string3);
            if (!this.isLocal) {
                this.innerCallback = new ProbeCallback();
                this.pHandle.connectWithErr(this.host, this.port, this.password, this.innerCallback);
            } else {
                this.localProbeHandle.connectWithErr(this.host, this.port, this.password, (ScProbeListener)new LocalProbeCallback());
            }
            this.isConnected = true;
        }
        catch (Throwable throwable) {
            try {
                if (!this.isLocal) {
                    this.innerCallback = new ProbeCallback();
                    this.pHandle.connect(string2, this.port, this.password, this.innerCallback);
                } else {
                    this.localProbeHandle.connectWithErr(this.host, this.port, this.password, (ScProbeListener)new LocalProbeCallback());
                }
            }
            catch (Exception exception) {
                String string4 = this.bundle.getString("ProbeConnection.ConnectionNotAvailable");
                UcDDL.logInfoMessage((String)(String.valueOf(string4) + string));
                throw new SMAPIException(exception.getMessage());
            }
        }
    }

    private void invalidFields(String string) throws SMAPIException {
        String string2 = this.bundle.getString("ProbeConnection.InvalidFieldsFromSetRequest");
        throw new SMAPIException(String.valueOf(string2) + string);
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    protected void parseResponse(String string) throws SMAPIException {
        int n = string.indexOf(58);
        if (n == -1) {
            this.invalidFields(string);
        }
        this.host = string.substring(0, n);
        if (this.host.equals("Error")) {
            throw new SMAPIException(string);
        }
        int n2 = string.indexOf(58, n + 1);
        if (n2 == -1) {
            this.invalidFields(string);
        }
        this.port = 0;
        try {
            this.port = Integer.parseInt(string.substring(n + 1, n2));
        }
        catch (NumberFormatException numberFormatException) {
            this.invalidFields(string);
        }
        this.password = String.valueOf(string.substring(n2 + 1)) + "\n";
    }

    public void readLines(int n) throws SMAPIException {
        try {
            if (!this.isConnected) {
                String string = this.bundle.getString("ProbeConnection.ReadFromUnconnected");
                UcDDL.logErrorMessage((String)string);
                throw new SMAPIException(string);
            }
            if (!this.isLocal) {
                this.pHandle.readLines(n);
            } else {
                this.localProbeHandle.readLines(n);
            }
        }
        catch (Throwable throwable) {
            String string = this.bundle.getString("ProbeConnection.ReadFailure");
            UcDDL.logErrorMessage((String)string, (Throwable)throwable);
            if (throwable instanceof SMAPIException) {
                throw (SMAPIException)throwable;
            }
            throw new SMAPIException(string, throwable);
        }
    }

    public void setEndOfStream(String string) throws SMAPIException {
        try {
            if (!this.isLocal) {
                this.pHandle.setEndOfStream(string);
            } else {
                this.localProbeHandle.setEndOfStream(string);
            }
        }
        catch (RemoteException remoteException) {
            String string2 = this.bundle.getString("ProbeConnection.RemoteException");
            throw new SMAPIException(string2, remoteException);
        }
    }

    public void setResponse(SMProbeListener sMProbeListener) {
        this.externalCallback = sMProbeListener;
    }

    public void setTimeOut(int n) throws SMAPIException {
        try {
            if (!this.isLocal) {
                this.pHandle.setTimeOut(n);
            } else {
                this.localProbeHandle.setTimeOut(n);
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof SMAPIException) {
                throw (SMAPIException)throwable;
            }
            throw new SMAPIException(throwable);
        }
    }

    public void startReader() throws SMAPIException {
        try {
            if (!this.isLocal) {
                this.pHandle.startReader();
            } else {
                this.localProbeHandle.startReader();
            }
        }
        catch (Throwable throwable) {
            String string = this.bundle.getString("ProbeConnection.CouldNotStartReader");
            UcDDL.logInfoMessage((String)string, (Throwable)throwable);
            throw new SMAPIException(string, throwable);
        }
    }

    public void write2probe(String string) throws SMAPIException {
        try {
            if (!this.isConnected) {
                String string2 = this.bundle.getString("ProbeConnection.WriteToUnconnected");
                UcDDL.logErrorMessage((String)string2);
                throw new SMAPIException(string2);
            }
            if (!this.isLocal) {
                this.pHandle.write2probe(string);
            } else {
                this.localProbeHandle.write2probe(string);
            }
        }
        catch (Throwable throwable) {
            String string3 = this.bundle.getString("ProbeConnection.WriteFailure");
            UcDDL.logErrorMessage((String)string3, (Throwable)throwable);
            if (throwable instanceof SMAPIException) {
                throw (SMAPIException)throwable;
            }
            throw new SMAPIException(string3, throwable);
        }
    }

    class LocalProbeCallback
    implements ScProbeListener {
        StringBuffer sb;
        final int INITIAL_CAPACITY = 10000;

        LocalProbeCallback() {
        }

        public void receiveBeginData() {
            this.sb = new StringBuffer(10000);
        }

        public synchronized void receiveData(String string) {
            if (SMProbeConnection.this.externalCallback != null) {
                SMProbeConnection.this.externalCallback.receiveData(string);
            } else {
                String string2 = SMProbeConnection.this.bundle.getString("ProbeConnection.CallbackFailure");
                UcDDL.logErrorMessage((String)string2);
            }
        }

        public void receiveDataPortion(String string) {
            this.sb.append(string);
        }

        public void receiveEndData() {
            if (SMProbeConnection.this.externalCallback != null) {
                SMProbeConnection.this.externalCallback.receiveData(this.sb.toString());
            } else {
                String string = SMProbeConnection.this.bundle.getString("ProbeConnection.CallbackFailure");
                UcDDL.logErrorMessage((String)string);
            }
        }

        public void receiveException(SMAPIException sMAPIException) {
            if (SMProbeConnection.this.externalCallback != null) {
                SMProbeConnection.this.externalCallback.receiveException(sMAPIException);
            } else {
                String string = SMProbeConnection.this.bundle.getString("ProbeConnection.CallbackFailure" + sMAPIException);
                UcDDL.logErrorMessage((String)string);
            }
        }
    }

    class ProbeCallback
    extends UnicastRemoteObject
    implements RMIProbeListener {
        StringBuffer sb;
        final int INITIAL_CAPACITY = 10000;

        ProbeCallback() throws RemoteException {
        }

        public void receiveBeginData() throws RemoteException {
            this.sb = new StringBuffer(10000);
        }

        public synchronized void receiveData(String string) throws RemoteException {
            if (SMProbeConnection.this.externalCallback != null) {
                SMProbeConnection.this.externalCallback.receiveData(string);
            } else {
                String string2 = SMProbeConnection.this.bundle.getString("ProbeConnection.CallbackFailure");
                UcDDL.logErrorMessage((String)string2);
            }
        }

        public void receiveDataPortion(String string) throws RemoteException {
            this.sb.append(string);
        }

        public void receiveEndData() throws RemoteException {
            if (SMProbeConnection.this.externalCallback != null) {
                SMProbeConnection.this.externalCallback.receiveData(this.sb.toString());
            } else {
                String string = SMProbeConnection.this.bundle.getString("ProbeConnection.CallbackFailure");
                UcDDL.logErrorMessage((String)string);
            }
        }

        public void receiveException(SMAPIException sMAPIException) throws RemoteException {
            if (SMProbeConnection.this.externalCallback != null) {
                SMProbeConnection.this.externalCallback.receiveException(sMAPIException);
            } else {
                String string = SMProbeConnection.this.bundle.getString("ProbeConnection.CallbackFailure");
                UcDDL.logErrorMessage((String)(String.valueOf(string) + sMAPIException));
            }
        }
    }
}

