/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.tools.migration;

import com.sun.symon.tools.migration.TmFileDataSource;
import com.sun.symon.tools.migration.datasource.MdDataSourceProperties;
import com.sun.symon.tools.migration.datasource.MdRecord;
import com.sun.symon.tools.migration.datasource.MdTable;
import com.sun.symon.tools.migration.datasource.MdTableSpace;
import com.sun.symon.tools.migration.util.MuDebug;
import java.io.IOException;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.helpers.ParserFactory;

public class TmXMLDataSource
extends TmFileDataSource {
    private final Condition ready = new Condition();
    private Thread readerThread;

    public TmXMLDataSource(MdTable mdTable, MdDataSourceProperties mdDataSourceProperties) throws Exception {
        super(mdTable, mdDataSourceProperties);
    }

    public static void main(String[] stringArray) throws Exception {
        MdTableSpace mdTableSpace = MdTableSpace.newInstance("SomeMdTableSpace", "XML", null);
        MdTable mdTable = mdTableSpace.newMdTable("user");
        mdTable.newMdAttribute("first_name", 7, null, null);
        mdTable.newMdAttribute("last_name", 7, null, null);
        mdTable.newMdAttribute("address", 7, null, null);
        TmXMLDataSource tmXMLDataSource = new TmXMLDataSource(mdTable, null);
        tmXMLDataSource.getMdDataSourceProperties().setProperty("directory", ".");
        tmXMLDataSource.getMdDataSourceProperties().setProperty("file", "records.xml");
        tmXMLDataSource.open(1);
    }

    protected void openReadImpl() throws IOException {
        super.openReadImpl();
        this.readerThread = new Thread((Runnable)new TmXMLDataSourceReader(), "TmXMLDataSourceReader");
        this.readerThread.start();
    }

    protected MdRecord readImpl() throws IOException {
        return null;
    }

    protected void writeImpl(MdRecord mdRecord) throws IOException {
    }

    class Condition {
        private boolean value;

        Condition() {
        }

        public void setFalse() {
            this.value = false;
        }

        public synchronized void setTrue() {
            this.value = true;
            this.notifyAll();
        }

        public synchronized void waitForTrue() throws InterruptedException {
            if (!this.value) {
                this.wait();
            }
        }
    }

    class TmXMLDataSourceReader
    extends HandlerBase
    implements Runnable {
        private Parser parser;

        public TmXMLDataSourceReader() {
            try {
                this.parser = ParserFactory.makeParser("com.sun.xml.parser.Parser");
                this.parser.setDocumentHandler(this);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void endDocument() {
            MuDebug.println("End document");
        }

        public void endElement(String string) {
            MuDebug.println("End element: " + string);
        }

        public void run() {
            try {
                this.parser.parse(new InputSource(TmXMLDataSource.this.in));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void startDocument() {
            MuDebug.println("Begin document");
        }

        public void startElement(String string, AttributeList attributeList) {
            MuDebug.println("Begin element: " + string);
        }
    }
}

