/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.views.dataview;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.service.SMDBObjectID;
import com.sun.symon.base.client.service.SMDuplicateException;
import com.sun.symon.base.client.service.SMNoSuchObjectException;
import com.sun.symon.base.client.view.SMView;
import com.sun.symon.base.client.view.SMViewData;
import com.sun.symon.base.console.awx.AwxObject;
import com.sun.symon.base.console.manager.CmConsoleSession;
import com.sun.symon.base.console.views.dataview.CvDataviewManager;
import com.sun.symon.base.console.views.dataview.base.CvDVUndoableAction;
import com.sun.symon.base.console.views.dataview.base.DataviewContent;
import com.sun.symon.base.console.views.dataview.base.DataviewEditor;
import com.sun.symon.base.console.views.dataview.base.DataviewHandler;
import com.sun.symon.base.console.views.dataview.clipboard.ClipboardListener;
import com.sun.symon.base.console.views.dataview.clipboard.DataviewClipboard;
import com.sun.symon.base.console.views.dataview.manager.DataviewMetadataReader;
import com.sun.symon.base.console.views.dataview.manager.DataviewMetadataWriter;
import com.sun.symon.base.console.views.dataview.manager.ViewServiceContext;
import com.sun.symon.base.console.views.dataview.util.DataviewUtil;
import com.sun.symon.base.console.views.dataview.util.MetaEvent;
import com.sun.symon.base.utility.UcCommon;
import com.sun.symon.base.utility.UcDialog;
import com.sun.symon.base.utility.UcInternationalizer;
import com.sun.symon.base.utility.UcThreadWorker;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Stack;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;

public class CvDataviewEditor
extends JFrame
implements ActionListener {
    static DataviewClipboard dataviewClipboard;
    private Stack undoStack = new Stack();
    boolean isChanged = false;
    String title;
    private JLabel statusBar;
    private JMenuItem saveMItem;
    private JMenuItem closeMItem;
    private JMenuItem undoMItem;
    private JMenuItem pasteMItem;
    private JMenuItem deleteMItem;
    private JMenuItem attributeMItem;
    private JMenuItem helpMItem;
    private JPanel contentPanel;
    DataviewHandler dataviewControler;
    public SMViewData dataview;

    public CvDataviewEditor(Dialog dialog, SMViewData sMViewData, int n) {
        this.construct(sMViewData, n);
    }

    public CvDataviewEditor(Frame frame, SMViewData sMViewData, int n) {
        this.construct(sMViewData, n);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.saveMItem) {
            this.save();
        } else if (object == this.pasteMItem) {
            this.pasteFromClipboard();
        } else if (object == this.deleteMItem) {
            int n = UcDialog.showYesNo((String)DataviewUtil.getI18nMsg("editor.confirmDelete"));
            if (n != 0) {
                return;
            }
            this.dataviewControler.deleteRows();
            this.deleteMItem.setEnabled(false);
            this.isChanged = true;
        } else if (object == this.undoMItem) {
            this.undo();
        } else if (object == this.attributeMItem) {
            this.dataviewControler.launchAttrEditor();
        } else if (object == this.helpMItem) {
            CmConsoleSession.getInstance().launchHelp("grouping-dataview-editor-help");
        } else if (object == this.closeMItem) {
            this.close();
        }
    }

    public void addUndoableAction(CvDVUndoableAction cvDVUndoableAction) {
    }

    public void attributeEditable(boolean bl) {
        this.attributeMItem.setEnabled(bl);
    }

    void close() {
        if (!this.isChanged) {
            ((Component)this).setVisible(false);
            CvDataviewManager.getInstance().closeChild(this);
            this.dispose();
            return;
        }
        int n = UcDialog.showYesNoCancel((String)DataviewUtil.getI18nMsg("editor.confirmQuit(" + this.dataview.getName() + ")"));
        if (n == 2) {
            return;
        }
        if (n == 1) {
            ((Component)this).setVisible(false);
            CvDataviewManager.getInstance().closeChild(this);
            this.dispose();
            return;
        }
        if (n == 0) {
            if (this.save()) {
                ((Component)this).setVisible(false);
                CvDataviewManager.getInstance().closeChild(this);
                this.dispose();
            } else {
                return;
            }
        }
    }

    private void construct(SMViewData sMViewData, int n) {
        Object object;
        Object object2;
        if (dataviewClipboard == null) {
            object2 = CmConsoleSession.getInstance();
            object = (AwxObject)object2.locate("~dvClipboard", true);
            dataviewClipboard = (DataviewClipboard)object.getBean();
        }
        dataviewClipboard.addClipboardListener(new ClipboardListener(){

            public void receiveClipboardEvent(MetaEvent metaEvent) {
                boolean bl = false;
                if (dataviewClipboard.getContent() != null) {
                    bl = true;
                }
                CvDataviewEditor.this.pasteMItem.setEnabled(bl);
                CvDataviewEditor.this.statusBar.setText(DataviewUtil.getI18nMsg("editor.contentReady"));
            }
        });
        this.dataview = sMViewData;
        this.dataviewControler = new DataviewHandler(this);
        this.createGUI();
        if (dataviewClipboard.getContent() != null) {
            this.pasteMItem.setEnabled(true);
        }
        object2 = "";
        object = String.valueOf(this.dataview.getName()) + "[" + UcInternationalizer.translateKey((String)this.dataview.getDomain()) + "]";
        if (n == 0) {
            Runnable runnable = new Runnable(){

                public void run() {
                    CvDataviewEditor.this.showDataview(CvDataviewEditor.this.dataview);
                }
            };
            new Thread(runnable).start();
        } else {
            this.newDataview();
            if (n == 2) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        CvDataviewEditor.this.pasteFromClipboard();
                    }
                };
                new Thread(runnable).start();
            }
        }
        object2 = DataviewUtil.getI18nMsg("editor.title(" + (String)object + ")");
        this.setTitle((String)object2);
        ((Component)this).setSize(600, 400);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                CvDataviewEditor.this.close();
            }
        });
    }

    private void createGUI() {
        this.setDefaultCloseOperation(0);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add(this.dataviewControler.getTablePane());
        this.statusBar = new JLabel();
        this.statusBar.setPreferredSize(new Dimension(100, 30));
        this.statusBar.setBackground(Color.black);
        jPanel.add((Component)this.statusBar, "South");
        this.setContentPane(jPanel);
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        JMenu jMenu = new JMenu(DataviewUtil.getI18nMsg("editor.m.dataviews"));
        this.saveMItem = new JMenuItem(DataviewUtil.getI18nMsg("editor.m.save"));
        this.saveMItem.addActionListener(this);
        jMenu.add(this.saveMItem);
        jMenu.addSeparator();
        this.closeMItem = new JMenuItem(DataviewUtil.getI18nMsg("editor.m.close"));
        this.closeMItem.addActionListener(this);
        jMenu.add(this.closeMItem);
        jMenuBar.add(jMenu);
        jMenu = new JMenu(DataviewUtil.getI18nMsg("editor.m.edit"));
        this.undoMItem = new JMenuItem(DataviewUtil.getI18nMsg("editor.m.undo()"));
        this.undoMItem.setEnabled(false);
        this.undoMItem.addActionListener(this);
        this.pasteMItem = new JMenuItem(DataviewUtil.getI18nMsg("editor.m.pasteFromClipboard"));
        this.pasteMItem.setEnabled(false);
        this.pasteMItem.addActionListener(this);
        jMenu.add(this.pasteMItem);
        this.deleteMItem = new JMenuItem(DataviewUtil.getI18nMsg("editor.m.deleteRow"));
        this.deleteMItem.setEnabled(false);
        this.deleteMItem.addActionListener(this);
        jMenu.add(this.deleteMItem);
        jMenuBar.add(jMenu);
        jMenu = new JMenu(DataviewUtil.getI18nMsg("editor.m.tools"));
        this.attributeMItem = new JMenuItem(DataviewUtil.getI18nMsg("editor.m.attributeEditor"));
        this.attributeMItem.setEnabled(false);
        this.attributeMItem.addActionListener(this);
        jMenu.add(this.attributeMItem);
        jMenuBar.add(jMenu);
        jMenuBar.add(Box.createHorizontalGlue());
        jMenu = new JMenu(DataviewUtil.getI18nMsg("editor.m.help"));
        this.helpMItem = new JMenuItem(DataviewUtil.getI18nMsg("editor.m.help"));
        this.helpMItem.addActionListener(this);
        jMenu.add(this.helpMItem);
        jMenuBar.add(jMenu);
        this.statusBar.setText(DataviewUtil.getI18nMsg("editor.starting"));
    }

    public void dataRowsSelected(boolean bl) {
        this.deleteMItem.setEnabled(bl);
    }

    public String getDataviewName() {
        return this.dataview.getName();
    }

    public String getDomain() {
        if (this.dataview != null) {
            return this.dataview.getDomain();
        }
        return null;
    }

    void newDataview() {
        CvDataviewManager cvDataviewManager = CvDataviewManager.getInstance();
        ViewServiceContext viewServiceContext = new ViewServiceContext((SMView)cvDataviewManager.dataviewHandle, this.dataview);
        this.dataviewControler.setServiceContext(viewServiceContext);
    }

    void pasteFromClipboard() {
        String string = this.dataviewControler.getDomain();
        if (string != null && !string.equals(dataviewClipboard.getDomain())) {
            UcDialog.showError((Component)this, (Object)DataviewUtil.getI18nMsg("editor.domainMismatchWarning"));
            return;
        }
        DataviewContent dataviewContent = dataviewClipboard.getContent();
        String string2 = this.dataviewControler.getType();
        if (string2 != null) {
            String string3;
            String string4;
            if (!string2.equals(dataviewContent.getType())) {
                UcDialog.showError((Component)this, (Object)DataviewUtil.getI18nMsg("editor.typeMismatchWarning"));
                return;
            }
            if (!string2.equals("_CELL_") && !(string4 = this.dataviewControler.getURL()).equals(string3 = dataviewContent.getDataviewURL())) {
                UcDialog.showError((Component)this, (Object)DataviewUtil.getI18nMsg("editor.ModuleMismatchWarning"));
                return;
            }
        }
        this.dataviewControler.pasteContent(dataviewContent);
        this.isChanged = true;
    }

    boolean save() {
        Object object;
        boolean bl = true;
        final String string = this.dataview.getName();
        final String string2 = this.dataview.getDescription();
        Vector vector = UcCommon.showSave((Component)this, (String)DataviewUtil.getI18nMsg("editor.saveDlgTitle"), (String)DataviewUtil.getI18nMsg("editor.dvName"), (int)32, (int)256, (String)string, (String)this.dataview.getDescription());
        if (vector != null) {
            object = (String)vector.elementAt(0);
            if (((String)object).equals(string)) {
                bl = false;
            }
            String string3 = (String)vector.elementAt(1);
            try {
                this.dataview.setDescription(string3);
                this.dataview.setName((String)object);
            }
            catch (SMAPIException sMAPIException) {}
        } else {
            return false;
        }
        object = this.dataviewControler.getServiceContext();
        ((ViewServiceContext)object).setOperationType(ViewServiceContext.SAVE);
        final boolean bl2 = bl;
        UcThreadWorker ucThreadWorker = new UcThreadWorker(){

            public void doWork() {
                statusBar.setText(DataviewUtil.getI18nMsg("editor.saving"));
                if (!this.saveXMLToDataview()) {
                    statusBar.setText(" ");
                    statusBar.setText(DataviewUtil.getI18nMsg("editor.starting"));
                    return;
                }
                if (this.saveToDB(bl2)) {
                    DataviewEditor dataviewEditor = dataviewControler.getEditor();
                    dataviewEditor.turnEditStatusOn(DataviewEditor.SAVE);
                    dataviewEditor.turnEditStatusOff(DataviewEditor.NEW);
                    String string3 = String.valueOf(dataview.getName()) + "[" + UcInternationalizer.translateKey((String)dataview.getDomain()) + "]";
                    this.setTitle(DataviewUtil.getI18nMsg("editor.title(" + string3 + ")"));
                } else {
                    try {
                        dataview.setName(string);
                        dataview.setDescription(string2);
                    }
                    catch (SMAPIException sMAPIException) {}
                }
                statusBar.setText(" ");
                statusBar.setText(DataviewUtil.getI18nMsg("editor.starting"));
            }
        };
        ucThreadWorker.start();
        return true;
    }

    boolean saveToDB(boolean bl) {
        CvDataviewManager cvDataviewManager = CvDataviewManager.getInstance();
        try {
            if (bl) {
                this.dataview = cvDataviewManager.dataviewHandle.saveAs(this.dataview, this.dataview.getName());
                this.dataviewControler.getServiceContext().setViewData(this.dataview);
            } else {
                SMDBObjectID sMDBObjectID = cvDataviewManager.dataviewHandle.save(this.dataview);
            }
            this.isChanged = false;
        }
        catch (SMNoSuchObjectException sMNoSuchObjectException) {
            this.dataview.setObjectID(null);
            return this.saveToDB(bl);
        }
        catch (SMDuplicateException sMDuplicateException) {
            boolean bl2 = false;
            String string = this.dataview.getName();
            String[] stringArray = new String[]{DataviewUtil.getI18nMsg("editor.button.text.yes"), DataviewUtil.getI18nMsg("editor.button.text.no")};
            int n = UcDialog.showYesNo((String)DataviewUtil.getI18nMsg("editor.confirmOverwrite(" + string + ")"));
            if (n != 0) {
                return false;
            }
            cvDataviewManager.delete(this.dataview.getName());
            return this.saveToDB(bl);
        }
        catch (SMAPIException sMAPIException) {
            sMAPIException.printStackTrace();
            UcDialog.showError((Component)this, (Object)sMAPIException.getMessage());
            return false;
        }
        return true;
    }

    boolean saveXMLToDataview() {
        DataviewMetadataWriter dataviewMetadataWriter = new DataviewMetadataWriter();
        try {
            this.dataviewControler.writeTo(dataviewMetadataWriter);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            UcDialog.showError((Component)this, (Object)exception.getMessage());
            return false;
        }
        return true;
    }

    void showDataview(SMViewData sMViewData) {
        this.statusBar.setText(DataviewUtil.getI18nMsg("editor.loading"));
        CvDataviewManager cvDataviewManager = CvDataviewManager.getInstance();
        ViewServiceContext viewServiceContext = new ViewServiceContext((SMView)cvDataviewManager.dataviewHandle, sMViewData);
        this.dataviewControler.setServiceContext(viewServiceContext);
        DataviewMetadataReader dataviewMetadataReader = new DataviewMetadataReader();
        try {
            this.dataviewControler.readFrom(dataviewMetadataReader);
        }
        catch (Exception exception) {
            UcDialog.showError((Component)this, (Object)exception.getMessage());
            this.statusBar.setText(" ");
            this.statusBar.setText(DataviewUtil.getI18nMsg("editor.starting"));
            return;
        }
        this.dataviewControler.showDataviewPane();
        DataviewEditor dataviewEditor = this.dataviewControler.getEditor();
        dataviewEditor.turnEditStatusOn(DataviewEditor.SAVE);
        this.statusBar.setText(" ");
        this.statusBar.setText(DataviewUtil.getI18nMsg("editor.starting"));
    }

    void undo() {
        CvDVUndoableAction cvDVUndoableAction = (CvDVUndoableAction)this.undoStack.pop();
        if (this.undoStack.empty()) {
            this.undoMItem.setText(DataviewUtil.getI18nMsg("editor.m.undo()"));
            this.undoMItem.setEnabled(false);
        } else {
            this.undoMItem.setText(DataviewUtil.getI18nMsg("editor.m.undo(" + ((CvDVUndoableAction)this.undoStack.peek()).getUndoName() + ")"));
        }
        cvDVUndoableAction.undo();
    }

    public void updateUI() {
    }
}

