/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.server.snmp.v2;

import com.sun.symon.base.server.snmp.SsDecodeException;
import com.sun.symon.base.server.snmp.SsEncodeException;
import com.sun.symon.base.server.snmp.SsMessage;
import com.sun.symon.base.server.snmp.jni.SsPacket;
import com.sun.symon.base.server.snmp.v2.SsGetBulkRequest;
import com.sun.symon.base.server.snmp.v2.SsGetNextRequest;
import com.sun.symon.base.server.snmp.v2.SsGetRequest;
import com.sun.symon.base.server.snmp.v2.SsInformRequest;
import com.sun.symon.base.server.snmp.v2.SsResponse;
import com.sun.symon.base.server.snmp.v2.SsSetRequest;
import com.sun.symon.base.server.snmp.v2.SsTrap;

public abstract class SsRequest
extends SsMessage {
    public static final int GET_REQUEST = 0;
    public static final int SET_REQUEST = 1;
    public static final int GET_NEXT_REQUEST = 2;
    public static final int TRAP = 3;
    public static final int INFORM_REQUEST = 4;
    public static final int RESPONSE = 5;
    public static final int GET_BULK_REQUEST = 6;
    public static final int REPORT = 7;

    public SsRequest() {
    }

    public SsRequest(SsPacket ssPacket) throws SsDecodeException {
        this.setState(ssPacket.state);
        this.setText(ssPacket.printStatus());
        this.setHost(ssPacket.host);
        this.setPort(ssPacket.port);
        this.setContextName(ssPacket.context);
        this.setSecurityName(ssPacket.security);
        this.setSecurityLevel(ssPacket.level);
        this.setSecurityModel(ssPacket.model);
        this.setSendId(ssPacket.send);
        this.setRequestId(ssPacket.request);
        this.setVariableNames(ssPacket.name);
        this.setVariableValues(ssPacket.kind, ssPacket.value);
    }

    public static SsMessage decode(SsPacket ssPacket) throws SsDecodeException {
        switch (ssPacket.type) {
            case 0: {
                return new SsGetRequest(ssPacket);
            }
            case 1: {
                return new SsSetRequest(ssPacket);
            }
            case 2: {
                return new SsGetNextRequest(ssPacket);
            }
            case 3: {
                return new SsTrap(ssPacket);
            }
            case 4: {
                return new SsInformRequest(ssPacket);
            }
            case 5: {
                return new SsResponse(ssPacket);
            }
            case 6: {
                return new SsGetBulkRequest(ssPacket);
            }
        }
        throw new SsDecodeException("unknown PDU type");
    }

    public int getVersion() {
        return 2;
    }

    public byte[] toBytestream() throws SsEncodeException {
        SsPacket ssPacket = new SsPacket();
        ssPacket.version = this.getVersion();
        ssPacket.state = this.getState();
        ssPacket.security = this.getSecurityName();
        ssPacket.level = this.getSecurityLevel();
        ssPacket.model = this.getSecurityModel();
        ssPacket.host = this.getHost();
        ssPacket.port = this.getPort();
        ssPacket.context = this.getContextName();
        ssPacket.type = this.getType();
        ssPacket.send = this.getSendId();
        ssPacket.request = this.getRequestId();
        ssPacket.name = this.getVariableNames();
        ssPacket.kind = this.getVariableTypes();
        ssPacket.value = this.getVariableValues();
        byte[] byArray = ssPacket.outgoing();
        ssPacket = null;
        return byArray;
    }
}

