/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.ejb.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import oracle.aurora.ejb.parser.CharStream;
import oracle.aurora.ejb.parser.OracleOutputStreamWriter;
import sun.io.CharToByteConverter;
import sun.io.MalformedInputException;

public class UCode_CharStream
implements CharStream {
    protected static final int DEFAULT_BUFFERSIZE = 4096;
    private static final String DEFAULT_ENCODING = "8859_1";
    private static final char LF_CHAR = '\n';
    private static final char CR_CHAR = '\r';
    private static final int EOF_CHAR = 65535;
    private static final int EOF_LINE = -999;
    private boolean CR_SEEN;
    private int escapesSeen;
    private boolean m_processUEscapes;
    private int m_bufpos;
    private int m_bufsize;
    private int m_backup;
    private char[] m_buf;
    private int[] m_bufcol;
    private int[] m_bufline;
    private int m_line;
    private int m_col;
    private int m_token_begin;
    private int tokenSize;
    private int tokenBeginLine;
    private int tokenBeginColumn;
    protected Reader m_r = null;
    protected CharToByteConverter m_charconv = null;
    private BufferedReader m_br = null;
    private static final int CONV_BUFFER_SIZE = 50;
    private int[] convBuffer = new int[50];
    private int convBufferIndex = 0;
    private int convBufferNext = 0;

    public UCode_CharStream() {
        this((Reader)null);
    }

    public UCode_CharStream(InputStream in) throws UnsupportedEncodingException {
        this(in, 4096, null);
    }

    public UCode_CharStream(InputStream in, int buffersize) throws UnsupportedEncodingException {
        this(in, buffersize, null);
    }

    public UCode_CharStream(InputStream in, int buffersize, String encoding) throws UnsupportedEncodingException {
        if (encoding == null || encoding.equals("")) {
            encoding = System.getProperty("file.encoding", DEFAULT_ENCODING);
        }
        this.m_charconv = CharToByteConverter.getConverter((String)encoding);
        this.m_r = new InputStreamReader(in, encoding);
        this.m_bufsize = buffersize;
        this.initialize();
    }

    public UCode_CharStream(InputStream in, String encoding) throws UnsupportedEncodingException {
        this(in, 4096, encoding);
    }

    public UCode_CharStream(Reader in) {
        this(in, 4096);
    }

    public UCode_CharStream(Reader in, int buffersize) {
        this.m_r = in;
        this.m_bufsize = buffersize;
        this.initialize();
    }

    public UCode_CharStream(Reader in, int buffersize, boolean processUCodeEscapes) {
        this.m_r = in;
        this.m_bufsize = buffersize;
        this.initialize();
        this.m_processUEscapes = processUCodeEscapes;
    }

    public UCode_CharStream(Reader in, boolean processUCodeEscapes) {
        this(in, 4096, processUCodeEscapes);
    }

    public char BeginToken() throws IOException {
        this.tokenSize = 0;
        this.read();
        char i = this.m_buf[this.m_bufpos];
        if (i == '\uffff' && this.m_bufline[this.m_bufpos] == -999) {
            throw new IOException("EOF");
        }
        this.tokenBeginLine = this.m_bufline[this.m_bufpos];
        this.tokenBeginColumn = this.m_bufcol[this.m_bufpos];
        this.m_token_begin = this.m_bufpos;
        return i;
    }

    public void Done() {
        this.m_buf = null;
        this.m_bufcol = null;
        this.m_bufline = null;
    }

    public String GetImage() throws IllegalArgumentException {
        if (this.tokenSize < 0) {
            throw new IllegalArgumentException("GetImage(): invalid token boundary");
        }
        StringBuffer sb = new StringBuffer(this.tokenSize);
        if (this.m_bufpos + 1 >= this.tokenSize) {
            sb.append(this.m_buf, this.m_bufpos - this.tokenSize + 1, this.tokenSize);
        } else {
            sb.append(this.m_buf, this.m_bufsize - (this.tokenSize - this.m_bufpos - 1), this.tokenSize - this.m_bufpos - 1);
            sb.append(this.m_buf, 0, this.m_bufpos + 1);
        }
        return sb.toString();
    }

    public char[] GetSuffix(int len) throws IllegalArgumentException {
        if (len > this.m_bufsize) {
            throw new IllegalArgumentException("GetSuffix(" + len + ") " + "exceeds buffer size " + this.m_bufsize);
        }
        char[] carr = new char[len];
        if (this.m_bufpos + 1 >= len) {
            System.arraycopy(this.m_buf, this.m_bufpos - len + 1, carr, 0, len);
        } else {
            System.arraycopy(this.m_buf, this.m_bufsize - (len - this.m_bufpos - 1), carr, 0, len - this.m_bufpos - 1);
            System.arraycopy(this.m_buf, 0, carr, len - this.m_bufpos - 1, this.m_bufpos + 1);
        }
        return carr;
    }

    public void backup(int amount) throws IllegalArgumentException {
        if (this.m_bufsize < amount) {
            throw new IllegalArgumentException("backup(" + amount + ") " + "exceeds buffer size " + this.m_bufsize);
        }
        this.m_bufpos -= amount;
        if (this.m_bufpos < 0) {
            this.m_bufpos += this.m_bufsize;
        }
        this.tokenSize -= amount;
        this.m_backup += amount;
    }

    public int getBeginColumn() {
        return this.tokenBeginColumn;
    }

    public int getBeginLine() {
        return this.tokenBeginLine;
    }

    public int getColumn() {
        return this.getEndColumn();
    }

    public int getEndColumn() {
        if (this.m_bufpos < 0) {
            return -1;
        }
        return this.m_bufcol[this.m_bufpos];
    }

    public int getEndLine() {
        if (this.m_bufpos < 0) {
            return -1;
        }
        return this.m_bufline[this.m_bufpos];
    }

    public int getLine() {
        return this.getEndLine();
    }

    public Reader getReader() {
        return this.m_r;
    }

    int hex(int ch) {
        if (ch >= 48 && ch <= 57) {
            return ch - 48;
        }
        if (ch >= 65 && ch <= 70) {
            return ch - 65 + 10;
        }
        if (ch >= 97 && ch <= 102) {
            return ch - 97 + 10;
        }
        return -1;
    }

    private void illegalCharacter(char c) {
        String s = "Illegal input character: " + OracleOutputStreamWriter.getEscape(c);
        this.message(s, this.getEndLine(), this.getEndColumn());
    }

    private void illegalUcodeCharacter(int c, int advance) {
        String s = "Illegal character in Unicode escape: '" + (char)c + "'";
        this.message(s, this.getEndLine(), this.getEndColumn() + advance);
    }

    private void illegallyEncodedCharacter() {
        String s = "Malformed input character";
        this.message(s, this.getEndLine(), this.getEndColumn());
    }

    private void initialize() {
        this.m_buf = new char[this.m_bufsize];
        this.m_bufcol = new int[this.m_bufsize];
        this.m_bufline = new int[this.m_bufsize];
        this.m_bufpos = -1;
        this.m_backup = 0;
        this.m_line = 1;
        this.m_col = 0;
        this.tokenBeginLine = 1;
        this.tokenBeginColumn = 0;
        this.tokenSize = 0;
        this.m_token_begin = 0;
        if (this.m_r != null) {
            this.m_br = new BufferedReader(this.m_r, 4096);
        }
        this.CR_SEEN = false;
        this.escapesSeen = 0;
        this.m_processUEscapes = true;
    }

    private void message(String msg, int line, int col) {
        System.out.println(String.valueOf(line) + "." + col + ": " + msg);
    }

    private void read() throws IOException {
        ++this.tokenSize;
        if (this.m_backup > 0) {
            --this.m_backup;
            this.m_bufpos = (this.m_bufpos + 1) % this.m_bufsize;
            if (this.m_buf[this.m_bufpos] == '\uffff' && this.m_bufline[this.m_bufpos] == -999) {
                throw new IOException("EOF");
            }
        } else {
            int i = this.readUnicodeCharacter();
            if (i == -1) {
                throw new IOException("EOF");
            }
            this.m_bufpos = (this.m_bufpos + 1) % this.m_bufsize;
            if (this.tokenSize >= this.m_bufsize) {
                char[] tmp = new char[this.m_bufsize + this.m_bufsize];
                int[] tmpline = new int[this.m_bufsize + this.m_bufsize];
                int[] tmpcol = new int[this.m_bufsize + this.m_bufsize];
                int idx = 0;
                int j = this.m_token_begin;
                while (j < this.m_bufsize) {
                    tmp[idx] = this.m_buf[j];
                    tmpline[idx] = this.m_bufline[j];
                    tmpcol[idx] = this.m_bufcol[j];
                    ++j;
                    ++idx;
                }
                int j2 = 0;
                while (j2 < this.m_token_begin) {
                    tmp[idx] = this.m_buf[j2];
                    tmpline[idx] = this.m_bufline[j2];
                    tmpcol[idx] = this.m_bufcol[j2];
                    ++j2;
                    ++idx;
                }
                this.m_token_begin = 0;
                this.m_bufpos = this.m_bufsize - 1;
                this.m_bufsize += this.m_bufsize;
                this.m_buf = tmp;
                this.m_bufline = tmpline;
                this.m_bufcol = tmpcol;
            }
            this.m_buf[this.m_bufpos] = (char)i;
            if (i == 10) {
                this.m_bufline[this.m_bufpos] = this.m_line++;
                this.m_bufcol[this.m_bufpos] = this.m_col;
                if (this.CR_SEEN) {
                    this.CR_SEEN = false;
                    --this.tokenSize;
                    --this.m_bufpos;
                    this.read();
                    this.m_col = 1;
                } else {
                    this.m_col = 0;
                }
            } else if (i == 13) {
                this.m_buf[this.m_bufpos] = 10;
                this.CR_SEEN = true;
                this.m_bufline[this.m_bufpos] = this.m_line++;
                this.m_bufcol[this.m_bufpos] = this.m_col;
                this.m_col = 0;
            } else {
                this.CR_SEEN = false;
                this.m_bufline[this.m_bufpos] = i < 0 ? -999 : this.m_line;
                this.m_bufcol[this.m_bufpos] = this.m_col;
            }
        }
    }

    public final char readChar() throws IOException {
        this.read();
        char i = this.m_buf[this.m_bufpos];
        if (i == '\uffff' && this.m_bufline[this.m_bufpos] == -999) {
            throw new IOException("EOF");
        }
        return i;
    }

    private int readUnicodeCharacter() throws IOException {
        int i;
        if (this.convBufferIndex < this.convBufferNext) {
            i = this.convBuffer[this.convBufferIndex++];
            ++this.m_col;
            if (this.convBufferIndex == this.convBufferNext) {
                this.convBufferIndex = 0;
                this.convBufferNext = 0;
            }
        } else {
            try {
                i = this.m_br.read();
                ++this.m_col;
                if (i == 92 && this.escapesSeen == 0) {
                    int j = this.m_br.read();
                    this.convBuffer[this.convBufferNext++] = j;
                    if (j == 117) {
                        while ((j = this.m_br.read()) == 117) {
                            this.convBuffer[this.convBufferNext++] = j;
                        }
                        this.convBuffer[this.convBufferNext++] = j;
                        int ch = 0;
                        int v = 0;
                        ch = this.hex(j);
                        if (ch >= 0) {
                            j = this.m_br.read();
                            this.convBuffer[this.convBufferNext++] = j;
                            v = this.hex(j);
                            if (v >= 0) {
                                ch = ch * 16 + v;
                                j = this.m_br.read();
                                this.convBuffer[this.convBufferNext++] = j;
                                v = this.hex(j);
                                if (v >= 0) {
                                    ch = ch * 16 + v;
                                    j = this.m_br.read();
                                    this.convBuffer[this.convBufferNext++] = j;
                                    v = this.hex(j);
                                    if (v >= 0) {
                                        ch = ch * 16 + v;
                                        this.m_col += this.convBufferNext;
                                        this.convBufferNext = 0;
                                        this.convBufferIndex = 0;
                                        return ch;
                                    }
                                    this.illegalUcodeCharacter(j, this.convBufferNext - 1);
                                } else {
                                    this.illegalUcodeCharacter(j, this.convBufferNext - 1);
                                }
                            } else {
                                this.illegalUcodeCharacter(j, this.convBufferNext - 1);
                            }
                        } else {
                            this.illegalUcodeCharacter(j, this.convBufferNext - 1);
                        }
                    }
                }
            }
            catch (IOException exn) {
                if (exn instanceof MalformedInputException) {
                    this.illegallyEncodedCharacter();
                }
                throw exn;
            }
        }
        if (i == 92) {
            ++this.escapesSeen;
            this.escapesSeen %= 2;
        } else {
            this.escapesSeen = 0;
        }
        return i;
    }
}

