/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server.tools.loadjava;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import java.util.zip.ZipEntry;
import md5.MD5InputStream;
import oracle.aurora.server.tools.loadjava.ClassFileReader;
import oracle.aurora.server.tools.loadjava.ToolsException;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OraclePreparedStatement;

public class IsClassDifferentImpl {
    byte[] md5;
    Connection conn;
    String filename;
    String username_password = "internal/oracle";
    String database = "@localhost:1521:orcl";

    String classNameFrom(String name) {
        return name.substring(0, name.lastIndexOf(".class")).replace('.', '/').replace('\\', '/');
    }

    boolean fileIsDifferent(String fileName, InputStream file) throws SQLException {
        boolean result = true;
        this.md5 = this.md5OfStream(file);
        Statement stmt = this.conn.createStatement();
        stmt.execute("SELECT MD5 FROM JAVA$CLASS$MD5$TABLE WHERE NAME = '" + fileName + "'");
        ResultSet rs = stmt.getResultSet();
        if (rs.next()) {
            result = this.md5IsEqual(rs.getBytes(1), this.md5) ^ true;
        }
        stmt.close();
        return result;
    }

    boolean isClassEntry(ZipEntry entry) {
        return entry.getName().endsWith(".class");
    }

    void loadFile(String fileName, InputStream file) throws SQLException, IOException {
        long byte_count;
        byte[] buf = new byte[4096];
        this.msg("loading file " + fileName);
        CallableStatement cs = this.conn.prepareCall("begin ? := loadlobs.beginload( ? ); end;");
        cs.registerOutParameter(1, 12);
        cs.setString(2, fileName);
        cs.execute();
        String err = cs.getString(1);
        if (!cs.wasNull()) {
            System.out.println(err);
        }
        cs.close();
        ((OracleConnection)this.conn).setDefaultExecuteBatch(100);
        cs = this.conn.prepareCall("begin loadlobs.appendpiece(?, ?); end;");
        int loop_count = 0;
        while ((byte_count = (long)file.read(buf, 0, buf.length)) >= 1L) {
            cs.setBytes(1, buf);
            cs.setLong(2, byte_count);
            cs.execute();
            ++loop_count;
        }
        int rows_updated = ((OraclePreparedStatement)cs).sendBatch();
        cs.close();
        cs = this.conn.prepareCall("begin ? := loadlobs.endload( ? ); end;");
        cs.registerOutParameter(1, 12);
        cs.setString(2, fileName);
        cs.execute();
        err = cs.getString(1);
        if (!cs.wasNull()) {
            System.out.println(err);
        }
        cs.close();
    }

    boolean md5IsEqual(byte[] a1, byte[] a2) {
        int i = 0;
        while (i < 16) {
            if (a1[i] != a2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    byte[] md5OfStream(InputStream in) {
        int l;
        MD5InputStream md5in = new MD5InputStream(in);
        do {
            try {
                l = md5in.read();
            }
            catch (IOException iOException) {
                l = -1;
            }
        } while (l >= 0);
        return md5in.hash();
    }

    void msg(String msg) {
        System.err.println(msg);
    }

    /*
     * Unable to fully structure code
     */
    public void run(String[] args) throws SQLException, ClassNotFoundException, IOException {
        Class.forName("oracle.jdbc.driver.OracleDriver");
        filenames = new Vector<E>(20, 10);
        i = 0;
        while (i < args.length) {
            if (args[i].startsWith("@")) {
                this.database = args[i];
            } else if (args[i].startsWith("-P")) {
                this.username_password = args[i].substring(2);
            } else {
                this.filename = args[i];
            }
            ++i;
        }
        this.msg("Parsed command-line arguments:");
        this.msg("database = '" + this.database + "'");
        this.msg("username/password = '" + this.username_password + "'");
        this.msg("file:" + this.filename);
        file = new FileInputStream(this.filename);
        try {
            try {
                className = new ClassFileReader(this.filename, file).fullyQualifiedClassName().replace('.', '/');
                file.close();
                file = new FileInputStream(this.filename);
                if (this.fileIsDifferent(className, file)) {
                    System.out.println("TRUE");
                } else {
                    System.out.println("FALSE");
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            catch (ToolsException e) {
                e.printStackTrace();
            }
            var8_8 = null;
            ** if (file == null) goto lbl-1000
        }
        catch (Throwable var7_10) {
            var8_9 = null;
            if (file != null) {
                file.close();
            }
            throw var7_10;
        }
lbl-1000:
        // 1 sources

        {
            file.close();
        }
lbl-1000:
        // 2 sources

        {
        }
        this.conn = DriverManager.getConnection("jdbc:oracle:thin:" + this.username_password + this.database);
        this.conn.setAutoCommit(false);
        this.conn.commit();
        this.conn.close();
    }
}

