/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.tools.editor;

import com.sun.symon.base.client.attribute.SMAttributeEntryData;
import com.sun.symon.base.console.tools.editor.CommentArea;
import com.sun.symon.base.console.tools.editor.CtActionBoolean;
import com.sun.symon.base.console.tools.editor.CtActionField;
import com.sun.symon.base.console.tools.editor.CtActionSelectionListener;
import com.sun.symon.base.console.tools.editor.CtAttributeEditor;
import com.sun.symon.base.console.tools.editor.CtBooleanField;
import com.sun.symon.base.console.tools.editor.CtFocusTraversable;
import com.sun.symon.base.console.tools.editor.CtListField;
import com.sun.symon.base.console.tools.editor.CtPasswordField;
import com.sun.symon.base.console.tools.editor.CtTextArea;
import com.sun.symon.base.console.tools.editor.CtTextField;
import com.sun.symon.base.console.tools.editor.CtTimexField;
import com.sun.symon.base.utility.UcDDL;
import com.sun.symon.base.utility.UcInternationalizer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.io.IOException;
import java.text.Collator;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;

public class CtEditorListPanel
extends JPanel {
    private CtAttributeEditor theEditor;
    private SMAttributeEntryData[] attributes;
    private int attSize;
    private String currentGroupKey;
    private GridBagLayout gridbag = new GridBagLayout();
    private GridBagConstraints c = new GridBagConstraints();
    JPanel top = new JPanel();
    Hashtable editableComps = new Hashtable();

    public CtEditorListPanel(String string, SMAttributeEntryData[] sMAttributeEntryDataArray, CtAttributeEditor ctAttributeEditor) {
        if (sMAttributeEntryDataArray == null || sMAttributeEntryDataArray.length == 0 || sMAttributeEntryDataArray[0] == null) {
            return;
        }
        this.theEditor = ctAttributeEditor;
        this.currentGroupKey = string;
        this.attSize = sMAttributeEntryDataArray.length;
        this.attributes = sMAttributeEntryDataArray;
        this.top.setLayout(this.gridbag);
        int n = this.lastFocusableIndex();
        int n2 = 0;
        while (n2 < this.attSize) {
            SMAttributeEntryData sMAttributeEntryData = sMAttributeEntryDataArray[n2];
            String string2 = sMAttributeEntryData.getFormat();
            String string3 = this.getRealFormat(string2);
            String string4 = sMAttributeEntryData.getValue();
            String string5 = sMAttributeEntryData.getDescId();
            String string6 = sMAttributeEntryData.getKey();
            boolean bl = sMAttributeEntryData.getAccess();
            string5 = string5.replace('\t', ' ');
            if (string3.equals("separator")) {
                this.addSeparator();
            } else if (string3.equals("blank")) {
                this.addBlankLine();
            } else if (string3.equals("header")) {
                this.addHeader(string5, string4);
            } else if (string3.equals("comment")) {
                this.addComments(string5, string4);
            } else if (string3.equals("i18ncomment")) {
                this.addInternationalizedComments(string5, string4);
                this.addBlankLine();
            } else if (string3.equals("i18n")) {
                this.addInternationalizedText(string5, string4);
            } else if (string3.equals("boolean")) {
                this.addCheckBox(sMAttributeEntryData);
            } else if (string3.equals("list")) {
                this.addList(sMAttributeEntryData);
            } else if (string3.equals("password")) {
                this.addPassword(sMAttributeEntryData);
            } else if (string3.equals("timex")) {
                this.addTimex(sMAttributeEntryData, false);
            } else if (string3.equals("timewindow")) {
                this.addTimex(sMAttributeEntryData, true);
            } else if (string3.equals("scheduletime")) {
                this.addModuleScheduleTime(sMAttributeEntryData);
            } else if (string3.equals("multi-line")) {
                this.addMultiLines(sMAttributeEntryData);
            } else if (string3.equals("action")) {
                this.addAction(sMAttributeEntryData, false);
            } else if (string3.equals("actionauto")) {
                this.addAction(sMAttributeEntryData, true);
            } else if (string3.length() > 5 && string3.substring(0, 5).equals("width")) {
                this.addFixedLengthText(sMAttributeEntryData);
            } else if (!bl) {
                if (!string3.equals("nodisplay")) {
                    this.addReadonlyField(string5, string4);
                }
            } else {
                this.addTextField(sMAttributeEntryData);
            }
            ++n2;
        }
        this.setLayout(new BorderLayout());
        this.add("North", this.top);
        this.firstGrabFocus();
    }

    private void addAction(SMAttributeEntryData sMAttributeEntryData, boolean bl) {
        JLabel jLabel = new JLabel(String.valueOf(sMAttributeEntryData.getDescId()) + ":");
        jLabel.setFont(this.theEditor.getLabelFont());
        this.c.weightx = 0.0;
        this.c.anchor = 12;
        this.c.fill = 0;
        this.c.gridwidth = 1;
        this.c.insets = new Insets(12, 12, 0, 0);
        this.top.add((Component)jLabel, this.c);
        CtActionField ctActionField = new CtActionField(sMAttributeEntryData, this.currentGroupKey, this.theEditor, bl);
        this.editableComps.put(sMAttributeEntryData.getKey(), ctActionField);
        this.c.anchor = 18;
        this.c.fill = 2;
        this.c.weightx = 1.0;
        this.c.insets = new Insets(11, 5, 0, 0);
        this.top.add((Component)ctActionField, this.c);
        String string = UcInternationalizer.translateKey((String)"base.console.tools.editor.ActionLabels:actions");
        String string2 = UcInternationalizer.translateKey((String)"base.console.tools.editor.ActionLabels:title");
        JButton jButton = new JButton(string);
        jButton.addActionListener(new CtActionSelectionListener(this, ctActionField));
        this.c.weightx = 0.0;
        this.c.fill = 0;
        this.c.insets = new Insets(11, 6, 0, 0);
        if (bl) {
            this.c.gridwidth = 0;
        }
        this.top.add((Component)jButton, this.c);
        CtActionBoolean ctActionBoolean = new CtActionBoolean(this.theEditor, ctActionField);
        ctActionField.setComps(jButton, ctActionBoolean);
        ctActionBoolean.setSelected(ctActionField.getInitialManualValue());
        ctActionBoolean.setFont(this.theEditor.getAttValueFont());
        if (!bl) {
            this.c.gridwidth = 0;
            this.top.add((Component)ctActionBoolean, this.c);
        }
    }

    private void addBlankLine() {
        this.c.weightx = 1.0;
        this.c.fill = 2;
        this.c.gridwidth = 0;
        this.c.gridheight = 1;
        this.c.insets = new Insets(0, 0, 0, 0);
        JLabel jLabel = new JLabel(" ");
        this.top.add((Component)jLabel, this.c);
    }

    private void addCheckBox(SMAttributeEntryData sMAttributeEntryData) {
        JLabel jLabel = new JLabel(String.valueOf(sMAttributeEntryData.getDescId()) + ":", 4);
        CtBooleanField ctBooleanField = new CtBooleanField(sMAttributeEntryData, this.currentGroupKey, this.theEditor);
        ctBooleanField.setBackground(new JLabel().getBackground());
        this.editableComps.put(sMAttributeEntryData.getKey(), ctBooleanField);
        JLabel jLabel2 = new JLabel("");
        this.addRow(jLabel, ctBooleanField);
    }

    private void addComments(String string, String string2) {
        JLabel jLabel = new JLabel(String.valueOf(string) + ":", 4);
        jLabel.setFont(this.theEditor.getLabelFont());
        this.c.weightx = 0.0;
        this.c.fill = 0;
        this.c.gridwidth = 1;
        this.c.anchor = 12;
        this.c.insets = new Insets(12, 12, 0, 0);
        this.top.add((Component)jLabel, this.c);
        CommentArea commentArea = new CommentArea(string2);
        commentArea.setEditable(false);
        commentArea.setLineWrap(true);
        commentArea.setWrapStyleWord(true);
        JScrollPane jScrollPane = new JScrollPane(commentArea);
        jScrollPane.setFont(this.theEditor.getAttValueFont());
        jScrollPane.setForeground(this.theEditor.getAttValueForeground());
        commentArea.setRows(4);
        commentArea.setMargin(new Insets(4, 5, 5, 5));
        this.c.weightx = 1.0;
        this.c.weighty = 1.0;
        this.c.fill = 1;
        this.c.gridwidth = 0;
        this.c.anchor = 18;
        this.c.insets = new Insets(12, 5, 0, 6);
        this.top.add((Component)jScrollPane, this.c);
    }

    private void addFixedLengthText(SMAttributeEntryData sMAttributeEntryData) {
        JLabel jLabel = new JLabel(sMAttributeEntryData.getDescId(), 4);
        this.c.weightx = 0.0;
        this.c.fill = 0;
        this.c.gridwidth = 1;
        this.c.insets = new Insets(12, 12, 0, 0);
        this.top.add((Component)jLabel, this.c);
        jLabel.setFont(this.theEditor.getLabelFont());
        CtTextField ctTextField = new CtTextField(sMAttributeEntryData, this.currentGroupKey, this.theEditor);
        this.editableComps.put(sMAttributeEntryData.getKey(), ctTextField);
        try {
            int n = Integer.parseInt(sMAttributeEntryData.getFormat().substring(6).trim());
            ctTextField.setPreferredSize(new Dimension(n, ctTextField.getPreferredSize().height));
        }
        catch (NumberFormatException numberFormatException) {}
        ctTextField.setFont(this.theEditor.getAttValueFont());
        ctTextField.setForeground(this.theEditor.getAttValueForeground());
        this.c.weightx = 0.0;
        this.c.fill = 2;
        this.c.gridwidth = 1;
        this.c.insets = new Insets(11, 5, 0, 0);
        this.top.add((Component)ctTextField, this.c);
        JLabel jLabel2 = new JLabel("");
        this.c.weightx = 1.0;
        this.c.fill = 2;
        this.c.gridwidth = 0;
        this.top.add((Component)jLabel2, this.c);
    }

    private void addHeader(String string, String string2) {
        JLabel jLabel = new JLabel(string);
        JLabel jLabel2 = new JLabel(UcInternationalizer.translateKey((String)string2));
        String string3 = UcInternationalizer.translateKey((String)"com.sun.symon.base.console.ConsoleGeneric:editAtt.actionstate");
        Collator collator = Collator.getInstance();
        if (collator.compare(string, string3) == 0) {
            this.c.anchor = 18;
            this.c.fill = 0;
            this.c.weightx = 1.0;
            this.c.gridwidth = 3;
            this.c.insets = new Insets(0, 0, 0, 0);
            this.top.add((Component)new JLabel(""), this.c);
            this.c.weightx = 0.0;
            this.c.gridwidth = 0;
            this.c.insets = new Insets(8, 6, 0, 6);
            this.top.add((Component)jLabel, this.c);
        } else {
            this.addRow(jLabel, jLabel2);
            jLabel.setForeground(this.theEditor.getHeaderForeground());
            jLabel.setFont(this.theEditor.getHeaderFont());
            jLabel2.setFont(this.theEditor.getHeaderFont());
        }
    }

    private void addInternationalizedComments(String string, String string2) {
        String string3 = UcInternationalizer.translateKey((String)string2);
        this.addComments(string, string3);
    }

    private void addInternationalizedText(String string, String string2) {
        String string3 = UcInternationalizer.translateKey((String)string2);
        this.addReadonlyField(string, string3);
    }

    private void addList(SMAttributeEntryData sMAttributeEntryData) {
        JLabel jLabel = new JLabel(String.valueOf(sMAttributeEntryData.getDescId()) + ":", 4);
        CtListField ctListField = new CtListField(sMAttributeEntryData, this.currentGroupKey, this.theEditor);
        ctListField.setBackground(this.theEditor.getAttValueBackground());
        this.editableComps.put(sMAttributeEntryData.getKey(), ctListField);
        JLabel jLabel2 = new JLabel("");
        this.addRow(jLabel, ctListField);
    }

    private void addModuleScheduleTime(SMAttributeEntryData sMAttributeEntryData) {
    }

    private void addMultiLines(SMAttributeEntryData sMAttributeEntryData) {
        JLabel jLabel = new JLabel(sMAttributeEntryData.getDescId(), 4);
        jLabel.setFont(this.theEditor.getAttNameFont());
        jLabel.setForeground(this.theEditor.getLabelForeground());
        CtTextArea ctTextArea = new CtTextArea(sMAttributeEntryData, this.currentGroupKey, this.theEditor);
        this.editableComps.put(sMAttributeEntryData.getKey(), ctTextArea);
        ctTextArea.setFont(this.theEditor.getAttValueFont());
        ctTextArea.setForeground(this.theEditor.getAttValueForeground());
        this.c.weightx = 0.0;
        this.c.fill = 2;
        this.c.gridwidth = 1;
        this.top.add((Component)jLabel, this.c);
        this.c.weightx = 1.0;
        this.c.fill = 2;
        this.c.gridwidth = 0;
        this.c.gridheight = 3;
        this.top.add((Component)ctTextArea, this.c);
        this.c.gridheight = 1;
    }

    private void addPassword(SMAttributeEntryData sMAttributeEntryData) {
        JLabel jLabel = new JLabel(sMAttributeEntryData.getDescId(), 4);
        CtPasswordField ctPasswordField = new CtPasswordField(sMAttributeEntryData, this.currentGroupKey, this.theEditor);
        this.editableComps.put(sMAttributeEntryData.getKey(), ctPasswordField);
        this.addRow(jLabel, ctPasswordField);
    }

    private void addReadonlyField(String string, String string2) {
        JLabel jLabel = new JLabel(String.valueOf(string) + ":", 4);
        JLabel jLabel2 = new JLabel(string2);
        this.addRow(jLabel, jLabel2);
    }

    private void addRow(Component component, Component component2) {
        component.setFont(this.theEditor.getLabelFont());
        component2.setFont(this.theEditor.getAttValueFont());
        component2.setForeground(this.theEditor.getAttValueForeground());
        this.c.weightx = 0.0;
        this.c.anchor = 12;
        this.c.fill = 0;
        this.c.gridwidth = 1;
        this.c.insets = new Insets(4, 6, 0, 0);
        this.top.add(component, this.c);
        this.c.weightx = 1.0;
        this.c.anchor = 18;
        this.c.fill = 2;
        this.c.gridwidth = 0;
        this.c.insets = new Insets(4, 5, 0, 6);
        this.top.add(component2, this.c);
    }

    private void addRow(Component component, Component component2, Component component3) {
        component.setFont(this.theEditor.getLabelFont());
        component2.setFont(this.theEditor.getAttValueFont());
        component2.setForeground(this.theEditor.getAttValueForeground());
        this.c.weightx = 0.0;
        this.c.fill = 2;
        this.c.gridwidth = 1;
        this.top.add(component, this.c);
        this.c.weightx = 0.0;
        this.c.fill = 2;
        this.c.gridwidth = 1;
        this.top.add(component2, this.c);
        this.c.weightx = 1.0;
        this.c.fill = 2;
        this.c.gridwidth = 0;
        this.top.add(component3, this.c);
    }

    private void addSeparator() {
        this.c.weightx = 1.0;
        this.c.fill = 2;
        this.c.gridwidth = 0;
        this.c.insets = new Insets(12, 6, 0, 6);
        JSeparator jSeparator = new JSeparator();
        this.top.add((Component)jSeparator, this.c);
    }

    private void addTextField(SMAttributeEntryData sMAttributeEntryData) {
        JLabel jLabel = new JLabel(String.valueOf(sMAttributeEntryData.getDescId()) + ":", 4);
        CtTextField ctTextField = new CtTextField(sMAttributeEntryData, this.currentGroupKey, this.theEditor);
        this.editableComps.put(sMAttributeEntryData.getKey(), ctTextField);
        this.addRow(jLabel, ctTextField);
    }

    private void addTimex(SMAttributeEntryData sMAttributeEntryData, boolean bl) {
        Object object;
        JLabel jLabel = new JLabel(String.valueOf(sMAttributeEntryData.getDescId()) + ":", 4);
        try {
            object = this.loadImage("timex16x16.gif");
            jLabel.setIcon(new ImageIcon((Image)object));
        }
        catch (IOException iOException) {
            UcDDL.logErrorMessage((String)"CtEditorListPanel::addTimex -- failed to load image timex16x16.gif");
        }
        object = new CtTimexField(sMAttributeEntryData, this.currentGroupKey, this.theEditor, bl);
        this.editableComps.put(sMAttributeEntryData.getKey(), object);
        ((JComponent)object).setBackground(new JLabel().getBackground());
        this.addRow(jLabel, (Component)object);
    }

    JComponent firstFocusableComp() {
        JComponent[] jComponentArray = this.getAllComponents();
        if (jComponentArray != null && jComponentArray[0] != null) {
            int n = 0;
            while (n < jComponentArray.length) {
                if (jComponentArray[n] instanceof CtFocusTraversable) {
                    return jComponentArray[n];
                }
                ++n;
            }
        }
        return null;
    }

    void firstGrabFocus() {
        JComponent jComponent = this.firstFocusableComp();
        if (jComponent == null) {
            return;
        }
        jComponent.requestFocus();
    }

    JComponent[] getAllComponents() {
        if (this.getComponentCount() != 0 && this.top.getComponentCount() != 0) {
            int n = this.top.getComponentCount();
            JComponent[] jComponentArray = new JComponent[n];
            int n2 = 0;
            while (n2 < n) {
                jComponentArray[n2] = (JComponent)this.top.getComponent(n2);
                ++n2;
            }
            return jComponentArray;
        }
        return null;
    }

    public Insets getInsets() {
        return new Insets(0, 4, 0, 4);
    }

    JComponent getInvalidField(String string) {
        return (JComponent)this.editableComps.get(string);
    }

    String getRealFormat(String string) {
        int n = string.indexOf(58, 0);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    public boolean isFocusCycleRoot() {
        return true;
    }

    public boolean isRequestFocusEnabled() {
        return true;
    }

    int lastFocusableIndex() {
        int n = this.attSize - 1;
        while (n >= 0) {
            SMAttributeEntryData sMAttributeEntryData = this.attributes[n];
            if (sMAttributeEntryData.getAccess()) {
                return n;
            }
            --n;
        }
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    private Image loadImage(String var1_1) throws IOException {
        var2_2 = this.getClass().getResourceAsStream(var1_1);
        if (var2_2 == null) {
            return null;
        }
        var3_3 = new byte[1024];
        var4_4 = new byte[1024];
        var5_5 = 0;
        while (true) {
            if ((var6_6 = var2_2.read(var4_4)) >= 0) ** GOTO lbl13
            break;
lbl-1000:
            // 1 sources

            {
                var7_7 = new byte[var3_3.length * 2];
                System.arraycopy(var3_3, 0, var7_7, 0, var5_5);
                var3_3 = var7_7;
lbl13:
                // 2 sources

                ** while (var6_6 + var5_5 >= var3_3.length)
            }
lbl14:
            // 1 sources

            System.arraycopy(var4_4, 0, var3_3, var5_5, var6_6);
            var5_5 += var6_6;
        }
        var2_2.close();
        return Toolkit.getDefaultToolkit().createImage(var3_3, 0, var5_5);
    }

    private String[] splitString(String string, String string2) {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n != -1) {
            int n2 = string.indexOf(string2, n);
            if (n2 == -1) {
                vector.addElement(string.substring(n));
                n = -1;
                continue;
            }
            vector.addElement(string.substring(n, n2));
            n = n2 + 1;
        }
        String[] stringArray = new String[vector.size()];
        int n3 = 0;
        while (n3 < vector.size()) {
            stringArray[n3] = (String)vector.elementAt(n3);
            ++n3;
        }
        return stringArray;
    }
}

