#
#   File:    topology-d.x
#   Author:  J.M. Heisz, Tom Yuyitung
#   Version: 1.42 02/06/27 13:38:27
#
#   Copyright (c) 1997 Halcyon Inc.
#
#   Topology module configuration information
#

[ use MANAGED-MODULE ]
[ load topology-m.x ]
[ requires package rtopo ]
[ requires template topology-models-d ]
[ inherit .templates.topology-models-d ]

#
#  Note: topology-shadow-d.prc must be sourced, and not inherited
#        since it *overrides* methods 
#
[ source topology-shadow-d.prc ]

persistentSlices = value

#
# Working objects for methods and data acquisition
#
_procedures = {
    [ use PROC ]
    [ source topology-d.prc ]
}

[ inherit _procedures ]

#
# define access control for the module
# - only admin privileged users should be able to write
#
userAccess(%operatorUsers,write) = none
userAccess(%operatorCommunities,write) = none
groupAccess(%operatorGroups,write) = none

#
# define the attribute editor 
#
shadowGroups()       = Info base.console.ConsoleGeneric:editGroup.info \
		       Security base.console.ConsoleGeneric:editGroup.security

shadowGroups(Info)   = topologyhost topologyport trapdest topopath

shadowMapping        = 10000:topodesc
shadowSpec(topopath) = "topopath {Actual Object} {} string {} ro scalar"
shadowDesc(topopath) = "Actual Object";
shadowGet(topopath)  = "getTopoObjectPath"; 
shadowExcludeIfBlank(topopath) = "true";

#
# activate actions
#
# - initEntities     - initialize entities 
# - agentStatusTimer - start timer to query agent status
# - snmpPingTimer    - start timer to query snmp status
# - icmpPingTimer    - start timer to query host availability status 
# - detailTimer      - start timer to query agent detail
#
activateActions(post)             = initEntities agentStatusTimer snmpPingTimer icmpPingTimer detailTimer
activateService(initEntities)     = _internal
activateCommand(initEntities)     = initializeEntities
activateService(agentStatusTimer) = _internal
activateCommand(agentStatusTimer) = initializeRequestTimer agentStatus 300 3600
activateService(snmpPingTimer)    = _internal
activateCommand(snmpPingTimer)    = initializeRequestTimer snmpPing 300 3600
activateService(icmpPingTimer)    = _internal
activateCommand(icmpPingTimer)    = initializeRequestTimer icmpPing 300 3600
activateService(detailTimer)      = _internal
activateCommand(detailTimer)      = initializeRequestTimer detail

#
# Agent status collects SyMON agent status information (both the 
# status message and alarm counts).  The status request is trap 
# correlated with respect to status changes but since the status 
# counts are combined in this request, and they do not (necessarily) 
# trap correlate, we have a 1 minute update interval to maintain 
# reasonably current counts.
#
# Note: base-config.x provides the default values for agentStatusInterval,
# snmpPingInterval, and icmpPingInterval. These values can be overridden in
# domain-config.x. A minimum of 300 seconds and maximum of 3600 seconds are
# enforced on these values.
#

agentStatusService = .services.snmp
agentStatusCommand = get "" "" 86400 %statusurl
agentStatusInitInterval = 30
agentStatusHoldoff = 120

#
# SNMP ping tests whether a generic SNMP agent is accessible.
# It sends an SNMPv1 get request using a user-provided community. 
#
snmpPingService = .services.snmp
snmpPingCommand = get "" "" 86400 %url -version SNMPv1 -community %community
snmpPingInitInterval = 30
snmpPingHoldoff = 180

#
# ICMP ping tests whether a host is pingable.
#
icmpPingService = .services.io.icmp
icmpPingCommand = ping %host
icmpPingInitInterval = 30
icmpPingHoldoff = 150

#
# Detail command collects agent representation information.
#
detailService = .services.snmp
detailCommand = get "" "" -1 %url
detailInterval = 7200
detailInitInterval = 30
detailHoldoff = 300
detailStagger = 20

################################################################################

#
# Topology property information
#
topoProperties = {
    [ inherit _procedures ]

    #
    # Refresh reads the view information from the database
    #
    type = active
    refreshInterval = 604800
    initInterval = 1
    refreshCommand = refreshViewProperties

    topoDesc = {
        [ inherit _procedures ]
        updateFilter = defaultDomainFilter
    } 
}

################################################################################

#
# Entity view information management table
#
entityViewTable = {
    entityViewEntry = {
        [ inherit _procedures ]

        #
        # Refresh command updates the entity status table 
        # from data collected by the entity status timers. 
        #
        type = active
        refreshInterval = 604800
        initInterval = 10
        refreshCommand = refreshEntityStatus

        entityStatus = { 
            collateRowTraps = true
            editableLevels = error warning info irr off down change
            statusCommand(trap) = "deferSetTrapInfo statusOID 0";
        } 
    }
}

#
# Entity detail information management table
#
entityInfoTable = {
    entityInfoEntry = {
        [ inherit _procedures ]

	# construction of attribute editor for alarm action

	# this part to define attribute editor for group alarm actions.

	shadowGroups() = TopoAlarmAction base.console.ConsoleGeneric:editGroup.topoalarmaction 
	shadowGroups(TopoAlarmAction) = topoActionHeader topoAlarmAction 
	
	shadowSpec(topoActionHeader) = "topoActionHeader {Alarm Actions} {} string header ro scalar" 
	shadowDesc(topoActionHeader) = "Alarm Actions" 
	shadowGet(topoActionHeader) = "" 
	
	shadowSpec(topoAlarmAction) = "topoAlarmAction {Topo Alarm Actions} {} string actionauto rw vector" 
	shadowDesc(topoAlarmAction)        = "Topo Alarm Action Commands" 
	shadowType(topoAlarmAction)        = "string" 
	shadowDim(topoAlarmAction)         = "vector" 
	shadowLength(topoAlarmAction)      = "llength [ getTopoActionCommandStates \"\" ]" 
	shadowInfo(topoAlarmAction)        = "lindex [ getTopoActionCommandStates \"\" ] %subindex" 
	shadowMaxAccess(topoAlarmAction)   = "rw" 
	shadowGet(topoAlarmAction) = "toe_send [locate topology.entityViewTable.entityViewEntry.entityStatus] getActionAutoCommandByIndex %rowname %subindex"
	shadowSet(topoAlarmAction) = "toe_send [locate topology.entityViewTable.entityViewEntry.entityStatus] setActionCommandByIndex %rowname %subindex %value" 
	shadowAccessMode(topoAlarmAction) = "useShadowAccess" 
	shadowValidate(topoAlarmAction)   = "validateActionCommand %value"

	# this part to define attribute editor for host alarm action
	entity = {
        	[ inherit _procedures ]

		shadowGroups() = TopoAlarmAction base.console.ConsoleGeneric:editGroup.topoalarmaction 
		shadowGroups(TopoAlarmAction) = topoActionHeader topoAlarmAction blankline topoInheritHeader topoGrpActCheck 
		
		shadowSpec(topoActionHeader) = "topoActionHeader {Alarm Actions} {} string header ro scalar" 
		shadowDesc(topoActionHeader) = "Alarm Actions" 
		shadowGet(topoActionHeader) = "" 
		
		shadowSpec(topoAlarmAction) = "topoAlarmAction {Topo Alarm Actions} {} string actionauto rw vector" 
		shadowDesc(topoAlarmAction)        = "Topo Alarm Action Commands"
		shadowType(topoAlarmAction)        = "string" 
		shadowDim(topoAlarmAction)         = "vector" 
		shadowLength(topoAlarmAction)      = "llength [ getTopoActionCommandStates %rowname ]" 
		shadowInfo(topoAlarmAction)        = "lindex [ getTopoActionCommandStates %rowname ] %subindex" 
		shadowMaxAccess(topoAlarmAction)   = "rw" 
		shadowGet(topoAlarmAction) = "toe_send [locate topology.entityViewTable.entityViewEntry.entityStatus] getActionAutoCommandByIndex %rowname %subindex" 
		shadowSet(topoAlarmAction) = "toe_send [locate topology.entityViewTable.entityViewEntry.entityStatus] setActionCommandByIndex %rowname %subindex %value" 
		shadowAccessMode(topoAlarmAction) = "useShadowAccess"
		shadowValidate(topoAlarmAction)   = "validateActionCommand %value" 
		
		shadowSpec(topoInheritHeader) = "topoActionInherit {Inherit Group Actions} {} string header ro scalar" 
		shadowDesc(topoInheritHeader) = "Inherit Group Actions" 
		shadowGet(topoInheritHeader) = "" 
		
		shadowSpec(topoGrpActCheck) = "topoGrpActCheck {Topo Group Actions Inherit} {} int boolean rw vector" 
		shadowDesc(topoGrpActCheck)  = "Inherit Groups Topo Alarm Actions"
		shadowType(topoGrpActCheck)  = "boolean" 
		shadowDim(topoGrpActCheck)   = "vector" 
		shadowLength(topoGrpActCheck) = "llength [ getTopoActionCommandStates %rowname]" 
		shadowInfo(topoGrpActCheck)  = "lindex [ getTopoActionCommandStates %rowname] %subindex" 
		shadowMaxAccess(topoGrpActCheck)   = "rw" 
		shadowGet(topoGrpActCheck) = "getTopoGrpActCheckByIndex %rowname %subindex" 
		shadowSet(topoGrpActCheck) = "setTopoGrpActCheckByIndex %rowname %subindex %value" 
		shadowAccessMode(topoGrpActCheck) = "useShadowAccess"
	}


        #
        # Again, another very long period, as this table is automatically
        # refreshed when the database is updated.
        #
        type = active
        refreshInterval = 604800
        initInterval = 10
        refreshCommand = refreshEntityDetails
    }
}

#
# Entity adder node
#
entityAdder = {
    access = wo
    setActions = *add
    setService(add) = _superior
    setCommand(add) = addEntity %value
}

#
# Entity view information update node
#
entityViewModifier = {
    access = wo
    setActions = *modify
    setService(modify) = _superior
    setCommand(modify) = updateEntityViews %value
}

#
# Entity detail information update node
#
entityDetailModifier = {
    access = wo
    setActions = *modify
    setService(modify) = _superior
    setCommand(modify) = updateEntityDetails %value
}

#
# Entity remover node
#
entityRemover = {
    access = wo
    setActions = *remove
    setService(remove) = _superior
    setCommand(remove) = removeEntities %value %pdu
}

################################################################################

#
# Adornment management table
#
adornmentTable = {
    adornmentEntry = {
        [ inherit _procedures ]

        type = active
        refreshInterval = 604800
        initInterval = 10
        refreshCommand = refreshAdornments
    }
}

#
# Adornment adder node
#
adornmentAdder = {
    access = wo
    setActions = *add
    setService(add) = adornmentTable.adornmentEntry
    setCommand(add) = addAdornment %value

}

#
# Adornment update node
#
adornmentModifier = {
    access = wo
    setActions = *update
    setService(update) = adornmentTable.adornmentEntry
    setCommand(update) = updateAdornments %value
}

#
# Adornment remover node
#
adornmentRemover = {
    access = wo
    setActions = *remove
    setService(remove) = adornmentTable.adornmentEntry
    setCommand(remove) = removeAdornments %value
}

################################################################################

#
# Discovery node
#
discovery = {
    [ source topology-discover-d.prc ]

    access = wo
    setActions = discover
    setService(discover) = _internal
    setMethod(discover) = startDiscovery %value

    discoverlogprefix = /tmp/discover

    discoverService = _services.sh
    discoverCommand = oa-logoutput.sh %{discoverlogprefix}-%{instance}.out 022 stderr network-discover.sh -oa %startIP %endIP -p %[ lookup value .config.agent.snmpPort ] -fo %[ getFinderOid ] -f %{discoverlogprefix}-%{instance}.out
 
    getBrowserRootService = .services.snmp
    getBrowserRootCommand = get %host %port -1 {{sym/base/mibman/browserRoot#0}} -community %[ lookup -d "public" value .config.current.generaluser ]
}

#
# View creation node
#
viewCreator = {
    access = wo
    setActions = *create
    setService(create) = _superior
    setCommand(create) = createView %value %pdu
}

#
# Element pasting node
#
elementPaster = {
    access = wo
    setActions = *paste
    setService(paste) = _superior
    setCommand(paste) = pasteElements %value %pdu
}
