#! /usr/bin/sh
#
# ident "@(#)es-console.sh 1.33     03/01/14 SMI"
#
# Copyright 2002-2003 Sun Microsystems, Inc.  All rights reserved.
# Use is subject to license terms.
#
#
# File: es-console.sh
# Version: 1.33 03/01/14 10:41:26
# Author: J.M. Heisz
#
# Copyright (c) 1997 Halcyon Inc.
#
#  This is a temporary script for launching the spa console.
#  All environment variables, etc. need to be finalized at a later point.
#

#------------------------------------------------------------------------------#
# if IESROOT NOT set then default ESROOT is [/opt/SUNWsymon].                  #
# make IESROOT as ESROOT, because all further references of ESROOT needs only  #
# <ws>/proto/Independent/.... path                                             #
#                                                                              #
# Note: later if the Independent path is removed, just remove the following    #
#       block and everything should work fine.                                 #
#------------------------------------------------------------------------------#
if [ ! -z "$IESROOT" ] ; then
  ESROOT=$IESROOT
fi
#------------------------------------------------------------------------------#

if test -z "$ESROOT"; then
    /usr/bin/gettext "ESROOT environment variable must be set"
    exit 1
fi

if test -z "$DISPLAY"; then
    /usr/bin/gettext "DISPLAY environment variable must be set"
    exit 1
fi

if test -z "$SYMON_JAVAHOME"; then
   /usr/bin/gettext "SYMON_JAVAHOME variable must be set"
   exit 1
else
   JAVA=$SYMON_JAVAHOME/bin/java
fi 

CLASSPATH=$ESROOT/classes:$ESROOT/apps/classes
CLASSPATH=$CLASSPATH:$ESROOT/classes/escon.jar
CLASSPATH=$CLASSPATH:$ESROOT/classes/esclt.jar
CLASSPATH=$CLASSPATH:$ESROOT/classes/esjrm.jar
CLASSPATH=$CLASSPATH:$ESROOT/classes/escom.jar
CLASSPATH=$CLASSPATH:$ESROOT/classes/esmsg.jar
CLASSPATH=$CLASSPATH:$ESROOT/classes/xml/parser.jar
CLASSPATH=$CLASSPATH:$ESROOT/jclass/chart/lib/jcchart362J.jar

# add application jars and zips to the classpath, if any
APP_JARS=`/usr/bin/ls -1 $ESROOT/apps/classes/*.jar 2>/dev/null`
APP_ZIPS=`/usr/bin/ls -1 $ESROOT/apps/classes/*.zip 2>/dev/null`

APP_CLASSES=$APP_JARS' '$APP_ZIPS
APP_CLASSPATH=''

for i in $APP_CLASSES
do
  APP_CLASSPATH=$APP_CLASSPATH:$i
done

CLASSPATH=$CLASSPATH$APP_CLASSPATH
#
# SunMC 3.5 specific CLASSPATH here.
#
addon_dirs=`/usr/bin/ls -1 $ESROOT/addons 2>/dev/null`
if [ ! -z "$addon_dirs" ]; then
        for i in $addon_dirs
        do
           if [ -d $ESROOT/addons/$i/lib/locale/classes ]; then
                CLASSPATH=$CLASSPATH:$ESROOT/addons/$i/lib/locale/classes
           fi
        done
fi
export CLASSPATH

#
# NOTE: the client should not need INTERFACE_PATH (through server).
#

ulimit -n 256

C_STACKSIZE="-Xss1500k"
MEMSIZE="-Xmx64m"
ARGLIST=""

for each_param in $*
do
    echo "$each_param" | /usr/bin/grep "\-Xmx" > /dev/null 2>&1
    if [ $? -eq 0 ] ; then
       MEMSIZE="$each_param"
    else
       ARGLIST="$ARGLIST $each_param"
    fi
done

$JAVA $MEMSIZE $C_STACKSIZE -DESROOT=$ESROOT com.sun.symon.base.console.main.ConsoleMain $ARGLIST -k 687a8398ad4a85077d33b72a94e16ffde0c4ba023e9c9ba77b247cc25bd3cd0015bc24b7429916751e681fd02e5ad6eb5345eb7c75b39a1c304e0f000846aa470b755b0640af974e7fc70daa6191dff6efa31a09431bb5e9848b7dc4cf4b97e1dbca31792d2860ca5a5990dfb369e1bcf296274a4e4984c8089329679dd304cd base-console.x


