--
--  @(#)validate-status.sql	1.2 01/02/20
--
--  Copyright (c) 02/20/01 Sun Microsystems, Inc. All Rights Reserved.
--

SET TERMOUT ON;
SET COLSEP |;
SET DEFINE ON;
SET ECHO ON;
SET FEEDBACK OFF;
SET FLUSH ON;
SET LINESIZE 1000;
SET PAGESIZE 1000;
SET SERVEROUTPUT ON SIZE 1000000;
SET TAB OFF;
SET TRIMOUT ON;
SET TRIMSPOOL ON;
SET WRAP OFF;

COLUMN OBJECT_TYPE FORMAT A25
COLUMN OBJECT_NAME FORMAT A25

DECLARE
    l_stmt      dbms_sql.VARCHAR2S;
    l_cursor    INTEGER;
    l_rows      NUMBER DEFAULT 0;
    table_name  VARCHAR2(100);

    i           binary_integer := 0;
BEGIN
    i           :=  0;

    SELECT  COUNT(*)
    INTO    i
    FROM    user_objects
    WHERE   object_name     =   'SUNMC_SCHEMA'
    ;

    IF i != 0 THEN
        i           :=  0;
        l_stmt(1)   :=  'DROP TABLE sunmc_schema';

        l_cursor := DBMS_SQL.OPEN_CURSOR;
        DBMS_SQL.PARSE(     l_cursor        -- ID number of the cursor
                        ,   l_stmt          -- SQL statement to be parsed
                        ,   1               -- lower bound for elements in array
                        ,   1               -- upper bound for elements in array
                        ,   TRUE            -- If TRUE, then insert a linefeed
                                            --  after each element on concatenation.
                        ,   dbms_sql.native -- Specifies normal behavior for the database to
                                            --  which the program is connected.
                      );
        l_rows := DBMS_SQL.EXECUTE( l_cursor );
        DBMS_SQL.CLOSE_CURSOR( l_cursor);
    END IF;
END;
/
CREATE GLOBAL TEMPORARY TABLE sunmc_schema (
    object_type     VARCHAR2(50)
,   object_name     VARCHAR2(50) );


INSERT INTO sunmc_schema VALUES ( 'FUNCTION', 'SP_STRIP_EXCLAMATION'  );
INSERT INTO sunmc_schema VALUES ( 'FUNCTION', 'SP_UPDATE_CHECK'  );
INSERT INTO sunmc_schema VALUES ( 'FUNCTION', 'TOPO_PARSE_URL'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'ADORNMENT_INFO_FVIEW_ADORNMENT'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'ADORNMENT_INFO_P'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'ALARM_NOTE_FR_101'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'ALARM_NOTE_P'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'DATA_VIEW_AK1'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'DATA_VIEW_P'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'DATA_VIEW_TEXT_FTEXT'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'DATA_VIEW_TEXT_P'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'ENTITY_INFO_FR_100'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'ENTITY_INFO_P'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'ENTITY_MODULEINSTANCE_FR_106'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'ENTITY_MODULEINSTANCE_FR_74'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'ENTITY_MODULEINSTANCE_P'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'ENTITY_VIEW_RELATOR_FENTITY_VI'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'ENTITY_VIEW_RELATOR_P'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'EVENTS_FR_60'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'EVENTS_P'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'FAMILY_TYPE_FR_112'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'FAMILY_TYPE_P'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'FILTER_AK1'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'FILTER_BY_IP_P'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'FILTER_BY_MODULE_FR_89'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'FILTER_BY_MODULE_P'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'FILTER_BY_NAME_P'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'FILTER_BY_OS_FR_84'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'FILTER_BY_OS_P'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'FILTER_BY_PLATFORM_FR_88'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'FILTER_BY_PLATFORM_P'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'FILTER_P'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'FILTER_QUERY_P'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'GROUP_BY_OBJECT_FR_94'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'GROUP_BY_OBJECT_P'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'HOSTINFO_P'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'LEAF_P'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'LICENSABLE_DOMAINS_P'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'LICENSING_WEIGHTS_P'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'MCP_PARCEL_AK1'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'MCP_PARCEL_MODULE_FPARCEL_MODU'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'MCP_PARCEL_MODULE_P'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'MCP_PARCEL_P'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'MODULEINSTANCE_FR_99'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'MODULEINSTANCE_P'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'MODULE_FR_96'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'MODULE_P'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'NODE_ENTITY_RELATOR_FR_114'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'NODE_ENTITY_RELATOR_FR_115'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'NODE_ENTITY_RELATOR_FR_117'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'NODE_ENTITY_RELATOR_P'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'NODE_LEAF_RELATOR_FR_104'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'NODE_LEAF_RELATOR_FR_105'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'NODE_LEAF_RELATOR_P'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'NODE_P'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'NODE_RELATOR_FR_119'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'NODE_RELATOR_FR_120'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'NODE_RELATOR_P'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'OBJECT_GROUP_AK1'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'OBJECT_GROUP_FR_93'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'OBJECT_GROUP_P'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'PACK_MODULE_FR_97'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'PACK_MODULE_FR_98'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'PACK_MODULE_P'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'PACK_P'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'SECURITY_CREDENTIAL_AK1'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'SECURITY_CREDENTIAL_P'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'SPECIAL_PLATFORMS_P'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'SUGGESTED_FIX_P'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'TASK_AK1'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'TASK_OPERATION_FR_95'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'TASK_OPERATION_P'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'TASK_P'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'TASK_REQUEST_AK1'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'TASK_REQUEST_P'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'VERSION_P'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'VIEW_ENTITY_RELATOR_FVIEW_ENTI'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'VIEW_ENTITY_RELATOR_P'  );
INSERT INTO sunmc_schema VALUES ( 'INDEX', 'VIEW_INFO_P'  );
INSERT INTO sunmc_schema VALUES ( 'PACKAGE BODY', 'TRACE'  );
INSERT INTO sunmc_schema VALUES ( 'PACKAGE', 'EVENTMANAGER_PACKAGE'  );
INSERT INTO sunmc_schema VALUES ( 'PACKAGE', 'PKG_DATAVIEW'  );
INSERT INTO sunmc_schema VALUES ( 'PACKAGE', 'PKG_GROUP'  );
INSERT INTO sunmc_schema VALUES ( 'PACKAGE', 'PKG_MCP'  );
INSERT INTO sunmc_schema VALUES ( 'PACKAGE', 'PKG_SECURITY'  );
INSERT INTO sunmc_schema VALUES ( 'PACKAGE', 'PKG_TASK'  );
INSERT INTO sunmc_schema VALUES ( 'PACKAGE', 'TOPOLOGY_PACKAGE'  );
INSERT INTO sunmc_schema VALUES ( 'PACKAGE', 'TRACE'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'DELETEDATAVIEW'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'DELETEDATAVIEWTEXT'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'DELETEFILTER'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'DELETEFILTERCRITERIA'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'DELETEGROUPBYOBJECT'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'DELETEOBJECTGROUP'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'DELETEPARCEL'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'DELETEPARCELMODULE'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'DELETESECURITYCREDENTIAL'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'DELETETASK'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'DELETETASKOPERATION'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'DELETETASKREQUEST'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'EVENTSDELBYEVID'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'EVENTSGETNEXTID'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'EVENTSINS'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'EVENTSSELBYEVID'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'GETALLDATAVIEWS'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'GETALLFILTERS'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'GETALLOBJECTGROUPS'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'GETALLPARCELS'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'GETALLTASKREQUESTS'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'GETALLTASKS'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'GETCHILDRENHOSTS'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'GETDATAVIEW'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'GETDATAVIEWTEXT'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'GETFAMILIES'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'GETFILTER'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'GETFILTERBYIP'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'GETFILTERBYMODULE'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'GETFILTERBYNAME'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'GETFILTERBYOS'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'GETFILTERBYPLATFORM'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'GETFILTERQUERY'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'GETGROUPBYOBJECT'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'GETMODULELISTBYLEAFID'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'GETOBJECTGROUP'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'GETPARCEL'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'GETPARCELMODULE'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'GETSECURITYCREDENTIAL'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'GETTASK'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'GETTASKOPERATION'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'GETTASKREQUEST'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'HOSTDELBYIPANDPORT'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'HOSTINS'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'HOSTSELBYIPANDPORT'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'SETNODEPATH'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'SP_ADD_LICENSABLE_HOST_TYPE'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'SP_ADD_LICENSABLE_MODULE'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'SP_ADORNMENT_CREATE'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'SP_ADORNMENT_DELETE'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'SP_ADORNMENT_MODIFY'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'SP_AGENT_COUNT'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'SP_ALARM_NOTE_DELETE'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'SP_ALARM_NOTE_INSERT'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'SP_ALARM_NOTE_SELECT'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'SP_ALARM_NOTE_UPDATE'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'SP_DECREMENT_ENTITY_CTR'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'SP_DELETE_MODULE_BY_IP_PORT'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'SP_DELETE_MODULE_BY_LEAF_ID'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'SP_DOMAIN_COUNT'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'SP_DOMAIN_LIST'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'SP_ENTITY_CHILD_VIEW'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'SP_ENTITY_COUNT'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'SP_ENTITY_CREATE'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'SP_ENTITY_DELETE'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'SP_ENTITY_EXISTS'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'SP_ENTITY_INFO'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'SP_ENTITY_LIST'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'SP_ENTITY_LIST_BY_POLL_TYPE'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'SP_ENTITY_LOCATE'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'SP_ENTITY_MODIFY'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'SP_ENTITY_MODINST_CREATE'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'SP_EVENTS_DELETE_ALL_CLOSED'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'SP_FIND_ADORNMENT'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'SP_FIND_DOMAIN_VIEW_RECORD'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'SP_FIND_ENTITY'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'SP_FIND_PARENT_VIEW_RECORD'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'SP_FIND_VIEW'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'SP_GET_AGENTS'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'SP_GET_AGENT_COUNT'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'SP_GET_LEAF_ID_BY_IP_PORT'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'SP_GET_MODULE_ID'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'SP_HAS_CHILD_VIEWS'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'SP_HIERARCHY_CHILDREN'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'SP_HOST_COUNT'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'SP_INCREMENT_ELEMENT_CTR'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'SP_INCREMENT_ENTITY_CTR'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'SP_IS_LICENSABLE'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'SP_IS_PARENT_VIEW'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'SP_LICENSABLE_DOMAINS_CREATE'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'SP_LICENSING_WEIGHTS_CREATE'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'SP_LIC_MODULES_LOADED'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'SP_LIC_MODULES_LOADED_BY_HOST'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'SP_LIC_PACK_INFO_BY_FAMILY'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'SP_LIC_TOPO_OBJECTS'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'SP_MODIFY_LICENSABLE'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'SP_MODULEINSTANCE_CREATE'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'SP_MODULE_ADD'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'SP_MODULE_CREATE'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'SP_PACK_CREATE'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'SP_SUGGESTED_FIX_DELETE'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'SP_SUGGESTED_FIX_INSERT'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'SP_SUGGESTED_FIX_SELECT'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'SP_SUGGESTED_FIX_UPDATE'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'SP_TOTAL_LIC_USED'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'SP_VERSION_CREATE'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'SP_VIEW_CHILD_VIEWS'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'SP_VIEW_CONNECT'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'SP_VIEW_COUNT'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'SP_VIEW_CREATE'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'SP_VIEW_DELETE'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'SP_VIEW_DISCONNECT'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'SP_VIEW_IS_DOMAIN'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'SP_VIEW_LIST'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'SP_VIEW_LOCATE'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'SP_VIEW_MODIFY'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'TOPO_FAMILY_FIND_CREATE'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'TOPO_LEAF_FIND_CREATE'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'UPDATEDATAVIEW'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'UPDATEDATAVIEWTEXT'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'UPDATEFILTER'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'UPDATEFILTERBYIP'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'UPDATEFILTERBYMODULE'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'UPDATEFILTERBYNAME'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'UPDATEFILTERBYOS'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'UPDATEFILTERBYPLATFORM'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'UPDATEFILTERQUERY'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'UPDATEGROUPBYOBJECT'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'UPDATEOBJECTGROUP'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'UPDATEPARCEL'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'UPDATEPARCELMODULE'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'UPDATESECURITYCREDENTIAL'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'UPDATETASK'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'UPDATETASKOPERATION'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'UPDATETASKREQUEST'  );
INSERT INTO sunmc_schema VALUES ( 'PROCEDURE', 'UPDATETASKREQUESTSTATUS'  );
INSERT INTO sunmc_schema VALUES ( 'SEQUENCE', 'SEQ_ADORNMENT_ID'  );
INSERT INTO sunmc_schema VALUES ( 'SEQUENCE', 'SEQ_ALARM_NOTE_ID'  );
INSERT INTO sunmc_schema VALUES ( 'SEQUENCE', 'SEQ_DATA_VIEW_ID'  );
INSERT INTO sunmc_schema VALUES ( 'SEQUENCE', 'SEQ_ENTITY_ID'  );
INSERT INTO sunmc_schema VALUES ( 'SEQUENCE', 'SEQ_EVENT_ID'  );
INSERT INTO sunmc_schema VALUES ( 'SEQUENCE', 'SEQ_FAMILY_TYPE_ID'  );
INSERT INTO sunmc_schema VALUES ( 'SEQUENCE', 'SEQ_FILTER_ID'  );
INSERT INTO sunmc_schema VALUES ( 'SEQUENCE', 'SEQ_LEAF_ID'  );
INSERT INTO sunmc_schema VALUES ( 'SEQUENCE', 'SEQ_LICENSING_WEIGHTS_ID'  );
INSERT INTO sunmc_schema VALUES ( 'SEQUENCE', 'SEQ_MCP_PARCEL_ID'  );
INSERT INTO sunmc_schema VALUES ( 'SEQUENCE', 'SEQ_MODULE_ID'  );
INSERT INTO sunmc_schema VALUES ( 'SEQUENCE', 'SEQ_MODULE_INSTANCE_ID'  );
INSERT INTO sunmc_schema VALUES ( 'SEQUENCE', 'SEQ_NODE_ID'  );
INSERT INTO sunmc_schema VALUES ( 'SEQUENCE', 'SEQ_OBJECT_GROUP_ID'  );
INSERT INTO sunmc_schema VALUES ( 'SEQUENCE', 'SEQ_PACK_ID'  );
INSERT INTO sunmc_schema VALUES ( 'SEQUENCE', 'SEQ_SECURITY_CREDENTIAL_ID'  );
INSERT INTO sunmc_schema VALUES ( 'SEQUENCE', 'SEQ_SPECIAL_PLATFORMS_ID'  );
INSERT INTO sunmc_schema VALUES ( 'SEQUENCE', 'SEQ_SUGGESTED_FIX_ID'  );
INSERT INTO sunmc_schema VALUES ( 'SEQUENCE', 'SEQ_TASK_ID'  );
INSERT INTO sunmc_schema VALUES ( 'SEQUENCE', 'SEQ_TASK_REQUEST_ID'  );
INSERT INTO sunmc_schema VALUES ( 'SEQUENCE', 'SEQ_VERSION_ID'  );
INSERT INTO sunmc_schema VALUES ( 'SEQUENCE', 'SEQ_VIEW_ID'  );
INSERT INTO sunmc_schema VALUES ( 'TABLE', 'ADORNMENT_INFO'  );
INSERT INTO sunmc_schema VALUES ( 'TABLE', 'ALARM_NOTE'  );
INSERT INTO sunmc_schema VALUES ( 'TABLE', 'DATA_VIEW'  );
INSERT INTO sunmc_schema VALUES ( 'TABLE', 'DATA_VIEW_TEXT'  );
INSERT INTO sunmc_schema VALUES ( 'TABLE', 'ENTITY_INFO'  );
INSERT INTO sunmc_schema VALUES ( 'TABLE', 'ENTITY_MODULEINSTANCE'  );
INSERT INTO sunmc_schema VALUES ( 'TABLE', 'ENTITY_VIEW_RELATOR'  );
INSERT INTO sunmc_schema VALUES ( 'TABLE', 'EVENTS'  );
INSERT INTO sunmc_schema VALUES ( 'TABLE', 'FAMILY_TYPE'  );
INSERT INTO sunmc_schema VALUES ( 'TABLE', 'FILTER'  );
INSERT INTO sunmc_schema VALUES ( 'TABLE', 'FILTER_BY_IP'  );
INSERT INTO sunmc_schema VALUES ( 'TABLE', 'FILTER_BY_MODULE'  );
INSERT INTO sunmc_schema VALUES ( 'TABLE', 'FILTER_BY_NAME'  );
INSERT INTO sunmc_schema VALUES ( 'TABLE', 'FILTER_BY_OS'  );
INSERT INTO sunmc_schema VALUES ( 'TABLE', 'FILTER_BY_PLATFORM'  );
INSERT INTO sunmc_schema VALUES ( 'TABLE', 'FILTER_QUERY'  );
INSERT INTO sunmc_schema VALUES ( 'TABLE', 'FKTEMP1'  );
INSERT INTO sunmc_schema VALUES ( 'TABLE', 'FKTEMP2'  );
INSERT INTO sunmc_schema VALUES ( 'TABLE', 'GROUP_BY_OBJECT'  );
INSERT INTO sunmc_schema VALUES ( 'TABLE', 'HOSTINFO'  );
INSERT INTO sunmc_schema VALUES ( 'TABLE', 'LEAF'  );
INSERT INTO sunmc_schema VALUES ( 'TABLE', 'LICENSABLE_DOMAINS'  );
INSERT INTO sunmc_schema VALUES ( 'TABLE', 'LICENSING_WEIGHTS'  );
INSERT INTO sunmc_schema VALUES ( 'TABLE', 'MCP_PARCEL'  );
INSERT INTO sunmc_schema VALUES ( 'TABLE', 'MCP_PARCEL_MODULE'  );
INSERT INTO sunmc_schema VALUES ( 'TABLE', 'MODULE'  );
INSERT INTO sunmc_schema VALUES ( 'TABLE', 'MODULEINSTANCE'  );
INSERT INTO sunmc_schema VALUES ( 'TABLE', 'NODE'  );
INSERT INTO sunmc_schema VALUES ( 'TABLE', 'NODE_ENTITY_RELATOR'  );
INSERT INTO sunmc_schema VALUES ( 'TABLE', 'NODE_LEAF_RELATOR'  );
INSERT INTO sunmc_schema VALUES ( 'TABLE', 'NODE_RELATOR'  );
INSERT INTO sunmc_schema VALUES ( 'TABLE', 'OBJECT_GROUP'  );
INSERT INTO sunmc_schema VALUES ( 'TABLE', 'PACK'  );
INSERT INTO sunmc_schema VALUES ( 'TABLE', 'PACK_MODULE'  );
INSERT INTO sunmc_schema VALUES ( 'TABLE', 'SECURITY_CREDENTIAL'  );
INSERT INTO sunmc_schema VALUES ( 'TABLE', 'SPECIAL_PLATFORMS'  );
INSERT INTO sunmc_schema VALUES ( 'TABLE', 'SUGGESTED_FIX'  );
INSERT INTO sunmc_schema VALUES ( 'TABLE', 'TASK'  );
INSERT INTO sunmc_schema VALUES ( 'TABLE', 'TASK_OPERATION'  );
INSERT INTO sunmc_schema VALUES ( 'TABLE', 'TASK_REQUEST'  );
INSERT INTO sunmc_schema VALUES ( 'TABLE', 'VERSION'  );
INSERT INTO sunmc_schema VALUES ( 'TABLE', 'VIEW_ENTITY_RELATOR'  );
INSERT INTO sunmc_schema VALUES ( 'TABLE', 'VIEW_INFO'  );
INSERT INTO sunmc_schema VALUES ( 'TRIGGER', 'TR_AL_TRACE'  );
--SELECT  *
--FROM    sunmc_schema
--;
DECLARE
    i           binary_integer := 0;
BEGIN
        
    i       :=  0;
    SELECT  COUNT(*)
    INTO    i
    FROM    user_objects        uo
    WHERE   EXISTS( SELECT  *
                    FROM    sunmc_schema        ss
                    WHERE   ss.object_type      =   uo.object_type
                    AND     ss.object_name      =   uo.object_name
                  );

    IF i <> 290 THEN
        DBMS_OUTPUT.PUT_LINE('Error: There should be 290 valid objects.  But there are ' || TO_CHAR( i ) );
    ELSE
        DBMS_OUTPUT.PUT_LINE('There are '||TO_CHAR(i)||' valid objects.');
    END IF;
END;
/
DROP TABLE sunmc_schema ;
QUIT
