#!/bin/sh
#
# File: es-servercontrol.sh
# Version: 1.6 02/02/08 16:29:16
# Author: Joe Mahony
#
# Copyright (c) 1999 Halcyon Inc.
#
# This is a script for performing control functions on the server
#  

if test -z "$ESROOT"; then
    echo "\nThe ESROOT environment variable is not set."
    echo "Enter ESROOT [/opt/SUNWsymon]: \c"
    read ESROOT
    if [ "$ESROOT" = "" ]
    then
        ESROOT="/opt/SUNWsymon"
    fi
fi
export ESROOT
CURRENT_DIR=`pwd`
cd $ESROOT
PWD=`pwd`
export PWD
. $ESROOT/startup.profile
cd $CURRENT_DIR

echo "\nEnter the hostname of the Sun Management Center server [`/usr/bin/hostname`]: \c"
read SERVERHOST
if [ "$SERVERHOST" = "" ]
then
    SERVERHOST=`/usr/bin/hostname`
fi

### The SYMON_JAVAHOME variable is being set in the startup.profile
## It is also prepended to the PATH variable and so it should pickup
## the correct java version

echo "\nEnter the port of the Sun Management Center server [2099]: \c"
read SERVERPORT
if [ "$SERVERPORT" = "" ]
then
    SERVERPORT=2099
fi

echo "\nEnter the Sun Management Center Superuser ID [esmaster]: \c"
read SYMONID
if [ "$SYMONID" = "" ]
then
    SYMONID="esmaster"
fi

stty -echo
while [ "$SYMON_PASSWD" = "" ]
do
    echo "\nEnter the Sun Management Center Superuser Password: \c"
    read SYMON_PASSWD
    if [ "$SYMON_PASSWD" = "" ]
    then
        echo "\nYou must supply a password"
    fi
done
stty echo
echo 

PASSLEN=`echo $SYMON_PASSWD | awk '{print length}'`
if [ $PASSLEN -gt 8 ] ; then
    SYMON_PASSWD=`echo $SYMON_PASSWD | awk '{print substr($SYMON_PASSWD,1,8)}'`
fi


while :
do
    echo "\nPlease Select one of the following Server control functions:"
    echo "0) View the Server Context Cache"
    echo "1) Clear the Server Context Cache"
    echo "2) Remove a host from the Server Context Cache"
    echo "3) Remove a host:port from the Server Context Cache"
    echo "4) View the SNMP OID (Finder) Cache"
    echo "5) Clear the SNMP OID (Finder) Cache"
    echo "6) Remove a host from the SNMP OID (Finder) Cache"
    echo "7) Remove a host:port from the SNMP OID (Finder) Cache"
    echo "8) Remove a host:port from the Cfgserver Engines Table"
    echo "9) Exit"
    echo "\nPlease Enter Your Selection [9]: \c"
    read COMMAND
     
    if [ "$COMMAND" = "9" ] || [ "$COMMAND" = "" ]
    then
        exit 0
    fi

    if [ "${COMMAND}" = 2 ] || [ "${COMMAND}" = 3 ] || [ "${COMMAND}" = 6 ] || [ "${COMMAND}" = 7 ] || [ "${COMMAND}" = 8 ]
    then
        echo "\nEnter the hostname of the Sun Management Center Agent [`/usr/bin/hostname`]:  \c"
        read AGENTHOST
        if [ "$AGENTHOST" = "" ]
        then
            AGENTHOST=`/usr/bin/hostname`
        fi
    fi
 
    if [ "${COMMAND}" = 3 ] || [ "${COMMAND}" = 7 ] || [ "${COMMAND}" = 8 ]
    then
        echo "\nEnter the port of the Sun Management Center Agent [161]: \c"
        read AGENTPORT
        if [ "$AGENTPORT" = "" ]
        then
            AGENTPORT=161
        fi
    fi

    java com.sun.symon.tools.serverutil.ServerControl $SERVERHOST $SERVERPORT $SYMONID $SYMON_PASSWD $COMMAND $AGENTHOST $AGENTPORT

done
