/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server.tools.sess_iiop;

import javax.naming.Name;
import javax.naming.NamingException;
import oracle.aurora.AuroraServices.PublishedObject;
import oracle.aurora.jndi.sess_iiop.SessionCtx;
import oracle.aurora.server.tools.sess_iiop.Chmod;
import oracle.aurora.server.tools.sess_iiop.ToolImpl;
import oracle.aurora.server.tools.sess_iiop.ToolsException;
import org.omg.CORBA.NO_PERMISSION;

public class Republish
extends ToolImpl {
    private Name objectName;
    private String className;
    private String schema;
    private String helper;
    private String[] grants;

    public Republish() {
    }

    public Republish(Name objectName_, String className_, String schema_, String helper_, String grants_) throws ToolsException {
        this.grants = this.parseCommaDelimited(grants_ == null ? "" : grants_);
        if (this.grants.length == 0) {
            this.grants = null;
        }
        this.objectName = objectName_;
        this.className = className_;
        this.schema = schema_;
        this.helper = helper_;
        this.invoke();
    }

    public Republish(Name objectName_, String className_, String schema_, String helper_, String[] grants_) throws ToolsException {
        this.grants = grants_;
        if (this.grants != null && this.grants.length == 0) {
            this.grants = null;
        }
        this.objectName = objectName_;
        this.className = className_;
        this.schema = schema_;
        this.helper = helper_;
        this.invoke();
    }

    public String description() throws ToolsException {
        return this.msg("REPUBLISH_DESCRIPTION", null);
    }

    private SessionCtx dir() throws ToolsException {
        try {
            return (SessionCtx)ToolImpl.wd.lookupParent(this.objectName);
        }
        catch (ClassCastException classCastException) {
            this.fail0("NOT_SESSION_CONTEXT");
            return null;
        }
    }

    public String help() throws ToolsException {
        return this.msg("REPUBLISH_HELP", null);
    }

    protected void invoke() throws ToolsException {
        try {
            Object o = this.dir().lookup(ToolImpl.wd.last(this.objectName));
            PublishedObject obj = (PublishedObject)o;
            if (this.schema == null) {
                obj.republish(this.className, this.helper);
            } else {
                obj.republish_in(this.className, this.schema, this.helper);
            }
        }
        catch (ClassCastException classCastException) {
            this.fail1("NOT_AN_OBJECT", this.objectName.toString());
        }
        catch (NamingException e) {
            this.fail1("CANNOT_REPUBLISH_OBJECT", e.getMessage());
        }
        catch (NO_PERMISSION nO_PERMISSION) {
            this.fail1("NO_PERMISSION_TO_REPUBLISH_OBJECT", this.objectName.toString());
        }
        if (this.grants != null) {
            new Chmod(this.objectName.toString(), this.grants, null, null, null, this.grants, null);
        }
    }

    public static void main(String[] args) {
        try {
            new Republish().invoke(args, System.in, System.out, System.err);
        }
        catch (ToolsException e) {
            System.err.println();
            System.err.println(e.getMessage());
            System.exit(1);
        }
        System.exit(0);
    }

    protected void parseArgs(String[] argv) throws ToolsException {
        if (argv.length == 0 || argv.length > 5) {
            this.error(this.usage());
        }
        int i = 0;
        while (i < argv.length) {
            if (argv[i].equals("-schema")) {
                if (++i == argv.length) {
                    this.fail0("MISSING_SCHEMA");
                }
                this.schema = argv[i];
            } else if (this.objectName == null) {
                this.objectName = ToolImpl.wd.parse(argv[i++]);
            } else if (this.className == null) {
                this.className = argv[i++];
            } else if (this.helper == null) {
                this.helper = argv[i++];
            } else {
                this.error(this.usage());
            }
            ++i;
        }
    }

    public String usage() throws ToolsException {
        return this.msg("REPUBLISH_USAGE", null);
    }

    public String version() throws ToolsException {
        return this.msg("REPUBLISH_VERSION", null);
    }
}

