/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server.tools.sess_iiop;

import java.io.InputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.CommunicationException;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import oracle.aurora.jndi.sess_iiop.ServiceCtx;
import oracle.aurora.jndi.sess_iiop.SessionCtx;
import oracle.aurora.server.tools.sess_iiop.ChainProperties;
import oracle.aurora.server.tools.sess_iiop.LocalWorkingDirectory;
import oracle.aurora.server.tools.sess_iiop.Tool;
import oracle.aurora.server.tools.sess_iiop.ToolsException;
import oracle.aurora.server.tools.sess_iiop.WorkingDirectory;
import org.omg.CORBA.NO_PERMISSION;

public abstract class ToolImpl
implements Tool {
    protected InputStream stdIn = System.in;
    protected PrintStream stdOut = System.out;
    protected PrintStream stdErr = System.err;
    private static ResourceBundle bundle;
    private static final String messageFile = "oracle.aurora.server.tools.sess_iiop.Message";
    protected static ChainProperties environment;
    protected static LocalWorkingDirectory local_wd;
    protected static WorkingDirectory wd;
    protected static boolean echo;
    protected static InitialContext _ic;
    public static final String SERVICE_URL = "oracle.aurora.sess_iiop.service.url";
    public static final String USER_HOME = "oracle.aurora.sess_iiop.user.home";
    public static final String IDL_FILE_NAME = "IDL_FILE_NAME";

    static {
        environment = new ChainProperties((Hashtable)System.getProperties());
        echo = false;
        _ic = null;
    }

    public abstract String description() throws ToolsException;

    protected void error(String message) throws ToolsException {
        throw new ToolsException(message);
    }

    protected void fail0(String key) throws ToolsException {
        String message = this.msg(key, null);
        throw new ToolsException(message);
    }

    protected void fail1(String key, String info) throws ToolsException {
        Object[] args = new Object[]{info == null ? "null" : info};
        String message = this.msg(key, args);
        throw new ToolsException(message);
    }

    protected void fail2(String key, String info, String info2) throws ToolsException {
        Object[] args = new Object[]{info == null ? "null" : info, info2 == null ? "null" : info2};
        String message = this.msg(key, args);
        throw new ToolsException(message);
    }

    protected void fail3(String key, String info, String info2, String info3) throws ToolsException {
        Object[] args = new Object[]{info == null ? "null" : info, info2 == null ? "null" : info2, info3 == null ? "null" : info3};
        String message = this.msg(key, args);
        throw new ToolsException(message);
    }

    private void getConnection() throws ToolsException {
    }

    String get_property(String key) throws ToolsException {
        if (bundle == null) {
            try {
                bundle = ResourceBundle.getBundle(messageFile);
            }
            catch (Exception exception) {
                throw new ToolsException("Tools default properties file 'oracle.aurora.server.tools.sess_iiop.Message' is missing.");
            }
        }
        return bundle.getString(key);
    }

    public abstract String help() throws ToolsException;

    private void initializeLocal() throws ToolsException {
        if (local_wd != null) {
            return;
        }
        local_wd = new LocalWorkingDirectory(environment);
    }

    private void initializeSession() throws ToolsException {
        if (wd != null) {
            return;
        }
        this.getConnection();
        String serviceURL = environment.getProperty(SERVICE_URL);
        if (serviceURL == null) {
            this.error(this.usage());
        }
        ((Hashtable)environment).put("java.naming.factory.url.pkgs", "oracle.aurora.jndi");
        try {
            _ic = new InitialContext(environment);
            SessionCtx ic = ((ServiceCtx)_ic.lookup(serviceURL)).login();
            wd = new WorkingDirectory(environment, ic);
        }
        catch (CommunicationException communicationException) {
            this.fail1("CANNOT_CONNECT", serviceURL);
        }
        catch (NoPermissionException noPermissionException) {
            this.fail0("INVALID_USERNAME_PASSWORD");
        }
        catch (NamingException e) {
            this.fail2("INVALID_SERVICE_URL", serviceURL, e.getMessage());
        }
        catch (NO_PERMISSION nO_PERMISSION) {
            this.fail0("INVALID_USERNAME_PASSWORD");
        }
    }

    protected abstract void invoke() throws ToolsException;

    public void invoke(String[] argv, InputStream in, PrintStream out, PrintStream err) throws ToolsException {
        this.stdIn = in;
        this.stdOut = out;
        this.stdErr = err;
        this.parseArgs(this.parseStdArgs(argv));
        this.invoke();
    }

    protected String msg(String key) throws ToolsException {
        return this.msg(key, null);
    }

    protected String msg(String key, Object[] args) throws ToolsException {
        if (bundle == null) {
            try {
                bundle = ResourceBundle.getBundle(messageFile);
            }
            catch (Exception exception) {
                return "Message file 'oracle.aurora.server.tools.sess_iiop.Message' is missing.";
            }
        }
        try {
            return MessageFormat.format(bundle.getString(key), args);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ToolsException("Message [" + key + "] not found in '" + messageFile + "'.");
        }
    }

    protected abstract void parseArgs(String[] var1) throws ToolsException;

    protected String[] parseCommaDelimited(String string) {
        StringTokenizer tokes = new StringTokenizer(string, ",");
        int numTokes = tokes.countTokens();
        String[] parsed = new String[tokes.countTokens()];
        int i = 0;
        while (i < numTokes) {
            parsed[i] = tokes.nextToken();
            ++i;
        }
        return parsed;
    }

    protected String[] parseStdArgs(String[] argv) throws ToolsException {
        Vector<String> argsLeft = new Vector<String>();
        boolean credsFile = false;
        boolean ssl = false;
        int i = 0;
        while (i < argv.length) {
            if (argv[i].equals("-help") || argv[i].equals("-h")) {
                this.error(this.help());
            } else if (argv[i].equals("-description") || argv[i].equals("-d")) {
                this.error(this.description());
            } else if (argv[i].equals("-version") || argv[i].equals("-v")) {
                this.error(this.version());
            } else if (argv[i].equals("-echo")) {
                echo = true;
            } else if (argv[i].equals("-user") || argv[i].equals("-u")) {
                if (++i == argv.length) {
                    this.fail0("MISSING_USERNAME");
                }
                if (argv[i].indexOf("/") < 0) {
                    ((Hashtable)environment).put("java.naming.security.principal", argv[i]);
                } else {
                    String uName = argv[i].substring(0, argv[i].indexOf("/"));
                    String pwd = argv[i].substring(argv[i].indexOf("/") + 1);
                    ((Hashtable)environment).put("java.naming.security.principal", uName);
                    ((Hashtable)environment).put("java.naming.security.credentials", pwd);
                }
            } else if (argv[i].equals("-password") || argv[i].equals("-p")) {
                if (++i == argv.length) {
                    this.fail0("MISSING_PASSWORD");
                }
                ((Hashtable)environment).put("java.naming.security.credentials", argv[i]);
            } else if (argv[i].equals("-role")) {
                if (++i == argv.length) {
                    this.fail0("MISSING_ROLE");
                }
                ((Hashtable)environment).put("oracle.aurora.sess_iiop.role", argv[i]);
            } else if (argv[i].equals("-service") || argv[i].equals("-s")) {
                if (++i == argv.length) {
                    this.fail0("MISSING_SERVICE");
                }
                ((Hashtable)environment).put(SERVICE_URL, argv[i]);
            } else if (argv[i].equals("-ssl")) {
                ((Hashtable)environment).put("SSL", "true");
                ssl = true;
            } else if (argv[i].equals("-iiop")) {
                ((Hashtable)environment).put("TRANSPORT_TYPE", ServiceCtx.IIOP);
            } else if (argv[i].equals("-useServiceName")) {
                ((Hashtable)environment).put("USE_SERVICE_NAME", "true");
            } else if (argv[i].equals("-credsFile")) {
                if (++i == argv.length) {
                    this.fail0("MISSING_CREDSFILE");
                }
                ((Hashtable)environment).put("java.naming.security.principal", argv[i]);
                credsFile = true;
            } else {
                argsLeft.addElement(argv[i]);
            }
            ++i;
        }
        if (credsFile && !ssl) {
            System.out.println("-credsFile can only be used when -ssl is used");
            this.error(this.usage());
        }
        if (environment.getProperty("java.naming.security.principal") == null) {
            this.error(this.usage());
        }
        if (environment.getProperty("java.naming.security.credentials") == null) {
            this.error(this.usage());
        }
        if (environment.getProperty(SERVICE_URL) == null) {
            this.error(this.usage());
        }
        if (environment.getProperty("java.naming.security.authentication") == null) {
            if (environment.getProperty("SSL") == null) {
                ((Hashtable)environment).put("java.naming.security.authentication", "Login");
            } else if (credsFile) {
                ((Hashtable)environment).put("java.naming.security.authentication", "SslClientAuth");
            } else {
                ((Hashtable)environment).put("java.naming.security.authentication", "SecureLogin");
            }
        }
        this.initializeSession();
        this.initializeLocal();
        Object[] result = new String[argsLeft.size()];
        argsLeft.copyInto(result);
        return result;
    }

    protected String password() {
        return environment.getProperty("java.naming.security.credentials");
    }

    protected Name service() throws ToolsException {
        return wd.last(wd.parse(environment.getProperty(SERVICE_URL)));
    }

    protected void source(String file) throws ToolsException {
        ResourceBundle bundle = null;
        try {
            bundle = ResourceBundle.getBundle(file);
        }
        catch (Exception exception) {
            throw new ToolsException("Properties file '" + file + "' is missing.");
        }
        Enumeration<String> keys = bundle.getKeys();
        environment = new ChainProperties((Hashtable)System.getProperties());
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            ((Hashtable)environment).put(key, bundle.getString(key));
        }
    }

    public abstract String usage() throws ToolsException;

    protected String username() {
        return environment.getProperty("java.naming.security.principal");
    }

    public abstract String version() throws ToolsException;
}

