/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.ejb.server;

import java.rmi.RemoteException;
import java.sql.SQLException;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import javax.ejb.EnterpriseBean;
import javax.ejb.Handle;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionSynchronization;
import javax.jts.HeuristicMixedException;
import javax.jts.HeuristicRollbackException;
import oracle.aurora.ejb.server.AuroraBeanSynchronization;
import oracle.aurora.ejb.server.AuroraEJBContext;
import oracle.aurora.jts.AuroraUserTransaction;
import oracle.aurora.jts.util.NoTransactionServiceException;
import oracle.aurora.jts.util.TS;
import oracle.aurora.rdbms.CurrentSchemaManager;
import oracle.aurora.rdbms.DbmsJava;
import oracle.aurora.rdbms.DbmsRealm;
import oracle.aurora.rdbms.Schema;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleDriver;
import org.omg.CORBA.Object;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.Current;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.Inactive;
import org.omg.CosTransactions.InvalidControl;
import org.omg.CosTransactions.NoTransaction;
import org.omg.CosTransactions.Status;
import org.omg.CosTransactions.SubtransactionsUnavailable;
import org.omg.CosTransactions.SynchronizationUnavailable;
import org.omg.CosTransactions.Unavailable;

public abstract class AuroraEnterpriseBean
extends CurrentSchemaManager
implements EJBObject {
    protected EJBObject tie;
    protected AuroraEJBContext context;
    protected Handle handle;
    protected AuroraUserTransaction userTxn;
    private boolean syncRegistered = false;
    private int runAs;
    private int runAsMode;
    protected boolean removed = false;
    private boolean xaOnlySet = false;
    protected int inMethod = -1;

    protected final void __afterBegin() throws RemoteException {
        ((SessionSynchronization)((java.lang.Object)this.__getBean())).afterBegin();
    }

    protected final void __afterCompletion(boolean completed) throws RemoteException {
        this.syncRegistered = false;
        ((SessionSynchronization)((java.lang.Object)this.__getBean())).afterCompletion(completed);
    }

    protected final void __beforeCompletion() throws RemoteException {
        ((SessionSynchronization)((java.lang.Object)this.__getBean())).beforeCompletion();
    }

    protected void __checkAuthorization(int[] acl) throws RemoteException {
        int caller = Schema.currentSchema().ownerNumber();
        if (caller == DbmsRealm.theSystemSchema.ownerNumber()) {
            return;
        }
        int i = 0;
        while (i < acl.length) {
            if (this.__check_authorization(caller, acl[i])) {
                return;
            }
            ++i;
        }
        AuroraEnterpriseBean.__throwSecurityViolationException("Invalid User: " + Schema.lookup((int)caller).name());
    }

    private boolean __check_authorization(int schema, int uorid) {
        if (uorid == DbmsRealm.thePublicSchema.ownerNumber()) {
            return true;
        }
        if (schema == DbmsRealm.theSystemSchema.ownerNumber()) {
            return true;
        }
        return schema == uorid || DbmsJava.isRoleEnabled((int)uorid);
    }

    protected final void __clearRegisteredSynchronization() {
        this.syncRegistered = false;
    }

    protected final Current __current() throws IllegalStateException {
        try {
            return TS.getTS().getCurrent();
        }
        catch (NoTransactionServiceException noTransactionServiceException) {
            throw new IllegalStateException("No Transaction Service is available");
        }
    }

    protected Schema __enterMethod(int[] acl, int methRunAsMode, int methRunAs) throws RemoteException {
        this.__checkAuthorization(acl);
        if (!this.__txn_present()) {
            this.__setXAOnly();
        }
        if (methRunAsMode != this.runAsMode) {
            this.__throwIncompatibleRunAsModeException(methRunAsMode);
        }
        switch (this.runAsMode) {
            case 0: {
                return null;
            }
            case 1: {
                if (this.runAs != methRunAs) {
                    this.__throwIncompatibleRunAsIdentityException(methRunAs);
                }
                return this.__pushSchema(Schema.lookup((int)this.runAs));
            }
            case 2: {
                return this.__pushSchema((Schema)DbmsRealm.theSystemSchema);
            }
        }
        AuroraEnterpriseBean.__throwSecurityViolationException("Invalid 'Run As' Identity state");
        return null;
    }

    protected abstract EnterpriseBean __getBean() throws RemoteException;

    protected final void __initialize(int ra, int ram, int[] acl) throws RemoteException {
        this.runAs = ra;
        this.runAsMode = ram;
        this.__checkAuthorization(acl);
    }

    private final AuroraEJBContext __loadEjbContext(String name) {
        return null;
    }

    protected boolean __recursiveCall() {
        return this.inMethod >= 0;
    }

    protected final void __registerSynchronization(boolean sync) throws RemoteException {
        block7: {
            if (this.syncRegistered) {
                return;
            }
            this.syncRegistered = true;
            if (!sync) break block7;
            try {
                Control current = this.__txn_current();
                if (current == null) {
                    return;
                }
                current.get_coordinator().register_synchronization(new AuroraBeanSynchronization(this));
                EnterpriseBean bean = this.__getBean();
                if (bean instanceof SessionBean) {
                    this.__afterBegin();
                }
            }
            catch (SynchronizationUnavailable synchronizationUnavailable) {
            }
            catch (Unavailable unavailable) {
            }
            catch (Inactive inactive) {}
        }
    }

    private final void __setTransactionIsolation(int isolationLevel) throws SQLException {
    }

    protected void __setXAOnly() {
        if (this.xaOnlySet) {
            return;
        }
        try {
            ((OracleConnection)new OracleDriver().defaultConnection()).setXAErrorFlag(true);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.xaOnlySet = true;
    }

    protected final void __throwIncompatibleRunAsIdentityException(int methRunAsIdent) throws RemoteException {
        String methRunAs = Schema.lookup((int)methRunAsIdent).toString();
        String createRunAs = Schema.lookup((int)this.runAs).toString();
        throw new RemoteException("Method RunAs Identity does not match RunAsIdentity specified upon creation.  Method: " + methRunAs + " Created: " + createRunAs);
    }

    protected final void __throwIncompatibleRunAsModeException(int methRunAsMode) throws RemoteException {
        String createRunAs = null;
        String methRunAs = null;
        switch (this.runAsMode) {
            case 0: {
                createRunAs = "CLIENT_IDENTITY";
                break;
            }
            case 1: {
                createRunAs = "SPECIFIED_IDENTITY";
                break;
            }
            case 2: {
                createRunAs = "SYSTEM_IDENTITY";
                break;
            }
            default: {
                AuroraEnterpriseBean.__throwSecurityViolationException("Invalid 'Run As' Identity state");
            }
        }
        switch (methRunAsMode) {
            case 0: {
                methRunAs = "CLIENT_IDENTITY";
                break;
            }
            case 1: {
                methRunAs = "SPECIFIED_IDENTITY";
                break;
            }
            case 2: {
                methRunAs = "SYSTEM_IDENTITY";
                break;
            }
            default: {
                methRunAs = "Invalid 'Run As' Identity state";
            }
        }
        throw new RemoteException("Method RunAsMode does not match RunAsMode specified upon creation.  Method: " + methRunAs + " Created: " + createRunAs);
    }

    protected static final void __throwInvalidContextException() throws RemoteException {
        throw new RemoteException("The EJB Context of the bean cannot be serialized");
    }

    protected static final void __throwSecurityViolationException(int id) throws RemoteException {
        throw new RemoteException("A security violation has occurred");
    }

    protected static final void __throwSecurityViolationException(String msg) throws RemoteException {
        throw new RemoteException(msg);
    }

    protected final void __txn_begin(int isolationLevel) throws RemoteException {
        try {
            this.__setTransactionIsolation(isolationLevel);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        try {
            this.__current().begin();
        }
        catch (SubtransactionsUnavailable subtransactionsUnavailable) {
            throw new IllegalStateException("Subtransactions are not permitted");
        }
    }

    protected final void __txn_commit() throws RemoteException {
        try {
            this.__current().commit(false);
        }
        catch (NoTransaction noTransaction) {
            throw new IllegalStateException("No Transaction");
        }
        catch (HeuristicMixed heuristicMixed) {
            throw new HeuristicMixedException();
        }
        catch (HeuristicHazard heuristicHazard) {
            throw new HeuristicRollbackException();
        }
    }

    protected final Control __txn_current() throws RemoteException {
        return this.__current().get_control();
    }

    protected final boolean __txn_present() throws RemoteException {
        return this.__current().get_status() == Status.StatusActive;
    }

    protected final void __txn_resume(Control txn) throws RemoteException {
        if (txn == null) {
            return;
        }
        try {
            this.__current().resume(txn);
        }
        catch (InvalidControl invalidControl) {
            throw new IllegalStateException("Invalid Transaction control");
        }
    }

    protected final void __txn_rollback() throws RemoteException {
        try {
            this.__current().rollback();
        }
        catch (NoTransaction noTransaction) {
            throw new IllegalStateException("No Transaction");
        }
    }

    protected final Control __txn_suspend() throws RemoteException {
        return this.__current().suspend();
    }

    public final EJBHome getEJBHome() throws RemoteException {
        return this.context.getEJBHome();
    }

    public final EJBObject getEJBObject() throws IllegalStateException {
        return this.tie;
    }

    public final Handle getHandle() throws RemoteException {
        return this.handle;
    }

    public abstract java.lang.Object getPrimaryKey() throws RemoteException;

    public boolean isIdentical(EJBObject obj) throws RemoteException {
        try {
            return ((Object)obj)._is_equivalent((Object)this.tie);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public abstract void remove() throws RemoteException, RemoveException;
}

