/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.tools.editor;

import com.sun.symon.base.console.tools.editor.CtActionField;
import com.sun.symon.base.console.tools.editor.CtAttributeEditor;
import com.sun.symon.base.console.tools.editor.CtFocusChangeEvent;
import com.sun.symon.base.console.tools.editor.CtFocusChangeListener;
import com.sun.symon.base.console.tools.editor.CtFocusTraversable;
import com.sun.symon.base.console.tools.editor.CtResetEvent;
import com.sun.symon.base.utility.UcInternationalizer;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.swing.JCheckBox;

public class CtActionBoolean
extends JCheckBox
implements CtFocusTraversable,
KeyListener,
FocusListener {
    static final String yesStr = UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:edit.boolean.yes");
    static final String noStr = UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:edit.boolean.no");
    private String current;
    private String original;
    private boolean lastEditable = false;
    private boolean changed = false;
    private boolean hasFocus = false;
    private CtAttributeEditor editor;
    private CtActionField actionField;
    private Vector focusListener = new Vector();
    private boolean selected;
    private boolean firstTime = true;

    public CtActionBoolean(CtAttributeEditor ctAttributeEditor, CtActionField ctActionField) {
        this.editor = ctAttributeEditor;
        this.actionField = ctActionField;
        this.addKeyListener(this);
        this.addFocusListener(this);
        this.setHorizontalAlignment(2);
        this.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                CtActionBoolean.this.setText(CtActionBoolean.this.isSelected() ? yesStr : noStr);
                if (CtActionBoolean.this.firstTime) {
                    CtActionBoolean.this.setForeground(CtActionBoolean.this.editor.getAttValueForeground());
                    CtActionBoolean.this.firstTime = false;
                    return;
                }
                CtActionBoolean.this.setForeground(CtActionBoolean.this.editor.getEditedForeground());
                CtActionBoolean.this.editor.notifyEdited();
                CtActionBoolean.this.actionField.updateSaveData(true);
                CtActionBoolean.this.changed = true;
            }
        });
    }

    static /* synthetic */ boolean access$4(CtActionBoolean ctActionBoolean) {
        return ctActionBoolean.changed;
    }

    public synchronized void addCtFocusChangeListener(CtFocusChangeListener ctFocusChangeListener) {
        if (!this.focusListener.contains(ctFocusChangeListener)) {
            this.focusListener.addElement(ctFocusChangeListener);
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        this.requestFocus();
        this.notifyFocusChange();
        this.hasFocus = true;
        this.repaint();
    }

    public void focusLost(FocusEvent focusEvent) {
        if (this.changed) {
            this.setForeground(this.editor.getEditedForeground());
        } else {
            this.setForeground(this.editor.getAttValueForeground());
        }
        this.hasFocus = false;
        this.repaint();
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public boolean isOpaque() {
        return true;
    }

    public boolean isRequestFocusEnabled() {
        return true;
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        Character c = new Character('\n');
        if (c.equals(new Character(keyEvent.getKeyChar()))) {
            if (this.lastEditable) {
                this.editor.currentPanel.firstGrabFocus();
            } else {
                this.transferFocus();
            }
        }
    }

    public void notifyFocusChange() {
        Vector vector;
        CtFocusChangeEvent ctFocusChangeEvent = new CtFocusChangeEvent(this);
        CtActionBoolean ctActionBoolean = this;
        synchronized (ctActionBoolean) {
            vector = (Vector)this.focusListener.clone();
        }
        int n = 0;
        while (n < vector.size()) {
            CtFocusChangeListener ctFocusChangeListener = (CtFocusChangeListener)vector.elementAt(n);
            ctFocusChangeListener.attributeFocusChanged(ctFocusChangeEvent);
            ++n;
        }
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        super.paint(graphics);
        if (this.hasFocus) {
            graphics.setColor(this.editor.getFocusedBorderColor());
            graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        }
    }

    public void reset(CtResetEvent ctResetEvent) {
        this.setForeground(this.editor.getAttValueForeground());
        this.changed = false;
        this.repaint();
    }

    public void setSelected(boolean bl) {
        super.setSelected(bl);
        if (this.firstTime) {
            this.setText(this.isSelected() ? yesStr : noStr);
            this.setForeground(this.editor.getAttValueForeground());
            this.firstTime = false;
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

