# cus_net_server.mk - "make" command file to reload 'tnslsnr',
# 'lsnrctl'
#
# Used to reload tnslsnr, lsnrctl, after changing
# network protocol adapter.
#
#
# NOTE:         ORACLE_HOME must be either:
#               . set in the user's environment
#               . passed in on the command line
#               . defined in a modified version of this makefile


include  $(ORACLE_HOME)/network/lib/env_network.mk

RDBMSHOME = $(ORACLE_HOME)/rdbms/
RDBMSLIB  = $(ORACLE_HOME)/rdbms/lib/
RDBMSBIN  = $(ORACLE_HOME)/rdbms/bin/
LDFLAGS   = -L$(LIBHOME) -L$(ORACLE_HOME)/rdbms/lib  -L$(ORACLE_HOME)/network/lib
LDCCOM    = $(LINK) $(LDFLAGS) $(EXOSFLAGS) -o $@
ECHO      = $(ORACLE_HOME)/bin/echodo


INSTALL_TARGS=clean itnslsnr ilsnrctl


tnslsnr: $(S0NSGL) $(SNSGLP) $(NSGLPNP)
	$(ECHODO) $(LDCCOM) $(S0NSGL) $(SNSGLP) $(NSGLPNP) \
	$(TTLIBS) $(LOCALNETLIBS) $(SNMPAGENTLIB) $(LINKEXSYSLIBS)

itnslsnr: tnslsnr
	-mv -f $(ORACLE_HOME)/bin/tnslsnr $(ORACLE_HOME)/bin/tnslsnr0
	-mv tnslsnr $(ORACLE_HOME)/bin/tnslsnr
	-chmod 751 $(ORACLE_HOME)/bin/tnslsnr

lsnrctl: $(S0NSGLC)
	$(ECHODO) $(LDCCOM) $(S0NSGLC) $(TTLIBS) $(LOCALNETLIBS) \
         $(SNMPAGENTLIB) $(LINKEXSYSLIBS)

ilsnrctl: lsnrctl
	-mv -f $(ORACLE_HOME)/bin/lsnrctl $(ORACLE_HOME)/bin/lsnrctl0
	-mv lsnrctl $(ORACLE_HOME)/bin/lsnrctl
	-chmod 751 $(ORACLE_HOME)/bin/lsnrctl

preinstall:
	-chmod 755 $(ORACLE_HOME)/bin

install: preinstall $(INSTALL_TARGS)

clean:
