Rem
Rem $Header: a0801050.sql 01-dec-99.12:47:44 rshaikh Exp $
Rem
Rem a0801050.sql
Rem
Rem  Copyright (c) Oracle Corporation 1999. All Rights Reserved.
Rem
Rem    NAME
Rem      a0801050.sql - additional ANONYMOUS BLOCK dictionary upgrade.
Rem      		Upgrade Oracle RDBMS from 8.1.5 to the new release
Rem
Rem
Rem    DESCRIPTION
Rem
Rem      Additional upgrade script to be run during the migration of an
Rem      8.1.5 database to the new release.
Rem
Rem	 This script is called from u0801050.sql and a0801040.sql
Rem
Rem	 Put any anonymous block related changes here.
Rem	 Any dictionary create, alter, updates and deletes  
Rem 	 that must be performed before catalog.sql and catproc.sql go 
Rem	 in c0801050.sql
Rem
Rem      The upgrade is performed in the following stages:
Rem        STAGE 1: additional steps to upgrade from 8.1.5 to 8.1.6
Rem        STAGE 2: upgrade from 8.1.5 to the new release
Rem
Rem    RETURNS
Rem 
Rem    NOTES
Rem      You must connect internal to run this script
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    rshaikh     12/01/99 - bug 1094821: dont run type upg twice
Rem    rshaikh     11/10/99 - add commit
Rem    mjungerm    11/01/99 - java additions
Rem    rshaikh     09/28/99 - bug 933439: mark all func ind w/imark all func in
Rem    rshaikh     07/26/99 - uncomment upgrade_system_types
Rem    attran      07/13/99 - PIOT: overloaded TAB$/pctused with IOTPK_OBJN
Rem    rshaikh     06/25/99 -
Rem    rshaikh     04/20/99 - add datetime system type initialization          
Rem    rshaikh     02/12/99 - Created
Rem

Rem =========================================================================
Rem BEGIN STAGE 1: upgrade from 8.1.5 to 8.1.6
Rem =========================================================================

REM INSERT YOUR UPGRADE STATEMENTS HERE

REM initialize datetime system types
DROP LIBRARY UPGRADE_LIB
/

CREATE LIBRARY UPGRADE_LIB TRUSTED AS STATIC
/


CREATE OR REPLACE PROCEDURE upgrade_system_types_to_816 IS
LANGUAGE C
NAME "TO_816"
LIBRARY UPGRADE_LIB;
/

set serveroutput on size 10000;

DECLARE
total NUMBER;
BEGIN
  select count(*) into total from obj$ o, user$ u where o.name in
    ('TIME', 'TIME WITH TZ', 'TIMESTAMP', 'TIMESTAMP WITH TZ',
     'INTERVAL YEAR TO MONTH', 'INTERVAL DAY TO SECOND',
     'TIMESTAMP WITH LOCAL TZ') and
     o.owner#=u.user# and u.name='SYS' and o.type#=13;     

  -- Only run this once
  IF total < 7 THEN
    dbms_output.put_line('Initializing new system types');
    upgrade_system_types_to_816();
  ELSE
    dbms_output.put_line('New system types already initialized');
  END IF;

END;
/


REM set TAB$.pctused$ to IND$.obj# if the table is an IOT.
DECLARE
index_stmt      VARCHAR2(100);
index_cursor_id NUMBER;
index_objn NUMBER;
table_stmt      VARCHAR2(100);
table_cursor_id NUMBER;
table_objn NUMBER;
rows       NUMBER;
BEGIN
  index_stmt := 'select obj#,bo# from ind$ where type#=4';
  index_cursor_id := dbms_sql.open_cursor;
  dbms_sql.parse(index_cursor_id, index_stmt, dbms_sql.native);
  dbms_sql.define_column(index_cursor_id, 1, index_objn);
  dbms_sql.define_column(index_cursor_id, 2, table_objn);

  table_stmt := 'update tab$ set pctused$=:index_objn where obj#=:table_objn';
  table_cursor_id := dbms_sql.open_cursor;
  dbms_sql.parse(table_cursor_id, table_stmt, dbms_sql.native);

  rows := dbms_sql.execute(index_cursor_id);
  LOOP
    rows := dbms_sql.fetch_rows(index_cursor_id);
    IF (rows = 0) THEN
      EXIT;
    ELSE
      dbms_sql.column_value(index_cursor_id, 1, index_objn);
      dbms_sql.column_value(index_cursor_id, 2, table_objn);
      dbms_sql.bind_variable(table_cursor_id, ':index_objn', index_objn);
      dbms_sql.bind_variable(table_cursor_id, ':table_objn', table_objn);
      rows := dbms_sql.execute(table_cursor_id);
    END IF;
  END LOOP;

  dbms_sql.close_cursor(table_cursor_id);
  dbms_sql.close_cursor(index_cursor_id);
END;
/

commit
/

REM 
REM bug 933439 - mark all functional indexes unusable that are created
REM on expressions whose return types are internal types.  The indexes
REM are incorrect and must be rebuilt.
REM

DECLARE
 obj_number number := 0;

 cursor C1 is select o.obj#, 
     'ALTER INDEX "' || u.name || '"."' || o.name || '" UNUSABLE'
        from ind$ i, user$ u, obj$ o, obj$ bo, col$ c, icol$ ic
 	where o.obj# > obj_number
	  and bitand(i.property, 16)=16 
	  and i.obj#=o.obj# 
	  and o.owner#=u.user# 
	  and i.bo#=bo.obj#
	  and bo.obj#=c.obj# 
	  and ic.col#=c.col#
	  and ic.intcol#=c.intcol# 
	  and ic.obj#=i.obj# 
	  and c.type# in (3,4,5,6,7,9,13,14,15,21,22,25,26,27,28,29,
		 30,31,68,69,94,95,97,100,101,104,108,110,
 		 116,118,136,152,153,154,155,156,172,184,185,
		 186,187,188,189,190,195,196,197,232,233)
	  order by o.obj#;

  DDL_CURSOR integer;
  ddl_statement varchar2(200);
  iterations number;
  loop_count number;
  my_err     number;
BEGIN
 loop_count := 0;
 -- To make sure we eventually stop, pick a max number of iterations
 select count(*) into iterations from ind$ i, user$ u, obj$ o, 
	obj$ bo, col$ c, icol$ ic
 	where bitand(i.property, 16)=16 
	  and i.obj#=o.obj# 
	  and o.owner#=u.user# 
	  and i.bo#=bo.obj#
	  and bo.obj#=c.obj# 
	  and ic.col#=c.col#
	  and ic.intcol#=c.intcol# 
	  and ic.obj#=i.obj# 
	  and c.type# in (3,4,5,6,7,9,13,14,15,21,22,25,26,27,28,29,
		 30,31,68,69,94,95,97,100,101,104,108,110,
 		 116,118,136,152,153,154,155,156,172,184,185,
		 186,187,188,189,190,195,196,197,232,233);


 DDL_CURSOR := dbms_sql.open_cursor;
 OPEN C1;

 dbms_output.put_line ('The following indexes are marked "UNUSABLE" due ');
 dbms_output.put_line ('to bug# 933439');

 LOOP

   BEGIN
     FETCH C1 INTO obj_number, ddl_statement;
     EXIT WHEN C1%NOTFOUND OR loop_count > iterations;
   EXCEPTION
    WHEN OTHERS THEN
      my_err := SQLCODE;
      IF my_err = -1555 THEN -- snapshot too old, re-execute fetch query
       CLOSE C1;
       -- Here is why C1 orders by obj#.  When we restart the query, we 
       -- will only find object with obj# greater than the last one tried.
       -- This keeps us from re-trying bjects that failed.
       OPEN  C1;
       GOTO continue;
      ELSE
       RAISE;
      END IF;
   END;

   BEGIN
       -- Issue the Alter Statement  (Parse implicitly executes DDLs)
       dbms_sql.parse(DDL_CURSOR, ddl_statement, dbms_sql.native);
       dbms_output.put_line (ddl_statement);
   EXCEPTION
       WHEN OTHERS THEN
        null; -- ignore, and proceed.
   END;

 <<continue>>
   loop_count := loop_count + 1;
 END LOOP;
 dbms_sql.close_cursor(DDL_CURSOR);
 CLOSE C1;

 dbms_output.put_line ('These indexes must be rebuilt');
END;
/

COMMIT
/

-- Upgrade an 8.1.5 database to 8.1.6 for running Java and the ORB

-- Load support packages, including rmjvm

-- inline javavm/install/initjvmaux.sql

-- initjvmaux: support package for conditional execution during jvm scripts
create or replace package initjvmaux is 
 -- exec: execute a statement
 procedure exec (x varchar2);
 -- drp: execute a statement
 -- with some errors typically seen in drop commands ignored
 procedure drp (x varchar2);
 -- rollbacksetup: find or allocate a big, online rollback segment
 -- return the set transaction command to use the segment in the current txn
 function rollbacksetup return varchar2;
 -- rollbackcleanup: deallocate any rollback segment allocated by rollbacksetup
 procedure rollbackcleanup;
end;
/

create or replace package body initjvmaux is

deallocate_rollback_segment boolean;

procedure exec (x varchar2) as
begin
dbms_output.put_line(substr(x, 1, 250));
execute immediate x;
end;

procedure drp (x varchar2) as
begin
exec(x);
exception
when others then
if sqlcode not in (-4080, -1418, -1919, -942, -1432, -4043, -1918, -2289,
                   -1598, -1534) then raise; end if;
end;

function rollbacksetup return varchar2 as
  rollback_segment_name varchar2(30);
  cursor C1 is select segment_name from dba_rollback_segs
    where tablespace_name='SYSTEM' and next_extent*max_extents>100000000 and
          status='ONLINE';
BEGIN

  deallocate_rollback_segment := FALSE;

  OPEN C1;
 
  FETCH C1 INTO rollback_segment_name;
  if C1%NOTFOUND then
    deallocate_rollback_segment := TRUE;
    rollback_segment_name := 'MONSTER';
    drp('alter rollback segment monster offline');
    drp('drop rollback segment monster');
    exec('create rollback segment monster ' ||
              'storage (initial 100 k next 100 k maxextents unlimited)');
    exec('alter rollback segment monster online');
  END IF;
  CLOSE C1;
  return
   'set transaction use rollback segment ' || rollback_segment_name;
END;

procedure rollbackcleanup as
begin
if deallocate_rollback_segment then
    drp('alter rollback segment monster offline');
    drp('drop rollback segment monster');
end if;
end;

end;
/

-- Package rmjvm: encapsulates undo logic for removing Java system objects
-- during upgrade/downgrade and for full removal of Java to back out of
-- the results of a failed initjvm
drop table java$rmjvm$aux;
drop table java$rmjvm$aux2;
drop index java$rmjvm$auxi;
drop index java$rmjvm$auxi2;
create table java$rmjvm$aux(obj# number);
create table java$rmjvm$aux2(name varchar2(30));
create unique index java$rmjvm$auxi on java$rmjvm$aux(obj#);
create unique index java$rmjvm$auxi2 on java$rmjvm$aux2(name);

create or replace package rmjvm is
 procedure run(remove_all boolean);
end;
/

create or replace package body rmjvm is

procedure exec (x varchar2) as
begin
 initjvmaux.exec(x);
end;

procedure drp (x varchar2) as
begin
 initjvmaux.drp(x);
end;

procedure run(remove_all boolean) as
rollback_segment_set_command varchar2(100) := initjvmaux.rollbacksetup;
begin
--    DESCRIPTION
--      This removes java related objects from the data dictionary.
--      If remove_all is true, it removes all java objects and java
--      related tables and packages, including user objects.
--      If remove all is false, it removes only the java objects, such
--      as system classes, that are considered to be a fixed part of a
--      given Oracle release.  It does not remove user objects.
--
--    NOTES
--      This procedure is destructive.  After it runs, System classes 
--      must be reloaded either by initjvm or in a subsequent 
--      upgraded/downgrade phase before Java is again usable.
--
--      This procedure requires a significant amount of rollback
--      to execute.
--

commit;
exec(rollback_segment_set_command);

declare
c number;
begin
select count(*) into c from java$rmjvm$aux;
if c = 0 then
  commit;
  exec(rollback_segment_set_command);
  if remove_all then
  exec('insert into java$rmjvm$aux (select obj# from obj$ where ' ||
    'type#=28 or type#=29 or type#=30 or type#=56)');
  else
  exec('insert into java$rmjvm$aux (select joxftobn from x$joxft ' ||
    'where (floor(joxftflags/64)*2)!=floor(joxftflags/32) or joxfttype=56)');
  end if;
  commit;
end if;
end;

commit;
exec(rollback_segment_set_command);

dbms_output.put_line('drop synonyms with java targets');

DECLARE
  cursor C1 is select
     'DROP PUBLIC SYNONYM "' || name || '"' from java$rmjvm$aux2;

  DDL_CURSOR integer;
  ddl_statement varchar2(200);
  iterations number;
  previous_iterations number;
  loop_count number;
  my_err     number;
BEGIN
 previous_iterations := 10000000;

 DDL_CURSOR := dbms_sql.open_cursor;

 loop
 
  exec('delete from java$rmjvm$aux2');
  if remove_all then
  exec('insert into  java$rmjvm$aux2 (select o1.name from ' ||
     'obj$ o1,obj$ o2 where o1.type#=5 and o1.name=o2.name and o2.type#=29)');
  else
  exec('insert into  java$rmjvm$aux2 (select o1.name ' ||
            'from obj$ o1,obj$ o2, java$rmjvm$aux j ' ||
            'where o1.type#=5 and o1.name=o2.name and o2.obj#=j.obj#)');
  end if;

 -- To make sure we eventually stop, pick a max number of iterations
  select count(*) into iterations from java$rmjvm$aux2;
 
  exit when iterations=0 or iterations >= previous_iterations;
  previous_iterations := iterations;
  loop_count := 0;
 
  OPEN C1;
 
  LOOP
 
    BEGIN
      FETCH C1 INTO ddl_statement;
      EXIT WHEN C1%NOTFOUND OR loop_count > iterations;
    EXCEPTION
     WHEN OTHERS THEN
       my_err := SQLCODE;
       IF my_err = -1555 THEN -- snapshot too old, re-execute fetch query
        CLOSE C1;
        exit;
       ELSE
        RAISE;
       END IF;
    END;
 
    BEGIN
        -- Issue the Alter Statement  (Parse implicitly executes DDLs)
        dbms_sql.parse(DDL_CURSOR, ddl_statement, dbms_sql.native);
    EXCEPTION
        WHEN OTHERS THEN
        null; -- ignore, and proceed.
    END;
 
  <<continue>>
    loop_count := loop_count + 1;

  END LOOP;
  CLOSE C1;

 end loop;
 dbms_sql.close_cursor(DDL_CURSOR);

END;
commit;

dbms_output.put_line('flush shared_pool');
execute immediate 'alter system flush shared_pool';
execute immediate 'alter system flush shared_pool';
execute immediate 'alter system flush shared_pool';

declare
total_to_delete number;
deletions_per_iteration number := 1000;
begin

exec(rollback_segment_set_command);

dbms_output.put_line('delete from dependency$');

if remove_all then
select count(*) into total_to_delete from dependency$
  where p_obj# in (select obj# from java$rmjvm$aux);
else
select count(*) into total_to_delete from dependency$
  where p_obj# in (select obj# from obj$ where (type#=29 or type#=56));
end if;
commit;
loop
exec(rollback_segment_set_command);
if remove_all then
delete from dependency$ where p_obj# in
  (select obj# from java$rmjvm$aux)
  and rownum <= deletions_per_iteration;
else
delete from dependency$ where p_obj# in
  (select obj# from obj$ where (type#=29 or type#=56))
  and rownum <= deletions_per_iteration;
end if;
commit;
exit when total_to_delete <= deletions_per_iteration;
total_to_delete := total_to_delete - deletions_per_iteration;
end loop;

exec(rollback_segment_set_command);

dbms_output.put_line('delete from error$');

if remove_all then
select count(*) into total_to_delete from error$
  where obj# in (select obj# from java$rmjvm$aux);
else
select count(*) into total_to_delete from error$
  where obj# in (select obj# from obj$
                 where type#=28 or type#=29 or type#=30 or type#=56);
end if;
commit;
loop
exec(rollback_segment_set_command);
if remove_all then
delete from error$ where obj# in
  (select obj# from java$rmjvm$aux)
  and rownum <= deletions_per_iteration;
else
delete from error$ where obj# in
  (select obj# from obj$ where type#=28 or type#=29 or type#=30 or type#=56)
  and rownum <= deletions_per_iteration;
end if;
commit;
exit when total_to_delete <= deletions_per_iteration;
total_to_delete := total_to_delete - deletions_per_iteration;
end loop;

exec(rollback_segment_set_command);

dbms_output.put_line('delete from objauth$');

select count(*) into total_to_delete from objauth$
   where obj# in (select obj# from java$rmjvm$aux);
commit;
loop
exec(rollback_segment_set_command);
delete from objauth$ where obj# in (select obj# from java$rmjvm$aux)
  and rownum <= deletions_per_iteration;
commit;
exit when total_to_delete <= deletions_per_iteration;
total_to_delete := total_to_delete - deletions_per_iteration;
end loop;

if remove_all then
exec(rollback_segment_set_command);

dbms_output.put_line('delete from javasnm$');
delete from javasnm$;
commit;
end if;

exec(rollback_segment_set_command);

dbms_output.put_line('delete from idl_ub1$');

select count(*) into total_to_delete
 from idl_ub1$ where obj# in (select obj# from java$rmjvm$aux);
commit;
loop
exec(rollback_segment_set_command);
delete from idl_ub1$ where obj# in (select obj# from java$rmjvm$aux)
   and rownum <= deletions_per_iteration;
commit;
exit when total_to_delete <= deletions_per_iteration;
total_to_delete := total_to_delete - deletions_per_iteration;
end loop;

dbms_output.put_line('delete from idl_ub2$');

execute immediate
'select count(*) from idl_ub2$ ' ||
  'where obj# in (select obj# from java$rmjvm$aux)' into total_to_delete;
commit;
loop
exec(rollback_segment_set_command);
execute immediate
'delete from idl_ub2$ where obj# in (select obj# from java$rmjvm$aux) ' ||
   'and rownum <= :deletions_per_iteration' using deletions_per_iteration;
commit;
exit when total_to_delete <= deletions_per_iteration;
total_to_delete := total_to_delete - deletions_per_iteration;
end loop;

dbms_output.put_line('delete from idl_char$');

select count(*) into total_to_delete
 from idl_char$ where obj# in (select obj# from java$rmjvm$aux);
commit;
loop
exec(rollback_segment_set_command);
delete from idl_char$ where obj# in (select obj# from java$rmjvm$aux)
   and rownum <= deletions_per_iteration;
commit;
exit when total_to_delete <= deletions_per_iteration;
total_to_delete := total_to_delete - deletions_per_iteration;
end loop;

dbms_output.put_line('delete from idl_sb4$');

execute immediate
'select count(*) from idl_sb4$ ' ||
 'where obj# in (select obj# from java$rmjvm$aux)' into total_to_delete;
commit;
loop
exec(rollback_segment_set_command);
execute immediate
'delete from idl_sb4$ where obj# in (select obj# from java$rmjvm$aux) ' ||
   'and rownum <= :deletions_per_iteration' using deletions_per_iteration;
commit;
exit when total_to_delete <= deletions_per_iteration;
total_to_delete := total_to_delete - deletions_per_iteration;
end loop;

dbms_output.put_line('delete from obj$');
-- 
-- only delete from obj$ if all the java information was deleted
-- from the other tables correctly.  Once we run this delete
-- there is no going back to remove the information from 
-- syn$, objauth$ and dependency$ using this script.
--
DECLARE
 c1 number;
 c2 number;
 c3 number;
 c4 number; 
BEGIN
  if remove_all then
  select count(*) into c1 from syn$ where obj# in
        (select o1.obj# from obj$ o1,obj$ o2 
                where o1.name=o2.name and 
                o1.type#=5 and o2.type#=29);
  select count(*) into c2 from dependency$ where p_obj# in 
        (select obj# from java$rmjvm$aux);
  select count(*) into c3 from objauth$ where obj# in
        (select obj# from java$rmjvm$aux);
  select count(*) into c4 from javasnm$;
  else
  select count(*) into c1 from syn$ where obj# in
        (select o1.obj# from obj$ o1,obj$ o2,java$rmjvm$aux j
           where o1.name=o2.name and o1.type#=5 and o2.obj#=j.obj#);
  select count(*) into c2 from dependency$ where p_obj# in
        (select obj# from obj$ where
         type#=28 or type#=29 or type#=30 or type#=56);
  select count(*)into c3 from objauth$ where obj# in
        (select obj# from java$rmjvm$aux);
  c4 := 0;
  end if;

  IF c1 = 0 AND c2 = 0 AND c3 = 0 AND c4 = 0 THEN
        select count(*) into total_to_delete
         from obj$ where obj# in (select obj# from java$rmjvm$aux);
        commit;
        loop
        exec(rollback_segment_set_command);
        delete from obj$ where obj# in (select obj# from java$rmjvm$aux)
           and rownum <= deletions_per_iteration;
        commit;
        exit when total_to_delete <= deletions_per_iteration;
        total_to_delete := total_to_delete - deletions_per_iteration;
        end loop;

	if not remove_all then
        update obj$ set status=5 where type#=28 or type#=29;
        end if;

        delete from java$rmjvm$aux;

        dbms_output.put_line('All java objects removed');
  ELSE
        dbms_output.put_line('Java objects not completely removed. ' ||
                             'Rerun rmjvm.run');
  END IF;
END;

end;

commit;

initjvmaux.rollbackcleanup;

dbms_output.put_line('flush shared_pool');
execute immediate 'alter system flush shared_pool';
execute immediate 'alter system flush shared_pool';
execute immediate 'alter system flush shared_pool';
end;

end;
/


-- end inline of javavm/install/initjvmaux.sql

-- Remove old system classes etc

-- inline relevant portions of javavm/install/jvmrm.sql and its subscripts

-- Remove some portion of the Java related data dictionary objects

-- This script must be run as a subscript of a script which sets the
-- variable jvmrmaction.
-- Possible values are
--  FULL_REMOVAL:        remove all java related objects
--  UPGRADE:             remove all system objects appropriate prior to
--                       upgrading to the current revision
--  DOWNGRADE:           remove all system objects appropriate prior to
--                       downgrading to previous revision
--  NONE:                do nothing

--
begin

initjvmaux.drp('drop package get_error$');
initjvmaux.drp('drop public synonym get_error$');

--
initjvmaux.drp('drop trigger AURORA$SERVER$SHUTDOWN');
initjvmaux.drp('drop trigger AURORA$SERVER$STARTUP');

-- initsql
initjvmaux.drp('drop package sqljutl');


-- inline relevant portion of jvmrm_dbj (subscript of jvmrm)

-- Remove some portion of the dictionary objects created by initdbj.sql

-- This script must be run as a subscript of a script which sets the
-- variable jvmrmaction.
-- Possible values are
--  FULL_REMOVAL:        remove all objects
--  UPGRADE:             remove all system objects appropriate prior to
--                       upgrading to the current revision
--  DOWNGRADE:           remove all system objects appropriate prior to
--                       downgrading to previous revision
--  NONE:                do nothing

initjvmaux.drp('drop package dbms_java');
initjvmaux.drp('drop PUBLIC SYNONYM dbms_java');
initjvmaux.drp('drop FUNCTION dbj_long_name');
initjvmaux.drp('drop function "NameFromLastDDL"');
initjvmaux.drp('drop PUBLIC SYNONYM "NameFromLastDDL"');
initjvmaux.drp('drop FUNCTION dbj_short_name');
initjvmaux.drp('drop PUBLIC SYNONYM dbj_short_name');

-- end inline of relevant portion of jvmrm_dbj (subscript of jvmrm)

-- inline relevant portion of jvmrm_namespace (subscript of jvmrm)

-- Remove some portion of the dictionary objects created by init_namespace.sql

-- This script must be run as a subscript of a script which sets the
-- variable jvmrmaction.
-- Possible values are
--  FULL_REMOVAL:        remove all objects
--  UPGRADE:             remove all system objects appropriate prior to
--                       upgrading to the current revision
--  DOWNGRADE:           remove all system objects appropriate prior to
--                       downgrading to previous revision
--  NONE:                do nothing

initjvmaux.drp('drop package dbms_orb_context');


-- end inline of relevant portion of jvmrm_namespace (subscript of jvmrm)

-- inline relevant portion of jvmrm_xa (subscript of jvmrm)

-- Remove some portion of the dictionary objects created by initxa.sql

-- This script must be run as a subscript of a script which sets the
-- variable jvmrmaction.
-- Possible values are
--  FULL_REMOVAL:        remove all objects
--  UPGRADE:             remove all system objects appropriate prior to
--                       upgrading to the current revision
--  DOWNGRADE:           remove all system objects appropriate prior to
--                       downgrading to previous revision
--  NONE:                do nothing

initjvmaux.drp('drop package JAVA_XA');
initjvmaux.drp('drop PUBLIC SYNONYM JAVA_XA');


-- end inline of relevant portion of jvmrm_xa (subscript of jvmrm)


-- end inline of relevant portions of javavm/install/jvmrm.sql
end;
/

-- The following may take some time (tens of minutes)
execute rmjvm.run(false);

-- The above simply removes the 8.1.5 system classes and related artifacts
-- The rest of the java upgrade is done optionally by running 
-- javavm/install/jvmu815.sql

Rem =========================================================================
Rem END STAGE 1: upgrade from 8.1.5 to 8.1.6
Rem =========================================================================

Rem =========================================================================
Rem BEGIN STAGE 2: upgrade from 8.1.5 to the new release
Rem =========================================================================
Rem

Rem END HERE FOR RELEASE 8.1.5
Rem For the next release we have to add a file here called
Rem @@a0801060

Rem =========================================================================
Rem END STAGE 2: upgrade from 8.1.5 to the new release
Rem =========================================================================

Rem *************************************************************************
Rem END a0801050.sql
Rem *************************************************************************
