# Entering /vobs/oracle/rdbms/install/cus_rdbms.mk
include $(ORACLE_HOME)/rdbms/lib/env_rdbms.mk

PRODUCT=rdbms

MAKEFILE=$(RDBMSLIB)ins_rdbms.mk
RDBMSBIN=$(ORACLE_HOME)/rdbms/lib/
JAVAVM_SHLIB_SOHOME=$(LIBHOME)
LLIBJAVAVMORJOX=$(SHLIBJOX) $(LLIBSERVER)

KSMS = $(ORACLE_HOME)/rdbms/lib/ksms.o
GENKSMS = $(ORACLE_HOME)/bin/genksms

DOLIB=$(ORACLE_HOME)/lib/liborcaccel.a
DUMSDOLIB=$(ORACLE_HOME)/lib/liborcaccel_stub.a
REALSDOLIB=/usr/lpp/orcaccel/liborcaccel.a

OSNTABST= `if [ -f $(ORACLE_HOME)/lib/osntabst.o ]; then \
		echo '$(ORACLE_HOME)/lib/osntabst.o'; \
	   else \
		echo '$(ORACLE_HOME)/network/lib/osntabst.o'; \
	   fi `

setsdolib:
	rm -f $(SDOLIB); \
	if ar t $(LIBKNLOPT) $(NO_SCAFOPT) > /dev/null 2>&1; then \
	 ln -s $(DUMSDOLIB) $(SDOLIB) ; \
	else \
		if [ -f $(REALSDOLIB) ] ; then \
		 ln -s $(REALSDOLIB)  $(SDOLIB) ; \
		else \
		 ln -s $(DUMSDOLIB) $(SDOLIB) ; \
		fi \
	fi


ksms.s $(RDBMSLIB)ksms.s:
	$(GENKSMS) > ksms.s

ksms.o $(KSMS): $(RDBMSLIB)ksms.s
	$(SILENT)$(CD) $(RDBMSLIB); \
	$(AS) -o ksms.o ksms.s; \
	$(AR) r $(LIBSERVER) ksms.o
 
$(CONFIG):	always
	$(SILENT)$(CD) $(RDBMSLIB); \
	$(CONFIG_COMPILE_LINE); \
	$(AR) r $(LIBSERVER) config.o

always:

client_sharedlib:
	$(GENCLNTSH)

INSTALL_TARGS=clean ioracle imig idbv itstshm imaxmem iorapwd idbfsize \
	icursize isvrmgrl iextproc iagtctl ihsalloci ihsots ihsdepxa isbttest \
	ikgmgr iloadpsp

ITEST=ioracle imig idbv itstshm imaxmem iorapwd idbfsize icursize isvrmgrl \
	iextproc ihsalloci ihsots ihsdepxa iosh isbttest iexp iimp isqlldr \
	irman iexpst iimpst isqlldrst ikgmgr iloadpsp

IUTILITIES=iimp iexp isqlldr itkprof irman ikgmgr iloadpsp

ALL_EXECS=oracle mig dbv tstshm maxmem orapwd dbfsize cursize svrmgrl extproc \
	hsalloci hsots hsdepxa osh sbttest imp exp sqlldr rman kgmgr loadpsp

default: $(ORACLE)

test: clean $(ITEST)
  
parropt: ops_on
no_parropt: ops_off

sdopt: sdo_on
no_sdopt: sdo_off

ipc_none:
	-$(RMF) $(LIBSKGXP)
	$(CP) $(LIBHOME)/libskgxpd.$(SKGXP_EXT) $(LIBSKGXP)

ipc_udp:
	-$(RMF) $(LIBSKGXP)
	$(CP) $(LIBHOME)/libskgxpu.$(SKGXP_EXT) $(LIBSKGXP)

ipc_tcp:
	-$(RMF) $(LIBSKGXP)
	$(CP) $(LIBHOME)/libskgxpt.$(SKGXP_EXT) $(LIBSKGXP)

utilities:	$(IUTILITIES)

ioracle: $(ORACLE)
	-mv -f $(ORACLE_HOME)/bin/oracle $(ORACLE_HOME)/bin/oracleO
	-mv $(ORACLE_HOME)/rdbms/lib/oracle $(ORACLE_HOME)/bin/oracle
	-chmod 6751 $(ORACLE_HOME)/bin/oracle

imig: $(MIG)
	-mv -f $(ORACLE_HOME)/bin/mig $(ORACLE_HOME)/bin/migO
	-mv $(ORACLE_HOME)/rdbms/lib/mig $(ORACLE_HOME)/bin/mig
	-chmod 751 $(ORACLE_HOME)/bin/mig

idbv: $(DBVERIFY)
	-mv -f $(ORACLE_HOME)/bin/dbv $(ORACLE_HOME)/bin/dbvO
	-mv $(ORACLE_HOME)/rdbms/lib/dbv $(ORACLE_HOME)/bin/dbv
	-chmod 751 $(ORACLE_HOME)/bin/dbv

itstshm: $(TSTSHM)
	-mv -f $(ORACLE_HOME)/bin/tstshm $(ORACLE_HOME)/bin/tstshmO
	-mv $(ORACLE_HOME)/rdbms/lib/tstshm $(ORACLE_HOME)/bin/tstshm
	-chmod 751 $(ORACLE_HOME)/bin/tstshm

imaxmem: $(MAXMEM)
	-mv -f $(ORACLE_HOME)/bin/maxmem $(ORACLE_HOME)/bin/maxmemO
	-mv $(ORACLE_HOME)/rdbms/lib/maxmem $(ORACLE_HOME)/bin/maxmem
	-chmod 751 $(ORACLE_HOME)/bin/maxmem

iorapwd: $(ORAPWD)
	-mv -f $(ORACLE_HOME)/bin/orapwd $(ORACLE_HOME)/bin/orapwdO
	-mv $(ORACLE_HOME)/rdbms/lib/orapwd $(ORACLE_HOME)/bin/orapwd
	-chmod 751 $(ORACLE_HOME)/bin/orapwd

idbfsize: $(DBFSIZE)
	-mv -f $(ORACLE_HOME)/bin/dbfsize $(ORACLE_HOME)/bin/dbfsizeO
	-mv $(ORACLE_HOME)/rdbms/lib/dbfsize $(ORACLE_HOME)/bin/dbfsize
	-chmod 751 $(ORACLE_HOME)/bin/dbfsize

icursize: $(CURSIZE)
	-mv -f $(ORACLE_HOME)/bin/cursize $(ORACLE_HOME)/bin/cursizeO
	-mv $(ORACLE_HOME)/rdbms/lib/cursize $(ORACLE_HOME)/bin/cursize
	-chmod 751 $(ORACLE_HOME)/bin/cursize

isvrmgrl: $(SVRMGRL)
	-mv -f $(ORACLE_HOME)/bin/svrmgrl $(ORACLE_HOME)/bin/svrmgrlO
	-mv $(ORACLE_HOME)/rdbms/lib/svrmgrl $(ORACLE_HOME)/bin/svrmgrl
	-chmod 751 $(ORACLE_HOME)/bin/svrmgrl

itdscomp: $(TDSCOMP)
	-mv -f $(ORACLE_HOME)/bin/tdscomp $(ORACLE_HOME)/bin/tdscompO
	-mv tdscomp $(ORACLE_HOME)/bin/tdscomp
	-chmod 751 $(ORACLE_HOME)/bin/tdscomp

iplsff: $(PLSFF)
	-mv -f $(ORACLE_HOME)/bin/plsff $(ORACLE_HOME)/bin/plsffO
	-mv plsff $(ORACLE_HOME)/bin/plsff
	-chmod 751 $(ORACLE_HOME)/bin/plsff

iextproc: $(EXTPROC)
	-mv -f $(ORACLE_HOME)/bin/extproc $(ORACLE_HOME)/bin/extprocO
	-mv $(ORACLE_HOME)/rdbms/lib/extproc $(ORACLE_HOME)/bin/extproc
	-chmod 751 $(ORACLE_HOME)/bin/extproc

iagtctl: $(AGTCTL)
	-mv -f $(ORACLE_HOME)/bin/agtctl $(ORACLE_HOME)/bin/agtctlO
	-mv $(ORACLE_HOME)/rdbms/lib/agtctl $(ORACLE_HOME)/bin/agtctl
	-chmod 751 $(ORACLE_HOME)/bin/agtctl

ihsalloci: $(HSALLOCI)
	-mv -f $(ORACLE_HOME)/bin/hsalloci $(ORACLE_HOME)/bin/hsallociO
	-mv hsalloci $(ORACLE_HOME)/bin/hsalloci
	-chmod 751 $(ORACLE_HOME)/bin/hsalloci

ihsots: $(HSOTS)
	-mv -f $(ORACLE_HOME)/bin/hsots $(ORACLE_HOME)/bin/hsotsO
	-mv hsots $(ORACLE_HOME)/bin/hsots
	-chmod 751 $(ORACLE_HOME)/bin/hsots

ihsdepxa: $(HSDEPXA)
	-mv -f $(ORACLE_HOME)/bin/hsdepxa $(ORACLE_HOME)/bin/hsdepxaO
	-mv hsdepxa $(ORACLE_HOME)/bin/hsdepxa
	-chmod 751 $(ORACLE_HOME)/bin/hsdepxa

iarchmon: $(ARCHMON)
	-mv -f $(ORACLE_HOME)/bin/archmon $(ORACLE_HOME)/bin/archmonO
	-mv archmon $(ORACLE_HOME)/bin/archmon
	-chmod 751 $(ORACLE_HOME)/bin/archmon

iosh: $(OSH)
	-mv -f $(ORACLE_HOME)/bin/osh $(ORACLE_HOME)/bin/oshO
	-mv osh $(ORACLE_HOME)/bin/osh
	-chmod 751 $(ORACLE_HOME)/bin/osh

isbttest: $(SBTTEST)
	-mv -f $(ORACLE_HOME)/bin/sbttest $(ORACLE_HOME)/bin/sbttestO
	-mv sbttest $(ORACLE_HOME)/bin/sbttest
	-chmod 751 $(ORACLE_HOME)/bin/sbttest

iexp: $(EXP)
	-mv -f $(ORACLE_HOME)/bin/exp $(ORACLE_HOME)/bin/expO
	-mv $(ORACLE_HOME)/rdbms/lib/exp $(ORACLE_HOME)/bin/exp
	-chmod 751 $(ORACLE_HOME)/bin/exp

iimp: $(IMP)
	-mv -f $(ORACLE_HOME)/bin/imp  $(ORACLE_HOME)/bin/impO
	-mv $(ORACLE_HOME)/rdbms/lib/imp $(ORACLE_HOME)/bin/imp
	-chmod 751 $(ORACLE_HOME)/bin/imp

isqlldr: $(SQLLDR)
	-mv -f $(ORACLE_HOME)/bin/sqlldr $(ORACLE_HOME)/bin/sqlldrO
	-mv $(ORACLE_HOME)/rdbms/lib/sqlldr $(ORACLE_HOME)/bin/sqlldr
	-chmod 751 $(ORACLE_HOME)/bin/sqlldr

itkprof: $(TKPROF)
	-mv -f $(ORACLE_HOME)/bin/tkprof $(ORACLE_HOME)/bin/tkprofO
	-mv $(ORACLE_HOME)/rdbms/lib/tkprof $(ORACLE_HOME)/bin/tkprof
	-chmod 751 $(ORACLE_HOME)/bin/tkprof

irman: $(RMAN)
	-mv -f $(ORACLE_HOME)/bin/rman $(ORACLE_HOME)/bin/rmanO
	-mv $(ORACLE_HOME)/rdbms/lib/rman $(ORACLE_HOME)/bin/rman
	-chmod 751 $(ORACLE_HOME)/bin/rman

ikgmgr: $(KGMGR)
	-mv -f $(ORACLE_HOME)/bin/kgmgr $(ORACLE_HOME)/bin/kgmgrO
	-mv $(ORACLE_HOME)/rdbms/lib/kgmgr $(ORACLE_HOME)/bin/kgmgr
	-chmod 751 $(ORACLE_HOME)/bin/kgmgr

iloadpsp: $(LOADPSP)
	-mv -f $(ORACLE_HOME)/bin/loadpsp $(ORACLE_HOME)/bin/loadpspO
	-mv $(ORACLE_HOME)/rdbms/lib/loadpsp $(ORACLE_HOME)/bin/loadpsp
	-chmod 751 $(ORACLE_HOME)/bin/loadpsp

singletask: iexpst iimpst isqlldrst

iexpst: expst
	-mv -f $(ORACLE_HOME)/bin/expst $(ORACLE_HOME)/bin/expstO
	-mv expst $(ORACLE_HOME)/bin/expst
	-chmod 751 $(ORACLE_HOME)/bin/expst

iimpst: impst
	-mv -f $(ORACLE_HOME)/bin/impst $(ORACLE_HOME)/bin/impstO
	-mv impst $(ORACLE_HOME)/bin/impst
	-chmod 751 $(ORACLE_HOME)/bin/impst

isqlldrst: sqlldrst
	-mv -f $(ORACLE_HOME)/bin/sqlldrst $(ORACLE_HOME)/bin/sqlldrstO
	-mv sqlldrst $(ORACLE_HOME)/bin/sqlldrst
	-chmod 751 $(ORACLE_HOME)/bin/sqlldrst

expst: $(EXPMAI) $(DEF_OPT) $(SSDBED)
	$(SILENT)$(ECHO) " - Linking Singletask Export utility (exp)"
	$(LINK) $(EXPMAI) $(SSDBED) $(DEF_OPT) $(LLIBDBTOOLS) $(LINKSTLIBS)

impst: $(IMPMAI) $(DEF_OPT) $(SSDBED)
	$(SILENT)$(ECHO) " - Linking Singletask Import utility (imp)"
	$(LINK) $(IMPMAI) $(SSDBED) $(DEF_OPT) $(LLIBDBTOOLS) $(LINKSTLIBS)

sqlldrst: $(LDRMAI) $(DEF_OPT) $(SSDBED)
	$(SILENT)$(ECHO) " - Linking Singletask SQL*Loader utility (sqlldr)"
	$(LINK) $(LDRMAI) $(SSDBED) $(DEF_OPT) \
	$(RDBMSLIB)$(LIL_OFF) $(LLIBDBTOOLS) $(LINKSTLIBS)

preinstall:
	-chmod 755 $(ORACLE_HOME)/bin

install: preinstall $(INSTALL_TARGS)


$(GENKSMS): ranlib $(GKSMAI)
	$(SILENT)$(ECHO) " - Linking SGA map generator (genksms)"
	$(LINK) $@ $(GKSMAI) $(LINKLDLIBS)

clean:
	-rm -f $(ALL_EXECS) $(RDBMSLIB)ksms.s $(RDBMSLIB)ksms.o
# Exiting /vobs/oracle/rdbms/install/cus_rdbms.mk
# Entering link.mk

ops_on: $(KNLOPT_LOCAL) $(RDBMSLIB)$(OPS_ON) $(SKGXP_OPS_ON)
	$(SILENT)if $(ARPRINT) $(LIBKNLOPT) | $(GREP) '^'$(OPS_OFF) > /dev/null ; then \
		$(ECHODO) $(ARDELETE) $(LIBKNLOPT) $(OPS_OFF) ; \
	fi
	$(ARCREATE) $(LIBKNLOPT) $(RDBMSLIB)$(OPS_ON) $(RANLIBL)
	$(MAKE) -f $(MAKEFILE) $(NMLIBLIST)
 
ops_off: $(KNLOPT_LOCAL) $(RDBMSLIB)$(OPS_OFF) $(SKGXP_DEFAULT)
	$(SILENT)if $(ARPRINT) $(LIBKNLOPT) | $(GREP) '^'$(OPS_ON) > /dev/null ; then \
		$(ECHODO) $(ARDELETE) $(LIBKNLOPT) $(OPS_ON) ; \
	fi
	$(ECHO) "$(NMOFF)" > $(NMLIBLIST);
	$(ARCREATE) $(LIBKNLOPT) $(RDBMSLIB)$(OPS_OFF) $(RANLIBL)

nmliblist $(NMLIBLIST) : $(LIBKNLOPT)
	$(RMF) $(NMLIBLIST)
	$(GENNMLIBLIST)

sdo_on: $(KNLOPT_LOCAL) $(RDBMSLIB)$(SDO_ON)
	$(SILENT)if $(ARPRINT) $(LIBKNLOPT) | $(GREP) '^'$(SDO_OFF) > /dev/null ; then \
		$(ECHODO) $(ARDELETE) $(LIBKNLOPT) $(SDO_OFF) ; \
	fi
	$(ARCREATE) $(LIBKNLOPT) $(RDBMSLIB)$(SDO_ON) $(RANLIBL)

sdo_off: $(KNLOPT_LOCAL) $(RDBMSLIB)$(SDO_OFF)
	$(SILENT)if $(ARPRINT) $(LIBKNLOPT) | $(GREP) '^'$(SDO_ON) > /dev/null ; then \
		$(ECHODO) $(ARDELETE) $(LIBKNLOPT) $(SDO_ON) ; \
	fi
	$(ARCREATE) $(LIBKNLOPT) $(RDBMSLIB)$(SDO_OFF) $(RANLIBL)

ctx_on:	$(KNLOPT_LOCAL) $(RDBMSLIB)$(CTX_ON)
	$(SILENT)if $(ARPRINT) $(LIBKNLOPT) | $(GREP) '^'$(CTX_OFF) > /dev/null ; then \
		$(ECHODO) $(ARDELETE) $(LIBKNLOPT) $(CTX_OFF) ; \
	fi
	$(ARCREATE) $(LIBKNLOPT) $(RDBMSLIB)$(CTX_ON) $(RANLIBL)

ctx_off: $(KNLOPT_LOCAL) $(RDBMSLIB)$(CTX_OFF)
	$(SILENT)if $(ARPRINT) $(LIBKNLOPT) | $(GREP) '^'$(CTX_ON) > /dev/null ; then \
		$(ECHODO) $(ARDELETE) $(LIBKNLOPT) $(CTX_ON) ; \
	fi
	$(ARCREATE) $(LIBKNLOPT) $(RDBMSLIB)$(CTX_OFF) $(RANLIBL)	

obj_on: $(KNLOPT_LOCAL) $(RDBMSLIB)$(OBJ_ON)
	$(SILENT)if $(ARPRINT) $(LIBKNLOPT) | $(GREP) '^'$(OBJ_OFF) > /dev/null ; then \
		$(ECHODO) $(ARDELETE) $(LIBKNLOPT) $(OBJ_OFF) ; \
	fi
	$(ARCREATE) $(LIBKNLOPT) $(RDBMSLIB)$(OBJ_ON) $(RANLIBL)

obj_off: $(KNLOPT_LOCAL) $(RDBMSLIB)$(OBJ_OFF)
	$(SILENT)if $(ARPRINT) $(LIBKNLOPT) | $(GREP) '^'$(OBJ_ON) > /dev/null ; then \
		$(ECHODO) $(ARDELETE) $(LIBKNLOPT) $(OBJ_ON) ; \
	fi
	$(ARCREATE) $(LIBKNLOPT) $(RDBMSLIB)$(OBJ_OFF) $(RANLIBL)

part_on: $(KNLOPT_LOCAL) $(RDBMSLIB)$(PART_ON)
	$(SILENT)if $(ARPRINT) $(LIBKNLOPT) | $(GREP) '^'$(PART_OFF) > /dev/null ; then \
		$(ECHODO) $(ARDELETE) $(LIBKNLOPT) $(PART_OFF) ; \
	fi
	$(ARCREATE) $(LIBKNLOPT) $(RDBMSLIB)$(PART_ON) $(RANLIBL)

part_off: $(KNLOPT_LOCAL) $(RDBMSLIB)$(PART_OFF)
	$(SILENT)if $(ARPRINT) $(LIBKNLOPT) | $(GREP) '^'$(PART_ON) > /dev/null ; then \
		$(ECHODO) $(ARDELETE) $(LIBKNLOPT) $(PART_ON) ; \
	fi
	$(ARCREATE) $(LIBKNLOPT) $(RDBMSLIB)$(PART_OFF) $(RANLIBL)

linit:
	$(SILENT)$(RMF) $(DEF_OPT)

def_on $(DEF_OPT): $(DEF_ON)
	$(SILENT)$(ECHO) "Using deferred protocol.."
	$(SILENT)$(RMF) $(DEF_OPT)
	$(SILENT)$(CP) $(DEF_ON) $(DEF_OPT)	

def_off: $(DEF_OFF)
	$(SILENT)$(ECHO) "Using non-deferred protocol.."
	$(SILENT)$(RMF) $(DEF_OPT)
	$(SILENT)$(CP) $(DEF_OFF) $(DEF_OPT)


$(ORACLE): $(ALWAYS) $(ORACLE_DEPS) $(DEF_OPT) $(NMLIBLIST) $(INS_CONFIG)
	$(SILENT)$(ECHO)
	$(SILENT)$(ECHO) " - Linking Oracle "
	$(RMF) $@
	$(ORACLE_LINKLINE)

$(IMP) : $(ALWAYS) $(IMP_DEPS) $(DEF_OPT)
	$(SILENT)$(ECHO)
	$(SILENT)$(ECHO) " - Linking Import utility (imp)"
	$(RMF) $@
	$(IMP_LINKLINE)

$(EXP) : $(ALWAYS) $(EXP_DEPS) $(DEF_OPT)
	$(SILENT)$(ECHO)
	$(SILENT)$(ECHO) " - Linking Export utility (exp)"
	$(RMF) $@
	$(EXP_LINKLINE)

$(SQLLDR) : $(ALWAYS) $(SQLLDR_DEPS) $(DEF_OPT)
	$(SILENT)$(ECHO)
	$(SILENT)$(ECHO) " - Linking SQL*Loader utility (sqlldr)"
	$(RMF) $@
	$(LDR_LINKLINE)

$(SQLLDR_LIL) : $(ALWAYS) $(SQLLIL_DEPS) $(DEF_OPT)
	$(SILENT)$(ECHO)
	$(SILENT)$(ECHO) " - Linking SQL*Loader utility (sqlldr)"
	$(RMF) $@
	$(LIL_LINKLINE)

$(MIG) : $(ALWAYS) $(MIG_DEPS) $(DEF_OPT)
	$(SILENT)$(ECHO)
	$(SILENT)$(ECHO) "Linking Migration utility (mig)"
	$(RMF) $@
	$(MIG_LINKLINE)

$(DBVERIFY) : $(ALWAYS) $(DBVERIFY_DEPS) $(DEF_OPT)
	$(SILENT)$(ECHO)
	$(SILENT)$(ECHO) " - Linking DB*Verify utility (dbv)"
	$(RMF) $@
	$(DBV_LINKLINE)
	
$(TSTSHM) : $(ALWAYS) $(TSTSHM_DEPS) $(DEF_OPT)
	$(SILENT)$(ECHO)
	$(SILENT)$(ECHO) " - Linking shared memory test utility (tstshm)"
	$(RMF) $@
	$(TSTSHM_LINKLINE)

$(MAXMEM) : $(ALWAYS) $(MAXMEM_DEPS) $(DEF_OPT)
	$(SILENT)$(ECHO)
	$(SILENT)$(ECHO) " - Linking max memory test utility (maxmem)"
	$(RMF) $@
	$(MAXMEM_LINKLINE)

$(ORAPWD) : $(ALWAYS) $(ORAPWD_DEPS) $(DEF_OPT)
	$(SILENT)$(ECHO)
	$(SILENT)$(ECHO) " - Linking password utility (orapwd)"
	$(RMF) $@
	$(ORAPWD_LINKLINE)

$(TKPROF) : $(ALWAYS) $(TKPROF_DEPS) $(DEF_OPT)
	$(SILENT)$(ECHO)
	$(SILENT)$(ECHO) " - Linking performance trace utility (tkprof)"
	$(RMF) $@
	$(TKPROF_LINKLINE)

$(DBFSIZE) : $(ALWAYS) $(DBFSIZE_DEPS) $(DEF_OPT)
	$(SILENT)$(ECHO)
	$(SILENT)$(ECHO) " - Linking database file size utility (dbfsize)"
	$(RMF) $@
	$(DBFSIZE_LINKLINE)

$(CURSIZE) : $(ALWAYS) $(CURSIZE_DEPS) $(DEF_OPT)
	$(SILENT)$(ECHO)
	$(SILENT)$(ECHO) " - Linking cursor size utility (cursize)"
	$(RMF) $@
	$(CURSIZE_LINKLINE)

$(RMAN) : $(ALWAYS) $(RMAN_DEPS) $(DEF_OPT)
	$(SILENT)$(ECHO)
	$(SILENT)$(ECHO) " - Linking recovery manager (rman)"
	$(RMF) $@
	$(RMAN_LINKLINE)

$(SVRMGRL) : $(ALWAYS) $(SVRMGRL_DEPS) $(DEF_OPT)
	$(SILENT)$(ECHO)
	$(SILENT)$(ECHO) "Linking svrmgrl"
	$(RMF) $@
	$(SVRMGRL_LINKLINE)

$(TDSCOMP) : $(ALWAYS) $(TDSCOMP_DEPS) $(DEF_OPT)
	$(SILENT)$(ECHO)
	$(SILENT)$(ECHO) " - Linking TDS compiler (tdscomp)"
	$(RMF) $@
	$(TDSCOMP_LINKLINE)

$(EXTPROC): $(ALWAYS) $(EXTPROC_DEPS) $(DEF_OPT)
	$(SILENT)$(ECHO)
	$(SILENT)$(ECHO) "Linking external procedure agent (extproc)"
	$(RMF) $@
	$(EXTPROC_LINKLINE)

$(AGTCTL): $(ALWAYS) $(AGTCTL_DEPS) $(DEF_OPT)
	$(SILENT)$(ECHO)
	$(SILENT)$(ECHO) " - Linking Agent Control Utility"
	$(RMF) $@
	$(AGTCTL_LINKLINE)

$(HSALLOCI): $(ALWAYS) $(HSALLOCI_DEPS) $(DEF_OPT)
	$(SILENT)$(ECHO)
	$(SILENT)$(ECHO) " - Linking HS ORACLE/OCI agent"
	$(RMF) $@
	$(HSALLOCI_LINKLINE)

$(HSDEPXA) : $(ALWAYS) $(HSDEPXA_DEPS) $(DEF_OPT)
	$(SILENT)$(ECHO)
	$(SILENT)$(ECHO) " - Linking HS Distributed External Procedure agent"
	$(RMF) $@
	$(HSDEPXA_LINKLINE)

$(HSOTS) : $(ALWAYS) $(HSOTS_DEPS) $(DEF_OPT)
	$(SILENT)$(ECHO)
	$(SILENT)$(ECHO) " - Linking HS OTS agent"
	$(RMF) $@
	$(HSOTS_LINKLINE)

$(ARCHMON) : $(ALWAYS) $(ARCHMON_DEPS) $(DEF_OPT)
	$(SILENT)$(ECHO)
	$(SILENT)$(ECHO) " - Linking archmon utility (archmon)"
	$(RMF) $@
	$(ARCHMON_LINKLINE)

$(OSH) : $(ALWAYS) $(OSH_DEPS) $(DEF_OPT)
	$(SILENT)$(ECHO)
	$(SILENT)$(ECHO) " - Linking osh utility (osh)"	
	$(RMF) $@
	$(OSH_LINKLINE)

$(BBED): $(ALWAYS) $(BBED_DEPS) $(DEF_OPT)
	$(SILENT)$(ECHO)
	$(SILENT)$(ECHO) "Linking BBED utility (bbed)"
	$(RMF) $@
	$(BBED_LINKLINE)

$(SBTTEST): $(ALWAYS) $(SBTTEST_DEPS) $(DEF_OPT)
	$(SILENT)$(ECHO)
	$(SILENT)$(ECHO) "Linking SBTTEST utility (sbttest)"
	$(RMF) $@
	$(SBTTEST_LINKLINE)

$(KGMGR): $(ALWAYS) $(KGMGR_DEPS) $(DEF_OPT)
	$(SILENT)$(RMF) $@
	$(SILENT)$(ECHO) "Linking KGMGR (kgmgr)"
	$(KGMGR_LINKLINE)

$(LOADPSP): $(ALWAYS) $(LOADPSP_DEPS)
	$(SILENT)$(RMF) $@
	$(SILENT)$(ECHO) " - Linking PSP Loader utility (loadpsp)"
	$(LOADPSP_LINKLINE)


# Exiting link.mk
# Entering s_link.mk

# Exiting s_link.mk
