/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.Reference;
import javax.naming.StringRefAddr;

class JNDIPublish {
    JNDIPublish() {
    }

    public static void main(String[] args) {
        String username = null;
        String password = null;
        String server = "ldap://dlsun502";
        String IORfile = null;
        String name = null;
        String helperclassname = null;
        boolean replace = false;
        int i = 0;
        while (i < args.length) {
            if (args[i].compareTo("-u") == 0) {
                username = args[++i];
            } else if (args[i].compareTo("-p") == 0) {
                password = args[++i];
            } else if (args[i].compareTo("-s") == 0) {
                server = args[++i];
            } else if (args[i].compareTo("-f") == 0) {
                IORfile = args[++i];
            } else if (args[i].compareTo("-n") == 0) {
                name = args[++i];
            } else if (args[i].compareTo("-h") == 0) {
                helperclassname = args[++i];
            } else if (args[i].compareTo("-r") == 0) {
                replace = true;
            } else {
                System.out.println("Invalid option " + args[i]);
                System.out.println("\nUsage: JNDIPublish [-u username] [-p password] [-s server] -f IORfile -n name -h helperclassname ");
                System.exit(1);
            }
            ++i;
        }
        if (IORfile == null || name == null || helperclassname == null) {
            System.out.println("Required arguments are not passed in");
            System.out.println("\nUsage: JNDIPublish [-u username] [-p password] [-s server] -f IORfile -n name -h helperclassname [-r]");
            System.exit(1);
        }
        Properties env = new Properties();
        ((Hashtable)env).put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        ((Hashtable)env).put("java.naming.provider.url", server);
        if (username != null && password != null) {
            ((Hashtable)env).put("java.naming.security.authentication", "simple");
            ((Hashtable)env).put("java.naming.security.principal", username);
            ((Hashtable)env).put("java.naming.security.credentials", password);
        }
        try {
            InitialContext ctx = new InitialContext(env);
            String ior = null;
            byte[] in = null;
            try {
                FileInputStream s = new FileInputStream(IORfile);
                in = new byte[s.available()];
                s.read(in);
                s.close();
                ior = new String(in);
            }
            catch (IOException e) {
                System.err.println("Unable to read IOR from " + IORfile);
                e.printStackTrace();
                System.exit(1);
            }
            Reference ref = new Reference(name, "oracle.aurora.jndi.CORBAObjectFactory", null);
            StringRefAddr refior = new StringRefAddr("Stringified IOR", ior);
            StringRefAddr refhelper = new StringRefAddr("HelperClass", helperclassname);
            ref.add(refhelper);
            ref.add(refior);
            if (replace) {
                try {
                    ctx.unbind("javaclassname=" + name);
                }
                catch (Exception exception) {
                    System.out.println("The object " + name + " doesn't exist in the server.  No replacement is done");
                }
            }
            ctx.bind("javaclassname=" + name, (Object)ref);
            System.out.println("Object " + name + " with helper class " + helperclassname + " has been stored in " + server);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Error occurred in JNDIPublish");
        }
    }
}

