/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.ejb.deployment;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.ejb.deployment.DeploymentDescriptor;
import javax.naming.Name;
import oracle.aurora.ejb.deployment.EjbDeploymentTool;
import oracle.aurora.ejb.deployment.EjbJarFileEditor;
import oracle.aurora.ejb.parser.EnterpriseBeanParser;
import oracle.aurora.server.tools.sess_iiop.ToolImpl;
import oracle.aurora.server.tools.sess_iiop.ToolsException;

public class CreateEjb
extends EjbDeploymentTool {
    Name jarIn;
    Name jarOut;
    Name descriptorFile;
    String beanName;
    private static final String DEFAULT_BEAN_NAME = "ejb.ejb";

    private String beanName() {
        if (this.beanName == null) {
            return DEFAULT_BEAN_NAME;
        }
        return this.beanName;
    }

    public String description() throws ToolsException {
        return this.msg("CREATE_EJB_DESCRIPTION", null);
    }

    public String help() throws ToolsException {
        return this.msg("CREATE_EJB_HELP", null);
    }

    protected void invoke() throws ToolsException {
        FileInputStream inStream = null;
        try {
            try {
                inStream = new FileInputStream((File)ToolImpl.local_wd.lookup(this.descriptorFile));
                EjbJarFileEditor in = new EjbJarFileEditor((File)ToolImpl.local_wd.lookup(this.jarIn));
                DeploymentDescriptor descriptor = EnterpriseBeanParser.parseDescriptor(inStream, in.classLoader());
                EjbJarFileEditor e = new EjbJarFileEditor((File)ToolImpl.local_wd.lookup(this.jarOut));
                e.addDeploymentDescriptor(this.beanName(), descriptor);
                e.save();
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.fail1("FILE_NOT_FOUND", this.descriptorFile.toString());
            }
            catch (Exception e) {
                this.fail2("CANNOT_PARSE", this.descriptorFile.toString(), e.getMessage());
            }
            Object var3_6 = null;
        }
        catch (Throwable throwable) {
            Object var3_7 = null;
            try {
                if (inStream != null) {
                    ((InputStream)inStream).close();
                }
            }
            catch (IOException iOException) {
                this.fail1("CANNOT_CLOSE_FILE", this.descriptorFile.toString());
            }
            throw throwable;
        }
        try {
            if (inStream != null) {
                ((InputStream)inStream).close();
            }
        }
        catch (IOException iOException) {
            this.fail1("CANNOT_CLOSE_FILE", this.descriptorFile.toString());
        }
    }

    public static void main(String[] args) {
        try {
            new CreateEjb().invoke(args, System.in, System.out, System.err);
        }
        catch (ToolsException e) {
            System.err.println();
            System.err.println(e.getMessage());
            System.exit(1);
        }
        System.exit(0);
    }

    protected void parseArgs(String[] argv) throws ToolsException {
        int i = 0;
        while (i < argv.length) {
            if (argv[i].equals("-out")) {
                if (argv.length == ++i) {
                    this.fail0("MISSING_OUTPUT_JAR");
                }
                this.jarOut = ToolImpl.local_wd.parse(argv[i]);
            } else {
                if (!argv[i].equals("-named")) break;
                if (argv.length == ++i) {
                    this.fail0("MISSING_BEAN_NAME");
                }
                this.beanName = argv[i];
            }
            ++i;
        }
        if (argv.length == i) {
            this.error(this.usage());
        }
        this.descriptorFile = ToolImpl.local_wd.parse(argv[i++]);
        this.jarIn = ToolImpl.local_wd.parse(argv[i]);
        if (argv.length > ++i) {
            this.error(this.usage());
        }
    }

    public String usage() throws ToolsException {
        return this.msg("CREATE_EJB_USAGE", null);
    }

    public String version() throws ToolsException {
        return this.msg("CREATE_EJB_VERSION", null);
    }
}

