/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.ejb.deployment;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.Identity;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.ejb.deployment.AccessControlEntry;
import javax.ejb.deployment.ControlDescriptor;
import javax.ejb.deployment.DeploymentDescriptor;
import oracle.aurora.ejb.deployment.EjbJarFileEditor;
import oracle.aurora.ejb.parser.EnterpriseBeanParser;
import oracle.aurora.server.tools.sess_iiop.ToolsException;

public class DDVerifier {
    boolean sessionBean = true;
    private static ResourceBundle resMessage = ResourceBundle.getBundle("oracle.aurora.ejb.deployment.Message");
    ClassLoader loader;
    DeploymentDescriptor descriptor;
    boolean hasDefaultAce = false;
    boolean hasDefaultCd = false;
    Class[] validBeanClasses;
    Class[] validRemoteInterfaces;
    private static ResourceBundle bundle;
    private static final String messageFile = "oracle.aurora.ejb.deployment.Message";
    static /* synthetic */ Class class$javax$ejb$EJBHome;
    static /* synthetic */ Class class$java$rmi$RemoteException;
    static /* synthetic */ Class class$javax$ejb$CreateException;
    static /* synthetic */ Class class$javax$ejb$EJBObject;
    static /* synthetic */ Class class$javax$ejb$EntityBean;

    public DDVerifier(ClassLoader l, DeploymentDescriptor d) {
        this.loader = l;
        this.descriptor = d;
    }

    AccessControlEntry[] acl() {
        return this.descriptor.getAccessControlEntries();
    }

    Method[] aclMethods() {
        Hashtable<Method, String> set = new Hashtable<Method, String>();
        AccessControlEntry[] acl = this.acl();
        int i = 0;
        while (i < acl.length) {
            if (acl[i].getMethod() != null) {
                set.put(acl[i].getMethod(), "foo bar loves ya!");
            }
            ++i;
        }
        Method[] rslt = new Method[set.size()];
        int i2 = 0;
        Enumeration e = set.keys();
        while (e.hasMoreElements()) {
            rslt[i2] = (Method)e.nextElement();
        }
        return rslt;
    }

    Class bean() throws ToolsException {
        try {
            return this.loader.loadClass(this.descriptor.getEnterpriseBeanClassName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.fail1("ENTERPRISE_BEAN_CLASS_NOT_FOUND", this.descriptor.getEnterpriseBeanClassName());
            return null;
        }
    }

    ControlDescriptor[] cdl() {
        return this.descriptor.getControlDescriptors();
    }

    Method[] cdlMethods() {
        Hashtable<Method, String> set = new Hashtable<Method, String>();
        ControlDescriptor[] cdl = this.cdl();
        int i = 0;
        while (i < cdl.length) {
            if (cdl[i].getMethod() != null) {
                set.put(cdl[i].getMethod(), "foo bar loves ya!");
            }
            ++i;
        }
        Method[] rslt = new Method[set.size()];
        int i2 = 0;
        Enumeration e = set.keys();
        while (e.hasMoreElements()) {
            rslt[i2] = (Method)e.nextElement();
        }
        return rslt;
    }

    void checkAce(AccessControlEntry entry) throws ToolsException {
        Identity[] allowed = entry.getAllowedIdentities();
        Method m = entry.getMethod();
        if (entry.getAllowedIdentities() == null) {
            this.fail1("ACE_ALLOWED_IDENTITIES_NULL", this.toString(m));
        }
        int i = 0;
        while (i < allowed.length) {
            if (allowed[i] == null) {
                this.fail2("NULL_IDENTITY_IN_ALLOWED_IDENTITIES", String.valueOf(i), this.toString(m));
            }
            ++i;
        }
    }

    void checkAcl() throws ToolsException {
        AccessControlEntry[] acl = this.acl();
        Class bean = this.bean();
        Hashtable<Method, String> set = new Hashtable<Method, String>();
        int i = 0;
        while (i < acl.length) {
            if (acl[i].getMethod() != null) {
                if (set.get(acl[i].getMethod()) != null) {
                    this.fail1("DUPLICATE_ACE", this.toString(acl[i].getMethod()));
                }
                set.put(acl[i].getMethod(), "foo bar loves ya!");
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < acl.length) {
            this.checkAce(acl[i2]);
            ++i2;
        }
    }

    void checkBean() throws ToolsException {
        boolean hasCreate = false;
        this.checkPublicConstructor();
        if (Modifier.isAbstract(this.bean().getModifiers())) {
            this.fail1("MUST_NOT_BE_ABSTRACT", this.bean().getName());
        }
        if (this.sessionBean) {
            Method[] beanMethods = this.getBeanMethods();
            int i = 0;
            while (i < beanMethods.length) {
                if (beanMethods[i].getName().equals("ejbCreate") && Modifier.isPublic(beanMethods[i].getModifiers()) && beanMethods[i].getReturnType().equals(Void.TYPE) && beanMethods[i].getParameterTypes().length == 0) {
                    hasCreate = true;
                    break;
                }
                ++i;
            }
        } else {
            hasCreate = true;
        }
        if (!hasCreate) {
            this.fail1("MUST_IMPLEMENT_CREATE", this.bean().getName());
        }
    }

    void checkCd(ControlDescriptor entry) throws ToolsException {
        if (entry.getRunAsMode() == 1 && entry.getRunAsIdentity() == null) {
            this.fail1("RUN_AS_IDENTITY_NULL", this.toString(entry.getMethod()));
        }
    }

    void checkCdl() throws ToolsException {
        ControlDescriptor[] cdl = this.cdl();
        Class bean = this.bean();
        Hashtable<Method, String> set = new Hashtable<Method, String>();
        int i = 0;
        while (i < cdl.length) {
            if (cdl[i].getMethod() != null) {
                if (set.get(cdl[i].getMethod()) != null) {
                    this.fail1("DUPLICATE_CD", this.toString(cdl[i].getMethod()));
                }
                set.put(cdl[i].getMethod(), "foo bar loves ya!");
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < cdl.length) {
            this.checkCd(cdl[i2]);
            ++i2;
        }
    }

    void checkDescriptor() throws ToolsException {
        if (this.descriptor.getBeanHomeName() == null) {
            this.fail0("BEAN_HOME_NAME_MUST_NOT_BE_NULL");
        }
        this.checkAcl();
        this.checkCdl();
        Method[] methods = this.getDeclaredMethods();
        Method[] rim = this.getEjbObjectMethods();
        Method[] him = this.getEjbHomeMethods();
        int i = 0;
        while (i < methods.length) {
            if (!this.checkIncludedInInterface(rim, methods[i]) && !this.checkIncludedInInterface(him, methods[i])) {
                this.fail1("DECLARED_METHOD_NOT_EXIST", this.simpleString(methods[i]));
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < methods.length) {
            if (!this.isValidBeanClass(methods[i2].getDeclaringClass())) {
                this.fail1("MUST_BE_BEAN_METHOD", this.toString(methods[i2]));
            }
            ++i2;
        }
        Method[] aclMethods = this.aclMethods();
        if (rim.length + him.length > this.aclMethods().length && !this.hasDefaultAce) {
            this.errorMethodsDontHaveAce(aclMethods, rim, him);
        }
        Method[] cdlMethods = this.cdlMethods();
        if (rim.length + him.length > this.cdlMethods().length && !this.hasDefaultCd) {
            this.errorMethodsDontHaveCd(cdlMethods, rim, him);
        }
    }

    void checkEjbHome() throws ToolsException {
        if (!(class$javax$ejb$EJBHome != null ? class$javax$ejb$EJBHome : (class$javax$ejb$EJBHome = DDVerifier.class$("javax.ejb.EJBHome"))).isAssignableFrom(this.homeInterface())) {
            this.fail1("MUST_EXTEND_EJB_HOME", this.homeInterface().getName());
        }
        Method[] him = this.getEjbHomeMethods();
        Method[] bms = this.getBeanMethods();
        if (this.sessionBean) {
            int i = 0;
            while (i < him.length) {
                if (!him[i].getName().equals("create")) {
                    this.fail1("ONLY_CREATE_METHODS", this.toString(him[i]));
                }
                if (!this.checkIncludedInBean(bms, him[i])) {
                    this.fail1("BEAN_METHOD_NOT_EXIST", this.toStringOfBean(him[i]));
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < him.length) {
                if (him[i2].getReturnType().equals(Void.TYPE)) {
                    this.fail1("CREATE_MUST_RETURN_VALUE", this.toString(him[i2]));
                }
                if (!this.isValidRemoteInterface(him[i2].getReturnType())) {
                    this.fail1("CREATE_MUST_RETURN_CORRECT_INTERFACE", this.toString(him[i2]));
                }
                if (!this.containsException(him[i2].getExceptionTypes(), class$java$rmi$RemoteException != null ? class$java$rmi$RemoteException : DDVerifier.class$("java.rmi.RemoteException"))) {
                    this.fail1("HOME_METHODS_MUST_THROW_REMOTE_EXCEPTION", this.toString(him[i2]));
                }
                if (!this.containsException(him[i2].getExceptionTypes(), class$javax$ejb$CreateException != null ? class$javax$ejb$CreateException : DDVerifier.class$("javax.ejb.CreateException"))) {
                    this.fail1("CREATE_MUST_THROW_CREATE_EXCEPTION", this.toString(him[i2]));
                }
                ++i2;
            }
        }
    }

    void checkEjbObject() throws ToolsException {
        if (!(class$javax$ejb$EJBObject != null ? class$javax$ejb$EJBObject : (class$javax$ejb$EJBObject = DDVerifier.class$("javax.ejb.EJBObject"))).isAssignableFrom(this.remoteInterface())) {
            this.fail1("MUST_EXTEND_EJB_OBJECT", this.remoteInterface().getName());
        }
        Method[] rim = this.getEjbObjectMethods();
        Method[] bms = this.getBeanMethods();
        int i = 0;
        while (i < rim.length) {
            if (!this.checkIncludedInBean(bms, rim[i])) {
                this.fail1("BEAN_METHOD_NOT_EXIST", this.toStringOfBean(rim[i]));
            }
            if (!this.containsException(rim[i].getExceptionTypes(), class$java$rmi$RemoteException != null ? class$java$rmi$RemoteException : DDVerifier.class$("java.rmi.RemoteException"))) {
                this.fail1("REMOTE_METHODS_MUST_THROW_REMOTE_EXCEPTION", this.simpleString(rim[i]));
            }
            ++i;
        }
    }

    boolean checkEqual(Method m1, Method m2) {
        Class<?>[] excepts2;
        Class<?>[] params2;
        Class<?>[] params1;
        if (m1.getName().equals("ejbCreate")) {
            if (!m2.getName().equals("create")) {
                return false;
            }
            if (!m1.getReturnType().equals(Void.TYPE)) {
                return false;
            }
        } else {
            if (!m1.getName().equals(m2.getName())) {
                return false;
            }
            if (!m1.getReturnType().equals(m2.getReturnType())) {
                return false;
            }
        }
        if ((params1 = m1.getParameterTypes()).length != (params2 = m2.getParameterTypes()).length) {
            return false;
        }
        int i = 0;
        while (i < params1.length) {
            if (params1[i] != params2[i]) {
                return false;
            }
            ++i;
        }
        if (!Modifier.isPublic(m1.getModifiers())) {
            return false;
        }
        if (Modifier.isAbstract(m1.getModifiers())) {
            return false;
        }
        Class<?>[] excepts1 = m1.getExceptionTypes();
        if (excepts1.length != (excepts2 = m2.getExceptionTypes()).length) {
            return false;
        }
        Hashtable set = new Hashtable();
        int i2 = 0;
        while (i2 < excepts2.length) {
            set.put(excepts2[i2], "foo bar loves ya!");
            ++i2;
        }
        int i3 = 0;
        while (i3 < excepts1.length) {
            if (set.get(excepts1[i3]) == null) {
                return false;
            }
            ++i3;
        }
        return true;
    }

    void checkForDefaults() throws ToolsException {
        AccessControlEntry[] acl = this.acl();
        ControlDescriptor[] cdl = this.cdl();
        int i = 0;
        while (i < acl.length) {
            try {
                if (acl[i].getMethod() == null) {
                    this.hasDefaultAce = true;
                }
            }
            catch (NullPointerException nullPointerException) {
                this.fail1("NULL_ACE", String.valueOf(i));
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < cdl.length) {
            try {
                if (cdl[i2].getMethod() == null) {
                    this.hasDefaultCd = true;
                }
            }
            catch (NullPointerException nullPointerException) {
                this.fail1("NULL_CD", String.valueOf(i2));
            }
            ++i2;
        }
    }

    boolean checkIncludedInBean(Method[] methodSet, Method test) throws ToolsException {
        int i = 0;
        while (i < methodSet.length) {
            if (this.checkEqual(methodSet[i], test)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    boolean checkIncludedInInterface(Method[] methodSet, Method test) throws ToolsException {
        int i = 0;
        while (i < methodSet.length) {
            if (this.checkEqual(test, methodSet[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    void checkPublicConstructor() throws ToolsException {
        Constructor<?>[] cons = this.bean().getConstructors();
        int i = 0;
        while (i < cons.length) {
            if (cons[i].getParameterTypes().length == 0) {
                if (Modifier.isPublic(cons[i].getModifiers())) {
                    return;
                }
                this.fail1("NO_ARGUMENT_CONSTRUCTOR_MUST_BE_PUBLIC", cons[i].getDeclaringClass().getName());
            }
            ++i;
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    boolean containsException(Class[] exceptions, Class exception) {
        int i = 0;
        while (i < exceptions.length) {
            if (exceptions[i] == exception) {
                return true;
            }
            ++i;
        }
        return false;
    }

    boolean enableEntityBean() {
        String prop = System.getProperty("AURORA_ENABLE_ENTITY_BEAN");
        if (prop == null) {
            return false;
        }
        return prop.equalsIgnoreCase("TRUE");
    }

    void errorMethodsDontHaveAce(Method[] aclMethods, Method[] rim, Method[] him) throws ToolsException {
        StringBuffer sb = new StringBuffer();
        Vector<Method> noAce = new Vector<Method>();
        int i = 0;
        while (i < rim.length) {
            if (!this.checkIncludedInBean(aclMethods, rim[i])) {
                noAce.addElement(rim[i]);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < him.length) {
            if (!this.checkIncludedInBean(aclMethods, him[i2])) {
                noAce.addElement(rim[i2]);
            }
            ++i2;
        }
        Enumeration e = noAce.elements();
        while (e.hasMoreElements()) {
            sb.append(System.getProperty("line.separator"));
            sb.append("        " + this.toString((Method)e.nextElement()));
        }
        this.fail1("NO_DEFAULT_ACE", sb.toString());
    }

    void errorMethodsDontHaveCd(Method[] cdlMethods, Method[] rim, Method[] him) throws ToolsException {
        StringBuffer sb = new StringBuffer();
        Vector<Method> noCd = new Vector<Method>();
        int i = 0;
        while (i < rim.length) {
            if (!this.checkIncludedInBean(cdlMethods, rim[i])) {
                noCd.addElement(rim[i]);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < him.length) {
            if (!this.checkIncludedInBean(cdlMethods, him[i2])) {
                noCd.addElement(rim[i2]);
            }
            ++i2;
        }
        Enumeration e = noCd.elements();
        while (e.hasMoreElements()) {
            sb.append(System.getProperty("line.separator"));
            sb.append("        " + this.toString((Method)e.nextElement()));
        }
        this.fail1("NO_DEFAULT_CD", sb.toString());
    }

    void fail0(String key) throws ToolsException {
        String message = this.msg(key, null);
        throw new ToolsException(message);
    }

    void fail1(String key, String info) throws ToolsException {
        Object[] args = new Object[]{info == null ? "null" : info};
        String message = this.msg(key, args);
        throw new ToolsException(message);
    }

    void fail2(String key, String info, String info2) throws ToolsException {
        Object[] args = new Object[]{info == null ? "null" : info, info2 == null ? "null" : info2};
        String message = this.msg(key, args);
        throw new ToolsException(message);
    }

    void fail3(String key, String info, String info2, String info3) throws ToolsException {
        Object[] args = new Object[]{info == null ? "null" : info, info2 == null ? "null" : info2, info3 == null ? "null" : info3};
        String message = this.msg(key, args);
        throw new ToolsException(message);
    }

    Method[] getBeanMethods() throws ToolsException {
        Vector<Method> allMethods = new Vector<Method>();
        Class current = this.bean();
        while (current != null) {
            Method[] methods = current.getMethods();
            int i = 0;
            while (i < methods.length) {
                allMethods.addElement(methods[i]);
                ++i;
            }
            current = current.getSuperclass();
        }
        Object[] rslt = new Method[allMethods.size()];
        allMethods.copyInto(rslt);
        return rslt;
    }

    Method[] getDeclaredEjbHomeMethods() {
        Hashtable<Method, String> set = new Hashtable<Method, String>();
        AccessControlEntry[] acl = this.acl();
        ControlDescriptor[] cdl = this.cdl();
        int i = 0;
        while (i < acl.length) {
            if (this.isEjbHomeMethod(acl[i].getMethod())) {
                set.put(acl[i].getMethod(), "foo bar loves ya!");
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < cdl.length) {
            if (this.isEjbHomeMethod(cdl[i2].getMethod())) {
                set.put(cdl[i2].getMethod(), "foo bar loves ya!");
            }
            ++i2;
        }
        Method[] rslt = new Method[set.size()];
        int i3 = 0;
        Enumeration e = set.keys();
        while (e.hasMoreElements()) {
            rslt[i3] = (Method)e.nextElement();
        }
        return rslt;
    }

    Method[] getDeclaredEjbObjectMethods() {
        Hashtable<Method, String> set = new Hashtable<Method, String>();
        AccessControlEntry[] acl = this.acl();
        ControlDescriptor[] cdl = this.cdl();
        int i = 0;
        while (i < acl.length) {
            if (this.isEjbObjectMethod(acl[i].getMethod())) {
                set.put(acl[i].getMethod(), "foo bar loves ya!");
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < cdl.length) {
            if (this.isEjbObjectMethod(cdl[i2].getMethod())) {
                set.put(cdl[i2].getMethod(), "foo bar loves ya!");
            }
            ++i2;
        }
        Method[] rslt = new Method[set.size()];
        int i3 = 0;
        Enumeration e = set.keys();
        while (e.hasMoreElements()) {
            rslt[i3] = (Method)e.nextElement();
        }
        return rslt;
    }

    Method[] getDeclaredMethods() {
        Hashtable<Method, String> set = new Hashtable<Method, String>();
        AccessControlEntry[] acl = this.acl();
        ControlDescriptor[] cdl = this.cdl();
        int i = 0;
        while (i < acl.length) {
            if (acl[i].getMethod() != null) {
                set.put(acl[i].getMethod(), "foo bar loves ya!");
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < cdl.length) {
            if (cdl[i2].getMethod() != null) {
                set.put(cdl[i2].getMethod(), "foo bar loves ya!");
            }
            ++i2;
        }
        Method[] rslt = new Method[set.size()];
        int i3 = 0;
        Enumeration e = set.keys();
        while (e.hasMoreElements()) {
            rslt[i3] = (Method)e.nextElement();
            ++i3;
        }
        return rslt;
    }

    Method[] getEjbHomeMethods() throws ToolsException {
        Method[] methods = this.homeInterface().getMethods();
        Vector<Method> allMethods = new Vector<Method>();
        int i = 0;
        while (i < methods.length) {
            if (!methods[i].getDeclaringClass().equals(class$javax$ejb$EJBHome != null ? class$javax$ejb$EJBHome : DDVerifier.class$("javax.ejb.EJBHome"))) {
                allMethods.addElement(methods[i]);
            }
            ++i;
        }
        Object[] rslt = new Method[allMethods.size()];
        allMethods.copyInto(rslt);
        return rslt;
    }

    Method[] getEjbObjectMethods() throws ToolsException {
        Method[] methods = this.remoteInterface().getMethods();
        Vector<Method> allMethods = new Vector<Method>();
        int i = 0;
        while (i < methods.length) {
            if (!methods[i].getDeclaringClass().equals(class$javax$ejb$EJBObject != null ? class$javax$ejb$EJBObject : DDVerifier.class$("javax.ejb.EJBObject"))) {
                allMethods.addElement(methods[i]);
            }
            ++i;
        }
        Object[] rslt = new Method[allMethods.size()];
        allMethods.copyInto(rslt);
        return rslt;
    }

    String getTypeName(Class type) {
        if (type.isArray()) {
            try {
                Class<?> cl = type;
                int dimensions = 0;
                while (cl.isArray()) {
                    ++dimensions;
                    cl = cl.getComponentType();
                }
                StringBuffer sb = new StringBuffer();
                sb.append(cl.getName());
                int i = 0;
                while (i < dimensions) {
                    sb.append("[]");
                    ++i;
                }
                return sb.toString();
            }
            catch (Throwable throwable) {
            }
        }
        return type.getName();
    }

    Class homeInterface() throws ToolsException {
        try {
            return this.loader.loadClass(this.descriptor.getHomeInterfaceClassName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.fail1("HOME_INTERFACE_NOT_FOUND", this.descriptor.getHomeInterfaceClassName());
            return null;
        }
    }

    boolean isEjbHomeMethod(Method m) {
        if (m == null) {
            return false;
        }
        return m.getName().startsWith("ejb");
    }

    boolean isEjbObjectMethod(Method m) {
        if (m == null) {
            return false;
        }
        return m.getName().startsWith("ejb") ^ true;
    }

    boolean isValidBeanClass(Class clazz) throws ToolsException {
        if (this.validBeanClasses == null) {
            Vector supers = new Vector();
            Class current = this.bean();
            while (current != null) {
                supers.addElement(current);
                current = current.getSuperclass();
            }
            this.validBeanClasses = new Class[supers.size()];
            supers.copyInto(this.validBeanClasses);
        }
        int i = 0;
        while (i < this.validBeanClasses.length) {
            if (this.validBeanClasses[i] == clazz) {
                return true;
            }
            ++i;
        }
        return false;
    }

    boolean isValidRemoteInterface(Class clazz) throws ToolsException {
        if (this.validRemoteInterfaces == null) {
            Vector interfaces = new Vector();
            interfaces.addElement(this.remoteInterface());
            Class<?>[] extensions = this.remoteInterface().getInterfaces();
            int i = 0;
            while (i < extensions.length) {
                interfaces.addElement(extensions[i]);
                ++i;
            }
            this.validRemoteInterfaces = new Class[interfaces.size()];
            interfaces.copyInto(this.validRemoteInterfaces);
        }
        int i = 0;
        while (i < this.validRemoteInterfaces.length) {
            if (this.validRemoteInterfaces[i] == clazz) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static void main(String[] argv) throws Exception {
        Object var6_7;
        File d = new File(argv[0]);
        EjbJarFileEditor editor = new EjbJarFileEditor(new File(argv[1]));
        DeploymentDescriptor descriptor = null;
        FileInputStream inStream = null;
        try {
            try {
                inStream = new FileInputStream(d);
                descriptor = EnterpriseBeanParser.parseDescriptor(inStream, editor.classLoader());
            }
            catch (FileNotFoundException fileNotFoundException) {
                new Error("FILE_NOT_FOUND: " + d);
            }
            catch (Exception e) {
                new Error("CANNOT_PARSE " + d + " : " + e.getMessage());
            }
            var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            try {
                if (inStream != null) {
                    ((InputStream)inStream).close();
                }
            }
            catch (IOException iOException) {
                new Error("CANNOT_CLOSE_FILE: " + d);
            }
            throw throwable;
        }
        try {
            if (inStream != null) {
                ((InputStream)inStream).close();
            }
        }
        catch (IOException iOException) {
            new Error("CANNOT_CLOSE_FILE: " + d);
        }
        try {
            try {
                new DDVerifier(editor.classLoader, descriptor).verify();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
            var6_7 = null;
        }
        catch (Throwable throwable) {
            var6_7 = null;
            editor.close();
            throw throwable;
        }
        editor.close();
    }

    protected String msg(String key, Object[] args) throws ToolsException {
        if (bundle == null) {
            try {
                bundle = ResourceBundle.getBundle(messageFile);
            }
            catch (Exception exception) {
                return "Message file 'oracle.aurora.ejb.deployment.Message' is missing.";
            }
        }
        return MessageFormat.format(bundle.getString(key), args);
    }

    Class remoteInterface() throws ToolsException {
        try {
            return this.loader.loadClass(this.descriptor.getRemoteInterfaceClassName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.fail1("REMOTE_INTERFACE_NOT_FOUND", this.descriptor.getRemoteInterfaceClassName());
            return null;
        }
    }

    String simpleString(Method m) {
        try {
            StringBuffer sb = new StringBuffer();
            int mod = m.getModifiers();
            if (mod != 0) {
                sb.append(String.valueOf(Modifier.toString(mod)) + " ");
            }
            if (m.getName().equals("create")) {
                sb.append("void ");
            } else {
                sb.append(String.valueOf(this.getTypeName(m.getReturnType())) + " ");
            }
            if (m.getName().equals("create")) {
                sb.append("ejbCreate(");
            } else {
                sb.append(String.valueOf(m.getName()) + "(");
            }
            Class<?>[] params = m.getParameterTypes();
            int j = 0;
            while (j < params.length) {
                sb.append(this.getTypeName(params[j]));
                if (j < params.length - 1) {
                    sb.append(",");
                }
                ++j;
            }
            sb.append(")");
            Class<?>[] exceptions = m.getExceptionTypes();
            if (exceptions.length > 0) {
                sb.append(" throws ");
                int k = 0;
                while (k < exceptions.length) {
                    sb.append(exceptions[k].getName());
                    if (k < exceptions.length - 1) {
                        sb.append(",");
                    }
                    ++k;
                }
            }
            return sb.toString();
        }
        catch (Exception e) {
            return "<" + e + ">";
        }
    }

    String toString(Method m) {
        if (m == null) {
            return resMessage.getString("bean_default");
        }
        return m.toString();
    }

    String toStringOfBean(Method m) {
        try {
            StringBuffer sb = new StringBuffer();
            int mod = m.getModifiers();
            if (mod != 0) {
                sb.append(String.valueOf(Modifier.toString(mod)) + " ");
            }
            if (m.getName().equals("create")) {
                sb.append("void ");
            } else {
                sb.append(String.valueOf(this.getTypeName(m.getReturnType())) + " ");
            }
            sb.append(String.valueOf(this.getTypeName(this.bean())) + ".");
            if (m.getName().equals("create")) {
                sb.append("ejbCreate(");
            } else {
                sb.append(String.valueOf(m.getName()) + "(");
            }
            Class<?>[] params = m.getParameterTypes();
            int j = 0;
            while (j < params.length) {
                sb.append(this.getTypeName(params[j]));
                if (j < params.length - 1) {
                    sb.append(",");
                }
                ++j;
            }
            sb.append(")");
            Class<?>[] exceptions = m.getExceptionTypes();
            if (exceptions.length > 0) {
                sb.append(" throws ");
                int k = 0;
                while (k < exceptions.length) {
                    sb.append(exceptions[k].getName());
                    if (k < exceptions.length - 1) {
                        sb.append(",");
                    }
                    ++k;
                }
            }
            return sb.toString();
        }
        catch (Exception e) {
            return "<" + e + ">";
        }
    }

    public void verify() throws ToolsException {
        if ((class$javax$ejb$EntityBean != null ? class$javax$ejb$EntityBean : (class$javax$ejb$EntityBean = DDVerifier.class$("javax.ejb.EntityBean"))).isAssignableFrom(this.bean())) {
            if (!this.enableEntityBean()) {
                this.fail1("MUST_IMPLEMENT_SESSION_BEAN", this.bean().getName());
            } else {
                this.sessionBean = false;
            }
        }
        this.checkForDefaults();
        this.checkDescriptor();
        this.checkEjbHome();
        this.checkEjbObject();
        this.checkBean();
    }
}

